package Business::RO::TaxDeduction::Table;
$Business::RO::TaxDeduction::Table::VERSION = '0.012';
# ABSTRACT: Deduction table by year

use 5.010001;
use utf8;
use Moo;
use MooX::HandlesVia;
use Business::RO::TaxDeduction::Types qw(
    Int
    HashRef
    TaxPersons
);

with qw(Business::RO::TaxDeduction::Role::Utils);

has vbl => (
    is       => 'ro',
    isa      => Int,
    required => 1,
);

has '_deduction_table_2018_0' => (
    is      => 'ro',
    isa     => HashRef,
    lazy    => 1,
    default => sub {
        return {
            510 => [ 1,    1950 ],
            495 => [ 1951, 2000 ],
            480 => [ 2001, 2050 ],
            465 => [ 2051, 2100 ],
            450 => [ 2101, 2150 ],
            435 => [ 2151, 2200 ],
            420 => [ 2201, 2250 ],
            405 => [ 2251, 2300 ],
            390 => [ 2301, 2350 ],
            375 => [ 2351, 2400 ],
            360 => [ 2401, 2450 ],
            345 => [ 2451, 2500 ],
            330 => [ 2501, 2550 ],
            315 => [ 2551, 2600 ],
            300 => [ 2601, 2650 ],
            285 => [ 2651, 2700 ],
            270 => [ 2701, 2750 ],
            255 => [ 2751, 2800 ],
            240 => [ 2801, 2850 ],
            225 => [ 2851, 2900 ],
            210 => [ 2901, 2950 ],
            195 => [ 2951, 3000 ],
            180 => [ 3001, 3050 ],
            165 => [ 3051, 3100 ],
            150 => [ 3101, 3150 ],
            135 => [ 3151, 3200 ],
            120 => [ 3201, 3250 ],
            105 => [ 3251, 3300 ],
            90  => [ 3301, 3350 ],
            75  => [ 3351, 3400 ],
            60  => [ 3401, 3450 ],
            45  => [ 3451, 3500 ],
            30  => [ 3501, 3550 ],
            15  => [ 3551, 3600 ],
            0   => [ 3601, 999999 ],
        };
    },
);

has '_deduction_table_2018_1' => (
    is      => 'ro',
    isa     => HashRef,
    lazy    => 1,
    default => sub {
        return {
            670 => [ 1,    1950 ],
            655 => [ 1951, 2000 ],
            640 => [ 2001, 2050 ],
            625 => [ 2051, 2100 ],
            610 => [ 2101, 2150 ],
            595 => [ 2151, 2200 ],
            580 => [ 2201, 2250 ],
            565 => [ 2251, 2300 ],
            550 => [ 2301, 2350 ],
            535 => [ 2351, 2400 ],
            520 => [ 2401, 2450 ],
            505 => [ 2451, 2500 ],
            490 => [ 2501, 2550 ],
            475 => [ 2551, 2600 ],
            460 => [ 2601, 2650 ],
            445 => [ 2651, 2700 ],
            430 => [ 2701, 2750 ],
            415 => [ 2751, 2800 ],
            400 => [ 2801, 2850 ],
            385 => [ 2851, 2900 ],
            370 => [ 2901, 2950 ],
            355 => [ 2951, 3000 ],
            340 => [ 3001, 3050 ],
            325 => [ 3051, 3100 ],
            310 => [ 3101, 3150 ],
            295 => [ 3151, 3200 ],
            280 => [ 3201, 3250 ],
            265 => [ 3251, 3300 ],
            250 => [ 3301, 3350 ],
            235 => [ 3351, 3400 ],
            220 => [ 3401, 3450 ],
            205 => [ 3451, 3500 ],
            190 => [ 3501, 3550 ],
            175 => [ 3551, 3600 ],
            0   => [ 3601, 999999 ],
        };
    },
);

has '_deduction_table_2018_2' => (
    is      => 'ro',
    isa     => HashRef,
    lazy    => 1,
    default => sub {
        return {
            830 => [ 1,    1950 ],
            815 => [ 1951, 2000 ],
            800 => [ 2001, 2050 ],
            785 => [ 2051, 2100 ],
            770 => [ 2101, 2150 ],
            755 => [ 2151, 2200 ],
            740 => [ 2201, 2250 ],
            725 => [ 2251, 2300 ],
            710 => [ 2301, 2350 ],
            695 => [ 2351, 2400 ],
            680 => [ 2401, 2450 ],
            665 => [ 2451, 2500 ],
            650 => [ 2501, 2550 ],
            635 => [ 2551, 2600 ],
            620 => [ 2601, 2650 ],
            605 => [ 2651, 2700 ],
            590 => [ 2701, 2750 ],
            575 => [ 2751, 2800 ],
            560 => [ 2801, 2850 ],
            545 => [ 2851, 2900 ],
            530 => [ 2901, 2950 ],
            515 => [ 2951, 3000 ],
            500 => [ 3001, 3050 ],
            485 => [ 3051, 3100 ],
            470 => [ 3101, 3150 ],
            455 => [ 3151, 3200 ],
            440 => [ 3201, 3250 ],
            425 => [ 3251, 3300 ],
            410 => [ 3301, 3350 ],
            395 => [ 3351, 3400 ],
            380 => [ 3401, 3450 ],
            365 => [ 3451, 3500 ],
            350 => [ 3501, 3550 ],
            335 => [ 3551, 3600 ],
            0   => [ 3601, 999999 ],
        };
    },
);

has '_deduction_table_2018_3' => (
    is      => 'ro',
    isa     => HashRef,
    lazy    => 1,
    default => sub {
        return {
            990 => [ 1,    1950 ],
            975 => [ 1951, 2000 ],
            960 => [ 2001, 2050 ],
            945 => [ 2051, 2100 ],
            930 => [ 2101, 2150 ],
            915 => [ 2151, 2200 ],
            900 => [ 2201, 2250 ],
            885 => [ 2251, 2300 ],
            870 => [ 2301, 2350 ],
            855 => [ 2351, 2400 ],
            840 => [ 2401, 2450 ],
            825 => [ 2451, 2500 ],
            810 => [ 2501, 2550 ],
            795 => [ 2551, 2600 ],
            780 => [ 2601, 2650 ],
            765 => [ 2651, 2700 ],
            750 => [ 2701, 2750 ],
            735 => [ 2751, 2800 ],
            720 => [ 2801, 2850 ],
            705 => [ 2851, 2900 ],
            690 => [ 2901, 2950 ],
            675 => [ 2951, 3000 ],
            660 => [ 3001, 3050 ],
            645 => [ 3051, 3100 ],
            630 => [ 3101, 3150 ],
            615 => [ 3151, 3200 ],
            600 => [ 3201, 3250 ],
            585 => [ 3251, 3300 ],
            570 => [ 3301, 3350 ],
            555 => [ 3351, 3400 ],
            540 => [ 3401, 3450 ],
            525 => [ 3451, 3500 ],
            510 => [ 3501, 3550 ],
            495 => [ 3551, 3600 ],
            0   => [ 3601, 999999 ],
        };
    },
);

has '_deduction_table_2018_4' => (
    is      => 'ro',
    isa     => HashRef,
    lazy    => 1,
    default => sub {
        return {
            1310 => [ 1,    1950 ],
            1295 => [ 1951, 2000 ],
            1280 => [ 2001, 2050 ],
            1265 => [ 2051, 2100 ],
            1250 => [ 2101, 2150 ],
            1235 => [ 2151, 2200 ],
            1220 => [ 2201, 2250 ],
            1205 => [ 2251, 2300 ],
            1190 => [ 2301, 2350 ],
            1175 => [ 2351, 2400 ],
            1160 => [ 2401, 2450 ],
            1145 => [ 2451, 2500 ],
            1130 => [ 2501, 2550 ],
            1115 => [ 2551, 2600 ],
            1100 => [ 2601, 2650 ],
            1085 => [ 2651, 2700 ],
            1070 => [ 2701, 2750 ],
            1055 => [ 2751, 2800 ],
            1040 => [ 2801, 2850 ],
            1025 => [ 2851, 2900 ],
            1010 => [ 2901, 2950 ],
            995  => [ 2951, 3000 ],
            980  => [ 3001, 3050 ],
            965  => [ 3051, 3100 ],
            950  => [ 3101, 3150 ],
            935  => [ 3151, 3200 ],
            920  => [ 3201, 3250 ],
            905  => [ 3251, 3300 ],
            890  => [ 3301, 3350 ],
            875  => [ 3351, 3400 ],
            860  => [ 3401, 3450 ],
            845  => [ 3451, 3500 ],
            830  => [ 3501, 3550 ],
            815  => [ 3551, 3600 ],
            0    => [ 3601, 999999 ],
        };
    },
);

has '_deduction_map' => (
    is          => 'ro',
    handles_via => 'Hash',
    lazy        => 1,
    default     => sub {
        my $self = shift;
        my $year = $self->base_year;
        my $pers = $self->persons;
        my $meth = "_deduction_table_${year}_${pers}";
        return $self->$meth;
    },
    handles => {
        _get_amounts => 'keys',
        _get_range   => 'get',
    },
);

sub deduction {
    my $self = shift;
    my $vbl  = $self->vbl;
    foreach my $amount ( $self->_get_amounts ) {
        my $range = $self->_get_range($amount);
        if (   ( $vbl >= $range->[0] )
            && ( $vbl <= $range->[1] ) )
        {
            return $amount;
        }
    }
    my $msg = "vbl=$vbl, persons=" . $self->persons;
    die "Something went wrong for $msg";
}

1;

__END__

=pod

=encoding UTF-8

=head1 NAME

Business::RO::TaxDeduction::Table - Deduction table by year

=head1 VERSION

version 0.012

=head1 SYNOPSIS

    use Business::RO::TaxDeduction::Table;

    my $tax = Business::RO::TaxDeduction::Table->new(
        year    => 2018,
        persons => 1,
        vbl     => 1950,
    );
    my $amount = $tax->deduction;

=head1 DESCRIPTION

Data module.  This module holds data used for calculating the tax
deduction for the changes made for the year 2018;

=head1 INTERFACE

=head2 ATTRIBUTES

=head3 vbl

=head3 _deduction_table_2018_0

=head3 _deduction_table_2018_1

=head3 _deduction_table_2018_2

=head3 _deduction_table_2018_3

=head3 _deduction_table_2018_4

=head3 _deduction_map

=head2 INSTANCE METHODS

=head3 deduction

=head1 AUTHOR

Ștefan Suciu <stefan@s2i2.ro>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2018 by Ștefan Suciu.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
