package Amazon::API::CloudSearch;

# Autogenerated by lib/Amazon/API/Botocore.pm 1.2.7 at Tue Apr 12 13:47:39 2022

use strict;
use warnings;

use parent qw{ Amazon::API };

our @API_METHODS = qw{
  BuildSuggesters
  CreateDomain
  DefineAnalysisScheme
  DefineExpression
  DefineIndexField
  DefineSuggester
  DeleteAnalysisScheme
  DeleteDomain
  DeleteExpression
  DeleteIndexField
  DeleteSuggester
  DescribeAnalysisSchemes
  DescribeAvailabilityOptions
  DescribeDomainEndpointOptions
  DescribeDomains
  DescribeExpressions
  DescribeIndexFields
  DescribeScalingParameters
  DescribeServiceAccessPolicies
  DescribeSuggesters
  IndexDocuments
  ListDomainNames
  UpdateAvailabilityOptions
  UpdateDomainEndpointOptions
  UpdateScalingParameters
  UpdateServiceAccessPolicies
};

our $VERSION = '1.2.7';

sub new {
  my ( $class, @options ) = @_;
  $class = ref($class) || $class;

  my %options = ref $options[0] ? %{ $options[0] } : @options;

  my $self = $class->SUPER::new(
    { service           => 'cloudsearch',
      endpoint_prefix   => 'cloudsearch',
      version           => '2013-01-01',
      target_prefix     => '',
      api_methods       => \@API_METHODS,
      content_type      => 'application/x-www-form-urlencoded',
      botocore_metadata => {
        'protocol'         => 'query',
        'serviceFullName'  => 'Amazon CloudSearch',
        'uid'              => 'cloudsearch-2013-01-01',
        'signatureVersion' => 'v4',
        'apiVersion'       => '2013-01-01',
        'xmlNamespace' => 'http://cloudsearch.amazonaws.com/doc/2013-01-01/',
        'serviceId'    => 'CloudSearch',
        'endpointPrefix' => 'cloudsearch'
      },
      botocore_operations => {
        'DefineSuggester' => {
          'errors' => [
            { 'shape' => 'BaseException' },
            { 'shape' => 'InternalException' },
            { 'shape' => 'LimitExceededException' },
            { 'shape' => 'InvalidTypeException' },
            { 'shape' => 'ResourceNotFoundException' },
            { 'shape' => 'ValidationException' }
          ],
          'input' => { 'shape' => 'DefineSuggesterRequest' },
          'http'  => {
            'parsed_request_uri' => {
              'parameters'      => [],
              'request_uri_tpl' => '/'
            },
            'requestUri' => '/',
            'method'     => 'POST'
          },
          'name'   => 'DefineSuggester',
          'output' => {
            'resultWrapper' => 'DefineSuggesterResult',
            'shape'         => 'DefineSuggesterResponse'
          }
        },
        'DeleteDomain' => {
          'errors' => [
            { 'shape' => 'BaseException' },
            { 'shape' => 'InternalException' }
          ],
          'input' => { 'shape' => 'DeleteDomainRequest' },
          'http'  => {
            'parsed_request_uri' => {
              'parameters'      => [],
              'request_uri_tpl' => '/'
            },
            'requestUri' => '/',
            'method'     => 'POST'
          },
          'name'   => 'DeleteDomain',
          'output' => {
            'resultWrapper' => 'DeleteDomainResult',
            'shape'         => 'DeleteDomainResponse'
          }
        },
        'IndexDocuments' => {
          'errors' => [
            { 'shape' => 'BaseException' },
            { 'shape' => 'InternalException' },
            { 'shape' => 'ResourceNotFoundException' },
            { 'shape' => 'ValidationException' }
          ],
          'input' => { 'shape' => 'IndexDocumentsRequest' },
          'http'  => {
            'parsed_request_uri' => {
              'parameters'      => [],
              'request_uri_tpl' => '/'
            },
            'requestUri' => '/',
            'method'     => 'POST'
          },
          'name'   => 'IndexDocuments',
          'output' => {
            'resultWrapper' => 'IndexDocumentsResult',
            'shape'         => 'IndexDocumentsResponse'
          }
        },
        'DefineExpression' => {
          'errors' => [
            { 'shape' => 'BaseException' },
            { 'shape' => 'InternalException' },
            { 'shape' => 'LimitExceededException' },
            { 'shape' => 'InvalidTypeException' },
            { 'shape' => 'ResourceNotFoundException' },
            { 'shape' => 'ValidationException' }
          ],
          'input' => { 'shape' => 'DefineExpressionRequest' },
          'http'  => {
            'parsed_request_uri' => {
              'parameters'      => [],
              'request_uri_tpl' => '/'
            },
            'requestUri' => '/',
            'method'     => 'POST'
          },
          'name'   => 'DefineExpression',
          'output' => {
            'resultWrapper' => 'DefineExpressionResult',
            'shape'         => 'DefineExpressionResponse'
          }
        },
        'DeleteIndexField' => {
          'errors' => [
            { 'shape' => 'BaseException' },
            { 'shape' => 'InternalException' },
            { 'shape' => 'InvalidTypeException' },
            { 'shape' => 'ResourceNotFoundException' },
            { 'shape' => 'ValidationException' }
          ],
          'input' => { 'shape' => 'DeleteIndexFieldRequest' },
          'http'  => {
            'parsed_request_uri' => {
              'parameters'      => [],
              'request_uri_tpl' => '/'
            },
            'requestUri' => '/',
            'method'     => 'POST'
          },
          'name'   => 'DeleteIndexField',
          'output' => {
            'resultWrapper' => 'DeleteIndexFieldResult',
            'shape'         => 'DeleteIndexFieldResponse'
          }
        },
        'DescribeServiceAccessPolicies' => {
          'errors' => [
            { 'shape' => 'BaseException' },
            { 'shape' => 'InternalException' },
            { 'shape' => 'ResourceNotFoundException' }
          ],
          'input' => { 'shape' => 'DescribeServiceAccessPoliciesRequest' },
          'http'  => {
            'parsed_request_uri' => {
              'parameters'      => [],
              'request_uri_tpl' => '/'
            },
            'requestUri' => '/',
            'method'     => 'POST'
          },
          'name'   => 'DescribeServiceAccessPolicies',
          'output' => {
            'resultWrapper' => 'DescribeServiceAccessPoliciesResult',
            'shape'         => 'DescribeServiceAccessPoliciesResponse'
          }
        },
        'DescribeScalingParameters' => {
          'errors' => [
            { 'shape' => 'BaseException' },
            { 'shape' => 'InternalException' },
            { 'shape' => 'ResourceNotFoundException' }
          ],
          'input' => { 'shape' => 'DescribeScalingParametersRequest' },
          'http'  => {
            'parsed_request_uri' => {
              'parameters'      => [],
              'request_uri_tpl' => '/'
            },
            'requestUri' => '/',
            'method'     => 'POST'
          },
          'name'   => 'DescribeScalingParameters',
          'output' => {
            'resultWrapper' => 'DescribeScalingParametersResult',
            'shape'         => 'DescribeScalingParametersResponse'
          }
        },
        'UpdateScalingParameters' => {
          'errors' => [
            { 'shape' => 'BaseException' },
            { 'shape' => 'InternalException' },
            { 'shape' => 'LimitExceededException' },
            { 'shape' => 'ResourceNotFoundException' },
            { 'shape' => 'InvalidTypeException' },
            { 'shape' => 'ValidationException' }
          ],
          'input' => { 'shape' => 'UpdateScalingParametersRequest' },
          'http'  => {
            'parsed_request_uri' => {
              'parameters'      => [],
              'request_uri_tpl' => '/'
            },
            'requestUri' => '/',
            'method'     => 'POST'
          },
          'name'   => 'UpdateScalingParameters',
          'output' => {
            'resultWrapper' => 'UpdateScalingParametersResult',
            'shape'         => 'UpdateScalingParametersResponse'
          }
        },
        'UpdateAvailabilityOptions' => {
          'errors' => [
            { 'shape' => 'BaseException' },
            { 'shape' => 'InternalException' },
            { 'shape' => 'InvalidTypeException' },
            { 'shape' => 'LimitExceededException' },
            { 'shape' => 'ResourceNotFoundException' },
            { 'shape' => 'DisabledOperationException' },
            { 'shape' => 'ValidationException' }
          ],
          'input' => { 'shape' => 'UpdateAvailabilityOptionsRequest' },
          'http'  => {
            'parsed_request_uri' => {
              'parameters'      => [],
              'request_uri_tpl' => '/'
            },
            'requestUri' => '/',
            'method'     => 'POST'
          },
          'name'   => 'UpdateAvailabilityOptions',
          'output' => {
            'resultWrapper' => 'UpdateAvailabilityOptionsResult',
            'shape'         => 'UpdateAvailabilityOptionsResponse'
          }
        },
        'DescribeExpressions' => {
          'errors' => [
            { 'shape' => 'BaseException' },
            { 'shape' => 'InternalException' },
            { 'shape' => 'ResourceNotFoundException' }
          ],
          'input' => { 'shape' => 'DescribeExpressionsRequest' },
          'http'  => {
            'parsed_request_uri' => {
              'parameters'      => [],
              'request_uri_tpl' => '/'
            },
            'requestUri' => '/',
            'method'     => 'POST'
          },
          'name'   => 'DescribeExpressions',
          'output' => {
            'resultWrapper' => 'DescribeExpressionsResult',
            'shape'         => 'DescribeExpressionsResponse'
          }
        },
        'DeleteExpression' => {
          'errors' => [
            { 'shape' => 'BaseException' },
            { 'shape' => 'InternalException' },
            { 'shape' => 'InvalidTypeException' },
            { 'shape' => 'ResourceNotFoundException' },
            { 'shape' => 'ValidationException' }
          ],
          'input' => { 'shape' => 'DeleteExpressionRequest' },
          'http'  => {
            'parsed_request_uri' => {
              'parameters'      => [],
              'request_uri_tpl' => '/'
            },
            'requestUri' => '/',
            'method'     => 'POST'
          },
          'name'   => 'DeleteExpression',
          'output' => {
            'resultWrapper' => 'DeleteExpressionResult',
            'shape'         => 'DeleteExpressionResponse'
          }
        },
        'DeleteSuggester' => {
          'errors' => [
            { 'shape' => 'BaseException' },
            { 'shape' => 'InternalException' },
            { 'shape' => 'InvalidTypeException' },
            { 'shape' => 'ResourceNotFoundException' },
            { 'shape' => 'ValidationException' }
          ],
          'input' => { 'shape' => 'DeleteSuggesterRequest' },
          'http'  => {
            'parsed_request_uri' => {
              'parameters'      => [],
              'request_uri_tpl' => '/'
            },
            'requestUri' => '/',
            'method'     => 'POST'
          },
          'name'   => 'DeleteSuggester',
          'output' => {
            'resultWrapper' => 'DeleteSuggesterResult',
            'shape'         => 'DeleteSuggesterResponse'
          }
        },
        'DefineAnalysisScheme' => {
          'errors' => [
            { 'shape' => 'BaseException' },
            { 'shape' => 'InternalException' },
            { 'shape' => 'LimitExceededException' },
            { 'shape' => 'InvalidTypeException' },
            { 'shape' => 'ResourceNotFoundException' },
            { 'shape' => 'ValidationException' }
          ],
          'input' => { 'shape' => 'DefineAnalysisSchemeRequest' },
          'http'  => {
            'parsed_request_uri' => {
              'parameters'      => [],
              'request_uri_tpl' => '/'
            },
            'requestUri' => '/',
            'method'     => 'POST'
          },
          'name'   => 'DefineAnalysisScheme',
          'output' => {
            'resultWrapper' => 'DefineAnalysisSchemeResult',
            'shape'         => 'DefineAnalysisSchemeResponse'
          }
        },
        'DeleteAnalysisScheme' => {
          'errors' => [
            { 'shape' => 'BaseException' },
            { 'shape' => 'InternalException' },
            { 'shape' => 'InvalidTypeException' },
            { 'shape' => 'ResourceNotFoundException' },
            { 'shape' => 'ValidationException' }
          ],
          'input' => { 'shape' => 'DeleteAnalysisSchemeRequest' },
          'http'  => {
            'parsed_request_uri' => {
              'parameters'      => [],
              'request_uri_tpl' => '/'
            },
            'requestUri' => '/',
            'method'     => 'POST'
          },
          'name'   => 'DeleteAnalysisScheme',
          'output' => {
            'resultWrapper' => 'DeleteAnalysisSchemeResult',
            'shape'         => 'DeleteAnalysisSchemeResponse'
          }
        },
        'DescribeSuggesters' => {
          'errors' => [
            { 'shape' => 'BaseException' },
            { 'shape' => 'InternalException' },
            { 'shape' => 'ResourceNotFoundException' }
          ],
          'input' => { 'shape' => 'DescribeSuggestersRequest' },
          'http'  => {
            'parsed_request_uri' => {
              'parameters'      => [],
              'request_uri_tpl' => '/'
            },
            'requestUri' => '/',
            'method'     => 'POST'
          },
          'name'   => 'DescribeSuggesters',
          'output' => {
            'resultWrapper' => 'DescribeSuggestersResult',
            'shape'         => 'DescribeSuggestersResponse'
          }
        },
        'DefineIndexField' => {
          'errors' => [
            { 'shape' => 'BaseException' },
            { 'shape' => 'InternalException' },
            { 'shape' => 'LimitExceededException' },
            { 'shape' => 'InvalidTypeException' },
            { 'shape' => 'ResourceNotFoundException' },
            { 'shape' => 'ValidationException' }
          ],
          'input' => { 'shape' => 'DefineIndexFieldRequest' },
          'http'  => {
            'parsed_request_uri' => {
              'parameters'      => [],
              'request_uri_tpl' => '/'
            },
            'requestUri' => '/',
            'method'     => 'POST'
          },
          'name'   => 'DefineIndexField',
          'output' => {
            'resultWrapper' => 'DefineIndexFieldResult',
            'shape'         => 'DefineIndexFieldResponse'
          }
        },
        'DescribeAnalysisSchemes' => {
          'errors' => [
            { 'shape' => 'BaseException' },
            { 'shape' => 'InternalException' },
            { 'shape' => 'ResourceNotFoundException' }
          ],
          'input' => { 'shape' => 'DescribeAnalysisSchemesRequest' },
          'http'  => {
            'parsed_request_uri' => {
              'parameters'      => [],
              'request_uri_tpl' => '/'
            },
            'requestUri' => '/',
            'method'     => 'POST'
          },
          'name'   => 'DescribeAnalysisSchemes',
          'output' => {
            'resultWrapper' => 'DescribeAnalysisSchemesResult',
            'shape'         => 'DescribeAnalysisSchemesResponse'
          }
        },
        'DescribeDomainEndpointOptions' => {
          'errors' => [
            { 'shape' => 'BaseException' },
            { 'shape' => 'InternalException' },
            { 'shape' => 'LimitExceededException' },
            { 'shape' => 'ResourceNotFoundException' },
            { 'shape' => 'DisabledOperationException' }
          ],
          'input' => { 'shape' => 'DescribeDomainEndpointOptionsRequest' },
          'http'  => {
            'parsed_request_uri' => {
              'parameters'      => [],
              'request_uri_tpl' => '/'
            },
            'requestUri' => '/',
            'method'     => 'POST'
          },
          'name'   => 'DescribeDomainEndpointOptions',
          'output' => {
            'resultWrapper' => 'DescribeDomainEndpointOptionsResult',
            'shape'         => 'DescribeDomainEndpointOptionsResponse'
          }
        },
        'ListDomainNames' => {
          'errors' => [ { 'shape' => 'BaseException' } ],
          'http'   => {
            'parsed_request_uri' => {
              'parameters'      => [],
              'request_uri_tpl' => '/'
            },
            'requestUri' => '/',
            'method'     => 'POST'
          },
          'name'   => 'ListDomainNames',
          'output' => {
            'resultWrapper' => 'ListDomainNamesResult',
            'shape'         => 'ListDomainNamesResponse'
          }
        },
        'DescribeDomains' => {
          'errors' => [
            { 'shape' => 'BaseException' },
            { 'shape' => 'InternalException' }
          ],
          'input' => { 'shape' => 'DescribeDomainsRequest' },
          'http'  => {
            'parsed_request_uri' => {
              'parameters'      => [],
              'request_uri_tpl' => '/'
            },
            'requestUri' => '/',
            'method'     => 'POST'
          },
          'name'   => 'DescribeDomains',
          'output' => {
            'resultWrapper' => 'DescribeDomainsResult',
            'shape'         => 'DescribeDomainsResponse'
          }
        },
        'UpdateDomainEndpointOptions' => {
          'errors' => [
            { 'shape' => 'BaseException' },
            { 'shape' => 'InternalException' },
            { 'shape' => 'InvalidTypeException' },
            { 'shape' => 'LimitExceededException' },
            { 'shape' => 'ResourceNotFoundException' },
            { 'shape' => 'DisabledOperationException' },
            { 'shape' => 'ValidationException' }
          ],
          'input' => { 'shape' => 'UpdateDomainEndpointOptionsRequest' },
          'http'  => {
            'parsed_request_uri' => {
              'parameters'      => [],
              'request_uri_tpl' => '/'
            },
            'requestUri' => '/',
            'method'     => 'POST'
          },
          'name'   => 'UpdateDomainEndpointOptions',
          'output' => {
            'resultWrapper' => 'UpdateDomainEndpointOptionsResult',
            'shape'         => 'UpdateDomainEndpointOptionsResponse'
          }
        },
        'CreateDomain' => {
          'errors' => [
            { 'shape' => 'BaseException' },
            { 'shape' => 'InternalException' },
            { 'shape' => 'LimitExceededException' },
            { 'shape' => 'ResourceAlreadyExistsException' },
            { 'shape' => 'ValidationException' }
          ],
          'input' => { 'shape' => 'CreateDomainRequest' },
          'http'  => {
            'parsed_request_uri' => {
              'parameters'      => [],
              'request_uri_tpl' => '/'
            },
            'requestUri' => '/',
            'method'     => 'POST'
          },
          'name'   => 'CreateDomain',
          'output' => {
            'resultWrapper' => 'CreateDomainResult',
            'shape'         => 'CreateDomainResponse'
          }
        },
        'DescribeAvailabilityOptions' => {
          'errors' => [
            { 'shape' => 'BaseException' },
            { 'shape' => 'InternalException' },
            { 'shape' => 'InvalidTypeException' },
            { 'shape' => 'LimitExceededException' },
            { 'shape' => 'ResourceNotFoundException' },
            { 'shape' => 'DisabledOperationException' }
          ],
          'input' => { 'shape' => 'DescribeAvailabilityOptionsRequest' },
          'http'  => {
            'parsed_request_uri' => {
              'parameters'      => [],
              'request_uri_tpl' => '/'
            },
            'requestUri' => '/',
            'method'     => 'POST'
          },
          'name'   => 'DescribeAvailabilityOptions',
          'output' => {
            'resultWrapper' => 'DescribeAvailabilityOptionsResult',
            'shape'         => 'DescribeAvailabilityOptionsResponse'
          }
        },
        'UpdateServiceAccessPolicies' => {
          'errors' => [
            { 'shape' => 'BaseException' },
            { 'shape' => 'InternalException' },
            { 'shape' => 'LimitExceededException' },
            { 'shape' => 'ResourceNotFoundException' },
            { 'shape' => 'InvalidTypeException' },
            { 'shape' => 'ValidationException' }
          ],
          'input' => { 'shape' => 'UpdateServiceAccessPoliciesRequest' },
          'http'  => {
            'parsed_request_uri' => {
              'parameters'      => [],
              'request_uri_tpl' => '/'
            },
            'requestUri' => '/',
            'method'     => 'POST'
          },
          'name'   => 'UpdateServiceAccessPolicies',
          'output' => {
            'resultWrapper' => 'UpdateServiceAccessPoliciesResult',
            'shape'         => 'UpdateServiceAccessPoliciesResponse'
          }
        },
        'DescribeIndexFields' => {
          'errors' => [
            { 'shape' => 'BaseException' },
            { 'shape' => 'InternalException' },
            { 'shape' => 'ResourceNotFoundException' }
          ],
          'input' => { 'shape' => 'DescribeIndexFieldsRequest' },
          'http'  => {
            'parsed_request_uri' => {
              'parameters'      => [],
              'request_uri_tpl' => '/'
            },
            'requestUri' => '/',
            'method'     => 'POST'
          },
          'name'   => 'DescribeIndexFields',
          'output' => {
            'resultWrapper' => 'DescribeIndexFieldsResult',
            'shape'         => 'DescribeIndexFieldsResponse'
          }
        },
        'BuildSuggesters' => {
          'errors' => [
            { 'shape' => 'BaseException' },
            { 'shape' => 'InternalException' },
            { 'shape' => 'ResourceNotFoundException' },
            { 'shape' => 'ValidationException' }
          ],
          'input' => { 'shape' => 'BuildSuggestersRequest' },
          'http'  => {
            'parsed_request_uri' => {
              'parameters'      => [],
              'request_uri_tpl' => '/'
            },
            'requestUri' => '/',
            'method'     => 'POST'
          },
          'name'   => 'BuildSuggesters',
          'output' => {
            'resultWrapper' => 'BuildSuggestersResult',
            'shape'         => 'BuildSuggestersResponse'
          }
        }
      },
      debug => $ENV{DEBUG} // 0,
      %options
    }
  );

  return $self;
} ## end sub new

1;

__END__

=pod

=head1 NAME

CloudSearch

=head1 DESCRIPTION

Amazon CloudSearch

=head1 VERSION

Version 1.2.7

=head1 METHODS


=head2 BuildSuggesters

=pod

Indexes the search suggestions. For more information, see Configuring
Suggesters in the I<Amazon CloudSearch Developer Guide>.

=cut

#Pod::HTML2Pod conversion notes:
# 260 bytes of input
#Tue Apr 12 13:47:39 2022 rlauer
# No a_name switch not specified, so will not try to render <a name='...'>
# No a_href switch not specified, so will not try to render <a href='...'>


=over 5

=item Input

BuildSuggestersRequest

=item Output

BuildSuggestersResponse

=item Errors

  BaseException
  InternalException
  ResourceNotFoundException
  ValidationException

=item Method

POST

=item Request URI

/

=back



=head2 CreateDomain

=pod

Creates a new search domain. For more information, see Creating a
Search Domain in the I<Amazon CloudSearch Developer Guide>.

=cut

#Pod::HTML2Pod conversion notes:
# 249 bytes of input
#Tue Apr 12 13:47:39 2022 rlauer
# No a_name switch not specified, so will not try to render <a name='...'>
# No a_href switch not specified, so will not try to render <a href='...'>


=over 5

=item Input

CreateDomainRequest

=item Output

CreateDomainResponse

=item Errors

  BaseException
  InternalException
  LimitExceededException
  ResourceAlreadyExistsException
  ValidationException

=item Method

POST

=item Request URI

/

=back



=head2 DefineAnalysisScheme

=pod

Configures an analysis scheme that can be applied to a C<text> or
C<text-array> field to define language-specific text processing
options. For more information, see Configuring Analysis Schemes in the
I<Amazon CloudSearch Developer Guide>.

=cut

#Pod::HTML2Pod conversion notes:
# 395 bytes of input
#Tue Apr 12 13:47:39 2022 rlauer
# No a_name switch not specified, so will not try to render <a name='...'>
# No a_href switch not specified, so will not try to render <a href='...'>


=over 5

=item Input

DefineAnalysisSchemeRequest

=item Output

DefineAnalysisSchemeResponse

=item Errors

  BaseException
  InternalException
  LimitExceededException
  InvalidTypeException
  ResourceNotFoundException
  ValidationException

=item Method

POST

=item Request URI

/

=back



=head2 DefineExpression

=pod

Configures an C<Expression> for the search domain. Used to create new
expressions and modify existing ones. If the expression exists, the new
configuration replaces the old one. For more information, see
Configuring Expressions in the I<Amazon CloudSearch Developer Guide>.

=cut

#Pod::HTML2Pod conversion notes:
# 421 bytes of input
#Tue Apr 12 13:47:39 2022 rlauer
# No a_name switch not specified, so will not try to render <a name='...'>
# No a_href switch not specified, so will not try to render <a href='...'>


=over 5

=item Input

DefineExpressionRequest

=item Output

DefineExpressionResponse

=item Errors

  BaseException
  InternalException
  LimitExceededException
  InvalidTypeException
  ResourceNotFoundException
  ValidationException

=item Method

POST

=item Request URI

/

=back



=head2 DefineIndexField

=pod

Configures an C<IndexField> for the search domain. Used to create new
fields and modify existing ones. You must specify the name of the
domain you are configuring and an index field configuration. The index
field configuration specifies a unique name, the index field type, and
the options you want to configure for the field. The options you can
specify depend on the C<IndexFieldType>. If the field exists, the new
configuration replaces the old one. For more information, see
Configuring Index Fields in the I<Amazon CloudSearch Developer Guide>.

=cut

#Pod::HTML2Pod conversion notes:
# 716 bytes of input
#Tue Apr 12 13:47:39 2022 rlauer
# No a_name switch not specified, so will not try to render <a name='...'>
# No a_href switch not specified, so will not try to render <a href='...'>


=over 5

=item Input

DefineIndexFieldRequest

=item Output

DefineIndexFieldResponse

=item Errors

  BaseException
  InternalException
  LimitExceededException
  InvalidTypeException
  ResourceNotFoundException
  ValidationException

=item Method

POST

=item Request URI

/

=back



=head2 DefineSuggester

=pod

Configures a suggester for a domain. A suggester enables you to display
possible matches before users finish typing their queries. When you
configure a suggester, you must specify the name of the text field you
want to search for possible matches and a unique name for the
suggester. For more information, see Getting Search Suggestions in the
I<Amazon CloudSearch Developer Guide>.

=cut

#Pod::HTML2Pod conversion notes:
# 509 bytes of input
#Tue Apr 12 13:47:39 2022 rlauer
# No a_name switch not specified, so will not try to render <a name='...'>
# No a_href switch not specified, so will not try to render <a href='...'>


=over 5

=item Input

DefineSuggesterRequest

=item Output

DefineSuggesterResponse

=item Errors

  BaseException
  InternalException
  LimitExceededException
  InvalidTypeException
  ResourceNotFoundException
  ValidationException

=item Method

POST

=item Request URI

/

=back



=head2 DeleteAnalysisScheme

=pod

Deletes an analysis scheme. For more information, see Configuring
Analysis Schemes in the I<Amazon CloudSearch Developer Guide>.

=cut

#Pod::HTML2Pod conversion notes:
# 265 bytes of input
#Tue Apr 12 13:47:39 2022 rlauer
# No a_name switch not specified, so will not try to render <a name='...'>
# No a_href switch not specified, so will not try to render <a href='...'>


=over 5

=item Input

DeleteAnalysisSchemeRequest

=item Output

DeleteAnalysisSchemeResponse

=item Errors

  BaseException
  InternalException
  InvalidTypeException
  ResourceNotFoundException
  ValidationException

=item Method

POST

=item Request URI

/

=back



=head2 DeleteDomain

=pod

Permanently deletes a search domain and all of its data. Once a domain
has been deleted, it cannot be recovered. For more information, see
Deleting a Search Domain in the I<Amazon CloudSearch Developer Guide>.

=cut

#Pod::HTML2Pod conversion notes:
# 334 bytes of input
#Tue Apr 12 13:47:39 2022 rlauer
# No a_name switch not specified, so will not try to render <a name='...'>
# No a_href switch not specified, so will not try to render <a href='...'>


=over 5

=item Input

DeleteDomainRequest

=item Output

DeleteDomainResponse

=item Errors

  BaseException
  InternalException

=item Method

POST

=item Request URI

/

=back



=head2 DeleteExpression

=pod

Removes an C<Expression> from the search domain. For more information,
see Configuring Expressions in the I<Amazon CloudSearch Developer
Guide>.

=cut

#Pod::HTML2Pod conversion notes:
# 292 bytes of input
#Tue Apr 12 13:47:39 2022 rlauer
# No a_name switch not specified, so will not try to render <a name='...'>
# No a_href switch not specified, so will not try to render <a href='...'>


=over 5

=item Input

DeleteExpressionRequest

=item Output

DeleteExpressionResponse

=item Errors

  BaseException
  InternalException
  InvalidTypeException
  ResourceNotFoundException
  ValidationException

=item Method

POST

=item Request URI

/

=back



=head2 DeleteIndexField

=pod

Removes an C<IndexField> from the search domain. For more information,
see Configuring Index Fields in the I<Amazon CloudSearch Developer
Guide>.

=cut

#Pod::HTML2Pod conversion notes:
# 294 bytes of input
#Tue Apr 12 13:47:39 2022 rlauer
# No a_name switch not specified, so will not try to render <a name='...'>
# No a_href switch not specified, so will not try to render <a href='...'>


=over 5

=item Input

DeleteIndexFieldRequest

=item Output

DeleteIndexFieldResponse

=item Errors

  BaseException
  InternalException
  InvalidTypeException
  ResourceNotFoundException
  ValidationException

=item Method

POST

=item Request URI

/

=back



=head2 DeleteSuggester

=pod

Deletes a suggester. For more information, see Getting Search
Suggestions in the I<Amazon CloudSearch Developer Guide>.

=cut

#Pod::HTML2Pod conversion notes:
# 246 bytes of input
#Tue Apr 12 13:47:39 2022 rlauer
# No a_name switch not specified, so will not try to render <a name='...'>
# No a_href switch not specified, so will not try to render <a href='...'>


=over 5

=item Input

DeleteSuggesterRequest

=item Output

DeleteSuggesterResponse

=item Errors

  BaseException
  InternalException
  InvalidTypeException
  ResourceNotFoundException
  ValidationException

=item Method

POST

=item Request URI

/

=back



=head2 DescribeAnalysisSchemes

=pod

Gets the analysis schemes configured for a domain. An analysis scheme
defines language-specific text processing options for a C<text> field.
Can be limited to specific analysis schemes by name. By default, shows
all analysis schemes and includes any pending changes to the
configuration. Set the C<Deployed> option to C<true> to show the active
configuration and exclude pending changes. For more information, see
Configuring Analysis Schemes in the I<Amazon CloudSearch Developer
Guide>.

=cut

#Pod::HTML2Pod conversion notes:
# 654 bytes of input
#Tue Apr 12 13:47:39 2022 rlauer
# No a_name switch not specified, so will not try to render <a name='...'>
# No a_href switch not specified, so will not try to render <a href='...'>


=over 5

=item Input

DescribeAnalysisSchemesRequest

=item Output

DescribeAnalysisSchemesResponse

=item Errors

  BaseException
  InternalException
  ResourceNotFoundException

=item Method

POST

=item Request URI

/

=back



=head2 DescribeAvailabilityOptions

=pod

Gets the availability options configured for a domain. By default,
shows the configuration with any pending changes. Set the C<Deployed>
option to C<true> to show the active configuration and exclude pending
changes. For more information, see Configuring Availability Options in
the I<Amazon CloudSearch Developer Guide>.

=cut

#Pod::HTML2Pod conversion notes:
# 481 bytes of input
#Tue Apr 12 13:47:39 2022 rlauer
# No a_name switch not specified, so will not try to render <a name='...'>
# No a_href switch not specified, so will not try to render <a href='...'>


=over 5

=item Input

DescribeAvailabilityOptionsRequest

=item Output

DescribeAvailabilityOptionsResponse

=item Errors

  BaseException
  InternalException
  InvalidTypeException
  LimitExceededException
  ResourceNotFoundException
  DisabledOperationException

=item Method

POST

=item Request URI

/

=back



=head2 DescribeDomainEndpointOptions

=pod

Returns the domain's endpoint options, specifically whether all
requests to the domain must arrive over HTTPS. For more information,
see Configuring Domain Endpoint Options in the I<Amazon CloudSearch
Developer Guide>.

=cut

#Pod::HTML2Pod conversion notes:
# 361 bytes of input
#Tue Apr 12 13:47:39 2022 rlauer
# No a_name switch not specified, so will not try to render <a name='...'>
# No a_href switch not specified, so will not try to render <a href='...'>


=over 5

=item Input

DescribeDomainEndpointOptionsRequest

=item Output

DescribeDomainEndpointOptionsResponse

=item Errors

  BaseException
  InternalException
  LimitExceededException
  ResourceNotFoundException
  DisabledOperationException

=item Method

POST

=item Request URI

/

=back



=head2 DescribeDomains

=pod

Gets information about the search domains owned by this account. Can be
limited to specific domains. Shows all domains by default. To get the
number of searchable documents in a domain, use the console or submit a
C<matchall> request to your domain's search endpoint:
C<q=matchall&amp;q.parser=structured&amp;size=0>. For more information,
see Getting Information about a Search Domain in the I<Amazon
CloudSearch Developer Guide>.

=cut

#Pod::HTML2Pod conversion notes:
# 586 bytes of input
#Tue Apr 12 13:47:39 2022 rlauer
# No a_name switch not specified, so will not try to render <a name='...'>
# No a_href switch not specified, so will not try to render <a href='...'>


=over 5

=item Input

DescribeDomainsRequest

=item Output

DescribeDomainsResponse

=item Errors

  BaseException
  InternalException

=item Method

POST

=item Request URI

/

=back



=head2 DescribeExpressions

=pod

Gets the expressions configured for the search domain. Can be limited
to specific expressions by name. By default, shows all expressions and
includes any pending changes to the configuration. Set the C<Deployed>
option to C<true> to show the active configuration and exclude pending
changes. For more information, see Configuring Expressions in the
I<Amazon CloudSearch Developer Guide>.

=cut

#Pod::HTML2Pod conversion notes:
# 538 bytes of input
#Tue Apr 12 13:47:39 2022 rlauer
# No a_name switch not specified, so will not try to render <a name='...'>
# No a_href switch not specified, so will not try to render <a href='...'>


=over 5

=item Input

DescribeExpressionsRequest

=item Output

DescribeExpressionsResponse

=item Errors

  BaseException
  InternalException
  ResourceNotFoundException

=item Method

POST

=item Request URI

/

=back



=head2 DescribeIndexFields

=pod

Gets information about the index fields configured for the search
domain. Can be limited to specific fields by name. By default, shows
all fields and includes any pending changes to the configuration. Set
the C<Deployed> option to C<true> to show the active configuration and
exclude pending changes. For more information, see Getting Domain
Information in the I<Amazon CloudSearch Developer Guide>.

=cut

#Pod::HTML2Pod conversion notes:
# 546 bytes of input
#Tue Apr 12 13:47:39 2022 rlauer
# No a_name switch not specified, so will not try to render <a name='...'>
# No a_href switch not specified, so will not try to render <a href='...'>


=over 5

=item Input

DescribeIndexFieldsRequest

=item Output

DescribeIndexFieldsResponse

=item Errors

  BaseException
  InternalException
  ResourceNotFoundException

=item Method

POST

=item Request URI

/

=back



=head2 DescribeScalingParameters

=pod

Gets the scaling parameters configured for a domain. A domain's scaling
parameters specify the desired search instance type and replication
count. For more information, see Configuring Scaling Options in the
I<Amazon CloudSearch Developer Guide>.

=cut

#Pod::HTML2Pod conversion notes:
# 381 bytes of input
#Tue Apr 12 13:47:39 2022 rlauer
# No a_name switch not specified, so will not try to render <a name='...'>
# No a_href switch not specified, so will not try to render <a href='...'>


=over 5

=item Input

DescribeScalingParametersRequest

=item Output

DescribeScalingParametersResponse

=item Errors

  BaseException
  InternalException
  ResourceNotFoundException

=item Method

POST

=item Request URI

/

=back



=head2 DescribeServiceAccessPolicies

=pod

Gets information about the access policies that control access to the
domain's document and search endpoints. By default, shows the
configuration with any pending changes. Set the C<Deployed> option to
C<true> to show the active configuration and exclude pending changes.
For more information, see Configuring Access for a Search Domain in the
I<Amazon CloudSearch Developer Guide>.

=cut

#Pod::HTML2Pod conversion notes:
# 528 bytes of input
#Tue Apr 12 13:47:39 2022 rlauer
# No a_name switch not specified, so will not try to render <a name='...'>
# No a_href switch not specified, so will not try to render <a href='...'>


=over 5

=item Input

DescribeServiceAccessPoliciesRequest

=item Output

DescribeServiceAccessPoliciesResponse

=item Errors

  BaseException
  InternalException
  ResourceNotFoundException

=item Method

POST

=item Request URI

/

=back



=head2 DescribeSuggesters

=pod

Gets the suggesters configured for a domain. A suggester enables you to
display possible matches before users finish typing their queries. Can
be limited to specific suggesters by name. By default, shows all
suggesters and includes any pending changes to the configuration. Set
the C<Deployed> option to C<true> to show the active configuration and
exclude pending changes. For more information, see Getting Search
Suggestions in the I<Amazon CloudSearch Developer Guide>.

=cut

#Pod::HTML2Pod conversion notes:
# 619 bytes of input
#Tue Apr 12 13:47:39 2022 rlauer
# No a_name switch not specified, so will not try to render <a name='...'>
# No a_href switch not specified, so will not try to render <a href='...'>


=over 5

=item Input

DescribeSuggestersRequest

=item Output

DescribeSuggestersResponse

=item Errors

  BaseException
  InternalException
  ResourceNotFoundException

=item Method

POST

=item Request URI

/

=back



=head2 IndexDocuments

=pod

Tells the search domain to start indexing its documents using the
latest indexing options. This operation must be invoked to activate
options whose OptionStatus is C<RequiresIndexDocuments>.

=cut

#Pod::HTML2Pod conversion notes:
# 214 bytes of input
#Tue Apr 12 13:47:39 2022 rlauer
# No a_name switch not specified, so will not try to render <a name='...'>
# No a_href switch not specified, so will not try to render <a href='...'>


=over 5

=item Input

IndexDocumentsRequest

=item Output

IndexDocumentsResponse

=item Errors

  BaseException
  InternalException
  ResourceNotFoundException
  ValidationException

=item Method

POST

=item Request URI

/

=back



=head2 ListDomainNames

=pod

Lists all search domains owned by an account.

=cut

#Pod::HTML2Pod conversion notes:
# 52 bytes of input
#Tue Apr 12 13:47:39 2022 rlauer
# No a_name switch not specified, so will not try to render <a name='...'>
# No a_href switch not specified, so will not try to render <a href='...'>


=over 5

=item Input

None

=item Output

ListDomainNamesResponse

=item Errors

  BaseException

=item Method

POST

=item Request URI

/

=back



=head2 UpdateAvailabilityOptions

=pod

Configures the availability options for a domain. Enabling the Multi-AZ
option expands an Amazon CloudSearch domain to an additional
Availability Zone in the same Region to increase fault tolerance in the
event of a service disruption. Changes to the Multi-AZ option can take
about half an hour to become active. For more information, see
Configuring Availability Options in the I<Amazon CloudSearch Developer
Guide>.

=cut

#Pod::HTML2Pod conversion notes:
# 557 bytes of input
#Tue Apr 12 13:47:39 2022 rlauer
# No a_name switch not specified, so will not try to render <a name='...'>
# No a_href switch not specified, so will not try to render <a href='...'>


=over 5

=item Input

UpdateAvailabilityOptionsRequest

=item Output

UpdateAvailabilityOptionsResponse

=item Errors

  BaseException
  InternalException
  InvalidTypeException
  LimitExceededException
  ResourceNotFoundException
  DisabledOperationException
  ValidationException

=item Method

POST

=item Request URI

/

=back



=head2 UpdateDomainEndpointOptions

=pod

Updates the domain's endpoint options, specifically whether all
requests to the domain must arrive over HTTPS. For more information,
see Configuring Domain Endpoint Options in the I<Amazon CloudSearch
Developer Guide>.

=cut

#Pod::HTML2Pod conversion notes:
# 361 bytes of input
#Tue Apr 12 13:47:39 2022 rlauer
# No a_name switch not specified, so will not try to render <a name='...'>
# No a_href switch not specified, so will not try to render <a href='...'>


=over 5

=item Input

UpdateDomainEndpointOptionsRequest

=item Output

UpdateDomainEndpointOptionsResponse

=item Errors

  BaseException
  InternalException
  InvalidTypeException
  LimitExceededException
  ResourceNotFoundException
  DisabledOperationException
  ValidationException

=item Method

POST

=item Request URI

/

=back



=head2 UpdateScalingParameters

=pod

Configures scaling parameters for a domain. A domain's scaling
parameters specify the desired search instance type and replication
count. Amazon CloudSearch will still automatically scale your domain
based on the volume of data and traffic, but not below the desired
instance type and replication count. If the Multi-AZ option is enabled,
these values control the resources used per Availability Zone. For more
information, see Configuring Scaling Options in the I<Amazon
CloudSearch Developer Guide>.

=cut

#Pod::HTML2Pod conversion notes:
# 637 bytes of input
#Tue Apr 12 13:47:39 2022 rlauer
# No a_name switch not specified, so will not try to render <a name='...'>
# No a_href switch not specified, so will not try to render <a href='...'>


=over 5

=item Input

UpdateScalingParametersRequest

=item Output

UpdateScalingParametersResponse

=item Errors

  BaseException
  InternalException
  LimitExceededException
  ResourceNotFoundException
  InvalidTypeException
  ValidationException

=item Method

POST

=item Request URI

/

=back



=head2 UpdateServiceAccessPolicies

=pod

Configures the access rules that control access to the domain's
document and search endpoints. For more information, see Configuring
Access for an Amazon CloudSearch Domain.

=cut

#Pod::HTML2Pod conversion notes:
# 296 bytes of input
#Tue Apr 12 13:47:39 2022 rlauer
# No a_name switch not specified, so will not try to render <a name='...'>
# No a_href switch not specified, so will not try to render <a href='...'>


=over 5

=item Input

UpdateServiceAccessPoliciesRequest

=item Output

UpdateServiceAccessPoliciesResponse

=item Errors

  BaseException
  InternalException
  LimitExceededException
  ResourceNotFoundException
  InvalidTypeException
  ValidationException

=item Method

POST

=item Request URI

/

=back



=head1 NOTE

Autogenerated by lib/Amazon/API/Botocore.pm at Tue Apr 12 13:47:39 2022

=head1 LICENSE AND COPYRIGHT

This module is free software it may be used, redistributed and/or
modified under the same terms as Perl itself.

=cut  
