#/usr/bin/env bash

_dothis_completions()
{


  export cur_word="${COMP_WORDS[COMP_CWORD]}"

  local prev_word=${COMP_WORDS[COMP_CWORD-1]}

  export comp_words_string=$( IFS=$'\t'; echo "${COMP_WORDS[*]}" )

  if perl -e '$w=$ENV{comp_words_string}; $w=~/--profile/ or exit 2'; then

    COMPREPLY=( $( compgen -W "ado git perl perl6 ruby" -- ${cur_word} ))

  elif [ -z "$cur_word" ]; then

    COMPREPLY=($(compgen -W "$(cd .tom && ls -1 *.pl6 | perl -n -e 'chomp; s{.pl6}{}; print "$_ " ')" -- ${cur_word} ))

  elif perl -e '$w=$ENV{cur_word}; exit(0) unless $w; $w=~/^-+/ or exit 2'; then


    COMPREPLY=( $( compgen -W "--help --completion --last --profile --list --cat -q --quiet --verbose --lines" -- ${cur_word} ))

  else

    COMPREPLY=($(compgen -W "$(cd .tom && ls -1 *.pl6 | perl -n -e 'chomp; s{.pl6}{}; print "$_ " ')" -- ${cur_word} ))

  fi


}

complete -F _dothis_completions tom
