use strict;
use warnings;
use Test::More;
use Compiler::Lexer;
use Compiler::Parser;
use Compiler::Parser::AST::Renderer;
use Test::Compiler::Parser;

subtest 'parse Plack/Test/Suite.pm' => sub {
    my $script = do { local $/; <DATA> };
    my $tokens = Compiler::Lexer->new('')->tokenize($script);
    my $ast = Compiler::Parser->new->parse($tokens);
    Compiler::Parser::AST::Renderer->new->render($ast);
    node_ok($ast->root, [
        Test::Compiler::Parser::package { 'Plack::Test::Suite',
        },
        module { 'strict',
        },
        module { 'warnings',
        },
        module { 'Digest::MD5',
        },
        module { 'File::ShareDir',
        },
        module { 'HTTP::Request',
        },
        module { 'HTTP::Request::Common',
        },
        module { 'LWP::UserAgent',
        },
        module { 'Test::More',
        },
        module { 'Test::TCP',
        },
        module { 'Plack::Loader',
        },
        module { 'Plack::Middleware::Lint',
        },
        module { 'Plack::Util',
        },
        module { 'Plack::Request',
        },
        module { 'Try::Tiny',
        },
        branch { '=',
            left => leaf '$share_dir',
            right => function_call { 'try',
                args => [
                    branch { '||',
                        left => hash_ref { '{}',
                            data => function_call { 'File::ShareDir::dist_dir',
                                args => [
                                    leaf 'Plack',
                                ],
                            },
                        },
                        right => leaf 'share',
                    },
                ],
            },
        },
        branch { '=',
            left => hash { '$ENV',
                key => hash_ref { '{}',
                    data => leaf 'PLACK_TEST_SCRIPT_NAME',
                },
            },
            right => leaf '',
        },
        branch { '=',
            left => leaf '@TEST',
            right => list { '()',
                data => branch { ',',
                    left => branch { ',',
                        left => branch { ',',
                            left => branch { ',',
                                left => branch { ',',
                                    left => branch { ',',
                                        left => branch { ',',
                                            left => branch { ',',
                                                left => branch { ',',
                                                    left => branch { ',',
                                                        left => branch { ',',
                                                            left => branch { ',',
                                                                left => branch { ',',
                                                                    left => branch { ',',
                                                                        left => branch { ',',
                                                                            left => branch { ',',
                                                                                left => branch { ',',
                                                                                    left => branch { ',',
                                                                                        left => branch { ',',
                                                                                            left => branch { ',',
                                                                                                left => branch { ',',
                                                                                                    left => branch { ',',
                                                                                                        left => branch { ',',
                                                                                                            left => branch { ',',
                                                                                                                left => branch { ',',
                                                                                                                    left => branch { ',',
                                                                                                                        left => branch { ',',
                                                                                                                            left => branch { ',',
                                                                                                                                left => branch { ',',
                                                                                                                                    left => branch { ',',
                                                                                                                                        left => branch { ',',
                                                                                                                                            left => branch { ',',
                                                                                                                                                left => branch { ',',
                                                                                                                                                    left => branch { ',',
                                                                                                                                                        left => branch { ',',
                                                                                                                                                            left => branch { ',',
                                                                                                                                                                left => array_ref { '[]',
                                                                                                                                                                    data => branch { ',',
                                                                                                                                                                        left => branch { ',',
                                                                                                                                                                            left => branch { ',',
                                                                                                                                                                                left => leaf 'SCRIPT_NAME',
                                                                                                                                                                                right => function { 'sub',
                                                                                                                                                                                    body => [
                                                                                                                                                                                        branch { '=',
                                                                                                                                                                                            left => leaf '$cb',
                                                                                                                                                                                            right => function_call { 'shift',
                                                                                                                                                                                                args => [
                                                                                                                                                                                                ],
                                                                                                                                                                                            },
                                                                                                                                                                                        },
                                                                                                                                                                                        branch { '=',
                                                                                                                                                                                            left => leaf '$res',
                                                                                                                                                                                            right => branch { '->',
                                                                                                                                                                                                left => leaf '$cb',
                                                                                                                                                                                                right => list { '()',
                                                                                                                                                                                                    data => function_call { 'GET',
                                                                                                                                                                                                        args => [
                                                                                                                                                                                                            leaf 'http://127.0.0.1/',
                                                                                                                                                                                                        ],
                                                                                                                                                                                                    },
                                                                                                                                                                                                },
                                                                                                                                                                                            },
                                                                                                                                                                                        },
                                                                                                                                                                                        function_call { 'is',
                                                                                                                                                                                            args => [
                                                                                                                                                                                                branch { ',',
                                                                                                                                                                                                    left => branch { '->',
                                                                                                                                                                                                        left => leaf '$res',
                                                                                                                                                                                                        right => function_call { 'content',
                                                                                                                                                                                                            args => [
                                                                                                                                                                                                            ],
                                                                                                                                                                                                        },
                                                                                                                                                                                                    },
                                                                                                                                                                                                    right => hash { '$ENV',
                                                                                                                                                                                                        key => hash_ref { '{}',
                                                                                                                                                                                                            data => leaf 'PLACK_TEST_SCRIPT_NAME',
                                                                                                                                                                                                        },
                                                                                                                                                                                                    },
                                                                                                                                                                                                },
                                                                                                                                                                                            ],
                                                                                                                                                                                        },
                                                                                                                                                                                    ],
                                                                                                                                                                                },
                                                                                                                                                                            },
                                                                                                                                                                            right => function { 'sub',
                                                                                                                                                                                body => [
                                                                                                                                                                                    branch { '=',
                                                                                                                                                                                        left => leaf '$env',
                                                                                                                                                                                        right => function_call { 'shift',
                                                                                                                                                                                            args => [
                                                                                                                                                                                            ],
                                                                                                                                                                                        },
                                                                                                                                                                                    },
                                                                                                                                                                                    Test::Compiler::Parser::return { 'return',
                                                                                                                                                                                        body => array_ref { '[]',
                                                                                                                                                                                            data => branch { ',',
                                                                                                                                                                                                left => branch { ',',
                                                                                                                                                                                                    left => leaf '200',
                                                                                                                                                                                                    right => array_ref { '[]',
                                                                                                                                                                                                        data => branch { ',',
                                                                                                                                                                                                            left => leaf 'Content-Type',
                                                                                                                                                                                                            right => leaf 'text/plain',
                                                                                                                                                                                                        },
                                                                                                                                                                                                    },
                                                                                                                                                                                                },
                                                                                                                                                                                                right => array_ref { '[]',
                                                                                                                                                                                                    data => branch { '->',
                                                                                                                                                                                                        left => leaf '$env',
                                                                                                                                                                                                        right => hash_ref { '{}',
                                                                                                                                                                                                            data => leaf 'SCRIPT_NAME',
                                                                                                                                                                                                        },
                                                                                                                                                                                                    },
                                                                                                                                                                                                },
                                                                                                                                                                                            },
                                                                                                                                                                                        },
                                                                                                                                                                                    },
                                                                                                                                                                                ],
                                                                                                                                                                            },
                                                                                                                                                                        },
                                                                                                                                                                    },
                                                                                                                                                                },
                                                                                                                                                                right => array_ref { '[]',
                                                                                                                                                                    data => branch { ',',
                                                                                                                                                                        left => branch { ',',
                                                                                                                                                                            left => branch { ',',
                                                                                                                                                                                left => leaf 'GET',
                                                                                                                                                                                right => function { 'sub',
                                                                                                                                                                                    body => [
                                                                                                                                                                                        branch { '=',
                                                                                                                                                                                            left => leaf '$cb',
                                                                                                                                                                                            right => function_call { 'shift',
                                                                                                                                                                                                args => [
                                                                                                                                                                                                ],
                                                                                                                                                                                            },
                                                                                                                                                                                        },
                                                                                                                                                                                        branch { '=',
                                                                                                                                                                                            left => leaf '$res',
                                                                                                                                                                                            right => branch { '->',
                                                                                                                                                                                                left => leaf '$cb',
                                                                                                                                                                                                right => list { '()',
                                                                                                                                                                                                    data => function_call { 'GET',
                                                                                                                                                                                                        args => [
                                                                                                                                                                                                            leaf 'http://127.0.0.1/?name=miyagawa',
                                                                                                                                                                                                        ],
                                                                                                                                                                                                    },
                                                                                                                                                                                                },
                                                                                                                                                                                            },
                                                                                                                                                                                        },
                                                                                                                                                                                        function_call { 'is',
                                                                                                                                                                                            args => [
                                                                                                                                                                                                branch { ',',
                                                                                                                                                                                                    left => branch { '->',
                                                                                                                                                                                                        left => leaf '$res',
                                                                                                                                                                                                        right => function_call { 'code',
                                                                                                                                                                                                            args => [
                                                                                                                                                                                                            ],
                                                                                                                                                                                                        },
                                                                                                                                                                                                    },
                                                                                                                                                                                                    right => leaf '200',
                                                                                                                                                                                                },
                                                                                                                                                                                            ],
                                                                                                                                                                                        },
                                                                                                                                                                                        function_call { 'is',
                                                                                                                                                                                            args => [
                                                                                                                                                                                                branch { ',',
                                                                                                                                                                                                    left => branch { '->',
                                                                                                                                                                                                        left => leaf '$res',
                                                                                                                                                                                                        right => function_call { 'message',
                                                                                                                                                                                                            args => [
                                                                                                                                                                                                            ],
                                                                                                                                                                                                        },
                                                                                                                                                                                                    },
                                                                                                                                                                                                    right => leaf 'OK',
                                                                                                                                                                                                },
                                                                                                                                                                                            ],
                                                                                                                                                                                        },
                                                                                                                                                                                        function_call { 'is',
                                                                                                                                                                                            args => [
                                                                                                                                                                                                branch { ',',
                                                                                                                                                                                                    left => branch { '->',
                                                                                                                                                                                                        left => leaf '$res',
                                                                                                                                                                                                        right => function_call { 'header',
                                                                                                                                                                                                            args => [
                                                                                                                                                                                                                leaf 'content_type',
                                                                                                                                                                                                            ],
                                                                                                                                                                                                        },
                                                                                                                                                                                                    },
                                                                                                                                                                                                    right => leaf 'text/plain',
                                                                                                                                                                                                },
                                                                                                                                                                                            ],
                                                                                                                                                                                        },
                                                                                                                                                                                        function_call { 'is',
                                                                                                                                                                                            args => [
                                                                                                                                                                                                branch { ',',
                                                                                                                                                                                                    left => branch { '->',
                                                                                                                                                                                                        left => leaf '$res',
                                                                                                                                                                                                        right => function_call { 'content',
                                                                                                                                                                                                            args => [
                                                                                                                                                                                                            ],
                                                                                                                                                                                                        },
                                                                                                                                                                                                    },
                                                                                                                                                                                                    right => leaf 'Hello, name=miyagawa',
                                                                                                                                                                                                },
                                                                                                                                                                                            ],
                                                                                                                                                                                        },
                                                                                                                                                                                    ],
                                                                                                                                                                                },
                                                                                                                                                                            },
                                                                                                                                                                            right => function { 'sub',
                                                                                                                                                                                body => [
                                                                                                                                                                                    branch { '=',
                                                                                                                                                                                        left => leaf '$env',
                                                                                                                                                                                        right => function_call { 'shift',
                                                                                                                                                                                            args => [
                                                                                                                                                                                            ],
                                                                                                                                                                                        },
                                                                                                                                                                                    },
                                                                                                                                                                                    Test::Compiler::Parser::return { 'return',
                                                                                                                                                                                        body => array_ref { '[]',
                                                                                                                                                                                            data => branch { ',',
                                                                                                                                                                                                left => branch { ',',
                                                                                                                                                                                                    left => branch { ',',
                                                                                                                                                                                                        left => leaf '200',
                                                                                                                                                                                                        right => array_ref { '[]',
                                                                                                                                                                                                            data => branch { ',',
                                                                                                                                                                                                                left => branch { '=>',
                                                                                                                                                                                                                    left => leaf 'Content-Type',
                                                                                                                                                                                                                    right => leaf 'text/plain',
                                                                                                                                                                                                                },
                                                                                                                                                                                                            },
                                                                                                                                                                                                        },
                                                                                                                                                                                                    },
                                                                                                                                                                                                    right => array_ref { '[]',
                                                                                                                                                                                                        data => branch { '.',
                                                                                                                                                                                                            left => leaf 'Hello, ',
                                                                                                                                                                                                            right => branch { '->',
                                                                                                                                                                                                                left => leaf '$env',
                                                                                                                                                                                                                right => hash_ref { '{}',
                                                                                                                                                                                                                    data => leaf 'QUERY_STRING',
                                                                                                                                                                                                                },
                                                                                                                                                                                                            },
                                                                                                                                                                                                        },
                                                                                                                                                                                                    },
                                                                                                                                                                                                },
                                                                                                                                                                                            },
                                                                                                                                                                                        },
                                                                                                                                                                                    },
                                                                                                                                                                                ],
                                                                                                                                                                            },
                                                                                                                                                                        },
                                                                                                                                                                    },
                                                                                                                                                                },
                                                                                                                                                            },
                                                                                                                                                            right => array_ref { '[]',
                                                                                                                                                                data => branch { ',',
                                                                                                                                                                    left => branch { ',',
                                                                                                                                                                        left => branch { ',',
                                                                                                                                                                            left => leaf 'POST',
                                                                                                                                                                            right => function { 'sub',
                                                                                                                                                                                body => [
                                                                                                                                                                                    branch { '=',
                                                                                                                                                                                        left => leaf '$cb',
                                                                                                                                                                                        right => function_call { 'shift',
                                                                                                                                                                                            args => [
                                                                                                                                                                                            ],
                                                                                                                                                                                        },
                                                                                                                                                                                    },
                                                                                                                                                                                    branch { '=',
                                                                                                                                                                                        left => leaf '$res',
                                                                                                                                                                                        right => branch { '->',
                                                                                                                                                                                            left => leaf '$cb',
                                                                                                                                                                                            right => list { '()',
                                                                                                                                                                                                data => function_call { 'POST',
                                                                                                                                                                                                    args => [
                                                                                                                                                                                                        branch { ',',
                                                                                                                                                                                                            left => leaf 'http://127.0.0.1/',
                                                                                                                                                                                                            right => array_ref { '[]',
                                                                                                                                                                                                                data => branch { '=>',
                                                                                                                                                                                                                    left => leaf 'name',
                                                                                                                                                                                                                    right => leaf 'tatsuhiko',
                                                                                                                                                                                                                },
                                                                                                                                                                                                            },
                                                                                                                                                                                                        },
                                                                                                                                                                                                    ],
                                                                                                                                                                                                },
                                                                                                                                                                                            },
                                                                                                                                                                                        },
                                                                                                                                                                                    },
                                                                                                                                                                                    function_call { 'is',
                                                                                                                                                                                        args => [
                                                                                                                                                                                            branch { ',',
                                                                                                                                                                                                left => branch { '->',
                                                                                                                                                                                                    left => leaf '$res',
                                                                                                                                                                                                    right => function_call { 'code',
                                                                                                                                                                                                        args => [
                                                                                                                                                                                                        ],
                                                                                                                                                                                                    },
                                                                                                                                                                                                },
                                                                                                                                                                                                right => leaf '200',
                                                                                                                                                                                            },
                                                                                                                                                                                        ],
                                                                                                                                                                                    },
                                                                                                                                                                                    function_call { 'is',
                                                                                                                                                                                        args => [
                                                                                                                                                                                            branch { ',',
                                                                                                                                                                                                left => branch { '->',
                                                                                                                                                                                                    left => leaf '$res',
                                                                                                                                                                                                    right => function_call { 'message',
                                                                                                                                                                                                        args => [
                                                                                                                                                                                                        ],
                                                                                                                                                                                                    },
                                                                                                                                                                                                },
                                                                                                                                                                                                right => leaf 'OK',
                                                                                                                                                                                            },
                                                                                                                                                                                        ],
                                                                                                                                                                                    },
                                                                                                                                                                                    function_call { 'is',
                                                                                                                                                                                        args => [
                                                                                                                                                                                            branch { ',',
                                                                                                                                                                                                left => branch { '->',
                                                                                                                                                                                                    left => leaf '$res',
                                                                                                                                                                                                    right => function_call { 'header',
                                                                                                                                                                                                        args => [
                                                                                                                                                                                                            leaf 'Client-Content-Length',
                                                                                                                                                                                                        ],
                                                                                                                                                                                                    },
                                                                                                                                                                                                },
                                                                                                                                                                                                right => leaf '14',
                                                                                                                                                                                            },
                                                                                                                                                                                        ],
                                                                                                                                                                                    },
                                                                                                                                                                                    function_call { 'is',
                                                                                                                                                                                        args => [
                                                                                                                                                                                            branch { ',',
                                                                                                                                                                                                left => branch { '->',
                                                                                                                                                                                                    left => leaf '$res',
                                                                                                                                                                                                    right => function_call { 'header',
                                                                                                                                                                                                        args => [
                                                                                                                                                                                                            leaf 'Client-Content-Type',
                                                                                                                                                                                                        ],
                                                                                                                                                                                                    },
                                                                                                                                                                                                },
                                                                                                                                                                                                right => leaf 'application/x-www-form-urlencoded',
                                                                                                                                                                                            },
                                                                                                                                                                                        ],
                                                                                                                                                                                    },
                                                                                                                                                                                    function_call { 'is',
                                                                                                                                                                                        args => [
                                                                                                                                                                                            branch { ',',
                                                                                                                                                                                                left => branch { '->',
                                                                                                                                                                                                    left => leaf '$res',
                                                                                                                                                                                                    right => function_call { 'header',
                                                                                                                                                                                                        args => [
                                                                                                                                                                                                            leaf 'content_type',
                                                                                                                                                                                                        ],
                                                                                                                                                                                                    },
                                                                                                                                                                                                },
                                                                                                                                                                                                right => leaf 'text/plain',
                                                                                                                                                                                            },
                                                                                                                                                                                        ],
                                                                                                                                                                                    },
                                                                                                                                                                                    function_call { 'is',
                                                                                                                                                                                        args => [
                                                                                                                                                                                            branch { ',',
                                                                                                                                                                                                left => branch { '->',
                                                                                                                                                                                                    left => leaf '$res',
                                                                                                                                                                                                    right => function_call { 'content',
                                                                                                                                                                                                        args => [
                                                                                                                                                                                                        ],
                                                                                                                                                                                                    },
                                                                                                                                                                                                },
                                                                                                                                                                                                right => leaf 'Hello, name=tatsuhiko',
                                                                                                                                                                                            },
                                                                                                                                                                                        ],
                                                                                                                                                                                    },
                                                                                                                                                                                ],
                                                                                                                                                                            },
                                                                                                                                                                        },
                                                                                                                                                                        right => function { 'sub',
                                                                                                                                                                            body => [
                                                                                                                                                                                branch { '=',
                                                                                                                                                                                    left => leaf '$env',
                                                                                                                                                                                    right => function_call { 'shift',
                                                                                                                                                                                        args => [
                                                                                                                                                                                        ],
                                                                                                                                                                                    },
                                                                                                                                                                                },
                                                                                                                                                                                leaf '$body',
                                                                                                                                                                                branch { '->',
                                                                                                                                                                                    left => branch { '->',
                                                                                                                                                                                        left => leaf '$env',
                                                                                                                                                                                        right => hash_ref { '{}',
                                                                                                                                                                                            data => leaf 'psgi.input',
                                                                                                                                                                                        },
                                                                                                                                                                                    },
                                                                                                                                                                                    right => function_call { 'read',
                                                                                                                                                                                        args => [
                                                                                                                                                                                            list { '()',
                                                                                                                                                                                                data => branch { ',',
                                                                                                                                                                                                    left => leaf '$body',
                                                                                                                                                                                                    right => branch { '->',
                                                                                                                                                                                                        left => leaf '$env',
                                                                                                                                                                                                        right => hash_ref { '{}',
                                                                                                                                                                                                            data => leaf 'CONTENT_LENGTH',
                                                                                                                                                                                                        },
                                                                                                                                                                                                    },
                                                                                                                                                                                                },
                                                                                                                                                                                            },
                                                                                                                                                                                        ],
                                                                                                                                                                                    },
                                                                                                                                                                                },
                                                                                                                                                                                Test::Compiler::Parser::return { 'return',
                                                                                                                                                                                    body => array_ref { '[]',
                                                                                                                                                                                        data => branch { ',',
                                                                                                                                                                                            left => branch { ',',
                                                                                                                                                                                                left => branch { ',',
                                                                                                                                                                                                    left => leaf '200',
                                                                                                                                                                                                    right => array_ref { '[]',
                                                                                                                                                                                                        data => branch { ',',
                                                                                                                                                                                                            left => branch { ',',
                                                                                                                                                                                                                left => branch { ',',
                                                                                                                                                                                                                    left => branch { '=>',
                                                                                                                                                                                                                        left => leaf 'Content-Type',
                                                                                                                                                                                                                        right => leaf 'text/plain',
                                                                                                                                                                                                                    },
                                                                                                                                                                                                                    right => branch { '=>',
                                                                                                                                                                                                                        left => leaf 'Client-Content-Length',
                                                                                                                                                                                                                        right => branch { '->',
                                                                                                                                                                                                                            left => leaf '$env',
                                                                                                                                                                                                                            right => hash_ref { '{}',
                                                                                                                                                                                                                                data => leaf 'CONTENT_LENGTH',
                                                                                                                                                                                                                            },
                                                                                                                                                                                                                        },
                                                                                                                                                                                                                    },
                                                                                                                                                                                                                },
                                                                                                                                                                                                                right => branch { '=>',
                                                                                                                                                                                                                    left => leaf 'Client-Content-Type',
                                                                                                                                                                                                                    right => branch { '->',
                                                                                                                                                                                                                        left => leaf '$env',
                                                                                                                                                                                                                        right => hash_ref { '{}',
                                                                                                                                                                                                                            data => leaf 'CONTENT_TYPE',
                                                                                                                                                                                                                        },
                                                                                                                                                                                                                    },
                                                                                                                                                                                                                },
                                                                                                                                                                                                            },
                                                                                                                                                                                                        },
                                                                                                                                                                                                    },
                                                                                                                                                                                                },
                                                                                                                                                                                                right => array_ref { '[]',
                                                                                                                                                                                                    data => branch { '.',
                                                                                                                                                                                                        left => leaf 'Hello, ',
                                                                                                                                                                                                        right => leaf '$body',
                                                                                                                                                                                                    },
                                                                                                                                                                                                },
                                                                                                                                                                                            },
                                                                                                                                                                                        },
                                                                                                                                                                                    },
                                                                                                                                                                                },
                                                                                                                                                                            ],
                                                                                                                                                                        },
                                                                                                                                                                    },
                                                                                                                                                                },
                                                                                                                                                            },
                                                                                                                                                        },
                                                                                                                                                        right => array_ref { '[]',
                                                                                                                                                            data => branch { ',',
                                                                                                                                                                left => branch { ',',
                                                                                                                                                                    left => branch { ',',
                                                                                                                                                                        left => leaf 'big POST',
                                                                                                                                                                        right => function { 'sub',
                                                                                                                                                                            body => [
                                                                                                                                                                                branch { '=',
                                                                                                                                                                                    left => leaf '$cb',
                                                                                                                                                                                    right => function_call { 'shift',
                                                                                                                                                                                        args => [
                                                                                                                                                                                        ],
                                                                                                                                                                                    },
                                                                                                                                                                                },
                                                                                                                                                                                branch { '=',
                                                                                                                                                                                    left => leaf '$chunk',
                                                                                                                                                                                    right => branch { 'x',
                                                                                                                                                                                        left => leaf 'abcdefgh',
                                                                                                                                                                                        right => leaf '12000',
                                                                                                                                                                                    },
                                                                                                                                                                                },
                                                                                                                                                                                branch { '=',
                                                                                                                                                                                    left => leaf '$req',
                                                                                                                                                                                    right => branch { '->',
                                                                                                                                                                                        left => leaf 'HTTP::Request',
                                                                                                                                                                                        right => function_call { 'new',
                                                                                                                                                                                            args => [
                                                                                                                                                                                                list { '()',
                                                                                                                                                                                                    data => branch { '=>',
                                                                                                                                                                                                        left => leaf 'POST',
                                                                                                                                                                                                        right => leaf 'http://127.0.0.1/',
                                                                                                                                                                                                    },
                                                                                                                                                                                                },
                                                                                                                                                                                            ],
                                                                                                                                                                                        },
                                                                                                                                                                                    },
                                                                                                                                                                                },
                                                                                                                                                                                branch { '->',
                                                                                                                                                                                    left => leaf '$req',
                                                                                                                                                                                    right => function_call { 'content_length',
                                                                                                                                                                                        args => [
                                                                                                                                                                                            function_call { 'length',
                                                                                                                                                                                                args => [
                                                                                                                                                                                                    leaf '$chunk',
                                                                                                                                                                                                ],
                                                                                                                                                                                            },
                                                                                                                                                                                        ],
                                                                                                                                                                                    },
                                                                                                                                                                                },
                                                                                                                                                                                branch { '->',
                                                                                                                                                                                    left => leaf '$req',
                                                                                                                                                                                    right => function_call { 'content_type',
                                                                                                                                                                                        args => [
                                                                                                                                                                                            leaf 'application/octet-stream',
                                                                                                                                                                                        ],
                                                                                                                                                                                    },
                                                                                                                                                                                },
                                                                                                                                                                                branch { '->',
                                                                                                                                                                                    left => leaf '$req',
                                                                                                                                                                                    right => function_call { 'content',
                                                                                                                                                                                        args => [
                                                                                                                                                                                            leaf '$chunk',
                                                                                                                                                                                        ],
                                                                                                                                                                                    },
                                                                                                                                                                                },
                                                                                                                                                                                branch { '=',
                                                                                                                                                                                    left => leaf '$res',
                                                                                                                                                                                    right => branch { '->',
                                                                                                                                                                                        left => leaf '$cb',
                                                                                                                                                                                        right => list { '()',
                                                                                                                                                                                            data => leaf '$req',
                                                                                                                                                                                        },
                                                                                                                                                                                    },
                                                                                                                                                                                },
                                                                                                                                                                                function_call { 'is',
                                                                                                                                                                                    args => [
                                                                                                                                                                                        branch { ',',
                                                                                                                                                                                            left => branch { '->',
                                                                                                                                                                                                left => leaf '$res',
                                                                                                                                                                                                right => function_call { 'code',
                                                                                                                                                                                                    args => [
                                                                                                                                                                                                    ],
                                                                                                                                                                                                },
                                                                                                                                                                                            },
                                                                                                                                                                                            right => leaf '200',
                                                                                                                                                                                        },
                                                                                                                                                                                    ],
                                                                                                                                                                                },
                                                                                                                                                                                function_call { 'is',
                                                                                                                                                                                    args => [
                                                                                                                                                                                        branch { ',',
                                                                                                                                                                                            left => branch { '->',
                                                                                                                                                                                                left => leaf '$res',
                                                                                                                                                                                                right => function_call { 'message',
                                                                                                                                                                                                    args => [
                                                                                                                                                                                                    ],
                                                                                                                                                                                                },
                                                                                                                                                                                            },
                                                                                                                                                                                            right => leaf 'OK',
                                                                                                                                                                                        },
                                                                                                                                                                                    ],
                                                                                                                                                                                },
                                                                                                                                                                                function_call { 'is',
                                                                                                                                                                                    args => [
                                                                                                                                                                                        branch { ',',
                                                                                                                                                                                            left => branch { '->',
                                                                                                                                                                                                left => leaf '$res',
                                                                                                                                                                                                right => function_call { 'header',
                                                                                                                                                                                                    args => [
                                                                                                                                                                                                        leaf 'Client-Content-Length',
                                                                                                                                                                                                    ],
                                                                                                                                                                                                },
                                                                                                                                                                                            },
                                                                                                                                                                                            right => function_call { 'length',
                                                                                                                                                                                                args => [
                                                                                                                                                                                                    leaf '$chunk',
                                                                                                                                                                                                ],
                                                                                                                                                                                            },
                                                                                                                                                                                        },
                                                                                                                                                                                    ],
                                                                                                                                                                                },
                                                                                                                                                                                function_call { 'is',
                                                                                                                                                                                    args => [
                                                                                                                                                                                        branch { ',',
                                                                                                                                                                                            left => function_call { 'length',
                                                                                                                                                                                                args => [
                                                                                                                                                                                                    branch { '->',
                                                                                                                                                                                                        left => leaf '$res',
                                                                                                                                                                                                        right => function_call { 'content',
                                                                                                                                                                                                            args => [
                                                                                                                                                                                                            ],
                                                                                                                                                                                                        },
                                                                                                                                                                                                    },
                                                                                                                                                                                                ],
                                                                                                                                                                                            },
                                                                                                                                                                                            right => function_call { 'length',
                                                                                                                                                                                                args => [
                                                                                                                                                                                                    leaf '$chunk',
                                                                                                                                                                                                ],
                                                                                                                                                                                            },
                                                                                                                                                                                        },
                                                                                                                                                                                    ],
                                                                                                                                                                                },
                                                                                                                                                                                function_call { 'is',
                                                                                                                                                                                    args => [
                                                                                                                                                                                        branch { ',',
                                                                                                                                                                                            left => function_call { 'Digest::MD5::md5_hex',
                                                                                                                                                                                                args => [
                                                                                                                                                                                                    branch { '->',
                                                                                                                                                                                                        left => leaf '$res',
                                                                                                                                                                                                        right => function_call { 'content',
                                                                                                                                                                                                            args => [
                                                                                                                                                                                                            ],
                                                                                                                                                                                                        },
                                                                                                                                                                                                    },
                                                                                                                                                                                                ],
                                                                                                                                                                                            },
                                                                                                                                                                                            right => function_call { 'Digest::MD5::md5_hex',
                                                                                                                                                                                                args => [
                                                                                                                                                                                                    leaf '$chunk',
                                                                                                                                                                                                ],
                                                                                                                                                                                            },
                                                                                                                                                                                        },
                                                                                                                                                                                    ],
                                                                                                                                                                                },
                                                                                                                                                                            ],
                                                                                                                                                                        },
                                                                                                                                                                    },
                                                                                                                                                                    right => function { 'sub',
                                                                                                                                                                        body => [
                                                                                                                                                                            branch { '=',
                                                                                                                                                                                left => leaf '$env',
                                                                                                                                                                                right => function_call { 'shift',
                                                                                                                                                                                    args => [
                                                                                                                                                                                    ],
                                                                                                                                                                                },
                                                                                                                                                                            },
                                                                                                                                                                            branch { '=',
                                                                                                                                                                                left => leaf '$len',
                                                                                                                                                                                right => branch { '->',
                                                                                                                                                                                    left => leaf '$env',
                                                                                                                                                                                    right => hash_ref { '{}',
                                                                                                                                                                                        data => leaf 'CONTENT_LENGTH',
                                                                                                                                                                                    },
                                                                                                                                                                                },
                                                                                                                                                                            },
                                                                                                                                                                            branch { '=',
                                                                                                                                                                                left => leaf '$body',
                                                                                                                                                                                right => leaf '',
                                                                                                                                                                            },
                                                                                                                                                                            leaf '$spin',
                                                                                                                                                                            while_stmt { 'while',
                                                                                                                                                                                expr => branch { '>',
                                                                                                                                                                                    left => leaf '$len',
                                                                                                                                                                                    right => leaf '0',
                                                                                                                                                                                },
                                                                                                                                                                                true_stmt => [
                                                                                                                                                                                    branch { '=',
                                                                                                                                                                                        left => leaf '$rc',
                                                                                                                                                                                        right => branch { '->',
                                                                                                                                                                                            left => branch { '->',
                                                                                                                                                                                                left => leaf '$env',
                                                                                                                                                                                                right => hash_ref { '{}',
                                                                                                                                                                                                    data => leaf 'psgi.input',
                                                                                                                                                                                                },
                                                                                                                                                                                            },
                                                                                                                                                                                            right => function_call { 'read',
                                                                                                                                                                                                args => [
                                                                                                                                                                                                    list { '()',
                                                                                                                                                                                                        data => branch { ',',
                                                                                                                                                                                                            left => branch { ',',
                                                                                                                                                                                                                left => leaf '$body',
                                                                                                                                                                                                                right => branch { '->',
                                                                                                                                                                                                                    left => leaf '$env',
                                                                                                                                                                                                                    right => hash_ref { '{}',
                                                                                                                                                                                                                        data => leaf 'CONTENT_LENGTH',
                                                                                                                                                                                                                    },
                                                                                                                                                                                                                },
                                                                                                                                                                                                            },
                                                                                                                                                                                                            right => function_call { 'length',
                                                                                                                                                                                                                args => [
                                                                                                                                                                                                                    leaf '$body',
                                                                                                                                                                                                                ],
                                                                                                                                                                                                            },
                                                                                                                                                                                                        },
                                                                                                                                                                                                    },
                                                                                                                                                                                                ],
                                                                                                                                                                                            },
                                                                                                                                                                                        },
                                                                                                                                                                                    },
                                                                                                                                                                                    branch { '-=',
                                                                                                                                                                                        left => leaf '$len',
                                                                                                                                                                                        right => leaf '$rc',
                                                                                                                                                                                    },
                                                                                                                                                                                    if_stmt { 'if',
                                                                                                                                                                                        expr => branch { '>',
                                                                                                                                                                                            left => single_term_operator { '++',
                                                                                                                                                                                                expr => leaf '$spin',
                                                                                                                                                                                            },
                                                                                                                                                                                            right => leaf '2000',
                                                                                                                                                                                        },
                                                                                                                                                                                        true_stmt => control_stmt { 'last',
                                                                                                                                                                                        },
                                                                                                                                                                                    },
                                                                                                                                                                                ],
                                                                                                                                                                            },
                                                                                                                                                                            Test::Compiler::Parser::return { 'return',
                                                                                                                                                                                body => array_ref { '[]',
                                                                                                                                                                                    data => branch { ',',
                                                                                                                                                                                        left => branch { ',',
                                                                                                                                                                                            left => branch { ',',
                                                                                                                                                                                                left => leaf '200',
                                                                                                                                                                                                right => array_ref { '[]',
                                                                                                                                                                                                    data => branch { ',',
                                                                                                                                                                                                        left => branch { ',',
                                                                                                                                                                                                            left => branch { ',',
                                                                                                                                                                                                                left => branch { '=>',
                                                                                                                                                                                                                    left => leaf 'Content-Type',
                                                                                                                                                                                                                    right => leaf 'text/plain',
                                                                                                                                                                                                                },
                                                                                                                                                                                                                right => branch { '=>',
                                                                                                                                                                                                                    left => leaf 'Client-Content-Length',
                                                                                                                                                                                                                    right => branch { '->',
                                                                                                                                                                                                                        left => leaf '$env',
                                                                                                                                                                                                                        right => hash_ref { '{}',
                                                                                                                                                                                                                            data => leaf 'CONTENT_LENGTH',
                                                                                                                                                                                                                        },
                                                                                                                                                                                                                    },
                                                                                                                                                                                                                },
                                                                                                                                                                                                            },
                                                                                                                                                                                                            right => branch { '=>',
                                                                                                                                                                                                                left => leaf 'Client-Content-Type',
                                                                                                                                                                                                                right => branch { '->',
                                                                                                                                                                                                                    left => leaf '$env',
                                                                                                                                                                                                                    right => hash_ref { '{}',
                                                                                                                                                                                                                        data => leaf 'CONTENT_TYPE',
                                                                                                                                                                                                                    },
                                                                                                                                                                                                                },
                                                                                                                                                                                                            },
                                                                                                                                                                                                        },
                                                                                                                                                                                                    },
                                                                                                                                                                                                },
                                                                                                                                                                                            },
                                                                                                                                                                                            right => array_ref { '[]',
                                                                                                                                                                                                data => leaf '$body',
                                                                                                                                                                                            },
                                                                                                                                                                                        },
                                                                                                                                                                                    },
                                                                                                                                                                                },
                                                                                                                                                                            },
                                                                                                                                                                        ],
                                                                                                                                                                    },
                                                                                                                                                                },
                                                                                                                                                            },
                                                                                                                                                        },
                                                                                                                                                    },
                                                                                                                                                    right => array_ref { '[]',
                                                                                                                                                        data => branch { ',',
                                                                                                                                                            left => branch { ',',
                                                                                                                                                                left => branch { ',',
                                                                                                                                                                    left => leaf 'psgi.url_scheme',
                                                                                                                                                                    right => function { 'sub',
                                                                                                                                                                        body => [
                                                                                                                                                                            branch { '=',
                                                                                                                                                                                left => leaf '$cb',
                                                                                                                                                                                right => function_call { 'shift',
                                                                                                                                                                                    args => [
                                                                                                                                                                                    ],
                                                                                                                                                                                },
                                                                                                                                                                            },
                                                                                                                                                                            branch { '=',
                                                                                                                                                                                left => leaf '$res',
                                                                                                                                                                                right => branch { '->',
                                                                                                                                                                                    left => leaf '$cb',
                                                                                                                                                                                    right => list { '()',
                                                                                                                                                                                        data => function_call { 'POST',
                                                                                                                                                                                            args => [
                                                                                                                                                                                                leaf 'http://127.0.0.1/',
                                                                                                                                                                                            ],
                                                                                                                                                                                        },
                                                                                                                                                                                    },
                                                                                                                                                                                },
                                                                                                                                                                            },
                                                                                                                                                                            function_call { 'is',
                                                                                                                                                                                args => [
                                                                                                                                                                                    branch { ',',
                                                                                                                                                                                        left => branch { '->',
                                                                                                                                                                                            left => leaf '$res',
                                                                                                                                                                                            right => function_call { 'code',
                                                                                                                                                                                                args => [
                                                                                                                                                                                                ],
                                                                                                                                                                                            },
                                                                                                                                                                                        },
                                                                                                                                                                                        right => leaf '200',
                                                                                                                                                                                    },
                                                                                                                                                                                ],
                                                                                                                                                                            },
                                                                                                                                                                            function_call { 'is',
                                                                                                                                                                                args => [
                                                                                                                                                                                    branch { ',',
                                                                                                                                                                                        left => branch { '->',
                                                                                                                                                                                            left => leaf '$res',
                                                                                                                                                                                            right => function_call { 'message',
                                                                                                                                                                                                args => [
                                                                                                                                                                                                ],
                                                                                                                                                                                            },
                                                                                                                                                                                        },
                                                                                                                                                                                        right => leaf 'OK',
                                                                                                                                                                                    },
                                                                                                                                                                                ],
                                                                                                                                                                            },
                                                                                                                                                                            function_call { 'is',
                                                                                                                                                                                args => [
                                                                                                                                                                                    branch { ',',
                                                                                                                                                                                        left => branch { '->',
                                                                                                                                                                                            left => leaf '$res',
                                                                                                                                                                                            right => function_call { 'header',
                                                                                                                                                                                                args => [
                                                                                                                                                                                                    leaf 'content_type',
                                                                                                                                                                                                ],
                                                                                                                                                                                            },
                                                                                                                                                                                        },
                                                                                                                                                                                        right => leaf 'text/plain',
                                                                                                                                                                                    },
                                                                                                                                                                                ],
                                                                                                                                                                            },
                                                                                                                                                                            function_call { 'is',
                                                                                                                                                                                args => [
                                                                                                                                                                                    branch { ',',
                                                                                                                                                                                        left => branch { '->',
                                                                                                                                                                                            left => leaf '$res',
                                                                                                                                                                                            right => function_call { 'content',
                                                                                                                                                                                                args => [
                                                                                                                                                                                                ],
                                                                                                                                                                                            },
                                                                                                                                                                                        },
                                                                                                                                                                                        right => leaf 'http',
                                                                                                                                                                                    },
                                                                                                                                                                                ],
                                                                                                                                                                            },
                                                                                                                                                                        ],
                                                                                                                                                                    },
                                                                                                                                                                },
                                                                                                                                                                right => function { 'sub',
                                                                                                                                                                    body => [
                                                                                                                                                                        branch { '=',
                                                                                                                                                                            left => leaf '$env',
                                                                                                                                                                            right => array { '$_',
                                                                                                                                                                                idx => array_ref { '[]',
                                                                                                                                                                                    data => leaf '0',
                                                                                                                                                                                },
                                                                                                                                                                            },
                                                                                                                                                                        },
                                                                                                                                                                        Test::Compiler::Parser::return { 'return',
                                                                                                                                                                            body => array_ref { '[]',
                                                                                                                                                                                data => branch { ',',
                                                                                                                                                                                    left => branch { ',',
                                                                                                                                                                                        left => branch { ',',
                                                                                                                                                                                            left => leaf '200',
                                                                                                                                                                                            right => array_ref { '[]',
                                                                                                                                                                                                data => branch { ',',
                                                                                                                                                                                                    left => branch { '=>',
                                                                                                                                                                                                        left => leaf 'Content-Type',
                                                                                                                                                                                                        right => leaf 'text/plain',
                                                                                                                                                                                                    },
                                                                                                                                                                                                },
                                                                                                                                                                                            },
                                                                                                                                                                                        },
                                                                                                                                                                                        right => array_ref { '[]',
                                                                                                                                                                                            data => branch { '->',
                                                                                                                                                                                                left => leaf '$env',
                                                                                                                                                                                                right => hash_ref { '{}',
                                                                                                                                                                                                    data => leaf 'psgi.url_scheme',
                                                                                                                                                                                                },
                                                                                                                                                                                            },
                                                                                                                                                                                        },
                                                                                                                                                                                    },
                                                                                                                                                                                },
                                                                                                                                                                            },
                                                                                                                                                                        },
                                                                                                                                                                    ],
                                                                                                                                                                },
                                                                                                                                                            },
                                                                                                                                                        },
                                                                                                                                                    },
                                                                                                                                                },
                                                                                                                                                right => array_ref { '[]',
                                                                                                                                                    data => branch { ',',
                                                                                                                                                        left => branch { ',',
                                                                                                                                                            left => branch { ',',
                                                                                                                                                                left => leaf 'return glob',
                                                                                                                                                                right => function { 'sub',
                                                                                                                                                                    body => [
                                                                                                                                                                        branch { '=',
                                                                                                                                                                            left => leaf '$cb',
                                                                                                                                                                            right => function_call { 'shift',
                                                                                                                                                                                args => [
                                                                                                                                                                                ],
                                                                                                                                                                            },
                                                                                                                                                                        },
                                                                                                                                                                        branch { '=',
                                                                                                                                                                            left => leaf '$res',
                                                                                                                                                                            right => branch { '->',
                                                                                                                                                                                left => leaf '$cb',
                                                                                                                                                                                right => list { '()',
                                                                                                                                                                                    data => function_call { 'GET',
                                                                                                                                                                                        args => [
                                                                                                                                                                                            leaf 'http://127.0.0.1/',
                                                                                                                                                                                        ],
                                                                                                                                                                                    },
                                                                                                                                                                                },
                                                                                                                                                                            },
                                                                                                                                                                        },
                                                                                                                                                                        function_call { 'is',
                                                                                                                                                                            args => [
                                                                                                                                                                                branch { ',',
                                                                                                                                                                                    left => branch { '->',
                                                                                                                                                                                        left => leaf '$res',
                                                                                                                                                                                        right => function_call { 'code',
                                                                                                                                                                                            args => [
                                                                                                                                                                                            ],
                                                                                                                                                                                        },
                                                                                                                                                                                    },
                                                                                                                                                                                    right => leaf '200',
                                                                                                                                                                                },
                                                                                                                                                                            ],
                                                                                                                                                                        },
                                                                                                                                                                        function_call { 'is',
                                                                                                                                                                            args => [
                                                                                                                                                                                branch { ',',
                                                                                                                                                                                    left => branch { '->',
                                                                                                                                                                                        left => leaf '$res',
                                                                                                                                                                                        right => function_call { 'message',
                                                                                                                                                                                            args => [
                                                                                                                                                                                            ],
                                                                                                                                                                                        },
                                                                                                                                                                                    },
                                                                                                                                                                                    right => leaf 'OK',
                                                                                                                                                                                },
                                                                                                                                                                            ],
                                                                                                                                                                        },
                                                                                                                                                                        function_call { 'is',
                                                                                                                                                                            args => [
                                                                                                                                                                                branch { ',',
                                                                                                                                                                                    left => branch { '->',
                                                                                                                                                                                        left => leaf '$res',
                                                                                                                                                                                        right => function_call { 'header',
                                                                                                                                                                                            args => [
                                                                                                                                                                                                leaf 'content_type',
                                                                                                                                                                                            ],
                                                                                                                                                                                        },
                                                                                                                                                                                    },
                                                                                                                                                                                    right => leaf 'text/plain',
                                                                                                                                                                                },
                                                                                                                                                                            ],
                                                                                                                                                                        },
                                                                                                                                                                        function_call { 'like',
                                                                                                                                                                            args => [
                                                                                                                                                                                branch { ',',
                                                                                                                                                                                    left => branch { '->',
                                                                                                                                                                                        left => leaf '$res',
                                                                                                                                                                                        right => function_call { 'content',
                                                                                                                                                                                            args => [
                                                                                                                                                                                            ],
                                                                                                                                                                                        },
                                                                                                                                                                                    },
                                                                                                                                                                                    right => reg_prefix { 'qr',
                                                                                                                                                                                        expr => leaf '^package ',
                                                                                                                                                                                    },
                                                                                                                                                                                },
                                                                                                                                                                            ],
                                                                                                                                                                        },
                                                                                                                                                                        function_call { 'like',
                                                                                                                                                                            args => [
                                                                                                                                                                                branch { ',',
                                                                                                                                                                                    left => branch { '->',
                                                                                                                                                                                        left => leaf '$res',
                                                                                                                                                                                        right => function_call { 'content',
                                                                                                                                                                                            args => [
                                                                                                                                                                                            ],
                                                                                                                                                                                        },
                                                                                                                                                                                    },
                                                                                                                                                                                    right => reg_prefix { 'qr',
                                                                                                                                                                                        expr => leaf 'END_MARK_FOR_TESTING$',
                                                                                                                                                                                    },
                                                                                                                                                                                },
                                                                                                                                                                            ],
                                                                                                                                                                        },
                                                                                                                                                                    ],
                                                                                                                                                                },
                                                                                                                                                            },
                                                                                                                                                            right => function { 'sub',
                                                                                                                                                                body => [
                                                                                                                                                                    branch { '=',
                                                                                                                                                                        left => leaf '$env',
                                                                                                                                                                        right => function_call { 'shift',
                                                                                                                                                                            args => [
                                                                                                                                                                            ],
                                                                                                                                                                        },
                                                                                                                                                                    },
                                                                                                                                                                    branch { 'or',
                                                                                                                                                                        left => function_call { 'open',
                                                                                                                                                                            args => [
                                                                                                                                                                                branch { ',',
                                                                                                                                                                                    left => branch { ',',
                                                                                                                                                                                        left => leaf '$fh',
                                                                                                                                                                                        right => leaf '<',
                                                                                                                                                                                    },
                                                                                                                                                                                },
                                                                                                                                                                            ],
                                                                                                                                                                        },
                                                                                                                                                                        right => function_call { 'die',
                                                                                                                                                                            args => [
                                                                                                                                                                                leaf '$!',
                                                                                                                                                                            ],
                                                                                                                                                                        },
                                                                                                                                                                    },
                                                                                                                                                                    Test::Compiler::Parser::return { 'return',
                                                                                                                                                                        body => array_ref { '[]',
                                                                                                                                                                            data => branch { ',',
                                                                                                                                                                                left => branch { ',',
                                                                                                                                                                                    left => branch { ',',
                                                                                                                                                                                        left => leaf '200',
                                                                                                                                                                                        right => array_ref { '[]',
                                                                                                                                                                                            data => branch { ',',
                                                                                                                                                                                                left => branch { '=>',
                                                                                                                                                                                                    left => leaf 'Content-Type',
                                                                                                                                                                                                    right => leaf 'text/plain',
                                                                                                                                                                                                },
                                                                                                                                                                                            },
                                                                                                                                                                                        },
                                                                                                                                                                                    },
                                                                                                                                                                                    right => leaf '$fh',
                                                                                                                                                                                },
                                                                                                                                                                            },
                                                                                                                                                                        },
                                                                                                                                                                    },
                                                                                                                                                                ],
                                                                                                                                                            },
                                                                                                                                                        },
                                                                                                                                                    },
                                                                                                                                                },
                                                                                                                                            },
                                                                                                                                            right => array_ref { '[]',
                                                                                                                                                data => branch { ',',
                                                                                                                                                    left => branch { ',',
                                                                                                                                                        left => branch { ',',
                                                                                                                                                            left => leaf 'filehandle',
                                                                                                                                                            right => function { 'sub',
                                                                                                                                                                body => [
                                                                                                                                                                    branch { '=',
                                                                                                                                                                        left => leaf '$cb',
                                                                                                                                                                        right => function_call { 'shift',
                                                                                                                                                                            args => [
                                                                                                                                                                            ],
                                                                                                                                                                        },
                                                                                                                                                                    },
                                                                                                                                                                    branch { '=',
                                                                                                                                                                        left => leaf '$res',
                                                                                                                                                                        right => branch { '->',
                                                                                                                                                                            left => leaf '$cb',
                                                                                                                                                                            right => list { '()',
                                                                                                                                                                                data => function_call { 'GET',
                                                                                                                                                                                    args => [
                                                                                                                                                                                        leaf 'http://127.0.0.1/foo.jpg',
                                                                                                                                                                                    ],
                                                                                                                                                                                },
                                                                                                                                                                            },
                                                                                                                                                                        },
                                                                                                                                                                    },
                                                                                                                                                                    function_call { 'is',
                                                                                                                                                                        args => [
                                                                                                                                                                            branch { ',',
                                                                                                                                                                                left => branch { '->',
                                                                                                                                                                                    left => leaf '$res',
                                                                                                                                                                                    right => function_call { 'code',
                                                                                                                                                                                        args => [
                                                                                                                                                                                        ],
                                                                                                                                                                                    },
                                                                                                                                                                                },
                                                                                                                                                                                right => leaf '200',
                                                                                                                                                                            },
                                                                                                                                                                        ],
                                                                                                                                                                    },
                                                                                                                                                                    function_call { 'is',
                                                                                                                                                                        args => [
                                                                                                                                                                            branch { ',',
                                                                                                                                                                                left => branch { '->',
                                                                                                                                                                                    left => leaf '$res',
                                                                                                                                                                                    right => function_call { 'message',
                                                                                                                                                                                        args => [
                                                                                                                                                                                        ],
                                                                                                                                                                                    },
                                                                                                                                                                                },
                                                                                                                                                                                right => leaf 'OK',
                                                                                                                                                                            },
                                                                                                                                                                        ],
                                                                                                                                                                    },
                                                                                                                                                                    function_call { 'is',
                                                                                                                                                                        args => [
                                                                                                                                                                            branch { ',',
                                                                                                                                                                                left => branch { '->',
                                                                                                                                                                                    left => leaf '$res',
                                                                                                                                                                                    right => function_call { 'header',
                                                                                                                                                                                        args => [
                                                                                                                                                                                            leaf 'content_type',
                                                                                                                                                                                        ],
                                                                                                                                                                                    },
                                                                                                                                                                                },
                                                                                                                                                                                right => leaf 'image/jpeg',
                                                                                                                                                                            },
                                                                                                                                                                        ],
                                                                                                                                                                    },
                                                                                                                                                                    function_call { 'is',
                                                                                                                                                                        args => [
                                                                                                                                                                            branch { ',',
                                                                                                                                                                                left => function_call { 'length',
                                                                                                                                                                                    args => [
                                                                                                                                                                                        branch { '->',
                                                                                                                                                                                            left => leaf '$res',
                                                                                                                                                                                            right => function_call { 'content',
                                                                                                                                                                                                args => [
                                                                                                                                                                                                ],
                                                                                                                                                                                            },
                                                                                                                                                                                        },
                                                                                                                                                                                    ],
                                                                                                                                                                                },
                                                                                                                                                                                right => leaf '4745',
                                                                                                                                                                            },
                                                                                                                                                                        ],
                                                                                                                                                                    },
                                                                                                                                                                ],
                                                                                                                                                            },
                                                                                                                                                        },
                                                                                                                                                        right => function { 'sub',
                                                                                                                                                            body => [
                                                                                                                                                                branch { '=',
                                                                                                                                                                    left => leaf '$env',
                                                                                                                                                                    right => function_call { 'shift',
                                                                                                                                                                        args => [
                                                                                                                                                                        ],
                                                                                                                                                                    },
                                                                                                                                                                },
                                                                                                                                                                function_call { 'open',
                                                                                                                                                                    args => [
                                                                                                                                                                        branch { ',',
                                                                                                                                                                            left => branch { ',',
                                                                                                                                                                                left => leaf '$fh',
                                                                                                                                                                                right => leaf '<',
                                                                                                                                                                            },
                                                                                                                                                                            right => leaf '$share_dir/face.jpg',
                                                                                                                                                                        },
                                                                                                                                                                    ],
                                                                                                                                                                },
                                                                                                                                                                Test::Compiler::Parser::return { 'return',
                                                                                                                                                                    body => array_ref { '[]',
                                                                                                                                                                        data => branch { ',',
                                                                                                                                                                            left => branch { ',',
                                                                                                                                                                                left => leaf '200',
                                                                                                                                                                                right => array_ref { '[]',
                                                                                                                                                                                    data => branch { ',',
                                                                                                                                                                                        left => branch { '=>',
                                                                                                                                                                                            left => leaf 'Content-Type',
                                                                                                                                                                                            right => leaf 'image/jpeg',
                                                                                                                                                                                        },
                                                                                                                                                                                        right => branch { '=>',
                                                                                                                                                                                            left => leaf 'Content-Length',
                                                                                                                                                                                            right => handle { '-s',
                                                                                                                                                                                                expr => leaf '$fh',
                                                                                                                                                                                            },
                                                                                                                                                                                        },
                                                                                                                                                                                    },
                                                                                                                                                                                },
                                                                                                                                                                            },
                                                                                                                                                                            right => leaf '$fh',
                                                                                                                                                                        },
                                                                                                                                                                    },
                                                                                                                                                                },
                                                                                                                                                            ],
                                                                                                                                                        },
                                                                                                                                                    },
                                                                                                                                                },
                                                                                                                                            },
                                                                                                                                        },
                                                                                                                                        right => array_ref { '[]',
                                                                                                                                            data => branch { ',',
                                                                                                                                                left => branch { ',',
                                                                                                                                                    left => branch { ',',
                                                                                                                                                        left => leaf 'bigger file',
                                                                                                                                                        right => function { 'sub',
                                                                                                                                                            body => [
                                                                                                                                                                branch { '=',
                                                                                                                                                                    left => leaf '$cb',
                                                                                                                                                                    right => function_call { 'shift',
                                                                                                                                                                        args => [
                                                                                                                                                                        ],
                                                                                                                                                                    },
                                                                                                                                                                },
                                                                                                                                                                branch { '=',
                                                                                                                                                                    left => leaf '$res',
                                                                                                                                                                    right => branch { '->',
                                                                                                                                                                        left => leaf '$cb',
                                                                                                                                                                        right => list { '()',
                                                                                                                                                                            data => function_call { 'GET',
                                                                                                                                                                                args => [
                                                                                                                                                                                    leaf 'http://127.0.0.1/baybridge.jpg',
                                                                                                                                                                                ],
                                                                                                                                                                            },
                                                                                                                                                                        },
                                                                                                                                                                    },
                                                                                                                                                                },
                                                                                                                                                                function_call { 'is',
                                                                                                                                                                    args => [
                                                                                                                                                                        branch { ',',
                                                                                                                                                                            left => branch { '->',
                                                                                                                                                                                left => leaf '$res',
                                                                                                                                                                                right => function_call { 'code',
                                                                                                                                                                                    args => [
                                                                                                                                                                                    ],
                                                                                                                                                                                },
                                                                                                                                                                            },
                                                                                                                                                                            right => leaf '200',
                                                                                                                                                                        },
                                                                                                                                                                    ],
                                                                                                                                                                },
                                                                                                                                                                function_call { 'is',
                                                                                                                                                                    args => [
                                                                                                                                                                        branch { ',',
                                                                                                                                                                            left => branch { '->',
                                                                                                                                                                                left => leaf '$res',
                                                                                                                                                                                right => function_call { 'message',
                                                                                                                                                                                    args => [
                                                                                                                                                                                    ],
                                                                                                                                                                                },
                                                                                                                                                                            },
                                                                                                                                                                            right => leaf 'OK',
                                                                                                                                                                        },
                                                                                                                                                                    ],
                                                                                                                                                                },
                                                                                                                                                                function_call { 'is',
                                                                                                                                                                    args => [
                                                                                                                                                                        branch { ',',
                                                                                                                                                                            left => branch { '->',
                                                                                                                                                                                left => leaf '$res',
                                                                                                                                                                                right => function_call { 'header',
                                                                                                                                                                                    args => [
                                                                                                                                                                                        leaf 'content_type',
                                                                                                                                                                                    ],
                                                                                                                                                                                },
                                                                                                                                                                            },
                                                                                                                                                                            right => leaf 'image/jpeg',
                                                                                                                                                                        },
                                                                                                                                                                    ],
                                                                                                                                                                },
                                                                                                                                                                function_call { 'is',
                                                                                                                                                                    args => [
                                                                                                                                                                        branch { ',',
                                                                                                                                                                            left => function_call { 'length',
                                                                                                                                                                                args => [
                                                                                                                                                                                    branch { '->',
                                                                                                                                                                                        left => leaf '$res',
                                                                                                                                                                                        right => function_call { 'content',
                                                                                                                                                                                            args => [
                                                                                                                                                                                            ],
                                                                                                                                                                                        },
                                                                                                                                                                                    },
                                                                                                                                                                                ],
                                                                                                                                                                            },
                                                                                                                                                                            right => leaf '79838',
                                                                                                                                                                        },
                                                                                                                                                                    ],
                                                                                                                                                                },
                                                                                                                                                                function_call { 'is',
                                                                                                                                                                    args => [
                                                                                                                                                                        branch { ',',
                                                                                                                                                                            left => function_call { 'Digest::MD5::md5_hex',
                                                                                                                                                                                args => [
                                                                                                                                                                                    branch { '->',
                                                                                                                                                                                        left => leaf '$res',
                                                                                                                                                                                        right => function_call { 'content',
                                                                                                                                                                                            args => [
                                                                                                                                                                                            ],
                                                                                                                                                                                        },
                                                                                                                                                                                    },
                                                                                                                                                                                ],
                                                                                                                                                                            },
                                                                                                                                                                            right => leaf '983726ae0e4ce5081bef5fb2b7216950',
                                                                                                                                                                        },
                                                                                                                                                                    ],
                                                                                                                                                                },
                                                                                                                                                            ],
                                                                                                                                                        },
                                                                                                                                                    },
                                                                                                                                                    right => function { 'sub',
                                                                                                                                                        body => [
                                                                                                                                                            branch { '=',
                                                                                                                                                                left => leaf '$env',
                                                                                                                                                                right => function_call { 'shift',
                                                                                                                                                                    args => [
                                                                                                                                                                    ],
                                                                                                                                                                },
                                                                                                                                                            },
                                                                                                                                                            function_call { 'open',
                                                                                                                                                                args => [
                                                                                                                                                                    branch { ',',
                                                                                                                                                                        left => branch { ',',
                                                                                                                                                                            left => leaf '$fh',
                                                                                                                                                                            right => leaf '<',
                                                                                                                                                                        },
                                                                                                                                                                        right => leaf '$share_dir/baybridge.jpg',
                                                                                                                                                                    },
                                                                                                                                                                ],
                                                                                                                                                            },
                                                                                                                                                            function_call { 'binmode',
                                                                                                                                                                args => [
                                                                                                                                                                    leaf '$fh',
                                                                                                                                                                ],
                                                                                                                                                            },
                                                                                                                                                            Test::Compiler::Parser::return { 'return',
                                                                                                                                                                body => array_ref { '[]',
                                                                                                                                                                    data => branch { ',',
                                                                                                                                                                        left => branch { ',',
                                                                                                                                                                            left => leaf '200',
                                                                                                                                                                            right => array_ref { '[]',
                                                                                                                                                                                data => branch { ',',
                                                                                                                                                                                    left => branch { '=>',
                                                                                                                                                                                        left => leaf 'Content-Type',
                                                                                                                                                                                        right => leaf 'image/jpeg',
                                                                                                                                                                                    },
                                                                                                                                                                                    right => branch { '=>',
                                                                                                                                                                                        left => leaf 'Content-Length',
                                                                                                                                                                                        right => handle { '-s',
                                                                                                                                                                                            expr => leaf '$fh',
                                                                                                                                                                                        },
                                                                                                                                                                                    },
                                                                                                                                                                                },
                                                                                                                                                                            },
                                                                                                                                                                        },
                                                                                                                                                                        right => leaf '$fh',
                                                                                                                                                                    },
                                                                                                                                                                },
                                                                                                                                                            },
                                                                                                                                                        ],
                                                                                                                                                    },
                                                                                                                                                },
                                                                                                                                            },
                                                                                                                                        },
                                                                                                                                    },
                                                                                                                                    right => array_ref { '[]',
                                                                                                                                        data => branch { ',',
                                                                                                                                            left => branch { ',',
                                                                                                                                                left => branch { ',',
                                                                                                                                                    left => leaf 'handle HTTP-Header',
                                                                                                                                                    right => function { 'sub',
                                                                                                                                                        body => [
                                                                                                                                                            branch { '=',
                                                                                                                                                                left => leaf '$cb',
                                                                                                                                                                right => function_call { 'shift',
                                                                                                                                                                    args => [
                                                                                                                                                                    ],
                                                                                                                                                                },
                                                                                                                                                            },
                                                                                                                                                            branch { '=',
                                                                                                                                                                left => leaf '$res',
                                                                                                                                                                right => branch { '->',
                                                                                                                                                                    left => leaf '$cb',
                                                                                                                                                                    right => list { '()',
                                                                                                                                                                        data => function_call { 'GET',
                                                                                                                                                                            args => [
                                                                                                                                                                                branch { ',',
                                                                                                                                                                                    left => leaf 'http://127.0.0.1/foo/?dankogai=kogaidan',
                                                                                                                                                                                    right => branch { '=>',
                                                                                                                                                                                        left => leaf 'Foo',
                                                                                                                                                                                        right => leaf 'Bar',
                                                                                                                                                                                    },
                                                                                                                                                                                },
                                                                                                                                                                            ],
                                                                                                                                                                        },
                                                                                                                                                                    },
                                                                                                                                                                },
                                                                                                                                                            },
                                                                                                                                                            function_call { 'is',
                                                                                                                                                                args => [
                                                                                                                                                                    branch { ',',
                                                                                                                                                                        left => branch { '->',
                                                                                                                                                                            left => leaf '$res',
                                                                                                                                                                            right => function_call { 'code',
                                                                                                                                                                                args => [
                                                                                                                                                                                ],
                                                                                                                                                                            },
                                                                                                                                                                        },
                                                                                                                                                                        right => leaf '200',
                                                                                                                                                                    },
                                                                                                                                                                ],
                                                                                                                                                            },
                                                                                                                                                            function_call { 'is',
                                                                                                                                                                args => [
                                                                                                                                                                    branch { ',',
                                                                                                                                                                        left => branch { '->',
                                                                                                                                                                            left => leaf '$res',
                                                                                                                                                                            right => function_call { 'message',
                                                                                                                                                                                args => [
                                                                                                                                                                                ],
                                                                                                                                                                            },
                                                                                                                                                                        },
                                                                                                                                                                        right => leaf 'OK',
                                                                                                                                                                    },
                                                                                                                                                                ],
                                                                                                                                                            },
                                                                                                                                                            function_call { 'is',
                                                                                                                                                                args => [
                                                                                                                                                                    branch { ',',
                                                                                                                                                                        left => branch { '->',
                                                                                                                                                                            left => leaf '$res',
                                                                                                                                                                            right => function_call { 'header',
                                                                                                                                                                                args => [
                                                                                                                                                                                    leaf 'content_type',
                                                                                                                                                                                ],
                                                                                                                                                                            },
                                                                                                                                                                        },
                                                                                                                                                                        right => leaf 'text/plain',
                                                                                                                                                                    },
                                                                                                                                                                ],
                                                                                                                                                            },
                                                                                                                                                            function_call { 'is',
                                                                                                                                                                args => [
                                                                                                                                                                    branch { ',',
                                                                                                                                                                        left => branch { '->',
                                                                                                                                                                            left => leaf '$res',
                                                                                                                                                                            right => function_call { 'content',
                                                                                                                                                                                args => [
                                                                                                                                                                                ],
                                                                                                                                                                            },
                                                                                                                                                                        },
                                                                                                                                                                        right => leaf 'Bar',
                                                                                                                                                                    },
                                                                                                                                                                ],
                                                                                                                                                            },
                                                                                                                                                        ],
                                                                                                                                                    },
                                                                                                                                                },
                                                                                                                                                right => function { 'sub',
                                                                                                                                                    body => [
                                                                                                                                                        branch { '=',
                                                                                                                                                            left => leaf '$env',
                                                                                                                                                            right => function_call { 'shift',
                                                                                                                                                                args => [
                                                                                                                                                                ],
                                                                                                                                                            },
                                                                                                                                                        },
                                                                                                                                                        Test::Compiler::Parser::return { 'return',
                                                                                                                                                            body => array_ref { '[]',
                                                                                                                                                                data => branch { ',',
                                                                                                                                                                    left => branch { ',',
                                                                                                                                                                        left => branch { ',',
                                                                                                                                                                            left => leaf '200',
                                                                                                                                                                            right => array_ref { '[]',
                                                                                                                                                                                data => branch { ',',
                                                                                                                                                                                    left => branch { '=>',
                                                                                                                                                                                        left => leaf 'Content-Type',
                                                                                                                                                                                        right => leaf 'text/plain',
                                                                                                                                                                                    },
                                                                                                                                                                                },
                                                                                                                                                                            },
                                                                                                                                                                        },
                                                                                                                                                                        right => array_ref { '[]',
                                                                                                                                                                            data => branch { '->',
                                                                                                                                                                                left => leaf '$env',
                                                                                                                                                                                right => hash_ref { '{}',
                                                                                                                                                                                    data => leaf 'HTTP_FOO',
                                                                                                                                                                                },
                                                                                                                                                                            },
                                                                                                                                                                        },
                                                                                                                                                                    },
                                                                                                                                                                },
                                                                                                                                                            },
                                                                                                                                                        },
                                                                                                                                                    ],
                                                                                                                                                },
                                                                                                                                            },
                                                                                                                                        },
                                                                                                                                    },
                                                                                                                                },
                                                                                                                                right => array_ref { '[]',
                                                                                                                                    data => branch { ',',
                                                                                                                                        left => branch { ',',
                                                                                                                                            left => branch { ',',
                                                                                                                                                left => leaf 'handle HTTP-Cookie',
                                                                                                                                                right => function { 'sub',
                                                                                                                                                    body => [
                                                                                                                                                        branch { '=',
                                                                                                                                                            left => leaf '$cb',
                                                                                                                                                            right => function_call { 'shift',
                                                                                                                                                                args => [
                                                                                                                                                                ],
                                                                                                                                                            },
                                                                                                                                                        },
                                                                                                                                                        branch { '=',
                                                                                                                                                            left => leaf '$res',
                                                                                                                                                            right => branch { '->',
                                                                                                                                                                left => leaf '$cb',
                                                                                                                                                                right => list { '()',
                                                                                                                                                                    data => function_call { 'GET',
                                                                                                                                                                        args => [
                                                                                                                                                                            branch { ',',
                                                                                                                                                                                left => leaf 'http://127.0.0.1/foo/?dankogai=kogaidan',
                                                                                                                                                                                right => branch { '=>',
                                                                                                                                                                                    left => leaf 'Cookie',
                                                                                                                                                                                    right => leaf 'foo',
                                                                                                                                                                                },
                                                                                                                                                                            },
                                                                                                                                                                        ],
                                                                                                                                                                    },
                                                                                                                                                                },
                                                                                                                                                            },
                                                                                                                                                        },
                                                                                                                                                        function_call { 'is',
                                                                                                                                                            args => [
                                                                                                                                                                branch { ',',
                                                                                                                                                                    left => branch { '->',
                                                                                                                                                                        left => leaf '$res',
                                                                                                                                                                        right => function_call { 'code',
                                                                                                                                                                            args => [
                                                                                                                                                                            ],
                                                                                                                                                                        },
                                                                                                                                                                    },
                                                                                                                                                                    right => leaf '200',
                                                                                                                                                                },
                                                                                                                                                            ],
                                                                                                                                                        },
                                                                                                                                                        function_call { 'is',
                                                                                                                                                            args => [
                                                                                                                                                                branch { ',',
                                                                                                                                                                    left => branch { '->',
                                                                                                                                                                        left => leaf '$res',
                                                                                                                                                                        right => function_call { 'message',
                                                                                                                                                                            args => [
                                                                                                                                                                            ],
                                                                                                                                                                        },
                                                                                                                                                                    },
                                                                                                                                                                    right => leaf 'OK',
                                                                                                                                                                },
                                                                                                                                                            ],
                                                                                                                                                        },
                                                                                                                                                        function_call { 'is',
                                                                                                                                                            args => [
                                                                                                                                                                branch { ',',
                                                                                                                                                                    left => branch { '->',
                                                                                                                                                                        left => leaf '$res',
                                                                                                                                                                        right => function_call { 'header',
                                                                                                                                                                            args => [
                                                                                                                                                                                leaf 'content_type',
                                                                                                                                                                            ],
                                                                                                                                                                        },
                                                                                                                                                                    },
                                                                                                                                                                    right => leaf 'text/plain',
                                                                                                                                                                },
                                                                                                                                                            ],
                                                                                                                                                        },
                                                                                                                                                        function_call { 'is',
                                                                                                                                                            args => [
                                                                                                                                                                branch { ',',
                                                                                                                                                                    left => branch { '->',
                                                                                                                                                                        left => leaf '$res',
                                                                                                                                                                        right => function_call { 'content',
                                                                                                                                                                            args => [
                                                                                                                                                                            ],
                                                                                                                                                                        },
                                                                                                                                                                    },
                                                                                                                                                                    right => leaf 'foo',
                                                                                                                                                                },
                                                                                                                                                            ],
                                                                                                                                                        },
                                                                                                                                                    ],
                                                                                                                                                },
                                                                                                                                            },
                                                                                                                                            right => function { 'sub',
                                                                                                                                                body => [
                                                                                                                                                    branch { '=',
                                                                                                                                                        left => leaf '$env',
                                                                                                                                                        right => function_call { 'shift',
                                                                                                                                                            args => [
                                                                                                                                                            ],
                                                                                                                                                        },
                                                                                                                                                    },
                                                                                                                                                    Test::Compiler::Parser::return { 'return',
                                                                                                                                                        body => array_ref { '[]',
                                                                                                                                                            data => branch { ',',
                                                                                                                                                                left => branch { ',',
                                                                                                                                                                    left => branch { ',',
                                                                                                                                                                        left => leaf '200',
                                                                                                                                                                        right => array_ref { '[]',
                                                                                                                                                                            data => branch { ',',
                                                                                                                                                                                left => branch { '=>',
                                                                                                                                                                                    left => leaf 'Content-Type',
                                                                                                                                                                                    right => leaf 'text/plain',
                                                                                                                                                                                },
                                                                                                                                                                            },
                                                                                                                                                                        },
                                                                                                                                                                    },
                                                                                                                                                                    right => array_ref { '[]',
                                                                                                                                                                        data => branch { '->',
                                                                                                                                                                            left => leaf '$env',
                                                                                                                                                                            right => hash_ref { '{}',
                                                                                                                                                                                data => leaf 'HTTP_COOKIE',
                                                                                                                                                                            },
                                                                                                                                                                        },
                                                                                                                                                                    },
                                                                                                                                                                },
                                                                                                                                                            },
                                                                                                                                                        },
                                                                                                                                                    },
                                                                                                                                                ],
                                                                                                                                            },
                                                                                                                                        },
                                                                                                                                    },
                                                                                                                                },
                                                                                                                            },
                                                                                                                            right => array_ref { '[]',
                                                                                                                                data => branch { ',',
                                                                                                                                    left => branch { ',',
                                                                                                                                        left => branch { ',',
                                                                                                                                            left => leaf 'validate env',
                                                                                                                                            right => function { 'sub',
                                                                                                                                                body => [
                                                                                                                                                    branch { '=',
                                                                                                                                                        left => leaf '$cb',
                                                                                                                                                        right => function_call { 'shift',
                                                                                                                                                            args => [
                                                                                                                                                            ],
                                                                                                                                                        },
                                                                                                                                                    },
                                                                                                                                                    branch { '=',
                                                                                                                                                        left => leaf '$res',
                                                                                                                                                        right => branch { '->',
                                                                                                                                                            left => leaf '$cb',
                                                                                                                                                            right => list { '()',
                                                                                                                                                                data => function_call { 'GET',
                                                                                                                                                                    args => [
                                                                                                                                                                        leaf 'http://127.0.0.1/foo/?dankogai=kogaidan',
                                                                                                                                                                    ],
                                                                                                                                                                },
                                                                                                                                                            },
                                                                                                                                                        },
                                                                                                                                                    },
                                                                                                                                                    function_call { 'is',
                                                                                                                                                        args => [
                                                                                                                                                            branch { ',',
                                                                                                                                                                left => branch { '->',
                                                                                                                                                                    left => leaf '$res',
                                                                                                                                                                    right => function_call { 'code',
                                                                                                                                                                        args => [
                                                                                                                                                                        ],
                                                                                                                                                                    },
                                                                                                                                                                },
                                                                                                                                                                right => leaf '200',
                                                                                                                                                            },
                                                                                                                                                        ],
                                                                                                                                                    },
                                                                                                                                                    function_call { 'is',
                                                                                                                                                        args => [
                                                                                                                                                            branch { ',',
                                                                                                                                                                left => branch { '->',
                                                                                                                                                                    left => leaf '$res',
                                                                                                                                                                    right => function_call { 'message',
                                                                                                                                                                        args => [
                                                                                                                                                                        ],
                                                                                                                                                                    },
                                                                                                                                                                },
                                                                                                                                                                right => leaf 'OK',
                                                                                                                                                            },
                                                                                                                                                        ],
                                                                                                                                                    },
                                                                                                                                                    function_call { 'is',
                                                                                                                                                        args => [
                                                                                                                                                            branch { ',',
                                                                                                                                                                left => branch { '->',
                                                                                                                                                                    left => leaf '$res',
                                                                                                                                                                    right => function_call { 'header',
                                                                                                                                                                        args => [
                                                                                                                                                                            leaf 'content_type',
                                                                                                                                                                        ],
                                                                                                                                                                    },
                                                                                                                                                                },
                                                                                                                                                                right => leaf 'text/plain',
                                                                                                                                                            },
                                                                                                                                                        ],
                                                                                                                                                    },
                                                                                                                                                    function_call { 'is',
                                                                                                                                                        args => [
                                                                                                                                                            branch { ',',
                                                                                                                                                                left => branch { '->',
                                                                                                                                                                    left => leaf '$res',
                                                                                                                                                                    right => function_call { 'content',
                                                                                                                                                                        args => [
                                                                                                                                                                        ],
                                                                                                                                                                    },
                                                                                                                                                                },
                                                                                                                                                                right => branch { '.',
                                                                                                                                                                    left => function_call { 'join',
                                                                                                                                                                        args => [
                                                                                                                                                                            list { '()',
                                                                                                                                                                                data => branch { ',',
                                                                                                                                                                                    left => branch { ',',
                                                                                                                                                                                        left => branch { ',',
                                                                                                                                                                                            left => branch { ',',
                                                                                                                                                                                                left => branch { ',',
                                                                                                                                                                                                    left => branch { ',',
                                                                                                                                                                                                        left => branch { ',',
                                                                                                                                                                                                            left => leaf '\n',
                                                                                                                                                                                                            right => leaf 'REQUEST_METHOD:GET',
                                                                                                                                                                                                        },
                                                                                                                                                                                                        right => leaf 'SCRIPT_NAME:$ENV{PLACK_TEST_SCRIPT_NAME}',
                                                                                                                                                                                                    },
                                                                                                                                                                                                    right => leaf 'PATH_INFO:/foo/',
                                                                                                                                                                                                },
                                                                                                                                                                                                right => leaf 'QUERY_STRING:dankogai=kogaidan',
                                                                                                                                                                                            },
                                                                                                                                                                                            right => leaf 'SERVER_NAME:127.0.0.1',
                                                                                                                                                                                        },
                                                                                                                                                                                        right => branch { '.',
                                                                                                                                                                                            left => leaf 'SERVER_PORT:',
                                                                                                                                                                                            right => branch { '->',
                                                                                                                                                                                                left => branch { '->',
                                                                                                                                                                                                    left => branch { '->',
                                                                                                                                                                                                        left => leaf '$res',
                                                                                                                                                                                                        right => function_call { 'request',
                                                                                                                                                                                                            args => [
                                                                                                                                                                                                            ],
                                                                                                                                                                                                        },
                                                                                                                                                                                                    },
                                                                                                                                                                                                    right => function_call { 'uri',
                                                                                                                                                                                                        args => [
                                                                                                                                                                                                        ],
                                                                                                                                                                                                    },
                                                                                                                                                                                                },
                                                                                                                                                                                                right => function_call { 'port',
                                                                                                                                                                                                    args => [
                                                                                                                                                                                                    ],
                                                                                                                                                                                                },
                                                                                                                                                                                            },
                                                                                                                                                                                        },
                                                                                                                                                                                    },
                                                                                                                                                                                },
                                                                                                                                                                            },
                                                                                                                                                                        ],
                                                                                                                                                                    },
                                                                                                                                                                    right => leaf '\n',
                                                                                                                                                                },
                                                                                                                                                            },
                                                                                                                                                        ],
                                                                                                                                                    },
                                                                                                                                                ],
                                                                                                                                            },
                                                                                                                                        },
                                                                                                                                        right => function { 'sub',
                                                                                                                                            body => [
                                                                                                                                                branch { '=',
                                                                                                                                                    left => leaf '$env',
                                                                                                                                                    right => function_call { 'shift',
                                                                                                                                                        args => [
                                                                                                                                                        ],
                                                                                                                                                    },
                                                                                                                                                },
                                                                                                                                                leaf '$body',
                                                                                                                                                foreach_stmt { 'for',
                                                                                                                                                    cond => reg_prefix { 'qw',
                                                                                                                                                        expr => leaf 'REQUEST_METHOD SCRIPT_NAME PATH_INFO QUERY_STRING SERVER_NAME SERVER_PORT',
                                                                                                                                                    },
                                                                                                                                                    true_stmt => branch { '.=',
                                                                                                                                                        left => leaf '$body',
                                                                                                                                                        right => branch { '.',
                                                                                                                                                            left => branch { '.',
                                                                                                                                                                left => branch { '.',
                                                                                                                                                                    left => leaf '$_',
                                                                                                                                                                    right => leaf ':',
                                                                                                                                                                },
                                                                                                                                                                right => branch { '->',
                                                                                                                                                                    left => leaf '$env',
                                                                                                                                                                    right => hash_ref { '{}',
                                                                                                                                                                        data => leaf '$_',
                                                                                                                                                                    },
                                                                                                                                                                },
                                                                                                                                                            },
                                                                                                                                                            right => leaf '\n',
                                                                                                                                                        },
                                                                                                                                                    },
                                                                                                                                                },
                                                                                                                                                Test::Compiler::Parser::return { 'return',
                                                                                                                                                    body => array_ref { '[]',
                                                                                                                                                        data => branch { ',',
                                                                                                                                                            left => branch { ',',
                                                                                                                                                                left => branch { ',',
                                                                                                                                                                    left => leaf '200',
                                                                                                                                                                    right => array_ref { '[]',
                                                                                                                                                                        data => branch { ',',
                                                                                                                                                                            left => branch { '=>',
                                                                                                                                                                                left => leaf 'Content-Type',
                                                                                                                                                                                right => leaf 'text/plain',
                                                                                                                                                                            },
                                                                                                                                                                        },
                                                                                                                                                                    },
                                                                                                                                                                },
                                                                                                                                                                right => array_ref { '[]',
                                                                                                                                                                    data => leaf '$body',
                                                                                                                                                                },
                                                                                                                                                            },
                                                                                                                                                        },
                                                                                                                                                    },
                                                                                                                                                },
                                                                                                                                            ],
                                                                                                                                        },
                                                                                                                                    },
                                                                                                                                },
                                                                                                                            },
                                                                                                                        },
                                                                                                                        right => array_ref { '[]',
                                                                                                                            data => branch { ',',
                                                                                                                                left => branch { ',',
                                                                                                                                    left => branch { ',',
                                                                                                                                        left => leaf '% encoding in PATH_INFO',
                                                                                                                                        right => function { 'sub',
                                                                                                                                            body => [
                                                                                                                                                branch { '=',
                                                                                                                                                    left => leaf '$cb',
                                                                                                                                                    right => function_call { 'shift',
                                                                                                                                                        args => [
                                                                                                                                                        ],
                                                                                                                                                    },
                                                                                                                                                },
                                                                                                                                                branch { '=',
                                                                                                                                                    left => leaf '$res',
                                                                                                                                                    right => branch { '->',
                                                                                                                                                        left => leaf '$cb',
                                                                                                                                                        right => list { '()',
                                                                                                                                                            data => function_call { 'GET',
                                                                                                                                                                args => [
                                                                                                                                                                    leaf 'http://127.0.0.1/foo/bar%2cbaz',
                                                                                                                                                                ],
                                                                                                                                                            },
                                                                                                                                                        },
                                                                                                                                                    },
                                                                                                                                                },
                                                                                                                                                function_call { 'is',
                                                                                                                                                    args => [
                                                                                                                                                        branch { ',',
                                                                                                                                                            left => branch { ',',
                                                                                                                                                                left => branch { '->',
                                                                                                                                                                    left => leaf '$res',
                                                                                                                                                                    right => function_call { 'content',
                                                                                                                                                                        args => [
                                                                                                                                                                        ],
                                                                                                                                                                    },
                                                                                                                                                                },
                                                                                                                                                                right => leaf '/foo/bar,baz',
                                                                                                                                                            },
                                                                                                                                                            right => leaf 'PATH_INFO should be decoded per RFC 3875',
                                                                                                                                                        },
                                                                                                                                                    ],
                                                                                                                                                },
                                                                                                                                            ],
                                                                                                                                        },
                                                                                                                                    },
                                                                                                                                    right => function { 'sub',
                                                                                                                                        body => [
                                                                                                                                            branch { '=',
                                                                                                                                                left => leaf '$env',
                                                                                                                                                right => function_call { 'shift',
                                                                                                                                                    args => [
                                                                                                                                                    ],
                                                                                                                                                },
                                                                                                                                            },
                                                                                                                                            Test::Compiler::Parser::return { 'return',
                                                                                                                                                body => array_ref { '[]',
                                                                                                                                                    data => branch { ',',
                                                                                                                                                        left => branch { ',',
                                                                                                                                                            left => branch { ',',
                                                                                                                                                                left => leaf '200',
                                                                                                                                                                right => array_ref { '[]',
                                                                                                                                                                    data => branch { ',',
                                                                                                                                                                        left => branch { '=>',
                                                                                                                                                                            left => leaf 'Content-Type',
                                                                                                                                                                            right => leaf 'text/plain',
                                                                                                                                                                        },
                                                                                                                                                                    },
                                                                                                                                                                },
                                                                                                                                                            },
                                                                                                                                                            right => array_ref { '[]',
                                                                                                                                                                data => branch { '->',
                                                                                                                                                                    left => leaf '$env',
                                                                                                                                                                    right => hash_ref { '{}',
                                                                                                                                                                        data => leaf 'PATH_INFO',
                                                                                                                                                                    },
                                                                                                                                                                },
                                                                                                                                                            },
                                                                                                                                                        },
                                                                                                                                                    },
                                                                                                                                                },
                                                                                                                                            },
                                                                                                                                        ],
                                                                                                                                    },
                                                                                                                                },
                                                                                                                            },
                                                                                                                        },
                                                                                                                    },
                                                                                                                    right => array_ref { '[]',
                                                                                                                        data => branch { ',',
                                                                                                                            left => branch { ',',
                                                                                                                                left => branch { ',',
                                                                                                                                    left => leaf '% double encoding in PATH_INFO',
                                                                                                                                    right => function { 'sub',
                                                                                                                                        body => [
                                                                                                                                            branch { '=',
                                                                                                                                                left => leaf '$cb',
                                                                                                                                                right => function_call { 'shift',
                                                                                                                                                    args => [
                                                                                                                                                    ],
                                                                                                                                                },
                                                                                                                                            },
                                                                                                                                            branch { '=',
                                                                                                                                                left => leaf '$res',
                                                                                                                                                right => branch { '->',
                                                                                                                                                    left => leaf '$cb',
                                                                                                                                                    right => list { '()',
                                                                                                                                                        data => function_call { 'GET',
                                                                                                                                                            args => [
                                                                                                                                                                leaf 'http://127.0.0.1/foo/bar%252cbaz',
                                                                                                                                                            ],
                                                                                                                                                        },
                                                                                                                                                    },
                                                                                                                                                },
                                                                                                                                            },
                                                                                                                                            function_call { 'is',
                                                                                                                                                args => [
                                                                                                                                                    branch { ',',
                                                                                                                                                        left => branch { ',',
                                                                                                                                                            left => branch { '->',
                                                                                                                                                                left => leaf '$res',
                                                                                                                                                                right => function_call { 'content',
                                                                                                                                                                    args => [
                                                                                                                                                                    ],
                                                                                                                                                                },
                                                                                                                                                            },
                                                                                                                                                            right => leaf '/foo/bar%2cbaz',
                                                                                                                                                        },
                                                                                                                                                        right => leaf 'PATH_INFO should be decoded only once, per RFC 3875',
                                                                                                                                                    },
                                                                                                                                                ],
                                                                                                                                            },
                                                                                                                                        ],
                                                                                                                                    },
                                                                                                                                },
                                                                                                                                right => function { 'sub',
                                                                                                                                    body => [
                                                                                                                                        branch { '=',
                                                                                                                                            left => leaf '$env',
                                                                                                                                            right => function_call { 'shift',
                                                                                                                                                args => [
                                                                                                                                                ],
                                                                                                                                            },
                                                                                                                                        },
                                                                                                                                        Test::Compiler::Parser::return { 'return',
                                                                                                                                            body => array_ref { '[]',
                                                                                                                                                data => branch { ',',
                                                                                                                                                    left => branch { ',',
                                                                                                                                                        left => branch { ',',
                                                                                                                                                            left => leaf '200',
                                                                                                                                                            right => array_ref { '[]',
                                                                                                                                                                data => branch { ',',
                                                                                                                                                                    left => branch { '=>',
                                                                                                                                                                        left => leaf 'Content-Type',
                                                                                                                                                                        right => leaf 'text/plain',
                                                                                                                                                                    },
                                                                                                                                                                },
                                                                                                                                                            },
                                                                                                                                                        },
                                                                                                                                                        right => array_ref { '[]',
                                                                                                                                                            data => branch { '->',
                                                                                                                                                                left => leaf '$env',
                                                                                                                                                                right => hash_ref { '{}',
                                                                                                                                                                    data => leaf 'PATH_INFO',
                                                                                                                                                                },
                                                                                                                                                            },
                                                                                                                                                        },
                                                                                                                                                    },
                                                                                                                                                },
                                                                                                                                            },
                                                                                                                                        },
                                                                                                                                    ],
                                                                                                                                },
                                                                                                                            },
                                                                                                                        },
                                                                                                                    },
                                                                                                                },
                                                                                                                right => array_ref { '[]',
                                                                                                                    data => branch { ',',
                                                                                                                        left => branch { ',',
                                                                                                                            left => branch { ',',
                                                                                                                                left => leaf '% encoding in PATH_INFO (outside of URI characters)',
                                                                                                                                right => function { 'sub',
                                                                                                                                    body => [
                                                                                                                                        branch { '=',
                                                                                                                                            left => leaf '$cb',
                                                                                                                                            right => function_call { 'shift',
                                                                                                                                                args => [
                                                                                                                                                ],
                                                                                                                                            },
                                                                                                                                        },
                                                                                                                                        branch { '=',
                                                                                                                                            left => leaf '$res',
                                                                                                                                            right => branch { '->',
                                                                                                                                                left => leaf '$cb',
                                                                                                                                                right => list { '()',
                                                                                                                                                    data => function_call { 'GET',
                                                                                                                                                        args => [
                                                                                                                                                            leaf 'http://127.0.0.1/foo%E3%81%82',
                                                                                                                                                        ],
                                                                                                                                                    },
                                                                                                                                                },
                                                                                                                                            },
                                                                                                                                        },
                                                                                                                                        function_call { 'is',
                                                                                                                                            args => [
                                                                                                                                                branch { ',',
                                                                                                                                                    left => branch { '->',
                                                                                                                                                        left => leaf '$res',
                                                                                                                                                        right => function_call { 'content',
                                                                                                                                                            args => [
                                                                                                                                                            ],
                                                                                                                                                        },
                                                                                                                                                    },
                                                                                                                                                    right => leaf '/foo\x{e3}\x{81}\x{82}',
                                                                                                                                                },
                                                                                                                                            ],
                                                                                                                                        },
                                                                                                                                    ],
                                                                                                                                },
                                                                                                                            },
                                                                                                                            right => function { 'sub',
                                                                                                                                body => [
                                                                                                                                    branch { '=',
                                                                                                                                        left => leaf '$env',
                                                                                                                                        right => function_call { 'shift',
                                                                                                                                            args => [
                                                                                                                                            ],
                                                                                                                                        },
                                                                                                                                    },
                                                                                                                                    Test::Compiler::Parser::return { 'return',
                                                                                                                                        body => array_ref { '[]',
                                                                                                                                            data => branch { ',',
                                                                                                                                                left => branch { ',',
                                                                                                                                                    left => branch { ',',
                                                                                                                                                        left => leaf '200',
                                                                                                                                                        right => array_ref { '[]',
                                                                                                                                                            data => branch { ',',
                                                                                                                                                                left => branch { '=>',
                                                                                                                                                                    left => leaf 'Content-Type',
                                                                                                                                                                    right => leaf 'text/plain',
                                                                                                                                                                },
                                                                                                                                                            },
                                                                                                                                                        },
                                                                                                                                                    },
                                                                                                                                                    right => array_ref { '[]',
                                                                                                                                                        data => branch { '->',
                                                                                                                                                            left => leaf '$env',
                                                                                                                                                            right => hash_ref { '{}',
                                                                                                                                                                data => leaf 'PATH_INFO',
                                                                                                                                                            },
                                                                                                                                                        },
                                                                                                                                                    },
                                                                                                                                                },
                                                                                                                                            },
                                                                                                                                        },
                                                                                                                                    },
                                                                                                                                ],
                                                                                                                            },
                                                                                                                        },
                                                                                                                    },
                                                                                                                },
                                                                                                            },
                                                                                                            right => array_ref { '[]',
                                                                                                                data => branch { ',',
                                                                                                                    left => branch { ',',
                                                                                                                        left => branch { ',',
                                                                                                                            left => leaf 'SERVER_PROTOCOL is required',
                                                                                                                            right => function { 'sub',
                                                                                                                                body => [
                                                                                                                                    branch { '=',
                                                                                                                                        left => leaf '$cb',
                                                                                                                                        right => function_call { 'shift',
                                                                                                                                            args => [
                                                                                                                                            ],
                                                                                                                                        },
                                                                                                                                    },
                                                                                                                                    branch { '=',
                                                                                                                                        left => leaf '$res',
                                                                                                                                        right => branch { '->',
                                                                                                                                            left => leaf '$cb',
                                                                                                                                            right => list { '()',
                                                                                                                                                data => function_call { 'GET',
                                                                                                                                                    args => [
                                                                                                                                                        leaf 'http://127.0.0.1/foo/?dankogai=kogaidan',
                                                                                                                                                    ],
                                                                                                                                                },
                                                                                                                                            },
                                                                                                                                        },
                                                                                                                                    },
                                                                                                                                    function_call { 'is',
                                                                                                                                        args => [
                                                                                                                                            branch { ',',
                                                                                                                                                left => branch { '->',
                                                                                                                                                    left => leaf '$res',
                                                                                                                                                    right => function_call { 'code',
                                                                                                                                                        args => [
                                                                                                                                                        ],
                                                                                                                                                    },
                                                                                                                                                },
                                                                                                                                                right => leaf '200',
                                                                                                                                            },
                                                                                                                                        ],
                                                                                                                                    },
                                                                                                                                    function_call { 'is',
                                                                                                                                        args => [
                                                                                                                                            branch { ',',
                                                                                                                                                left => branch { '->',
                                                                                                                                                    left => leaf '$res',
                                                                                                                                                    right => function_call { 'message',
                                                                                                                                                        args => [
                                                                                                                                                        ],
                                                                                                                                                    },
                                                                                                                                                },
                                                                                                                                                right => leaf 'OK',
                                                                                                                                            },
                                                                                                                                        ],
                                                                                                                                    },
                                                                                                                                    function_call { 'is',
                                                                                                                                        args => [
                                                                                                                                            branch { ',',
                                                                                                                                                left => branch { '->',
                                                                                                                                                    left => leaf '$res',
                                                                                                                                                    right => function_call { 'header',
                                                                                                                                                        args => [
                                                                                                                                                            leaf 'content_type',
                                                                                                                                                        ],
                                                                                                                                                    },
                                                                                                                                                },
                                                                                                                                                right => leaf 'text/plain',
                                                                                                                                            },
                                                                                                                                        ],
                                                                                                                                    },
                                                                                                                                    function_call { 'like',
                                                                                                                                        args => [
                                                                                                                                            branch { ',',
                                                                                                                                                left => branch { '->',
                                                                                                                                                    left => leaf '$res',
                                                                                                                                                    right => function_call { 'content',
                                                                                                                                                        args => [
                                                                                                                                                        ],
                                                                                                                                                    },
                                                                                                                                                },
                                                                                                                                                right => reg_prefix { 'qr',
                                                                                                                                                    expr => leaf '^HTTP/1\.[01]$',
                                                                                                                                                },
                                                                                                                                            },
                                                                                                                                        ],
                                                                                                                                    },
                                                                                                                                ],
                                                                                                                            },
                                                                                                                        },
                                                                                                                        right => function { 'sub',
                                                                                                                            body => [
                                                                                                                                branch { '=',
                                                                                                                                    left => leaf '$env',
                                                                                                                                    right => function_call { 'shift',
                                                                                                                                        args => [
                                                                                                                                        ],
                                                                                                                                    },
                                                                                                                                },
                                                                                                                                Test::Compiler::Parser::return { 'return',
                                                                                                                                    body => array_ref { '[]',
                                                                                                                                        data => branch { ',',
                                                                                                                                            left => branch { ',',
                                                                                                                                                left => branch { ',',
                                                                                                                                                    left => leaf '200',
                                                                                                                                                    right => array_ref { '[]',
                                                                                                                                                        data => branch { ',',
                                                                                                                                                            left => branch { '=>',
                                                                                                                                                                left => leaf 'Content-Type',
                                                                                                                                                                right => leaf 'text/plain',
                                                                                                                                                            },
                                                                                                                                                        },
                                                                                                                                                    },
                                                                                                                                                },
                                                                                                                                                right => array_ref { '[]',
                                                                                                                                                    data => branch { '->',
                                                                                                                                                        left => leaf '$env',
                                                                                                                                                        right => hash_ref { '{}',
                                                                                                                                                            data => leaf 'SERVER_PROTOCOL',
                                                                                                                                                        },
                                                                                                                                                    },
                                                                                                                                                },
                                                                                                                                            },
                                                                                                                                        },
                                                                                                                                    },
                                                                                                                                },
                                                                                                                            ],
                                                                                                                        },
                                                                                                                    },
                                                                                                                },
                                                                                                            },
                                                                                                        },
                                                                                                        right => array_ref { '[]',
                                                                                                            data => branch { ',',
                                                                                                                left => branch { ',',
                                                                                                                    left => branch { ',',
                                                                                                                        left => leaf 'SCRIPT_NAME should not be undef',
                                                                                                                        right => function { 'sub',
                                                                                                                            body => [
                                                                                                                                branch { '=',
                                                                                                                                    left => leaf '$cb',
                                                                                                                                    right => function_call { 'shift',
                                                                                                                                        args => [
                                                                                                                                        ],
                                                                                                                                    },
                                                                                                                                },
                                                                                                                                branch { '=',
                                                                                                                                    left => leaf '$res',
                                                                                                                                    right => branch { '->',
                                                                                                                                        left => leaf '$cb',
                                                                                                                                        right => list { '()',
                                                                                                                                            data => function_call { 'GET',
                                                                                                                                                args => [
                                                                                                                                                    leaf 'http://127.0.0.1/foo/?dankogai=kogaidan',
                                                                                                                                                ],
                                                                                                                                            },
                                                                                                                                        },
                                                                                                                                    },
                                                                                                                                },
                                                                                                                                function_call { 'is',
                                                                                                                                    args => [
                                                                                                                                        branch { ',',
                                                                                                                                            left => branch { '->',
                                                                                                                                                left => leaf '$res',
                                                                                                                                                right => function_call { 'content',
                                                                                                                                                    args => [
                                                                                                                                                    ],
                                                                                                                                                },
                                                                                                                                            },
                                                                                                                                            right => leaf '1',
                                                                                                                                        },
                                                                                                                                    ],
                                                                                                                                },
                                                                                                                            ],
                                                                                                                        },
                                                                                                                    },
                                                                                                                    right => function { 'sub',
                                                                                                                        body => [
                                                                                                                            branch { '=',
                                                                                                                                left => leaf '$env',
                                                                                                                                right => function_call { 'shift',
                                                                                                                                    args => [
                                                                                                                                    ],
                                                                                                                                },
                                                                                                                            },
                                                                                                                            branch { '=',
                                                                                                                                left => leaf '$cont',
                                                                                                                                right => function_call { 'defined',
                                                                                                                                    args => [
                                                                                                                                        branch { '->',
                                                                                                                                            left => leaf '$env',
                                                                                                                                            right => hash_ref { '{}',
                                                                                                                                                data => leaf 'SCRIPT_NAME',
                                                                                                                                            },
                                                                                                                                        },
                                                                                                                                    ],
                                                                                                                                },
                                                                                                                            },
                                                                                                                            Test::Compiler::Parser::return { 'return',
                                                                                                                                body => array_ref { '[]',
                                                                                                                                    data => branch { ',',
                                                                                                                                        left => branch { ',',
                                                                                                                                            left => branch { ',',
                                                                                                                                                left => leaf '200',
                                                                                                                                                right => array_ref { '[]',
                                                                                                                                                    data => branch { ',',
                                                                                                                                                        left => branch { '=>',
                                                                                                                                                            left => leaf 'Content-Type',
                                                                                                                                                            right => leaf 'text/plain',
                                                                                                                                                        },
                                                                                                                                                    },
                                                                                                                                                },
                                                                                                                                            },
                                                                                                                                            right => array_ref { '[]',
                                                                                                                                                data => leaf '$cont',
                                                                                                                                            },
                                                                                                                                        },
                                                                                                                                    },
                                                                                                                                },
                                                                                                                            },
                                                                                                                        ],
                                                                                                                    },
                                                                                                                },
                                                                                                            },
                                                                                                        },
                                                                                                    },
                                                                                                    right => array_ref { '[]',
                                                                                                        data => branch { ',',
                                                                                                            left => branch { ',',
                                                                                                                left => branch { ',',
                                                                                                                    left => leaf 'call close after read IO::Handle-like',
                                                                                                                    right => function { 'sub',
                                                                                                                        body => [
                                                                                                                            branch { '=',
                                                                                                                                left => leaf '$cb',
                                                                                                                                right => function_call { 'shift',
                                                                                                                                    args => [
                                                                                                                                    ],
                                                                                                                                },
                                                                                                                            },
                                                                                                                            branch { '=',
                                                                                                                                left => leaf '$res',
                                                                                                                                right => branch { '->',
                                                                                                                                    left => leaf '$cb',
                                                                                                                                    right => list { '()',
                                                                                                                                        data => function_call { 'GET',
                                                                                                                                            args => [
                                                                                                                                                leaf 'http://127.0.0.1/call_close',
                                                                                                                                            ],
                                                                                                                                        },
                                                                                                                                    },
                                                                                                                                },
                                                                                                                            },
                                                                                                                            function_call { 'is',
                                                                                                                                args => [
                                                                                                                                    list { '()',
                                                                                                                                        data => branch { ',',
                                                                                                                                            left => branch { '->',
                                                                                                                                                left => leaf '$res',
                                                                                                                                                right => function_call { 'content',
                                                                                                                                                    args => [
                                                                                                                                                    ],
                                                                                                                                                },
                                                                                                                                            },
                                                                                                                                            right => leaf '1234',
                                                                                                                                        },
                                                                                                                                    },
                                                                                                                                ],
                                                                                                                            },
                                                                                                                        ],
                                                                                                                    },
                                                                                                                },
                                                                                                                right => function { 'sub',
                                                                                                                    body => [
                                                                                                                        branch { '=',
                                                                                                                            left => leaf '$env',
                                                                                                                            right => function_call { 'shift',
                                                                                                                                args => [
                                                                                                                                ],
                                                                                                                            },
                                                                                                                        },
                                                                                                                        block { '',
                                                                                                                            body => [
                                                                                                                                branch { '=',
                                                                                                                                    left => leaf '$closed',
                                                                                                                                    right => leaf '-1',
                                                                                                                                },
                                                                                                                                function { 'CalledClose::new',
                                                                                                                                    body => [
                                                                                                                                        branch { '=',
                                                                                                                                            left => leaf '$closed',
                                                                                                                                            right => leaf '0',
                                                                                                                                        },
                                                                                                                                        branch { '=',
                                                                                                                                            left => leaf '$i',
                                                                                                                                            right => leaf '0',
                                                                                                                                        },
                                                                                                                                        function_call { 'bless',
                                                                                                                                            args => [
                                                                                                                                                branch { ',',
                                                                                                                                                    left => single_term_operator { '\\',
                                                                                                                                                        expr => leaf '$i',
                                                                                                                                                    },
                                                                                                                                                    right => leaf 'CalledClose',
                                                                                                                                                },
                                                                                                                                            ],
                                                                                                                                        },
                                                                                                                                    ],
                                                                                                                                },
                                                                                                                                function { 'CalledClose::getline',
                                                                                                                                    body => [
                                                                                                                                        branch { '=',
                                                                                                                                            left => leaf '$self',
                                                                                                                                            right => function_call { 'shift',
                                                                                                                                                args => [
                                                                                                                                                ],
                                                                                                                                            },
                                                                                                                                        },
                                                                                                                                        Test::Compiler::Parser::return { 'return',
                                                                                                                                            body => three_term_operator { '?',
                                                                                                                                                cond => branch { '<',
                                                                                                                                                    left => single_term_operator { '++',
                                                                                                                                                        expr => dereference { '$$self',
                                                                                                                                                            expr => leaf '$$self',
                                                                                                                                                        },
                                                                                                                                                    },
                                                                                                                                                    right => leaf '4',
                                                                                                                                                },
                                                                                                                                                true_expr => dereference { '$$self',
                                                                                                                                                    expr => leaf '$$self',
                                                                                                                                                },
                                                                                                                                                false_expr => leaf 'undef',
                                                                                                                                            },
                                                                                                                                        },
                                                                                                                                    ],
                                                                                                                                },
                                                                                                                                function { 'CalledClose::close',
                                                                                                                                    body => if_stmt { 'if',
                                                                                                                                        expr => function_call { 'defined',
                                                                                                                                            args => [
                                                                                                                                                single_term_operator { '&',
                                                                                                                                                    expr => function_call { 'main::ok',
                                                                                                                                                        args => [
                                                                                                                                                        ],
                                                                                                                                                    },
                                                                                                                                                },
                                                                                                                                            ],
                                                                                                                                        },
                                                                                                                                        true_stmt => function_call { 'main::ok',
                                                                                                                                            args => [
                                                                                                                                                list { '()',
                                                                                                                                                    data => branch { ',',
                                                                                                                                                        left => leaf '1',
                                                                                                                                                        right => leaf 'closed',
                                                                                                                                                    },
                                                                                                                                                },
                                                                                                                                            ],
                                                                                                                                        },
                                                                                                                                    },
                                                                                                                                },
                                                                                                                            ],
                                                                                                                        },
                                                                                                                        Test::Compiler::Parser::return { 'return',
                                                                                                                            body => array_ref { '[]',
                                                                                                                                data => branch { ',',
                                                                                                                                    left => branch { ',',
                                                                                                                                        left => branch { ',',
                                                                                                                                            left => leaf '200',
                                                                                                                                            right => array_ref { '[]',
                                                                                                                                                data => branch { ',',
                                                                                                                                                    left => branch { '=>',
                                                                                                                                                        left => leaf 'Content-Type',
                                                                                                                                                        right => leaf 'text/plain',
                                                                                                                                                    },
                                                                                                                                                },
                                                                                                                                            },
                                                                                                                                        },
                                                                                                                                        right => branch { '->',
                                                                                                                                            left => leaf 'CalledClose',
                                                                                                                                            right => function_call { 'new',
                                                                                                                                                args => [
                                                                                                                                                    list { '()',
                                                                                                                                                    },
                                                                                                                                                ],
                                                                                                                                            },
                                                                                                                                        },
                                                                                                                                    },
                                                                                                                                },
                                                                                                                            },
                                                                                                                        },
                                                                                                                    ],
                                                                                                                },
                                                                                                            },
                                                                                                        },
                                                                                                    },
                                                                                                },
                                                                                                right => array_ref { '[]',
                                                                                                    data => branch { ',',
                                                                                                        left => branch { ',',
                                                                                                            left => branch { ',',
                                                                                                                left => leaf 'has errors',
                                                                                                                right => function { 'sub',
                                                                                                                    body => [
                                                                                                                        branch { '=',
                                                                                                                            left => leaf '$cb',
                                                                                                                            right => function_call { 'shift',
                                                                                                                                args => [
                                                                                                                                ],
                                                                                                                            },
                                                                                                                        },
                                                                                                                        branch { '=',
                                                                                                                            left => leaf '$res',
                                                                                                                            right => branch { '->',
                                                                                                                                left => leaf '$cb',
                                                                                                                                right => list { '()',
                                                                                                                                    data => function_call { 'GET',
                                                                                                                                        args => [
                                                                                                                                            leaf 'http://127.0.0.1/has_errors',
                                                                                                                                        ],
                                                                                                                                    },
                                                                                                                                },
                                                                                                                            },
                                                                                                                        },
                                                                                                                        function_call { 'is',
                                                                                                                            args => [
                                                                                                                                branch { ',',
                                                                                                                                    left => branch { '->',
                                                                                                                                        left => leaf '$res',
                                                                                                                                        right => function_call { 'content',
                                                                                                                                            args => [
                                                                                                                                            ],
                                                                                                                                        },
                                                                                                                                    },
                                                                                                                                    right => leaf '1',
                                                                                                                                },
                                                                                                                            ],
                                                                                                                        },
                                                                                                                    ],
                                                                                                                },
                                                                                                            },
                                                                                                            right => function { 'sub',
                                                                                                                body => [
                                                                                                                    branch { '=',
                                                                                                                        left => leaf '$env',
                                                                                                                        right => function_call { 'shift',
                                                                                                                            args => [
                                                                                                                            ],
                                                                                                                        },
                                                                                                                    },
                                                                                                                    branch { '=',
                                                                                                                        left => leaf '$err',
                                                                                                                        right => branch { '->',
                                                                                                                            left => leaf '$env',
                                                                                                                            right => hash_ref { '{}',
                                                                                                                                data => leaf 'psgi.errors',
                                                                                                                            },
                                                                                                                        },
                                                                                                                    },
                                                                                                                    branch { '=',
                                                                                                                        left => leaf '$has_errors',
                                                                                                                        right => function_call { 'defined',
                                                                                                                            args => [
                                                                                                                                leaf '$err',
                                                                                                                            ],
                                                                                                                        },
                                                                                                                    },
                                                                                                                    Test::Compiler::Parser::return { 'return',
                                                                                                                        body => array_ref { '[]',
                                                                                                                            data => branch { ',',
                                                                                                                                left => branch { ',',
                                                                                                                                    left => leaf '200',
                                                                                                                                    right => array_ref { '[]',
                                                                                                                                        data => branch { ',',
                                                                                                                                            left => branch { '=>',
                                                                                                                                                left => leaf 'Content-Type',
                                                                                                                                                right => leaf 'text/plain',
                                                                                                                                            },
                                                                                                                                        },
                                                                                                                                    },
                                                                                                                                },
                                                                                                                                right => array_ref { '[]',
                                                                                                                                    data => leaf '$has_errors',
                                                                                                                                },
                                                                                                                            },
                                                                                                                        },
                                                                                                                    },
                                                                                                                ],
                                                                                                            },
                                                                                                        },
                                                                                                    },
                                                                                                },
                                                                                            },
                                                                                            right => array_ref { '[]',
                                                                                                data => branch { ',',
                                                                                                    left => branch { ',',
                                                                                                        left => branch { ',',
                                                                                                            left => leaf 'status line',
                                                                                                            right => function { 'sub',
                                                                                                                body => [
                                                                                                                    branch { '=',
                                                                                                                        left => leaf '$cb',
                                                                                                                        right => function_call { 'shift',
                                                                                                                            args => [
                                                                                                                            ],
                                                                                                                        },
                                                                                                                    },
                                                                                                                    branch { '=',
                                                                                                                        left => leaf '$res',
                                                                                                                        right => branch { '->',
                                                                                                                            left => leaf '$cb',
                                                                                                                            right => list { '()',
                                                                                                                                data => function_call { 'GET',
                                                                                                                                    args => [
                                                                                                                                        leaf 'http://127.0.0.1/foo/?dankogai=kogaidan',
                                                                                                                                    ],
                                                                                                                                },
                                                                                                                            },
                                                                                                                        },
                                                                                                                    },
                                                                                                                    function_call { 'is',
                                                                                                                        args => [
                                                                                                                            list { '()',
                                                                                                                                data => branch { ',',
                                                                                                                                    left => branch { '->',
                                                                                                                                        left => leaf '$res',
                                                                                                                                        right => function_call { 'status_line',
                                                                                                                                            args => [
                                                                                                                                            ],
                                                                                                                                        },
                                                                                                                                    },
                                                                                                                                    right => leaf '200 OK',
                                                                                                                                },
                                                                                                                            },
                                                                                                                        ],
                                                                                                                    },
                                                                                                                ],
                                                                                                            },
                                                                                                        },
                                                                                                        right => function { 'sub',
                                                                                                            body => [
                                                                                                                branch { '=',
                                                                                                                    left => leaf '$env',
                                                                                                                    right => function_call { 'shift',
                                                                                                                        args => [
                                                                                                                        ],
                                                                                                                    },
                                                                                                                },
                                                                                                                Test::Compiler::Parser::return { 'return',
                                                                                                                    body => array_ref { '[]',
                                                                                                                        data => branch { ',',
                                                                                                                            left => branch { ',',
                                                                                                                                left => leaf '200',
                                                                                                                                right => array_ref { '[]',
                                                                                                                                    data => branch { ',',
                                                                                                                                        left => branch { '=>',
                                                                                                                                            left => leaf 'Content-Type',
                                                                                                                                            right => leaf 'text/plain',
                                                                                                                                        },
                                                                                                                                    },
                                                                                                                                },
                                                                                                                            },
                                                                                                                            right => array_ref { '[]',
                                                                                                                                data => leaf '1',
                                                                                                                            },
                                                                                                                        },
                                                                                                                    },
                                                                                                                },
                                                                                                            ],
                                                                                                        },
                                                                                                    },
                                                                                                },
                                                                                            },
                                                                                        },
                                                                                        right => array_ref { '[]',
                                                                                            data => branch { ',',
                                                                                                left => branch { ',',
                                                                                                    left => branch { ',',
                                                                                                        left => leaf 'Do not crash when the app dies',
                                                                                                        right => function { 'sub',
                                                                                                            body => [
                                                                                                                branch { '=',
                                                                                                                    left => leaf '$cb',
                                                                                                                    right => function_call { 'shift',
                                                                                                                        args => [
                                                                                                                        ],
                                                                                                                    },
                                                                                                                },
                                                                                                                branch { '=',
                                                                                                                    left => leaf '$res',
                                                                                                                    right => branch { '->',
                                                                                                                        left => leaf '$cb',
                                                                                                                        right => list { '()',
                                                                                                                            data => function_call { 'GET',
                                                                                                                                args => [
                                                                                                                                    leaf 'http://127.0.0.1/',
                                                                                                                                ],
                                                                                                                            },
                                                                                                                        },
                                                                                                                    },
                                                                                                                },
                                                                                                                function_call { 'is',
                                                                                                                    args => [
                                                                                                                        branch { ',',
                                                                                                                            left => branch { '->',
                                                                                                                                left => leaf '$res',
                                                                                                                                right => function_call { 'code',
                                                                                                                                    args => [
                                                                                                                                    ],
                                                                                                                                },
                                                                                                                            },
                                                                                                                            right => leaf '500',
                                                                                                                        },
                                                                                                                    ],
                                                                                                                },
                                                                                                                function_call { 'is',
                                                                                                                    args => [
                                                                                                                        branch { ',',
                                                                                                                            left => branch { '->',
                                                                                                                                left => leaf '$res',
                                                                                                                                right => function_call { 'message',
                                                                                                                                    args => [
                                                                                                                                    ],
                                                                                                                                },
                                                                                                                            },
                                                                                                                            right => leaf 'Internal Server Error',
                                                                                                                        },
                                                                                                                    ],
                                                                                                                },
                                                                                                            ],
                                                                                                        },
                                                                                                    },
                                                                                                    right => function { 'sub',
                                                                                                        body => [
                                                                                                            branch { '=',
                                                                                                                left => leaf '$env',
                                                                                                                right => function_call { 'shift',
                                                                                                                    args => [
                                                                                                                    ],
                                                                                                                },
                                                                                                            },
                                                                                                            function_call { 'open',
                                                                                                                args => [
                                                                                                                    branch { ',',
                                                                                                                        left => branch { ',',
                                                                                                                            left => leaf '$io',
                                                                                                                            right => leaf '>',
                                                                                                                        },
                                                                                                                        right => single_term_operator { '\\',
                                                                                                                            expr => leaf '$error',
                                                                                                                        },
                                                                                                                    },
                                                                                                                ],
                                                                                                            },
                                                                                                            branch { '=',
                                                                                                                left => branch { '->',
                                                                                                                    left => leaf '$env',
                                                                                                                    right => hash_ref { '{}',
                                                                                                                        data => leaf 'psgi.errors',
                                                                                                                    },
                                                                                                                },
                                                                                                                right => leaf '$io',
                                                                                                            },
                                                                                                            function_call { 'die',
                                                                                                                args => [
                                                                                                                    leaf 'Throwing an exception from app handler. Server shouldn\'t crash.',
                                                                                                                ],
                                                                                                            },
                                                                                                        ],
                                                                                                    },
                                                                                                },
                                                                                            },
                                                                                        },
                                                                                    },
                                                                                    right => array_ref { '[]',
                                                                                        data => branch { ',',
                                                                                            left => branch { ',',
                                                                                                left => branch { ',',
                                                                                                    left => leaf 'multi headers (request)',
                                                                                                    right => function { 'sub',
                                                                                                        body => [
                                                                                                            branch { '=',
                                                                                                                left => leaf '$cb',
                                                                                                                right => function_call { 'shift',
                                                                                                                    args => [
                                                                                                                    ],
                                                                                                                },
                                                                                                            },
                                                                                                            branch { '=',
                                                                                                                left => leaf '$req',
                                                                                                                right => branch { '->',
                                                                                                                    left => leaf 'HTTP::Request',
                                                                                                                    right => function_call { 'new',
                                                                                                                        args => [
                                                                                                                            list { '()',
                                                                                                                                data => branch { ',',
                                                                                                                                    left => branch { '=>',
                                                                                                                                        left => leaf 'GET',
                                                                                                                                        right => leaf 'http://127.0.0.1/',
                                                                                                                                    },
                                                                                                                                },
                                                                                                                            },
                                                                                                                        ],
                                                                                                                    },
                                                                                                                },
                                                                                                            },
                                                                                                            branch { '->',
                                                                                                                left => leaf '$req',
                                                                                                                right => function_call { 'push_header',
                                                                                                                    args => [
                                                                                                                        list { '()',
                                                                                                                            data => branch { '=>',
                                                                                                                                left => leaf 'Foo',
                                                                                                                                right => leaf 'bar',
                                                                                                                            },
                                                                                                                        },
                                                                                                                    ],
                                                                                                                },
                                                                                                            },
                                                                                                            branch { '->',
                                                                                                                left => leaf '$req',
                                                                                                                right => function_call { 'push_header',
                                                                                                                    args => [
                                                                                                                        list { '()',
                                                                                                                            data => branch { '=>',
                                                                                                                                left => leaf 'Foo',
                                                                                                                                right => leaf 'baz',
                                                                                                                            },
                                                                                                                        },
                                                                                                                    ],
                                                                                                                },
                                                                                                            },
                                                                                                            branch { '=',
                                                                                                                left => leaf '$res',
                                                                                                                right => branch { '->',
                                                                                                                    left => leaf '$cb',
                                                                                                                    right => list { '()',
                                                                                                                        data => leaf '$req',
                                                                                                                    },
                                                                                                                },
                                                                                                            },
                                                                                                            function_call { 'like',
                                                                                                                args => [
                                                                                                                    list { '()',
                                                                                                                        data => branch { ',',
                                                                                                                            left => branch { '->',
                                                                                                                                left => leaf '$res',
                                                                                                                                right => function_call { 'content',
                                                                                                                                    args => [
                                                                                                                                    ],
                                                                                                                                },
                                                                                                                            },
                                                                                                                            right => reg_prefix { 'qr',
                                                                                                                                expr => leaf '^bar,\s*baz$',
                                                                                                                            },
                                                                                                                        },
                                                                                                                    },
                                                                                                                ],
                                                                                                            },
                                                                                                        ],
                                                                                                    },
                                                                                                },
                                                                                                right => function { 'sub',
                                                                                                    body => [
                                                                                                        branch { '=',
                                                                                                            left => leaf '$env',
                                                                                                            right => function_call { 'shift',
                                                                                                                args => [
                                                                                                                ],
                                                                                                            },
                                                                                                        },
                                                                                                        Test::Compiler::Parser::return { 'return',
                                                                                                            body => array_ref { '[]',
                                                                                                                data => branch { ',',
                                                                                                                    left => branch { ',',
                                                                                                                        left => leaf '200',
                                                                                                                        right => array_ref { '[]',
                                                                                                                            data => branch { ',',
                                                                                                                                left => branch { '=>',
                                                                                                                                    left => leaf 'Content-Type',
                                                                                                                                    right => leaf 'text/plain',
                                                                                                                                },
                                                                                                                            },
                                                                                                                        },
                                                                                                                    },
                                                                                                                    right => array_ref { '[]',
                                                                                                                        data => branch { '->',
                                                                                                                            left => leaf '$env',
                                                                                                                            right => hash_ref { '{}',
                                                                                                                                data => leaf 'HTTP_FOO',
                                                                                                                            },
                                                                                                                        },
                                                                                                                    },
                                                                                                                },
                                                                                                            },
                                                                                                        },
                                                                                                    ],
                                                                                                },
                                                                                            },
                                                                                        },
                                                                                    },
                                                                                },
                                                                                right => array_ref { '[]',
                                                                                    data => branch { ',',
                                                                                        left => branch { ',',
                                                                                            left => branch { ',',
                                                                                                left => leaf 'multi headers (response)',
                                                                                                right => function { 'sub',
                                                                                                    body => [
                                                                                                        branch { '=',
                                                                                                            left => leaf '$cb',
                                                                                                            right => function_call { 'shift',
                                                                                                                args => [
                                                                                                                ],
                                                                                                            },
                                                                                                        },
                                                                                                        branch { '=',
                                                                                                            left => leaf '$res',
                                                                                                            right => branch { '->',
                                                                                                                left => leaf '$cb',
                                                                                                                right => list { '()',
                                                                                                                    data => branch { '->',
                                                                                                                        left => leaf 'HTTP::Request',
                                                                                                                        right => function_call { 'new',
                                                                                                                            args => [
                                                                                                                                list { '()',
                                                                                                                                    data => branch { '=>',
                                                                                                                                        left => leaf 'GET',
                                                                                                                                        right => leaf 'http://127.0.0.1/',
                                                                                                                                    },
                                                                                                                                },
                                                                                                                            ],
                                                                                                                        },
                                                                                                                    },
                                                                                                                },
                                                                                                            },
                                                                                                        },
                                                                                                        branch { '=',
                                                                                                            left => leaf '$foo',
                                                                                                            right => branch { '->',
                                                                                                                left => leaf '$res',
                                                                                                                right => function_call { 'header',
                                                                                                                    args => [
                                                                                                                        leaf 'X-Foo',
                                                                                                                    ],
                                                                                                                },
                                                                                                            },
                                                                                                        },
                                                                                                        function_call { 'like',
                                                                                                            args => [
                                                                                                                branch { ',',
                                                                                                                    left => leaf '$foo',
                                                                                                                    right => reg_prefix { 'qr',
                                                                                                                        expr => leaf 'foo,\s*bar,\s*baz',
                                                                                                                    },
                                                                                                                },
                                                                                                            ],
                                                                                                        },
                                                                                                    ],
                                                                                                },
                                                                                            },
                                                                                            right => function { 'sub',
                                                                                                body => [
                                                                                                    branch { '=',
                                                                                                        left => leaf '$env',
                                                                                                        right => function_call { 'shift',
                                                                                                            args => [
                                                                                                            ],
                                                                                                        },
                                                                                                    },
                                                                                                    Test::Compiler::Parser::return { 'return',
                                                                                                        body => array_ref { '[]',
                                                                                                            data => branch { ',',
                                                                                                                left => branch { ',',
                                                                                                                    left => leaf '200',
                                                                                                                    right => array_ref { '[]',
                                                                                                                        data => branch { ',',
                                                                                                                            left => branch { ',',
                                                                                                                                left => branch { ',',
                                                                                                                                    left => branch { ',',
                                                                                                                                        left => branch { '=>',
                                                                                                                                            left => leaf 'Content-Type',
                                                                                                                                            right => leaf 'text/plain',
                                                                                                                                        },
                                                                                                                                        right => leaf 'X-Foo',
                                                                                                                                    },
                                                                                                                                    right => leaf 'foo',
                                                                                                                                },
                                                                                                                                right => leaf 'X-Foo',
                                                                                                                            },
                                                                                                                            right => leaf 'bar, baz',
                                                                                                                        },
                                                                                                                    },
                                                                                                                },
                                                                                                                right => array_ref { '[]',
                                                                                                                    data => leaf 'hi',
                                                                                                                },
                                                                                                            },
                                                                                                        },
                                                                                                    },
                                                                                                ],
                                                                                            },
                                                                                        },
                                                                                    },
                                                                                },
                                                                            },
                                                                            right => array_ref { '[]',
                                                                                data => branch { ',',
                                                                                    left => branch { ',',
                                                                                        left => branch { ',',
                                                                                            left => leaf 'Do not set $env->{COOKIE}',
                                                                                            right => function { 'sub',
                                                                                                body => [
                                                                                                    branch { '=',
                                                                                                        left => leaf '$cb',
                                                                                                        right => function_call { 'shift',
                                                                                                            args => [
                                                                                                            ],
                                                                                                        },
                                                                                                    },
                                                                                                    branch { '=',
                                                                                                        left => leaf '$req',
                                                                                                        right => branch { '->',
                                                                                                            left => leaf 'HTTP::Request',
                                                                                                            right => function_call { 'new',
                                                                                                                args => [
                                                                                                                    list { '()',
                                                                                                                        data => branch { ',',
                                                                                                                            left => branch { '=>',
                                                                                                                                left => leaf 'GET',
                                                                                                                                right => leaf 'http://127.0.0.1/',
                                                                                                                            },
                                                                                                                        },
                                                                                                                    },
                                                                                                                ],
                                                                                                            },
                                                                                                        },
                                                                                                    },
                                                                                                    branch { '->',
                                                                                                        left => leaf '$req',
                                                                                                        right => function_call { 'push_header',
                                                                                                            args => [
                                                                                                                list { '()',
                                                                                                                    data => branch { '=>',
                                                                                                                        left => leaf 'Cookie',
                                                                                                                        right => leaf 'foo=bar',
                                                                                                                    },
                                                                                                                },
                                                                                                            ],
                                                                                                        },
                                                                                                    },
                                                                                                    branch { '=',
                                                                                                        left => leaf '$res',
                                                                                                        right => branch { '->',
                                                                                                            left => leaf '$cb',
                                                                                                            right => list { '()',
                                                                                                                data => leaf '$req',
                                                                                                            },
                                                                                                        },
                                                                                                    },
                                                                                                    function_call { 'is',
                                                                                                        args => [
                                                                                                            list { '()',
                                                                                                                data => branch { ',',
                                                                                                                    left => branch { '->',
                                                                                                                        left => leaf '$res',
                                                                                                                        right => function_call { 'header',
                                                                                                                            args => [
                                                                                                                                leaf 'X-Cookie',
                                                                                                                            ],
                                                                                                                        },
                                                                                                                    },
                                                                                                                    right => leaf '0',
                                                                                                                },
                                                                                                            },
                                                                                                        ],
                                                                                                    },
                                                                                                    function_call { 'is',
                                                                                                        args => [
                                                                                                            branch { ',',
                                                                                                                left => branch { '->',
                                                                                                                    left => leaf '$res',
                                                                                                                    right => function_call { 'content',
                                                                                                                        args => [
                                                                                                                        ],
                                                                                                                    },
                                                                                                                },
                                                                                                                right => leaf 'foo=bar',
                                                                                                            },
                                                                                                        ],
                                                                                                    },
                                                                                                ],
                                                                                            },
                                                                                        },
                                                                                        right => function { 'sub',
                                                                                            body => [
                                                                                                branch { '=',
                                                                                                    left => leaf '$env',
                                                                                                    right => function_call { 'shift',
                                                                                                        args => [
                                                                                                        ],
                                                                                                    },
                                                                                                },
                                                                                                Test::Compiler::Parser::return { 'return',
                                                                                                    body => array_ref { '[]',
                                                                                                        data => branch { ',',
                                                                                                            left => branch { ',',
                                                                                                                left => leaf '200',
                                                                                                                right => array_ref { '[]',
                                                                                                                    data => branch { ',',
                                                                                                                        left => branch { '=>',
                                                                                                                            left => leaf 'Content-Type',
                                                                                                                            right => leaf 'text/plain',
                                                                                                                        },
                                                                                                                        right => branch { '=>',
                                                                                                                            left => leaf 'X-Cookie',
                                                                                                                            right => three_term_operator { '?',
                                                                                                                                cond => branch { '->',
                                                                                                                                    left => leaf '$env',
                                                                                                                                    right => hash_ref { '{}',
                                                                                                                                        data => leaf 'COOKIE',
                                                                                                                                    },
                                                                                                                                },
                                                                                                                                true_expr => leaf '1',
                                                                                                                                false_expr => leaf '0',
                                                                                                                            },
                                                                                                                        },
                                                                                                                    },
                                                                                                                },
                                                                                                            },
                                                                                                            right => array_ref { '[]',
                                                                                                                data => branch { '->',
                                                                                                                    left => leaf '$env',
                                                                                                                    right => hash_ref { '{}',
                                                                                                                        data => leaf 'HTTP_COOKIE',
                                                                                                                    },
                                                                                                                },
                                                                                                            },
                                                                                                        },
                                                                                                    },
                                                                                                },
                                                                                            ],
                                                                                        },
                                                                                    },
                                                                                },
                                                                            },
                                                                        },
                                                                        right => array_ref { '[]',
                                                                            data => branch { ',',
                                                                                left => branch { ',',
                                                                                    left => branch { ',',
                                                                                        left => leaf 'no entity headers on 304',
                                                                                        right => function { 'sub',
                                                                                            body => [
                                                                                                branch { '=',
                                                                                                    left => leaf '$cb',
                                                                                                    right => function_call { 'shift',
                                                                                                        args => [
                                                                                                        ],
                                                                                                    },
                                                                                                },
                                                                                                branch { '=',
                                                                                                    left => leaf '$res',
                                                                                                    right => branch { '->',
                                                                                                        left => leaf '$cb',
                                                                                                        right => list { '()',
                                                                                                            data => function_call { 'GET',
                                                                                                                args => [
                                                                                                                    leaf 'http://127.0.0.1/',
                                                                                                                ],
                                                                                                            },
                                                                                                        },
                                                                                                    },
                                                                                                },
                                                                                                function_call { 'is',
                                                                                                    args => [
                                                                                                        branch { ',',
                                                                                                            left => branch { '->',
                                                                                                                left => leaf '$res',
                                                                                                                right => function_call { 'code',
                                                                                                                    args => [
                                                                                                                    ],
                                                                                                                },
                                                                                                            },
                                                                                                            right => leaf '304',
                                                                                                        },
                                                                                                    ],
                                                                                                },
                                                                                                function_call { 'is',
                                                                                                    args => [
                                                                                                        branch { ',',
                                                                                                            left => branch { '->',
                                                                                                                left => leaf '$res',
                                                                                                                right => function_call { 'message',
                                                                                                                    args => [
                                                                                                                    ],
                                                                                                                },
                                                                                                            },
                                                                                                            right => leaf 'Not Modified',
                                                                                                        },
                                                                                                    ],
                                                                                                },
                                                                                                function_call { 'is',
                                                                                                    args => [
                                                                                                        branch { ',',
                                                                                                            left => branch { '->',
                                                                                                                left => leaf '$res',
                                                                                                                right => function_call { 'content',
                                                                                                                    args => [
                                                                                                                    ],
                                                                                                                },
                                                                                                            },
                                                                                                            right => leaf '',
                                                                                                        },
                                                                                                    ],
                                                                                                },
                                                                                                function_call { 'ok',
                                                                                                    args => [
                                                                                                        branch { ',',
                                                                                                            left => single_term_operator { '!',
                                                                                                                expr => function_call { 'defined',
                                                                                                                    args => [
                                                                                                                        branch { '->',
                                                                                                                            left => leaf '$res',
                                                                                                                            right => function_call { 'header',
                                                                                                                                args => [
                                                                                                                                    leaf 'content_type',
                                                                                                                                ],
                                                                                                                            },
                                                                                                                        },
                                                                                                                    ],
                                                                                                                },
                                                                                                            },
                                                                                                            right => leaf 'No Content-Type',
                                                                                                        },
                                                                                                    ],
                                                                                                },
                                                                                                function_call { 'ok',
                                                                                                    args => [
                                                                                                        branch { ',',
                                                                                                            left => single_term_operator { '!',
                                                                                                                expr => function_call { 'defined',
                                                                                                                    args => [
                                                                                                                        branch { '->',
                                                                                                                            left => leaf '$res',
                                                                                                                            right => function_call { 'header',
                                                                                                                                args => [
                                                                                                                                    leaf 'content_length',
                                                                                                                                ],
                                                                                                                            },
                                                                                                                        },
                                                                                                                    ],
                                                                                                                },
                                                                                                            },
                                                                                                            right => leaf 'No Content-Length',
                                                                                                        },
                                                                                                    ],
                                                                                                },
                                                                                                function_call { 'ok',
                                                                                                    args => [
                                                                                                        branch { ',',
                                                                                                            left => single_term_operator { '!',
                                                                                                                expr => function_call { 'defined',
                                                                                                                    args => [
                                                                                                                        branch { '->',
                                                                                                                            left => leaf '$res',
                                                                                                                            right => function_call { 'header',
                                                                                                                                args => [
                                                                                                                                    leaf 'transfer_encoding',
                                                                                                                                ],
                                                                                                                            },
                                                                                                                        },
                                                                                                                    ],
                                                                                                                },
                                                                                                            },
                                                                                                            right => leaf 'No Transfer-Encoding',
                                                                                                        },
                                                                                                    ],
                                                                                                },
                                                                                            ],
                                                                                        },
                                                                                    },
                                                                                    right => function { 'sub',
                                                                                        body => [
                                                                                            branch { '=',
                                                                                                left => leaf '$env',
                                                                                                right => function_call { 'shift',
                                                                                                    args => [
                                                                                                    ],
                                                                                                },
                                                                                            },
                                                                                            Test::Compiler::Parser::return { 'return',
                                                                                                body => array_ref { '[]',
                                                                                                    data => branch { ',',
                                                                                                        left => branch { ',',
                                                                                                            left => leaf '304',
                                                                                                            right => array_ref { '[]',
                                                                                                            },
                                                                                                        },
                                                                                                        right => array_ref { '[]',
                                                                                                        },
                                                                                                    },
                                                                                                },
                                                                                            },
                                                                                        ],
                                                                                    },
                                                                                },
                                                                            },
                                                                        },
                                                                    },
                                                                    right => array_ref { '[]',
                                                                        data => branch { ',',
                                                                            left => branch { ',',
                                                                                left => branch { ',',
                                                                                    left => leaf 'REQUEST_URI is set',
                                                                                    right => function { 'sub',
                                                                                        body => [
                                                                                            branch { '=',
                                                                                                left => leaf '$cb',
                                                                                                right => function_call { 'shift',
                                                                                                    args => [
                                                                                                    ],
                                                                                                },
                                                                                            },
                                                                                            branch { '=',
                                                                                                left => leaf '$res',
                                                                                                right => branch { '->',
                                                                                                    left => leaf '$cb',
                                                                                                    right => list { '()',
                                                                                                        data => function_call { 'GET',
                                                                                                            args => [
                                                                                                                leaf 'http://127.0.0.1/foo/bar%20baz%73?x=a',
                                                                                                            ],
                                                                                                        },
                                                                                                    },
                                                                                                },
                                                                                            },
                                                                                            function_call { 'is',
                                                                                                args => [
                                                                                                    branch { ',',
                                                                                                        left => branch { '->',
                                                                                                            left => leaf '$res',
                                                                                                            right => function_call { 'content',
                                                                                                                args => [
                                                                                                                ],
                                                                                                            },
                                                                                                        },
                                                                                                        right => branch { '.',
                                                                                                            left => hash { '$ENV',
                                                                                                                key => hash_ref { '{}',
                                                                                                                    data => leaf 'PLACK_TEST_SCRIPT_NAME',
                                                                                                                },
                                                                                                            },
                                                                                                            right => leaf '/foo/bar%20baz%73?x=a',
                                                                                                        },
                                                                                                    },
                                                                                                ],
                                                                                            },
                                                                                        ],
                                                                                    },
                                                                                },
                                                                                right => function { 'sub',
                                                                                    body => [
                                                                                        branch { '=',
                                                                                            left => leaf '$env',
                                                                                            right => function_call { 'shift',
                                                                                                args => [
                                                                                                ],
                                                                                            },
                                                                                        },
                                                                                        Test::Compiler::Parser::return { 'return',
                                                                                            body => array_ref { '[]',
                                                                                                data => branch { ',',
                                                                                                    left => branch { ',',
                                                                                                        left => leaf '200',
                                                                                                        right => array_ref { '[]',
                                                                                                            data => branch { '=>',
                                                                                                                left => leaf 'Content-Type',
                                                                                                                right => leaf 'text/plain',
                                                                                                            },
                                                                                                        },
                                                                                                    },
                                                                                                    right => array_ref { '[]',
                                                                                                        data => branch { '->',
                                                                                                            left => leaf '$env',
                                                                                                            right => hash_ref { '{}',
                                                                                                                data => leaf 'REQUEST_URI',
                                                                                                            },
                                                                                                        },
                                                                                                    },
                                                                                                },
                                                                                            },
                                                                                        },
                                                                                    ],
                                                                                },
                                                                            },
                                                                        },
                                                                    },
                                                                },
                                                                right => array_ref { '[]',
                                                                    data => branch { ',',
                                                                        left => branch { ',',
                                                                            left => branch { ',',
                                                                                left => leaf 'filehandle with path()',
                                                                                right => function { 'sub',
                                                                                    body => [
                                                                                        branch { '=',
                                                                                            left => leaf '$cb',
                                                                                            right => function_call { 'shift',
                                                                                                args => [
                                                                                                ],
                                                                                            },
                                                                                        },
                                                                                        branch { '=',
                                                                                            left => leaf '$res',
                                                                                            right => branch { '->',
                                                                                                left => leaf '$cb',
                                                                                                right => list { '()',
                                                                                                    data => function_call { 'GET',
                                                                                                        args => [
                                                                                                            leaf 'http://127.0.0.1/foo.jpg',
                                                                                                        ],
                                                                                                    },
                                                                                                },
                                                                                            },
                                                                                        },
                                                                                        function_call { 'is',
                                                                                            args => [
                                                                                                branch { ',',
                                                                                                    left => branch { '->',
                                                                                                        left => leaf '$res',
                                                                                                        right => function_call { 'code',
                                                                                                            args => [
                                                                                                            ],
                                                                                                        },
                                                                                                    },
                                                                                                    right => leaf '200',
                                                                                                },
                                                                                            ],
                                                                                        },
                                                                                        function_call { 'is',
                                                                                            args => [
                                                                                                branch { ',',
                                                                                                    left => branch { '->',
                                                                                                        left => leaf '$res',
                                                                                                        right => function_call { 'message',
                                                                                                            args => [
                                                                                                            ],
                                                                                                        },
                                                                                                    },
                                                                                                    right => leaf 'OK',
                                                                                                },
                                                                                            ],
                                                                                        },
                                                                                        function_call { 'is',
                                                                                            args => [
                                                                                                branch { ',',
                                                                                                    left => branch { '->',
                                                                                                        left => leaf '$res',
                                                                                                        right => function_call { 'header',
                                                                                                            args => [
                                                                                                                leaf 'content_type',
                                                                                                            ],
                                                                                                        },
                                                                                                    },
                                                                                                    right => leaf 'image/jpeg',
                                                                                                },
                                                                                            ],
                                                                                        },
                                                                                        function_call { 'is',
                                                                                            args => [
                                                                                                branch { ',',
                                                                                                    left => function_call { 'length',
                                                                                                        args => [
                                                                                                            branch { '->',
                                                                                                                left => leaf '$res',
                                                                                                                right => function_call { 'content',
                                                                                                                    args => [
                                                                                                                    ],
                                                                                                                },
                                                                                                            },
                                                                                                        ],
                                                                                                    },
                                                                                                    right => leaf '4745',
                                                                                                },
                                                                                            ],
                                                                                        },
                                                                                    ],
                                                                                },
                                                                            },
                                                                            right => function { 'sub',
                                                                                body => [
                                                                                    branch { '=',
                                                                                        left => leaf '$env',
                                                                                        right => function_call { 'shift',
                                                                                            args => [
                                                                                            ],
                                                                                        },
                                                                                    },
                                                                                    function_call { 'open',
                                                                                        args => [
                                                                                            branch { ',',
                                                                                                left => branch { ',',
                                                                                                    left => leaf '$fh',
                                                                                                    right => leaf '<',
                                                                                                },
                                                                                                right => leaf '$share_dir/face.jpg',
                                                                                            },
                                                                                        ],
                                                                                    },
                                                                                    function_call { 'Plack::Util::set_io_path',
                                                                                        args => [
                                                                                            list { '()',
                                                                                                data => branch { ',',
                                                                                                    left => leaf '$fh',
                                                                                                    right => leaf '$share_dir/face.jpg',
                                                                                                },
                                                                                            },
                                                                                        ],
                                                                                    },
                                                                                    Test::Compiler::Parser::return { 'return',
                                                                                        body => array_ref { '[]',
                                                                                            data => branch { ',',
                                                                                                left => branch { ',',
                                                                                                    left => leaf '200',
                                                                                                    right => array_ref { '[]',
                                                                                                        data => branch { ',',
                                                                                                            left => branch { '=>',
                                                                                                                left => leaf 'Content-Type',
                                                                                                                right => leaf 'image/jpeg',
                                                                                                            },
                                                                                                            right => branch { '=>',
                                                                                                                left => leaf 'Content-Length',
                                                                                                                right => handle { '-s',
                                                                                                                    expr => leaf '$fh',
                                                                                                                },
                                                                                                            },
                                                                                                        },
                                                                                                    },
                                                                                                },
                                                                                                right => leaf '$fh',
                                                                                            },
                                                                                        },
                                                                                    },
                                                                                ],
                                                                            },
                                                                        },
                                                                    },
                                                                },
                                                            },
                                                            right => array_ref { '[]',
                                                                data => branch { ',',
                                                                    left => branch { ',',
                                                                        left => branch { ',',
                                                                            left => leaf 'a big header value > 128 bytes',
                                                                            right => function { 'sub',
                                                                                body => [
                                                                                    branch { '=',
                                                                                        left => leaf '$cb',
                                                                                        right => function_call { 'shift',
                                                                                            args => [
                                                                                            ],
                                                                                        },
                                                                                    },
                                                                                    branch { '=',
                                                                                        left => leaf '$req',
                                                                                        right => leaf 'GET',
                                                                                    },
                                                                                    branch { '=',
                                                                                        left => leaf '$v',
                                                                                        right => branch { 'x',
                                                                                            left => leaf 'abcdefgh',
                                                                                            right => leaf '16',
                                                                                        },
                                                                                    },
                                                                                    branch { '->',
                                                                                        left => leaf '$req',
                                                                                        right => function_call { 'header',
                                                                                            args => [
                                                                                                list { '()',
                                                                                                    data => branch { '=>',
                                                                                                        left => leaf 'X-Foo',
                                                                                                        right => leaf '$v',
                                                                                                    },
                                                                                                },
                                                                                            ],
                                                                                        },
                                                                                    },
                                                                                    branch { '=',
                                                                                        left => leaf '$res',
                                                                                        right => branch { '->',
                                                                                            left => leaf '$cb',
                                                                                            right => list { '()',
                                                                                                data => leaf '$req',
                                                                                            },
                                                                                        },
                                                                                    },
                                                                                    function_call { 'is',
                                                                                        args => [
                                                                                            branch { ',',
                                                                                                left => branch { '->',
                                                                                                    left => leaf '$res',
                                                                                                    right => function_call { 'code',
                                                                                                        args => [
                                                                                                        ],
                                                                                                    },
                                                                                                },
                                                                                                right => leaf '200',
                                                                                            },
                                                                                        ],
                                                                                    },
                                                                                    function_call { 'is',
                                                                                        args => [
                                                                                            branch { ',',
                                                                                                left => branch { '->',
                                                                                                    left => leaf '$res',
                                                                                                    right => function_call { 'message',
                                                                                                        args => [
                                                                                                        ],
                                                                                                    },
                                                                                                },
                                                                                                right => leaf 'OK',
                                                                                            },
                                                                                        ],
                                                                                    },
                                                                                    function_call { 'is',
                                                                                        args => [
                                                                                            branch { ',',
                                                                                                left => branch { '->',
                                                                                                    left => leaf '$res',
                                                                                                    right => function_call { 'content',
                                                                                                        args => [
                                                                                                        ],
                                                                                                    },
                                                                                                },
                                                                                                right => leaf '$v',
                                                                                            },
                                                                                        ],
                                                                                    },
                                                                                ],
                                                                            },
                                                                        },
                                                                        right => function { 'sub',
                                                                            body => [
                                                                                branch { '=',
                                                                                    left => leaf '$env',
                                                                                    right => function_call { 'shift',
                                                                                        args => [
                                                                                        ],
                                                                                    },
                                                                                },
                                                                                Test::Compiler::Parser::return { 'return',
                                                                                    body => array_ref { '[]',
                                                                                        data => branch { ',',
                                                                                            left => branch { ',',
                                                                                                left => branch { ',',
                                                                                                    left => leaf '200',
                                                                                                    right => array_ref { '[]',
                                                                                                        data => branch { '=>',
                                                                                                            left => leaf 'Content-Type',
                                                                                                            right => leaf 'text/plain',
                                                                                                        },
                                                                                                    },
                                                                                                },
                                                                                                right => array_ref { '[]',
                                                                                                    data => branch { '->',
                                                                                                        left => leaf '$env',
                                                                                                        right => hash_ref { '{}',
                                                                                                            data => leaf 'HTTP_X_FOO',
                                                                                                        },
                                                                                                    },
                                                                                                },
                                                                                            },
                                                                                        },
                                                                                    },
                                                                                },
                                                                            ],
                                                                        },
                                                                    },
                                                                },
                                                            },
                                                        },
                                                        right => array_ref { '[]',
                                                            data => branch { ',',
                                                                left => branch { ',',
                                                                    left => branch { ',',
                                                                        left => leaf 'coderef res',
                                                                        right => function { 'sub',
                                                                            body => [
                                                                                branch { '=',
                                                                                    left => leaf '$cb',
                                                                                    right => function_call { 'shift',
                                                                                        args => [
                                                                                        ],
                                                                                    },
                                                                                },
                                                                                branch { '=',
                                                                                    left => leaf '$res',
                                                                                    right => branch { '->',
                                                                                        left => leaf '$cb',
                                                                                        right => list { '()',
                                                                                            data => function_call { 'GET',
                                                                                                args => [
                                                                                                    leaf 'http://127.0.0.1/?name=miyagawa',
                                                                                                ],
                                                                                            },
                                                                                        },
                                                                                    },
                                                                                },
                                                                                if_stmt { 'if',
                                                                                    expr => branch { '==',
                                                                                        left => branch { '->',
                                                                                            left => leaf '$res',
                                                                                            right => function_call { 'code',
                                                                                                args => [
                                                                                                ],
                                                                                            },
                                                                                        },
                                                                                        right => leaf '501',
                                                                                    },
                                                                                    true_stmt => Test::Compiler::Parser::return { 'return',
                                                                                    },
                                                                                },
                                                                                function_call { 'is',
                                                                                    args => [
                                                                                        branch { ',',
                                                                                            left => branch { '->',
                                                                                                left => leaf '$res',
                                                                                                right => function_call { 'code',
                                                                                                    args => [
                                                                                                    ],
                                                                                                },
                                                                                            },
                                                                                            right => leaf '200',
                                                                                        },
                                                                                    ],
                                                                                },
                                                                                function_call { 'is',
                                                                                    args => [
                                                                                        branch { ',',
                                                                                            left => branch { '->',
                                                                                                left => leaf '$res',
                                                                                                right => function_call { 'message',
                                                                                                    args => [
                                                                                                    ],
                                                                                                },
                                                                                            },
                                                                                            right => leaf 'OK',
                                                                                        },
                                                                                    ],
                                                                                },
                                                                                function_call { 'is',
                                                                                    args => [
                                                                                        branch { ',',
                                                                                            left => branch { '->',
                                                                                                left => leaf '$res',
                                                                                                right => function_call { 'header',
                                                                                                    args => [
                                                                                                        leaf 'content_type',
                                                                                                    ],
                                                                                                },
                                                                                            },
                                                                                            right => leaf 'text/plain',
                                                                                        },
                                                                                    ],
                                                                                },
                                                                                function_call { 'is',
                                                                                    args => [
                                                                                        branch { ',',
                                                                                            left => branch { '->',
                                                                                                left => leaf '$res',
                                                                                                right => function_call { 'content',
                                                                                                    args => [
                                                                                                    ],
                                                                                                },
                                                                                            },
                                                                                            right => leaf 'Hello, name=miyagawa',
                                                                                        },
                                                                                    ],
                                                                                },
                                                                            ],
                                                                        },
                                                                    },
                                                                    right => function { 'sub',
                                                                        body => [
                                                                            branch { '=',
                                                                                left => leaf '$env',
                                                                                right => function_call { 'shift',
                                                                                    args => [
                                                                                    ],
                                                                                },
                                                                            },
                                                                            branch { 'or',
                                                                                left => branch { '->',
                                                                                    left => leaf '$env',
                                                                                    right => hash_ref { '{}',
                                                                                        data => leaf 'psgi.streaming',
                                                                                    },
                                                                                },
                                                                                right => Test::Compiler::Parser::return { 'return',
                                                                                    body => array_ref { '[]',
                                                                                        data => branch { ',',
                                                                                            left => branch { ',',
                                                                                                left => leaf '501',
                                                                                                right => array_ref { '[]',
                                                                                                    data => branch { ',',
                                                                                                        left => leaf 'Content-Type',
                                                                                                        right => leaf 'text/plain',
                                                                                                    },
                                                                                                },
                                                                                            },
                                                                                            right => array_ref { '[]',
                                                                                            },
                                                                                        },
                                                                                    },
                                                                                },
                                                                            },
                                                                            Test::Compiler::Parser::return { 'return',
                                                                                body => function { 'sub',
                                                                                    body => [
                                                                                        branch { '=',
                                                                                            left => leaf '$respond',
                                                                                            right => function_call { 'shift',
                                                                                                args => [
                                                                                                ],
                                                                                            },
                                                                                        },
                                                                                        branch { '->',
                                                                                            left => leaf '$respond',
                                                                                            right => list { '()',
                                                                                                data => array_ref { '[]',
                                                                                                    data => branch { ',',
                                                                                                        left => branch { ',',
                                                                                                            left => branch { ',',
                                                                                                                left => leaf '200',
                                                                                                                right => array_ref { '[]',
                                                                                                                    data => branch { ',',
                                                                                                                        left => branch { '=>',
                                                                                                                            left => leaf 'Content-Type',
                                                                                                                            right => leaf 'text/plain',
                                                                                                                        },
                                                                                                                    },
                                                                                                                },
                                                                                                            },
                                                                                                            right => array_ref { '[]',
                                                                                                                data => branch { '.',
                                                                                                                    left => leaf 'Hello, ',
                                                                                                                    right => branch { '->',
                                                                                                                        left => leaf '$env',
                                                                                                                        right => hash_ref { '{}',
                                                                                                                            data => leaf 'QUERY_STRING',
                                                                                                                        },
                                                                                                                    },
                                                                                                                },
                                                                                                            },
                                                                                                        },
                                                                                                    },
                                                                                                },
                                                                                            },
                                                                                        },
                                                                                    ],
                                                                                },
                                                                            },
                                                                        ],
                                                                    },
                                                                },
                                                            },
                                                        },
                                                    },
                                                    right => array_ref { '[]',
                                                        data => branch { ',',
                                                            left => branch { ',',
                                                                left => branch { ',',
                                                                    left => leaf 'coderef streaming',
                                                                    right => function { 'sub',
                                                                        body => [
                                                                            branch { '=',
                                                                                left => leaf '$cb',
                                                                                right => function_call { 'shift',
                                                                                    args => [
                                                                                    ],
                                                                                },
                                                                            },
                                                                            branch { '=',
                                                                                left => leaf '$res',
                                                                                right => branch { '->',
                                                                                    left => leaf '$cb',
                                                                                    right => list { '()',
                                                                                        data => function_call { 'GET',
                                                                                            args => [
                                                                                                leaf 'http://127.0.0.1/?name=miyagawa',
                                                                                            ],
                                                                                        },
                                                                                    },
                                                                                },
                                                                            },
                                                                            if_stmt { 'if',
                                                                                expr => branch { '==',
                                                                                    left => branch { '->',
                                                                                        left => leaf '$res',
                                                                                        right => function_call { 'code',
                                                                                            args => [
                                                                                            ],
                                                                                        },
                                                                                    },
                                                                                    right => leaf '501',
                                                                                },
                                                                                true_stmt => Test::Compiler::Parser::return { 'return',
                                                                                },
                                                                            },
                                                                            function_call { 'is',
                                                                                args => [
                                                                                    branch { ',',
                                                                                        left => branch { '->',
                                                                                            left => leaf '$res',
                                                                                            right => function_call { 'code',
                                                                                                args => [
                                                                                                ],
                                                                                            },
                                                                                        },
                                                                                        right => leaf '200',
                                                                                    },
                                                                                ],
                                                                            },
                                                                            function_call { 'is',
                                                                                args => [
                                                                                    branch { ',',
                                                                                        left => branch { '->',
                                                                                            left => leaf '$res',
                                                                                            right => function_call { 'message',
                                                                                                args => [
                                                                                                ],
                                                                                            },
                                                                                        },
                                                                                        right => leaf 'OK',
                                                                                    },
                                                                                ],
                                                                            },
                                                                            function_call { 'is',
                                                                                args => [
                                                                                    branch { ',',
                                                                                        left => branch { '->',
                                                                                            left => leaf '$res',
                                                                                            right => function_call { 'header',
                                                                                                args => [
                                                                                                    leaf 'content_type',
                                                                                                ],
                                                                                            },
                                                                                        },
                                                                                        right => leaf 'text/plain',
                                                                                    },
                                                                                ],
                                                                            },
                                                                            function_call { 'is',
                                                                                args => [
                                                                                    branch { ',',
                                                                                        left => branch { '->',
                                                                                            left => leaf '$res',
                                                                                            right => function_call { 'content',
                                                                                                args => [
                                                                                                ],
                                                                                            },
                                                                                        },
                                                                                        right => leaf 'Hello, name=miyagawa',
                                                                                    },
                                                                                ],
                                                                            },
                                                                        ],
                                                                    },
                                                                },
                                                                right => function { 'sub',
                                                                    body => [
                                                                        branch { '=',
                                                                            left => leaf '$env',
                                                                            right => function_call { 'shift',
                                                                                args => [
                                                                                ],
                                                                            },
                                                                        },
                                                                        branch { 'or',
                                                                            left => branch { '->',
                                                                                left => leaf '$env',
                                                                                right => hash_ref { '{}',
                                                                                    data => leaf 'psgi.streaming',
                                                                                },
                                                                            },
                                                                            right => Test::Compiler::Parser::return { 'return',
                                                                                body => array_ref { '[]',
                                                                                    data => branch { ',',
                                                                                        left => branch { ',',
                                                                                            left => leaf '501',
                                                                                            right => array_ref { '[]',
                                                                                                data => branch { ',',
                                                                                                    left => leaf 'Content-Type',
                                                                                                    right => leaf 'text/plain',
                                                                                                },
                                                                                            },
                                                                                        },
                                                                                        right => array_ref { '[]',
                                                                                        },
                                                                                    },
                                                                                },
                                                                            },
                                                                        },
                                                                        Test::Compiler::Parser::return { 'return',
                                                                            body => function { 'sub',
                                                                                body => [
                                                                                    branch { '=',
                                                                                        left => leaf '$respond',
                                                                                        right => function_call { 'shift',
                                                                                            args => [
                                                                                            ],
                                                                                        },
                                                                                    },
                                                                                    branch { '=',
                                                                                        left => leaf '$writer',
                                                                                        right => branch { '->',
                                                                                            left => leaf '$respond',
                                                                                            right => list { '()',
                                                                                                data => array_ref { '[]',
                                                                                                    data => branch { ',',
                                                                                                        left => branch { ',',
                                                                                                            left => leaf '200',
                                                                                                            right => array_ref { '[]',
                                                                                                                data => branch { ',',
                                                                                                                    left => branch { '=>',
                                                                                                                        left => leaf 'Content-Type',
                                                                                                                        right => leaf 'text/plain',
                                                                                                                    },
                                                                                                                },
                                                                                                            },
                                                                                                        },
                                                                                                    },
                                                                                                },
                                                                                            },
                                                                                        },
                                                                                    },
                                                                                    branch { '->',
                                                                                        left => leaf '$writer',
                                                                                        right => function_call { 'write',
                                                                                            args => [
                                                                                                leaf 'Hello, ',
                                                                                            ],
                                                                                        },
                                                                                    },
                                                                                    branch { '->',
                                                                                        left => leaf '$writer',
                                                                                        right => function_call { 'write',
                                                                                            args => [
                                                                                                branch { '->',
                                                                                                    left => leaf '$env',
                                                                                                    right => hash_ref { '{}',
                                                                                                        data => leaf 'QUERY_STRING',
                                                                                                    },
                                                                                                },
                                                                                            ],
                                                                                        },
                                                                                    },
                                                                                    branch { '->',
                                                                                        left => leaf '$writer',
                                                                                        right => function_call { 'close',
                                                                                            args => [
                                                                                                list { '()',
                                                                                                },
                                                                                            ],
                                                                                        },
                                                                                    },
                                                                                ],
                                                                            },
                                                                        },
                                                                    ],
                                                                },
                                                            },
                                                        },
                                                    },
                                                },
                                                right => array_ref { '[]',
                                                    data => branch { ',',
                                                        left => branch { ',',
                                                            left => branch { ',',
                                                                left => leaf 'CRLF output and FCGI parse bug',
                                                                right => function { 'sub',
                                                                    body => [
                                                                        branch { '=',
                                                                            left => leaf '$cb',
                                                                            right => function_call { 'shift',
                                                                                args => [
                                                                                ],
                                                                            },
                                                                        },
                                                                        branch { '=',
                                                                            left => leaf '$res',
                                                                            right => branch { '->',
                                                                                left => leaf '$cb',
                                                                                right => list { '()',
                                                                                    data => function_call { 'GET',
                                                                                        args => [
                                                                                            leaf 'http://127.0.0.1/',
                                                                                        ],
                                                                                    },
                                                                                },
                                                                            },
                                                                        },
                                                                        function_call { 'is',
                                                                            args => [
                                                                                branch { ',',
                                                                                    left => branch { '->',
                                                                                        left => leaf '$res',
                                                                                        right => function_call { 'header',
                                                                                            args => [
                                                                                                leaf 'Foo',
                                                                                            ],
                                                                                        },
                                                                                    },
                                                                                    right => leaf 'undef',
                                                                                },
                                                                            ],
                                                                        },
                                                                        function_call { 'is',
                                                                            args => [
                                                                                branch { ',',
                                                                                    left => branch { '->',
                                                                                        left => leaf '$res',
                                                                                        right => function_call { 'content',
                                                                                            args => [
                                                                                            ],
                                                                                        },
                                                                                    },
                                                                                    right => leaf 'Foo: Bar\r\n\r\nHello World',
                                                                                },
                                                                            ],
                                                                        },
                                                                    ],
                                                                },
                                                            },
                                                            right => function { 'sub',
                                                                body => Test::Compiler::Parser::return { 'return',
                                                                    body => array_ref { '[]',
                                                                        data => branch { ',',
                                                                            left => branch { ',',
                                                                                left => leaf '200',
                                                                                right => array_ref { '[]',
                                                                                    data => branch { ',',
                                                                                        left => leaf 'Content-Type',
                                                                                        right => leaf 'text/plain',
                                                                                    },
                                                                                },
                                                                            },
                                                                            right => array_ref { '[]',
                                                                                data => leaf 'Foo: Bar\r\n\r\nHello World',
                                                                            },
                                                                        },
                                                                    },
                                                                },
                                                            },
                                                        },
                                                    },
                                                },
                                            },
                                            right => array_ref { '[]',
                                                data => branch { ',',
                                                    left => branch { ',',
                                                        left => branch { ',',
                                                            left => leaf 'newlines',
                                                            right => function { 'sub',
                                                                body => [
                                                                    branch { '=',
                                                                        left => leaf '$cb',
                                                                        right => function_call { 'shift',
                                                                            args => [
                                                                            ],
                                                                        },
                                                                    },
                                                                    branch { '=',
                                                                        left => leaf '$res',
                                                                        right => branch { '->',
                                                                            left => leaf '$cb',
                                                                            right => list { '()',
                                                                                data => function_call { 'GET',
                                                                                    args => [
                                                                                        leaf 'http://127.0.0.1/',
                                                                                    ],
                                                                                },
                                                                            },
                                                                        },
                                                                    },
                                                                    function_call { 'is',
                                                                        args => [
                                                                            branch { ',',
                                                                                left => function_call { 'length',
                                                                                    args => [
                                                                                        branch { '->',
                                                                                            left => leaf '$res',
                                                                                            right => function_call { 'content',
                                                                                                args => [
                                                                                                ],
                                                                                            },
                                                                                        },
                                                                                    ],
                                                                                },
                                                                                right => leaf '7',
                                                                            },
                                                                        ],
                                                                    },
                                                                ],
                                                            },
                                                        },
                                                        right => function { 'sub',
                                                            body => Test::Compiler::Parser::return { 'return',
                                                                body => array_ref { '[]',
                                                                    data => branch { ',',
                                                                        left => branch { ',',
                                                                            left => leaf '200',
                                                                            right => array_ref { '[]',
                                                                                data => branch { ',',
                                                                                    left => leaf 'Content-Type',
                                                                                    right => leaf 'text/plain',
                                                                                },
                                                                            },
                                                                        },
                                                                        right => array_ref { '[]',
                                                                            data => leaf 'Bar\nBaz',
                                                                        },
                                                                    },
                                                                },
                                                            },
                                                        },
                                                    },
                                                },
                                            },
                                        },
                                        right => array_ref { '[]',
                                            data => branch { ',',
                                                left => branch { ',',
                                                    left => branch { ',',
                                                        left => leaf 'test 404',
                                                        right => function { 'sub',
                                                            body => [
                                                                branch { '=',
                                                                    left => leaf '$cb',
                                                                    right => function_call { 'shift',
                                                                        args => [
                                                                        ],
                                                                    },
                                                                },
                                                                branch { '=',
                                                                    left => leaf '$res',
                                                                    right => branch { '->',
                                                                        left => leaf '$cb',
                                                                        right => list { '()',
                                                                            data => function_call { 'GET',
                                                                                args => [
                                                                                    leaf 'http://127.0.0.1/',
                                                                                ],
                                                                            },
                                                                        },
                                                                    },
                                                                },
                                                                function_call { 'is',
                                                                    args => [
                                                                        branch { ',',
                                                                            left => branch { '->',
                                                                                left => leaf '$res',
                                                                                right => function_call { 'code',
                                                                                    args => [
                                                                                    ],
                                                                                },
                                                                            },
                                                                            right => leaf '404',
                                                                        },
                                                                    ],
                                                                },
                                                                function_call { 'is',
                                                                    args => [
                                                                        branch { ',',
                                                                            left => branch { '->',
                                                                                left => leaf '$res',
                                                                                right => function_call { 'message',
                                                                                    args => [
                                                                                    ],
                                                                                },
                                                                            },
                                                                            right => leaf 'Not Found',
                                                                        },
                                                                    ],
                                                                },
                                                                function_call { 'is',
                                                                    args => [
                                                                        branch { ',',
                                                                            left => branch { '->',
                                                                                left => leaf '$res',
                                                                                right => function_call { 'content',
                                                                                    args => [
                                                                                    ],
                                                                                },
                                                                            },
                                                                            right => leaf 'Not Found',
                                                                        },
                                                                    ],
                                                                },
                                                            ],
                                                        },
                                                    },
                                                    right => function { 'sub',
                                                        body => Test::Compiler::Parser::return { 'return',
                                                            body => array_ref { '[]',
                                                                data => branch { ',',
                                                                    left => branch { ',',
                                                                        left => leaf '404',
                                                                        right => array_ref { '[]',
                                                                            data => branch { ',',
                                                                                left => leaf 'Content-Type',
                                                                                right => leaf 'text/plain',
                                                                            },
                                                                        },
                                                                    },
                                                                    right => array_ref { '[]',
                                                                        data => leaf 'Not Found',
                                                                    },
                                                                },
                                                            },
                                                        },
                                                    },
                                                },
                                            },
                                        },
                                    },
                                    right => array_ref { '[]',
                                        data => branch { ',',
                                            left => branch { ',',
                                                left => branch { ',',
                                                    left => leaf 'request->input seekable',
                                                    right => function { 'sub',
                                                        body => [
                                                            branch { '=',
                                                                left => leaf '$cb',
                                                                right => function_call { 'shift',
                                                                    args => [
                                                                    ],
                                                                },
                                                            },
                                                            branch { '=',
                                                                left => leaf '$req',
                                                                right => branch { '->',
                                                                    left => leaf 'HTTP::Request',
                                                                    right => function_call { 'new',
                                                                        args => [
                                                                            list { '()',
                                                                                data => branch { '=>',
                                                                                    left => leaf 'POST',
                                                                                    right => leaf 'http://127.0.0.1/',
                                                                                },
                                                                            },
                                                                        ],
                                                                    },
                                                                },
                                                            },
                                                            branch { '->',
                                                                left => leaf '$req',
                                                                right => function_call { 'content',
                                                                    args => [
                                                                        leaf 'body',
                                                                    ],
                                                                },
                                                            },
                                                            branch { '->',
                                                                left => leaf '$req',
                                                                right => function_call { 'content_type',
                                                                    args => [
                                                                        leaf 'text/plain',
                                                                    ],
                                                                },
                                                            },
                                                            branch { '->',
                                                                left => leaf '$req',
                                                                right => function_call { 'content_length',
                                                                    args => [
                                                                        leaf '4',
                                                                    ],
                                                                },
                                                            },
                                                            branch { '=',
                                                                left => leaf '$res',
                                                                right => branch { '->',
                                                                    left => leaf '$cb',
                                                                    right => list { '()',
                                                                        data => leaf '$req',
                                                                    },
                                                                },
                                                            },
                                                            function_call { 'is',
                                                                args => [
                                                                    branch { ',',
                                                                        left => branch { '->',
                                                                            left => leaf '$res',
                                                                            right => function_call { 'content',
                                                                                args => [
                                                                                ],
                                                                            },
                                                                        },
                                                                        right => leaf 'body',
                                                                    },
                                                                ],
                                                            },
                                                        ],
                                                    },
                                                },
                                                right => function { 'sub',
                                                    body => [
                                                        branch { '=',
                                                            left => leaf '$req',
                                                            right => branch { '->',
                                                                left => leaf 'Plack::Request',
                                                                right => function_call { 'new',
                                                                    args => [
                                                                        function_call { 'shift',
                                                                            args => [
                                                                            ],
                                                                        },
                                                                    ],
                                                                },
                                                            },
                                                        },
                                                        Test::Compiler::Parser::return { 'return',
                                                            body => array_ref { '[]',
                                                                data => branch { ',',
                                                                    left => branch { ',',
                                                                        left => leaf '200',
                                                                        right => array_ref { '[]',
                                                                            data => branch { ',',
                                                                                left => leaf 'Content-Type',
                                                                                right => leaf 'text/plain',
                                                                            },
                                                                        },
                                                                    },
                                                                    right => array_ref { '[]',
                                                                        data => branch { '->',
                                                                            left => leaf '$req',
                                                                            right => function_call { 'content',
                                                                                args => [
                                                                                ],
                                                                            },
                                                                        },
                                                                    },
                                                                },
                                                            },
                                                        },
                                                    ],
                                                },
                                            },
                                        },
                                    },
                                },
                                right => array_ref { '[]',
                                    data => branch { ',',
                                        left => branch { ',',
                                            left => branch { ',',
                                                left => leaf 'request->content on GET',
                                                right => function { 'sub',
                                                    body => [
                                                        branch { '=',
                                                            left => leaf '$cb',
                                                            right => function_call { 'shift',
                                                                args => [
                                                                ],
                                                            },
                                                        },
                                                        branch { '=',
                                                            left => leaf '$res',
                                                            right => branch { '->',
                                                                left => leaf '$cb',
                                                                right => list { '()',
                                                                    data => function_call { 'GET',
                                                                        args => [
                                                                            leaf 'http://127.0.0.1/',
                                                                        ],
                                                                    },
                                                                },
                                                            },
                                                        },
                                                        function_call { 'ok',
                                                            args => [
                                                                branch { '->',
                                                                    left => leaf '$res',
                                                                    right => function_call { 'is_success',
                                                                        args => [
                                                                        ],
                                                                    },
                                                                },
                                                            ],
                                                        },
                                                    ],
                                                },
                                            },
                                            right => function { 'sub',
                                                body => [
                                                    branch { '=',
                                                        left => leaf '$req',
                                                        right => branch { '->',
                                                            left => leaf 'Plack::Request',
                                                            right => function_call { 'new',
                                                                args => [
                                                                    function_call { 'shift',
                                                                        args => [
                                                                        ],
                                                                    },
                                                                ],
                                                            },
                                                        },
                                                    },
                                                    branch { '->',
                                                        left => leaf '$req',
                                                        right => function_call { 'content',
                                                            args => [
                                                            ],
                                                        },
                                                    },
                                                    Test::Compiler::Parser::return { 'return',
                                                        body => array_ref { '[]',
                                                            data => branch { ',',
                                                                left => branch { ',',
                                                                    left => leaf '200',
                                                                    right => array_ref { '[]',
                                                                        data => branch { ',',
                                                                            left => leaf 'Content-Type',
                                                                            right => leaf 'text/plain',
                                                                        },
                                                                    },
                                                                },
                                                                right => array_ref { '[]',
                                                                    data => leaf 'OK',
                                                                },
                                                            },
                                                        },
                                                    },
                                                ],
                                            },
                                        },
                                    },
                                },
                            },
                            right => array_ref { '[]',
                                data => branch { ',',
                                    left => branch { ',',
                                        left => branch { ',',
                                            left => leaf 'handle Authorization header',
                                            right => function { 'sub',
                                                body => [
                                                    branch { '=',
                                                        left => leaf '$cb',
                                                        right => function_call { 'shift',
                                                            args => [
                                                            ],
                                                        },
                                                    },
                                                    block { '',
                                                        body => [
                                                            if_stmt { 'if',
                                                                expr => branch { 'eq',
                                                                    left => branch { '||',
                                                                        left => hash { '$ENV',
                                                                            key => hash_ref { '{}',
                                                                                data => leaf 'PLACK_TEST_HANDLER',
                                                                            },
                                                                        },
                                                                        right => leaf '',
                                                                    },
                                                                    right => leaf 'CGI',
                                                                },
                                                                true_stmt => function_call { 'skip',
                                                                    args => [
                                                                        branch { ',',
                                                                            left => leaf 'Authorization header is unsupported under CGI',
                                                                            right => leaf '4',
                                                                        },
                                                                    ],
                                                                },
                                                            },
                                                            block { '',
                                                                body => [
                                                                    branch { '=',
                                                                        left => leaf '$req',
                                                                        right => branch { '->',
                                                                            left => leaf 'HTTP::Request',
                                                                            right => function_call { 'new',
                                                                                args => [
                                                                                    list { '()',
                                                                                        data => branch { ',',
                                                                                            left => branch { '=>',
                                                                                                left => leaf 'GET',
                                                                                                right => leaf 'http://127.0.0.1/',
                                                                                            },
                                                                                        },
                                                                                    },
                                                                                ],
                                                                            },
                                                                        },
                                                                    },
                                                                    branch { '->',
                                                                        left => leaf '$req',
                                                                        right => function_call { 'push_header',
                                                                            args => [
                                                                                list { '()',
                                                                                    data => branch { '=>',
                                                                                        left => leaf 'Authorization',
                                                                                        right => leaf 'Basic XXXX',
                                                                                    },
                                                                                },
                                                                            ],
                                                                        },
                                                                    },
                                                                    branch { '=',
                                                                        left => leaf '$res',
                                                                        right => branch { '->',
                                                                            left => leaf '$cb',
                                                                            right => list { '()',
                                                                                data => leaf '$req',
                                                                            },
                                                                        },
                                                                    },
                                                                    function_call { 'is',
                                                                        args => [
                                                                            branch { ',',
                                                                                left => branch { '->',
                                                                                    left => leaf '$res',
                                                                                    right => function_call { 'header',
                                                                                        args => [
                                                                                            leaf 'X-AUTHORIZATION',
                                                                                        ],
                                                                                    },
                                                                                },
                                                                                right => leaf '1',
                                                                            },
                                                                        ],
                                                                    },
                                                                    function_call { 'is',
                                                                        args => [
                                                                            branch { ',',
                                                                                left => branch { '->',
                                                                                    left => leaf '$res',
                                                                                    right => function_call { 'content',
                                                                                        args => [
                                                                                        ],
                                                                                    },
                                                                                },
                                                                                right => leaf 'Basic XXXX',
                                                                            },
                                                                        ],
                                                                    },
                                                                ],
                                                            },
                                                            block { '',
                                                                body => [
                                                                    branch { '=',
                                                                        left => leaf '$req',
                                                                        right => branch { '->',
                                                                            left => leaf 'HTTP::Request',
                                                                            right => function_call { 'new',
                                                                                args => [
                                                                                    list { '()',
                                                                                        data => branch { ',',
                                                                                            left => branch { '=>',
                                                                                                left => leaf 'GET',
                                                                                                right => leaf 'http://127.0.0.1/',
                                                                                            },
                                                                                        },
                                                                                    },
                                                                                ],
                                                                            },
                                                                        },
                                                                    },
                                                                    branch { '=',
                                                                        left => leaf '$res',
                                                                        right => branch { '->',
                                                                            left => leaf '$cb',
                                                                            right => list { '()',
                                                                                data => leaf '$req',
                                                                            },
                                                                        },
                                                                    },
                                                                    function_call { 'is',
                                                                        args => [
                                                                            branch { ',',
                                                                                left => branch { '->',
                                                                                    left => leaf '$res',
                                                                                    right => function_call { 'header',
                                                                                        args => [
                                                                                            leaf 'X-AUTHORIZATION',
                                                                                        ],
                                                                                    },
                                                                                },
                                                                                right => leaf '0',
                                                                            },
                                                                        ],
                                                                    },
                                                                    function_call { 'is',
                                                                        args => [
                                                                            branch { ',',
                                                                                left => branch { '->',
                                                                                    left => leaf '$res',
                                                                                    right => function_call { 'content',
                                                                                        args => [
                                                                                        ],
                                                                                    },
                                                                                },
                                                                                right => leaf '',
                                                                            },
                                                                        ],
                                                                    },
                                                                ],
                                                            },
                                                        ],
                                                    },
                                                ],
                                            },
                                        },
                                        right => function { 'sub',
                                            body => [
                                                branch { '=',
                                                    left => leaf '$env',
                                                    right => function_call { 'shift',
                                                        args => [
                                                        ],
                                                    },
                                                },
                                                Test::Compiler::Parser::return { 'return',
                                                    body => array_ref { '[]',
                                                        data => branch { ',',
                                                            left => branch { ',',
                                                                left => branch { ',',
                                                                    left => leaf '200',
                                                                    right => array_ref { '[]',
                                                                        data => branch { ',',
                                                                            left => branch { '=>',
                                                                                left => leaf 'Content-Type',
                                                                                right => leaf 'text/plain',
                                                                            },
                                                                            right => branch { '=>',
                                                                                left => leaf 'X-AUTHORIZATION',
                                                                                right => three_term_operator { '?',
                                                                                    cond => function_call { 'exists',
                                                                                        args => [
                                                                                            branch { '->',
                                                                                                left => leaf '$env',
                                                                                                right => hash_ref { '{}',
                                                                                                    data => leaf 'HTTP_AUTHORIZATION',
                                                                                                },
                                                                                            },
                                                                                        ],
                                                                                    },
                                                                                    true_expr => leaf '1',
                                                                                    false_expr => leaf '0',
                                                                                },
                                                                            },
                                                                        },
                                                                    },
                                                                },
                                                                right => array_ref { '[]',
                                                                    data => branch { '||',
                                                                        left => branch { '->',
                                                                            left => leaf '$env',
                                                                            right => hash_ref { '{}',
                                                                                data => leaf 'HTTP_AUTHORIZATION',
                                                                            },
                                                                        },
                                                                        right => leaf '',
                                                                    },
                                                                },
                                                            },
                                                        },
                                                    },
                                                },
                                            ],
                                        },
                                    },
                                },
                            },
                        },
                        right => array_ref { '[]',
                            data => branch { ',',
                                left => branch { ',',
                                    left => branch { ',',
                                        left => leaf 'repeated slashes',
                                        right => function { 'sub',
                                            body => [
                                                branch { '=',
                                                    left => leaf '$cb',
                                                    right => function_call { 'shift',
                                                        args => [
                                                        ],
                                                    },
                                                },
                                                branch { '=',
                                                    left => leaf '$res',
                                                    right => branch { '->',
                                                        left => leaf '$cb',
                                                        right => list { '()',
                                                            data => function_call { 'GET',
                                                                args => [
                                                                    leaf 'http://127.0.0.1//foo///bar/baz',
                                                                ],
                                                            },
                                                        },
                                                    },
                                                },
                                                function_call { 'is',
                                                    args => [
                                                        branch { ',',
                                                            left => branch { '->',
                                                                left => leaf '$res',
                                                                right => function_call { 'code',
                                                                    args => [
                                                                    ],
                                                                },
                                                            },
                                                            right => leaf '200',
                                                        },
                                                    ],
                                                },
                                                function_call { 'is',
                                                    args => [
                                                        branch { ',',
                                                            left => branch { '->',
                                                                left => leaf '$res',
                                                                right => function_call { 'message',
                                                                    args => [
                                                                    ],
                                                                },
                                                            },
                                                            right => leaf 'OK',
                                                        },
                                                    ],
                                                },
                                                function_call { 'is',
                                                    args => [
                                                        branch { ',',
                                                            left => branch { '->',
                                                                left => leaf '$res',
                                                                right => function_call { 'header',
                                                                    args => [
                                                                        leaf 'content_type',
                                                                    ],
                                                                },
                                                            },
                                                            right => leaf 'text/plain',
                                                        },
                                                    ],
                                                },
                                                function_call { 'is',
                                                    args => [
                                                        branch { ',',
                                                            left => branch { '->',
                                                                left => leaf '$res',
                                                                right => function_call { 'content',
                                                                    args => [
                                                                    ],
                                                                },
                                                            },
                                                            right => leaf '//foo///bar/baz',
                                                        },
                                                    ],
                                                },
                                            ],
                                        },
                                    },
                                    right => function { 'sub',
                                        body => [
                                            branch { '=',
                                                left => leaf '$env',
                                                right => function_call { 'shift',
                                                    args => [
                                                    ],
                                                },
                                            },
                                            Test::Compiler::Parser::return { 'return',
                                                body => array_ref { '[]',
                                                    data => branch { ',',
                                                        left => branch { ',',
                                                            left => branch { ',',
                                                                left => leaf '200',
                                                                right => array_ref { '[]',
                                                                    data => branch { ',',
                                                                        left => branch { '=>',
                                                                            left => leaf 'Content-Type',
                                                                            right => leaf 'text/plain',
                                                                        },
                                                                    },
                                                                },
                                                            },
                                                            right => array_ref { '[]',
                                                                data => branch { '->',
                                                                    left => leaf '$env',
                                                                    right => hash_ref { '{}',
                                                                        data => leaf 'PATH_INFO',
                                                                    },
                                                                },
                                                            },
                                                        },
                                                    },
                                                },
                                            },
                                        ],
                                    },
                                },
                            },
                        },
                    },
                },
            },
        },
        function { 'runtests',
            body => [
                branch { '=',
                    left => list { '()',
                        data => branch { ',',
                            left => leaf '$class',
                            right => leaf '$runner',
                        },
                    },
                    right => leaf '@_',
                },
                foreach_stmt { 'for',
                    cond => leaf '@TEST',
                    true_stmt => branch { '->',
                        left => leaf '$runner',
                        right => list { '()',
                            data => dereference { '@$test',
                                expr => leaf '@$test',
                            },
                        },
                    },
                    itr => leaf '$test',
                },
            ],
        },
        function { 'run_server_tests',
            body => [
                branch { '=',
                    left => list { '()',
                        data => branch { ',',
                            left => branch { ',',
                                left => branch { ',',
                                    left => branch { ',',
                                        left => leaf '$class',
                                        right => leaf '$server',
                                    },
                                    right => leaf '$server_port',
                                },
                                right => leaf '$http_port',
                            },
                            right => leaf '%args',
                        },
                    },
                    right => leaf '@_',
                },
                if_stmt { 'if',
                    expr => branch { 'ne',
                        left => function_call { 'ref',
                            args => [
                                leaf '$server',
                            ],
                        },
                        right => leaf 'CODE',
                    },
                    true_stmt => [
                        branch { '=',
                            left => leaf '$server_class',
                            right => leaf '$server',
                        },
                        branch { '=',
                            left => leaf '$server',
                            right => function { 'sub',
                                body => [
                                    branch { '=',
                                        left => list { '()',
                                            data => branch { ',',
                                                left => leaf '$port',
                                                right => leaf '$app',
                                            },
                                        },
                                        right => leaf '@_',
                                    },
                                    branch { '=',
                                        left => leaf '$server',
                                        right => branch { '->',
                                            left => leaf 'Plack::Loader',
                                            right => function_call { 'load',
                                                args => [
                                                    list { '()',
                                                        data => branch { ',',
                                                            left => branch { ',',
                                                                left => branch { ',',
                                                                    left => leaf '$server_class',
                                                                    right => branch { '=>',
                                                                        left => leaf 'port',
                                                                        right => leaf '$port',
                                                                    },
                                                                },
                                                                right => branch { '=>',
                                                                    left => leaf 'host',
                                                                    right => leaf '127.0.0.1',
                                                                },
                                                            },
                                                            right => leaf '%args',
                                                        },
                                                    },
                                                ],
                                            },
                                        },
                                    },
                                    branch { '=',
                                        left => leaf '$app',
                                        right => branch { '->',
                                            left => leaf 'Plack::Middleware::Lint',
                                            right => function_call { 'wrap',
                                                args => [
                                                    leaf '$app',
                                                ],
                                            },
                                        },
                                    },
                                    branch { '->',
                                        left => leaf '$server',
                                        right => function_call { 'run',
                                            args => [
                                                leaf '$app',
                                            ],
                                        },
                                    },
                                ],
                            },
                        },
                    ],
                },
                function_call { 'test_tcp',
                    args => [
                        list { '()',
                            data => branch { ',',
                                left => branch { ',',
                                    left => branch { ',',
                                        left => branch { '=>',
                                            left => leaf 'client',
                                            right => function { 'sub',
                                                body => [
                                                    branch { '=',
                                                        left => leaf '$port',
                                                        right => function_call { 'shift',
                                                            args => [
                                                            ],
                                                        },
                                                    },
                                                    branch { '=',
                                                        left => leaf '$ua',
                                                        right => branch { '->',
                                                            left => leaf 'LWP::UserAgent',
                                                            right => function_call { 'new',
                                                                args => [
                                                                ],
                                                            },
                                                        },
                                                    },
                                                    foreach_stmt { 'for',
                                                        cond => branch { '..',
                                                            left => leaf '0',
                                                            right => single_term_operator { '$#',
                                                                expr => leaf 'TEST',
                                                            },
                                                        },
                                                        true_stmt => [
                                                            branch { '=',
                                                                left => leaf '$test',
                                                                right => array { '$TEST',
                                                                    idx => array_ref { '[]',
                                                                        data => leaf '$i',
                                                                    },
                                                                },
                                                            },
                                                            function_call { 'note',
                                                                args => [
                                                                    branch { '->',
                                                                        left => leaf '$test',
                                                                        right => array_ref { '[]',
                                                                            data => leaf '0',
                                                                        },
                                                                    },
                                                                ],
                                                            },
                                                            branch { '=',
                                                                left => leaf '$cb',
                                                                right => function { 'sub',
                                                                    body => [
                                                                        branch { '=',
                                                                            left => leaf '$req',
                                                                            right => function_call { 'shift',
                                                                                args => [
                                                                                ],
                                                                            },
                                                                        },
                                                                        branch { '->',
                                                                            left => branch { '->',
                                                                                left => leaf '$req',
                                                                                right => function_call { 'uri',
                                                                                    args => [
                                                                                    ],
                                                                                },
                                                                            },
                                                                            right => function_call { 'port',
                                                                                args => [
                                                                                    branch { '||',
                                                                                        left => leaf '$http_port',
                                                                                        right => leaf '$port',
                                                                                    },
                                                                                ],
                                                                            },
                                                                        },
                                                                        branch { '->',
                                                                            left => branch { '->',
                                                                                left => leaf '$req',
                                                                                right => function_call { 'uri',
                                                                                    args => [
                                                                                    ],
                                                                                },
                                                                            },
                                                                            right => function_call { 'path',
                                                                                args => [
                                                                                    branch { '.',
                                                                                        left => branch { '||',
                                                                                            left => hash { '$ENV',
                                                                                                key => hash_ref { '{}',
                                                                                                    data => leaf 'PLACK_TEST_SCRIPT_NAME',
                                                                                                },
                                                                                            },
                                                                                            right => leaf '',
                                                                                        },
                                                                                        right => branch { '->',
                                                                                            left => branch { '->',
                                                                                                left => leaf '$req',
                                                                                                right => function_call { 'uri',
                                                                                                    args => [
                                                                                                    ],
                                                                                                },
                                                                                            },
                                                                                            right => function_call { 'path',
                                                                                                args => [
                                                                                                ],
                                                                                            },
                                                                                        },
                                                                                    },
                                                                                ],
                                                                            },
                                                                        },
                                                                        branch { '->',
                                                                            left => leaf '$req',
                                                                            right => function_call { 'header',
                                                                                args => [
                                                                                    list { '()',
                                                                                        data => branch { '=>',
                                                                                            left => leaf 'X-Plack-Test',
                                                                                            right => leaf '$i',
                                                                                        },
                                                                                    },
                                                                                ],
                                                                            },
                                                                        },
                                                                        Test::Compiler::Parser::return { 'return',
                                                                            body => branch { '->',
                                                                                left => leaf '$ua',
                                                                                right => function_call { 'request',
                                                                                    args => [
                                                                                        leaf '$req',
                                                                                    ],
                                                                                },
                                                                            },
                                                                        },
                                                                    ],
                                                                },
                                                            },
                                                            branch { '->',
                                                                left => branch { '->',
                                                                    left => leaf '$test',
                                                                    right => array_ref { '[]',
                                                                        data => leaf '1',
                                                                    },
                                                                },
                                                                right => list { '()',
                                                                    data => leaf '$cb',
                                                                },
                                                            },
                                                        ],
                                                        itr => leaf '$i',
                                                    },
                                                ],
                                            },
                                        },
                                        right => branch { '=>',
                                            left => leaf 'server',
                                            right => function { 'sub',
                                                body => [
                                                    branch { '=',
                                                        left => leaf '$port',
                                                        right => function_call { 'shift',
                                                            args => [
                                                            ],
                                                        },
                                                    },
                                                    branch { '=',
                                                        left => leaf '$app',
                                                        right => branch { '->',
                                                            left => leaf '$class',
                                                            right => function_call { 'test_app_handler',
                                                                args => [
                                                                ],
                                                            },
                                                        },
                                                    },
                                                    branch { '->',
                                                        left => leaf '$server',
                                                        right => list { '()',
                                                            data => branch { ',',
                                                                left => leaf '$port',
                                                                right => leaf '$app',
                                                            },
                                                        },
                                                    },
                                                    function_call { 'exit',
                                                        args => [
                                                            leaf '0',
                                                        ],
                                                    },
                                                ],
                                            },
                                        },
                                    },
                                    right => branch { '=>',
                                        left => leaf 'port',
                                        right => leaf '$server_port',
                                    },
                                },
                            },
                        },
                    ],
                },
            ],
        },
        function { 'test_app_handler',
            body => Test::Compiler::Parser::return { 'return',
                body => function { 'sub',
                    body => [
                        branch { '=',
                            left => leaf '$env',
                            right => function_call { 'shift',
                                args => [
                                ],
                            },
                        },
                        branch { '->',
                            left => branch { '->',
                                left => array { '$TEST',
                                    idx => array_ref { '[]',
                                        data => branch { '->',
                                            left => leaf '$env',
                                            right => hash_ref { '{}',
                                                data => leaf 'HTTP_X_PLACK_TEST',
                                            },
                                        },
                                    },
                                },
                                right => array_ref { '[]',
                                    data => leaf '2',
                                },
                            },
                            right => list { '()',
                                data => leaf '$env',
                            },
                        },
                    ],
                },
            },
        },
        leaf '1',
    ]);
};

done_testing;

__DATA__
package Plack::Test::Suite;
use strict;
use warnings;
use Digest::MD5;
use File::ShareDir;
use HTTP::Request;
use HTTP::Request::Common;
use LWP::UserAgent;
use Test::More;
use Test::TCP;
use Plack::Loader;
use Plack::Middleware::Lint;
use Plack::Util;
use Plack::Request;
use Try::Tiny;

my $share_dir = try { File::ShareDir::dist_dir('Plack') } || 'share';

$ENV{PLACK_TEST_SCRIPT_NAME} = '';

# 0: test name
# 1: request generator coderef.
# 2: request handler
# 3: test case for response
our @TEST = (
    [
        'SCRIPT_NAME',
        sub {
            my $cb = shift;
            my $res = $cb->(GET "http://127.0.0.1/");
            is $res->content, $ENV{PLACK_TEST_SCRIPT_NAME};
        },
        sub {
            my $env = shift;
            return [ 200, ["Content-Type", "text/plain"], [ $env->{SCRIPT_NAME} ] ];
        },
    ],
    [
        'GET',
        sub {
            my $cb = shift;
            my $res = $cb->(GET "http://127.0.0.1/?name=miyagawa");
            is $res->code, 200;
            is $res->message, 'OK';
            is $res->header('content_type'), 'text/plain';
            is $res->content, 'Hello, name=miyagawa';
        },
        sub {
            my $env = shift;
            return [
                200,
                [ 'Content-Type' => 'text/plain', ],
                [ 'Hello, ' . $env->{QUERY_STRING} ],
            ];
        },
    ],
    [
        'POST',
        sub {
            my $cb = shift;
            my $res = $cb->(POST "http://127.0.0.1/", [name => 'tatsuhiko']);
            is $res->code, 200;
            is $res->message, 'OK';
            is $res->header('Client-Content-Length'), 14;
            is $res->header('Client-Content-Type'), 'application/x-www-form-urlencoded';
            is $res->header('content_type'), 'text/plain';
            is $res->content, 'Hello, name=tatsuhiko';
        },
        sub {
            my $env = shift;
            my $body;
            $env->{'psgi.input'}->read($body, $env->{CONTENT_LENGTH});
            return [
                200,
                [ 'Content-Type' => 'text/plain',
                  'Client-Content-Length' => $env->{CONTENT_LENGTH},
                  'Client-Content-Type' => $env->{CONTENT_TYPE},
              ],
                [ 'Hello, ' . $body ],
            ];
        },
    ],
    [
        'big POST',
        sub {
            my $cb = shift;
            my $chunk = "abcdefgh" x 12000;
            my $req = HTTP::Request->new(POST => "http://127.0.0.1/");
            $req->content_length(length $chunk);
            $req->content_type('application/octet-stream');
            $req->content($chunk);

            my $res = $cb->($req);
            is $res->code, 200;
            is $res->message, 'OK';
            is $res->header('Client-Content-Length'), length $chunk;
            is length $res->content, length $chunk;
            is Digest::MD5::md5_hex($res->content), Digest::MD5::md5_hex($chunk);
        },
        sub {
            my $env = shift;
            my $len = $env->{CONTENT_LENGTH};
            my $body = '';
            my $spin;
            while ($len > 0) {
                my $rc = $env->{'psgi.input'}->read($body, $env->{CONTENT_LENGTH}, length $body);
                $len -= $rc;
                last if $spin++ > 2000;
            }
            return [
                200,
                [ 'Content-Type' => 'text/plain',
                  'Client-Content-Length' => $env->{CONTENT_LENGTH},
                  'Client-Content-Type' => $env->{CONTENT_TYPE},
              ],
                [ $body ],
            ];
        },
    ],
    [
        'psgi.url_scheme',
        sub {
            my $cb = shift;
            my $res = $cb->(POST "http://127.0.0.1/");
            is $res->code, 200;
            is $res->message, 'OK';
            is $res->header('content_type'), 'text/plain';
            is $res->content, 'http';
        },
        sub {
            my $env = $_[0];
            return [
                200,
                [ 'Content-Type' => 'text/plain', ],
                [ $env->{'psgi.url_scheme'} ],
            ];
        },
    ],
    [
        'return glob',
        sub {
            my $cb  = shift;
            my $res = $cb->(GET "http://127.0.0.1/");
            is $res->code, 200;
            is $res->message, 'OK';
            is $res->header('content_type'), 'text/plain';
            like $res->content, qr/^package /;
            like $res->content, qr/END_MARK_FOR_TESTING$/;
        },
        sub {
            my $env = shift;
            open my $fh, '<', __FILE__ or die $!;
            return [
                200,
                [ 'Content-Type' => 'text/plain', ],
                $fh,
            ];
        },
    ],
    [
        'filehandle',
        sub {
            my $cb  = shift;
            my $res = $cb->(GET "http://127.0.0.1/foo.jpg");
            is $res->code, 200;
            is $res->message, 'OK';
            is $res->header('content_type'), 'image/jpeg';
            is length $res->content, 4745;
        },
        sub {
            my $env = shift;
            open my $fh, '<', "$share_dir/face.jpg";
            return [
                200,
                [ 'Content-Type' => 'image/jpeg', 'Content-Length' => -s $fh ],
                $fh
            ];
        },
    ],
    [
        'bigger file',
        sub {
            my $cb  = shift;
            my $res = $cb->(GET "http://127.0.0.1/baybridge.jpg");
            is $res->code, 200;
            is $res->message, 'OK';
            is $res->header('content_type'), 'image/jpeg';
            is length $res->content, 79838;
            is Digest::MD5::md5_hex($res->content), '983726ae0e4ce5081bef5fb2b7216950';
        },
        sub {
            my $env = shift;
            open my $fh, '<', "$share_dir/baybridge.jpg";
            binmode $fh;
            return [
                200,
                [ 'Content-Type' => 'image/jpeg', 'Content-Length' => -s $fh ],
                $fh
            ];
        },
    ],
    [
        'handle HTTP-Header',
        sub {
            my $cb  = shift;
            my $res = $cb->(GET "http://127.0.0.1/foo/?dankogai=kogaidan", Foo => "Bar");
            is $res->code, 200;
            is $res->message, 'OK';
            is $res->header('content_type'), 'text/plain';
            is $res->content, 'Bar';
        },
        sub {
            my $env = shift;
            return [
                200,
                [ 'Content-Type' => 'text/plain', ],
                [$env->{HTTP_FOO}],
            ];
        },
    ],
    [
        'handle HTTP-Cookie',
        sub {
            my $cb  = shift;
            my $res = $cb->(GET "http://127.0.0.1/foo/?dankogai=kogaidan", Cookie => "foo");
            is $res->code, 200;
            is $res->message, 'OK';
            is $res->header('content_type'), 'text/plain';
            is $res->content, 'foo';
        },
        sub {
            my $env = shift;
            return [
                200,
                [ 'Content-Type' => 'text/plain', ],
                [$env->{HTTP_COOKIE}],
            ];
        },
    ],
    [
        'validate env',
        sub {
            my $cb  = shift;
            my $res = $cb->(GET "http://127.0.0.1/foo/?dankogai=kogaidan");
            is $res->code, 200;
            is $res->message, 'OK';
            is $res->header('content_type'), 'text/plain';
            is $res->content, join("\n",
                'REQUEST_METHOD:GET',
                "SCRIPT_NAME:$ENV{PLACK_TEST_SCRIPT_NAME}",
                'PATH_INFO:/foo/',
                'QUERY_STRING:dankogai=kogaidan',
                'SERVER_NAME:127.0.0.1',
                "SERVER_PORT:" . $res->request->uri->port,
            )."\n";
        },
        sub {
            my $env = shift;
            my $body;
            $body .= $_ . ':' . $env->{$_} . "\n" for qw/REQUEST_METHOD SCRIPT_NAME PATH_INFO QUERY_STRING SERVER_NAME SERVER_PORT/;
            return [
                200,
                [ 'Content-Type' => 'text/plain', ],
                [$body],
            ];
        },
    ],
    [
        '% encoding in PATH_INFO',
        sub {
            my $cb  = shift;
            my $res = $cb->(GET "http://127.0.0.1/foo/bar%2cbaz");
            is $res->content, "/foo/bar,baz", "PATH_INFO should be decoded per RFC 3875";
        },
        sub {
            my $env = shift;
            return [
                200,
                [ 'Content-Type' => 'text/plain', ],
                [ $env->{PATH_INFO} ],
            ];
        },
    ],
    [
        '% double encoding in PATH_INFO',
        sub {
            my $cb  = shift;
            my $res = $cb->(GET "http://127.0.0.1/foo/bar%252cbaz");
            is $res->content, "/foo/bar%2cbaz", "PATH_INFO should be decoded only once, per RFC 3875";
        },
        sub {
            my $env = shift;
            return [
                200,
                [ 'Content-Type' => 'text/plain', ],
                [ $env->{PATH_INFO} ],
            ];
        },
    ],
    [
        '% encoding in PATH_INFO (outside of URI characters)',
        sub {
            my $cb  = shift;
            my $res = $cb->(GET "http://127.0.0.1/foo%E3%81%82");
            is $res->content, "/foo\x{e3}\x{81}\x{82}";
        },
        sub {
            my $env = shift;
            return [
                200,
                [ 'Content-Type' => 'text/plain', ],
                [ $env->{PATH_INFO} ],
            ];
        },
    ],
    [
        'SERVER_PROTOCOL is required',
        sub {
            my $cb  = shift;
            my $res = $cb->(GET "http://127.0.0.1/foo/?dankogai=kogaidan");
            is $res->code, 200;
            is $res->message, 'OK';
            is $res->header('content_type'), 'text/plain';
            like $res->content, qr{^HTTP/1\.[01]$};
        },
        sub {
            my $env = shift;
            return [
                200,
                [ 'Content-Type' => 'text/plain', ],
                [$env->{SERVER_PROTOCOL}],
            ];
        },
    ],
    [
        'SCRIPT_NAME should not be undef',
        sub {
            my $cb  = shift;
            my $res = $cb->(GET "http://127.0.0.1/foo/?dankogai=kogaidan");
            is $res->content, 1;
        },
        sub {
            my $env = shift;
            my $cont = defined $env->{'SCRIPT_NAME'};
            return [
                200,
                [ 'Content-Type' => 'text/plain', ],
                [$cont],
            ];
        },
    ],
    [
        'call close after read IO::Handle-like',
        sub {
            my $cb  = shift;
            my $res = $cb->(GET "http://127.0.0.1/call_close");
            is($res->content, '1234');
        },
        sub {
            my $env = shift;
            {
                our $closed = -1;
                sub CalledClose::new { $closed = 0; my $i=0; bless \$i, 'CalledClose' }
                sub CalledClose::getline {
                    my $self = shift;
                    return $$self++ < 4 ? $$self : undef;
                }
                sub CalledClose::close { ::ok(1, 'closed') if defined &::ok }
            }
            return [
                200,
                [ 'Content-Type' => 'text/plain', ],
                CalledClose->new(),
            ];
        },
    ],
    [
        'has errors',
        sub {
            my $cb  = shift;
            my $res = $cb->(GET "http://127.0.0.1/has_errors");
            is $res->content, 1;
        },
        sub {
            my $env = shift;
            my $err = $env->{'psgi.errors'};
            my $has_errors = defined $err;
            return [
                200,
                [ 'Content-Type' => 'text/plain', ],
                [$has_errors]
            ];
        },
    ],
    [
        'status line',
        sub {
            my $cb  = shift;
            my $res = $cb->(GET "http://127.0.0.1/foo/?dankogai=kogaidan");
            is($res->status_line, '200 OK');
        },
        sub {
            my $env = shift;
            return [
                200,
                [ 'Content-Type' => 'text/plain', ],
                [1]
            ];
        },
    ],
    [
        'Do not crash when the app dies',
        sub {
            my $cb  = shift;
            my $res = $cb->(GET "http://127.0.0.1/");
            is $res->code, 500;
            is $res->message, 'Internal Server Error';
        },
        sub {
            my $env = shift;
            open my $io, '>', \my $error;
            $env->{'psgi.errors'} = $io;
            die "Throwing an exception from app handler. Server shouldn't crash.";
        },
    ],
    [
        'multi headers (request)',
        sub {
            my $cb  = shift;
            my $req = HTTP::Request->new(
                GET => "http://127.0.0.1/",
            );
            $req->push_header(Foo => "bar");
            $req->push_header(Foo => "baz");
            my $res = $cb->($req);
            like($res->content, qr/^bar,\s*baz$/);
        },
        sub {
            my $env = shift;
            return [
                200,
                [ 'Content-Type' => 'text/plain', ],
                [ $env->{HTTP_FOO} ]
            ];
        },
    ],
    [
        'multi headers (response)',
        sub {
            my $cb  = shift;
            my $res = $cb->(HTTP::Request->new(GET => "http://127.0.0.1/"));
            my $foo = $res->header('X-Foo');
            like $foo, qr/foo,\s*bar,\s*baz/;
        },
        sub {
            my $env = shift;
            return [
                200,
                [ 'Content-Type' => 'text/plain', 'X-Foo', 'foo', 'X-Foo', 'bar, baz' ],
                [ 'hi' ]
            ];
        },
    ],
    [
        'Do not set $env->{COOKIE}',
        sub {
            my $cb  = shift;
            my $req = HTTP::Request->new(
                GET => "http://127.0.0.1/",
            );
            $req->push_header(Cookie => "foo=bar");
            my $res = $cb->($req);
            is($res->header('X-Cookie'), 0);
            is $res->content, 'foo=bar';
        },
        sub {
            my $env = shift;
            return [
                200,
                [ 'Content-Type' => 'text/plain', 'X-Cookie' => $env->{COOKIE} ? 1 : 0 ],
                [ $env->{HTTP_COOKIE} ]
            ];
        },
    ],
    [
        'no entity headers on 304',
        sub {
            my $cb  = shift;
            my $res = $cb->(GET "http://127.0.0.1/");
            is $res->code, 304;
            is $res->message, 'Not Modified';
            is $res->content, '';
            ok ! defined $res->header('content_type'), "No Content-Type";
            ok ! defined $res->header('content_length'), "No Content-Length";
            ok ! defined $res->header('transfer_encoding'), "No Transfer-Encoding";
        },
        sub {
            my $env = shift;
            return [ 304, [], [] ];
        },
    ],
    [
        'REQUEST_URI is set',
        sub {
            my $cb  = shift;
            my $res = $cb->(GET "http://127.0.0.1/foo/bar%20baz%73?x=a");
            is $res->content, $ENV{PLACK_TEST_SCRIPT_NAME} . "/foo/bar%20baz%73?x=a";
        },
        sub {
            my $env = shift;
            return [ 200, [ 'Content-Type' => 'text/plain' ], [ $env->{REQUEST_URI} ] ];
        },
    ],
    [
        'filehandle with path()',
        sub {
            my $cb  = shift;
            my $res = $cb->(GET "http://127.0.0.1/foo.jpg");
            is $res->code, 200;
            is $res->message, 'OK';
            is $res->header('content_type'), 'image/jpeg';
            is length $res->content, 4745;
        },
        sub {
            my $env = shift;
            open my $fh, '<', "$share_dir/face.jpg";
            Plack::Util::set_io_path($fh, "$share_dir/face.jpg");
            return [
                200,
                [ 'Content-Type' => 'image/jpeg', 'Content-Length' => -s $fh ],
                $fh
            ];
        },
    ],
    [
        'a big header value > 128 bytes',
        sub {
            my $cb  = shift;
            my $req = GET "http://127.0.0.1/";
            my $v = ("abcdefgh" x 16);
            $req->header('X-Foo' => $v);
            my $res = $cb->($req);
            is $res->code, 200;
            is $res->message, 'OK';
            is $res->content, $v;
        },
        sub {
            my $env = shift;
            return [
                200,
                [ 'Content-Type' => 'text/plain' ],
                [ $env->{HTTP_X_FOO} ],
            ];
        },
    ],
    [
        'coderef res',
        sub {
            my $cb = shift;
            my $res = $cb->(GET "http://127.0.0.1/?name=miyagawa");
            return if $res->code == 501;

            is $res->code, 200;
            is $res->message, 'OK';
            is $res->header('content_type'), 'text/plain';
            is $res->content, 'Hello, name=miyagawa';
        },
        sub {
            my $env = shift;
            $env->{'psgi.streaming'} or return [ 501, ['Content-Type','text/plain'], [] ];
            return sub {
                my $respond = shift;
                $respond->([
                    200,
                    [ 'Content-Type' => 'text/plain', ],
                    [ 'Hello, ' . $env->{QUERY_STRING} ],
                ]);
            }
        },
    ],
    [
        'coderef streaming',
        sub {
            my $cb = shift;
            my $res = $cb->(GET "http://127.0.0.1/?name=miyagawa");
            return if $res->code == 501;

            is $res->code, 200;
            is $res->message, 'OK';
            is $res->header('content_type'), 'text/plain';
            is $res->content, 'Hello, name=miyagawa';
        },
        sub {
            my $env = shift;
            $env->{'psgi.streaming'} or return [ 501, ['Content-Type','text/plain'], [] ];

            return sub {
                my $respond = shift;

                my $writer = $respond->([
                    200,
                    [ 'Content-Type' => 'text/plain', ],
                ]);

                $writer->write("Hello, ");
                $writer->write($env->{QUERY_STRING});
                $writer->close();
            }
        },
    ],
    [
        'CRLF output and FCGI parse bug',
        sub {
            my $cb = shift;
            my $res = $cb->(GET "http://127.0.0.1/");

            is $res->header("Foo"), undef;
            is $res->content, "Foo: Bar\r\n\r\nHello World";
        },
        sub {
            return [ 200, [ "Content-Type", "text/plain" ], [ "Foo: Bar\r\n\r\nHello World" ] ];
        },
    ],
    [
        'newlines',
        sub {
            my $cb = shift;
            my $res = $cb->(GET "http://127.0.0.1/");
            is length($res->content), 7;
        },
        sub {
            return [ 200, [ "Content-Type", "text/plain" ], [ "Bar\nBaz" ] ];
        },
    ],
    [
        'test 404',
        sub {
            my $cb = shift;
            my $res = $cb->(GET "http://127.0.0.1/");
            is $res->code, 404;
            is $res->message, 'Not Found';
            is $res->content, 'Not Found';
        },
        sub {
            return [ 404, [ "Content-Type", "text/plain" ], [ "Not Found" ] ];
        },
    ],
    [
        'request->input seekable',
        sub {
            my $cb = shift;
            my $req = HTTP::Request->new(POST => "http://127.0.0.1/");
            $req->content("body");
            $req->content_type('text/plain');
            $req->content_length(4);
            my $res = $cb->($req);
            is $res->content, 'body';
        },
        sub {
            my $req = Plack::Request->new(shift);
            return [ 200, [ "Content-Type", "text/plain" ], [ $req->content ] ];
        },
    ],
    [
        'request->content on GET',
        sub {
            my $cb = shift;
            my $res = $cb->(GET "http://127.0.0.1/");
            ok $res->is_success;
        },
        sub {
            my $req = Plack::Request->new(shift);
            $req->content;
            return [ 200, [ "Content-Type", "text/plain" ], [ "OK" ] ];
        },
    ],
    [
        'handle Authorization header',
        sub {
            my $cb  = shift;
            SKIP: {
                skip "Authorization header is unsupported under CGI", 4 if ($ENV{PLACK_TEST_HANDLER} || "") eq "CGI";

                {
                    my $req = HTTP::Request->new(
                        GET => "http://127.0.0.1/",
                    );
                    $req->push_header(Authorization => 'Basic XXXX');
                    my $res = $cb->($req);
                    is $res->header('X-AUTHORIZATION'), 1;
                    is $res->content, 'Basic XXXX';
                };

                {
                    my $req = HTTP::Request->new(
                        GET => "http://127.0.0.1/",
                    );
                    my $res = $cb->($req);
                    is $res->header('X-AUTHORIZATION'), 0;
                    is $res->content, '';
                };
            };
        },
        sub {
            my $env = shift;
            return [
                200,
                [ 'Content-Type' => 'text/plain', 'X-AUTHORIZATION' => exists($env->{HTTP_AUTHORIZATION}) ? 1 : 0 ],
                [ $env->{HTTP_AUTHORIZATION} || '' ],
            ];
        },
    ],
    [
        'repeated slashes',
        sub {
            my $cb = shift;
            my $res = $cb->(GET "http://127.0.0.1//foo///bar/baz");
            is $res->code, 200;
            is $res->message, 'OK';
            is $res->header('content_type'), 'text/plain';
            is $res->content, '//foo///bar/baz';
        },
        sub {
            my $env = shift;
            return [
                200,
                [ 'Content-Type' => 'text/plain', ],
                [ $env->{PATH_INFO} ],
            ];
        },
    ],
);

sub runtests {
    my($class, $runner) = @_;
    for my $test (@TEST) {
        $runner->(@$test);
    }
}

sub run_server_tests {
    my($class, $server, $server_port, $http_port, %args) = @_;

    if (ref $server ne 'CODE') {
        my $server_class = $server;
        $server = sub {
            my($port, $app) = @_;
            my $server = Plack::Loader->load($server_class, port => $port, host => "127.0.0.1", %args);
            $app = Plack::Middleware::Lint->wrap($app);
            $server->run($app);
        }
    }

    test_tcp(
        client => sub {
            my $port = shift;

            my $ua = LWP::UserAgent->new;
            for my $i (0..$#TEST) {
                my $test = $TEST[$i];
                note $test->[0];
                my $cb = sub {
                    my $req = shift;
                    $req->uri->port($http_port || $port);
                    $req->uri->path(($ENV{PLACK_TEST_SCRIPT_NAME}||"") . $req->uri->path);
                    $req->header('X-Plack-Test' => $i);
                    return $ua->request($req);
                };

                $test->[1]->($cb);
            }
        },
        server => sub {
            my $port = shift;
            my $app  = $class->test_app_handler;
            $server->($port, $app);
            exit(0); # for Test::TCP
        },
        port => $server_port,
    );
}

sub test_app_handler {
    return sub {
        my $env = shift;
        $TEST[$env->{HTTP_X_PLACK_TEST}][2]->($env);
    };
}

1;
__END__

=head1 NAME

Plack::Test::Suite - Test suite for Plack handlers

=head1 SYNOPSIS

  use Test::More;
  use Plack::Test::Suite;
  Plack::Test::Suite->run_server_tests('Your::Handler');
  done_testing;

=head1 DESCRIPTION

Plack::Test::Suite is a test suite to test a new PSGI server
implementation. It automatically loads a new handler environment and
uses LWP to send HTTP requests to the local server to make sure your
handler implements the PSGI specification correctly.

Note that the handler name doesn't include the C<Plack::Handler::>
prefix, i.e. if you have a new Plack handler Plack::Handler::Foo, your
test script would look like:

  Plack::Test::Suite->run_server_tests('Foo');

=head1 AUTHOR

Tokuhiro Matsuno

Tatsuhiko Miyagawa

Kazuho Oku

=cut

END_MARK_FOR_TESTING

