#!/usr/bin/perl

use strict;
use warnings;
use utf8;

use ChordPro::Testing;
use ChordPro::Config;
use ChordPro::Songbook;

plan tests => 4;

# For transcoding, both source and target notation systems must be
# defined. The source system must be last, so it is current and used
# to parse the the input data.

our $config =
  eval {
      ChordPro::Config::configurator
	  ( { nosysconfig => 1, nolegacyconfig => 1, nouserconfig => 1,
	      config => [ getresource("config/notes/common.json"),
			  getresource("config/notes/latin.json"),
			],
	      transcode => "common"
	    } );
  };
ok( $config, "got config" );
my $s = ChordPro::Songbook->new;

my $data = <<EOD;
{title: Swing Low Sweet Chariot}
{key: Re}
I [Re]looked over Jordan, and [Solm7]what did I [Re]see,
EOD

eval { $s->parse_file( \$data ) } or diag("$@");

ok( scalar( @{ $s->{songs} } ) == 1, "One song" );
isa_ok( $s->{songs}->[0], 'ChordPro::Song', "It's a song" );

my $song = {
	    'settings' => {},
	    'meta' => {
		       'songindex' => 1,
		       'key' => [ 'D' ],
		       'title' => [
				   'Swing Low Sweet Chariot'
				  ],
		      },
	    'title' => 'Swing Low Sweet Chariot',
	    'chords' => {
			 'origin' => 'song',
			 'type' => 'diagrams',
			 'show' => 'all',
			 'chords' => [
				      'D',
				      'Gm7'
				     ]
			},
	    'body' => [
                       {
			 'context' => '',
			 'line' => 3,
			 'phrases' => [
					'I ',
					'looked over Jordan, and ',
					'what did I ',
					'see,'
				      ],
			 'chords' => [
				       '',
				       'D',
				       'Gm7',
				       'D'
				     ],
			 'type' => 'songline'
		       }
		      ],
	    chordsinfo => { map { $_ => $_ } qw( D Gm7 )  },
	    'source' => { file => "__STRING__", line => 1 },
	    'structure' => 'linear',
	    'system' => 'latin',
	   };

is_deeply( { %{ $s->{songs}->[0] } }, $song, "Song contents" );
