#!/usr/bin/perl
#
# @(#)$Id: esqlsed.pl,v 2015.1 2015/08/21 22:56:29 jleffler Exp $ 
#
# DBD::Informix for Perl Version 5
#
# Post-process C files generated by Informix ESQL/C versions 4.10.UC1 upwards
#
# Copyright 1996-98 Jonathan Leffler
# Copyright 2002    IBM
#
# You may distribute under the terms of either the GNU General Public
# License or the Artistic License, as specified in the Perl README file.

# NB: Used by esqlcc script.
use strict;
use warnings;

my $first = <>;

die "This isn't C code generated from ESQL/C\n$first"
    unless ($first =~ m/^#include\s*<sqlhdr\.h>$/);

my ($info) =
    '/* Processed by $RCSfile: esqlsed.pl,v $' .
        ' version $Revision: 2015.1 $' .
        ' ($Date: 2015/08/21 22:56:29 $) */';
$info =~ s/\$[A-Z][A-Za-z]*: ([^\$]+) \$/$1/g;   # Remove RCS!
$info =~ s/,v//g;
print "$info\n#include \"esqlc.h\"\n";

while (<>)
{
    $_ = "" if (/^#include\s+<sqlca\.h>\s*$/o);
    $_ = "" if (/^#include\s+<sqlhdr\.h>\s*$/o);
    $_ = "" if (/^extern\s+_SQCURSOR\s*\*_iqnprep\(\);\s*$/o);
    $_ = "" if (/^#define\s+const\s*$/o);
    s/\(char\s*\*\)\s*0/0/og if (/\b_iq\w+\(/o);
    print;
}
