use 5.006;
use strict;
use warnings;

use Module::Build;


my $class = Module::Build->subclass(
	code =>
	q|
		# Override 'test' to support running extended tests in the xt/
		# directory.
		sub ACTION_test
		{
			my ( $self ) = @_;

			$self->recursive_test_files(1);

			$self->test_files( 't', 'xt' )
				if $ENV{'RELEASE_TESTING'};

			return $self->SUPER::ACTION_test();
		}

		# Force running extended tests when testing the distribution.
		sub ACTION_disttest
		{
			my ( $self ) = @_;

			local $ENV{ RELEASE_TESTING } = 1;

			return $self->SUPER::ACTION_disttest();
		}
	|,
);

my $builder = $class->new(
	module_name          => 'App::GitHooks::Plugin::NotifyReleasesToSlack',
	license              => 'GPL_3',
	dist_author          => q{Guillaume Aubert <aubertg@cpan.org>},
	dist_version_from    => 'lib/App/GitHooks/Plugin/NotifyReleasesToSlack.pm',
	build_requires       =>
	{
		'Test::FailWarnings'   => 0,
		'Test::Git'            => 0,
		'Test::More'           => 0.94,
	},
	requires             =>
	{
		'App::GitHooks'        => 0,
		'CPAN::Changes'        => 0,
		'Data::Dumper'         => 0,
		'JSON'                 => 0,
		'LWP::UserAgent'       => 0,
		'Log::Any'             => 0,
		'Try::Tiny'            => 0,
		'perl'                 => 5.010, # "state" variables.
	},
	add_to_cleanup       =>
	[
		'App-GitHooks-Plugin-NotifyReleasesToSlack-*',
	],
	create_makefile_pl   => 'traditional',
	configure_requires   =>
	{
		'Module::Build'        => 0,
	},
	meta_merge           =>
	{
		resources              =>
		{
			repository  => 'https://github.com/guillaumeaubert/App-GitHooks-Plugin-NotifyReleasesToSlack',
			homepage    => 'https://metacpan.org/release/App-GitHooks-Plugin-NotifyReleasesToSlack',
			bugtracker  => 'https://github.com/guillaumeaubert/App-GitHooks-Plugin-NotifyReleasesToSlack/issues',
		},
	},
	recursive_test_files => 1,
);

$builder->create_build_script();
