package Daje::Plugin::Apploader;
use Mojo::Base 'Mojolicious::Plugin', -signatures;
use v5.40;

use Mojo::Loader qw {load_class};
use Daje::Database::Migrator;

# NAME
# ====
#
# Daje::Plugin::Apploader - It's new $module
#
# SYNOPSIS
# ========
#
#   load_ables => {
#             namespaces => {
#                 plugins => [
#                     {
#                         name => ''
#                    }
#                 ],
#                 routes => [
#                     {
#                         name => ''
#                    }
#                 ]
#             },
#          plugin => [
#                 {
#                    name => '',
#                    options => [
#                        {
#                            name => '',
#                           option => ''
#                       }
#                   ]
#               }
#           ],
#           helper => [
#               {
#                   name => '',
#                   class => '',
#                   options => ''
#               }
#           ],
#           routes => [
#               {
#                   route => '',
#                   target => '',
#                   method => ''
#               }
#           ]
#     }
#     use Daje::Plugin::Apploader;
#
#     sub register ($self, $app)
#
# DESCRIPTION
# ===========
#
# Daje::Plugin::Apploader is ...
#
# LICENSE
# =======
#
# Copyright (C) janeskil1525.
#
# This library is free software; you can redistribute it and/or modify
# it under the same terms as Perl itself.
#
# AUTHOR
# ======
#
# janeskil1525 E<lt>janeskil1525@gmail.comE<gt>
#

our $VERSION = "0.02";

sub register ($self, $app, $config) {

    $app->log->debug("Daje::Plugin::Apploader::register start");
    $self->_setup_database($app);
    $app->log->debug("_setup_database done");

    try {
        my $pg = $app->pg;
        my $loadables = $app->config("load_ables");

        if(exists $loadables->{namespaces}->{plugins}) {
            my $length = scalar @{$loadables->{namespaces}->{plugins}};
            for(my $i = 0; $i < $length; $i++) {
                push @{$app->plugins->namespaces}, @{$loadables->{namespaces}->{plugins}}[$i]->{name}
            }
        }

        $app->log->debug("plugin namespace done");
        if(exists $loadables->{namespaces}->{routes}) {
            my $length = scalar @{$loadables->{namespaces}->{routes}};
            for(my $i = 0; $i < $length; $i++) {
                push @{$app->routes->namespaces}, @{$loadables->{namespaces}->{routes}}[$i]->{name}
            }
        }

        $app->log->debug("routes namespace done");
        if(exists $loadables->{plugin}) {
            my $length = scalar @{$loadables->{plugin}};
            for(my $i = 0; $i < $length; $i++) {
                if (exists @{$loadables->{plugin}}[$i]->{options}) {
                    my %plugin = $self->_plugin_options(
                        $app,
                        @{$loadables->{plugin}}[$i]->{name},
                        @{$loadables->{plugin}}[$i]->{options}
                    );
                    $app->plugin(
                        %plugin
                    );
                } else {
                    $app->plugin(@{$loadables->{plugin}}[$i]->{name});
                }
            }
        }

        $app->log->debug("plugin loading done");
        if(exists $loadables->{helper}) {
            my $length = scalar @{$loadables->{helper}};
            for(my $i = 0; $i < $length; $i++) {
                my $class = @{$loadables->{helper}}[$i]->{class};
                if (my $e = load_class $class) {
                    $app->log->fatal($e);
                }
                my $name = @{$loadables->{helper}}[$i]->{name};
                $app->helper($name => sub{ state $var = $class->new()});
                # self->helper(jwt => sub {state $jwt = Daje::Tools::JWT->new()});
            }
        }

        $app->log->debug("helper loading done");
        if(exists $loadables->{routes}) {
            my $length = scalar @{$loadables->{routes}};
            for(my $i = 0; $i < $length; $i++) {

            }
        }

        $app->log->debug("route loading done");
        my $test = 1;
    } catch ($e) {
        my $error = $e;
        $app->log->fatal($e);
    }
}

sub _setup_database($self, $app) {

    try {
        Daje::Database::Migrator->new(
            pg         => $app->pg,
            migrations => $app->config('migrations'),
        )->migrate();
    } catch ($e) {
        $app->log->error($e);
    };
}

sub _plugin_options($self, $app, $name, $options) {

    my %plugin = ();
    my %result = ();

    my $length = scalar @{$options};
    for (my $i = 0; $i < $length; $i++) {
        my $plug = @{$options}[$i]->{name};
        my $data = @{$options}[$i]->{option};
        %plugin =  ($plug => eval $data);
    }

    $result{$name} = \%plugin;

    return %result;
}
1;
__END__






#################### pod generated by Pod::Autopod - keep this line to make pod updates possible ####################

=head1 NAME


Daje::Plugin::Apploader - It's new $module



=head1 SYNOPSIS


  load_ables => {
            namespaces => {
                plugins => [
                    {
                        name => ''
                   }
                ],
                routes => [
                    {
                        name => ''
                   }
                ]
            },
         plugin => [
                {
                   name => '',
                   options => [
                       {
                           name => '',
                          option => ''
                      }
                  ]
              }
          ],
          helper => [
              {
                  name => '',
                  class => '',
                  options => ''
              }
          ],
          routes => [
              {
                  route => '',
                  target => '',
                  method => ''
              }
          ]
    }
    use Daje::Plugin::Apploader;

    sub register ($self, $app)



=head1 DESCRIPTION


Daje::Plugin::Apploader is ...



=head1 REQUIRES

L<Mojo::Loader> 

L<v5.40> 

L<Mojo::Base> 


=head1 METHODS

=head2 register

 register();


=head1 AUTHOR


janeskil1525 E<lt>janeskil1525@gmail.comE<gt>



=head1 LICENSE


Copyright (C) janeskil1525.

This library is free software; you can redistribute it and/or modify
it under the same terms as Perl itself.



=cut

