# Generated by default/object.tt
package Paws::S3Control::AwsLambdaTransformation;
  use Moose;
  has FunctionArn => (is => 'ro', isa => 'Str', required => 1);
  has FunctionPayload => (is => 'ro', isa => 'Str');

1;

### main pod documentation begin ###

=head1 NAME

Paws::S3Control::AwsLambdaTransformation

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::S3Control::AwsLambdaTransformation object:

  $service_obj->Method(Att1 => { FunctionArn => $value, ..., FunctionPayload => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::S3Control::AwsLambdaTransformation object:

  $result = $service_obj->Method(...);
  $result->Att1->FunctionArn

=head1 DESCRIPTION

AWS Lambda function used to transform objects through an Object Lambda
Access Point.

=head1 ATTRIBUTES


=head2 B<REQUIRED> FunctionArn => Str

The Amazon Resource Name (ARN) of the AWS Lambda function.


=head2 FunctionPayload => Str

Additional JSON that provides supplemental data to the Lambda function
used to transform objects.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::S3Control>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

