package Acme::CPANModules::DescribeAModuleBadly::PERLANCAR;

use strict;

our $AUTHORITY = 'cpan:PERLANCAR'; # AUTHORITY
our $DATE = '2023-10-29'; # DATE
our $DIST = 'Acme-CPANModules-DescribeAModuleBadly-PERLANCAR'; # DIST
our $VERSION = '0.002'; # VERSION

our $LIST = {
    summary => 'List of modules that are described badly by PERLANCAR',
    description => <<'_',

_
    entries => [

        {
            module => 'Path::Tiny',
            description => <<'_',

When you're bored and want to relearn crawling, standing up, walking and speech
all over again when dealing with files.

_
        },

        {
            module => 'M',
            description => <<'_',

Remember when you want to have more than four ways to do OO, but less than six?
Yeah, me neither.

 (To be honest, I've used all <pm:Moose>, <pm:Mouse>, <pm:Moo>, and <pm:Mo> for
"real-world" purposes, and Mo is so lightweight the only way to be more
lightweight is to do bare OO by yourself.)

_
        },

        {
            module => 'Dist::Zilla',
            description => <<'_',

An ideal distribution builder tool, particularly if you need to develop
Dist::Zilla plugin distributions.

_
        },

    ],
};

1;
# ABSTRACT: List of modules that are described badly by PERLANCAR

__END__

=pod

=encoding UTF-8

=head1 NAME

Acme::CPANModules::DescribeAModuleBadly::PERLANCAR - List of modules that are described badly by PERLANCAR

=head1 VERSION

This document describes version 0.002 of Acme::CPANModules::DescribeAModuleBadly::PERLANCAR (from Perl distribution Acme-CPANModules-DescribeAModuleBadly-PERLANCAR), released on 2023-10-29.

=head1 ACME::CPANMODULES ENTRIES

=over

=item L<Path::Tiny>

Author: L<DAGOLDEN|https://metacpan.org/author/DAGOLDEN>

When you're bored and want to relearn crawling, standing up, walking and speech
all over again when dealing with files.


=item L<M>

Author: L<MSTROUT|https://metacpan.org/author/MSTROUT>

Remember when you want to have more than four ways to do OO, but less than six?
Yeah, me neither.

 (To be honest, I've used all L<Moose>, L<Mouse>, L<Moo>, and L<Mo> for
"real-world" purposes, and Mo is so lightweight the only way to be more
lightweight is to do bare OO by yourself.)


=item L<Dist::Zilla>

Author: L<RJBS|https://metacpan.org/author/RJBS>

An ideal distribution builder tool, particularly if you need to develop
Dist::Zilla plugin distributions.


=back

=head1 FAQ

=head2 What is an Acme::CPANModules::* module?

An Acme::CPANModules::* module, like this module, contains just a list of module
names that share a common characteristics. It is a way to categorize modules and
document CPAN. See L<Acme::CPANModules> for more details.

=head2 What are ways to use this Acme::CPANModules module?

Aside from reading this Acme::CPANModules module's POD documentation, you can
install all the listed modules (entries) using L<cpanm-cpanmodules> script (from
L<App::cpanm::cpanmodules> distribution):

 % cpanm-cpanmodules -n DescribeAModuleBadly::PERLANCAR

Alternatively you can use the L<cpanmodules> CLI (from L<App::cpanmodules>
distribution):

    % cpanmodules ls-entries DescribeAModuleBadly::PERLANCAR | cpanm -n

or L<Acme::CM::Get>:

    % perl -MAcme::CM::Get=DescribeAModuleBadly::PERLANCAR -E'say $_->{module} for @{ $LIST->{entries} }' | cpanm -n

or directly:

    % perl -MAcme::CPANModules::DescribeAModuleBadly::PERLANCAR -E'say $_->{module} for @{ $Acme::CPANModules::DescribeAModuleBadly::PERLANCAR::LIST->{entries} }' | cpanm -n

This Acme::CPANModules module also helps L<lcpan> produce a more meaningful
result for C<lcpan related-mods> command when it comes to finding related
modules for the modules listed in this Acme::CPANModules module.
See L<App::lcpan::Cmd::related_mods> for more details on how "related modules"
are found.

=head1 HOMEPAGE

Please visit the project's homepage at L<https://metacpan.org/release/Acme-CPANModules-DescribeAModuleBadly-PERLANCAR>.

=head1 SOURCE

Source repository is at L<https://github.com/perlancar/perl-Acme-CPANModules-DescribeAModuleBadly-PERLANCAR>.

=head1 SEE ALSO

L<Acme::CPANModules> - about the Acme::CPANModules namespace

L<cpanmodules> - CLI tool to let you browse/view the lists

The L<Acme::CPANModules::DescribeAModuleBadly> namespace.

=head1 AUTHOR

perlancar <perlancar@cpan.org>

=head1 CONTRIBUTING


To contribute, you can send patches by email/via RT, or send pull requests on
GitHub.

Most of the time, you don't need to build the distribution yourself. You can
simply modify the code, then test via:

 % prove -l

If you want to build the distribution (e.g. to try to install it locally on your
system), you can install L<Dist::Zilla>,
L<Dist::Zilla::PluginBundle::Author::PERLANCAR>,
L<Pod::Weaver::PluginBundle::Author::PERLANCAR>, and sometimes one or two other
Dist::Zilla- and/or Pod::Weaver plugins. Any additional steps required beyond
that are considered a bug and can be reported to me.

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2023, 2020 by perlancar <perlancar@cpan.org>.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=head1 BUGS

Please report any bugs or feature requests on the bugtracker website L<https://rt.cpan.org/Public/Dist/Display.html?Name=Acme-CPANModules-DescribeAModuleBadly-PERLANCAR>

When submitting a bug or request, please include a test-file or a
patch to an existing test-file that illustrates the bug or desired
feature.

=cut
