package Net::Async::Spotify::Object::Artist;

use strict;
use warnings;

our $VERSION = '0.002'; # VERSION
our $AUTHORITY = 'cpan:VNEALV'; # AUTHORITY

use mro;
use parent qw(Net::Async::Spotify::Object::Generated::Artist);

=encoding utf8

=head1 NAME

Net::Async::Spotify::Object::Artist - Package representing Main Spotify Artist Object

=head1 DESCRIPTION

Main module for an Autogenerated one L<Net::Async::Spotify::Object::Generated::Artist>.
Will hold all extra functionality for Spotify Artist Object

=head1 METHODS

=cut

sub to_human {
    my $self = shift;
    return join(' | ',
        $self->id,
        $self->name,
        $self->type,
        join(', ', $self->genres->@*),
        $self->popularity
    );
}

1;
