#!/usr/bin/perl

package eBay::API::XML::Call::UploadSiteHostedPictures::UploadSiteHostedPicturesResponseType;

use strict;
use warnings;  

##########################################################################
#
# Module: ............... <user defined location>eBay/API/XML
# File: ................. UploadSiteHostedPicturesResponseType.pm
# Generated by: ......... genEBayApiDataTypes.pl
# Last Generated: ....... 08/24/2008 16:44
# API Release Number: ... 579
#
##########################################################################  

=head1 NAME

eBay::API::XML::Call::UploadSiteHostedPictures::UploadSiteHostedPicturesResponseType

=head1 DESCRIPTION

Contains information about a picture upload (i.e., information about a picture
upload containing a binary attachment of an image).



=head1 SYNOPSIS

=cut


=head1 INHERITANCE

eBay::API::XML::Call::UploadSiteHostedPictures::UploadSiteHostedPicturesResponseType inherits from the L<eBay::API::XML::ResponseDataType> class

=cut

use eBay::API::XML::ResponseDataType;
our @ISA = ("eBay::API::XML::ResponseDataType");

use eBay::API::XML::DataType::SiteHostedPictureDetailsType;


my @gaProperties = ( [ 'PictureSystemVersion', 'xs:int', '', '', '' ]
	, [ 'SiteHostedPictureDetails', 'ns:SiteHostedPictureDetailsType', ''
	     ,'eBay::API::XML::DataType::SiteHostedPictureDetailsType', '1' ]
                    );
push @gaProperties, @{eBay::API::XML::ResponseDataType::getPropertiesList()};

my @gaAttributes = ( 
                    );
push @gaAttributes, @{eBay::API::XML::ResponseDataType::getAttributesList()};

=head1 Subroutines:

=cut

sub new {
  my $classname = shift;
  my %args = @_;
  my $self = $classname->SUPER::new(%args);
  return $self;
}

sub isScalar {
   return 0; 
}



=head2 setPictureSystemVersion()

Specifies the picture system version that was used to upload pictures.
Only version 2 is valid.

#    Argument: 'xs:int'

=cut

sub setPictureSystemVersion {
  my $self = shift;
  $self->{'PictureSystemVersion'} = shift
}

=head2 getPictureSystemVersion()

  Returned: Always
#    Returns: 'xs:int'

=cut

sub getPictureSystemVersion {
  my $self = shift;
  return $self->{'PictureSystemVersion'};
}


=head2 setSiteHostedPictureDetails()

Contains information about an UploadSiteHostedPictures upload,
including the URL of the uploaded picture.

#    Argument: 'ns:SiteHostedPictureDetailsType'

=cut

sub setSiteHostedPictureDetails {
  my $self = shift;
  $self->{'SiteHostedPictureDetails'} = shift
}

=head2 getSiteHostedPictureDetails()

  Returned: Always
#    Returns: 'ns:SiteHostedPictureDetailsType'

=cut

sub getSiteHostedPictureDetails {
  my $self = shift;
  return $self->_getDataTypeInstance( 'SiteHostedPictureDetails'
		,'eBay::API::XML::DataType::SiteHostedPictureDetailsType');
}





##  Attribute and Property lists
sub getPropertiesList {
   my $self = shift;
   return \@gaProperties;
}

sub getAttributesList {
   my $self = shift;
   return \@gaAttributes;
}



1;   
