#!/usr/bin/perl

package eBay::API::XML::Call::VerifyAddItem;

use strict;
use warnings;  

##########################################################################
#
# Module: ............... <user defined location>eBay/API/XML
# File: ................. VerifyAddItem.pm
# Generated by: ......... genEBayApiDataTypes.pl
# Last Generated: ....... 08/24/2008 16:44
# API Release Number: ... 579
#
##########################################################################  

=head1 NAME

eBay::API::XML::Call::VerifyAddItem

=head1 DESCRIPTION



=head1 SYNOPSIS

=cut


=head1 INHERITANCE

eBay::API::XML::Call::VerifyAddItem inherits from the L<eBay::API::XML::BaseCall> class

=cut

use eBay::API::XML::BaseCall;
our @ISA = ("eBay::API::XML::BaseCall");

use eBay::API::XML::Call::VerifyAddItem::VerifyAddItemRequestType;
use eBay::API::XML::Call::VerifyAddItem::VerifyAddItemResponseType;


=head1 Subroutines:

=cut

sub getApiCallName {
   return 'VerifyAddItem';
}
sub getRequestDataTypeFullPackage {
   return 'eBay::API::XML::Call::VerifyAddItem::VerifyAddItemRequestType';
}
sub getResponseDataTypeFullPackage {
   return 'eBay::API::XML::Call::VerifyAddItem::VerifyAddItemResponseType';
}

#
# input properties
#

=head2 setExternalProductID()

<b>Deprecated.</b> This field will be removed from the schema
in a future release. Recommended usage as of release 439 varies for
eBay.com listings and Half.com listings.
<br><br>
For eBay.com listings:
As of release 439, this field can still be passed in, but we recommend
that you update your applications to use the ExternalProductID field
defined on the item instead (i.e., Item.ExternalProductID). If you
specify both Item.ExternalProductID and this field in the same request,
eBay uses the value in Item.ExternalProductID and ignores the value in
this field. See Item.ExternalProductID for information on using an
external ID for eBay.com listings.
<br><br>
For Half.com listings:
As of release 439, this field is required for Half.com listings.
Causes Half.com to list the item with Pre-filled Item Information based on
an ISBN value or other supported external ID, plus other meta-data that
you specify. See the eBay Web Services guide for information about
listing to Half.com.

  RequiredInput: Conditionally
#    Argument: 'ns:ExternalProductIDType'

=cut
       
sub setExternalProductID {
   my $self   = shift;
   my $pExternalProductID = shift;
   $self->getRequestDataType()->setExternalProductID($pExternalProductID);
}

=head2 setIncludeExpressRequirements()

Indicates if the response should include detailed data relating to
whether an item would qualify as an Express listing. For
information about the Express-related data that can be returned
when IncludeExpressRequirements is set to true,
see the response of VerifyAddItem and see the
eBay Web Services Guide.

Default: false
SeeLink: URL: http://developer.ebay.com/DevZone/XML/docs/WebHelp/index.htm?context=eBay_XML_API&topic=ExpressListingCriteria
Title: Listing Criteria for eBay Express

  RequiredInput: No
#    Argument: 'xs:boolean'

=cut
       
sub setIncludeExpressRequirements {
   my $self   = shift;
   my $sIncludeExpressRequirements = shift;
   $self->getRequestDataType()->setIncludeExpressRequirements($sIncludeExpressRequirements);
}

=head2 setItem()

ItemType object, the properties of which define the new item listing.

  RequiredInput: Yes
#    Argument: 'ns:ItemType'

=cut
       
sub setItem {
   my $self   = shift;
   my $pItem = shift;
   $self->getRequestDataType()->setItem($pItem);
}



#
# output properties
#

=head2 getCategory2ID()

ID of the secondary category in which the item would be listed.
Only returned if you set Item.CategoryMappingAllowed to true in the request
and the ID you passed in SecondaryCategory was mapped to a new ID by eBay.
If the secondary category has not changed or it has expired with no replacement,
Category2ID does not return a value.

  Returned: Conditionally
#    Returns: 'xs:string'

=cut
       
sub getCategory2ID {
   my $self = shift;
   return $self->getResponseDataType()->getCategory2ID();
}

=head2 getCategoryID()

ID of the primary category in which the item would be listed.
Only returned if you set Item.CategoryMappingAllowed to true in the request
and the ID you passed in PrimaryCategory was mapped to a new ID by eBay.
If the primary category has not changed or it has expired with no replacement,
CategoryID does not return a value.

  Returned: Conditionally
#    Returns: 'xs:string'

=cut
       
sub getCategoryID {
   my $self = shift;
   return $self->getResponseDataType()->getCategoryID();
}

=head2 getExpressItemRequirements()

Contains details about why an item does or doesn't
qualify as an eBay Express listing. Only returned when
IncludeExpressRequirements is true the request.<br>
<br>
The item requirements are assessed in this order:<br>
- SellerExpressEligible<br>
- ExpressOptOut<br>
- ExpressApproved<br>
- All other settings

  Returned: Conditionally
#    Returns: 'ns:ExpressItemRequirementsType'

=cut
       
sub getExpressItemRequirements {
   my $self = shift;
   return $self->getResponseDataType()->getExpressItemRequirements();
}

=head2 isExpressListing()

Indicates whether the item would be listed on eBay Express.
See ExpressItemRequirements for hints about why this
value is true or false for a given item.

  Returned: Conditionally
#    Returns: 'xs:boolean'

=cut
       
sub isExpressListing {
   my $self = shift;
   return $self->getResponseDataType()->isExpressListing();
}

=head2 getFees()

Child elements contain the estimated listing fees for the new item listing.
The fees do not include the Final Value Fee (FVF), which cannot be determined
until an item is sold.

  Returned: Always
#    Returns: 'ns:FeesType'

=cut
       
sub getFees {
   my $self = shift;
   return $self->getResponseDataType()->getFees();
}

=head2 getItemID()

Represents the item ID for the new listing. VerifyAddItem does not
actually list an item, so 0 is returned instead of a normal item ID.

  Returned: Always
#    Returns: 'ns:ItemIDType'

=cut
       
sub getItemID {
   my $self = shift;
   return $self->getResponseDataType()->getItemID();
}





1;   
