#!/usr/bin/perl -w
#
#    sjis.pl
#
#    $Id: sjis.pl,v 1.2 2001/02/11 03:27:53 bstell Exp $
#
#    Copyright (c) 2000 Brian Stell
#
#    This package is free software and is provided ``as is'' without
#    express or implied warranty. It may be used, redistributed and/or
#    modified under the terms of the Perl Artistic License 
#    (see http://www.perl.com/perl/misc/Artistic.html)
#

require 5.6.0;
use strict;

use POSIX qw(locale_h errno strftime);
use Time::Local;
use utf8;

use ExtUtils::testlib;
use ICU;
use ICU::Unicode qw(:EUnicodeEnums :EUnicodeScriptGenericTypes 
                    :EUnicodeScript :EDirectionProperty :ECellWidths);
use ICU::UConverter;
use CharacterSet::SJIS;

#$CharacterSet::SJIS::DEBUG_ismbcl0 = 1;

print "<pre>\n";

my $ascii_str = 'hello';
my $Single_Only = q(0123456789!"#$%&'()=-*<>?_*+:;@ABCGHIJKLMXYZaopqrstuvwxyz);
my $Mixed_Singlebyte_Katakana = 'ｱｲｳｴｵﾜｵﾝ';

my $_1_N_1_Normal_Single_Only               = '0123456789!"#$%&\'()=-*<>?_*+:;@ABCGHIJKLMXYZaopqrstuvwxyz';
my $_1_E_1_Error_Mixed_Singlebyte_Katakana  = 'ｱｲｳｴｵﾜｵﾝ';
my $_1_E_2_Error_Mixed_Doublebyte_Katakana  = 'アイウエオ';
my $_1_E_3_Error_Mixed_Doublebyte_NonKanji  = 'Ａ１あア●√';
my $_1_E_4_Error_Mixed_JIS_Level1           = '日本';
my $_1_E_5_Error_Mixed_JIS_Level2           = '梵ⅸ';
my $_1_E_6_Error_Mixed_Other                = '℡髙';

my $_2_N_1_Normal_Single_Only                     = '0123456789!"#$%&\'()=-*<>?_*+:;@ABCGHIJKLMXYZaopqrstuvwxyz';
my $_2_N_2_Normal                                 = 'ＤＯＵＢＬＥ　ＯＮＬＹ Ａ１あア●√　漢字';
my $_2_N_3_Normal_Mixed_Db_Katakana               = 'アイウエオ';
my $_2_N_4_Normal_Mixed_Db_NonKanji               = 'Ａ１あア●√';
my $_2_N_5_Normal_Mixed_Db_NonKanji_JIS_L1        = 'Ａ１あア●√　日本';
my $_2_N_6_Normal_Mixed_Db_NonKanji_JIS_L1_JIS_L2 = 'Ａ１あア●√　日本　梵ⅸ';
my $_2_E_1_Error_Mixed_Singlebyte_Katakana        = 'ｱｲｳｴｵﾜｵﾝ';
my $_2_E_2_Error_Mixed_Double_Singlebyte_Katakana = 'アイウエオｱｲｳｴｵﾜｵﾝ';
my $_2_E_3_Error_Mixed_Other                      = '℡髙';

my $_3_N_1_Normal                           = 'アイウエオワオンパバ';
my $_3_E_1_Error_Single_Only                = '0123456789!"#$%&\'()=-*<>?_*+:;@ABCGHIJKLMXYZaopqrstuvwxyz';
my $_3_E_2_Error                            = 'ＤＯＵＢＬＥ　ＯＮＬＹ Ａ１あア●√　漢字';
my $_3_E_3_Error                            = 'アイウエオMixed Single Byte';
my $_3_E_4_Error                            = 'Ａ１あア●√';
my $_3_E_5_Error                            = 'アイウエオ日本';
my $_3_E_6_Error                            = 'アイウエオ梵ⅸ';
my $_3_E_7_Error                            = 'アイウエオｱｲｳｴｵﾜｵﾝ';
my $_3_E_8_Error                            = 'アイウエオ℡髙';

my $cs = new CharacterSet::SJIS;

show_sjis_type('ascii', $ascii_str);
show_sjis_type('_1_N_1_Normal_Single_Only', $_1_N_1_Normal_Single_Only);
show_sjis_type('_1_E_1_Error_Mixed_Singlebyte_Katakana', $_1_E_1_Error_Mixed_Singlebyte_Katakana);
show_sjis_type('_1_E_2_Error_Mixed_Doublebyte_Katakana', $_1_E_2_Error_Mixed_Doublebyte_Katakana);
show_sjis_type('_1_E_3_Error_Mixed_Doublebyte_NonKanji', $_1_E_3_Error_Mixed_Doublebyte_NonKanji);
show_sjis_type('_1_E_4_Error_Mixed_JIS_Level1', $_1_E_4_Error_Mixed_JIS_Level1);
show_sjis_type('_1_E_5_Error_Mixed_JIS_Level2', $_1_E_5_Error_Mixed_JIS_Level2);
show_sjis_type('_1_E_6_Error_Mixed_Other', $_1_E_6_Error_Mixed_Other);
show_sjis_type('_2_N_1_Normal_Single_Only', $_2_N_1_Normal_Single_Only);
show_sjis_type('_2_N_2_Normal', $_2_N_2_Normal);
show_sjis_type('_2_N_3_Normal_Mixed_Db_Katakana', $_2_N_3_Normal_Mixed_Db_Katakana);
show_sjis_type('_2_N_4_Normal_Mixed_Db_NonKanji', $_2_N_4_Normal_Mixed_Db_NonKanji);
show_sjis_type('_2_N_5_Normal_Mixed_Db_NonKanji_JIS_L1', $_2_N_5_Normal_Mixed_Db_NonKanji_JIS_L1);
show_sjis_type('_2_N_6_Normal_Mixed_Db_NonKanji_JIS_L1_JIS_L2', $_2_N_6_Normal_Mixed_Db_NonKanji_JIS_L1_JIS_L2);
show_sjis_type('_2_E_1_Error_Mixed_Singlebyte_Katakana', $_2_E_1_Error_Mixed_Singlebyte_Katakana);
show_sjis_type('_2_E_2_Error_Mixed_Double_Singlebyte_Katakana', $_2_E_2_Error_Mixed_Double_Singlebyte_Katakana);
show_sjis_type('_2_E_3_Error_Mixed_Other', $_2_E_3_Error_Mixed_Other);
show_sjis_type('_3_N_1_Normal', $_3_N_1_Normal);
show_sjis_type('_3_E_1_Error_Single_Only', $_3_E_1_Error_Single_Only);
show_sjis_type('_3_E_2_Error', $_3_E_2_Error);
show_sjis_type('_3_E_3_Error', $_3_E_3_Error);
show_sjis_type('_3_E_4_Error', $_3_E_4_Error);
show_sjis_type('_3_E_5_Error', $_3_E_5_Error);
show_sjis_type('_3_E_6_Error', $_3_E_6_Error);
show_sjis_type('_3_E_7_Error', $_3_E_7_Error);
show_sjis_type('_3_E_8_Error', $_3_E_8_Error);
#show_sjis_type('x', $x);

sub show_sjis_type {
  my ($name, $utf8_str) = @_;
  print "$name ($utf8_str):\n";
  if ($cs->_ismbcalnum($utf8_str)) {
      print "    is alnum\n";
  }
  else {
      print "    is not alnum\n";
  }
  if ($cs->_ismbckata($utf8_str)) {
      print "    is kata\n";
  }
  else {
      print "    is not kata\n";
  }
  if ($cs->_ismbcl0($utf8_str)) {
      print "    is l0\n";
  }
  else {
      print "    is not l0\n";
  }
  if ($cs->_ismbcl1($utf8_str)) {
      print "    is l1\n";
  }
  else {
      print "    is not l2\n";
  }
  if ($cs->_ismbcl2($utf8_str)) {
      print "    is l2\n";
  }
  else {
      print "    is not l2\n";
  }
}

print "</pre>\n";


exit(0);
