#============================================================= -*-Perl-*-
#
# Jemplate::Grammar
#
# DESCRIPTION
#   Grammar file for the Template Toolkit language containing token
#   definitions and parser state/rules tables generated by Parse::Yapp.
#
# AUTHOR
#   Ingy döt Net   <ingy@cpan.org>
#
# ORIGINAL AUTHOR
#   Andy Wardley   <abw@kfs.org>
#
# COPYRIGHT
#   Copyright (C) 2006-2008 Ingy döt Net.
#   Copyright (C) 1996-2000 Andy Wardley.
#   Copyright (C) 1998-2000 Canon Research Centre Europe Ltd.
#
#   This module is free software; you can redistribute it and/or
#   modify it under the same terms as Perl itself.
#
#------------------------------------------------------------------------
#
# NOTE: this module is constructed from the parser/Grammar.pm.skel
# file by running the parser/yc script.  You only need to do this if 
# you have modified the grammar in the parser/Parser.yp file and need
# to-recompile it.  See the README in the 'parser' directory for more
# information (sub-directory of the Jemplate distribution).
#
#========================================================================

package Jemplate::Grammar;

require 5.004;

use strict;
use vars qw( $VERSION );

$VERSION  = sprintf("%d.%02d", q$Revision: 2.10 $ =~ /(\d+)\.(\d+)/);

my (@RESERVED, %CMPOP, $LEXTABLE, $RULES, $STATES);
my ($factory, $rawstart);


#========================================================================
# Reserved words, comparison and binary operators
#========================================================================

@RESERVED = qw( 
	GET CALL SET DEFAULT INSERT INCLUDE PROCESS WRAPPER BLOCK END
	USE RAW PLUGIN FILTER MACRO JAVASCRIPT TO STEP AND OR NOT DIV MOD
	IF UNLESS ELSE ELSIF FOR NEXT WHILE SWITCH CASE META IN
	TRY THROW CATCH FINAL LAST RETURN STOP CLEAR VIEW DEBUG
    );

# for historical reasons, != and == are converted to ne and eq to perform 
# stringwise comparison (mainly because it doesn't generate "non-numerical 
# comparison" warnings which != and == can) but the others (e.g. < > <= >=)
# are not converted to their stringwise equivalents.  I added 'gt' et al, 
# briefly for v2.04d and then took them out again in 2.04e.

%CMPOP = qw( 
    != !=
    == ==
    <  <
    >  >
    >= >=
    <= <=
);


#========================================================================
# Lexer Token Table
#========================================================================

# lookup table used by lexer is initialised with special-cases
$LEXTABLE = {
    'FOREACH' => 'FOR',
    'BREAK'   => 'LAST',
    '&&'      => 'AND',
    '||'      => 'OR',
    '!'       => 'NOT',
    '|'	      => 'FILTER',
    '.'       => 'DOT',
    '_'       => 'CAT',
    '..'      => 'TO',
#    ':'       => 'MACRO',
    '='       => 'ASSIGN',
    '=>'      => 'ASSIGN',
#    '->'      => 'ARROW',
    ','       => 'COMMA',
    '\\'      => 'REF',
    'and'     => 'AND',		# explicitly specified so that qw( and or
    'or'      => 'OR',		# not ) can always be used in lower case, 
    'not'     => 'NOT',		# regardless of ANYCASE flag
    'mod'     => 'MOD',
    'div'     => 'DIV',
};

# localise the temporary variables needed to complete lexer table
{ 
#    my @tokens = qw< ( ) [ ] { } ${ $ / ; : ? >;
    my @tokens = qw< ( ) [ ] { } ${ $ + / ; : ? >;
    my @cmpop  = keys %CMPOP;
#    my @binop  = qw( + - * % );              # '/' above, in @tokens
    my @binop  = qw( - * % );              # '+' and '/' above, in @tokens

    # fill lexer table, slice by slice, with reserved words and operators
    @$LEXTABLE{ @RESERVED, @cmpop, @binop, @tokens } 
	= ( @RESERVED, ('CMPOP') x @cmpop, ('BINOP') x @binop, @tokens );
}


#========================================================================
# CLASS METHODS
#========================================================================

sub new {
    my $class = shift;
    bless {
	LEXTABLE => $LEXTABLE,
	STATES   => $STATES,
	RULES    => $RULES,
    }, $class;
}

# update method to set package-scoped $factory lexical 
sub install_factory {
    my ($self, $new_factory) = @_;
    $factory = $new_factory;
}


#========================================================================
# States
#========================================================================

$STATES = [
	{#State 0
		ACTIONS => {
			'SET' => 1,
			'NOT' => 40,
			'IDENT' => 2,
			'CLEAR' => 42,
			'UNLESS' => 4,
			'IF' => 45,
			"\$" => 44,
			'STOP' => 7,
			'CALL' => 46,
			'THROW' => 9,
			'GET' => 48,
			"[" => 10,
			'TRY' => 11,
			'LAST' => 50,
			'DEBUG' => 52,
			'META' => 15,
			'INCLUDE' => 17,
			"(" => 54,
			'SWITCH' => 55,
			'MACRO' => 18,
			'JAVASCRIPT' => 56,
			'WRAPPER' => 57,
			";" => -19,
			'FOR' => 21,
			'LITERAL' => 59,
			'NEXT' => 22,
			'rawperl' => 61,
			"\"" => 62,
			'TEXT' => 24,
			'PROCESS' => 63,
			'RETURN' => 66,
			'FILTER' => 25,
			'INSERT' => 67,
			'NUMBER' => 26,
			'REF' => 27,
			'WHILE' => 69,
			'RAW' => 28,
			'BLOCK' => 29,
			'DEFAULT' => 71,
			"{" => 31,
			'perl' => 32,
			'USE' => 33,
			'VIEW' => 37,
			"\${" => 38
		},
		DEFAULT => -3,
		GOTOS => {
			'item' => 41,
			'javascript' => 3,
			'loop' => 5,
			'capture' => 43,
			'statement' => 6,
			'view' => 8,
			'wrapper' => 47,
			'atomexpr' => 49,
			'chunk' => 12,
			'atomdir' => 13,
			'anonblock' => 51,
			'template' => 53,
			'defblockname' => 14,
			'ident' => 16,
			'assign' => 19,
			'macro' => 20,
			'lterm' => 58,
			'node' => 23,
			'term' => 60,
			'expr' => 64,
			'use' => 65,
			'defblock' => 68,
			'filter' => 30,
			'sterm' => 70,
			'chunks' => 34,
			'setlist' => 72,
			'try' => 36,
			'switch' => 35,
			'directive' => 73,
			'block' => 74,
			'raw' => 39,
			'condition' => 75
		}
	},
	{#State 1
		ACTIONS => {
			"\$" => 44,
			'LITERAL' => 77,
			'IDENT' => 2,
			"\${" => 38
		},
		GOTOS => {
			'setlist' => 78,
			'item' => 41,
			'assign' => 19,
			'node' => 23,
			'ident' => 76
		}
	},
	{#State 2
		DEFAULT => -131
	},
	{#State 3
		DEFAULT => -26
	},
	{#State 4
		ACTIONS => {
			'NOT' => 40,
			"{" => 31,
			'LITERAL' => 80,
			'IDENT' => 2,
			"\"" => 62,
			"(" => 54,
			"\$" => 44,
			"[" => 10,
			'NUMBER' => 26,
			'REF' => 27,
			"\${" => 38
		},
		GOTOS => {
			'expr' => 81,
			'sterm' => 70,
			'item' => 41,
			'node' => 23,
			'ident' => 79,
			'term' => 60,
			'lterm' => 58
		}
	},
	{#State 5
		DEFAULT => -24
	},
	{#State 6
		ACTIONS => {
			";" => 82
		}
	},
	{#State 7
		DEFAULT => -39
	},
	{#State 8
		DEFAULT => -15
	},
	{#State 9
		ACTIONS => {
			"\"" => 91,
			"\$" => 88,
			'LITERAL' => 90,
			'FILENAME' => 85,
			'IDENT' => 83,
			'NUMBER' => 86
		},
		GOTOS => {
			'filepart' => 89,
			'names' => 93,
			'nameargs' => 92,
			'filename' => 87,
			'name' => 84
		}
	},
	{#State 10
		ACTIONS => {
			"{" => 31,
			'LITERAL' => 80,
			'IDENT' => 2,
			"\"" => 62,
			"\$" => 44,
			"[" => 10,
			'NUMBER' => 26,
			'REF' => 27,
			"]" => 96,
			"\${" => 38
		},
		GOTOS => {
			'sterm' => 98,
			'item' => 41,
			'range' => 95,
			'node' => 23,
			'ident' => 79,
			'term' => 97,
			'lterm' => 58,
			'list' => 94
		}
	},
	{#State 11
		ACTIONS => {
			";" => 99
		}
	},
	{#State 12
		DEFAULT => -5
	},
	{#State 13
		ACTIONS => {
			";" => -21
		},
		DEFAULT => -29
	},
	{#State 14
		ACTIONS => {
			'IDENT' => 100
		},
		DEFAULT => -88,
		GOTOS => {
			'blockargs' => 103,
			'metadata' => 102,
			'meta' => 101
		}
	},
	{#State 15
		ACTIONS => {
			'IDENT' => 100
		},
		GOTOS => {
			'metadata' => 104,
			'meta' => 101
		}
	},
	{#State 16
		ACTIONS => {
			'DOT' => 105,
			'ASSIGN' => 106
		},
		DEFAULT => -110
	},
	{#State 17
		ACTIONS => {
			"\"" => 91,
			"\$" => 88,
			'LITERAL' => 90,
			'FILENAME' => 85,
			'IDENT' => 83,
			'NUMBER' => 86
		},
		GOTOS => {
			'filepart' => 89,
			'names' => 93,
			'nameargs' => 107,
			'filename' => 87,
			'name' => 84
		}
	},
	{#State 18
		ACTIONS => {
			'IDENT' => 108
		}
	},
	{#State 19
		DEFAULT => -150
	},
	{#State 20
		DEFAULT => -12
	},
	{#State 21
		ACTIONS => {
			"{" => 31,
			'LITERAL' => 80,
			'IDENT' => 109,
			"\"" => 62,
			"\$" => 44,
			"[" => 10,
			'NUMBER' => 26,
			'REF' => 27,
			"\${" => 38
		},
		GOTOS => {
			'sterm' => 70,
			'item' => 41,
			'loopvar' => 111,
			'node' => 23,
			'ident' => 79,
			'term' => 110,
			'lterm' => 58
		}
	},
	{#State 22
		DEFAULT => -42
	},
	{#State 23
		DEFAULT => -128
	},
	{#State 24
		DEFAULT => -6
	},
	{#State 25
		ACTIONS => {
			"\"" => 118,
			"\$" => 115,
			'LITERAL' => 117,
			'FILENAME' => 85,
			'IDENT' => 112,
			'NUMBER' => 86,
			"\${" => 38
		},
		GOTOS => {
			'names' => 93,
			'lvalue' => 113,
			'item' => 114,
			'name' => 84,
			'filepart' => 89,
			'filename' => 87,
			'nameargs' => 119,
			'lnameargs' => 116
		}
	},
	{#State 26
		DEFAULT => -114
	},
	{#State 27
		ACTIONS => {
			"\$" => 44,
			'IDENT' => 2,
			"\${" => 38
		},
		GOTOS => {
			'item' => 41,
			'node' => 23,
			'ident' => 120
		}
	},
	{#State 28
		ACTIONS => {
			"\"" => 118,
			"\$" => 115,
			'LITERAL' => 117,
			'FILENAME' => 85,
			'IDENT' => 112,
			'NUMBER' => 86,
			"\${" => 38
		},
		GOTOS => {
			'names' => 93,
			'lvalue' => 113,
			'item' => 114,
			'name' => 84,
			'filepart' => 89,
			'filename' => 87,
			'nameargs' => 119,
			'lnameargs' => 121
		}
	},
	{#State 29
		ACTIONS => {
			'LITERAL' => 126,
			'FILENAME' => 85,
			'IDENT' => 122,
			'NUMBER' => 86
		},
		DEFAULT => -88,
		GOTOS => {
			'blockargs' => 125,
			'filepart' => 89,
			'filename' => 124,
			'blockname' => 123,
			'metadata' => 102,
			'meta' => 101
		}
	},
	{#State 30
		DEFAULT => -45
	},
	{#State 31
		ACTIONS => {
			"\$" => 44,
			'LITERAL' => 131,
			'IDENT' => 2,
			"\${" => 38
		},
		DEFAULT => -120,
		GOTOS => {
			'params' => 130,
			'hash' => 127,
			'item' => 128,
			'param' => 129
		}
	},
	{#State 32
		DEFAULT => -27
	},
	{#State 33
		ACTIONS => {
			"\"" => 118,
			"\$" => 115,
			'LITERAL' => 117,
			'FILENAME' => 85,
			'IDENT' => 112,
			'NUMBER' => 86,
			"\${" => 38
		},
		GOTOS => {
			'names' => 93,
			'lvalue' => 113,
			'item' => 114,
			'name' => 84,
			'filepart' => 89,
			'filename' => 87,
			'nameargs' => 119,
			'lnameargs' => 132
		}
	},
	{#State 34
		ACTIONS => {
			'SET' => 1,
			'NOT' => 40,
			'IDENT' => 2,
			'CLEAR' => 42,
			'UNLESS' => 4,
			'IF' => 45,
			"\$" => 44,
			'STOP' => 7,
			'CALL' => 46,
			'THROW' => 9,
			'GET' => 48,
			"[" => 10,
			'TRY' => 11,
			'LAST' => 50,
			'DEBUG' => 52,
			'META' => 15,
			'INCLUDE' => 17,
			"(" => 54,
			'SWITCH' => 55,
			'MACRO' => 18,
			'JAVASCRIPT' => 56,
			'WRAPPER' => 57,
			";" => -19,
			'FOR' => 21,
			'LITERAL' => 59,
			'NEXT' => 22,
			'rawperl' => 61,
			"\"" => 62,
			'TEXT' => 24,
			'PROCESS' => 63,
			'RETURN' => 66,
			'FILTER' => 25,
			'INSERT' => 67,
			'NUMBER' => 26,
			'REF' => 27,
			'WHILE' => 69,
			'RAW' => 28,
			'BLOCK' => 29,
			'DEFAULT' => 71,
			"{" => 31,
			'perl' => 32,
			'USE' => 33,
			'VIEW' => 37,
			"\${" => 38
		},
		DEFAULT => -2,
		GOTOS => {
			'item' => 41,
			'javascript' => 3,
			'node' => 23,
			'term' => 60,
			'loop' => 5,
			'use' => 65,
			'expr' => 64,
			'capture' => 43,
			'statement' => 6,
			'view' => 8,
			'wrapper' => 47,
			'atomexpr' => 49,
			'chunk' => 133,
			'defblock' => 68,
			'atomdir' => 13,
			'anonblock' => 51,
			'sterm' => 70,
			'defblockname' => 14,
			'filter' => 30,
			'ident' => 16,
			'setlist' => 72,
			'try' => 36,
			'switch' => 35,
			'assign' => 19,
			'directive' => 73,
			'macro' => 20,
			'condition' => 75,
			'lterm' => 58,
			'raw' => 39
		}
	},
	{#State 35
		DEFAULT => -23
	},
	{#State 36
		DEFAULT => -25
	},
	{#State 37
		ACTIONS => {
			"\"" => 91,
			"\$" => 88,
			'LITERAL' => 90,
			'FILENAME' => 85,
			'IDENT' => 83,
			'NUMBER' => 86
		},
		GOTOS => {
			'filepart' => 89,
			'names' => 93,
			'nameargs' => 134,
			'filename' => 87,
			'name' => 84
		}
	},
	{#State 38
		ACTIONS => {
			"\"" => 62,
			"\$" => 44,
			'LITERAL' => 80,
			'IDENT' => 2,
			'REF' => 27,
			'NUMBER' => 26,
			"\${" => 38
		},
		GOTOS => {
			'sterm' => 135,
			'item' => 41,
			'node' => 23,
			'ident' => 79
		}
	},
	{#State 39
		DEFAULT => -14
	},
	{#State 40
		ACTIONS => {
			'NOT' => 40,
			"{" => 31,
			'LITERAL' => 80,
			'IDENT' => 2,
			"\"" => 62,
			"(" => 54,
			"\$" => 44,
			"[" => 10,
			'NUMBER' => 26,
			'REF' => 27,
			"\${" => 38
		},
		GOTOS => {
			'expr' => 136,
			'sterm' => 70,
			'item' => 41,
			'node' => 23,
			'ident' => 79,
			'term' => 60,
			'lterm' => 58
		}
	},
	{#State 41
		ACTIONS => {
			"(" => 137
		},
		DEFAULT => -129
	},
	{#State 42
		DEFAULT => -40
	},
	{#State 43
		DEFAULT => -11
	},
	{#State 44
		ACTIONS => {
			'IDENT' => 138
		}
	},
	{#State 45
		ACTIONS => {
			'NOT' => 40,
			"{" => 31,
			'LITERAL' => 80,
			'IDENT' => 2,
			"\"" => 62,
			"(" => 54,
			"\$" => 44,
			"[" => 10,
			'NUMBER' => 26,
			'REF' => 27,
			"\${" => 38
		},
		GOTOS => {
			'expr' => 139,
			'sterm' => 70,
			'item' => 41,
			'node' => 23,
			'ident' => 79,
			'term' => 60,
			'lterm' => 58
		}
	},
	{#State 46
		ACTIONS => {
			'NOT' => 40,
			"{" => 31,
			'LITERAL' => 80,
			'IDENT' => 2,
			"\"" => 62,
			"(" => 54,
			"\$" => 44,
			"[" => 10,
			'NUMBER' => 26,
			'REF' => 27,
			"\${" => 38
		},
		GOTOS => {
			'expr' => 140,
			'sterm' => 70,
			'item' => 41,
			'node' => 23,
			'ident' => 79,
			'term' => 60,
			'lterm' => 58
		}
	},
	{#State 47
		DEFAULT => -44
	},
	{#State 48
		ACTIONS => {
			'NOT' => 40,
			"{" => 31,
			'LITERAL' => 80,
			'IDENT' => 2,
			"\"" => 62,
			"(" => 54,
			"\$" => 44,
			"[" => 10,
			'NUMBER' => 26,
			'REF' => 27,
			"\${" => 38
		},
		GOTOS => {
			'expr' => 141,
			'sterm' => 70,
			'item' => 41,
			'node' => 23,
			'ident' => 79,
			'term' => 60,
			'lterm' => 58
		}
	},
	{#State 49
		ACTIONS => {
			'IF' => 145,
			'FILTER' => 144,
			'FOR' => 143,
			'WHILE' => 147,
			'WRAPPER' => 146,
			'UNLESS' => 142
		}
	},
	{#State 50
		DEFAULT => -41
	},
	{#State 51
		DEFAULT => -10
	},
	{#State 52
		ACTIONS => {
			"\"" => 91,
			"\$" => 88,
			'LITERAL' => 90,
			'FILENAME' => 85,
			'IDENT' => 83,
			'NUMBER' => 86
		},
		GOTOS => {
			'filepart' => 89,
			'names' => 93,
			'nameargs' => 148,
			'filename' => 87,
			'name' => 84
		}
	},
	{#State 53
		ACTIONS => {
			'' => 149
		}
	},
	{#State 54
		ACTIONS => {
			'NOT' => 40,
			"{" => 31,
			'LITERAL' => 59,
			'IDENT' => 2,
			"\"" => 62,
			"(" => 54,
			"\$" => 44,
			"[" => 10,
			'NUMBER' => 26,
			'REF' => 27,
			"\${" => 38
		},
		GOTOS => {
			'expr' => 152,
			'sterm' => 70,
			'item' => 41,
			'assign' => 151,
			'node' => 23,
			'ident' => 150,
			'term' => 60,
			'lterm' => 58
		}
	},
	{#State 55
		ACTIONS => {
			'NOT' => 40,
			"{" => 31,
			'LITERAL' => 80,
			'IDENT' => 2,
			"\"" => 62,
			"(" => 54,
			"\$" => 44,
			"[" => 10,
			'NUMBER' => 26,
			'REF' => 27,
			"\${" => 38
		},
		GOTOS => {
			'expr' => 153,
			'sterm' => 70,
			'item' => 41,
			'node' => 23,
			'ident' => 79,
			'term' => 60,
			'lterm' => 58
		}
	},
	{#State 56
		ACTIONS => {
			";" => 154
		}
	},
	{#State 57
		ACTIONS => {
			"\"" => 91,
			"\$" => 88,
			'LITERAL' => 90,
			'FILENAME' => 85,
			'IDENT' => 83,
			'NUMBER' => 86
		},
		GOTOS => {
			'filepart' => 89,
			'names' => 93,
			'nameargs' => 155,
			'filename' => 87,
			'name' => 84
		}
	},
	{#State 58
		DEFAULT => -104
	},
	{#State 59
		ACTIONS => {
			'ASSIGN' => 156
		},
		DEFAULT => -113
	},
	{#State 60
		DEFAULT => -147
	},
	{#State 61
		DEFAULT => -16
	},
	{#State 62
		DEFAULT => -177,
		GOTOS => {
			'quoted' => 157
		}
	},
	{#State 63
		ACTIONS => {
			"\"" => 91,
			"\$" => 88,
			'LITERAL' => 90,
			'FILENAME' => 85,
			'IDENT' => 83,
			'NUMBER' => 86
		},
		GOTOS => {
			'filepart' => 89,
			'names' => 93,
			'nameargs' => 158,
			'filename' => 87,
			'name' => 84
		}
	},
	{#State 64
		ACTIONS => {
			";" => -17,
			"+" => 159,
			'CAT' => 165,
			'CMPOP' => 166,
			"?" => 160,
			'DIV' => 161,
			'MOD' => 167,
			"/" => 168,
			'AND' => 162,
			'BINOP' => 163,
			'OR' => 164
		},
		DEFAULT => -28
	},
	{#State 65
		DEFAULT => -13
	},
	{#State 66
		DEFAULT => -38
	},
	{#State 67
		ACTIONS => {
			"\"" => 91,
			"\$" => 88,
			'LITERAL' => 90,
			'FILENAME' => 85,
			'IDENT' => 83,
			'NUMBER' => 86
		},
		GOTOS => {
			'filepart' => 89,
			'names' => 93,
			'nameargs' => 169,
			'filename' => 87,
			'name' => 84
		}
	},
	{#State 68
		DEFAULT => -9
	},
	{#State 69
		ACTIONS => {
			'NOT' => 40,
			"{" => 31,
			'LITERAL' => 80,
			'IDENT' => 2,
			"\"" => 62,
			"(" => 54,
			"\$" => 44,
			"[" => 10,
			'NUMBER' => 26,
			'REF' => 27,
			"\${" => 38
		},
		GOTOS => {
			'expr' => 170,
			'sterm' => 70,
			'item' => 41,
			'node' => 23,
			'ident' => 79,
			'term' => 60,
			'lterm' => 58
		}
	},
	{#State 70
		DEFAULT => -105
	},
	{#State 71
		ACTIONS => {
			"\$" => 44,
			'LITERAL' => 77,
			'IDENT' => 2,
			"\${" => 38
		},
		GOTOS => {
			'setlist' => 171,
			'item' => 41,
			'assign' => 19,
			'node' => 23,
			'ident' => 76
		}
	},
	{#State 72
		ACTIONS => {
			"\$" => 44,
			'COMMA' => 173,
			'LITERAL' => 77,
			'IDENT' => 2,
			"\${" => 38
		},
		DEFAULT => -20,
		GOTOS => {
			'item' => 41,
			'assign' => 172,
			'node' => 23,
			'ident' => 76
		}
	},
	{#State 73
		DEFAULT => -8
	},
	{#State 74
		DEFAULT => -1
	},
	{#State 75
		DEFAULT => -22
	},
	{#State 76
		ACTIONS => {
			'ASSIGN' => 174,
			'DOT' => 105
		}
	},
	{#State 77
		ACTIONS => {
			'ASSIGN' => 156
		}
	},
	{#State 78
		ACTIONS => {
			'COMMA' => 173,
			'LITERAL' => 77,
			'IDENT' => 2,
			"\$" => 44,
			"\${" => 38
		},
		DEFAULT => -32,
		GOTOS => {
			'item' => 41,
			'assign' => 172,
			'node' => 23,
			'ident' => 76
		}
	},
	{#State 79
		ACTIONS => {
			'DOT' => 105
		},
		DEFAULT => -110
	},
	{#State 80
		DEFAULT => -113
	},
	{#State 81
		ACTIONS => {
			'CMPOP' => 166,
			"?" => 160,
			";" => 175,
			"+" => 159,
			'MOD' => 167,
			'DIV' => 161,
			"/" => 168,
			'AND' => 162,
			'CAT' => 165,
			'BINOP' => 163,
			'OR' => 164
		}
	},
	{#State 82
		DEFAULT => -7
	},
	{#State 83
		DEFAULT => -174
	},
	{#State 84
		DEFAULT => -167
	},
	{#State 85
		DEFAULT => -173
	},
	{#State 86
		DEFAULT => -175
	},
	{#State 87
		ACTIONS => {
			'DOT' => 176
		},
		DEFAULT => -169
	},
	{#State 88
		ACTIONS => {
			"\$" => 44,
			'IDENT' => 2,
			"\${" => 38
		},
		GOTOS => {
			'item' => 41,
			'node' => 23,
			'ident' => 177
		}
	},
	{#State 89
		DEFAULT => -172
	},
	{#State 90
		DEFAULT => -170
	},
	{#State 91
		DEFAULT => -177,
		GOTOS => {
			'quoted' => 178
		}
	},
	{#State 92
		DEFAULT => -37
	},
	{#State 93
		ACTIONS => {
			"+" => 179,
			"(" => 180
		},
		DEFAULT => -157,
		GOTOS => {
			'args' => 181
		}
	},
	{#State 94
		ACTIONS => {
			"{" => 31,
			'COMMA' => 184,
			'LITERAL' => 80,
			'IDENT' => 2,
			"\"" => 62,
			"\$" => 44,
			"[" => 10,
			'NUMBER' => 26,
			'REF' => 27,
			"]" => 182,
			"\${" => 38
		},
		GOTOS => {
			'sterm' => 70,
			'item' => 41,
			'node' => 23,
			'ident' => 79,
			'term' => 183,
			'lterm' => 58
		}
	},
	{#State 95
		ACTIONS => {
			"]" => 185
		}
	},
	{#State 96
		DEFAULT => -108
	},
	{#State 97
		DEFAULT => -117
	},
	{#State 98
		ACTIONS => {
			'TO' => 186
		},
		DEFAULT => -105
	},
	{#State 99
		ACTIONS => {
			'SET' => 1,
			'NOT' => 40,
			'IDENT' => 2,
			'CLEAR' => 42,
			'UNLESS' => 4,
			'IF' => 45,
			"\$" => 44,
			'STOP' => 7,
			'CALL' => 46,
			'THROW' => 9,
			'GET' => 48,
			"[" => 10,
			'TRY' => 11,
			'LAST' => 50,
			'DEBUG' => 52,
			'META' => 15,
			'INCLUDE' => 17,
			"(" => 54,
			'SWITCH' => 55,
			'MACRO' => 18,
			'JAVASCRIPT' => 56,
			'WRAPPER' => 57,
			";" => -19,
			'FOR' => 21,
			'LITERAL' => 59,
			'NEXT' => 22,
			'rawperl' => 61,
			"\"" => 62,
			'TEXT' => 24,
			'PROCESS' => 63,
			'RETURN' => 66,
			'FILTER' => 25,
			'INSERT' => 67,
			'NUMBER' => 26,
			'REF' => 27,
			'WHILE' => 69,
			'RAW' => 28,
			'BLOCK' => 29,
			'DEFAULT' => 71,
			"{" => 31,
			'perl' => 32,
			'USE' => 33,
			'VIEW' => 37,
			"\${" => 38
		},
		DEFAULT => -3,
		GOTOS => {
			'item' => 41,
			'javascript' => 3,
			'node' => 23,
			'term' => 60,
			'loop' => 5,
			'use' => 65,
			'expr' => 64,
			'capture' => 43,
			'statement' => 6,
			'view' => 8,
			'wrapper' => 47,
			'atomexpr' => 49,
			'chunk' => 12,
			'defblock' => 68,
			'atomdir' => 13,
			'anonblock' => 51,
			'sterm' => 70,
			'defblockname' => 14,
			'filter' => 30,
			'ident' => 16,
			'setlist' => 72,
			'chunks' => 34,
			'try' => 36,
			'switch' => 35,
			'assign' => 19,
			'block' => 187,
			'directive' => 73,
			'macro' => 20,
			'condition' => 75,
			'lterm' => 58,
			'raw' => 39
		}
	},
	{#State 100
		ACTIONS => {
			'ASSIGN' => 188
		}
	},
	{#State 101
		DEFAULT => -100
	},
	{#State 102
		ACTIONS => {
			'COMMA' => 190,
			'IDENT' => 100
		},
		DEFAULT => -87,
		GOTOS => {
			'meta' => 189
		}
	},
	{#State 103
		ACTIONS => {
			";" => 191
		}
	},
	{#State 104
		ACTIONS => {
			'COMMA' => 190,
			'IDENT' => 100
		},
		DEFAULT => -18,
		GOTOS => {
			'meta' => 189
		}
	},
	{#State 105
		ACTIONS => {
			"\$" => 44,
			'IDENT' => 2,
			'NUMBER' => 193,
			"\${" => 38
		},
		GOTOS => {
			'item' => 41,
			'node' => 192
		}
	},
	{#State 106
		ACTIONS => {
			'SET' => 1,
			'NOT' => 40,
			'IDENT' => 2,
			'CLEAR' => 42,
			'UNLESS' => 4,
			'IF' => 45,
			"\$" => 44,
			'STOP' => 7,
			'CALL' => 46,
			'THROW' => 9,
			'GET' => 48,
			"[" => 10,
			'TRY' => 11,
			'LAST' => 50,
			'DEBUG' => 52,
			'INCLUDE' => 17,
			"(" => 54,
			'SWITCH' => 55,
			'JAVASCRIPT' => 56,
			'WRAPPER' => 57,
			'FOR' => 21,
			'NEXT' => 22,
			'LITERAL' => 59,
			"\"" => 62,
			'PROCESS' => 63,
			'FILTER' => 25,
			'RETURN' => 66,
			'INSERT' => 67,
			'NUMBER' => 26,
			'REF' => 27,
			'WHILE' => 69,
			'BLOCK' => 194,
			'DEFAULT' => 71,
			"{" => 31,
			'perl' => 32,
			"\${" => 38
		},
		GOTOS => {
			'item' => 41,
			'javascript' => 3,
			'node' => 23,
			'term' => 60,
			'loop' => 5,
			'expr' => 196,
			'wrapper' => 47,
			'atomexpr' => 49,
			'atomdir' => 13,
			'mdir' => 195,
			'filter' => 30,
			'sterm' => 70,
			'ident' => 150,
			'setlist' => 72,
			'try' => 36,
			'switch' => 35,
			'assign' => 19,
			'directive' => 197,
			'condition' => 75,
			'lterm' => 58
		}
	},
	{#State 107
		DEFAULT => -35
	},
	{#State 108
		ACTIONS => {
			'SET' => 1,
			'NOT' => 40,
			'IDENT' => 2,
			'CLEAR' => 42,
			'UNLESS' => 4,
			'IF' => 45,
			"\$" => 44,
			'STOP' => 7,
			'CALL' => 46,
			'THROW' => 9,
			'GET' => 48,
			"[" => 10,
			'TRY' => 11,
			'LAST' => 50,
			'DEBUG' => 52,
			'INCLUDE' => 17,
			"(" => 199,
			'SWITCH' => 55,
			'JAVASCRIPT' => 56,
			'WRAPPER' => 57,
			'FOR' => 21,
			'NEXT' => 22,
			'LITERAL' => 59,
			"\"" => 62,
			'PROCESS' => 63,
			'FILTER' => 25,
			'RETURN' => 66,
			'INSERT' => 67,
			'NUMBER' => 26,
			'REF' => 27,
			'WHILE' => 69,
			'BLOCK' => 194,
			'DEFAULT' => 71,
			"{" => 31,
			'perl' => 32,
			"\${" => 38
		},
		GOTOS => {
			'item' => 41,
			'javascript' => 3,
			'node' => 23,
			'term' => 60,
			'loop' => 5,
			'expr' => 200,
			'wrapper' => 47,
			'atomexpr' => 49,
			'atomdir' => 13,
			'mdir' => 198,
			'filter' => 30,
			'sterm' => 70,
			'ident' => 150,
			'setlist' => 72,
			'try' => 36,
			'switch' => 35,
			'assign' => 19,
			'directive' => 197,
			'condition' => 75,
			'lterm' => 58
		}
	},
	{#State 109
		ACTIONS => {
			'IN' => 202,
			'ASSIGN' => 201
		},
		DEFAULT => -131
	},
	{#State 110
		DEFAULT => -157,
		GOTOS => {
			'args' => 203
		}
	},
	{#State 111
		ACTIONS => {
			";" => 204
		}
	},
	{#State 112
		ACTIONS => {
			'ASSIGN' => -131
		},
		DEFAULT => -174
	},
	{#State 113
		ACTIONS => {
			'ASSIGN' => 205
		}
	},
	{#State 114
		DEFAULT => -160
	},
	{#State 115
		ACTIONS => {
			"\$" => 44,
			'IDENT' => 206,
			"\${" => 38
		},
		GOTOS => {
			'item' => 41,
			'node' => 23,
			'ident' => 177
		}
	},
	{#State 116
		ACTIONS => {
			";" => 207
		}
	},
	{#State 117
		ACTIONS => {
			'ASSIGN' => -162
		},
		DEFAULT => -170
	},
	{#State 118
		DEFAULT => -177,
		GOTOS => {
			'quoted' => 208
		}
	},
	{#State 119
		DEFAULT => -159
	},
	{#State 120
		ACTIONS => {
			'DOT' => 105
		},
		DEFAULT => -111
	},
	{#State 121
		DEFAULT => -76
	},
	{#State 122
		ACTIONS => {
			'ASSIGN' => 188
		},
		DEFAULT => -174
	},
	{#State 123
		DEFAULT => -84
	},
	{#State 124
		ACTIONS => {
			'DOT' => 176
		},
		DEFAULT => -85
	},
	{#State 125
		ACTIONS => {
			";" => 209
		}
	},
	{#State 126
		DEFAULT => -86
	},
	{#State 127
		ACTIONS => {
			"}" => 210
		}
	},
	{#State 128
		ACTIONS => {
			'ASSIGN' => 211
		}
	},
	{#State 129
		DEFAULT => -123
	},
	{#State 130
		ACTIONS => {
			"\$" => 44,
			'COMMA' => 213,
			'LITERAL' => 131,
			'IDENT' => 2,
			"\${" => 38
		},
		DEFAULT => -119,
		GOTOS => {
			'item' => 128,
			'param' => 212
		}
	},
	{#State 131
		ACTIONS => {
			'ASSIGN' => 214
		}
	},
	{#State 132
		DEFAULT => -75
	},
	{#State 133
		DEFAULT => -4
	},
	{#State 134
		ACTIONS => {
			";" => 215
		}
	},
	{#State 135
		ACTIONS => {
			"}" => 216
		}
	},
	{#State 136
		ACTIONS => {
			'DIV' => 161,
			'BINOP' => 163,
			"+" => 159,
			'CAT' => 165,
			'CMPOP' => 166,
			'MOD' => 167,
			"/" => 168
		},
		DEFAULT => -143
	},
	{#State 137
		DEFAULT => -157,
		GOTOS => {
			'args' => 217
		}
	},
	{#State 138
		DEFAULT => -133
	},
	{#State 139
		ACTIONS => {
			'CMPOP' => 166,
			"?" => 160,
			";" => 218,
			"+" => 159,
			'MOD' => 167,
			'DIV' => 161,
			"/" => 168,
			'AND' => 162,
			'CAT' => 165,
			'BINOP' => 163,
			'OR' => 164
		}
	},
	{#State 140
		ACTIONS => {
			"+" => 159,
			'CAT' => 165,
			'CMPOP' => 166,
			"?" => 160,
			'DIV' => 161,
			'MOD' => 167,
			"/" => 168,
			'AND' => 162,
			'BINOP' => 163,
			'OR' => 164
		},
		DEFAULT => -31
	},
	{#State 141
		ACTIONS => {
			"+" => 159,
			'CAT' => 165,
			'CMPOP' => 166,
			"?" => 160,
			'DIV' => 161,
			'MOD' => 167,
			"/" => 168,
			'AND' => 162,
			'BINOP' => 163,
			'OR' => 164
		},
		DEFAULT => -30
	},
	{#State 142
		ACTIONS => {
			'NOT' => 40,
			"{" => 31,
			'LITERAL' => 80,
			'IDENT' => 2,
			"\"" => 62,
			"(" => 54,
			"\$" => 44,
			"[" => 10,
			'NUMBER' => 26,
			'REF' => 27,
			"\${" => 38
		},
		GOTOS => {
			'expr' => 219,
			'sterm' => 70,
			'item' => 41,
			'node' => 23,
			'ident' => 79,
			'term' => 60,
			'lterm' => 58
		}
	},
	{#State 143
		ACTIONS => {
			"{" => 31,
			'LITERAL' => 80,
			'IDENT' => 109,
			"\"" => 62,
			"\$" => 44,
			"[" => 10,
			'NUMBER' => 26,
			'REF' => 27,
			"\${" => 38
		},
		GOTOS => {
			'sterm' => 70,
			'item' => 41,
			'loopvar' => 220,
			'node' => 23,
			'ident' => 79,
			'term' => 110,
			'lterm' => 58
		}
	},
	{#State 144
		ACTIONS => {
			"\"" => 118,
			"\$" => 115,
			'LITERAL' => 117,
			'FILENAME' => 85,
			'IDENT' => 112,
			'NUMBER' => 86,
			"\${" => 38
		},
		GOTOS => {
			'names' => 93,
			'lvalue' => 113,
			'item' => 114,
			'name' => 84,
			'filepart' => 89,
			'filename' => 87,
			'nameargs' => 119,
			'lnameargs' => 221
		}
	},
	{#State 145
		ACTIONS => {
			'NOT' => 40,
			"{" => 31,
			'LITERAL' => 80,
			'IDENT' => 2,
			"\"" => 62,
			"(" => 54,
			"\$" => 44,
			"[" => 10,
			'NUMBER' => 26,
			'REF' => 27,
			"\${" => 38
		},
		GOTOS => {
			'expr' => 222,
			'sterm' => 70,
			'item' => 41,
			'node' => 23,
			'ident' => 79,
			'term' => 60,
			'lterm' => 58
		}
	},
	{#State 146
		ACTIONS => {
			"\"" => 91,
			"\$" => 88,
			'LITERAL' => 90,
			'FILENAME' => 85,
			'IDENT' => 83,
			'NUMBER' => 86
		},
		GOTOS => {
			'filepart' => 89,
			'names' => 93,
			'nameargs' => 223,
			'filename' => 87,
			'name' => 84
		}
	},
	{#State 147
		ACTIONS => {
			'NOT' => 40,
			"{" => 31,
			'LITERAL' => 80,
			'IDENT' => 2,
			"\"" => 62,
			"(" => 54,
			"\$" => 44,
			"[" => 10,
			'NUMBER' => 26,
			'REF' => 27,
			"\${" => 38
		},
		GOTOS => {
			'expr' => 224,
			'sterm' => 70,
			'item' => 41,
			'node' => 23,
			'ident' => 79,
			'term' => 60,
			'lterm' => 58
		}
	},
	{#State 148
		DEFAULT => -43
	},
	{#State 149
		DEFAULT => 0
	},
	{#State 150
		ACTIONS => {
			'DOT' => 105,
			'ASSIGN' => 174
		},
		DEFAULT => -110
	},
	{#State 151
		ACTIONS => {
			")" => 225
		}
	},
	{#State 152
		ACTIONS => {
			'CMPOP' => 166,
			"?" => 160,
			"+" => 159,
			'MOD' => 167,
			'DIV' => 161,
			"/" => 168,
			'AND' => 162,
			'CAT' => 165,
			'BINOP' => 163,
			")" => 226,
			'OR' => 164
		}
	},
	{#State 153
		ACTIONS => {
			'CMPOP' => 166,
			"?" => 160,
			";" => 227,
			"+" => 159,
			'MOD' => 167,
			'DIV' => 161,
			"/" => 168,
			'AND' => 162,
			'CAT' => 165,
			'BINOP' => 163,
			'OR' => 164
		}
	},
	{#State 154
		DEFAULT => -79,
		GOTOS => {
			'@4-2' => 228
		}
	},
	{#State 155
		ACTIONS => {
			";" => 229
		}
	},
	{#State 156
		ACTIONS => {
			'NOT' => 40,
			"{" => 31,
			'LITERAL' => 80,
			'IDENT' => 2,
			"\"" => 62,
			"(" => 54,
			"\$" => 44,
			"[" => 10,
			'NUMBER' => 26,
			'REF' => 27,
			"\${" => 38
		},
		GOTOS => {
			'expr' => 230,
			'sterm' => 70,
			'item' => 41,
			'node' => 23,
			'ident' => 79,
			'term' => 60,
			'lterm' => 58
		}
	},
	{#State 157
		ACTIONS => {
			"\"" => 235,
			'TEXT' => 232,
			";" => 234,
			"\$" => 44,
			'IDENT' => 2,
			"\${" => 38
		},
		GOTOS => {
			'item' => 41,
			'node' => 23,
			'ident' => 231,
			'quotable' => 233
		}
	},
	{#State 158
		DEFAULT => -36
	},
	{#State 159
		ACTIONS => {
			'NOT' => 40,
			"{" => 31,
			'LITERAL' => 80,
			'IDENT' => 2,
			"\"" => 62,
			"(" => 54,
			"\$" => 44,
			"[" => 10,
			'NUMBER' => 26,
			'REF' => 27,
			"\${" => 38
		},
		GOTOS => {
			'expr' => 236,
			'sterm' => 70,
			'item' => 41,
			'node' => 23,
			'ident' => 79,
			'term' => 60,
			'lterm' => 58
		}
	},
	{#State 160
		ACTIONS => {
			'NOT' => 40,
			"{" => 31,
			'LITERAL' => 80,
			'IDENT' => 2,
			"\"" => 62,
			"(" => 54,
			"\$" => 44,
			"[" => 10,
			'NUMBER' => 26,
			'REF' => 27,
			"\${" => 38
		},
		GOTOS => {
			'expr' => 237,
			'sterm' => 70,
			'item' => 41,
			'node' => 23,
			'ident' => 79,
			'term' => 60,
			'lterm' => 58
		}
	},
	{#State 161
		ACTIONS => {
			'NOT' => 40,
			"{" => 31,
			'LITERAL' => 80,
			'IDENT' => 2,
			"\"" => 62,
			"(" => 54,
			"\$" => 44,
			"[" => 10,
			'NUMBER' => 26,
			'REF' => 27,
			"\${" => 38
		},
		GOTOS => {
			'expr' => 238,
			'sterm' => 70,
			'item' => 41,
			'node' => 23,
			'ident' => 79,
			'term' => 60,
			'lterm' => 58
		}
	},
	{#State 162
		ACTIONS => {
			'NOT' => 40,
			"{" => 31,
			'LITERAL' => 80,
			'IDENT' => 2,
			"\"" => 62,
			"(" => 54,
			"\$" => 44,
			"[" => 10,
			'NUMBER' => 26,
			'REF' => 27,
			"\${" => 38
		},
		GOTOS => {
			'expr' => 239,
			'sterm' => 70,
			'item' => 41,
			'node' => 23,
			'ident' => 79,
			'term' => 60,
			'lterm' => 58
		}
	},
	{#State 163
		ACTIONS => {
			'NOT' => 40,
			"{" => 31,
			'LITERAL' => 80,
			'IDENT' => 2,
			"\"" => 62,
			"(" => 54,
			"\$" => 44,
			"[" => 10,
			'NUMBER' => 26,
			'REF' => 27,
			"\${" => 38
		},
		GOTOS => {
			'expr' => 240,
			'sterm' => 70,
			'item' => 41,
			'node' => 23,
			'ident' => 79,
			'term' => 60,
			'lterm' => 58
		}
	},
	{#State 164
		ACTIONS => {
			'NOT' => 40,
			"{" => 31,
			'LITERAL' => 80,
			'IDENT' => 2,
			"\"" => 62,
			"(" => 54,
			"\$" => 44,
			"[" => 10,
			'NUMBER' => 26,
			'REF' => 27,
			"\${" => 38
		},
		GOTOS => {
			'expr' => 241,
			'sterm' => 70,
			'item' => 41,
			'node' => 23,
			'ident' => 79,
			'term' => 60,
			'lterm' => 58
		}
	},
	{#State 165
		ACTIONS => {
			'NOT' => 40,
			"{" => 31,
			'LITERAL' => 80,
			'IDENT' => 2,
			"\"" => 62,
			"(" => 54,
			"\$" => 44,
			"[" => 10,
			'NUMBER' => 26,
			'REF' => 27,
			"\${" => 38
		},
		GOTOS => {
			'expr' => 242,
			'sterm' => 70,
			'item' => 41,
			'node' => 23,
			'ident' => 79,
			'term' => 60,
			'lterm' => 58
		}
	},
	{#State 166
		ACTIONS => {
			'NOT' => 40,
			"{" => 31,
			'LITERAL' => 80,
			'IDENT' => 2,
			"\"" => 62,
			"(" => 54,
			"\$" => 44,
			"[" => 10,
			'NUMBER' => 26,
			'REF' => 27,
			"\${" => 38
		},
		GOTOS => {
			'expr' => 243,
			'sterm' => 70,
			'item' => 41,
			'node' => 23,
			'ident' => 79,
			'term' => 60,
			'lterm' => 58
		}
	},
	{#State 167
		ACTIONS => {
			'NOT' => 40,
			"{" => 31,
			'LITERAL' => 80,
			'IDENT' => 2,
			"\"" => 62,
			"(" => 54,
			"\$" => 44,
			"[" => 10,
			'NUMBER' => 26,
			'REF' => 27,
			"\${" => 38
		},
		GOTOS => {
			'expr' => 244,
			'sterm' => 70,
			'item' => 41,
			'node' => 23,
			'ident' => 79,
			'term' => 60,
			'lterm' => 58
		}
	},
	{#State 168
		ACTIONS => {
			'NOT' => 40,
			"{" => 31,
			'LITERAL' => 80,
			'IDENT' => 2,
			"\"" => 62,
			"(" => 54,
			"\$" => 44,
			"[" => 10,
			'NUMBER' => 26,
			'REF' => 27,
			"\${" => 38
		},
		GOTOS => {
			'expr' => 245,
			'sterm' => 70,
			'item' => 41,
			'node' => 23,
			'ident' => 79,
			'term' => 60,
			'lterm' => 58
		}
	},
	{#State 169
		DEFAULT => -34
	},
	{#State 170
		ACTIONS => {
			'CMPOP' => 166,
			"?" => 160,
			";" => 246,
			"+" => 159,
			'MOD' => 167,
			'DIV' => 161,
			"/" => 168,
			'AND' => 162,
			'CAT' => 165,
			'BINOP' => 163,
			'OR' => 164
		}
	},
	{#State 171
		ACTIONS => {
			'COMMA' => 173,
			'LITERAL' => 77,
			'IDENT' => 2,
			"\$" => 44,
			"\${" => 38
		},
		DEFAULT => -33,
		GOTOS => {
			'item' => 41,
			'assign' => 172,
			'node' => 23,
			'ident' => 76
		}
	},
	{#State 172
		DEFAULT => -148
	},
	{#State 173
		DEFAULT => -149
	},
	{#State 174
		ACTIONS => {
			'NOT' => 40,
			"{" => 31,
			'LITERAL' => 80,
			'IDENT' => 2,
			"\"" => 62,
			"(" => 54,
			"\$" => 44,
			"[" => 10,
			'NUMBER' => 26,
			'REF' => 27,
			"\${" => 38
		},
		GOTOS => {
			'expr' => 247,
			'sterm' => 70,
			'item' => 41,
			'node' => 23,
			'ident' => 79,
			'term' => 60,
			'lterm' => 58
		}
	},
	{#State 175
		ACTIONS => {
			'SET' => 1,
			'NOT' => 40,
			'IDENT' => 2,
			'CLEAR' => 42,
			'UNLESS' => 4,
			'IF' => 45,
			"\$" => 44,
			'STOP' => 7,
			'CALL' => 46,
			'THROW' => 9,
			'GET' => 48,
			"[" => 10,
			'TRY' => 11,
			'LAST' => 50,
			'DEBUG' => 52,
			'META' => 15,
			'INCLUDE' => 17,
			"(" => 54,
			'SWITCH' => 55,
			'MACRO' => 18,
			'JAVASCRIPT' => 56,
			'WRAPPER' => 57,
			";" => -19,
			'FOR' => 21,
			'LITERAL' => 59,
			'NEXT' => 22,
			'rawperl' => 61,
			"\"" => 62,
			'TEXT' => 24,
			'PROCESS' => 63,
			'RETURN' => 66,
			'FILTER' => 25,
			'INSERT' => 67,
			'NUMBER' => 26,
			'REF' => 27,
			'WHILE' => 69,
			'RAW' => 28,
			'BLOCK' => 29,
			'DEFAULT' => 71,
			"{" => 31,
			'perl' => 32,
			'USE' => 33,
			'VIEW' => 37,
			"\${" => 38
		},
		DEFAULT => -3,
		GOTOS => {
			'item' => 41,
			'javascript' => 3,
			'node' => 23,
			'term' => 60,
			'loop' => 5,
			'use' => 65,
			'expr' => 64,
			'capture' => 43,
			'statement' => 6,
			'view' => 8,
			'wrapper' => 47,
			'atomexpr' => 49,
			'chunk' => 12,
			'defblock' => 68,
			'atomdir' => 13,
			'anonblock' => 51,
			'sterm' => 70,
			'defblockname' => 14,
			'filter' => 30,
			'ident' => 16,
			'setlist' => 72,
			'chunks' => 34,
			'try' => 36,
			'switch' => 35,
			'assign' => 19,
			'block' => 248,
			'directive' => 73,
			'macro' => 20,
			'condition' => 75,
			'lterm' => 58,
			'raw' => 39
		}
	},
	{#State 176
		ACTIONS => {
			'FILENAME' => 85,
			'IDENT' => 83,
			'NUMBER' => 86
		},
		GOTOS => {
			'filepart' => 249
		}
	},
	{#State 177
		ACTIONS => {
			'DOT' => 105
		},
		DEFAULT => -157,
		GOTOS => {
			'args' => 250
		}
	},
	{#State 178
		ACTIONS => {
			"\"" => 251,
			'TEXT' => 232,
			";" => 234,
			"\$" => 44,
			'IDENT' => 2,
			"\${" => 38
		},
		GOTOS => {
			'item' => 41,
			'node' => 23,
			'ident' => 231,
			'quotable' => 233
		}
	},
	{#State 179
		ACTIONS => {
			"\"" => 91,
			'LITERAL' => 90,
			'FILENAME' => 85,
			'IDENT' => 83,
			'NUMBER' => 86
		},
		GOTOS => {
			'filepart' => 89,
			'filename' => 87,
			'name' => 252
		}
	},
	{#State 180
		DEFAULT => -157,
		GOTOS => {
			'args' => 253
		}
	},
	{#State 181
		ACTIONS => {
			'NOT' => 40,
			'LITERAL' => 257,
			'IDENT' => 2,
			"\"" => 62,
			"\$" => 44,
			"[" => 10,
			'NUMBER' => 26,
			'REF' => 27,
			"{" => 31,
			'COMMA' => 259,
			"(" => 54,
			"\${" => 38
		},
		DEFAULT => -164,
		GOTOS => {
			'expr' => 258,
			'sterm' => 70,
			'item' => 255,
			'param' => 256,
			'node' => 23,
			'ident' => 254,
			'term' => 60,
			'lterm' => 58
		}
	},
	{#State 182
		DEFAULT => -106
	},
	{#State 183
		DEFAULT => -115
	},
	{#State 184
		DEFAULT => -116
	},
	{#State 185
		DEFAULT => -107
	},
	{#State 186
		ACTIONS => {
			"\"" => 62,
			"\$" => 44,
			'LITERAL' => 80,
			'IDENT' => 2,
			'REF' => 27,
			'NUMBER' => 26,
			"\${" => 38
		},
		GOTOS => {
			'sterm' => 260,
			'item' => 41,
			'node' => 23,
			'ident' => 79
		}
	},
	{#State 187
		ACTIONS => {
			'FINAL' => 261,
			'CATCH' => 263
		},
		DEFAULT => -74,
		GOTOS => {
			'final' => 262
		}
	},
	{#State 188
		ACTIONS => {
			"\"" => 266,
			'LITERAL' => 265,
			'NUMBER' => 264
		}
	},
	{#State 189
		DEFAULT => -98
	},
	{#State 190
		DEFAULT => -99
	},
	{#State 191
		ACTIONS => {
			'SET' => 1,
			'NOT' => 40,
			'IDENT' => 2,
			'CLEAR' => 42,
			'UNLESS' => 4,
			'IF' => 45,
			"\$" => 44,
			'STOP' => 7,
			'CALL' => 46,
			'THROW' => 9,
			'GET' => 48,
			"[" => 10,
			'TRY' => 11,
			'LAST' => 50,
			'DEBUG' => 52,
			'META' => 15,
			'INCLUDE' => 17,
			"(" => 54,
			'SWITCH' => 55,
			'MACRO' => 18,
			'JAVASCRIPT' => 56,
			'WRAPPER' => 57,
			";" => -19,
			'FOR' => 21,
			'LITERAL' => 59,
			'NEXT' => 22,
			'rawperl' => 61,
			"\"" => 62,
			'TEXT' => 24,
			'PROCESS' => 63,
			'RETURN' => 66,
			'FILTER' => 25,
			'INSERT' => 67,
			'NUMBER' => 26,
			'REF' => 27,
			'WHILE' => 69,
			'RAW' => 28,
			'BLOCK' => 29,
			'DEFAULT' => 71,
			"{" => 31,
			'perl' => 32,
			'USE' => 33,
			'VIEW' => 37,
			"\${" => 38
		},
		DEFAULT => -3,
		GOTOS => {
			'item' => 41,
			'javascript' => 3,
			'loop' => 5,
			'capture' => 43,
			'statement' => 6,
			'view' => 8,
			'wrapper' => 47,
			'atomexpr' => 49,
			'chunk' => 12,
			'atomdir' => 13,
			'anonblock' => 51,
			'template' => 267,
			'defblockname' => 14,
			'ident' => 16,
			'assign' => 19,
			'macro' => 20,
			'lterm' => 58,
			'node' => 23,
			'term' => 60,
			'expr' => 64,
			'use' => 65,
			'defblock' => 68,
			'filter' => 30,
			'sterm' => 70,
			'chunks' => 34,
			'setlist' => 72,
			'switch' => 35,
			'try' => 36,
			'directive' => 73,
			'block' => 74,
			'raw' => 39,
			'condition' => 75
		}
	},
	{#State 192
		DEFAULT => -126
	},
	{#State 193
		DEFAULT => -127
	},
	{#State 194
		ACTIONS => {
			";" => 268
		}
	},
	{#State 195
		DEFAULT => -90
	},
	{#State 196
		ACTIONS => {
			";" => -151,
			"+" => 159,
			'LITERAL' => -151,
			'IDENT' => -151,
			'CAT' => 165,
			"\$" => -151,
			'CMPOP' => 166,
			"?" => 160,
			'DIV' => 161,
			'MOD' => 167,
			'COMMA' => -151,
			"/" => 168,
			'AND' => 162,
			'BINOP' => 163,
			'OR' => 164,
			"\${" => -151
		},
		DEFAULT => -28
	},
	{#State 197
		DEFAULT => -93
	},
	{#State 198
		DEFAULT => -92
	},
	{#State 199
		ACTIONS => {
			'NOT' => 40,
			"{" => 31,
			'LITERAL' => 59,
			'IDENT' => 269,
			"\"" => 62,
			"(" => 54,
			"\$" => 44,
			"[" => 10,
			'NUMBER' => 26,
			'REF' => 27,
			"\${" => 38
		},
		GOTOS => {
			'expr' => 152,
			'sterm' => 70,
			'item' => 41,
			'assign' => 151,
			'margs' => 270,
			'node' => 23,
			'ident' => 150,
			'term' => 60,
			'lterm' => 58
		}
	},
	{#State 200
		ACTIONS => {
			"+" => 159,
			'CAT' => 165,
			'CMPOP' => 166,
			"?" => 160,
			'DIV' => 161,
			'MOD' => 167,
			"/" => 168,
			'AND' => 162,
			'BINOP' => 163,
			'OR' => 164
		},
		DEFAULT => -28
	},
	{#State 201
		ACTIONS => {
			"{" => 31,
			'LITERAL' => 80,
			'IDENT' => 2,
			"\"" => 62,
			"\$" => 44,
			"[" => 10,
			'NUMBER' => 26,
			'REF' => 27,
			"\${" => 38
		},
		GOTOS => {
			'sterm' => 70,
			'item' => 41,
			'node' => 23,
			'ident' => 79,
			'term' => 271,
			'lterm' => 58
		}
	},
	{#State 202
		ACTIONS => {
			"{" => 31,
			'LITERAL' => 80,
			'IDENT' => 2,
			"\"" => 62,
			"\$" => 44,
			"[" => 10,
			'NUMBER' => 26,
			'REF' => 27,
			"\${" => 38
		},
		GOTOS => {
			'sterm' => 70,
			'item' => 41,
			'node' => 23,
			'ident' => 79,
			'term' => 272,
			'lterm' => 58
		}
	},
	{#State 203
		ACTIONS => {
			'NOT' => 40,
			"{" => 31,
			'COMMA' => 259,
			'LITERAL' => 257,
			'IDENT' => 2,
			"\"" => 62,
			"(" => 54,
			"\$" => 44,
			"[" => 10,
			'NUMBER' => 26,
			'REF' => 27,
			"\${" => 38
		},
		DEFAULT => -66,
		GOTOS => {
			'expr' => 258,
			'sterm' => 70,
			'item' => 255,
			'param' => 256,
			'node' => 23,
			'ident' => 254,
			'term' => 60,
			'lterm' => 58
		}
	},
	{#State 204
		DEFAULT => -58,
		GOTOS => {
			'@1-3' => 273
		}
	},
	{#State 205
		ACTIONS => {
			"\"" => 91,
			"\$" => 88,
			'LITERAL' => 90,
			'FILENAME' => 85,
			'IDENT' => 83,
			'NUMBER' => 86
		},
		GOTOS => {
			'filepart' => 89,
			'names' => 93,
			'nameargs' => 274,
			'filename' => 87,
			'name' => 84
		}
	},
	{#State 206
		ACTIONS => {
			'ASSIGN' => -133
		},
		DEFAULT => -131
	},
	{#State 207
		ACTIONS => {
			'SET' => 1,
			'NOT' => 40,
			'IDENT' => 2,
			'CLEAR' => 42,
			'UNLESS' => 4,
			'IF' => 45,
			"\$" => 44,
			'STOP' => 7,
			'CALL' => 46,
			'THROW' => 9,
			'GET' => 48,
			"[" => 10,
			'TRY' => 11,
			'LAST' => 50,
			'DEBUG' => 52,
			'META' => 15,
			'INCLUDE' => 17,
			"(" => 54,
			'SWITCH' => 55,
			'MACRO' => 18,
			'JAVASCRIPT' => 56,
			'WRAPPER' => 57,
			";" => -19,
			'FOR' => 21,
			'LITERAL' => 59,
			'NEXT' => 22,
			'rawperl' => 61,
			"\"" => 62,
			'TEXT' => 24,
			'PROCESS' => 63,
			'RETURN' => 66,
			'FILTER' => 25,
			'INSERT' => 67,
			'NUMBER' => 26,
			'REF' => 27,
			'WHILE' => 69,
			'RAW' => 28,
			'BLOCK' => 29,
			'DEFAULT' => 71,
			"{" => 31,
			'perl' => 32,
			'USE' => 33,
			'VIEW' => 37,
			"\${" => 38
		},
		DEFAULT => -3,
		GOTOS => {
			'item' => 41,
			'javascript' => 3,
			'node' => 23,
			'term' => 60,
			'loop' => 5,
			'use' => 65,
			'expr' => 64,
			'capture' => 43,
			'statement' => 6,
			'view' => 8,
			'wrapper' => 47,
			'atomexpr' => 49,
			'chunk' => 12,
			'defblock' => 68,
			'atomdir' => 13,
			'anonblock' => 51,
			'sterm' => 70,
			'defblockname' => 14,
			'filter' => 30,
			'ident' => 16,
			'setlist' => 72,
			'chunks' => 34,
			'try' => 36,
			'switch' => 35,
			'assign' => 19,
			'block' => 275,
			'directive' => 73,
			'macro' => 20,
			'condition' => 75,
			'lterm' => 58,
			'raw' => 39
		}
	},
	{#State 208
		ACTIONS => {
			"\"" => 276,
			'TEXT' => 232,
			";" => 234,
			"\$" => 44,
			'IDENT' => 2,
			"\${" => 38
		},
		GOTOS => {
			'item' => 41,
			'node' => 23,
			'ident' => 231,
			'quotable' => 233
		}
	},
	{#State 209
		ACTIONS => {
			'SET' => 1,
			'NOT' => 40,
			'IDENT' => 2,
			'CLEAR' => 42,
			'UNLESS' => 4,
			'IF' => 45,
			"\$" => 44,
			'STOP' => 7,
			'CALL' => 46,
			'THROW' => 9,
			'GET' => 48,
			"[" => 10,
			'TRY' => 11,
			'LAST' => 50,
			'DEBUG' => 52,
			'META' => 15,
			'INCLUDE' => 17,
			"(" => 54,
			'SWITCH' => 55,
			'MACRO' => 18,
			'JAVASCRIPT' => 56,
			'WRAPPER' => 57,
			";" => -19,
			'FOR' => 21,
			'LITERAL' => 59,
			'NEXT' => 22,
			'rawperl' => 61,
			"\"" => 62,
			'TEXT' => 24,
			'PROCESS' => 63,
			'RETURN' => 66,
			'FILTER' => 25,
			'INSERT' => 67,
			'NUMBER' => 26,
			'REF' => 27,
			'WHILE' => 69,
			'RAW' => 28,
			'BLOCK' => 29,
			'DEFAULT' => 71,
			"{" => 31,
			'perl' => 32,
			'USE' => 33,
			'VIEW' => 37,
			"\${" => 38
		},
		DEFAULT => -3,
		GOTOS => {
			'item' => 41,
			'javascript' => 3,
			'node' => 23,
			'term' => 60,
			'loop' => 5,
			'use' => 65,
			'expr' => 64,
			'capture' => 43,
			'statement' => 6,
			'view' => 8,
			'wrapper' => 47,
			'atomexpr' => 49,
			'chunk' => 12,
			'defblock' => 68,
			'atomdir' => 13,
			'anonblock' => 51,
			'sterm' => 70,
			'defblockname' => 14,
			'filter' => 30,
			'ident' => 16,
			'setlist' => 72,
			'chunks' => 34,
			'try' => 36,
			'switch' => 35,
			'assign' => 19,
			'block' => 277,
			'directive' => 73,
			'macro' => 20,
			'condition' => 75,
			'lterm' => 58,
			'raw' => 39
		}
	},
	{#State 210
		DEFAULT => -109
	},
	{#State 211
		ACTIONS => {
			'NOT' => 40,
			"{" => 31,
			'LITERAL' => 80,
			'IDENT' => 2,
			"\"" => 62,
			"(" => 54,
			"\$" => 44,
			"[" => 10,
			'NUMBER' => 26,
			'REF' => 27,
			"\${" => 38
		},
		GOTOS => {
			'expr' => 278,
			'sterm' => 70,
			'item' => 41,
			'node' => 23,
			'ident' => 79,
			'term' => 60,
			'lterm' => 58
		}
	},
	{#State 212
		DEFAULT => -121
	},
	{#State 213
		DEFAULT => -122
	},
	{#State 214
		ACTIONS => {
			'NOT' => 40,
			"{" => 31,
			'LITERAL' => 80,
			'IDENT' => 2,
			"\"" => 62,
			"(" => 54,
			"\$" => 44,
			"[" => 10,
			'NUMBER' => 26,
			'REF' => 27,
			"\${" => 38
		},
		GOTOS => {
			'expr' => 279,
			'sterm' => 70,
			'item' => 41,
			'node' => 23,
			'ident' => 79,
			'term' => 60,
			'lterm' => 58
		}
	},
	{#State 215
		DEFAULT => -77,
		GOTOS => {
			'@3-3' => 280
		}
	},
	{#State 216
		DEFAULT => -132
	},
	{#State 217
		ACTIONS => {
			'NOT' => 40,
			"{" => 31,
			'COMMA' => 259,
			'LITERAL' => 257,
			'IDENT' => 2,
			"\"" => 62,
			"(" => 54,
			"\$" => 44,
			"[" => 10,
			'NUMBER' => 26,
			'REF' => 27,
			")" => 281,
			"\${" => 38
		},
		GOTOS => {
			'expr' => 258,
			'sterm' => 70,
			'item' => 255,
			'param' => 256,
			'node' => 23,
			'ident' => 254,
			'term' => 60,
			'lterm' => 58
		}
	},
	{#State 218
		ACTIONS => {
			'SET' => 1,
			'NOT' => 40,
			'IDENT' => 2,
			'CLEAR' => 42,
			'UNLESS' => 4,
			'IF' => 45,
			"\$" => 44,
			'STOP' => 7,
			'CALL' => 46,
			'THROW' => 9,
			'GET' => 48,
			"[" => 10,
			'TRY' => 11,
			'LAST' => 50,
			'DEBUG' => 52,
			'META' => 15,
			'INCLUDE' => 17,
			"(" => 54,
			'SWITCH' => 55,
			'MACRO' => 18,
			'JAVASCRIPT' => 56,
			'WRAPPER' => 57,
			";" => -19,
			'FOR' => 21,
			'LITERAL' => 59,
			'NEXT' => 22,
			'rawperl' => 61,
			"\"" => 62,
			'TEXT' => 24,
			'PROCESS' => 63,
			'RETURN' => 66,
			'FILTER' => 25,
			'INSERT' => 67,
			'NUMBER' => 26,
			'REF' => 27,
			'WHILE' => 69,
			'RAW' => 28,
			'BLOCK' => 29,
			'DEFAULT' => 71,
			"{" => 31,
			'perl' => 32,
			'USE' => 33,
			'VIEW' => 37,
			"\${" => 38
		},
		DEFAULT => -3,
		GOTOS => {
			'item' => 41,
			'javascript' => 3,
			'node' => 23,
			'term' => 60,
			'loop' => 5,
			'use' => 65,
			'expr' => 64,
			'capture' => 43,
			'statement' => 6,
			'view' => 8,
			'wrapper' => 47,
			'atomexpr' => 49,
			'chunk' => 12,
			'defblock' => 68,
			'atomdir' => 13,
			'anonblock' => 51,
			'sterm' => 70,
			'defblockname' => 14,
			'filter' => 30,
			'ident' => 16,
			'setlist' => 72,
			'chunks' => 34,
			'try' => 36,
			'switch' => 35,
			'assign' => 19,
			'block' => 282,
			'directive' => 73,
			'macro' => 20,
			'condition' => 75,
			'lterm' => 58,
			'raw' => 39
		}
	},
	{#State 219
		ACTIONS => {
			'CMPOP' => 166,
			"?" => 160,
			"+" => 159,
			'MOD' => 167,
			'DIV' => 161,
			"/" => 168,
			'AND' => 162,
			'CAT' => 165,
			'BINOP' => 163,
			'OR' => 164
		},
		DEFAULT => -49
	},
	{#State 220
		DEFAULT => -60
	},
	{#State 221
		DEFAULT => -82
	},
	{#State 222
		ACTIONS => {
			'CMPOP' => 166,
			"?" => 160,
			"+" => 159,
			'MOD' => 167,
			'DIV' => 161,
			"/" => 168,
			'AND' => 162,
			'CAT' => 165,
			'BINOP' => 163,
			'OR' => 164
		},
		DEFAULT => -47
	},
	{#State 223
		DEFAULT => -68
	},
	{#State 224
		ACTIONS => {
			'CMPOP' => 166,
			"?" => 160,
			"+" => 159,
			'MOD' => 167,
			'DIV' => 161,
			"/" => 168,
			'AND' => 162,
			'CAT' => 165,
			'BINOP' => 163,
			'OR' => 164
		},
		DEFAULT => -63
	},
	{#State 225
		DEFAULT => -145
	},
	{#State 226
		DEFAULT => -146
	},
	{#State 227
		ACTIONS => {
			'SET' => 1,
			'NOT' => 40,
			'IDENT' => 2,
			'CLEAR' => 42,
			'UNLESS' => 4,
			'IF' => 45,
			"\$" => 44,
			'STOP' => 7,
			'CALL' => 46,
			'THROW' => 9,
			'GET' => 48,
			"[" => 10,
			'TRY' => 11,
			'LAST' => 50,
			'DEBUG' => 52,
			'META' => 15,
			'INCLUDE' => 17,
			"(" => 54,
			'SWITCH' => 55,
			'MACRO' => 18,
			'JAVASCRIPT' => 56,
			'WRAPPER' => 57,
			";" => -19,
			'FOR' => 21,
			'LITERAL' => 59,
			'NEXT' => 22,
			'rawperl' => 61,
			"\"" => 62,
			'TEXT' => 24,
			'PROCESS' => 63,
			'RETURN' => 66,
			'FILTER' => 25,
			'INSERT' => 67,
			'NUMBER' => 26,
			'REF' => 27,
			'WHILE' => 69,
			'RAW' => 28,
			'BLOCK' => 29,
			'DEFAULT' => 71,
			"{" => 31,
			'perl' => 32,
			'USE' => 33,
			'VIEW' => 37,
			"\${" => 38
		},
		DEFAULT => -3,
		GOTOS => {
			'item' => 41,
			'javascript' => 3,
			'node' => 23,
			'term' => 60,
			'loop' => 5,
			'use' => 65,
			'expr' => 64,
			'capture' => 43,
			'statement' => 6,
			'view' => 8,
			'wrapper' => 47,
			'atomexpr' => 49,
			'chunk' => 12,
			'defblock' => 68,
			'atomdir' => 13,
			'anonblock' => 51,
			'sterm' => 70,
			'defblockname' => 14,
			'filter' => 30,
			'ident' => 16,
			'setlist' => 72,
			'chunks' => 34,
			'try' => 36,
			'switch' => 35,
			'assign' => 19,
			'block' => 283,
			'directive' => 73,
			'macro' => 20,
			'condition' => 75,
			'lterm' => 58,
			'raw' => 39
		}
	},
	{#State 228
		ACTIONS => {
			'SET' => 1,
			'NOT' => 40,
			'IDENT' => 2,
			'CLEAR' => 42,
			'UNLESS' => 4,
			'IF' => 45,
			"\$" => 44,
			'STOP' => 7,
			'CALL' => 46,
			'THROW' => 9,
			'GET' => 48,
			"[" => 10,
			'TRY' => 11,
			'LAST' => 50,
			'DEBUG' => 52,
			'META' => 15,
			'INCLUDE' => 17,
			"(" => 54,
			'SWITCH' => 55,
			'MACRO' => 18,
			'JAVASCRIPT' => 56,
			'WRAPPER' => 57,
			";" => -19,
			'FOR' => 21,
			'LITERAL' => 59,
			'NEXT' => 22,
			'rawperl' => 61,
			"\"" => 62,
			'TEXT' => 24,
			'PROCESS' => 63,
			'RETURN' => 66,
			'FILTER' => 25,
			'INSERT' => 67,
			'NUMBER' => 26,
			'REF' => 27,
			'WHILE' => 69,
			'RAW' => 28,
			'BLOCK' => 29,
			'DEFAULT' => 71,
			"{" => 31,
			'perl' => 32,
			'USE' => 33,
			'VIEW' => 37,
			"\${" => 38
		},
		DEFAULT => -3,
		GOTOS => {
			'item' => 41,
			'javascript' => 3,
			'node' => 23,
			'term' => 60,
			'loop' => 5,
			'use' => 65,
			'expr' => 64,
			'capture' => 43,
			'statement' => 6,
			'view' => 8,
			'wrapper' => 47,
			'atomexpr' => 49,
			'chunk' => 12,
			'defblock' => 68,
			'atomdir' => 13,
			'anonblock' => 51,
			'sterm' => 70,
			'defblockname' => 14,
			'filter' => 30,
			'ident' => 16,
			'setlist' => 72,
			'chunks' => 34,
			'try' => 36,
			'switch' => 35,
			'assign' => 19,
			'block' => 284,
			'directive' => 73,
			'macro' => 20,
			'condition' => 75,
			'lterm' => 58,
			'raw' => 39
		}
	},
	{#State 229
		ACTIONS => {
			'SET' => 1,
			'NOT' => 40,
			'IDENT' => 2,
			'CLEAR' => 42,
			'UNLESS' => 4,
			'IF' => 45,
			"\$" => 44,
			'STOP' => 7,
			'CALL' => 46,
			'THROW' => 9,
			'GET' => 48,
			"[" => 10,
			'TRY' => 11,
			'LAST' => 50,
			'DEBUG' => 52,
			'META' => 15,
			'INCLUDE' => 17,
			"(" => 54,
			'SWITCH' => 55,
			'MACRO' => 18,
			'JAVASCRIPT' => 56,
			'WRAPPER' => 57,
			";" => -19,
			'FOR' => 21,
			'LITERAL' => 59,
			'NEXT' => 22,
			'rawperl' => 61,
			"\"" => 62,
			'TEXT' => 24,
			'PROCESS' => 63,
			'RETURN' => 66,
			'FILTER' => 25,
			'INSERT' => 67,
			'NUMBER' => 26,
			'REF' => 27,
			'WHILE' => 69,
			'RAW' => 28,
			'BLOCK' => 29,
			'DEFAULT' => 71,
			"{" => 31,
			'perl' => 32,
			'USE' => 33,
			'VIEW' => 37,
			"\${" => 38
		},
		DEFAULT => -3,
		GOTOS => {
			'item' => 41,
			'javascript' => 3,
			'node' => 23,
			'term' => 60,
			'loop' => 5,
			'use' => 65,
			'expr' => 64,
			'capture' => 43,
			'statement' => 6,
			'view' => 8,
			'wrapper' => 47,
			'atomexpr' => 49,
			'chunk' => 12,
			'defblock' => 68,
			'atomdir' => 13,
			'anonblock' => 51,
			'sterm' => 70,
			'defblockname' => 14,
			'filter' => 30,
			'ident' => 16,
			'setlist' => 72,
			'chunks' => 34,
			'try' => 36,
			'switch' => 35,
			'assign' => 19,
			'block' => 285,
			'directive' => 73,
			'macro' => 20,
			'condition' => 75,
			'lterm' => 58,
			'raw' => 39
		}
	},
	{#State 230
		ACTIONS => {
			"+" => 159,
			'CAT' => 165,
			'CMPOP' => 166,
			"?" => 160,
			'DIV' => 161,
			'MOD' => 167,
			"/" => 168,
			'AND' => 162,
			'BINOP' => 163,
			'OR' => 164
		},
		DEFAULT => -152
	},
	{#State 231
		ACTIONS => {
			'DOT' => 105
		},
		DEFAULT => -178
	},
	{#State 232
		DEFAULT => -179
	},
	{#State 233
		DEFAULT => -176
	},
	{#State 234
		DEFAULT => -180
	},
	{#State 235
		DEFAULT => -112
	},
	{#State 236
		ACTIONS => {
			'DIV' => 161,
			'MOD' => 167,
			"/" => 168
		},
		DEFAULT => -136
	},
	{#State 237
		ACTIONS => {
			":" => 286,
			'CMPOP' => 166,
			"?" => 160,
			"+" => 159,
			'MOD' => 167,
			'DIV' => 161,
			"/" => 168,
			'AND' => 162,
			'CAT' => 165,
			'BINOP' => 163,
			'OR' => 164
		}
	},
	{#State 238
		ACTIONS => {
			'MOD' => 167
		},
		DEFAULT => -137
	},
	{#State 239
		ACTIONS => {
			'DIV' => 161,
			'BINOP' => 163,
			"+" => 159,
			'CAT' => 165,
			'CMPOP' => 166,
			'MOD' => 167,
			"/" => 168
		},
		DEFAULT => -141
	},
	{#State 240
		ACTIONS => {
			'DIV' => 161,
			"+" => 159,
			'MOD' => 167,
			"/" => 168
		},
		DEFAULT => -134
	},
	{#State 241
		ACTIONS => {
			'DIV' => 161,
			'BINOP' => 163,
			"+" => 159,
			'CAT' => 165,
			'CMPOP' => 166,
			'MOD' => 167,
			"/" => 168
		},
		DEFAULT => -142
	},
	{#State 242
		ACTIONS => {
			'DIV' => 161,
			'BINOP' => 163,
			"+" => 159,
			'CMPOP' => 166,
			'MOD' => 167,
			"/" => 168
		},
		DEFAULT => -140
	},
	{#State 243
		ACTIONS => {
			'DIV' => 161,
			'BINOP' => 163,
			"+" => 159,
			'MOD' => 167,
			"/" => 168
		},
		DEFAULT => -139
	},
	{#State 244
		DEFAULT => -138
	},
	{#State 245
		ACTIONS => {
			'DIV' => 161,
			'MOD' => 167
		},
		DEFAULT => -135
	},
	{#State 246
		DEFAULT => -61,
		GOTOS => {
			'@2-3' => 287
		}
	},
	{#State 247
		ACTIONS => {
			"+" => 159,
			'CAT' => 165,
			'CMPOP' => 166,
			"?" => 160,
			'DIV' => 161,
			'MOD' => 167,
			"/" => 168,
			'AND' => 162,
			'BINOP' => 163,
			'OR' => 164
		},
		DEFAULT => -151
	},
	{#State 248
		ACTIONS => {
			'ELSIF' => 290,
			'ELSE' => 288
		},
		DEFAULT => -52,
		GOTOS => {
			'else' => 289
		}
	},
	{#State 249
		DEFAULT => -171
	},
	{#State 250
		ACTIONS => {
			'NOT' => 40,
			'LITERAL' => 257,
			'IDENT' => 2,
			"\"" => 62,
			"\$" => 44,
			"[" => 10,
			'NUMBER' => 26,
			'REF' => 27,
			"{" => 31,
			'COMMA' => 259,
			"(" => 54,
			"\${" => 38
		},
		DEFAULT => -163,
		GOTOS => {
			'expr' => 258,
			'sterm' => 70,
			'item' => 255,
			'param' => 256,
			'node' => 23,
			'ident' => 254,
			'term' => 60,
			'lterm' => 58
		}
	},
	{#State 251
		DEFAULT => -168
	},
	{#State 252
		DEFAULT => -166
	},
	{#State 253
		ACTIONS => {
			'NOT' => 40,
			"{" => 31,
			'COMMA' => 259,
			'LITERAL' => 257,
			'IDENT' => 2,
			"\"" => 62,
			"(" => 54,
			"\$" => 44,
			"[" => 10,
			'NUMBER' => 26,
			'REF' => 27,
			")" => 291,
			"\${" => 38
		},
		GOTOS => {
			'expr' => 258,
			'sterm' => 70,
			'item' => 255,
			'param' => 256,
			'node' => 23,
			'ident' => 254,
			'term' => 60,
			'lterm' => 58
		}
	},
	{#State 254
		ACTIONS => {
			'DOT' => 105,
			'ASSIGN' => 292
		},
		DEFAULT => -110
	},
	{#State 255
		ACTIONS => {
			"(" => 137,
			'ASSIGN' => 211
		},
		DEFAULT => -129
	},
	{#State 256
		DEFAULT => -154
	},
	{#State 257
		ACTIONS => {
			'ASSIGN' => 214
		},
		DEFAULT => -113
	},
	{#State 258
		ACTIONS => {
			"+" => 159,
			'CAT' => 165,
			'CMPOP' => 166,
			"?" => 160,
			'DIV' => 161,
			'MOD' => 167,
			"/" => 168,
			'AND' => 162,
			'BINOP' => 163,
			'OR' => 164
		},
		DEFAULT => -153
	},
	{#State 259
		DEFAULT => -156
	},
	{#State 260
		DEFAULT => -118
	},
	{#State 261
		ACTIONS => {
			";" => 293
		}
	},
	{#State 262
		ACTIONS => {
			'END' => 294
		}
	},
	{#State 263
		ACTIONS => {
			";" => 296,
			'DEFAULT' => 297,
			'FILENAME' => 85,
			'IDENT' => 83,
			'NUMBER' => 86
		},
		GOTOS => {
			'filepart' => 89,
			'filename' => 295
		}
	},
	{#State 264
		DEFAULT => -103
	},
	{#State 265
		DEFAULT => -101
	},
	{#State 266
		ACTIONS => {
			'TEXT' => 298
		}
	},
	{#State 267
		ACTIONS => {
			'END' => 299
		}
	},
	{#State 268
		ACTIONS => {
			'SET' => 1,
			'NOT' => 40,
			'IDENT' => 2,
			'CLEAR' => 42,
			'UNLESS' => 4,
			'IF' => 45,
			"\$" => 44,
			'STOP' => 7,
			'CALL' => 46,
			'THROW' => 9,
			'GET' => 48,
			"[" => 10,
			'TRY' => 11,
			'LAST' => 50,
			'DEBUG' => 52,
			'META' => 15,
			'INCLUDE' => 17,
			"(" => 54,
			'SWITCH' => 55,
			'MACRO' => 18,
			'JAVASCRIPT' => 56,
			'WRAPPER' => 57,
			";" => -19,
			'FOR' => 21,
			'LITERAL' => 59,
			'NEXT' => 22,
			'rawperl' => 61,
			"\"" => 62,
			'TEXT' => 24,
			'PROCESS' => 63,
			'RETURN' => 66,
			'FILTER' => 25,
			'INSERT' => 67,
			'NUMBER' => 26,
			'REF' => 27,
			'WHILE' => 69,
			'RAW' => 28,
			'BLOCK' => 29,
			'DEFAULT' => 71,
			"{" => 31,
			'perl' => 32,
			'USE' => 33,
			'VIEW' => 37,
			"\${" => 38
		},
		DEFAULT => -3,
		GOTOS => {
			'item' => 41,
			'javascript' => 3,
			'node' => 23,
			'term' => 60,
			'loop' => 5,
			'use' => 65,
			'expr' => 64,
			'capture' => 43,
			'statement' => 6,
			'view' => 8,
			'wrapper' => 47,
			'atomexpr' => 49,
			'chunk' => 12,
			'defblock' => 68,
			'atomdir' => 13,
			'anonblock' => 51,
			'sterm' => 70,
			'defblockname' => 14,
			'filter' => 30,
			'ident' => 16,
			'setlist' => 72,
			'chunks' => 34,
			'try' => 36,
			'switch' => 35,
			'assign' => 19,
			'block' => 300,
			'directive' => 73,
			'macro' => 20,
			'condition' => 75,
			'lterm' => 58,
			'raw' => 39
		}
	},
	{#State 269
		ACTIONS => {
			'IDENT' => -97,
			")" => -97,
			'COMMA' => -97
		},
		DEFAULT => -131
	},
	{#State 270
		ACTIONS => {
			'COMMA' => 303,
			'IDENT' => 301,
			")" => 302
		}
	},
	{#State 271
		DEFAULT => -157,
		GOTOS => {
			'args' => 304
		}
	},
	{#State 272
		DEFAULT => -157,
		GOTOS => {
			'args' => 305
		}
	},
	{#State 273
		ACTIONS => {
			'SET' => 1,
			'NOT' => 40,
			'IDENT' => 2,
			'CLEAR' => 42,
			'UNLESS' => 4,
			'IF' => 45,
			"\$" => 44,
			'STOP' => 7,
			'CALL' => 46,
			'THROW' => 9,
			'GET' => 48,
			"[" => 10,
			'TRY' => 11,
			'LAST' => 50,
			'DEBUG' => 52,
			'META' => 15,
			'INCLUDE' => 17,
			"(" => 54,
			'SWITCH' => 55,
			'MACRO' => 18,
			'JAVASCRIPT' => 56,
			'WRAPPER' => 57,
			";" => -19,
			'FOR' => 21,
			'LITERAL' => 59,
			'NEXT' => 22,
			'rawperl' => 61,
			"\"" => 62,
			'TEXT' => 24,
			'PROCESS' => 63,
			'RETURN' => 66,
			'FILTER' => 25,
			'INSERT' => 67,
			'NUMBER' => 26,
			'REF' => 27,
			'WHILE' => 69,
			'RAW' => 28,
			'BLOCK' => 29,
			'DEFAULT' => 71,
			"{" => 31,
			'perl' => 32,
			'USE' => 33,
			'VIEW' => 37,
			"\${" => 38
		},
		DEFAULT => -3,
		GOTOS => {
			'item' => 41,
			'javascript' => 3,
			'node' => 23,
			'term' => 60,
			'loop' => 5,
			'use' => 65,
			'expr' => 64,
			'capture' => 43,
			'statement' => 6,
			'view' => 8,
			'wrapper' => 47,
			'atomexpr' => 49,
			'chunk' => 12,
			'defblock' => 68,
			'atomdir' => 13,
			'anonblock' => 51,
			'sterm' => 70,
			'defblockname' => 14,
			'filter' => 30,
			'ident' => 16,
			'setlist' => 72,
			'chunks' => 34,
			'try' => 36,
			'switch' => 35,
			'assign' => 19,
			'block' => 306,
			'directive' => 73,
			'macro' => 20,
			'condition' => 75,
			'lterm' => 58,
			'raw' => 39
		}
	},
	{#State 274
		DEFAULT => -158
	},
	{#State 275
		ACTIONS => {
			'END' => 307
		}
	},
	{#State 276
		ACTIONS => {
			'ASSIGN' => -161
		},
		DEFAULT => -168
	},
	{#State 277
		ACTIONS => {
			'END' => 308
		}
	},
	{#State 278
		ACTIONS => {
			'DIV' => 161,
			'AND' => 162,
			'BINOP' => 163,
			'OR' => 164,
			"+" => 159,
			'CAT' => 165,
			'CMPOP' => 166,
			"?" => 160,
			'MOD' => 167,
			"/" => 168
		},
		DEFAULT => -125
	},
	{#State 279
		ACTIONS => {
			'DIV' => 161,
			'AND' => 162,
			'BINOP' => 163,
			'OR' => 164,
			"+" => 159,
			'CAT' => 165,
			'CMPOP' => 166,
			"?" => 160,
			'MOD' => 167,
			"/" => 168
		},
		DEFAULT => -124
	},
	{#State 280
		ACTIONS => {
			'SET' => 1,
			'NOT' => 40,
			'IDENT' => 2,
			'CLEAR' => 42,
			'UNLESS' => 4,
			'IF' => 45,
			"\$" => 44,
			'STOP' => 7,
			'CALL' => 46,
			'THROW' => 9,
			'GET' => 48,
			"[" => 10,
			'TRY' => 11,
			'LAST' => 50,
			'DEBUG' => 52,
			'META' => 15,
			'INCLUDE' => 17,
			"(" => 54,
			'SWITCH' => 55,
			'MACRO' => 18,
			'JAVASCRIPT' => 56,
			'WRAPPER' => 57,
			";" => -19,
			'FOR' => 21,
			'LITERAL' => 59,
			'NEXT' => 22,
			'rawperl' => 61,
			"\"" => 62,
			'TEXT' => 24,
			'PROCESS' => 63,
			'RETURN' => 66,
			'FILTER' => 25,
			'INSERT' => 67,
			'NUMBER' => 26,
			'REF' => 27,
			'WHILE' => 69,
			'RAW' => 28,
			'BLOCK' => 29,
			'DEFAULT' => 71,
			"{" => 31,
			'perl' => 32,
			'USE' => 33,
			'VIEW' => 37,
			"\${" => 38
		},
		DEFAULT => -3,
		GOTOS => {
			'item' => 41,
			'javascript' => 3,
			'node' => 23,
			'term' => 60,
			'loop' => 5,
			'use' => 65,
			'expr' => 64,
			'capture' => 43,
			'statement' => 6,
			'view' => 8,
			'wrapper' => 47,
			'atomexpr' => 49,
			'chunk' => 12,
			'defblock' => 68,
			'atomdir' => 13,
			'anonblock' => 51,
			'sterm' => 70,
			'defblockname' => 14,
			'filter' => 30,
			'ident' => 16,
			'setlist' => 72,
			'chunks' => 34,
			'try' => 36,
			'switch' => 35,
			'assign' => 19,
			'block' => 309,
			'directive' => 73,
			'macro' => 20,
			'condition' => 75,
			'lterm' => 58,
			'raw' => 39
		}
	},
	{#State 281
		DEFAULT => -130
	},
	{#State 282
		ACTIONS => {
			'ELSIF' => 290,
			'ELSE' => 288
		},
		DEFAULT => -52,
		GOTOS => {
			'else' => 310
		}
	},
	{#State 283
		ACTIONS => {
			'CASE' => 311
		},
		DEFAULT => -57,
		GOTOS => {
			'case' => 312
		}
	},
	{#State 284
		ACTIONS => {
			'END' => 313
		}
	},
	{#State 285
		ACTIONS => {
			'END' => 314
		}
	},
	{#State 286
		ACTIONS => {
			'NOT' => 40,
			"{" => 31,
			'LITERAL' => 80,
			'IDENT' => 2,
			"\"" => 62,
			"(" => 54,
			"\$" => 44,
			"[" => 10,
			'NUMBER' => 26,
			'REF' => 27,
			"\${" => 38
		},
		GOTOS => {
			'expr' => 315,
			'sterm' => 70,
			'item' => 41,
			'node' => 23,
			'ident' => 79,
			'term' => 60,
			'lterm' => 58
		}
	},
	{#State 287
		ACTIONS => {
			'SET' => 1,
			'NOT' => 40,
			'IDENT' => 2,
			'CLEAR' => 42,
			'UNLESS' => 4,
			'IF' => 45,
			"\$" => 44,
			'STOP' => 7,
			'CALL' => 46,
			'THROW' => 9,
			'GET' => 48,
			"[" => 10,
			'TRY' => 11,
			'LAST' => 50,
			'DEBUG' => 52,
			'META' => 15,
			'INCLUDE' => 17,
			"(" => 54,
			'SWITCH' => 55,
			'MACRO' => 18,
			'JAVASCRIPT' => 56,
			'WRAPPER' => 57,
			";" => -19,
			'FOR' => 21,
			'LITERAL' => 59,
			'NEXT' => 22,
			'rawperl' => 61,
			"\"" => 62,
			'TEXT' => 24,
			'PROCESS' => 63,
			'RETURN' => 66,
			'FILTER' => 25,
			'INSERT' => 67,
			'NUMBER' => 26,
			'REF' => 27,
			'WHILE' => 69,
			'RAW' => 28,
			'BLOCK' => 29,
			'DEFAULT' => 71,
			"{" => 31,
			'perl' => 32,
			'USE' => 33,
			'VIEW' => 37,
			"\${" => 38
		},
		DEFAULT => -3,
		GOTOS => {
			'item' => 41,
			'javascript' => 3,
			'node' => 23,
			'term' => 60,
			'loop' => 5,
			'use' => 65,
			'expr' => 64,
			'capture' => 43,
			'statement' => 6,
			'view' => 8,
			'wrapper' => 47,
			'atomexpr' => 49,
			'chunk' => 12,
			'defblock' => 68,
			'atomdir' => 13,
			'anonblock' => 51,
			'sterm' => 70,
			'defblockname' => 14,
			'filter' => 30,
			'ident' => 16,
			'setlist' => 72,
			'chunks' => 34,
			'try' => 36,
			'switch' => 35,
			'assign' => 19,
			'block' => 316,
			'directive' => 73,
			'macro' => 20,
			'condition' => 75,
			'lterm' => 58,
			'raw' => 39
		}
	},
	{#State 288
		ACTIONS => {
			";" => 317
		}
	},
	{#State 289
		ACTIONS => {
			'END' => 318
		}
	},
	{#State 290
		ACTIONS => {
			'NOT' => 40,
			"{" => 31,
			'LITERAL' => 80,
			'IDENT' => 2,
			"\"" => 62,
			"(" => 54,
			"\$" => 44,
			"[" => 10,
			'NUMBER' => 26,
			'REF' => 27,
			"\${" => 38
		},
		GOTOS => {
			'expr' => 319,
			'sterm' => 70,
			'item' => 41,
			'node' => 23,
			'ident' => 79,
			'term' => 60,
			'lterm' => 58
		}
	},
	{#State 291
		DEFAULT => -165
	},
	{#State 292
		ACTIONS => {
			'NOT' => 40,
			"{" => 31,
			'LITERAL' => 80,
			'IDENT' => 2,
			"\"" => 62,
			"(" => 54,
			"\$" => 44,
			"[" => 10,
			'NUMBER' => 26,
			'REF' => 27,
			"\${" => 38
		},
		GOTOS => {
			'expr' => 320,
			'sterm' => 70,
			'item' => 41,
			'node' => 23,
			'ident' => 79,
			'term' => 60,
			'lterm' => 58
		}
	},
	{#State 293
		ACTIONS => {
			'SET' => 1,
			'NOT' => 40,
			'IDENT' => 2,
			'CLEAR' => 42,
			'UNLESS' => 4,
			'IF' => 45,
			"\$" => 44,
			'STOP' => 7,
			'CALL' => 46,
			'THROW' => 9,
			'GET' => 48,
			"[" => 10,
			'TRY' => 11,
			'LAST' => 50,
			'DEBUG' => 52,
			'META' => 15,
			'INCLUDE' => 17,
			"(" => 54,
			'SWITCH' => 55,
			'MACRO' => 18,
			'JAVASCRIPT' => 56,
			'WRAPPER' => 57,
			";" => -19,
			'FOR' => 21,
			'LITERAL' => 59,
			'NEXT' => 22,
			'rawperl' => 61,
			"\"" => 62,
			'TEXT' => 24,
			'PROCESS' => 63,
			'RETURN' => 66,
			'FILTER' => 25,
			'INSERT' => 67,
			'NUMBER' => 26,
			'REF' => 27,
			'WHILE' => 69,
			'RAW' => 28,
			'BLOCK' => 29,
			'DEFAULT' => 71,
			"{" => 31,
			'perl' => 32,
			'USE' => 33,
			'VIEW' => 37,
			"\${" => 38
		},
		DEFAULT => -3,
		GOTOS => {
			'item' => 41,
			'javascript' => 3,
			'node' => 23,
			'term' => 60,
			'loop' => 5,
			'use' => 65,
			'expr' => 64,
			'capture' => 43,
			'statement' => 6,
			'view' => 8,
			'wrapper' => 47,
			'atomexpr' => 49,
			'chunk' => 12,
			'defblock' => 68,
			'atomdir' => 13,
			'anonblock' => 51,
			'sterm' => 70,
			'defblockname' => 14,
			'filter' => 30,
			'ident' => 16,
			'setlist' => 72,
			'chunks' => 34,
			'try' => 36,
			'switch' => 35,
			'assign' => 19,
			'block' => 321,
			'directive' => 73,
			'macro' => 20,
			'condition' => 75,
			'lterm' => 58,
			'raw' => 39
		}
	},
	{#State 294
		DEFAULT => -69
	},
	{#State 295
		ACTIONS => {
			'DOT' => 176,
			";" => 322
		}
	},
	{#State 296
		ACTIONS => {
			'SET' => 1,
			'NOT' => 40,
			'IDENT' => 2,
			'CLEAR' => 42,
			'UNLESS' => 4,
			'IF' => 45,
			"\$" => 44,
			'STOP' => 7,
			'CALL' => 46,
			'THROW' => 9,
			'GET' => 48,
			"[" => 10,
			'TRY' => 11,
			'LAST' => 50,
			'DEBUG' => 52,
			'META' => 15,
			'INCLUDE' => 17,
			"(" => 54,
			'SWITCH' => 55,
			'MACRO' => 18,
			'JAVASCRIPT' => 56,
			'WRAPPER' => 57,
			";" => -19,
			'FOR' => 21,
			'LITERAL' => 59,
			'NEXT' => 22,
			'rawperl' => 61,
			"\"" => 62,
			'TEXT' => 24,
			'PROCESS' => 63,
			'RETURN' => 66,
			'FILTER' => 25,
			'INSERT' => 67,
			'NUMBER' => 26,
			'REF' => 27,
			'WHILE' => 69,
			'RAW' => 28,
			'BLOCK' => 29,
			'DEFAULT' => 71,
			"{" => 31,
			'perl' => 32,
			'USE' => 33,
			'VIEW' => 37,
			"\${" => 38
		},
		DEFAULT => -3,
		GOTOS => {
			'item' => 41,
			'javascript' => 3,
			'node' => 23,
			'term' => 60,
			'loop' => 5,
			'use' => 65,
			'expr' => 64,
			'capture' => 43,
			'statement' => 6,
			'view' => 8,
			'wrapper' => 47,
			'atomexpr' => 49,
			'chunk' => 12,
			'defblock' => 68,
			'atomdir' => 13,
			'anonblock' => 51,
			'sterm' => 70,
			'defblockname' => 14,
			'filter' => 30,
			'ident' => 16,
			'setlist' => 72,
			'chunks' => 34,
			'try' => 36,
			'switch' => 35,
			'assign' => 19,
			'block' => 323,
			'directive' => 73,
			'macro' => 20,
			'condition' => 75,
			'lterm' => 58,
			'raw' => 39
		}
	},
	{#State 297
		ACTIONS => {
			";" => 324
		}
	},
	{#State 298
		ACTIONS => {
			"\"" => 325
		}
	},
	{#State 299
		DEFAULT => -83
	},
	{#State 300
		ACTIONS => {
			'END' => 326
		}
	},
	{#State 301
		DEFAULT => -95
	},
	{#State 302
		ACTIONS => {
			'SET' => 1,
			'NOT' => 40,
			'IDENT' => 2,
			'CLEAR' => 42,
			'UNLESS' => 4,
			'IF' => 45,
			"\$" => 44,
			'STOP' => 7,
			'CALL' => 46,
			'THROW' => 9,
			'GET' => 48,
			"[" => 10,
			'TRY' => 11,
			'LAST' => 50,
			'DEBUG' => 52,
			'INCLUDE' => 17,
			"(" => 54,
			'SWITCH' => 55,
			'JAVASCRIPT' => 56,
			'WRAPPER' => 57,
			'FOR' => 21,
			'NEXT' => 22,
			'LITERAL' => 59,
			"\"" => 62,
			'PROCESS' => 63,
			'FILTER' => 25,
			'RETURN' => 66,
			'INSERT' => 67,
			'NUMBER' => 26,
			'REF' => 27,
			'WHILE' => 69,
			'BLOCK' => 194,
			'DEFAULT' => 71,
			"{" => 31,
			'perl' => 32,
			"\${" => 38
		},
		GOTOS => {
			'item' => 41,
			'javascript' => 3,
			'node' => 23,
			'term' => 60,
			'loop' => 5,
			'expr' => 200,
			'wrapper' => 47,
			'atomexpr' => 49,
			'atomdir' => 13,
			'mdir' => 327,
			'filter' => 30,
			'sterm' => 70,
			'ident' => 150,
			'setlist' => 72,
			'try' => 36,
			'switch' => 35,
			'assign' => 19,
			'directive' => 197,
			'condition' => 75,
			'lterm' => 58
		}
	},
	{#State 303
		DEFAULT => -96
	},
	{#State 304
		ACTIONS => {
			'NOT' => 40,
			"{" => 31,
			'COMMA' => 259,
			'LITERAL' => 257,
			'IDENT' => 2,
			"\"" => 62,
			"(" => 54,
			"\$" => 44,
			"[" => 10,
			'NUMBER' => 26,
			'REF' => 27,
			"\${" => 38
		},
		DEFAULT => -64,
		GOTOS => {
			'expr' => 258,
			'sterm' => 70,
			'item' => 255,
			'param' => 256,
			'node' => 23,
			'ident' => 254,
			'term' => 60,
			'lterm' => 58
		}
	},
	{#State 305
		ACTIONS => {
			'NOT' => 40,
			"{" => 31,
			'COMMA' => 259,
			'LITERAL' => 257,
			'IDENT' => 2,
			"\"" => 62,
			"(" => 54,
			"\$" => 44,
			"[" => 10,
			'NUMBER' => 26,
			'REF' => 27,
			"\${" => 38
		},
		DEFAULT => -65,
		GOTOS => {
			'expr' => 258,
			'sterm' => 70,
			'item' => 255,
			'param' => 256,
			'node' => 23,
			'ident' => 254,
			'term' => 60,
			'lterm' => 58
		}
	},
	{#State 306
		ACTIONS => {
			'END' => 328
		}
	},
	{#State 307
		DEFAULT => -81
	},
	{#State 308
		DEFAULT => -89
	},
	{#State 309
		ACTIONS => {
			'END' => 329
		}
	},
	{#State 310
		ACTIONS => {
			'END' => 330
		}
	},
	{#State 311
		ACTIONS => {
			";" => 331,
			'DEFAULT' => 333,
			"{" => 31,
			'LITERAL' => 80,
			'IDENT' => 2,
			"\"" => 62,
			"\$" => 44,
			"[" => 10,
			'NUMBER' => 26,
			'REF' => 27,
			"\${" => 38
		},
		GOTOS => {
			'sterm' => 70,
			'item' => 41,
			'node' => 23,
			'ident' => 79,
			'term' => 332,
			'lterm' => 58
		}
	},
	{#State 312
		ACTIONS => {
			'END' => 334
		}
	},
	{#State 313
		DEFAULT => -80
	},
	{#State 314
		DEFAULT => -67
	},
	{#State 315
		ACTIONS => {
			'DIV' => 161,
			'AND' => 162,
			'BINOP' => 163,
			'OR' => 164,
			"+" => 159,
			'CAT' => 165,
			'CMPOP' => 166,
			"?" => 160,
			'MOD' => 167,
			"/" => 168
		},
		DEFAULT => -144
	},
	{#State 316
		ACTIONS => {
			'END' => 335
		}
	},
	{#State 317
		ACTIONS => {
			'SET' => 1,
			'NOT' => 40,
			'IDENT' => 2,
			'CLEAR' => 42,
			'UNLESS' => 4,
			'IF' => 45,
			"\$" => 44,
			'STOP' => 7,
			'CALL' => 46,
			'THROW' => 9,
			'GET' => 48,
			"[" => 10,
			'TRY' => 11,
			'LAST' => 50,
			'DEBUG' => 52,
			'META' => 15,
			'INCLUDE' => 17,
			"(" => 54,
			'SWITCH' => 55,
			'MACRO' => 18,
			'JAVASCRIPT' => 56,
			'WRAPPER' => 57,
			";" => -19,
			'FOR' => 21,
			'LITERAL' => 59,
			'NEXT' => 22,
			'rawperl' => 61,
			"\"" => 62,
			'TEXT' => 24,
			'PROCESS' => 63,
			'RETURN' => 66,
			'FILTER' => 25,
			'INSERT' => 67,
			'NUMBER' => 26,
			'REF' => 27,
			'WHILE' => 69,
			'RAW' => 28,
			'BLOCK' => 29,
			'DEFAULT' => 71,
			"{" => 31,
			'perl' => 32,
			'USE' => 33,
			'VIEW' => 37,
			"\${" => 38
		},
		DEFAULT => -3,
		GOTOS => {
			'item' => 41,
			'javascript' => 3,
			'node' => 23,
			'term' => 60,
			'loop' => 5,
			'use' => 65,
			'expr' => 64,
			'capture' => 43,
			'statement' => 6,
			'view' => 8,
			'wrapper' => 47,
			'atomexpr' => 49,
			'chunk' => 12,
			'defblock' => 68,
			'atomdir' => 13,
			'anonblock' => 51,
			'sterm' => 70,
			'defblockname' => 14,
			'filter' => 30,
			'ident' => 16,
			'setlist' => 72,
			'chunks' => 34,
			'try' => 36,
			'switch' => 35,
			'assign' => 19,
			'block' => 336,
			'directive' => 73,
			'macro' => 20,
			'condition' => 75,
			'lterm' => 58,
			'raw' => 39
		}
	},
	{#State 318
		DEFAULT => -48
	},
	{#State 319
		ACTIONS => {
			'CMPOP' => 166,
			"?" => 160,
			";" => 337,
			"+" => 159,
			'MOD' => 167,
			'DIV' => 161,
			"/" => 168,
			'AND' => 162,
			'CAT' => 165,
			'BINOP' => 163,
			'OR' => 164
		}
	},
	{#State 320
		ACTIONS => {
			"+" => 159,
			'CAT' => 165,
			'CMPOP' => 166,
			"?" => 160,
			'DIV' => 161,
			'MOD' => 167,
			"/" => 168,
			'AND' => 162,
			'BINOP' => 163,
			'OR' => 164
		},
		DEFAULT => -155
	},
	{#State 321
		DEFAULT => -73
	},
	{#State 322
		ACTIONS => {
			'SET' => 1,
			'NOT' => 40,
			'IDENT' => 2,
			'CLEAR' => 42,
			'UNLESS' => 4,
			'IF' => 45,
			"\$" => 44,
			'STOP' => 7,
			'CALL' => 46,
			'THROW' => 9,
			'GET' => 48,
			"[" => 10,
			'TRY' => 11,
			'LAST' => 50,
			'DEBUG' => 52,
			'META' => 15,
			'INCLUDE' => 17,
			"(" => 54,
			'SWITCH' => 55,
			'MACRO' => 18,
			'JAVASCRIPT' => 56,
			'WRAPPER' => 57,
			";" => -19,
			'FOR' => 21,
			'LITERAL' => 59,
			'NEXT' => 22,
			'rawperl' => 61,
			"\"" => 62,
			'TEXT' => 24,
			'PROCESS' => 63,
			'RETURN' => 66,
			'FILTER' => 25,
			'INSERT' => 67,
			'NUMBER' => 26,
			'REF' => 27,
			'WHILE' => 69,
			'RAW' => 28,
			'BLOCK' => 29,
			'DEFAULT' => 71,
			"{" => 31,
			'perl' => 32,
			'USE' => 33,
			'VIEW' => 37,
			"\${" => 38
		},
		DEFAULT => -3,
		GOTOS => {
			'item' => 41,
			'javascript' => 3,
			'node' => 23,
			'term' => 60,
			'loop' => 5,
			'use' => 65,
			'expr' => 64,
			'capture' => 43,
			'statement' => 6,
			'view' => 8,
			'wrapper' => 47,
			'atomexpr' => 49,
			'chunk' => 12,
			'defblock' => 68,
			'atomdir' => 13,
			'anonblock' => 51,
			'sterm' => 70,
			'defblockname' => 14,
			'filter' => 30,
			'ident' => 16,
			'setlist' => 72,
			'chunks' => 34,
			'try' => 36,
			'switch' => 35,
			'assign' => 19,
			'block' => 338,
			'directive' => 73,
			'macro' => 20,
			'condition' => 75,
			'lterm' => 58,
			'raw' => 39
		}
	},
	{#State 323
		ACTIONS => {
			'FINAL' => 261,
			'CATCH' => 263
		},
		DEFAULT => -74,
		GOTOS => {
			'final' => 339
		}
	},
	{#State 324
		ACTIONS => {
			'SET' => 1,
			'NOT' => 40,
			'IDENT' => 2,
			'CLEAR' => 42,
			'UNLESS' => 4,
			'IF' => 45,
			"\$" => 44,
			'STOP' => 7,
			'CALL' => 46,
			'THROW' => 9,
			'GET' => 48,
			"[" => 10,
			'TRY' => 11,
			'LAST' => 50,
			'DEBUG' => 52,
			'META' => 15,
			'INCLUDE' => 17,
			"(" => 54,
			'SWITCH' => 55,
			'MACRO' => 18,
			'JAVASCRIPT' => 56,
			'WRAPPER' => 57,
			";" => -19,
			'FOR' => 21,
			'LITERAL' => 59,
			'NEXT' => 22,
			'rawperl' => 61,
			"\"" => 62,
			'TEXT' => 24,
			'PROCESS' => 63,
			'RETURN' => 66,
			'FILTER' => 25,
			'INSERT' => 67,
			'NUMBER' => 26,
			'REF' => 27,
			'WHILE' => 69,
			'RAW' => 28,
			'BLOCK' => 29,
			'DEFAULT' => 71,
			"{" => 31,
			'perl' => 32,
			'USE' => 33,
			'VIEW' => 37,
			"\${" => 38
		},
		DEFAULT => -3,
		GOTOS => {
			'item' => 41,
			'javascript' => 3,
			'node' => 23,
			'term' => 60,
			'loop' => 5,
			'use' => 65,
			'expr' => 64,
			'capture' => 43,
			'statement' => 6,
			'view' => 8,
			'wrapper' => 47,
			'atomexpr' => 49,
			'chunk' => 12,
			'defblock' => 68,
			'atomdir' => 13,
			'anonblock' => 51,
			'sterm' => 70,
			'defblockname' => 14,
			'filter' => 30,
			'ident' => 16,
			'setlist' => 72,
			'chunks' => 34,
			'try' => 36,
			'switch' => 35,
			'assign' => 19,
			'block' => 340,
			'directive' => 73,
			'macro' => 20,
			'condition' => 75,
			'lterm' => 58,
			'raw' => 39
		}
	},
	{#State 325
		DEFAULT => -102
	},
	{#State 326
		DEFAULT => -94
	},
	{#State 327
		DEFAULT => -91
	},
	{#State 328
		DEFAULT => -59
	},
	{#State 329
		DEFAULT => -78
	},
	{#State 330
		DEFAULT => -46
	},
	{#State 331
		ACTIONS => {
			'SET' => 1,
			'NOT' => 40,
			'IDENT' => 2,
			'CLEAR' => 42,
			'UNLESS' => 4,
			'IF' => 45,
			"\$" => 44,
			'STOP' => 7,
			'CALL' => 46,
			'THROW' => 9,
			'GET' => 48,
			"[" => 10,
			'TRY' => 11,
			'LAST' => 50,
			'DEBUG' => 52,
			'META' => 15,
			'INCLUDE' => 17,
			"(" => 54,
			'SWITCH' => 55,
			'MACRO' => 18,
			'JAVASCRIPT' => 56,
			'WRAPPER' => 57,
			";" => -19,
			'FOR' => 21,
			'LITERAL' => 59,
			'NEXT' => 22,
			'rawperl' => 61,
			"\"" => 62,
			'TEXT' => 24,
			'PROCESS' => 63,
			'RETURN' => 66,
			'FILTER' => 25,
			'INSERT' => 67,
			'NUMBER' => 26,
			'REF' => 27,
			'WHILE' => 69,
			'RAW' => 28,
			'BLOCK' => 29,
			'DEFAULT' => 71,
			"{" => 31,
			'perl' => 32,
			'USE' => 33,
			'VIEW' => 37,
			"\${" => 38
		},
		DEFAULT => -3,
		GOTOS => {
			'item' => 41,
			'javascript' => 3,
			'node' => 23,
			'term' => 60,
			'loop' => 5,
			'use' => 65,
			'expr' => 64,
			'capture' => 43,
			'statement' => 6,
			'view' => 8,
			'wrapper' => 47,
			'atomexpr' => 49,
			'chunk' => 12,
			'defblock' => 68,
			'atomdir' => 13,
			'anonblock' => 51,
			'sterm' => 70,
			'defblockname' => 14,
			'filter' => 30,
			'ident' => 16,
			'setlist' => 72,
			'chunks' => 34,
			'try' => 36,
			'switch' => 35,
			'assign' => 19,
			'block' => 341,
			'directive' => 73,
			'macro' => 20,
			'condition' => 75,
			'lterm' => 58,
			'raw' => 39
		}
	},
	{#State 332
		ACTIONS => {
			";" => 342
		}
	},
	{#State 333
		ACTIONS => {
			";" => 343
		}
	},
	{#State 334
		DEFAULT => -53
	},
	{#State 335
		DEFAULT => -62
	},
	{#State 336
		DEFAULT => -51
	},
	{#State 337
		ACTIONS => {
			'SET' => 1,
			'NOT' => 40,
			'IDENT' => 2,
			'CLEAR' => 42,
			'UNLESS' => 4,
			'IF' => 45,
			"\$" => 44,
			'STOP' => 7,
			'CALL' => 46,
			'THROW' => 9,
			'GET' => 48,
			"[" => 10,
			'TRY' => 11,
			'LAST' => 50,
			'DEBUG' => 52,
			'META' => 15,
			'INCLUDE' => 17,
			"(" => 54,
			'SWITCH' => 55,
			'MACRO' => 18,
			'JAVASCRIPT' => 56,
			'WRAPPER' => 57,
			";" => -19,
			'FOR' => 21,
			'LITERAL' => 59,
			'NEXT' => 22,
			'rawperl' => 61,
			"\"" => 62,
			'TEXT' => 24,
			'PROCESS' => 63,
			'RETURN' => 66,
			'FILTER' => 25,
			'INSERT' => 67,
			'NUMBER' => 26,
			'REF' => 27,
			'WHILE' => 69,
			'RAW' => 28,
			'BLOCK' => 29,
			'DEFAULT' => 71,
			"{" => 31,
			'perl' => 32,
			'USE' => 33,
			'VIEW' => 37,
			"\${" => 38
		},
		DEFAULT => -3,
		GOTOS => {
			'item' => 41,
			'javascript' => 3,
			'node' => 23,
			'term' => 60,
			'loop' => 5,
			'use' => 65,
			'expr' => 64,
			'capture' => 43,
			'statement' => 6,
			'view' => 8,
			'wrapper' => 47,
			'atomexpr' => 49,
			'chunk' => 12,
			'defblock' => 68,
			'atomdir' => 13,
			'anonblock' => 51,
			'sterm' => 70,
			'defblockname' => 14,
			'filter' => 30,
			'ident' => 16,
			'setlist' => 72,
			'chunks' => 34,
			'try' => 36,
			'switch' => 35,
			'assign' => 19,
			'block' => 344,
			'directive' => 73,
			'macro' => 20,
			'condition' => 75,
			'lterm' => 58,
			'raw' => 39
		}
	},
	{#State 338
		ACTIONS => {
			'FINAL' => 261,
			'CATCH' => 263
		},
		DEFAULT => -74,
		GOTOS => {
			'final' => 345
		}
	},
	{#State 339
		DEFAULT => -72
	},
	{#State 340
		ACTIONS => {
			'FINAL' => 261,
			'CATCH' => 263
		},
		DEFAULT => -74,
		GOTOS => {
			'final' => 346
		}
	},
	{#State 341
		DEFAULT => -56
	},
	{#State 342
		ACTIONS => {
			'SET' => 1,
			'NOT' => 40,
			'IDENT' => 2,
			'CLEAR' => 42,
			'UNLESS' => 4,
			'IF' => 45,
			"\$" => 44,
			'STOP' => 7,
			'CALL' => 46,
			'THROW' => 9,
			'GET' => 48,
			"[" => 10,
			'TRY' => 11,
			'LAST' => 50,
			'DEBUG' => 52,
			'META' => 15,
			'INCLUDE' => 17,
			"(" => 54,
			'SWITCH' => 55,
			'MACRO' => 18,
			'JAVASCRIPT' => 56,
			'WRAPPER' => 57,
			";" => -19,
			'FOR' => 21,
			'LITERAL' => 59,
			'NEXT' => 22,
			'rawperl' => 61,
			"\"" => 62,
			'TEXT' => 24,
			'PROCESS' => 63,
			'RETURN' => 66,
			'FILTER' => 25,
			'INSERT' => 67,
			'NUMBER' => 26,
			'REF' => 27,
			'WHILE' => 69,
			'RAW' => 28,
			'BLOCK' => 29,
			'DEFAULT' => 71,
			"{" => 31,
			'perl' => 32,
			'USE' => 33,
			'VIEW' => 37,
			"\${" => 38
		},
		DEFAULT => -3,
		GOTOS => {
			'item' => 41,
			'javascript' => 3,
			'node' => 23,
			'term' => 60,
			'loop' => 5,
			'use' => 65,
			'expr' => 64,
			'capture' => 43,
			'statement' => 6,
			'view' => 8,
			'wrapper' => 47,
			'atomexpr' => 49,
			'chunk' => 12,
			'defblock' => 68,
			'atomdir' => 13,
			'anonblock' => 51,
			'sterm' => 70,
			'defblockname' => 14,
			'filter' => 30,
			'ident' => 16,
			'setlist' => 72,
			'chunks' => 34,
			'try' => 36,
			'switch' => 35,
			'assign' => 19,
			'block' => 347,
			'directive' => 73,
			'macro' => 20,
			'condition' => 75,
			'lterm' => 58,
			'raw' => 39
		}
	},
	{#State 343
		ACTIONS => {
			'SET' => 1,
			'NOT' => 40,
			'IDENT' => 2,
			'CLEAR' => 42,
			'UNLESS' => 4,
			'IF' => 45,
			"\$" => 44,
			'STOP' => 7,
			'CALL' => 46,
			'THROW' => 9,
			'GET' => 48,
			"[" => 10,
			'TRY' => 11,
			'LAST' => 50,
			'DEBUG' => 52,
			'META' => 15,
			'INCLUDE' => 17,
			"(" => 54,
			'SWITCH' => 55,
			'MACRO' => 18,
			'JAVASCRIPT' => 56,
			'WRAPPER' => 57,
			";" => -19,
			'FOR' => 21,
			'LITERAL' => 59,
			'NEXT' => 22,
			'rawperl' => 61,
			"\"" => 62,
			'TEXT' => 24,
			'PROCESS' => 63,
			'RETURN' => 66,
			'FILTER' => 25,
			'INSERT' => 67,
			'NUMBER' => 26,
			'REF' => 27,
			'WHILE' => 69,
			'RAW' => 28,
			'BLOCK' => 29,
			'DEFAULT' => 71,
			"{" => 31,
			'perl' => 32,
			'USE' => 33,
			'VIEW' => 37,
			"\${" => 38
		},
		DEFAULT => -3,
		GOTOS => {
			'item' => 41,
			'javascript' => 3,
			'node' => 23,
			'term' => 60,
			'loop' => 5,
			'use' => 65,
			'expr' => 64,
			'capture' => 43,
			'statement' => 6,
			'view' => 8,
			'wrapper' => 47,
			'atomexpr' => 49,
			'chunk' => 12,
			'defblock' => 68,
			'atomdir' => 13,
			'anonblock' => 51,
			'sterm' => 70,
			'defblockname' => 14,
			'filter' => 30,
			'ident' => 16,
			'setlist' => 72,
			'chunks' => 34,
			'try' => 36,
			'switch' => 35,
			'assign' => 19,
			'block' => 348,
			'directive' => 73,
			'macro' => 20,
			'condition' => 75,
			'lterm' => 58,
			'raw' => 39
		}
	},
	{#State 344
		ACTIONS => {
			'ELSIF' => 290,
			'ELSE' => 288
		},
		DEFAULT => -52,
		GOTOS => {
			'else' => 349
		}
	},
	{#State 345
		DEFAULT => -70
	},
	{#State 346
		DEFAULT => -71
	},
	{#State 347
		ACTIONS => {
			'CASE' => 311
		},
		DEFAULT => -57,
		GOTOS => {
			'case' => 350
		}
	},
	{#State 348
		DEFAULT => -55
	},
	{#State 349
		DEFAULT => -50
	},
	{#State 350
		DEFAULT => -54
	}
]; 


#========================================================================
# Rules
#========================================================================

$RULES = [
	[#Rule 0
		 '$start', 2, undef
	],
	[#Rule 1
		 'template', 1,
sub
#line 68 "Parser.yp"
{ $factory->template($_[1])           }
	],
	[#Rule 2
		 'block', 1,
sub
#line 71 "Parser.yp"
{ $factory->block($_[1])              }
	],
	[#Rule 3
		 'block', 0,
sub
#line 72 "Parser.yp"
{ $factory->block()                   }
	],
	[#Rule 4
		 'chunks', 2,
sub
#line 75 "Parser.yp"
{ push(@{$_[1]}, $_[2]) 
					if defined $_[2]; $_[1]           }
	],
	[#Rule 5
		 'chunks', 1,
sub
#line 77 "Parser.yp"
{ defined $_[1] ? [ $_[1] ] : [ ]     }
	],
	[#Rule 6
		 'chunk', 1,
sub
#line 80 "Parser.yp"
{ $factory->textblock($_[1])          }
	],
	[#Rule 7
		 'chunk', 2,
sub
#line 81 "Parser.yp"
{ return '' unless $_[1];
                           $_[0]->location() . $_[1];
                         }
	],
	[#Rule 8
		 'statement', 1, undef
	],
	[#Rule 9
		 'statement', 1, undef
	],
	[#Rule 10
		 'statement', 1, undef
	],
	[#Rule 11
		 'statement', 1, undef
	],
	[#Rule 12
		 'statement', 1, undef
	],
	[#Rule 13
		 'statement', 1, undef
	],
	[#Rule 14
		 'statement', 1, undef
	],
	[#Rule 15
		 'statement', 1, undef
	],
	[#Rule 16
		 'statement', 1, undef
	],
	[#Rule 17
		 'statement', 1,
sub
#line 95 "Parser.yp"
{ $factory->get($_[1])                }
	],
	[#Rule 18
		 'statement', 2,
sub
#line 96 "Parser.yp"
{ $_[0]->add_metadata($_[2]);         }
	],
	[#Rule 19
		 'statement', 0, undef
	],
	[#Rule 20
		 'directive', 1,
sub
#line 100 "Parser.yp"
{ $factory->set($_[1])                }
	],
	[#Rule 21
		 'directive', 1, undef
	],
	[#Rule 22
		 'directive', 1, undef
	],
	[#Rule 23
		 'directive', 1, undef
	],
	[#Rule 24
		 'directive', 1, undef
	],
	[#Rule 25
		 'directive', 1, undef
	],
	[#Rule 26
		 'directive', 1, undef
	],
	[#Rule 27
		 'directive', 1, undef
	],
	[#Rule 28
		 'atomexpr', 1,
sub
#line 115 "Parser.yp"
{ $factory->get($_[1])                }
	],
	[#Rule 29
		 'atomexpr', 1, undef
	],
	[#Rule 30
		 'atomdir', 2,
sub
#line 119 "Parser.yp"
{ $factory->get($_[2])                }
	],
	[#Rule 31
		 'atomdir', 2,
sub
#line 120 "Parser.yp"
{ $factory->call($_[2])               }
	],
	[#Rule 32
		 'atomdir', 2,
sub
#line 121 "Parser.yp"
{ $factory->set($_[2])                }
	],
	[#Rule 33
		 'atomdir', 2,
sub
#line 122 "Parser.yp"
{ $factory->default($_[2])            }
	],
	[#Rule 34
		 'atomdir', 2,
sub
#line 123 "Parser.yp"
{ $factory->insert($_[2])             }
	],
	[#Rule 35
		 'atomdir', 2,
sub
#line 124 "Parser.yp"
{ $factory->include($_[2])            }
	],
	[#Rule 36
		 'atomdir', 2,
sub
#line 125 "Parser.yp"
{ $factory->process($_[2])            }
	],
	[#Rule 37
		 'atomdir', 2,
sub
#line 126 "Parser.yp"
{ $factory->throw($_[2])              }
	],
	[#Rule 38
		 'atomdir', 1,
sub
#line 127 "Parser.yp"
{ $factory->return()                  }
	],
	[#Rule 39
		 'atomdir', 1,
sub
#line 128 "Parser.yp"
{ $factory->stop()                    }
	],
	[#Rule 40
		 'atomdir', 1,
sub
#line 129 "Parser.yp"
{ $factory->clear()                   }
	],
	[#Rule 41
		 'atomdir', 1,
sub
#line 130 "Parser.yp"
{ $factory->break()                   }
	],
	[#Rule 42
		 'atomdir', 1,
sub
#line 131 "Parser.yp"
{ $factory->next()                    }
	],
	[#Rule 43
		 'atomdir', 2,
sub
#line 132 "Parser.yp"
{ if ($_[2]->[0]->[0] =~ /^'(on|off)'$/) {
				          $_[0]->{ DEBUG_DIRS } = ($1 eq 'on');
					  $factory->debug($_[2]);
				      }
				      else {
					  $_[0]->{ DEBUG_DIRS } ? $factory->debug($_[2]) : '';
				      }
				    }
	],
	[#Rule 44
		 'atomdir', 1, undef
	],
	[#Rule 45
		 'atomdir', 1, undef
	],
	[#Rule 46
		 'condition', 6,
sub
#line 145 "Parser.yp"
{ $factory->if(@_[2, 4, 5])           }
	],
	[#Rule 47
		 'condition', 3,
sub
#line 146 "Parser.yp"
{ $factory->if(@_[3, 1])              }
	],
	[#Rule 48
		 'condition', 6,
sub
#line 148 "Parser.yp"
{ $factory->if("!($_[2])", @_[4, 5])  }
	],
	[#Rule 49
		 'condition', 3,
sub
#line 149 "Parser.yp"
{ $factory->if("!($_[3])", $_[1])     }
	],
	[#Rule 50
		 'else', 5,
sub
#line 153 "Parser.yp"
{ unshift(@{$_[5]}, [ @_[2, 4] ]);
				      $_[5];                              }
	],
	[#Rule 51
		 'else', 3,
sub
#line 155 "Parser.yp"
{ [ $_[3] ]                           }
	],
	[#Rule 52
		 'else', 0,
sub
#line 156 "Parser.yp"
{ [ undef ]                           }
	],
	[#Rule 53
		 'switch', 6,
sub
#line 160 "Parser.yp"
{ $factory->switch(@_[2, 5])          }
	],
	[#Rule 54
		 'case', 5,
sub
#line 164 "Parser.yp"
{ unshift(@{$_[5]}, [ @_[2, 4] ]); 
				      $_[5];                              }
	],
	[#Rule 55
		 'case', 4,
sub
#line 166 "Parser.yp"
{ [ $_[4] ]                           }
	],
	[#Rule 56
		 'case', 3,
sub
#line 167 "Parser.yp"
{ [ $_[3] ]                           }
	],
	[#Rule 57
		 'case', 0,
sub
#line 168 "Parser.yp"
{ [ undef ]                           }
	],
	[#Rule 58
		 '@1-3', 0,
sub
#line 171 "Parser.yp"
{ $_[0]->{ INFOR }++                  }
	],
	[#Rule 59
		 'loop', 6,
sub
#line 172 "Parser.yp"
{ $_[0]->{ INFOR }--;
				      $factory->foreach(@{$_[2]}, $_[5])  }
	],
	[#Rule 60
		 'loop', 3,
sub
#line 176 "Parser.yp"
{ $factory->foreach(@{$_[3]}, $_[1])  }
	],
	[#Rule 61
		 '@2-3', 0,
sub
#line 177 "Parser.yp"
{ $_[0]->{ INWHILE }++                }
	],
	[#Rule 62
		 'loop', 6,
sub
#line 178 "Parser.yp"
{ $_[0]->{ INWHILE }--;
                                      $factory->while(@_[2, 5])           }
	],
	[#Rule 63
		 'loop', 3,
sub
#line 180 "Parser.yp"
{ $factory->while(@_[3, 1])           }
	],
	[#Rule 64
		 'loopvar', 4,
sub
#line 183 "Parser.yp"
{ [ @_[1, 3, 4] ]                     }
	],
	[#Rule 65
		 'loopvar', 4,
sub
#line 184 "Parser.yp"
{ [ @_[1, 3, 4] ]                     }
	],
	[#Rule 66
		 'loopvar', 2,
sub
#line 185 "Parser.yp"
{ [ 0, @_[1, 2] ]                     }
	],
	[#Rule 67
		 'wrapper', 5,
sub
#line 189 "Parser.yp"
{ $factory->wrapper(@_[2, 4])         }
	],
	[#Rule 68
		 'wrapper', 3,
sub
#line 191 "Parser.yp"
{ $factory->wrapper(@_[3, 1])         }
	],
	[#Rule 69
		 'try', 5,
sub
#line 195 "Parser.yp"
{ $factory->try(@_[3, 4])             }
	],
	[#Rule 70
		 'final', 5,
sub
#line 199 "Parser.yp"
{ unshift(@{$_[5]}, [ @_[2,4] ]);
				      $_[5];                              }
	],
	[#Rule 71
		 'final', 5,
sub
#line 202 "Parser.yp"
{ unshift(@{$_[5]}, [ undef, $_[4] ]);
				      $_[5];                              }
	],
	[#Rule 72
		 'final', 4,
sub
#line 205 "Parser.yp"
{ unshift(@{$_[4]}, [ undef, $_[3] ]);
				      $_[4];                              }
	],
	[#Rule 73
		 'final', 3,
sub
#line 207 "Parser.yp"
{ [ $_[3] ]                           }
	],
	[#Rule 74
		 'final', 0,
sub
#line 208 "Parser.yp"
{ [ 0 ] }
	],
	[#Rule 75
		 'use', 2,
sub
#line 211 "Parser.yp"
{ $factory->use($_[2])                }
	],
	[#Rule 76
		 'raw', 2,
sub
#line 214 "Parser.yp"
{ $factory->raw($_[2])                }
	],
	[#Rule 77
		 '@3-3', 0,
sub
#line 217 "Parser.yp"
{ $_[0]->push_defblock();		  }
	],
	[#Rule 78
		 'view', 6,
sub
#line 218 "Parser.yp"
{ $factory->view(@_[2,5], 
						     $_[0]->pop_defblock) }
	],
	[#Rule 79
		 '@4-2', 0,
sub
#line 222 "Parser.yp"
{ ${$_[0]->{ INJAVASCRIPT }}++;             }
	],
	[#Rule 80
		 'javascript', 5,
sub
#line 223 "Parser.yp"
{ ${$_[0]->{ INJAVASCRIPT }}--;
				      $_[0]->{ EVAL_JAVASCRIPT } 
				      ? $factory->javascript($_[4])             
				      : $factory->no_javascript();              }
	],
	[#Rule 81
		 'filter', 5,
sub
#line 230 "Parser.yp"
{ $factory->filter(@_[2,4])           }
	],
	[#Rule 82
		 'filter', 3,
sub
#line 232 "Parser.yp"
{ $factory->filter(@_[3,1])           }
	],
	[#Rule 83
		 'defblock', 5,
sub
#line 237 "Parser.yp"
{ my $name = join('/', @{ $_[0]->{ DEFBLOCKS } });
				      pop(@{ $_[0]->{ DEFBLOCKS } });
				      $_[0]->define_block($name, $_[4]); 
				      undef
				    }
	],
	[#Rule 84
		 'defblockname', 2,
sub
#line 244 "Parser.yp"
{ push(@{ $_[0]->{ DEFBLOCKS } }, $_[2]);
				      $_[2];
				    }
	],
	[#Rule 85
		 'blockname', 1, undef
	],
	[#Rule 86
		 'blockname', 1,
sub
#line 250 "Parser.yp"
{ $_[1] =~ s/^'(.*)'$/$1/; $_[1]      }
	],
	[#Rule 87
		 'blockargs', 1, undef
	],
	[#Rule 88
		 'blockargs', 0, undef
	],
	[#Rule 89
		 'anonblock', 5,
sub
#line 258 "Parser.yp"
{ local $" = ', ';
				      print STDERR "experimental block args: [@{ $_[2] }]\n"
					  if $_[2];
				      $factory->anon_block($_[4])         }
	],
	[#Rule 90
		 'capture', 3,
sub
#line 264 "Parser.yp"
{ $factory->capture(@_[1, 3])         }
	],
	[#Rule 91
		 'macro', 6,
sub
#line 268 "Parser.yp"
{ $factory->macro(@_[2, 6, 4])        }
	],
	[#Rule 92
		 'macro', 3,
sub
#line 269 "Parser.yp"
{ $factory->macro(@_[2, 3])           }
	],
	[#Rule 93
		 'mdir', 1, undef
	],
	[#Rule 94
		 'mdir', 4,
sub
#line 273 "Parser.yp"
{ $_[3]                               }
	],
	[#Rule 95
		 'margs', 2,
sub
#line 276 "Parser.yp"
{ push(@{$_[1]}, $_[2]); $_[1]        }
	],
	[#Rule 96
		 'margs', 2,
sub
#line 277 "Parser.yp"
{ $_[1]                               }
	],
	[#Rule 97
		 'margs', 1,
sub
#line 278 "Parser.yp"
{ [ $_[1] ]                           }
	],
	[#Rule 98
		 'metadata', 2,
sub
#line 281 "Parser.yp"
{ push(@{$_[1]}, @{$_[2]}); $_[1]     }
	],
	[#Rule 99
		 'metadata', 2, undef
	],
	[#Rule 100
		 'metadata', 1, undef
	],
	[#Rule 101
		 'meta', 3,
sub
#line 286 "Parser.yp"
{ for ($_[3]) { s/^'//; s/'$//; 
						       s/\\'/'/g  }; 
					 [ @_[1,3] ] }
	],
	[#Rule 102
		 'meta', 5,
sub
#line 289 "Parser.yp"
{ [ @_[1,4] ] }
	],
	[#Rule 103
		 'meta', 3,
sub
#line 290 "Parser.yp"
{ [ @_[1,3] ] }
	],
	[#Rule 104
		 'term', 1, undef
	],
	[#Rule 105
		 'term', 1, undef
	],
	[#Rule 106
		 'lterm', 3,
sub
#line 302 "Parser.yp"
{ "[ $_[2] ]"                         }
	],
	[#Rule 107
		 'lterm', 3,
sub
#line 303 "Parser.yp"
{ "[ $_[2] ]"                         }
	],
	[#Rule 108
		 'lterm', 2,
sub
#line 304 "Parser.yp"
{ "[ ]"                               }
	],
	[#Rule 109
		 'lterm', 3,
sub
#line 305 "Parser.yp"
{ "{ $_[2]  }"                        }
	],
	[#Rule 110
		 'sterm', 1,
sub
#line 308 "Parser.yp"
{ $factory->ident($_[1])              }
	],
	[#Rule 111
		 'sterm', 2,
sub
#line 309 "Parser.yp"
{ $factory->identref($_[2])           }
	],
	[#Rule 112
		 'sterm', 3,
sub
#line 310 "Parser.yp"
{ $factory->quoted($_[2])             }
	],
	[#Rule 113
		 'sterm', 1, undef
	],
	[#Rule 114
		 'sterm', 1, undef
	],
	[#Rule 115
		 'list', 2,
sub
#line 315 "Parser.yp"
{ "$_[1], $_[2]"                      }
	],
	[#Rule 116
		 'list', 2, undef
	],
	[#Rule 117
		 'list', 1, undef
	],
	[#Rule 118
		 'range', 3,
sub
#line 320 "Parser.yp"
{ $_[1] . '..' . $_[3]                }
	],
	[#Rule 119
		 'hash', 1, undef
	],
	[#Rule 120
		 'hash', 0,
sub
#line 325 "Parser.yp"
{ "" }
	],
	[#Rule 121
		 'params', 2,
sub
#line 328 "Parser.yp"
{ "$_[1], $_[2]"                      }
	],
	[#Rule 122
		 'params', 2, undef
	],
	[#Rule 123
		 'params', 1, undef
	],
	[#Rule 124
		 'param', 3,
sub
#line 333 "Parser.yp"
{ "$_[1]: $_[3]"                    }
	],
	[#Rule 125
		 'param', 3,
sub
#line 334 "Parser.yp"
{ "$_[1]: $_[3]"                    }
	],
	[#Rule 126
		 'ident', 3,
sub
#line 337 "Parser.yp"
{ push(@{$_[1]}, @{$_[3]}); $_[1]     }
	],
	[#Rule 127
		 'ident', 3,
sub
#line 338 "Parser.yp"
{ push(@{$_[1]}, 
					   map {($_, 0)} split(/\./, $_[3]));
				      $_[1];			          }
	],
	[#Rule 128
		 'ident', 1, undef
	],
	[#Rule 129
		 'node', 1,
sub
#line 344 "Parser.yp"
{ [ $_[1], 0 ]                        }
	],
	[#Rule 130
		 'node', 4,
sub
#line 345 "Parser.yp"
{ [ $_[1], $factory->args($_[3]) ]    }
	],
	[#Rule 131
		 'item', 1,
sub
#line 348 "Parser.yp"
{ "'$_[1]'"                           }
	],
	[#Rule 132
		 'item', 3,
sub
#line 349 "Parser.yp"
{ $_[2]                               }
	],
	[#Rule 133
		 'item', 2,
sub
#line 350 "Parser.yp"
{ $_[0]->{ V1DOLLAR }
				       ? "'$_[2]'" 
				       : $factory->ident(["'$_[2]'", 0])  }
	],
	[#Rule 134
		 'expr', 3,
sub
#line 355 "Parser.yp"
{ "$_[1] $_[2] $_[3]"                 }
	],
	[#Rule 135
		 'expr', 3,
sub
#line 356 "Parser.yp"
{ "$_[1] $_[2] $_[3]"                 }
	],
	[#Rule 136
		 'expr', 3,
sub
#line 357 "Parser.yp"
{ "$_[1] $_[2] $_[3]"                 }
	],
	[#Rule 137
		 'expr', 3,
sub
#line 358 "Parser.yp"
{ "int($_[1] / $_[3])"                }
	],
	[#Rule 138
		 'expr', 3,
sub
#line 359 "Parser.yp"
{ "$_[1] % $_[3]"                     }
	],
	[#Rule 139
		 'expr', 3,
sub
#line 360 "Parser.yp"
{ "$_[1] $CMPOP{ $_[2] } $_[3]"       }
	],
	[#Rule 140
		 'expr', 3,
sub
#line 361 "Parser.yp"
{ "$_[1]  + $_[3]"                    }
	],
	[#Rule 141
		 'expr', 3,
sub
#line 362 "Parser.yp"
{ "$_[1] && $_[3]"                    }
	],
	[#Rule 142
		 'expr', 3,
sub
#line 363 "Parser.yp"
{ "$_[1] || $_[3]"                    }
	],
	[#Rule 143
		 'expr', 2,
sub
#line 364 "Parser.yp"
{ "! $_[2]"                           }
	],
	[#Rule 144
		 'expr', 5,
sub
#line 365 "Parser.yp"
{ "$_[1] ? $_[3] : $_[5]"             }
	],
	[#Rule 145
		 'expr', 3,
sub
#line 366 "Parser.yp"
{ $factory->assign(@{$_[2]})          }
	],
	[#Rule 146
		 'expr', 3,
sub
#line 367 "Parser.yp"
{ "($_[2])"                           }
	],
	[#Rule 147
		 'expr', 1, undef
	],
	[#Rule 148
		 'setlist', 2,
sub
#line 371 "Parser.yp"
{ push(@{$_[1]}, @{$_[2]}); $_[1]     }
	],
	[#Rule 149
		 'setlist', 2, undef
	],
	[#Rule 150
		 'setlist', 1, undef
	],
	[#Rule 151
		 'assign', 3,
sub
#line 377 "Parser.yp"
{ [ $_[1], $_[3] ]                    }
	],
	[#Rule 152
		 'assign', 3,
sub
#line 378 "Parser.yp"
{ [ @_[1,3] ]                         }
	],
	[#Rule 153
		 'args', 2,
sub
#line 385 "Parser.yp"
{ push(@{$_[1]}, $_[2]); $_[1]        }
	],
	[#Rule 154
		 'args', 2,
sub
#line 386 "Parser.yp"
{ push(@{$_[1]->[0]}, $_[2]); $_[1]   }
	],
	[#Rule 155
		 'args', 4,
sub
#line 387 "Parser.yp"
{ push(@{$_[1]->[0]}, "'', " . 
				      $factory->assign(@_[2,4])); $_[1]  }
	],
	[#Rule 156
		 'args', 2,
sub
#line 389 "Parser.yp"
{ $_[1]                               }
	],
	[#Rule 157
		 'args', 0,
sub
#line 390 "Parser.yp"
{ [ [ ] ]                             }
	],
	[#Rule 158
		 'lnameargs', 3,
sub
#line 400 "Parser.yp"
{ push(@{$_[3]}, $_[1]); $_[3]        }
	],
	[#Rule 159
		 'lnameargs', 1, undef
	],
	[#Rule 160
		 'lvalue', 1, undef
	],
	[#Rule 161
		 'lvalue', 3,
sub
#line 405 "Parser.yp"
{ $factory->quoted($_[2])             }
	],
	[#Rule 162
		 'lvalue', 1, undef
	],
	[#Rule 163
		 'nameargs', 3,
sub
#line 409 "Parser.yp"
{ [ [$factory->ident($_[2])], $_[3] ]   }
	],
	[#Rule 164
		 'nameargs', 2,
sub
#line 410 "Parser.yp"
{ [ @_[1,2] ] }
	],
	[#Rule 165
		 'nameargs', 4,
sub
#line 411 "Parser.yp"
{ [ @_[1,3] ] }
	],
	[#Rule 166
		 'names', 3,
sub
#line 414 "Parser.yp"
{ push(@{$_[1]}, $_[3]); $_[1] }
	],
	[#Rule 167
		 'names', 1,
sub
#line 415 "Parser.yp"
{ [ $_[1] ]                    }
	],
	[#Rule 168
		 'name', 3,
sub
#line 418 "Parser.yp"
{ $factory->quoted($_[2])  }
	],
	[#Rule 169
		 'name', 1,
sub
#line 419 "Parser.yp"
{ "'$_[1]'" }
	],
	[#Rule 170
		 'name', 1, undef
	],
	[#Rule 171
		 'filename', 3,
sub
#line 431 "Parser.yp"
{ "$_[1].$_[3]" }
	],
	[#Rule 172
		 'filename', 1, undef
	],
	[#Rule 173
		 'filepart', 1, undef
	],
	[#Rule 174
		 'filepart', 1, undef
	],
	[#Rule 175
		 'filepart', 1, undef
	],
	[#Rule 176
		 'quoted', 2,
sub
#line 445 "Parser.yp"
{ push(@{$_[1]}, $_[2]) 
				          if defined $_[2]; $_[1]         }
	],
	[#Rule 177
		 'quoted', 0,
sub
#line 447 "Parser.yp"
{ [ ]                                 }
	],
	[#Rule 178
		 'quotable', 1,
sub
#line 450 "Parser.yp"
{ $factory->ident($_[1])              }
	],
	[#Rule 179
		 'quotable', 1,
sub
#line 451 "Parser.yp"
{ $factory->text($_[1])               }
	],
	[#Rule 180
		 'quotable', 1,
sub
#line 452 "Parser.yp"
{ undef                               }
	]
];

1;
