# Generated by default/object.tt
package Paws::AccessAnalyzer::Substring;
  use Moose;
  has Length => (is => 'ro', isa => 'Int', request_name => 'length', traits => ['NameInRequest'], required => 1);
  has Start => (is => 'ro', isa => 'Int', request_name => 'start', traits => ['NameInRequest'], required => 1);

1;

### main pod documentation begin ###

=head1 NAME

Paws::AccessAnalyzer::Substring

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::AccessAnalyzer::Substring object:

  $service_obj->Method(Att1 => { Length => $value, ..., Start => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::AccessAnalyzer::Substring object:

  $result = $service_obj->Method(...);
  $result->Att1->Length

=head1 DESCRIPTION

A reference to a substring of a literal string in a JSON document.

=head1 ATTRIBUTES


=head2 B<REQUIRED> Length => Int

The length of the substring.


=head2 B<REQUIRED> Start => Int

The start index of the substring, starting from 0.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::AccessAnalyzer>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

