# Generated by default/object.tt
package Paws::Transfer::EndpointDetails;
  use Moose;
  has AddressAllocationIds => (is => 'ro', isa => 'ArrayRef[Str|Undef]');
  has SecurityGroupIds => (is => 'ro', isa => 'ArrayRef[Str|Undef]');
  has SubnetIds => (is => 'ro', isa => 'ArrayRef[Str|Undef]');
  has VpcEndpointId => (is => 'ro', isa => 'Str');
  has VpcId => (is => 'ro', isa => 'Str');

1;

### main pod documentation begin ###

=head1 NAME

Paws::Transfer::EndpointDetails

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::Transfer::EndpointDetails object:

  $service_obj->Method(Att1 => { AddressAllocationIds => $value, ..., VpcId => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::Transfer::EndpointDetails object:

  $result = $service_obj->Method(...);
  $result->Att1->AddressAllocationIds

=head1 DESCRIPTION

The virtual private cloud (VPC) endpoint settings that are configured
for your file transfer protocol-enabled server. With a VPC endpoint,
you can restrict access to your server and resources only within your
VPC. To control incoming internet traffic, invoke the C<UpdateServer>
API and attach an Elastic IP address to your server's endpoint.

After May 19, 2021, you won't be able to create a server using
C<EndpointType=VPC_ENDPOINT> in your Amazon Web Servicesaccount if your
account hasn't already done so before May 19, 2021. If you have already
created servers with C<EndpointType=VPC_ENDPOINT> in your Amazon Web
Servicesaccount on or before May 19, 2021, you will not be affected.
After this date, use C<EndpointType>=C<VPC>.

For more information, see
https://docs.aws.amazon.com/transfer/latest/userguide/create-server-in-vpc.html#deprecate-vpc-endpoint.

=head1 ATTRIBUTES


=head2 AddressAllocationIds => ArrayRef[Str|Undef]

A list of address allocation IDs that are required to attach an Elastic
IP address to your server's endpoint.

This property can only be set when C<EndpointType> is set to C<VPC> and
it is only valid in the C<UpdateServer> API.


=head2 SecurityGroupIds => ArrayRef[Str|Undef]

A list of security groups IDs that are available to attach to your
server's endpoint.

This property can only be set when C<EndpointType> is set to C<VPC>.

You can edit the C<SecurityGroupIds> property in the UpdateServer
(https://docs.aws.amazon.com/transfer/latest/userguide/API_UpdateServer.html)
API only if you are changing the C<EndpointType> from C<PUBLIC> or
C<VPC_ENDPOINT> to C<VPC>. To change security groups associated with
your server's VPC endpoint after creation, use the Amazon EC2
ModifyVpcEndpoint
(https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_ModifyVpcEndpoint.html)
API.


=head2 SubnetIds => ArrayRef[Str|Undef]

A list of subnet IDs that are required to host your server endpoint in
your VPC.

This property can only be set when C<EndpointType> is set to C<VPC>.


=head2 VpcEndpointId => Str

The ID of the VPC endpoint.

This property can only be set when C<EndpointType> is set to
C<VPC_ENDPOINT>.

For more information, see
https://docs.aws.amazon.com/transfer/latest/userguide/create-server-in-vpc.html#deprecate-vpc-endpoint.


=head2 VpcId => Str

The VPC ID of the VPC in which a server's endpoint will be hosted.

This property can only be set when C<EndpointType> is set to C<VPC>.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::Transfer>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

