/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.ie.machinereading.domains.ace.reader;

import edu.stanford.nlp.ie.machinereading.domains.ace.reader.AceCharSeq;
import edu.stanford.nlp.ie.machinereading.domains.ace.reader.AceElement;
import edu.stanford.nlp.ie.machinereading.domains.ace.reader.AceEntityMention;

public class AceMentionArgument {
    protected final String mRole;
    protected final AceEntityMention mContent;
    private final String mentionType;

    public AceMentionArgument(String role, AceEntityMention content, String mentionType) {
        this.mRole = role;
        this.mContent = content;
        this.mentionType = mentionType;
    }

    public AceEntityMention getContent() {
        return this.mContent;
    }

    public String getRole() {
        return this.mRole;
    }

    public String toXml(int offset) {
        StringBuffer buffer = new StringBuffer();
        AceElement.appendOffset(buffer, offset);
        buffer.append("<" + this.mentionType + "_mention_argument REFID=\"" + this.mContent.getId() + "\" ROLE=\"" + this.mRole + "\">\n");
        AceCharSeq ext = this.getContent().getExtent();
        buffer.append(ext.toXml("extent", offset + 2));
        buffer.append("\n");
        AceElement.appendOffset(buffer, offset);
        buffer.append("</" + this.mentionType + "_mention_argument>");
        return buffer.toString();
    }

    public String toXmlShort(int offset) {
        StringBuffer buffer = new StringBuffer();
        AceElement.appendOffset(buffer, offset);
        buffer.append("<" + this.mentionType + "_argument REFID=\"" + this.mContent.getParent().getId() + "\" ROLE=\"" + this.mRole + "\"/>");
        return buffer.toString();
    }
}

