/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.ling.tokensregex;

import edu.stanford.nlp.util.CacheMap;
import edu.stanford.nlp.util.IntPair;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class MultiWordStringMatcher {
    private boolean caseInsensitiveMatch = false;
    MatchType matchType = MatchType.EXCTWS;
    private CacheMap<String, Pattern> targetStringPatternCache = new CacheMap(5000);
    public static final Comparator<String> LONGEST_STRING_COMPARATOR = new LongestStringComparator();
    private static Pattern whitespacePattern = Pattern.compile("\\s+");
    private static final Pattern punctWhitespacePattern = Pattern.compile("\\s*(\\p{Punct})\\s*");
    private static final Pattern lnrmDelimPatternAny = Pattern.compile("(?:\\p{Punct}|\\s)*");
    private static final Pattern lnrmDelimPattern = Pattern.compile("(?:\\p{Punct}|\\s)+");

    public MultiWordStringMatcher(MatchType matchType) {
        this.setMatchType(matchType);
    }

    public MultiWordStringMatcher(String matchTypeStr) {
        this.setMatchType(MatchType.valueOf(matchTypeStr));
    }

    public MatchType getMatchType() {
        return this.matchType;
    }

    public void setMatchType(MatchType matchType) {
        this.matchType = matchType;
        this.caseInsensitiveMatch = matchType != MatchType.EXCT && matchType != MatchType.EXCTWS;
        this.targetStringPatternCache.clear();
    }

    public String putSpacesAroundTargetString(String text, String targetString) {
        return this.markTargetString(text, targetString, " ", " ", true);
    }

    protected String markTargetString(String text, String targetString, String beginMark, String endMark, boolean markOnlyIfSpace) {
        StringBuilder sb = new StringBuilder(text);
        int i = sb.indexOf(targetString);
        while (i >= 0) {
            boolean markAfter;
            boolean matched = true;
            boolean markBefore = !markOnlyIfSpace;
            boolean bl = markAfter = !markOnlyIfSpace;
            if (i > 0) {
                char charBefore = sb.charAt(i - 1);
                if (Character.isLetterOrDigit(charBefore)) {
                    matched = false;
                } else if (!Character.isWhitespace(charBefore)) {
                    markBefore = true;
                }
            }
            if (i + targetString.length() < sb.length()) {
                char charAfter = sb.charAt(i + targetString.length());
                if (Character.isLetterOrDigit(charAfter)) {
                    matched = false;
                } else if (!Character.isWhitespace(charAfter)) {
                    markAfter = true;
                }
            }
            if (matched) {
                if (markBefore) {
                    sb.insert(i, beginMark);
                    i += beginMark.length();
                }
                i += targetString.length();
                if (markAfter) {
                    sb.insert(i, endMark);
                    i += endMark.length();
                }
            } else {
                ++i;
            }
            i = sb.indexOf(targetString, i);
        }
        return sb.toString();
    }

    protected List<IntPair> findTargetStringOffsetsExct(String text, String targetString, int start, int end) {
        if (start > text.length()) {
            return null;
        }
        if (end > text.length()) {
            return null;
        }
        ArrayList<IntPair> offsets = null;
        int i = text.indexOf(targetString, start);
        if (i >= 0 && i < end) {
            offsets = new ArrayList<IntPair>();
        }
        while (i >= 0 && i < end) {
            char charAfter;
            char charBefore;
            boolean matched = true;
            if (i > 0 && Character.isLetterOrDigit(charBefore = text.charAt(i - 1))) {
                matched = false;
            }
            if (i + targetString.length() < text.length() && Character.isLetterOrDigit(charAfter = text.charAt(i + targetString.length()))) {
                matched = false;
            }
            if (matched) {
                offsets.add(new IntPair(i, i + targetString.length()));
                i += targetString.length();
            } else {
                ++i;
            }
            i = text.indexOf(targetString, i);
        }
        return offsets;
    }

    public Pattern getPattern(String[] targetStrings) {
        String regex = this.getRegex(targetStrings);
        return Pattern.compile(regex);
    }

    public String getRegex(String[] targetStrings) {
        List<String> strings = Arrays.asList(targetStrings);
        Collections.sort(strings, LONGEST_STRING_COMPARATOR);
        StringBuilder sb = new StringBuilder();
        for (String s : strings) {
            if (sb.length() > 0) {
                sb.append("|");
            }
            sb.append(this.getRegex(s));
        }
        String regex = sb.toString();
        return regex;
    }

    public Pattern getPattern(String targetString) {
        Pattern pattern = this.targetStringPatternCache.get(targetString);
        if (pattern == null) {
            pattern = this.createPattern(targetString);
            this.targetStringPatternCache.put(targetString, pattern);
        }
        return pattern;
    }

    public Pattern createPattern(String targetString) {
        String wordRegex = this.getRegex(targetString);
        return Pattern.compile(wordRegex);
    }

    public String getRegex(String targetString) {
        String wordRegex2;
        switch (this.matchType) {
            case EXCT: {
                wordRegex2 = Pattern.quote(targetString);
                break;
            }
            case EXCTWS: {
                wordRegex2 = this.getExctWsRegex(targetString);
                break;
            }
            case LWS: {
                wordRegex2 = this.getLWsRegex(targetString);
                break;
            }
            case LNRM: {
                wordRegex2 = this.getLnrmRegex(targetString);
                break;
            }
            case REGEX: {
                String wordRegex2 = targetString;
            }
            default: {
                throw new UnsupportedOperationException();
            }
        }
        return wordRegex2;
    }

    public String getExctWsRegex(String targetString) {
        String[] fields;
        StringBuilder sb = new StringBuilder();
        for (String field : fields = whitespacePattern.split(targetString)) {
            String[] punctFields;
            if (sb.length() > 0) {
                sb.append("\\s+");
            }
            String tmp = punctWhitespacePattern.matcher(field).replaceAll(" $1 ");
            tmp = tmp.trim();
            for (String f : punctFields = whitespacePattern.split(tmp)) {
                if (sb.length() > 0) {
                    sb.append("\\s*");
                }
                sb.append(Pattern.quote(f));
            }
        }
        return sb.toString();
    }

    public String getLWsRegex(String targetString) {
        StringBuilder sb = new StringBuilder("(?u)(?i)");
        sb.append(this.getExctWsRegex(targetString));
        return sb.toString();
    }

    public String getLnrmRegex(String targetString) {
        StringBuilder sb = new StringBuilder("(?u)(?i)");
        String[] fields = lnrmDelimPattern.split(targetString);
        boolean first = true;
        for (String field : fields) {
            if (!first) {
                sb.append(lnrmDelimPatternAny);
            } else {
                first = false;
            }
            sb.append(Pattern.quote(field));
        }
        return sb.toString();
    }

    protected List<IntPair> findTargetStringOffsetsRegex(String text, String targetString, int start, int end) {
        if (start > text.length()) {
            return null;
        }
        if (end > text.length()) {
            return null;
        }
        Pattern targetPattern = this.getPattern(targetString);
        return MultiWordStringMatcher.findOffsets(targetPattern, text, start, end);
    }

    public static List<IntPair> findOffsets(Pattern pattern, String text) {
        return MultiWordStringMatcher.findOffsets(pattern, text, 0, text.length());
    }

    public static List<IntPair> findOffsets(Pattern pattern, String text, int start, int end) {
        int i;
        Matcher matcher = pattern.matcher(text);
        ArrayList<IntPair> offsets = null;
        matcher.region(start, end);
        int n = i = matcher.find() ? matcher.start() : -1;
        if (i >= 0 && i < end) {
            offsets = new ArrayList<IntPair>();
        }
        while (i >= 0 && i < end) {
            char charAfter;
            char charBefore;
            boolean matched = true;
            int matchEnd = matcher.end();
            if (i > 0 && Character.isLetterOrDigit(charBefore = text.charAt(i - 1))) {
                matched = false;
            }
            if (matchEnd < text.length() && Character.isLetterOrDigit(charAfter = text.charAt(matchEnd))) {
                matched = false;
            }
            if (matched) {
                offsets.add(new IntPair(i, matchEnd));
            }
            i = matcher.find() ? matcher.start() : -1;
        }
        return offsets;
    }

    public List<IntPair> findTargetStringOffsets(String text, String targetString) {
        return this.findTargetStringOffsets(text, targetString, 0, text.length());
    }

    public List<IntPair> findTargetStringOffsets(String text, String targetString, int start, int end) {
        switch (this.matchType) {
            case EXCT: {
                return this.findTargetStringOffsetsExct(text, targetString, start, end);
            }
        }
        return this.findTargetStringOffsetsRegex(text, targetString, start, end);
    }

    public static class LongestStringComparator
    implements Comparator<String> {
        @Override
        public int compare(String o1, String o2) {
            int l2;
            int l1 = o1.length();
            if (l1 == (l2 = o2.length())) {
                return o1.compareTo(o2);
            }
            return l1 > l2 ? -1 : 1;
        }
    }

    public static enum MatchType {
        EXCT,
        EXCTWS,
        LWS,
        LNRM,
        REGEX;

    }
}

