/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.parser.lexparser;

import edu.stanford.nlp.trees.Tree;
import edu.stanford.nlp.trees.TreeFactory;
import edu.stanford.nlp.trees.TreeTransformer;
import edu.stanford.nlp.trees.TreebankLanguagePack;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

public class CollinsPuncTransformer
implements TreeTransformer {
    private TreebankLanguagePack tlp;

    boolean isPunc(Tree t) {
        String s;
        return t.isPreTerminal() && this.tlp.isEvalBIgnoredPunctuationTag(s = t.label().value());
    }

    static LinkedList<Tree> preTerms(Tree t) {
        LinkedList<Tree> l = new LinkedList<Tree>();
        CollinsPuncTransformer.preTermHelper(t, l);
        return l;
    }

    static void preTermHelper(Tree t, List<Tree> l) {
        Tree[] children;
        if (t.isLeaf()) {
            return;
        }
        if (t.isPreTerminal()) {
            l.add(t);
            return;
        }
        for (Tree child : children = t.children()) {
            CollinsPuncTransformer.preTermHelper(child, l);
        }
    }

    Tree transformRoot(Tree tree, TreeFactory tf) {
        if (((Object)tree.label()).toString().startsWith("ROOT")) {
            return tf.newTreeNode(tree.label(), Collections.singletonList(this.transformNode(tree.children()[0], tf)));
        }
        return this.transformNode(tree, tf);
    }

    Tree transformNode(Tree tree, TreeFactory tf) {
        if (tree.isLeaf()) {
            return tf.newLeaf(tree.label());
        }
        if (tree.isPreTerminal()) {
            return tf.newTreeNode(tree.label(), Collections.singletonList(tf.newLeaf(tree.children()[0].label())));
        }
        List<Tree> children = tree.getChildrenAsList();
        LinkedList<Tree> newChildren = new LinkedList<Tree>();
        for (Tree child : children) {
            LinkedList<Tree> preTerms = CollinsPuncTransformer.preTerms(child);
            while (!preTerms.isEmpty() && this.isPunc(preTerms.getFirst())) {
                newChildren.add(preTerms.getFirst());
                preTerms.removeFirst();
            }
            Tree newChild = this.transformNode(child, tf);
            LinkedList<Tree> temp = new LinkedList<Tree>();
            if (newChild.children().length > 0) {
                newChildren.add(newChild);
            }
            while (!preTerms.isEmpty() && this.isPunc(preTerms.getLast())) {
                temp.addFirst(preTerms.getLast());
                preTerms.removeLast();
            }
            newChildren.addAll(temp);
        }
        while (!newChildren.isEmpty() && this.isPunc((Tree)newChildren.getFirst())) {
            newChildren.removeFirst();
        }
        while (!newChildren.isEmpty() && this.isPunc((Tree)newChildren.getLast())) {
            newChildren.removeLast();
        }
        return tf.newTreeNode(tree.label(), newChildren);
    }

    @Override
    public Tree transformTree(Tree tree) {
        return this.transformRoot(tree, tree.treeFactory());
    }

    public CollinsPuncTransformer(TreebankLanguagePack tlp) {
        this.tlp = tlp;
    }
}

