/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.pipeline;

import edu.stanford.nlp.ling.CoreAnnotations;
import edu.stanford.nlp.ling.CoreLabel;
import edu.stanford.nlp.ling.tokensregex.CoreMapExpressionExtractor;
import edu.stanford.nlp.ling.tokensregex.Env;
import edu.stanford.nlp.ling.tokensregex.EnvLookup;
import edu.stanford.nlp.ling.tokensregex.TokenSequencePattern;
import edu.stanford.nlp.pipeline.Annotation;
import edu.stanford.nlp.pipeline.Annotator;
import edu.stanford.nlp.util.CoreMap;
import edu.stanford.nlp.util.PropertiesUtils;
import edu.stanford.nlp.util.Timing;
import edu.stanford.nlp.util.logging.Redwood;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;

public class TokensRegexAnnotator
implements Annotator {
    private Env env;
    private CoreMapExpressionExtractor extractor;
    private Options options = new Options();
    private Timing timer = new Timing();
    private boolean verbose;

    public TokensRegexAnnotator(String ... files) {
        this.env = TokenSequencePattern.getNewEnv();
        this.extractor = CoreMapExpressionExtractor.createExtractorFromFiles(this.env, files);
    }

    public TokensRegexAnnotator(String name, Properties props) {
        String prefix = name == null ? "" : name + ".";
        String[] files = PropertiesUtils.getStringArray(props, prefix + "rules");
        if (files == null || files.length == 0) {
            throw new RuntimeException("No rules specified for TokensRegexAnnotator " + name + ", check " + prefix + "rules property");
        }
        this.env = TokenSequencePattern.getNewEnv();
        this.env.bind("options", this.options);
        this.extractor = CoreMapExpressionExtractor.createExtractorFromFiles(this.env, files);
        this.verbose = PropertiesUtils.getBool(props, prefix + "verbose", this.verbose);
        this.options.setTokenOffsets = PropertiesUtils.getBool(props, prefix + "setTokenOffsets", this.options.setTokenOffsets);
        this.options.extractWithTokens = PropertiesUtils.getBool(props, prefix + "extractWithTokens", this.options.extractWithTokens);
        this.options.flatten = PropertiesUtils.getBool(props, prefix + "flatten", this.options.flatten);
        String matchedExpressionsAnnotationKeyName = props.getProperty(prefix + "matchedExpressionsAnnotationKey");
        if (matchedExpressionsAnnotationKeyName != null) {
            this.options.matchedExpressionsAnnotationKey = EnvLookup.lookupAnnotationKey(this.env, matchedExpressionsAnnotationKeyName);
            if (this.options.matchedExpressionsAnnotationKey == null) {
                String propName = prefix + "matchedExpressionsAnnotationKey";
                throw new RuntimeException("Cannot determine annotation key for " + propName + "=" + matchedExpressionsAnnotationKeyName);
            }
        }
    }

    public TokensRegexAnnotator(Properties props) {
        this(null, props);
    }

    public void addTokenOffsets(CoreMap annotation) {
        Integer startTokenOffset = (Integer)annotation.get(CoreAnnotations.TokenBeginAnnotation.class);
        if (startTokenOffset == null) {
            startTokenOffset = 0;
        }
        int i = 0;
        for (CoreLabel c : (List)annotation.get(CoreAnnotations.TokensAnnotation.class)) {
            c.set(CoreAnnotations.TokenBeginAnnotation.class, i + startTokenOffset);
            c.set(CoreAnnotations.TokenEndAnnotation.class, ++i + startTokenOffset);
        }
    }

    private List<CoreMap> extract(CoreMap annotation) {
        List<CoreMap> cms = this.options.extractWithTokens ? this.extractor.extractCoreMapsMergedWithTokens(annotation) : this.extractor.extractCoreMaps(annotation);
        if (this.options.flatten) {
            return this.extractor.flatten(cms);
        }
        return cms;
    }

    @Override
    public void annotate(Annotation annotation) {
        List<Object> allMatched;
        if (this.verbose) {
            this.timer.start();
            Redwood.log(new Object[]{Redwood.DBG, "Adding TokensRegexAnnotator annotation..."});
        }
        if (this.options.setTokenOffsets) {
            this.addTokenOffsets(annotation);
        }
        if (annotation.containsKey(CoreAnnotations.SentencesAnnotation.class)) {
            allMatched = new ArrayList();
            List sentences = (List)annotation.get(CoreAnnotations.SentencesAnnotation.class);
            for (CoreMap sentence : sentences) {
                List<CoreMap> matched = this.extract(sentence);
                if (matched == null || this.options.matchedExpressionsAnnotationKey == null) continue;
                allMatched.addAll(matched);
                sentence.set(this.options.matchedExpressionsAnnotationKey, matched);
                for (CoreMap cm : matched) {
                    cm.set(CoreAnnotations.SentenceIndexAnnotation.class, sentence.get(CoreAnnotations.SentenceIndexAnnotation.class));
                }
            }
        } else {
            allMatched = this.extract(annotation);
        }
        if (this.options.matchedExpressionsAnnotationKey != null) {
            annotation.set(this.options.matchedExpressionsAnnotationKey, allMatched);
        }
        if (this.verbose) {
            this.timer.stop("done.");
        }
    }

    public static class Options {
        public Class matchedExpressionsAnnotationKey;
        public boolean setTokenOffsets;
        public boolean extractWithTokens;
        public boolean flatten;
    }
}

