/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.time;

import edu.stanford.nlp.ling.tokensregex.types.Expressions;
import edu.stanford.nlp.time.JodaTimeUtils;
import edu.stanford.nlp.util.CollectionUtils;
import edu.stanford.nlp.util.FuzzyInterval;
import edu.stanford.nlp.util.HasInterval;
import edu.stanford.nlp.util.HashIndex;
import edu.stanford.nlp.util.Index;
import edu.stanford.nlp.util.StringUtils;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.joda.time.DateTimeFieldType;
import org.joda.time.DateTimeZone;
import org.joda.time.DurationFieldType;
import org.joda.time.Instant;
import org.joda.time.Interval;
import org.joda.time.MutableDateTime;
import org.joda.time.MutablePeriod;
import org.joda.time.Partial;
import org.joda.time.Period;
import org.joda.time.ReadableDuration;
import org.joda.time.ReadableInstant;
import org.joda.time.ReadablePartial;
import org.joda.time.ReadablePeriod;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.DateTimeFormatterBuilder;

public class SUTime {
    public static final String PAD_FIELD_UNKNOWN = "X";
    public static final String PAD_FIELD_UNKNOWN2 = "XX";
    public static final String PAD_FIELD_UNKNOWN4 = "XXXX";
    public static final int RESOLVE_NOW = 1;
    public static final int RESOLVE_TO_THIS = 32;
    public static final int RESOLVE_TO_PAST = 64;
    public static final int RESOLVE_TO_FUTURE = 128;
    public static final int RESOLVE_TO_CLOSEST = 512;
    public static final int DUR_RESOLVE_TO_AS_REF = 4096;
    public static final int DUR_RESOLVE_FROM_AS_REF = 8192;
    public static final int RANGE_RESOLVE_TIME_REF = 0x100000;
    public static final int RANGE_OFFSET_BEGIN = 1;
    public static final int RANGE_OFFSET_END = 2;
    public static final int RANGE_EXPAND_FIX_BEGIN = 16;
    public static final int RANGE_EXPAND_FIX_END = 32;
    public static final int RANGE_FLAGS_PAD_MASK = 15;
    public static final int RANGE_FLAGS_PAD_NONE = 1;
    public static final int RANGE_FLAGS_PAD_AUTO = 2;
    public static final int RANGE_FLAGS_PAD_FINEST = 3;
    public static final int RANGE_FLAGS_PAD_SPECIFIED = 4;
    public static final int FORMAT_ISO = 1;
    public static final int FORMAT_TIMEX3_VALUE = 2;
    public static final int FORMAT_FULL = 4;
    public static final int FORMAT_PAD_UNKNOWN = 4096;
    protected static final int timexVersion = 3;
    public static final Duration YEAR = new DurationWithFields((ReadablePeriod)Period.years((int)1)){

        @Override
        public DateTimeFieldType[] getDateTimeFields() {
            return new DateTimeFieldType[]{DateTimeFieldType.year(), DateTimeFieldType.yearOfCentury(), DateTimeFieldType.yearOfEra()};
        }
    };
    public static final Duration DAY = new DurationWithFields((ReadablePeriod)Period.days((int)1)){

        @Override
        public DateTimeFieldType[] getDateTimeFields() {
            return new DateTimeFieldType[]{DateTimeFieldType.dayOfMonth(), DateTimeFieldType.dayOfWeek(), DateTimeFieldType.dayOfYear()};
        }
    };
    public static final Duration WEEK = new DurationWithFields((ReadablePeriod)Period.weeks((int)1)){

        @Override
        public DateTimeFieldType[] getDateTimeFields() {
            return new DateTimeFieldType[]{DateTimeFieldType.weekOfWeekyear()};
        }
    };
    public static final Duration FORTNIGHT = new DurationWithFields((ReadablePeriod)Period.weeks((int)2));
    public static final Duration MONTH = new DurationWithFields((ReadablePeriod)Period.months((int)1)){

        @Override
        public DateTimeFieldType[] getDateTimeFields() {
            return new DateTimeFieldType[]{DateTimeFieldType.monthOfYear()};
        }
    };
    public static final Duration QUARTER = new DurationWithFields((ReadablePeriod)Period.months((int)3)){

        @Override
        public DateTimeFieldType[] getDateTimeFields() {
            return new DateTimeFieldType[]{JodaTimeUtils.QuarterOfYear};
        }
    };
    public static final Duration MILLIS = new DurationWithFields((ReadablePeriod)Period.millis((int)1)){

        @Override
        public DateTimeFieldType[] getDateTimeFields() {
            return new DateTimeFieldType[]{DateTimeFieldType.millisOfSecond(), DateTimeFieldType.millisOfDay()};
        }
    };
    public static final Duration SECOND = new DurationWithFields((ReadablePeriod)Period.seconds((int)1)){

        @Override
        public DateTimeFieldType[] getDateTimeFields() {
            return new DateTimeFieldType[]{DateTimeFieldType.secondOfMinute(), DateTimeFieldType.secondOfDay()};
        }
    };
    public static final Duration MINUTE = new DurationWithFields((ReadablePeriod)Period.minutes((int)1)){

        @Override
        public DateTimeFieldType[] getDateTimeFields() {
            return new DateTimeFieldType[]{DateTimeFieldType.minuteOfHour(), DateTimeFieldType.minuteOfDay()};
        }
    };
    public static final Duration HOUR = new DurationWithFields((ReadablePeriod)Period.hours((int)1)){

        @Override
        public DateTimeFieldType[] getDateTimeFields() {
            return new DateTimeFieldType[]{DateTimeFieldType.hourOfDay(), DateTimeFieldType.hourOfHalfday()};
        }
    };
    public static final Duration HALFHOUR = new DurationWithFields((ReadablePeriod)Period.minutes((int)30));
    public static final Duration QUARTERHOUR = new DurationWithFields((ReadablePeriod)Period.minutes((int)15));
    public static final Duration DECADE = new DurationWithFields((ReadablePeriod)Period.years((int)10)){

        @Override
        public DateTimeFieldType[] getDateTimeFields() {
            return new DateTimeFieldType[]{JodaTimeUtils.DecadeOfCentury};
        }
    };
    public static final Duration CENTURY = new DurationWithFields((ReadablePeriod)Period.years((int)100)){

        @Override
        public DateTimeFieldType[] getDateTimeFields() {
            return new DateTimeFieldType[]{DateTimeFieldType.centuryOfEra()};
        }
    };
    public static final Duration MILLENIUM = new DurationWithFields((ReadablePeriod)Period.years((int)1000));
    public static final Time TIME_REF = new RefTime("REF"){};
    public static final Time TIME_REF_UNKNOWN = new RefTime("UNKNOWN");
    public static final Time TIME_UNKNOWN = new SimpleTime("UNKNOWN");
    public static final Time TIME_NONE = null;
    public static final Time TIME_NONE_OK = new SimpleTime("NOTIME");
    public static final Time TIME_NOW = SUTime.createTemporal(StandardTemporalType.REFTIME, "PRESENT_REF", new RefTime("NOW"));
    public static final Time TIME_PRESENT = SUTime.createTemporal(StandardTemporalType.REFDATE, "PRESENT_REF", new InexactTime(new Range(TIME_NOW, TIME_NOW)));
    public static final Time TIME_PAST = SUTime.createTemporal(StandardTemporalType.REFDATE, "PAST_REF", new InexactTime(new Range(TIME_UNKNOWN, TIME_NOW)));
    public static final Time TIME_FUTURE = SUTime.createTemporal(StandardTemporalType.REFDATE, "FUTURE_REF", new InexactTime(new Range(TIME_NOW, TIME_UNKNOWN)));
    public static final Duration DURATION_UNKNOWN = new DurationWithFields();
    public static final Duration DURATION_NONE = new DurationWithFields((ReadablePeriod)Period.ZERO);
    public static final Time MONDAY = (Time)StandardTemporalType.DAY_OF_WEEK.createTemporal(1);
    public static final Time TUESDAY = (Time)StandardTemporalType.DAY_OF_WEEK.createTemporal(2);
    public static final Time WEDNESDAY = (Time)StandardTemporalType.DAY_OF_WEEK.createTemporal(3);
    public static final Time THURSDAY = (Time)StandardTemporalType.DAY_OF_WEEK.createTemporal(4);
    public static final Time FRIDAY = (Time)StandardTemporalType.DAY_OF_WEEK.createTemporal(5);
    public static final Time SATURDAY = (Time)StandardTemporalType.DAY_OF_WEEK.createTemporal(6);
    public static final Time SUNDAY = (Time)StandardTemporalType.DAY_OF_WEEK.createTemporal(7);
    public static final Time WEEKDAY = SUTime.createTemporal(StandardTemporalType.DAYS_OF_WEEK, "WD", new InexactTime(null, DAY, new Range(MONDAY, FRIDAY)){

        @Override
        public Duration getDuration() {
            return DAY;
        }
    });
    public static final Time WEEKEND = SUTime.createTemporal(StandardTemporalType.DAYS_OF_WEEK, "WE", new TimeWithRange(new Range(SATURDAY, SUNDAY, DAY.multiplyBy(2))));
    public static final Time JANUARY = (Time)StandardTemporalType.MONTH_OF_YEAR.createTemporal(1);
    public static final Time FEBRUARY = (Time)StandardTemporalType.MONTH_OF_YEAR.createTemporal(2);
    public static final Time MARCH = (Time)StandardTemporalType.MONTH_OF_YEAR.createTemporal(3);
    public static final Time APRIL = (Time)StandardTemporalType.MONTH_OF_YEAR.createTemporal(4);
    public static final Time MAY = (Time)StandardTemporalType.MONTH_OF_YEAR.createTemporal(5);
    public static final Time JUNE = (Time)StandardTemporalType.MONTH_OF_YEAR.createTemporal(6);
    public static final Time JULY = (Time)StandardTemporalType.MONTH_OF_YEAR.createTemporal(7);
    public static final Time AUGUST = (Time)StandardTemporalType.MONTH_OF_YEAR.createTemporal(8);
    public static final Time SEPTEMBER = (Time)StandardTemporalType.MONTH_OF_YEAR.createTemporal(9);
    public static final Time OCTOBER = (Time)StandardTemporalType.MONTH_OF_YEAR.createTemporal(10);
    public static final Time NOVEMBER = (Time)StandardTemporalType.MONTH_OF_YEAR.createTemporal(11);
    public static final Time DECEMBER = (Time)StandardTemporalType.MONTH_OF_YEAR.createTemporal(12);
    public static final Time SPRING_EQUINOX = SUTime.createTemporal(StandardTemporalType.DAY_OF_YEAR, "SP", new InexactTime(new Range(new IsoDate(-1, 3, 20), new IsoDate(-1, 3, 21))));
    public static final Time SUMMER_SOLSTICE = SUTime.createTemporal(StandardTemporalType.DAY_OF_YEAR, "SU", new InexactTime(new Range(new IsoDate(-1, 6, 20), new IsoDate(-1, 6, 21))));
    public static final Time WINTER_SOLSTICE = SUTime.createTemporal(StandardTemporalType.DAY_OF_YEAR, "WI", new InexactTime(new Range(new IsoDate(-1, 12, 21), new IsoDate(-1, 12, 22))));
    public static final Time FALL_EQUINOX = SUTime.createTemporal(StandardTemporalType.DAY_OF_YEAR, "FA", new InexactTime(new Range(new IsoDate(-1, 9, 22), new IsoDate(-1, 9, 23))));
    public static final Time SPRING = SUTime.createTemporal(StandardTemporalType.SEASON_OF_YEAR, "SP", new InexactTime(SPRING_EQUINOX, QUARTER, new Range(MARCH, JUNE, QUARTER)));
    public static final Time SUMMER = SUTime.createTemporal(StandardTemporalType.SEASON_OF_YEAR, "SU", new InexactTime(SUMMER_SOLSTICE, QUARTER, new Range(JUNE, SEPTEMBER, QUARTER)));
    public static final Time FALL = SUTime.createTemporal(StandardTemporalType.SEASON_OF_YEAR, "FA", new InexactTime(FALL_EQUINOX, QUARTER, new Range(SEPTEMBER, DECEMBER, QUARTER)));
    public static final Time WINTER = SUTime.createTemporal(StandardTemporalType.SEASON_OF_YEAR, "WI", new InexactTime(WINTER_SOLSTICE, QUARTER, new Range(DECEMBER, MARCH, QUARTER)));
    public static final PartialTime NOON = SUTime.createTemporal(StandardTemporalType.TIME_OF_DAY, "MI", new IsoTime(12, 0, -1));
    public static final PartialTime MIDNIGHT = SUTime.createTemporal(StandardTemporalType.TIME_OF_DAY, new IsoTime(0, 0, -1));
    public static final Time MORNING = SUTime.createTemporal(StandardTemporalType.TIME_OF_DAY, "MO", new InexactTime(new Range(new InexactTime(new Partial(DateTimeFieldType.hourOfDay(), 6)), NOON)));
    public static final Time AFTERNOON = SUTime.createTemporal(StandardTemporalType.TIME_OF_DAY, "AF", new InexactTime(new Range(NOON, new InexactTime(new Partial(DateTimeFieldType.hourOfDay(), 18)))));
    public static final Time EVENING = SUTime.createTemporal(StandardTemporalType.TIME_OF_DAY, "EV", new InexactTime(new Range(new InexactTime(new Partial(DateTimeFieldType.hourOfDay(), 18)), new InexactTime(new Partial(DateTimeFieldType.hourOfDay(), 20)))));
    public static final Time NIGHT = SUTime.createTemporal(StandardTemporalType.TIME_OF_DAY, "NI", new InexactTime(new Range(new InexactTime(new Partial(DateTimeFieldType.hourOfDay(), 19)), new InexactTime(new Partial(DateTimeFieldType.hourOfDay(), 5)))));
    public static final Time SUNRISE = SUTime.createTemporal(StandardTemporalType.TIME_OF_DAY, "MO", TimexMod.EARLY.name(), new PartialTime());
    public static final Time SUNSET = SUTime.createTemporal(StandardTemporalType.TIME_OF_DAY, "EV", TimexMod.EARLY.name(), new PartialTime());
    public static final Time DAWN = SUTime.createTemporal(StandardTemporalType.TIME_OF_DAY, "MO", TimexMod.EARLY.name(), new PartialTime());
    public static final Time DUSK = SUTime.createTemporal(StandardTemporalType.TIME_OF_DAY, "EV", new PartialTime());
    public static final Time DAYTIME = SUTime.createTemporal(StandardTemporalType.TIME_OF_DAY, "DT", new InexactTime(new Range(SUNRISE, SUNSET)));
    public static final Time LUNCHTIME = SUTime.createTemporal(StandardTemporalType.TIME_OF_DAY, "MI", new InexactTime(new Range(new InexactTime(new Partial(DateTimeFieldType.hourOfDay(), 12)), new InexactTime(new Partial(DateTimeFieldType.hourOfDay(), 14)))));
    public static final Time TEATIME = SUTime.createTemporal(StandardTemporalType.TIME_OF_DAY, "AF", new InexactTime(new Range(new InexactTime(new Partial(DateTimeFieldType.hourOfDay(), 15)), new InexactTime(new Partial(DateTimeFieldType.hourOfDay(), 17)))));
    public static final Time DINNERTIME = SUTime.createTemporal(StandardTemporalType.TIME_OF_DAY, "EV", new InexactTime(new Range(new InexactTime(new Partial(DateTimeFieldType.hourOfDay(), 18)), new InexactTime(new Partial(DateTimeFieldType.hourOfDay(), 20)))));
    public static final Time MORNING_TWILIGHT = SUTime.createTemporal(StandardTemporalType.TIME_OF_DAY, "MO", new InexactTime(new Range(DAWN, SUNRISE)));
    public static final Time EVENING_TWILIGHT = SUTime.createTemporal(StandardTemporalType.TIME_OF_DAY, "EV", new InexactTime(new Range(SUNSET, DUSK)));
    public static final TemporalSet TWILIGHT = SUTime.createTemporal(StandardTemporalType.TIME_OF_DAY, "NI", new ExplicitTemporalSet(EVENING_TWILIGHT, MORNING_TWILIGHT));
    public static final RelativeTime YESTERDAY = new RelativeTime(DAY.multiplyBy(-1));
    public static final RelativeTime TOMORROW = new RelativeTime(DAY.multiplyBy(1));
    public static final RelativeTime TODAY = new RelativeTime(TemporalOp.THIS, (Temporal)DAY);
    public static final RelativeTime TONIGHT = new RelativeTime(TemporalOp.THIS, NIGHT);
    public static final int ERA_BC = 0;
    public static final int ERA_AD = 1;
    public static final int ERA_UNKNOWN = -1;
    public static final int HALFDAY_AM = 0;
    public static final int HALFDAY_PM = 1;
    public static final int HALFDAY_UNKNOWN = -1;
    public static final PeriodicTemporalSet HOURLY = new PeriodicTemporalSet(null, HOUR, "EVERY", "P1X");
    public static final PeriodicTemporalSet NIGHTLY = new PeriodicTemporalSet(NIGHT, DAY, "EVERY", "P1X");
    public static final PeriodicTemporalSet DAILY = new PeriodicTemporalSet(null, DAY, "EVERY", "P1X");
    public static final PeriodicTemporalSet MONTHLY = new PeriodicTemporalSet(null, MONTH, "EVERY", "P1X");
    public static final PeriodicTemporalSet QUARTERLY = new PeriodicTemporalSet(null, QUARTER, "EVERY", "P1X");
    public static final PeriodicTemporalSet YEARLY = new PeriodicTemporalSet(null, YEAR, "EVERY", "P1X");
    public static final PeriodicTemporalSet WEEKLY = new PeriodicTemporalSet(null, WEEK, "EVERY", "P1X");

    private SUTime() {
    }

    public static <T extends Temporal> T createTemporal(StandardTemporalType timeType, T temporal) {
        temporal.standardTemporalType = timeType;
        return temporal;
    }

    public static <T extends Temporal> T createTemporal(StandardTemporalType timeType, String label, T temporal) {
        temporal.standardTemporalType = timeType;
        temporal.timeLabel = label;
        return temporal;
    }

    public static <T extends Temporal> T createTemporal(StandardTemporalType timeType, String label, String mod, T temporal) {
        temporal.standardTemporalType = timeType;
        temporal.timeLabel = label;
        temporal.mod = mod;
        return temporal;
    }

    public static Time parseDateTime(String dateStr) {
        IsoTime isoTime;
        if (dateStr == null) {
            return null;
        }
        Pattern p = Pattern.compile("(\\d\\d\\d\\d)-?(\\d\\d?)-?(\\d\\d?)(-?(?:T(\\d\\d):?(\\d\\d)?:?(\\d\\d)?(?:[.,](\\d{1,3}))?([+-]\\d\\d:?\\d\\d)?))?");
        Matcher m = p.matcher(dateStr);
        if (m.matches()) {
            String time = m.group(4);
            IsoDate isoDate = new IsoDate(m.group(1), m.group(2), m.group(3));
            if (time != null) {
                IsoTime isoTime2 = new IsoTime(m.group(5), m.group(6), m.group(7), m.group(8));
                return new IsoDateTime(isoDate, isoTime2);
            }
            return isoDate;
        }
        p = Pattern.compile("(\\d\\d\\d\\d)(\\d\\d)(\\d\\d):(\\d\\d)(\\d\\d)");
        m = p.matcher(dateStr);
        if (m.matches()) {
            IsoDate date = new IsoDate(m.group(1), m.group(2), m.group(3));
            IsoTime time = new IsoTime(m.group(4), m.group(5), null);
            return new IsoDateTime(date, time);
        }
        p = Pattern.compile("T(\\d\\d):?(\\d\\d)?:?(\\d\\d)?(?:[.,](\\d{1,3}))?([+-]\\d\\d:?\\d\\d)?");
        m = p.matcher(dateStr);
        if (m.matches()) {
            return new IsoTime(m.group(1), m.group(2), m.group(3), m.group(4));
        }
        IsoDate isoDate = null;
        if (isoDate == null && (m = (p = Pattern.compile(".*(\\d\\d\\d\\d)\\/(\\d\\d?)\\/(\\d\\d?).*")).matcher(dateStr)).matches()) {
            isoDate = new IsoDate(m.group(1), m.group(2), m.group(3));
        }
        if (isoDate == null && (m = (p = Pattern.compile(".*(\\d\\d\\d\\d)\\-(\\d\\d?)\\-(\\d\\d?).*")).matcher(dateStr)).matches()) {
            isoDate = new IsoDate(m.group(1), m.group(2), m.group(3));
        }
        if (isoDate == null && (m = (p = Pattern.compile(".*(\\d\\d?)\\/(\\d\\d?)\\/(\\d\\d(\\d\\d)?).*")).matcher(dateStr)).matches()) {
            isoDate = new IsoDate(m.group(3), m.group(1), m.group(2));
        }
        if (isoDate == null && (m = (p = Pattern.compile(".*(\\d\\d?)\\-(\\d\\d?)\\-(\\d\\d(\\d\\d)?).*")).matcher(dateStr)).matches()) {
            isoDate = new IsoDate(m.group(3), m.group(1), m.group(2));
        }
        if (isoDate == null && (m = (p = Pattern.compile(".*(\\d\\d?)\\.(\\d\\d?)\\.(\\d\\d(\\d\\d)?).*")).matcher(dateStr)).matches()) {
            isoDate = new IsoDate(m.group(3), m.group(2), m.group(1));
        }
        if ((isoTime = null) == null && (m = (p = Pattern.compile(".*(\\d?\\d):(\\d\\d)(:(\\d\\d)(\\.\\d+)?)?(\\s*([AP])\\.?M\\.?)?(\\s+([+\\-]\\d+|[A-Z][SD]T|GMT([+\\-]\\d+)?))?.*")).matcher(dateStr)).matches()) {
            isoTime = new IsoTime(m.group(1), m.group(2), m.group(4));
        }
        if (isoDate != null && isoTime != null) {
            return new IsoDateTime(isoDate, isoTime);
        }
        if (isoDate != null) {
            return isoDate;
        }
        return isoTime;
    }

    public static class PeriodicTemporalSet
    extends TemporalSet {
        Range occursIn;
        Temporal base;
        Duration periodicity;
        String quant;
        String freq;

        public PeriodicTemporalSet(Temporal base, Duration periodicity, String quant, String freq) {
            this.base = base;
            this.periodicity = periodicity;
            this.quant = quant;
            this.freq = freq;
        }

        public PeriodicTemporalSet(PeriodicTemporalSet p, Temporal base, Duration periodicity, Range range, String quant, String freq) {
            super(p);
            this.occursIn = range;
            this.base = base;
            this.periodicity = periodicity;
            this.quant = quant;
            this.freq = freq;
        }

        @Override
        public PeriodicTemporalSet setTimeZone(DateTimeZone tz) {
            return new PeriodicTemporalSet(this, (Time)Temporal.setTimeZone(this.base, tz), this.periodicity, (Range)Temporal.setTimeZone(this.occursIn, tz), this.quant, this.freq);
        }

        public PeriodicTemporalSet multiplyDurationBy(int scale) {
            return new PeriodicTemporalSet(this, this.base, this.periodicity.multiplyBy(scale), this.occursIn, this.quant, this.freq);
        }

        public PeriodicTemporalSet divideDurationBy(int scale) {
            return new PeriodicTemporalSet(this, this.base, this.periodicity.divideBy(scale), this.occursIn, this.quant, this.freq);
        }

        @Override
        public boolean isGrounded() {
            return this.occursIn != null && this.occursIn.isGrounded();
        }

        @Override
        public Duration getPeriod() {
            return this.periodicity;
        }

        @Override
        public Time getTime() {
            return null;
        }

        @Override
        public Duration getDuration() {
            return null;
        }

        @Override
        public Range getRange(int flags, Duration granularity) {
            return this.occursIn;
        }

        @Override
        public Map<String, String> getTimexAttributes(TimeIndex timeIndex) {
            Map<String, String> map = super.getTimexAttributes(timeIndex);
            if (this.quant != null) {
                map.put(TimexAttr.quant.name(), this.quant);
            }
            if (this.freq != null) {
                map.put(TimexAttr.freq.name(), this.freq);
            }
            if (this.periodicity != null) {
                map.put("periodicity", this.periodicity.getTimexValue());
            }
            return map;
        }

        @Override
        public Temporal resolve(Time refTime, int flags) {
            Range resolvedOccursIn = this.occursIn != null ? this.occursIn.resolve(refTime, flags) : null;
            Temporal resolvedBase = this.base != null ? this.base.resolve(null, 0) : null;
            return new PeriodicTemporalSet(this, resolvedBase, this.periodicity, resolvedOccursIn, this.quant, this.freq);
        }

        @Override
        public String toFormattedString(int flags) {
            if (this.getTimeLabel() != null) {
                return this.getTimeLabel();
            }
            if ((flags & 1) != 0) {
                return null;
            }
            if (this.base != null) {
                return this.base.toFormattedString(flags);
            }
            if (this.periodicity != null) {
                return this.periodicity.toFormattedString(flags);
            }
            return null;
        }

        @Override
        public Temporal intersect(Temporal t) {
            if (t instanceof Range) {
                if (this.occursIn == null) {
                    return new PeriodicTemporalSet(this, this.base, this.periodicity, (Range)t, this.quant, this.freq);
                }
            } else {
                if (this.base != null) {
                    Temporal merged = this.base.intersect(t);
                    return new PeriodicTemporalSet(this, merged, this.periodicity, this.occursIn, this.quant, this.freq);
                }
                return new PeriodicTemporalSet(this, t, this.periodicity, this.occursIn, this.quant, this.freq);
            }
            return null;
        }
    }

    public static class ExplicitTemporalSet
    extends TemporalSet {
        Set<Temporal> temporals;

        public ExplicitTemporalSet(Temporal ... temporals) {
            this.temporals = CollectionUtils.asSet(temporals);
        }

        public ExplicitTemporalSet(Set<Temporal> temporals) {
            this.temporals = temporals;
        }

        public ExplicitTemporalSet(ExplicitTemporalSet p, Set<Temporal> temporals) {
            super(p);
            this.temporals = temporals;
        }

        @Override
        public ExplicitTemporalSet setTimeZone(DateTimeZone tz) {
            HashSet<Temporal> tzTemporals = new HashSet<Temporal>(this.temporals.size());
            for (Temporal t : this.temporals) {
                tzTemporals.add(Temporal.setTimeZone(t, tz));
            }
            return new ExplicitTemporalSet(this, tzTemporals);
        }

        @Override
        public boolean isGrounded() {
            return false;
        }

        @Override
        public Time getTime() {
            return null;
        }

        @Override
        public Duration getDuration() {
            return null;
        }

        @Override
        public Range getRange(int flags, Duration granularity) {
            return null;
        }

        @Override
        public Temporal resolve(Time refTime, int flags) {
            Temporal[] newTemporals = new Temporal[this.temporals.size()];
            int i = 0;
            for (Temporal t : this.temporals) {
                newTemporals[i] = t.resolve(refTime, flags);
                ++i;
            }
            return new ExplicitTemporalSet(newTemporals);
        }

        @Override
        public String toFormattedString(int flags) {
            if (this.getTimeLabel() != null) {
                return this.getTimeLabel();
            }
            if ((flags & 1) != 0) {
                return null;
            }
            if ((flags & 2) != 0) {
                return null;
            }
            return "{" + StringUtils.join(this.temporals, ", ") + "}";
        }

        @Override
        public Temporal intersect(Temporal other) {
            if (other == null) {
                return this;
            }
            if (other == TIME_UNKNOWN || other == DURATION_UNKNOWN) {
                return this;
            }
            HashSet<Temporal> newTemporals = new HashSet<Temporal>();
            for (Temporal t : this.temporals) {
                Temporal t2 = t.intersect(other);
                if (t2 == null) continue;
                newTemporals.add(t2);
            }
            return new ExplicitTemporalSet(newTemporals);
        }
    }

    public static abstract class TemporalSet
    extends Temporal {
        public TemporalSet() {
        }

        public TemporalSet(TemporalSet t) {
            super(t);
        }

        @Override
        public TimexType getTimexType() {
            return TimexType.SET;
        }
    }

    public static class Range
    extends Temporal
    implements HasInterval<Time> {
        Time begin = TIME_UNKNOWN;
        Time end = TIME_UNKNOWN;
        Duration duration = DURATION_UNKNOWN;

        public Range(Time begin, Time end) {
            this.begin = begin;
            this.end = end;
            this.duration = Time.difference(begin, end);
        }

        public Range(Time begin, Time end, Duration duration) {
            this.begin = begin;
            this.end = end;
            this.duration = duration;
        }

        public Range(Range r, Time begin, Time end, Duration duration) {
            super(r);
            this.begin = begin;
            this.end = end;
            this.duration = duration;
        }

        @Override
        public Range setTimeZone(DateTimeZone tz) {
            return new Range(this, (Time)Temporal.setTimeZone(this.begin, tz), (Time)Temporal.setTimeZone(this.end, tz), this.duration);
        }

        @Override
        public edu.stanford.nlp.util.Interval<Time> getInterval() {
            return FuzzyInterval.toInterval(this.begin, this.end);
        }

        public Interval getJodaTimeInterval() {
            return new Interval((ReadableInstant)this.begin.getJodaTimeInstant(), (ReadableInstant)this.end.getJodaTimeInstant());
        }

        @Override
        public boolean isGrounded() {
            return this.begin.isGrounded() && this.end.isGrounded();
        }

        @Override
        public Time getTime() {
            return this.begin;
        }

        @Override
        public Duration getDuration() {
            return this.duration;
        }

        @Override
        public Range getRange(int flags, Duration granularity) {
            return this;
        }

        @Override
        public TimexType getTimexType() {
            return TimexType.DURATION;
        }

        @Override
        public Map<String, String> getTimexAttributes(TimeIndex timeIndex) {
            String beginTidStr = this.begin != null ? this.begin.getTidString(timeIndex) : null;
            String endTidStr = this.end != null ? this.end.getTidString(timeIndex) : null;
            Map<String, String> map = super.getTimexAttributes(timeIndex);
            if (beginTidStr != null) {
                map.put(TimexAttr.beginPoint.name(), beginTidStr);
            }
            if (endTidStr != null) {
                map.put(TimexAttr.endPoint.name(), endTidStr);
            }
            return map;
        }

        @Override
        public String toFormattedString(int flags) {
            if ((flags & 3) != 0) {
                String durationStr;
                if (this.getTimeLabel() != null) {
                    return this.getTimeLabel();
                }
                String beginStr = this.begin != null ? this.begin.toFormattedString(flags) : null;
                String endStr = this.end != null ? this.end.toFormattedString(flags) : null;
                String string = durationStr = this.duration != null ? this.duration.toFormattedString(flags) : null;
                if ((flags & 1) != 0) {
                    if (beginStr != null && endStr != null) {
                        return beginStr + "/" + endStr;
                    }
                    if (beginStr != null && durationStr != null) {
                        return beginStr + "/" + durationStr;
                    }
                    if (durationStr != null && endStr != null) {
                        return durationStr + "/" + endStr;
                    }
                }
                return durationStr;
            }
            StringBuilder sb = new StringBuilder();
            sb.append("(");
            if (this.begin != null) {
                sb.append(this.begin);
            }
            sb.append(",");
            if (this.end != null) {
                sb.append(this.end);
            }
            sb.append(",");
            if (this.duration != null) {
                sb.append(this.duration);
            }
            sb.append(")");
            return sb.toString();
        }

        @Override
        public Range resolve(Time refTime, int flags) {
            if (refTime == null) {
                return this;
            }
            if (this.isGrounded()) {
                return this;
            }
            if ((flags & 0x100000) != 0 && (this.begin == TIME_REF || this.end == TIME_REF)) {
                Time groundedBegin = this.begin;
                Duration groundedDuration = this.duration;
                if (this.begin == TIME_REF) {
                    groundedBegin = (Time)this.begin.resolve(refTime, flags);
                    groundedDuration = this.duration != null ? this.duration.resolve(refTime, flags | 0x2000) : null;
                }
                Time groundedEnd = this.end;
                if (this.end == TIME_REF) {
                    groundedEnd = (Time)this.end.resolve(refTime, flags);
                    groundedDuration = this.duration != null ? this.duration.resolve(refTime, flags | 0x1000) : null;
                }
                return new Range(this, groundedBegin, groundedEnd, groundedDuration);
            }
            return this;
        }

        public Range offset(Duration d) {
            return this.offset(d, 3);
        }

        public Range offset(Duration d, int flags) {
            Time b2 = this.begin;
            if ((flags & 1) != 0) {
                b2 = this.begin != null ? this.begin.offset(d) : null;
            }
            Time e2 = this.end;
            if ((flags & 2) != 0) {
                e2 = this.end != null ? this.end.offset(d) : null;
            }
            return new Range(this, b2, e2, this.duration);
        }

        public Range subtract(Duration d) {
            return this.subtract(d, 16);
        }

        public Range subtract(Duration d, int flags) {
            return this.add(d.multiplyBy(-1), 16);
        }

        public Range add(Duration d) {
            return this.add(d, 16);
        }

        public Range add(Duration d, int flags) {
            Duration d2 = this.duration.add(d);
            Time b2 = this.begin;
            Time e2 = this.end;
            if ((flags & 0x10) == 0) {
                b2 = this.end != null ? this.end.offset(d2.multiplyBy(-1)) : null;
            } else if ((flags & 0x20) == 0) {
                e2 = this.begin != null ? this.begin.offset(d2) : null;
            }
            return new Range(this, b2, e2, d2);
        }

        public Time begin() {
            return this.begin;
        }

        public Time end() {
            return this.end;
        }

        public Time beginTime() {
            Range r;
            if (this.begin != null && (r = this.begin.getRange()) != null && !this.begin.equals(r.begin)) {
                return r.begin;
            }
            return this.begin;
        }

        public Time endTime() {
            return this.end;
        }

        public Time mid() {
            if (this.duration != null && this.begin != null) {
                return this.begin.add(this.duration.divideBy(2));
            }
            if (this.duration != null && this.end != null) {
                return this.end.subtract(this.duration.divideBy(2));
            }
            if (this.begin == null || this.end == null) {
                if (this.begin != null) {
                    return this.begin;
                }
                if (this.end != null) {
                    return this.end;
                }
            }
            return null;
        }

        @Override
        public Temporal intersect(Temporal t) {
            if (t instanceof Time) {
                return new RelativeTime((Time)t, TemporalOp.INTERSECT, this);
            }
            if (t instanceof Range) {
                Range rt = (Range)t;
                Time b = Time.max(this.begin, rt.begin);
                Time e = Time.min(this.end, rt.end);
                return new Range(b, e);
            }
            if (t instanceof Duration) {
                return new InexactTime(null, (Duration)t, this);
            }
            return null;
        }

        public boolean contains(Range r) {
            return false;
        }
    }

    public static class InexactDuration
    extends DurationWithFields {
        public InexactDuration(ReadablePeriod period) {
            this.period = period;
            this.approx = true;
        }

        public InexactDuration(Duration d) {
            super(d, (ReadablePeriod)d.getJodaTimePeriod());
            this.approx = true;
        }

        public InexactDuration(Duration d, ReadablePeriod period) {
            super(d, period);
            this.approx = true;
        }

        @Override
        public String toFormattedString(int flags) {
            String s = super.toFormattedString(flags);
            return s.replaceAll("\\d+", SUTime.PAD_FIELD_UNKNOWN);
        }
    }

    public static class DurationRange
    extends Duration {
        Duration minDuration;
        Duration maxDuration;

        public DurationRange(DurationRange d, Duration min, Duration max) {
            super(d);
            this.minDuration = min;
            this.maxDuration = max;
        }

        public DurationRange(Duration min, Duration max) {
            this.minDuration = min;
            this.maxDuration = max;
        }

        @Override
        public boolean includeTimexAltValue() {
            return true;
        }

        @Override
        public String toFormattedString(int flags) {
            if ((flags & 3) != 0) {
                return null;
            }
            StringBuilder sb = new StringBuilder();
            if (this.minDuration != null) {
                sb.append(this.minDuration.toFormattedString(flags));
            }
            sb.append("/");
            if (this.maxDuration != null) {
                sb.append(this.maxDuration.toFormattedString(flags));
            }
            return sb.toString();
        }

        @Override
        public Period getJodaTimePeriod() {
            if (this.minDuration == null) {
                return this.maxDuration.getJodaTimePeriod();
            }
            if (this.maxDuration == null) {
                return this.minDuration.getJodaTimePeriod();
            }
            Duration mid = this.minDuration.add(this.maxDuration).divideBy(2);
            return mid.getJodaTimePeriod();
        }

        @Override
        public org.joda.time.Duration getJodaTimeDuration() {
            if (this.minDuration == null) {
                return this.maxDuration.getJodaTimeDuration();
            }
            if (this.maxDuration == null) {
                return this.minDuration.getJodaTimeDuration();
            }
            Duration mid = this.minDuration.add(this.maxDuration).divideBy(2);
            return mid.getJodaTimeDuration();
        }

        @Override
        public Duration add(Duration d) {
            Duration min2 = this.minDuration != null ? this.minDuration.add(d) : null;
            Duration max2 = this.maxDuration != null ? this.maxDuration.add(d) : null;
            return new DurationRange(this, min2, max2);
        }

        @Override
        public Duration multiplyBy(int m) {
            Duration min2 = this.minDuration != null ? this.minDuration.multiplyBy(m) : null;
            Duration max2 = this.maxDuration != null ? this.maxDuration.multiplyBy(m) : null;
            return new DurationRange(this, min2, max2);
        }

        @Override
        public Duration divideBy(int m) {
            Duration min2 = this.minDuration != null ? this.minDuration.divideBy(m) : null;
            Duration max2 = this.maxDuration != null ? this.maxDuration.divideBy(m) : null;
            return new DurationRange(this, min2, max2);
        }
    }

    public static class DurationWithMillis
    extends Duration {
        ReadableDuration base;

        public DurationWithMillis(long ms) {
            this.base = new org.joda.time.Duration(ms);
        }

        public DurationWithMillis(ReadableDuration base) {
            this.base = base;
        }

        public DurationWithMillis(Duration d, ReadableDuration base) {
            super(d);
            this.base = base;
        }

        @Override
        public Duration multiplyBy(int m) {
            if (m == 1) {
                return this;
            }
            long ms = this.base.getMillis();
            return new DurationWithMillis(ms * (long)m);
        }

        @Override
        public Duration divideBy(int m) {
            if (m == 1) {
                return this;
            }
            long ms = this.base.getMillis();
            return new DurationWithMillis(ms / (long)m);
        }

        @Override
        public Period getJodaTimePeriod() {
            return this.base.toPeriod();
        }

        @Override
        public org.joda.time.Duration getJodaTimeDuration() {
            return this.base.toDuration();
        }

        @Override
        public Duration add(Duration d) {
            if (d instanceof DurationWithMillis) {
                return new DurationWithMillis(this, (ReadableDuration)this.base.toDuration().plus(((DurationWithMillis)d).base));
            }
            if (d instanceof DurationWithFields) {
                return ((DurationWithFields)d).add(this);
            }
            throw new UnsupportedOperationException("Unknown duration type in add: " + d.getClass());
        }
    }

    public static class DurationWithFields
    extends Duration {
        ReadablePeriod period;

        public DurationWithFields() {
            this.period = null;
        }

        public DurationWithFields(ReadablePeriod period) {
            this.period = period;
        }

        public DurationWithFields(Duration d, ReadablePeriod period) {
            super(d);
            this.period = period;
        }

        @Override
        public Duration multiplyBy(int m) {
            if (m == 1 || this.period == null) {
                return this;
            }
            MutablePeriod p = this.period.toMutablePeriod();
            for (int i = 0; i < this.period.size(); ++i) {
                p.setValue(i, this.period.getValue(i) * m);
            }
            return new DurationWithFields((ReadablePeriod)p);
        }

        @Override
        public Duration divideBy(int m) {
            int i;
            if (m == 1 || this.period == null) {
                return this;
            }
            MutablePeriod p = new MutablePeriod();
            for (i = 0; i < this.period.size(); ++i) {
                DurationFieldType f;
                int oldVal = this.period.getValue(i);
                DurationFieldType field = this.period.getFieldType(i);
                int remainder = oldVal % m;
                p.add(field, oldVal - remainder);
                if (remainder == 0) continue;
                int standardUnit = 1;
                if (DurationFieldType.centuries().equals(field)) {
                    f = DurationFieldType.years();
                    standardUnit = 100;
                } else if (DurationFieldType.years().equals(field)) {
                    f = DurationFieldType.months();
                    standardUnit = 12;
                } else if (DurationFieldType.halfdays().equals(field)) {
                    f = DurationFieldType.hours();
                    standardUnit = 12;
                } else if (DurationFieldType.days().equals(field)) {
                    f = DurationFieldType.hours();
                    standardUnit = 24;
                } else if (DurationFieldType.hours().equals(field)) {
                    f = DurationFieldType.minutes();
                    standardUnit = 60;
                } else if (DurationFieldType.minutes().equals(field)) {
                    f = DurationFieldType.seconds();
                    standardUnit = 60;
                } else if (DurationFieldType.seconds().equals(field)) {
                    f = DurationFieldType.millis();
                    standardUnit = 1000;
                } else if (DurationFieldType.months().equals(field)) {
                    f = DurationFieldType.days();
                    standardUnit = 30;
                } else if (DurationFieldType.weeks().equals(field)) {
                    f = DurationFieldType.days();
                    standardUnit = 7;
                } else if (DurationFieldType.millis().equals(field)) {
                    f = DurationFieldType.millis();
                    standardUnit = 0;
                } else {
                    throw new UnsupportedOperationException("Unsupported duration type: " + field + " when dividing");
                }
                p.add(f, standardUnit * remainder);
            }
            for (i = 0; i < p.size(); ++i) {
                p.setValue(i, p.getValue(i) / m);
            }
            return new DurationWithFields((ReadablePeriod)p);
        }

        @Override
        public Period getJodaTimePeriod() {
            return this.period != null ? this.period.toPeriod() : null;
        }

        @Override
        public org.joda.time.Duration getJodaTimeDuration() {
            return this.period != null ? this.period.toPeriod().toDurationFrom((ReadableInstant)JodaTimeUtils.INSTANT_ZERO) : null;
        }

        @Override
        public Duration resolve(Time refTime, int flags) {
            Instant instant;
            Instant instant2 = instant = refTime != null ? refTime.getJodaTimeInstant() : null;
            if (instant != null) {
                if ((flags & 0x2000) != 0) {
                    return new DurationWithMillis(this, (ReadableDuration)this.period.toPeriod().toDurationFrom((ReadableInstant)instant));
                }
                if ((flags & 0x1000) != 0) {
                    return new DurationWithMillis(this, (ReadableDuration)this.period.toPeriod().toDurationTo((ReadableInstant)instant));
                }
            }
            return this;
        }

        @Override
        public Duration add(Duration d) {
            Period p = this.period.toPeriod().plus((ReadablePeriod)d.getJodaTimePeriod());
            if (this instanceof InexactDuration || d instanceof InexactDuration) {
                return new InexactDuration(this, (ReadablePeriod)p);
            }
            return new DurationWithFields(this, (ReadablePeriod)p);
        }
    }

    public static abstract class Duration
    extends Temporal
    implements FuzzyInterval.FuzzyComparable<Duration> {
        public Duration() {
        }

        public Duration(Duration d) {
            super(d);
        }

        public static Duration getDuration(ReadablePeriod p) {
            return new DurationWithFields(p);
        }

        public static Duration getDuration(org.joda.time.Duration d) {
            return new DurationWithMillis((ReadableDuration)d);
        }

        public static Duration getInexactDuration(ReadablePeriod p) {
            return new InexactDuration(p);
        }

        public static Duration getInexactDuration(org.joda.time.Duration d) {
            return new InexactDuration((ReadablePeriod)d.toPeriod());
        }

        public InexactDuration makeInexact() {
            return new InexactDuration((ReadablePeriod)this.getJodaTimePeriod());
        }

        public DateTimeFieldType[] getDateTimeFields() {
            return null;
        }

        @Override
        public boolean isGrounded() {
            return false;
        }

        @Override
        public Time getTime() {
            return null;
        }

        public Time toTime(Time refTime) {
            return this.toTime(refTime, 0);
        }

        public Time toTime(Time refTime, int flags) {
            Partial p = refTime.getJodaTimePartial();
            if (p != null) {
                DateTimeFieldType[] dtFieldTypes = this.getDateTimeFields();
                Time t = null;
                if (dtFieldTypes != null) {
                    Instant instant;
                    for (DateTimeFieldType dtft : dtFieldTypes) {
                        if (!p.isSupported(dtft)) continue;
                        t = new PartialTime(JodaTimeUtils.discardMoreSpecificFields(p, dtft));
                    }
                    if (t == null && (instant = refTime.getJodaTimeInstant()) != null) {
                        for (DateTimeFieldType dtft : dtFieldTypes) {
                            if (!instant.isSupported(dtft)) continue;
                            Partial p2 = JodaTimeUtils.getPartial(instant, p.with(dtft, 1));
                            t = new PartialTime(JodaTimeUtils.discardMoreSpecificFields(p2, dtft));
                        }
                    }
                    if (t != null) {
                        if ((flags & 0x40) != 0) {
                            if (t.compareTo(refTime) >= 0) {
                                return t.subtract(this);
                            }
                        } else if ((flags & 0x80) != 0 && t.compareTo(refTime) <= 0) {
                            return t.add(this);
                        }
                    }
                    return t;
                }
            }
            Time minTime = refTime.subtract(this);
            Time maxTime = refTime.add(this);
            Range likelyRange = null;
            if ((flags & 0x2080) != 0) {
                likelyRange = new Range(refTime, maxTime, this);
            } else if ((flags & 0x1040) != 0) {
                likelyRange = new Range(minTime, refTime, this);
            } else {
                Duration halfDuration = this.divideBy(2);
                likelyRange = new Range(refTime.subtract(halfDuration), refTime.add(halfDuration), this);
            }
            if ((flags & 0xC0) != 0) {
                return new TimeWithRange(likelyRange);
            }
            Range r = new Range(minTime, maxTime, this.multiplyBy(2));
            return new InexactTime(new TimeWithRange(likelyRange), this, r);
        }

        @Override
        public Duration getDuration() {
            return this;
        }

        @Override
        public Range getRange(int flags, Duration granularity) {
            return new Range(null, null, this);
        }

        @Override
        public TimexType getTimexType() {
            return TimexType.DURATION;
        }

        public abstract Period getJodaTimePeriod();

        public abstract org.joda.time.Duration getJodaTimeDuration();

        @Override
        public String toFormattedString(int flags) {
            String m;
            String s;
            if (this.getTimeLabel() != null) {
                return this.getTimeLabel();
            }
            Period p = this.getJodaTimePeriod();
            String string = s = p != null ? p.toString() : "PXX";
            if ((flags & 3) == 0 && (m = this.getMod()) != null) {
                try {
                    TimexMod tm = TimexMod.valueOf(m);
                    if (tm.getSymbol() != null) {
                        s = tm.getSymbol() + s;
                    }
                }
                catch (Exception ex) {
                    // empty catch block
                }
            }
            return s;
        }

        @Override
        public Duration getPeriod() {
            StandardTemporalType tlt = this.getStandardTemporalType();
            if (tlt != null) {
                return tlt.getPeriod();
            }
            return this;
        }

        @Override
        public int compareTo(Duration d) {
            org.joda.time.Duration d1 = this.getJodaTimeDuration();
            org.joda.time.Duration d2 = d.getJodaTimeDuration();
            if (d1 == null && d2 == null) {
                return 0;
            }
            if (d1 == null) {
                return 1;
            }
            if (d2 == null) {
                return -1;
            }
            int cmp = d1.compareTo((ReadableDuration)d2);
            if (cmp == 0) {
                if (d.isApprox() && !this.isApprox()) {
                    return -1;
                }
                if (!d.isApprox() && this.isApprox()) {
                    return 1;
                }
                return 0;
            }
            return cmp;
        }

        @Override
        public boolean isComparable(Duration d) {
            return true;
        }

        public abstract Duration add(Duration var1);

        public abstract Duration multiplyBy(int var1);

        public abstract Duration divideBy(int var1);

        public Duration subtract(Duration d) {
            return this.add(d.multiplyBy(-1));
        }

        @Override
        public Duration resolve(Time refTime, int flags) {
            return this;
        }

        @Override
        public Temporal intersect(Temporal t) {
            if (t == null) {
                return this;
            }
            if (t == TIME_UNKNOWN || t == DURATION_UNKNOWN) {
                return this;
            }
            if (t instanceof Time) {
                RelativeTime rt = new RelativeTime((Time)t, TemporalOp.INTERSECT, this);
                rt = (RelativeTime)rt.addMod(this.getMod());
                return rt;
            }
            if (!(t instanceof Range) && t instanceof Duration) {
                Duration d = (Duration)t;
                return this.intersect(d);
            }
            return null;
        }

        public Duration intersect(Duration d) {
            if (d == null || d == DURATION_UNKNOWN) {
                return this;
            }
            int cmp = this.compareTo(d);
            if (cmp < 0) {
                return this;
            }
            return d;
        }

        public static Duration min(Duration d1, Duration d2) {
            if (d2 == null) {
                return d1;
            }
            if (d1 == null) {
                return d2;
            }
            if (d1.isComparable(d2)) {
                int c = d1.compareTo(d2);
                return c < 0 ? d1 : d2;
            }
            return d1;
        }

        public static Duration max(Duration d1, Duration d2) {
            if (d1 == null) {
                return d2;
            }
            if (d2 == null) {
                return d1;
            }
            if (d1.isComparable(d2)) {
                int c = d1.compareTo(d2);
                return c >= 0 ? d1 : d2;
            }
            return d2;
        }
    }

    public static class GroundedTime
    extends Time {
        ReadableInstant base;

        public GroundedTime(Time p, ReadableInstant base) {
            super(p);
            this.base = base;
        }

        public GroundedTime(ReadableInstant base) {
            this.base = base;
        }

        @Override
        public GroundedTime setTimeZone(DateTimeZone tz) {
            MutableDateTime tzBase = this.base.toInstant().toMutableDateTime();
            tzBase.setZone(tz);
            return new GroundedTime(this, (ReadableInstant)tzBase);
        }

        @Override
        public boolean hasTime() {
            return true;
        }

        @Override
        public boolean isGrounded() {
            return true;
        }

        @Override
        public Duration getDuration() {
            return DURATION_NONE;
        }

        @Override
        public Range getRange(int flags, Duration granularity) {
            return new Range(this, this);
        }

        @Override
        public String toFormattedString(int flags) {
            return this.base.toString();
        }

        @Override
        public Time resolve(Time refTime, int flags) {
            return this;
        }

        @Override
        public Time add(Duration offset) {
            Period p = offset.getJodaTimePeriod();
            GroundedTime g = new GroundedTime((ReadableInstant)this.base.toInstant().withDurationAdded((ReadableDuration)p.toDurationFrom(this.base), 1));
            g.approx = this.approx;
            g.mod = this.mod;
            return g;
        }

        @Override
        public Time intersect(Time t) {
            if (t.getRange().contains(this.getRange())) {
                return this;
            }
            return null;
        }

        @Override
        public Temporal intersect(Temporal other) {
            if (other == null) {
                return this;
            }
            if (other == TIME_UNKNOWN) {
                return this;
            }
            if (other.getRange().contains(this.getRange())) {
                return this;
            }
            return null;
        }

        @Override
        public Instant getJodaTimeInstant() {
            return this.base.toInstant();
        }

        @Override
        public Partial getJodaTimePartial() {
            return JodaTimeUtils.getPartial(this.base.toInstant(), JodaTimeUtils.EMPTY_ISO_PARTIAL);
        }
    }

    protected static class IsoDateTime
    extends PartialTime {
        IsoDate date;
        IsoTime time;

        public IsoDateTime(IsoDate date, IsoTime time) {
            this.date = date;
            this.time = time;
            this.base = JodaTimeUtils.combine(date.base, time.base);
        }

        @Override
        public boolean hasTime() {
            return this.time != null;
        }
    }

    protected static class IsoTime
    extends PartialTime {
        public int hour = -1;
        public int minute = -1;
        public int second = -1;
        public int millis = -1;
        public int halfday = -1;

        public IsoTime(int h, int m, int s) {
            this(h, m, s, -1, -1);
        }

        public IsoTime(Number h, Number m, Number s) {
            this(h, m, s, null, null);
        }

        public IsoTime(int h, int m, int s, int ms, int halfday) {
            this.hour = h;
            this.minute = m;
            this.second = s;
            this.millis = ms;
            this.halfday = halfday;
            this.initBase();
        }

        public IsoTime(Number h, Number m, Number s, Number ms, Number halfday) {
            this.hour = h != null ? h.intValue() : -1;
            this.minute = m != null ? m.intValue() : -1;
            this.second = s != null ? s.intValue() : -1;
            this.millis = ms != null ? ms.intValue() : -1;
            this.halfday = halfday != null ? halfday.intValue() : -1;
            this.initBase();
        }

        public IsoTime(String h, String m, String s) {
            this(h, m, s, null);
        }

        public IsoTime(String h, String m, String s, String ms) {
            if (h != null) {
                this.hour = Integer.parseInt(h);
            }
            if (m != null) {
                this.minute = Integer.parseInt(m);
            }
            if (s != null) {
                this.second = Integer.parseInt(s);
            }
            if (ms != null) {
                this.millis = Integer.parseInt(s);
            }
            this.initBase();
        }

        @Override
        public boolean hasTime() {
            return true;
        }

        private void initBase() {
            if (this.hour >= 0) {
                this.base = this.hour < 24 ? JodaTimeUtils.setField(this.base, DateTimeFieldType.hourOfDay(), this.hour) : JodaTimeUtils.setField(this.base, DateTimeFieldType.clockhourOfDay(), this.hour);
            }
            if (this.minute >= 0) {
                this.base = JodaTimeUtils.setField(this.base, DateTimeFieldType.minuteOfHour(), this.minute);
            }
            if (this.second >= 0) {
                this.base = JodaTimeUtils.setField(this.base, DateTimeFieldType.secondOfMinute(), this.second);
            }
            if (this.millis >= 0) {
                this.base = JodaTimeUtils.setField(this.base, DateTimeFieldType.millisOfSecond(), this.millis);
            }
            if (this.halfday >= 0) {
                this.base = JodaTimeUtils.setField(this.base, DateTimeFieldType.halfdayOfDay(), this.halfday);
            }
        }
    }

    public static class IsoDate
    extends PartialTime {
        public int era = -1;
        public int year = -1;
        public int month = -1;
        public int day = -1;

        public IsoDate(int y, int m, int d) {
            this.year = y;
            this.month = m;
            this.day = d;
            this.initBase();
        }

        public IsoDate(Number y, Number m, Number d) {
            this(y, m, d, null, null);
        }

        public IsoDate(Number y, Number m, Number d, Number era, Boolean yearEraAdjustNeeded) {
            this.year = y != null ? y.intValue() : -1;
            this.month = m != null ? m.intValue() : -1;
            this.day = d != null ? d.intValue() : -1;
            int n = this.era = era != null ? era.intValue() : -1;
            if (yearEraAdjustNeeded != null && yearEraAdjustNeeded.booleanValue() && this.era == 0 && this.year > 0) {
                --this.year;
            }
            this.initBase();
        }

        public IsoDate(String y, String m, String d) {
            if (y != null && !SUTime.PAD_FIELD_UNKNOWN4.equals(y)) {
                if (!y.matches("[+-]?[0-9X]{4}")) {
                    throw new IllegalArgumentException("Year not in ISO format " + y);
                }
                if (y.startsWith("-")) {
                    y = y.substring(1);
                    this.era = 0;
                } else if (y.startsWith("+")) {
                    y = y.substring(1);
                    this.era = 1;
                }
                if (!y.contains(SUTime.PAD_FIELD_UNKNOWN)) {
                    this.year = Integer.parseInt(y);
                }
            } else {
                y = SUTime.PAD_FIELD_UNKNOWN4;
            }
            if (m != null && !SUTime.PAD_FIELD_UNKNOWN2.equals(m)) {
                this.month = Integer.parseInt(m);
            } else {
                m = SUTime.PAD_FIELD_UNKNOWN2;
            }
            if (d != null && !SUTime.PAD_FIELD_UNKNOWN2.equals(d)) {
                this.day = Integer.parseInt(d);
            } else {
                d = SUTime.PAD_FIELD_UNKNOWN2;
            }
            this.initBase();
            if (this.year < 0 && !SUTime.PAD_FIELD_UNKNOWN4.equals(y)) {
                if (Character.isDigit(y.charAt(0)) && Character.isDigit(y.charAt(1))) {
                    int century = Integer.parseInt(y.substring(0, 2));
                    this.base = JodaTimeUtils.setField(this.base, DateTimeFieldType.centuryOfEra(), century);
                }
                if (Character.isDigit(y.charAt(2)) && Character.isDigit(y.charAt(3))) {
                    int cy = Integer.parseInt(y.substring(2, 4));
                    this.base = JodaTimeUtils.setField(this.base, DateTimeFieldType.yearOfCentury(), cy);
                } else if (Character.isDigit(y.charAt(2))) {
                    int decade = Integer.parseInt(y.substring(2, 3));
                    this.base = JodaTimeUtils.setField(this.base, JodaTimeUtils.DecadeOfCentury, decade);
                }
            }
        }

        private void initBase() {
            if (this.era >= 0) {
                this.base = JodaTimeUtils.setField(this.base, DateTimeFieldType.era(), this.era);
            }
            if (this.year >= 0) {
                this.base = JodaTimeUtils.setField(this.base, DateTimeFieldType.year(), this.year);
            }
            if (this.month >= 0) {
                this.base = JodaTimeUtils.setField(this.base, DateTimeFieldType.monthOfYear(), this.month);
            }
            if (this.day >= 0) {
                this.base = JodaTimeUtils.setField(this.base, DateTimeFieldType.dayOfMonth(), this.day);
            }
        }

        @Override
        public String toString() {
            StringBuilder os = new StringBuilder();
            if (this.era == 0) {
                os.append("-");
            } else if (this.era == 1) {
                os.append("+");
            }
            if (this.year >= 0) {
                os.append(this.year);
            } else {
                os.append(SUTime.PAD_FIELD_UNKNOWN4);
            }
            os.append("-");
            if (this.month >= 0) {
                os.append(this.month);
            } else {
                os.append(SUTime.PAD_FIELD_UNKNOWN2);
            }
            os.append("-");
            if (this.day >= 0) {
                os.append(this.day);
            } else {
                os.append(SUTime.PAD_FIELD_UNKNOWN2);
            }
            return os.toString();
        }

        public int getYear() {
            return this.year;
        }

        public void setYear(int y) {
            this.year = y;
            this.initBase();
        }

        public int getMonth() {
            return this.month;
        }

        public void setMonth(int m) {
            this.month = m;
            this.initBase();
        }

        public int getDay() {
            return this.day;
        }

        public void setDay(int d) {
            this.day = d;
            this.initBase();
        }

        public void setDate(int y, int m, int d) {
            this.year = y;
            this.month = m;
            this.day = d;
            this.initBase();
        }
    }

    public static class PartialTime
    extends Time {
        Partial base;
        DateTimeZone dateTimeZone;

        public PartialTime(Time t, Partial p) {
            super(t);
            this.base = p;
        }

        public PartialTime(PartialTime pt) {
            super(pt);
            this.base = pt.base;
        }

        public PartialTime(Partial base) {
            this.base = base;
        }

        public PartialTime() {
        }

        @Override
        public PartialTime setTimeZone(DateTimeZone tz) {
            PartialTime tzPt = new PartialTime(this, this.base);
            tzPt.dateTimeZone = tz;
            return tzPt;
        }

        @Override
        public Instant getJodaTimeInstant() {
            return JodaTimeUtils.getInstant(this.base);
        }

        @Override
        public Partial getJodaTimePartial() {
            return this.base;
        }

        @Override
        public boolean hasTime() {
            if (this.base == null) {
                return false;
            }
            DateTimeFieldType sdft = JodaTimeUtils.getMostSpecific(this.base);
            return sdft != null && JodaTimeUtils.isMoreGeneral(DateTimeFieldType.dayOfMonth(), sdft, this.base.getChronology());
        }

        protected boolean appendDateFormats(DateTimeFormatterBuilder builder, int flags) {
            boolean isTimex3;
            boolean alwaysPad = (flags & 0x1000) != 0;
            boolean hasDate = true;
            boolean isISO = (flags & 1) != 0;
            boolean bl = isTimex3 = (flags & 2) != 0;
            if (JodaTimeUtils.hasField((ReadablePartial)this.base, DateTimeFieldType.era())) {
                int era = this.base.get(DateTimeFieldType.era());
                if (era == 0) {
                    builder.appendLiteral('-');
                } else if (era == 1) {
                    builder.appendLiteral('+');
                }
            }
            if (JodaTimeUtils.hasField((ReadablePartial)this.base, DateTimeFieldType.centuryOfEra()) || JodaTimeUtils.hasField((ReadablePartial)this.base, JodaTimeUtils.DecadeOfCentury) || JodaTimeUtils.hasField((ReadablePartial)this.base, DateTimeFieldType.yearOfCentury())) {
                if (JodaTimeUtils.hasField((ReadablePartial)this.base, DateTimeFieldType.centuryOfEra())) {
                    builder.appendCenturyOfEra(2, 2);
                } else {
                    builder.appendLiteral(SUTime.PAD_FIELD_UNKNOWN2);
                }
                if (JodaTimeUtils.hasField((ReadablePartial)this.base, JodaTimeUtils.DecadeOfCentury)) {
                    builder.appendDecimal(JodaTimeUtils.DecadeOfCentury, 1, 1);
                    builder.appendLiteral(SUTime.PAD_FIELD_UNKNOWN);
                } else if (JodaTimeUtils.hasField((ReadablePartial)this.base, DateTimeFieldType.yearOfCentury())) {
                    builder.appendYearOfCentury(2, 2);
                } else {
                    builder.appendLiteral(SUTime.PAD_FIELD_UNKNOWN2);
                }
            } else if (JodaTimeUtils.hasField((ReadablePartial)this.base, DateTimeFieldType.year())) {
                builder.appendYear(4, 4);
            } else if (JodaTimeUtils.hasField((ReadablePartial)this.base, DateTimeFieldType.weekyear())) {
                builder.appendWeekyear(4, 4);
            } else {
                builder.appendLiteral(SUTime.PAD_FIELD_UNKNOWN4);
                hasDate = false;
            }
            boolean appendQuarter = false;
            boolean appendMonthDay = false;
            boolean appendWeekDay = false;
            if (isISO || isTimex3) {
                if (JodaTimeUtils.hasField((ReadablePartial)this.base, DateTimeFieldType.monthOfYear()) && JodaTimeUtils.hasField((ReadablePartial)this.base, DateTimeFieldType.dayOfMonth())) {
                    appendMonthDay = true;
                } else if (JodaTimeUtils.hasField((ReadablePartial)this.base, DateTimeFieldType.weekOfWeekyear()) || JodaTimeUtils.hasField((ReadablePartial)this.base, DateTimeFieldType.dayOfWeek())) {
                    appendWeekDay = true;
                } else if (JodaTimeUtils.hasField((ReadablePartial)this.base, DateTimeFieldType.monthOfYear()) || JodaTimeUtils.hasField((ReadablePartial)this.base, DateTimeFieldType.dayOfMonth())) {
                    appendMonthDay = true;
                } else if (JodaTimeUtils.hasField((ReadablePartial)this.base, JodaTimeUtils.QuarterOfYear)) {
                    appendQuarter = true;
                }
            } else {
                appendQuarter = true;
                appendMonthDay = true;
                appendWeekDay = true;
            }
            if (appendQuarter && JodaTimeUtils.hasField((ReadablePartial)this.base, JodaTimeUtils.QuarterOfYear)) {
                builder.appendLiteral("-Q");
                builder.appendDecimal(JodaTimeUtils.QuarterOfYear, 1, 1);
            }
            if (appendMonthDay && (JodaTimeUtils.hasField((ReadablePartial)this.base, DateTimeFieldType.monthOfYear()) || JodaTimeUtils.hasField((ReadablePartial)this.base, DateTimeFieldType.dayOfMonth()))) {
                hasDate = true;
                builder.appendLiteral('-');
                if (JodaTimeUtils.hasField((ReadablePartial)this.base, DateTimeFieldType.monthOfYear())) {
                    builder.appendMonthOfYear(2);
                } else {
                    builder.appendLiteral(SUTime.PAD_FIELD_UNKNOWN2);
                }
                if (JodaTimeUtils.hasField((ReadablePartial)this.base, DateTimeFieldType.dayOfMonth())) {
                    builder.appendLiteral('-');
                    builder.appendDayOfMonth(2);
                } else if (alwaysPad) {
                    builder.appendLiteral(SUTime.PAD_FIELD_UNKNOWN2);
                }
            }
            if (appendWeekDay && (JodaTimeUtils.hasField((ReadablePartial)this.base, DateTimeFieldType.weekOfWeekyear()) || JodaTimeUtils.hasField((ReadablePartial)this.base, DateTimeFieldType.dayOfWeek()))) {
                hasDate = true;
                builder.appendLiteral("-W");
                if (JodaTimeUtils.hasField((ReadablePartial)this.base, DateTimeFieldType.weekOfWeekyear())) {
                    builder.appendWeekOfWeekyear(2);
                } else {
                    builder.appendLiteral(SUTime.PAD_FIELD_UNKNOWN2);
                }
                if (JodaTimeUtils.hasField((ReadablePartial)this.base, DateTimeFieldType.dayOfWeek())) {
                    builder.appendLiteral("-");
                    builder.appendDayOfWeek(1);
                }
            }
            return hasDate;
        }

        protected boolean appendTimeFormats(DateTimeFormatterBuilder builder, int flags) {
            boolean alwaysPad = (flags & 0x1000) != 0;
            boolean hasTime = this.hasTime();
            DateTimeFieldType sdft = JodaTimeUtils.getMostSpecific(this.base);
            if (hasTime) {
                builder.appendLiteral("T");
                if (JodaTimeUtils.hasField((ReadablePartial)this.base, DateTimeFieldType.hourOfDay())) {
                    builder.appendHourOfDay(2);
                } else if (JodaTimeUtils.hasField((ReadablePartial)this.base, DateTimeFieldType.clockhourOfDay())) {
                    builder.appendClockhourOfDay(2);
                } else {
                    builder.appendLiteral(SUTime.PAD_FIELD_UNKNOWN2);
                }
                if (JodaTimeUtils.hasField((ReadablePartial)this.base, DateTimeFieldType.minuteOfHour())) {
                    builder.appendLiteral(":");
                    builder.appendMinuteOfHour(2);
                } else if (alwaysPad || JodaTimeUtils.isMoreGeneral(DateTimeFieldType.minuteOfHour(), sdft, this.base.getChronology())) {
                    builder.appendLiteral(":");
                    builder.appendLiteral(SUTime.PAD_FIELD_UNKNOWN2);
                }
                if (JodaTimeUtils.hasField((ReadablePartial)this.base, DateTimeFieldType.secondOfMinute())) {
                    builder.appendLiteral(":");
                    builder.appendSecondOfMinute(2);
                } else if (alwaysPad || JodaTimeUtils.isMoreGeneral(DateTimeFieldType.secondOfMinute(), sdft, this.base.getChronology())) {
                    builder.appendLiteral(":");
                    builder.appendLiteral(SUTime.PAD_FIELD_UNKNOWN2);
                }
                if (JodaTimeUtils.hasField((ReadablePartial)this.base, DateTimeFieldType.millisOfSecond())) {
                    builder.appendLiteral(".");
                    builder.appendMillisOfSecond(3);
                }
            }
            return hasTime;
        }

        protected DateTimeFormatter getFormatter(int flags) {
            DateTimeFormatterBuilder builder = new DateTimeFormatterBuilder();
            boolean hasDate = this.appendDateFormats(builder, flags);
            boolean hasTime = this.hasTime();
            if (hasTime) {
                if (!hasDate) {
                    builder.clear();
                }
                this.appendTimeFormats(builder, flags);
            }
            return builder.toFormatter();
        }

        @Override
        public boolean isGrounded() {
            return false;
        }

        @Override
        public Duration getDuration() {
            StandardTemporalType tlt = this.getStandardTemporalType();
            if (tlt != null) {
                return tlt.getDuration();
            }
            return Duration.getDuration((ReadablePeriod)JodaTimeUtils.getJodaTimePeriod(this.base));
        }

        @Override
        public Range getRange(int flags, Duration inputGranularity) {
            Duration d = this.getDuration();
            if (d != null) {
                int padType = flags & 0xF;
                PartialTime start = this;
                Duration granularity = inputGranularity;
                switch (padType) {
                    case 1: {
                        start = this;
                        break;
                    }
                    case 2: {
                        granularity = this.hasTime() ? MILLIS : DAY;
                        start = this.padMoreSpecificFields(granularity);
                        break;
                    }
                    case 3: {
                        granularity = MILLIS;
                        start = this.padMoreSpecificFields(granularity);
                        break;
                    }
                    case 4: {
                        start = this.padMoreSpecificFields(granularity);
                        break;
                    }
                    default: {
                        throw new UnsupportedOperationException("Unsupported pad type for getRange: " + flags);
                    }
                }
                if (start instanceof PartialTime) {
                    start.withStandardFields();
                }
                Time end = ((Time)start).add(d);
                if (granularity != null) {
                    end = end.subtract(granularity);
                }
                return new Range(start, end, d);
            }
            return new Range(this, this);
        }

        protected void withStandardFields() {
            if (this.base.isSupported(DateTimeFieldType.dayOfWeek())) {
                this.base = JodaTimeUtils.resolveDowToDay(this.base);
            } else if (this.base.isSupported(DateTimeFieldType.monthOfYear()) && this.base.isSupported(DateTimeFieldType.dayOfMonth())) {
                if (this.base.isSupported(DateTimeFieldType.weekOfWeekyear())) {
                    this.base = this.base.without(DateTimeFieldType.weekOfWeekyear());
                }
                if (this.base.isSupported(DateTimeFieldType.dayOfWeek())) {
                    this.base = this.base.without(DateTimeFieldType.dayOfWeek());
                }
            }
        }

        public PartialTime padMoreSpecificFields(Duration granularity) {
            Period period = null;
            if (granularity != null) {
                period = granularity.getJodaTimePeriod();
            }
            Partial p = JodaTimeUtils.padMoreSpecificFields(this.base, period);
            return new PartialTime(p);
        }

        @Override
        public String toFormattedString(int flags) {
            DateTimeFormatter formatter;
            if (this.getTimeLabel() != null) {
                return this.getTimeLabel();
            }
            String s = null;
            if (this.base != null) {
                formatter = this.getFormatter(flags);
                s = formatter.print((ReadablePartial)this.base);
            } else {
                s = "XXXX-XX-XX";
            }
            if (this.dateTimeZone != null) {
                formatter = DateTimeFormat.forPattern((String)"Z");
                formatter = formatter.withZone(this.dateTimeZone);
                s = s + formatter.print(0L);
            }
            return s;
        }

        @Override
        public Time resolve(Time ref, int flags) {
            if (ref == null || ref == TIME_UNKNOWN || ref == TIME_REF) {
                return this;
            }
            if (this == TIME_REF) {
                return ref;
            }
            if (this == TIME_UNKNOWN) {
                return this;
            }
            Partial partialRef = ref.getJodaTimePartial();
            if (partialRef == null) {
                throw new UnsupportedOperationException("Cannot resolve if reftime is of class: " + ref.getClass());
            }
            Partial p = this.base != null ? JodaTimeUtils.combineMoreGeneralFields(this.base, partialRef) : partialRef;
            p = JodaTimeUtils.resolveDowToDay(p, partialRef);
            Time resolved = p == this.base ? this : new PartialTime(this, p);
            Duration resolvedGranularity = resolved.getGranularity();
            Duration refGranularity = ref.getGranularity();
            if (resolvedGranularity != null && refGranularity != null && resolvedGranularity.compareTo(refGranularity) >= 0) {
                if ((flags & 0x40) != 0) {
                    Time t;
                    if (resolved.compareTo(ref) > 0 && (t = (Time)this.prev()) != null) {
                        resolved = (Time)t.resolve(ref, 0);
                    }
                } else if ((flags & 0x80) != 0) {
                    Time t;
                    if (resolved.compareTo(ref) < 0 && (t = (Time)this.next()) != null) {
                        resolved = (Time)t.resolve(ref, 0);
                    }
                } else if ((flags & 0x200) != 0) {
                    Time resolved2;
                    Time t;
                    if (resolved.compareTo(ref) > 0 && (t = (Time)this.prev()) != null) {
                        resolved2 = (Time)t.resolve(ref, 0);
                        resolved = Time.closest(ref, resolved, resolved2);
                    }
                    if (resolved.compareTo(ref) < 0 && (t = (Time)this.next()) != null) {
                        resolved2 = (Time)t.resolve(ref, 0);
                        resolved = Time.closest(ref, resolved, resolved2);
                    }
                }
            }
            return resolved;
        }

        public boolean isCompatible(PartialTime time) {
            return JodaTimeUtils.isCompatible(this.base, time.base);
        }

        @Override
        public Duration getPeriod() {
            StandardTemporalType tlt = this.getStandardTemporalType();
            if (tlt != null) {
                return tlt.getPeriod();
            }
            if (this.base == null) {
                return null;
            }
            DateTimeFieldType mostGeneral = JodaTimeUtils.getMostGeneral(this.base);
            DurationFieldType df = mostGeneral.getRangeDurationType();
            if (df != null) {
                try {
                    return new DurationWithFields((ReadablePeriod)new Period().withField(df, 1));
                }
                catch (Exception ex) {
                    // empty catch block
                }
            }
            return null;
        }

        public List<Temporal> toList() {
            if (JodaTimeUtils.hasField((ReadablePartial)this.base, DateTimeFieldType.year()) && JodaTimeUtils.hasField((ReadablePartial)this.base, DateTimeFieldType.monthOfYear()) && JodaTimeUtils.hasField((ReadablePartial)this.base, DateTimeFieldType.dayOfWeek())) {
                ArrayList<Temporal> list = new ArrayList<Temporal>();
                Partial pt = new Partial();
                pt = JodaTimeUtils.setField(pt, DateTimeFieldType.year(), this.base.get(DateTimeFieldType.year()));
                pt = JodaTimeUtils.setField(pt, DateTimeFieldType.monthOfYear(), this.base.get(DateTimeFieldType.monthOfYear()));
                Partial candidate = JodaTimeUtils.resolveDowToDay(this.base, pt = JodaTimeUtils.setField(pt, DateTimeFieldType.dayOfMonth(), 1));
                if (candidate.get(DateTimeFieldType.monthOfYear()) != this.base.get(DateTimeFieldType.monthOfYear()) && (candidate = JodaTimeUtils.resolveDowToDay(this.base, pt = JodaTimeUtils.setField(pt, DateTimeFieldType.dayOfMonth(), 8))).get(DateTimeFieldType.monthOfYear()) != this.base.get(DateTimeFieldType.monthOfYear())) {
                    return null;
                }
                while (candidate.get(DateTimeFieldType.monthOfYear()) == this.base.get(DateTimeFieldType.monthOfYear())) {
                    list.add(new PartialTime(this, candidate));
                    pt = JodaTimeUtils.setField(pt, DateTimeFieldType.dayOfMonth(), pt.get(DateTimeFieldType.dayOfMonth()) + 7);
                    candidate = JodaTimeUtils.resolveDowToDay(this.base, pt);
                }
                return list;
            }
            return null;
        }

        @Override
        public Time intersect(Time t) {
            if (t == null || t == TIME_UNKNOWN) {
                return this;
            }
            if (this.base == null) {
                return t;
            }
            if (t instanceof CompositePartialTime) {
                return t.intersect(this);
            }
            if (t instanceof PartialTime) {
                if (!this.isCompatible((PartialTime)t)) {
                    return null;
                }
                Partial p = JodaTimeUtils.combine(this.base, ((PartialTime)t).base);
                return new PartialTime(p);
            }
            if (t instanceof GroundedTime) {
                return t.intersect(this);
            }
            if (t instanceof RelativeTime) {
                return t.intersect(this);
            }
            CompositePartialTime cpt = PartialTime.makeComposite(this, t);
            if (cpt != null) {
                return cpt;
            }
            if (t instanceof InexactTime) {
                return t.intersect(this);
            }
            return null;
        }

        protected PartialTime addSupported(Period p, int scalar) {
            return new PartialTime(this.base.withPeriodAdded((ReadablePeriod)p, scalar));
        }

        protected PartialTime addUnsupported(Period p, int scalar) {
            return new PartialTime(this, JodaTimeUtils.addForce(this.base, p, scalar));
        }

        @Override
        public Time add(Duration offset) {
            if (this.base == null) {
                return this;
            }
            Period per = offset.getJodaTimePeriod();
            PartialTime p = this.addSupported(per, 1);
            Period unsupported = JodaTimeUtils.getUnsupportedDurationPeriod(p.base, per);
            Time t = p;
            if (unsupported != null) {
                if (JodaTimeUtils.hasField((ReadablePeriod)unsupported, DurationFieldType.weeks()) && JodaTimeUtils.hasField((ReadablePartial)p.base, DateTimeFieldType.year()) && JodaTimeUtils.hasField((ReadablePartial)p.base, DateTimeFieldType.monthOfYear()) && JodaTimeUtils.hasField((ReadablePartial)p.base, DateTimeFieldType.dayOfMonth())) {
                    t = p.addUnsupported(per, 1);
                } else {
                    Partial p2;
                    if (JodaTimeUtils.hasField((ReadablePeriod)unsupported, DurationFieldType.months()) && unsupported.getMonths() % 3 == 0 && JodaTimeUtils.hasField((ReadablePartial)p.base, JodaTimeUtils.QuarterOfYear)) {
                        p2 = p.base.withFieldAddWrapped(JodaTimeUtils.Quarters, unsupported.getMonths() / 3);
                        p = new PartialTime(p, p2);
                        unsupported = unsupported.withMonths(0);
                    }
                    if (JodaTimeUtils.hasField((ReadablePeriod)unsupported, DurationFieldType.years()) && unsupported.getYears() % 10 == 0 && JodaTimeUtils.hasField((ReadablePartial)p.base, JodaTimeUtils.DecadeOfCentury)) {
                        p2 = p.base.withFieldAddWrapped(JodaTimeUtils.Decades, unsupported.getYears() / 10);
                        p = new PartialTime(p, p2);
                        unsupported = unsupported.withYears(0);
                    }
                    if (JodaTimeUtils.hasField((ReadablePeriod)unsupported, DurationFieldType.years()) && unsupported.getYears() % 100 == 0 && JodaTimeUtils.hasField((ReadablePartial)p.base, DateTimeFieldType.centuryOfEra())) {
                        p2 = p.base.withField(DateTimeFieldType.centuryOfEra(), p.base.get(DateTimeFieldType.centuryOfEra()) + unsupported.getYears() / 100);
                        p = new PartialTime(p, p2);
                        unsupported = unsupported.withYears(0);
                    }
                    if (unsupported.getDays() > 0 && !JodaTimeUtils.hasField((ReadablePartial)p.base, DateTimeFieldType.dayOfYear()) && !JodaTimeUtils.hasField((ReadablePartial)p.base, DateTimeFieldType.dayOfMonth()) && !JodaTimeUtils.hasField((ReadablePartial)p.base, DateTimeFieldType.dayOfWeek()) && JodaTimeUtils.hasField((ReadablePartial)p.base, DateTimeFieldType.monthOfYear())) {
                        p2 = p.base.with(DateTimeFieldType.dayOfMonth(), unsupported.getDays());
                        p = new PartialTime(p, p2);
                        unsupported = unsupported.withDays(0);
                    }
                    if (!unsupported.equals((Object)Period.ZERO)) {
                        t = new RelativeTime(p, new DurationWithFields((ReadablePeriod)unsupported));
                        t.approx = this.approx;
                        t.mod = this.mod;
                    } else {
                        t = p;
                    }
                }
            }
            return t;
        }
    }

    public static class RelativeTime
    extends Time {
        Time base = TIME_REF;
        TemporalOp tempOp;
        Temporal tempArg;
        int opFlags;

        public RelativeTime(Time base, TemporalOp tempOp, Temporal tempArg, int flags) {
            super(base);
            this.base = base;
            this.tempOp = tempOp;
            this.tempArg = tempArg;
            this.opFlags = flags;
        }

        public RelativeTime(Time base, TemporalOp tempOp, Temporal tempArg) {
            super(base);
            this.base = base;
            this.tempOp = tempOp;
            this.tempArg = tempArg;
        }

        public RelativeTime(TemporalOp tempOp, Temporal tempArg) {
            this.tempOp = tempOp;
            this.tempArg = tempArg;
        }

        public RelativeTime(TemporalOp tempOp, Temporal tempArg, int flags) {
            this.tempOp = tempOp;
            this.tempArg = tempArg;
            this.opFlags = flags;
        }

        public RelativeTime(Duration offset) {
            this(TIME_REF, TemporalOp.OFFSET, offset);
        }

        public RelativeTime(Time base, Duration offset) {
            this(base, TemporalOp.OFFSET, offset);
        }

        public RelativeTime(Time base) {
            this.base = base;
        }

        public RelativeTime() {
        }

        @Override
        public boolean isGrounded() {
            return this.base != null && this.base.isGrounded();
        }

        @Override
        public Duration getDuration() {
            return null;
        }

        @Override
        public Range getRange(int flags, Duration granularity) {
            return new Range(this, this);
        }

        @Override
        public Map<String, String> getTimexAttributes(TimeIndex timeIndex) {
            Map<String, String> map = super.getTimexAttributes(timeIndex);
            String tfid = this.getTfidString(timeIndex);
            map.put(TimexAttr.temporalFunction.name(), "true");
            map.put(TimexAttr.valueFromFunction.name(), tfid);
            if (this.base != null) {
                map.put(TimexAttr.anchorTimeID.name(), this.base.getTidString(timeIndex));
            }
            return map;
        }

        @Override
        public String toFormattedString(int flags) {
            if (this.getTimeLabel() != null) {
                return this.getTimeLabel();
            }
            if ((flags & 1) != 0) {
                return null;
            }
            if ((flags & 2) != 0) {
                return null;
            }
            StringBuilder sb = new StringBuilder();
            if (this.base != null && this.base != TIME_REF) {
                sb.append(this.base.toFormattedString(flags));
            }
            if (this.tempOp != null) {
                if (sb.length() > 0) {
                    sb.append(" ");
                }
                sb.append((Object)this.tempOp);
                if (this.tempArg != null) {
                    sb.append(" ").append(this.tempArg.toFormattedString(flags));
                }
            }
            return sb.toString();
        }

        @Override
        public Temporal resolve(Time refTime, int flags) {
            Temporal groundedBase = null;
            if (this.base == TIME_REF) {
                groundedBase = refTime;
            } else if (this.base != null) {
                groundedBase = this.base.resolve(refTime, flags);
            }
            if (this.tempOp != null) {
                Temporal t = this.tempOp.apply(groundedBase, this.tempArg, this.opFlags);
                if (t != null) {
                    t = t.addModApprox(this.mod, this.approx);
                    return t;
                }
                t = this.tempOp.apply((Temporal)this.base, this.tempArg, this.opFlags);
                if (t != null) {
                    if (!this.equals(t = t.addModApprox(this.mod, this.approx))) {
                        return t.resolve(refTime, flags);
                    }
                    return this;
                }
                return null;
            }
            return groundedBase != null ? groundedBase.addModApprox(this.mod, this.approx) : null;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            RelativeTime that = (RelativeTime)o;
            if (this.opFlags != that.opFlags) {
                return false;
            }
            if (this.base != null ? !this.base.equals(that.base) : that.base != null) {
                return false;
            }
            if (this.tempArg != null ? !this.tempArg.equals(that.tempArg) : that.tempArg != null) {
                return false;
            }
            return this.tempOp == that.tempOp;
        }

        public int hashCode() {
            int result = this.base != null ? this.base.hashCode() : 0;
            result = 31 * result + (this.tempOp != null ? this.tempOp.hashCode() : 0);
            result = 31 * result + (this.tempArg != null ? this.tempArg.hashCode() : 0);
            result = 31 * result + this.opFlags;
            return result;
        }

        @Override
        public Time add(Duration offset) {
            RelativeTime t;
            Duration d = offset;
            if (this.tempOp == null) {
                t = new RelativeTime(this.base, d);
                t.approx = this.approx;
                t.mod = this.mod;
            } else if (this.tempOp == TemporalOp.OFFSET) {
                d = ((Duration)this.tempArg).add(offset);
                t = new RelativeTime(this.base, d);
                t.approx = this.approx;
                t.mod = this.mod;
            } else {
                t = new RelativeTime(this, d);
            }
            return t;
        }

        @Override
        public Temporal intersect(Temporal t) {
            return new RelativeTime(this, TemporalOp.INTERSECT, t);
        }
    }

    public static class InexactTime
    extends Time {
        Time base;
        Duration duration;
        Range range;

        public InexactTime(Partial partial) {
            this.base = new PartialTime(partial);
            this.range = this.base.getRange();
            this.approx = true;
        }

        public InexactTime(Time base, Duration duration, Range range) {
            this.base = base;
            this.duration = duration;
            this.range = range;
            this.approx = true;
        }

        public InexactTime(InexactTime t, Time base, Duration duration, Range range) {
            super(t);
            this.base = base;
            this.duration = duration;
            this.range = range;
            this.approx = true;
        }

        public InexactTime(Range range) {
            this.base = range.mid();
            this.range = range;
            this.approx = true;
        }

        @Override
        public InexactTime setTimeZone(DateTimeZone tz) {
            return new InexactTime(this, (Time)Temporal.setTimeZone(this.base, tz), this.duration, (Range)Temporal.setTimeZone(this.range, tz));
        }

        @Override
        public Time getTime() {
            return this;
        }

        @Override
        public Duration getDuration() {
            if (this.duration != null) {
                return this.duration;
            }
            if (this.range != null) {
                return this.range.getDuration();
            }
            if (this.base != null) {
                return this.base.getDuration();
            }
            return null;
        }

        @Override
        public Range getRange(int flags, Duration granularity) {
            if (this.range != null) {
                return this.range.getRange(flags, granularity);
            }
            if (this.base != null) {
                return this.base.getRange(flags, granularity);
            }
            return null;
        }

        @Override
        public Time add(Duration offset) {
            if (this.getStandardTemporalType() != null) {
                return new RelativeTime(this, TemporalOp.OFFSET, offset);
            }
            return new InexactTime(this, (Time)TemporalOp.OFFSET.apply((Temporal)this.base, (Temporal)offset), this.duration, (Range)TemporalOp.OFFSET.apply((Temporal)this.range, (Temporal)offset));
        }

        @Override
        public Time resolve(Time refTime, int flags) {
            CompositePartialTime cpt = InexactTime.makeComposite(new PartialTime(this, new Partial()), this);
            if (cpt != null) {
                return cpt.resolve(refTime, flags);
            }
            Time groundedBase = null;
            if (this.base == TIME_REF) {
                groundedBase = refTime;
            } else if (this.base != null) {
                groundedBase = this.base.resolve(refTime, flags).getTime();
            }
            Range groundedRange = null;
            if (this.range != null) {
                groundedRange = this.range.resolve(refTime, flags).getRange();
            }
            return SUTime.createTemporal(this.standardTemporalType, this.timeLabel, this.mod, new InexactTime(groundedBase, this.duration, groundedRange));
        }

        @Override
        public Instant getJodaTimeInstant() {
            Instant p = null;
            if (this.base != null) {
                p = this.base.getJodaTimeInstant();
            }
            if (p == null && this.range != null) {
                p = this.range.mid().getJodaTimeInstant();
            }
            return p;
        }

        @Override
        public Partial getJodaTimePartial() {
            Partial p = null;
            if (this.base != null) {
                p = this.base.getJodaTimePartial();
            }
            if (p == null && this.range != null) {
                p = this.range.mid().getJodaTimePartial();
            }
            return p;
        }

        @Override
        public String toFormattedString(int flags) {
            if (this.getTimeLabel() != null) {
                return this.getTimeLabel();
            }
            if ((flags & 1) != 0) {
                return null;
            }
            if ((flags & 2) != 0) {
                return null;
            }
            StringBuilder sb = new StringBuilder();
            sb.append("~(");
            if (this.base != null) {
                sb.append(this.base.toFormattedString(flags));
            }
            if (this.duration != null) {
                sb.append(":");
                sb.append(this.duration.toFormattedString(flags));
            }
            if (this.range != null) {
                sb.append(" IN ");
                sb.append(this.range.toFormattedString(flags));
            }
            sb.append(")");
            return sb.toString();
        }
    }

    public static class TimeWithRange
    extends Time {
        Range range;

        public TimeWithRange(TimeWithRange t, Range range) {
            super(t);
            this.range = range;
        }

        public TimeWithRange(Range range) {
            this.range = range;
        }

        @Override
        public TimeWithRange setTimeZone(DateTimeZone tz) {
            return new TimeWithRange(this, (Range)Temporal.setTimeZone(this.range, tz));
        }

        @Override
        public Duration getDuration() {
            if (this.range != null) {
                return this.range.getDuration();
            }
            return null;
        }

        @Override
        public Range getRange(int flags, Duration granularity) {
            if (this.range != null) {
                return this.range.getRange(flags, granularity);
            }
            return null;
        }

        @Override
        public Time add(Duration offset) {
            if (this.getStandardTemporalType() != null) {
                return new RelativeTime(this, TemporalOp.OFFSET, offset);
            }
            return new TimeWithRange(this, this.range.offset(offset));
        }

        @Override
        public Time intersect(Time t) {
            if (t == null || t == TIME_UNKNOWN) {
                return this;
            }
            if (t instanceof CompositePartialTime) {
                return t.intersect(this);
            }
            if (t instanceof PartialTime) {
                return t.intersect(this);
            }
            if (t instanceof GroundedTime) {
                return t.intersect(this);
            }
            return new TimeWithRange((Range)this.range.intersect(t));
        }

        @Override
        public Time resolve(Time refTime, int flags) {
            CompositePartialTime cpt = TimeWithRange.makeComposite(new PartialTime(new Partial()), this);
            if (cpt != null) {
                return cpt.resolve(refTime, flags);
            }
            Range groundedRange = null;
            if (this.range != null) {
                groundedRange = this.range.resolve(refTime, flags).getRange();
            }
            return SUTime.createTemporal(this.standardTemporalType, this.timeLabel, new TimeWithRange(this, groundedRange));
        }

        @Override
        public String toFormattedString(int flags) {
            if (this.getTimeLabel() != null) {
                return this.getTimeLabel();
            }
            if ((flags & 2) != 0) {
                flags |= 1;
            }
            return this.range.toFormattedString(flags);
        }
    }

    public static class OrdinalTime
    extends Time {
        Temporal base;
        int n;

        public OrdinalTime(Temporal base, int n) {
            this.base = base;
            this.n = n;
        }

        @Override
        public Time add(Duration offset) {
            return new RelativeTime(this, TemporalOp.OFFSET, offset);
        }

        @Override
        public String toFormattedString(int flags) {
            String str;
            if (this.getTimeLabel() != null) {
                return this.getTimeLabel();
            }
            if ((flags & 1) != 0) {
                return null;
            }
            if ((flags & 2) != 0) {
                return null;
            }
            if (this.base != null && (str = this.base.toFormattedString(flags)) != null) {
                return str + "-#" + this.n;
            }
            return null;
        }

        @Override
        public Time intersect(Time t) {
            if (this.base instanceof PartialTime && t instanceof PartialTime) {
                return new OrdinalTime(this.base.intersect(t), this.n);
            }
            return new RelativeTime(this, TemporalOp.INTERSECT, t);
        }

        @Override
        public Temporal resolve(Time t, int flags) {
            PartialTime pt;
            List<Temporal> list;
            if (this.base instanceof PartialTime && (list = (pt = (PartialTime)this.base).toList()) != null && list.size() >= this.n) {
                return list.get(this.n - 1);
            }
            return this;
        }
    }

    public static class CompositePartialTime
    extends PartialTime {
        Time tod;
        Time dow;
        Time poy;

        public CompositePartialTime(PartialTime t, Time poy, Time dow, Time tod) {
            super(t);
            this.poy = poy;
            this.dow = dow;
            this.tod = tod;
        }

        public CompositePartialTime(PartialTime t, Partial p, Time poy, Time dow, Time tod) {
            this(t, poy, dow, tod);
            this.base = p;
        }

        @Override
        public Instant getJodaTimeInstant() {
            Partial p2;
            Partial p = this.base;
            if (this.tod != null && (p2 = this.tod.getJodaTimePartial()) != null && JodaTimeUtils.isCompatible(p, p2)) {
                p = JodaTimeUtils.combine(p, p2);
            }
            if (this.dow != null && (p2 = this.dow.getJodaTimePartial()) != null && JodaTimeUtils.isCompatible(p, p2)) {
                p = JodaTimeUtils.combine(p, p2);
            }
            if (this.poy != null && (p2 = this.poy.getJodaTimePartial()) != null && JodaTimeUtils.isCompatible(p, p2)) {
                p = JodaTimeUtils.combine(p, p2);
            }
            return JodaTimeUtils.getInstant(p);
        }

        @Override
        public Duration getDuration() {
            Duration bd;
            StandardTemporalType tlt = this.getStandardTemporalType();
            if (tlt != null) {
                return tlt.getDuration();
            }
            Duration duration = bd = this.base != null ? Duration.getDuration((ReadablePeriod)JodaTimeUtils.getJodaTimePeriod(this.base)) : null;
            if (this.tod != null) {
                Duration d = this.tod.getDuration();
                return bd.compareTo(d) < 0 ? bd : d;
            }
            if (this.dow != null) {
                Duration d = this.dow.getDuration();
                return bd.compareTo(d) < 0 ? bd : d;
            }
            if (this.poy != null) {
                Duration d = this.poy.getDuration();
                return bd.compareTo(d) < 0 ? bd : d;
            }
            return bd;
        }

        @Override
        public Duration getPeriod() {
            Duration d;
            StandardTemporalType tlt = this.getStandardTemporalType();
            if (tlt != null) {
                return tlt.getPeriod();
            }
            Duration bd = null;
            if (this.base != null) {
                DateTimeFieldType mostGeneral = JodaTimeUtils.getMostGeneral(this.base);
                DurationFieldType df = mostGeneral.getRangeDurationType();
                if (df == null) {
                    df = mostGeneral.getDurationType();
                }
                if (df != null) {
                    bd = new DurationWithFields((ReadablePeriod)new Period().withField(df, 1));
                }
            }
            if (this.poy != null) {
                d = this.poy.getPeriod();
                return bd.compareTo(d) > 0 ? bd : d;
            }
            if (this.dow != null) {
                d = this.dow.getPeriod();
                return bd.compareTo(d) > 0 ? bd : d;
            }
            if (this.tod != null) {
                d = this.tod.getPeriod();
                return bd.compareTo(d) > 0 ? bd : d;
            }
            return bd;
        }

        @Override
        public Range getRange(int flags, Duration granularity) {
            Duration d = this.getDuration();
            if (this.tod != null) {
                Range r = this.tod.getRange(flags, granularity);
                if (r != null) {
                    CompositePartialTime cpt = new CompositePartialTime(this, this.poy, this.dow, null);
                    Time t1 = cpt.intersect(r.beginTime());
                    Time t2 = cpt.intersect(r.endTime());
                    return new Range(t1, t2, d);
                }
                return super.getRange(flags, granularity);
            }
            if (this.dow != null) {
                Range r = this.dow.getRange(flags, granularity);
                if (r != null) {
                    Time t2;
                    CompositePartialTime cpt = new CompositePartialTime(this, this.poy, this.dow, null);
                    Time t1 = cpt.intersect(r.beginTime());
                    if (t1 instanceof PartialTime) {
                        ((PartialTime)t1).withStandardFields();
                    }
                    if ((t2 = cpt.intersect(r.endTime())) instanceof PartialTime) {
                        ((PartialTime)t2).withStandardFields();
                    }
                    return new Range(t1, t2, d);
                }
                return super.getRange(flags, granularity);
            }
            if (this.poy != null) {
                Range r = this.poy.getRange(flags, granularity);
                if (r != null) {
                    CompositePartialTime cpt = new CompositePartialTime(this, this.poy, null, null);
                    Time t1 = cpt.intersect(r.beginTime());
                    Time t2 = cpt.intersect(r.endTime());
                    return new Range(t1, t2, d);
                }
                return super.getRange(flags, granularity);
            }
            return super.getRange(flags, granularity);
        }

        @Override
        public Time intersect(Time t) {
            if (t == null || t == TIME_UNKNOWN) {
                return this;
            }
            if (this.base == null) {
                return t;
            }
            if (t instanceof PartialTime) {
                if (!this.isCompatible((PartialTime)t)) {
                    return null;
                }
                Partial p = JodaTimeUtils.combine(this.base, ((PartialTime)t).base);
                if (t instanceof CompositePartialTime) {
                    CompositePartialTime cpt = (CompositePartialTime)t;
                    Time ntod = Time.intersect(this.tod, cpt.tod);
                    Time ndow = Time.intersect(this.dow, cpt.dow);
                    Time npoy = Time.intersect(this.poy, cpt.poy);
                    if (ntod == null && (this.tod != null || cpt.tod != null)) {
                        return null;
                    }
                    if (ndow == null && (this.dow != null || cpt.dow != null)) {
                        return null;
                    }
                    if (npoy == null && (this.poy != null || cpt.poy != null)) {
                        return null;
                    }
                    return new CompositePartialTime(this, p, npoy, ndow, ntod);
                }
                return new CompositePartialTime(this, p, this.poy, this.dow, this.tod);
            }
            return super.intersect(t);
        }

        @Override
        protected PartialTime addSupported(Period p, int scalar) {
            return new CompositePartialTime(this, this.base.withPeriodAdded((ReadablePeriod)p, 1), this.poy, this.dow, this.tod);
        }

        @Override
        protected PartialTime addUnsupported(Period p, int scalar) {
            return new CompositePartialTime(this, JodaTimeUtils.addForce(this.base, p, scalar), this.poy, this.dow, this.tod);
        }

        @Override
        public Time resolve(Time ref, int flags) {
            Partial p;
            if (ref == null || ref == TIME_UNKNOWN || ref == TIME_REF) {
                return this;
            }
            if (this == TIME_REF) {
                return ref;
            }
            if (this == TIME_UNKNOWN) {
                return this;
            }
            Partial partialRef = ref.getJodaTimePartial();
            if (partialRef == null) {
                throw new UnsupportedOperationException("Cannot resolve if reftime is of class: " + ref.getClass());
            }
            DateTimeFieldType mgf = null;
            if (this.poy != null) {
                mgf = JodaTimeUtils.QuarterOfYear;
            } else if (this.dow != null) {
                mgf = DateTimeFieldType.dayOfWeek();
            } else if (this.tod != null) {
                mgf = DateTimeFieldType.halfdayOfDay();
            }
            Partial partial = p = this.base != null ? JodaTimeUtils.combineMoreGeneralFields(this.base, partialRef, mgf) : partialRef;
            if (p.isSupported(DateTimeFieldType.dayOfWeek())) {
                p = JodaTimeUtils.resolveDowToDay(p, partialRef);
            } else if (this.dow != null) {
                p = JodaTimeUtils.resolveWeek(p, partialRef);
            }
            if (p == this.base) {
                return this;
            }
            return new CompositePartialTime(this, p, this.poy, this.dow, this.tod);
        }

        @Override
        public DateTimeFormatter getFormatter(int flags) {
            DateTimeFormatterBuilder builder = new DateTimeFormatterBuilder();
            boolean hasDate = this.appendDateFormats(builder, flags);
            if (this.poy != null && !JodaTimeUtils.hasField((ReadablePartial)this.base, DateTimeFieldType.monthOfYear())) {
                builder.appendLiteral("-");
                builder.appendLiteral(this.poy.toISOString());
                hasDate = true;
            }
            if (this.dow != null && !JodaTimeUtils.hasField((ReadablePartial)this.base, DateTimeFieldType.monthOfYear()) && !JodaTimeUtils.hasField((ReadablePartial)this.base, DateTimeFieldType.dayOfWeek())) {
                builder.appendLiteral("-");
                builder.appendLiteral(this.dow.toISOString());
                hasDate = true;
            }
            if (this.hasTime()) {
                if (!hasDate) {
                    builder.clear();
                }
                this.appendTimeFormats(builder, flags);
            } else if (this.tod != null) {
                if (!hasDate) {
                    builder.clear();
                }
                builder.appendLiteral("T");
                builder.appendLiteral(this.tod.toISOString());
            }
            return builder.toFormatter();
        }

        @Override
        public TimexType getTimexType() {
            return this.hasTime() || this.tod != null ? TimexType.TIME : TimexType.DATE;
        }
    }

    public static class SimpleTime
    extends Time {
        String label;

        public SimpleTime(String label) {
            this.label = label;
        }

        @Override
        public String toFormattedString(int flags) {
            if (this.getTimeLabel() != null) {
                return this.getTimeLabel();
            }
            if ((flags & 1) != 0) {
                return null;
            }
            return this.label;
        }

        @Override
        public Time add(Duration offset) {
            RelativeTime t = new RelativeTime(this, TemporalOp.OFFSET, offset);
            return t;
        }
    }

    public static class RefTime
    extends Time {
        String label;

        public RefTime(String label) {
            this.label = label;
        }

        @Override
        public boolean isRef() {
            return true;
        }

        @Override
        public String toFormattedString(int flags) {
            if (this.getTimeLabel() != null) {
                return this.getTimeLabel();
            }
            if ((flags & 1) != 0) {
                return null;
            }
            return this.label;
        }

        @Override
        public Time add(Duration offset) {
            return new RelativeTime(this, TemporalOp.OFFSET, offset);
        }

        @Override
        public Time resolve(Time refTime, int flags) {
            if (this == TIME_REF) {
                return refTime;
            }
            if (this == TIME_NOW && (flags & 1) != 0) {
                return refTime;
            }
            return this;
        }
    }

    public static abstract class Time
    extends Temporal
    implements FuzzyInterval.FuzzyComparable<Time>,
    HasInterval<Time> {
        public Time() {
        }

        public Time(Time t) {
            super(t);
        }

        @Override
        public boolean isGrounded() {
            return false;
        }

        @Override
        public Time getTime() {
            return this;
        }

        @Override
        public Range getRange(int flags, Duration granularity) {
            return new Range(this, this);
        }

        @Override
        public Duration getDuration() {
            return DURATION_NONE;
        }

        @Override
        public Duration getGranularity() {
            StandardTemporalType tlt = this.getStandardTemporalType();
            if (tlt != null) {
                return tlt.getGranularity();
            }
            Partial p = this.getJodaTimePartial();
            return Duration.getDuration((ReadablePeriod)JodaTimeUtils.getJodaTimePeriod(p));
        }

        @Override
        public edu.stanford.nlp.util.Interval<Time> getInterval() {
            Range r = this.getRange();
            if (r != null) {
                return r.getInterval();
            }
            return null;
        }

        @Override
        public boolean isComparable(Time t) {
            Instant i = this.getJodaTimeInstant();
            Instant i2 = t.getJodaTimeInstant();
            return i != null && i2 != null;
        }

        @Override
        public int compareTo(Time t) {
            Instant i = this.getJodaTimeInstant();
            Instant i2 = t.getJodaTimeInstant();
            return i.compareTo((ReadableInstant)i2);
        }

        public boolean hasTime() {
            return false;
        }

        @Override
        public TimexType getTimexType() {
            if (this.getStandardTemporalType() != null) {
                return this.getStandardTemporalType().getTimexType();
            }
            return this.hasTime() ? TimexType.TIME : TimexType.DATE;
        }

        public boolean contains(Time t) {
            return this.getRange().contains(t.getRange());
        }

        public abstract Time add(Duration var1);

        public Time offset(Duration offset) {
            return this.add(offset);
        }

        public Time subtract(Duration offset) {
            return this.add(offset.multiplyBy(-1));
        }

        public static Time closest(Time ref, Time ... times) {
            Time res = null;
            long refMillis = ref.getJodaTimeInstant().getMillis();
            long min = 0L;
            for (Time t : times) {
                long d = Math.abs(refMillis - t.getJodaTimeInstant().getMillis());
                if (res != null && d >= min) continue;
                res = t;
                min = d;
            }
            return res;
        }

        public static Duration distance(Time t1, Time t2) {
            if (t1.compareTo(t2) < 0) {
                return Time.difference(t1, t2);
            }
            return Time.difference(t2, t1);
        }

        public static Duration difference(Time t1, Time t2) {
            Duration g2;
            if (t1 == null || t2 == null) {
                return null;
            }
            Instant i1 = t1.getJodaTimeInstant();
            Instant i2 = t2.getJodaTimeInstant();
            if (i1 == null || i2 == null) {
                return null;
            }
            DurationWithMillis d = new DurationWithMillis(i2.getMillis() - i1.getMillis());
            Duration g1 = t1.getGranularity();
            Duration g = Duration.max(g1, g2 = t2.getGranularity());
            if (g != null) {
                Period p = g.getJodaTimePeriod();
                p = p.normalizedStandard();
                Period p2 = JodaTimeUtils.discardMoreSpecificFields(((Duration)d).getJodaTimePeriod(), p.getFieldType(p.size() - 1), i1.getChronology());
                return new DurationWithFields((ReadablePeriod)p2);
            }
            return d;
        }

        public static CompositePartialTime makeComposite(PartialTime pt, Time t) {
            CompositePartialTime cp = null;
            StandardTemporalType tlt = t.getStandardTemporalType();
            if (tlt != null) {
                switch (tlt) {
                    case TIME_OF_DAY: {
                        cp = new CompositePartialTime(pt, null, null, t);
                        break;
                    }
                    case PART_OF_YEAR: 
                    case QUARTER_OF_YEAR: 
                    case SEASON_OF_YEAR: {
                        cp = new CompositePartialTime(pt, t, null, null);
                        break;
                    }
                    case DAYS_OF_WEEK: {
                        cp = new CompositePartialTime(pt, null, t, null);
                    }
                }
            }
            return cp;
        }

        @Override
        public Temporal resolve(Time t, int flags) {
            return this;
        }

        @Override
        public Temporal intersect(Temporal t) {
            if (t == null) {
                return this;
            }
            if (t == TIME_UNKNOWN || t == DURATION_UNKNOWN) {
                return this;
            }
            if (t instanceof Time) {
                return this.intersect((Time)t);
            }
            if (t instanceof Range) {
                return t.intersect(this);
            }
            if (t instanceof Duration) {
                return new RelativeTime(this, TemporalOp.INTERSECT, t);
            }
            return null;
        }

        protected Time intersect(Time t) {
            return null;
        }

        protected static Time intersect(Time t1, Time t2) {
            if (t1 == null) {
                return t2;
            }
            if (t2 == null) {
                return t1;
            }
            return t1.intersect(t2);
        }

        public static Time min(Time t1, Time t2) {
            if (t2 == null) {
                return t1;
            }
            if (t1 == null) {
                return t2;
            }
            if (t1.isComparable(t2)) {
                int c = t1.compareTo(t2);
                return c < 0 ? t1 : t2;
            }
            return t1;
        }

        public static Time max(Time t1, Time t2) {
            if (t1 == null) {
                return t2;
            }
            if (t2 == null) {
                return t1;
            }
            if (t1.isComparable(t2)) {
                int c = t1.compareTo(t2);
                return c >= 0 ? t1 : t2;
            }
            return t2;
        }

        public Instant getJodaTimeInstant() {
            return null;
        }

        public Partial getJodaTimePartial() {
            return null;
        }
    }

    public static enum TemporalOp {
        NEXT{

            @Override
            public Temporal apply(Temporal arg1, Temporal arg2, int flags) {
                if (arg2 == null) {
                    return arg1;
                }
                Temporal arg2Next = arg2.next();
                if (arg1 == null || arg2Next == null) {
                    return arg2Next;
                }
                if (arg1 instanceof Time) {
                    Temporal resolved = arg2Next.resolve((Time)arg1, 0);
                    return resolved;
                }
                throw new UnsupportedOperationException("NEXT not implemented for arg1=" + arg1.getClass() + ", arg2=" + arg2.getClass());
            }
        }
        ,
        NEXT_IMMEDIATE{

            @Override
            public Temporal apply(Temporal arg1, Temporal arg2, int flags) {
                if (arg1 == null) {
                    return new RelativeTime(NEXT_IMMEDIATE, arg2);
                }
                if (arg2 == null) {
                    return arg1;
                }
                if (arg1 instanceof Time) {
                    Time t = (Time)arg1;
                    if (arg2 instanceof Duration) {
                        return ((Duration)arg2).toTime(t, flags | 0x80);
                    }
                    Temporal resolvedThis = arg2.resolve(t, 128);
                    if (resolvedThis != null && resolvedThis instanceof Time && ((Time)resolvedThis).compareTo(t) <= 0) {
                        return NEXT.apply(arg1, arg2);
                    }
                    return resolvedThis;
                }
                throw new UnsupportedOperationException("NEXT_IMMEDIATE not implemented for arg1=" + arg1.getClass() + ", arg2=" + arg2.getClass());
            }
        }
        ,
        THIS{

            @Override
            public Temporal apply(Temporal arg1, Temporal arg2, int flags) {
                if (arg1 == null) {
                    return new RelativeTime(THIS, arg2, flags);
                }
                if (arg1 instanceof Time) {
                    if (arg2 instanceof Duration) {
                        return ((Duration)arg2).toTime((Time)arg1, flags);
                    }
                    return arg2.resolve((Time)arg1, flags | 0x20);
                }
                throw new UnsupportedOperationException("THIS not implemented for arg1=" + arg1.getClass() + ", arg2=" + arg2.getClass());
            }
        }
        ,
        PREV{

            @Override
            public Temporal apply(Temporal arg1, Temporal arg2, int flags) {
                if (arg2 == null) {
                    return arg1;
                }
                Temporal arg2Prev = arg2.prev();
                if (arg1 == null || arg2Prev == null) {
                    return arg2Prev;
                }
                if (arg1 instanceof Time) {
                    Temporal resolved = arg2Prev.resolve((Time)arg1, 0);
                    return resolved;
                }
                throw new UnsupportedOperationException("PREV not implemented for arg1=" + arg1.getClass() + ", arg2=" + arg2.getClass());
            }
        }
        ,
        PREV_IMMEDIATE{

            @Override
            public Temporal apply(Temporal arg1, Temporal arg2, int flags) {
                if (arg1 == null) {
                    return new RelativeTime(PREV_IMMEDIATE, arg2);
                }
                if (arg2 == null) {
                    return arg1;
                }
                if (arg1 instanceof Time) {
                    Time t = (Time)arg1;
                    if (arg2 instanceof Duration) {
                        return ((Duration)arg2).toTime(t, flags | 0x40);
                    }
                    Temporal resolvedThis = arg2.resolve(t, 64);
                    if (resolvedThis != null && resolvedThis instanceof Time && ((Time)resolvedThis).compareTo(t) >= 0) {
                        return PREV.apply(arg1, arg2);
                    }
                    return resolvedThis;
                }
                throw new UnsupportedOperationException("PREV_IMMEDIATE not implemented for arg1=" + arg1.getClass() + ", arg2=" + arg2.getClass());
            }
        }
        ,
        UNION{

            @Override
            public Temporal apply(Temporal arg1, Temporal arg2, int flags) {
                if (arg1 == null) {
                    return arg2;
                }
                if (arg2 == null) {
                    return arg1;
                }
                throw new UnsupportedOperationException("UNION not implemented for arg1=" + arg1.getClass() + ", arg2=" + arg2.getClass());
            }
        }
        ,
        INTERSECT{

            @Override
            public Temporal apply(Temporal arg1, Temporal arg2, int flags) {
                if (arg1 == null) {
                    return arg2;
                }
                if (arg2 == null) {
                    return arg1;
                }
                Temporal t = arg1.intersect(arg2);
                if (t == null) {
                    t = arg2.intersect(arg1);
                }
                return t;
            }
        }
        ,
        IN{

            @Override
            public Temporal apply(Temporal arg1, Temporal arg2, int flags) {
                if (arg1 == null) {
                    return arg2;
                }
                if (arg1 instanceof Time) {
                    return arg2.intersect((Time)arg1);
                }
                throw new UnsupportedOperationException("IN not implemented for arg1=" + arg1.getClass() + ", arg2=" + arg2.getClass());
            }
        }
        ,
        OFFSET{

            @Override
            public Temporal apply(Temporal arg1, Temporal arg2, int flags) {
                if (arg1 == null) {
                    return new RelativeTime(OFFSET, arg2);
                }
                if (arg1 instanceof Time && arg2 instanceof Duration) {
                    return ((Time)arg1).offset((Duration)arg2);
                }
                if (arg1 instanceof Range && arg2 instanceof Duration) {
                    return ((Range)arg1).offset((Duration)arg2);
                }
                throw new UnsupportedOperationException("OFFSET not implemented for arg1=" + arg1.getClass() + ", arg2=" + arg2.getClass());
            }
        }
        ,
        MINUS{

            @Override
            public Temporal apply(Temporal arg1, Temporal arg2, int flags) {
                if (arg1 == null) {
                    return arg2;
                }
                if (arg2 == null) {
                    return arg1;
                }
                if (arg1 instanceof Duration && arg2 instanceof Duration) {
                    return ((Duration)arg1).subtract((Duration)arg2);
                }
                if (arg1 instanceof Time && arg2 instanceof Duration) {
                    return ((Time)arg1).subtract((Duration)arg2);
                }
                if (arg1 instanceof Range && arg2 instanceof Duration) {
                    return ((Range)arg1).subtract((Duration)arg2);
                }
                throw new UnsupportedOperationException("MINUS not implemented for arg1=" + arg1.getClass() + ", arg2=" + arg2.getClass());
            }
        }
        ,
        PLUS{

            @Override
            public Temporal apply(Temporal arg1, Temporal arg2, int flags) {
                if (arg1 == null) {
                    return arg2;
                }
                if (arg2 == null) {
                    return arg1;
                }
                if (arg1 instanceof Duration && arg2 instanceof Duration) {
                    return ((Duration)arg1).add((Duration)arg2);
                }
                if (arg1 instanceof Time && arg2 instanceof Duration) {
                    return ((Time)arg1).add((Duration)arg2);
                }
                if (arg1 instanceof Range && arg2 instanceof Duration) {
                    return ((Range)arg1).add((Duration)arg2);
                }
                throw new UnsupportedOperationException("PLUS not implemented for arg1=" + arg1.getClass() + ", arg2=" + arg2.getClass());
            }
        }
        ,
        MIN{

            @Override
            public Temporal apply(Temporal arg1, Temporal arg2, int flags) {
                if (arg1 == null) {
                    return arg2;
                }
                if (arg2 == null) {
                    return arg1;
                }
                if (arg1 instanceof Time && arg2 instanceof Time) {
                    return Time.min((Time)arg1, (Time)arg2);
                }
                if (arg1 instanceof Duration && arg2 instanceof Duration) {
                    return Duration.min((Duration)arg1, (Duration)arg2);
                }
                throw new UnsupportedOperationException("MIN not implemented for arg1=" + arg1.getClass() + ", arg2=" + arg2.getClass());
            }
        }
        ,
        MAX{

            @Override
            public Temporal apply(Temporal arg1, Temporal arg2, int flags) {
                if (arg1 == null) {
                    return arg2;
                }
                if (arg2 == null) {
                    return arg1;
                }
                if (arg1 instanceof Time && arg2 instanceof Time) {
                    return Time.max((Time)arg1, (Time)arg2);
                }
                if (arg1 instanceof Duration && arg2 instanceof Duration) {
                    return Duration.max((Duration)arg1, (Duration)arg2);
                }
                throw new UnsupportedOperationException("MAX not implemented for arg1=" + arg1.getClass() + ", arg2=" + arg2.getClass());
            }
        }
        ,
        MULTIPLY{

            public Temporal apply(Duration d, int scale) {
                if (d == null) {
                    return null;
                }
                if (scale == 1) {
                    return d;
                }
                return d.multiplyBy(scale);
            }

            public Temporal apply(PeriodicTemporalSet d, int scale) {
                if (d == null) {
                    return null;
                }
                if (scale == 1) {
                    return d;
                }
                return d.multiplyDurationBy(scale);
            }

            @Override
            public Temporal apply(Object ... args) {
                if (args.length == 2) {
                    if (args[0] instanceof Duration && (args[1] instanceof Integer || args[1] instanceof Long)) {
                        return this.apply((Duration)args[0], ((Number)args[1]).intValue());
                    }
                    if (args[0] instanceof PeriodicTemporalSet && (args[1] instanceof Integer || args[1] instanceof Long)) {
                        return this.apply((PeriodicTemporalSet)args[0], ((Number)args[1]).intValue());
                    }
                }
                throw new UnsupportedOperationException("apply(Object...) not implemented for TemporalOp " + (Object)((Object)this));
            }
        }
        ,
        DIVIDE{

            public Temporal apply(Duration d, int scale) {
                if (d == null) {
                    return null;
                }
                if (scale == 1) {
                    return d;
                }
                return d.divideBy(scale);
            }

            public Temporal apply(PeriodicTemporalSet d, int scale) {
                if (d == null) {
                    return null;
                }
                if (scale == 1) {
                    return d;
                }
                return d.divideDurationBy(scale);
            }

            @Override
            public Temporal apply(Object ... args) {
                if (args.length == 2) {
                    if (args[0] instanceof Duration && (args[1] instanceof Integer || args[1] instanceof Long)) {
                        return this.apply((Duration)args[0], ((Number)args[1]).intValue());
                    }
                    if (args[0] instanceof PeriodicTemporalSet && (args[1] instanceof Integer || args[1] instanceof Long)) {
                        return this.apply((PeriodicTemporalSet)args[0], ((Number)args[1]).intValue());
                    }
                }
                throw new UnsupportedOperationException("apply(Object...) not implemented for TemporalOp " + (Object)((Object)this));
            }
        }
        ,
        CREATE{

            public Temporal apply(TimeUnit tu, int n) {
                return tu.createTemporal(n);
            }

            @Override
            public Temporal apply(Object ... args) {
                if (args.length == 2) {
                    if (args[0] instanceof TimeUnit && args[1] instanceof Number) {
                        return this.apply((TimeUnit)((Object)args[0]), ((Number)args[1]).intValue());
                    }
                    if (args[0] instanceof StandardTemporalType && args[1] instanceof Number) {
                        return ((StandardTemporalType)((Object)args[0])).createTemporal(((Number)args[1]).intValue());
                    }
                    if (args[0] instanceof Temporal && args[1] instanceof Number) {
                        return new OrdinalTime((Temporal)args[0], ((Number)args[1]).intValue());
                    }
                }
                throw new UnsupportedOperationException("apply(Object...) not implemented for TemporalOp " + (Object)((Object)this));
            }
        }
        ,
        ADD_MODIFIER{

            public Temporal apply(Temporal t, String modifier) {
                return t.addMod(modifier);
            }

            @Override
            public Temporal apply(Object ... args) {
                if (args.length == 2 && args[0] instanceof Temporal && args[1] instanceof String) {
                    return this.apply((Temporal)args[0], (String)args[1]);
                }
                throw new UnsupportedOperationException("apply(Object...) not implemented for TemporalOp " + (Object)((Object)this));
            }
        };


        public Temporal apply(Temporal arg1, Temporal arg2, int flags) {
            throw new UnsupportedOperationException("apply(Temporal, Temporal, int) not implemented for TemporalOp " + (Object)((Object)this));
        }

        public Temporal apply(Temporal arg1, Temporal arg2) {
            return this.apply(arg1, arg2, 0);
        }

        public Temporal apply(Temporal ... args) {
            if (args.length == 2) {
                return this.apply(args[0], args[1]);
            }
            throw new UnsupportedOperationException("apply(Temporal...) not implemented for TemporalOp " + (Object)((Object)this));
        }

        public Temporal apply(Object ... args) {
            throw new UnsupportedOperationException("apply(Object...) not implemented for TemporalOp " + (Object)((Object)this));
        }
    }

    public static enum StandardTemporalType {
        REFDATE(TimexType.DATE),
        REFTIME(TimexType.TIME),
        TIME_OF_DAY(TimexType.TIME, TimeUnit.HOUR, DAY){

            @Override
            public Duration getDuration() {
                return HOUR.makeInexact();
            }
        }
        ,
        DAY_OF_YEAR(TimexType.DATE, TimeUnit.DAY, YEAR){

            @Override
            protected Time _createTemporal(int n) {
                return new PartialTime(new Partial(DateTimeFieldType.dayOfYear(), n));
            }
        }
        ,
        DAY_OF_WEEK(TimexType.DATE, TimeUnit.DAY, WEEK){

            @Override
            protected Time _createTemporal(int n) {
                return new PartialTime(new Partial(DateTimeFieldType.dayOfWeek(), n));
            }
        }
        ,
        DAYS_OF_WEEK(TimexType.DATE, TimeUnit.DAY, WEEK){

            @Override
            public Duration getDuration() {
                return DAY.makeInexact();
            }
        }
        ,
        WEEK_OF_YEAR(TimexType.DATE, TimeUnit.WEEK, YEAR){

            @Override
            protected Time _createTemporal(int n) {
                return new PartialTime(new Partial(DateTimeFieldType.weekOfWeekyear(), n));
            }
        }
        ,
        MONTH_OF_YEAR(TimexType.DATE, TimeUnit.MONTH, YEAR){

            @Override
            protected Time _createTemporal(int n) {
                return new IsoDate(-1, n, -1);
            }
        }
        ,
        PART_OF_YEAR(TimexType.DATE, TimeUnit.DAY, YEAR){

            @Override
            public Duration getDuration() {
                return DAY.makeInexact();
            }
        }
        ,
        SEASON_OF_YEAR(TimexType.DATE, TimeUnit.QUARTER, YEAR),
        QUARTER_OF_YEAR(TimexType.DATE, TimeUnit.QUARTER, YEAR){

            @Override
            protected Time _createTemporal(int n) {
                return new PartialTime(new Partial(JodaTimeUtils.QuarterOfYear, n));
            }
        };

        TimexType timexType;
        TimeUnit unit = TimeUnit.UNKNOWN;
        Duration period = DURATION_NONE;

        private StandardTemporalType(TimexType timexType) {
            this.timexType = timexType;
        }

        private StandardTemporalType(TimexType timexType, TimeUnit unit) {
            this.timexType = timexType;
            this.unit = unit;
            this.period = unit.getPeriod();
        }

        private StandardTemporalType(TimexType timexType, TimeUnit unit, Duration period) {
            this.timexType = timexType;
            this.unit = unit;
            this.period = period;
        }

        public TimexType getTimexType() {
            return this.timexType;
        }

        public Duration getDuration() {
            return this.unit.getDuration();
        }

        public Duration getPeriod() {
            return this.period;
        }

        public Duration getGranularity() {
            return this.unit.getGranularity();
        }

        protected Temporal _createTemporal(int n) {
            return null;
        }

        public Temporal createTemporal(int n) {
            Temporal t = this._createTemporal(n);
            if (t != null) {
                t.standardTemporalType = this;
            }
            return t;
        }

        public Temporal create(Expressions.CompositeValue compositeValue) {
            StandardTemporalType temporalType = (StandardTemporalType)((Object)compositeValue.get("type"));
            String label = (String)compositeValue.get("label");
            String modifier = (String)compositeValue.get("modifier");
            Temporal temporal = (Temporal)compositeValue.get("value");
            if (temporal == null) {
                temporal = new PartialTime();
            }
            return SUTime.createTemporal(temporalType, label, modifier, temporal);
        }
    }

    public static enum TimeUnit {
        MILLIS(MILLIS),
        SECOND(SECOND),
        MINUTE(MINUTE),
        HOUR(HOUR),
        DAY(DAY),
        WEEK(WEEK),
        MONTH(MONTH),
        QUARTER(QUARTER),
        YEAR(YEAR),
        DECADE(DECADE),
        CENTURY(CENTURY),
        MILLENIUM(MILLENIUM),
        UNKNOWN(DURATION_UNKNOWN);

        protected Duration duration;

        private TimeUnit(Duration d) {
            this.duration = d;
        }

        public Duration getDuration() {
            return this.duration;
        }

        public Duration getPeriod() {
            return this.duration;
        }

        public Duration getGranularity() {
            return this.duration;
        }

        public Temporal createTemporal(int n) {
            return this.duration.multiplyBy(n);
        }
    }

    public static abstract class Temporal
    implements Cloneable {
        public String mod;
        public boolean approx;
        StandardTemporalType standardTemporalType;
        public String timeLabel;

        public Temporal() {
        }

        public Temporal(Temporal t) {
            this.mod = t.mod;
            this.approx = t.approx;
        }

        public abstract boolean isGrounded();

        public abstract Time getTime();

        public abstract Duration getDuration();

        public Range getRange() {
            return this.getRange(2);
        }

        public Range getRange(int flags) {
            return this.getRange(flags, null);
        }

        public abstract Range getRange(int var1, Duration var2);

        public Duration getPeriod() {
            StandardTemporalType tlt = this.getStandardTemporalType();
            if (tlt != null) {
                return tlt.getPeriod();
            }
            return null;
        }

        public Duration getGranularity() {
            StandardTemporalType tlt = this.getStandardTemporalType();
            if (tlt != null) {
                return tlt.getGranularity();
            }
            return null;
        }

        public Temporal resolve(Time refTime) {
            return this.resolve(refTime, 0);
        }

        public abstract Temporal resolve(Time var1, int var2);

        public StandardTemporalType getStandardTemporalType() {
            return this.standardTemporalType;
        }

        public boolean isRef() {
            return false;
        }

        public boolean isApprox() {
            return this.approx;
        }

        public int getTid(TimeIndex timeIndex) {
            return timeIndex.indexOfTemporal(this, true);
        }

        public String getTidString(TimeIndex timeIndex) {
            return "t" + this.getTid(timeIndex);
        }

        public int getTfid(TimeIndex timeIndex) {
            return timeIndex.indexOfTemporalFunc(this, true);
        }

        public String getTfidString(TimeIndex timeIndex) {
            return "tf" + this.getTfid(timeIndex);
        }

        public boolean includeTimexAltValue() {
            return false;
        }

        public Map<String, String> getTimexAttributes(TimeIndex timeIndex) {
            String str;
            LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
            map.put(TimexAttr.tid.name(), this.getTidString(timeIndex));
            String val = this.getTimexValue();
            if (val != null) {
                map.put(TimexAttr.value.name(), val);
            }
            if ((val == null || this.includeTimexAltValue()) && (str = this.toFormattedString(4)) != null) {
                map.put("alt_value", str);
            }
            map.put(TimexAttr.type.name(), this.getTimexType().name());
            if (this.mod != null) {
                map.put(TimexAttr.mod.name(), this.mod);
            }
            return map;
        }

        public TimexType getTimexType() {
            if (this.getStandardTemporalType() != null) {
                return this.getStandardTemporalType().getTimexType();
            }
            return null;
        }

        public String getTimexValue() {
            return this.toFormattedString(2);
        }

        public String toISOString() {
            return this.toFormattedString(1);
        }

        public String toString() {
            return this.toFormattedString(4);
        }

        public String getTimeLabel() {
            return this.timeLabel;
        }

        public String toFormattedString(int flags) {
            if (this.getTimeLabel() != null) {
                return this.getTimeLabel();
            }
            return null;
        }

        public static Temporal setTimeZone(Temporal t, DateTimeZone tz) {
            if (t == null) {
                return null;
            }
            return t.setTimeZone(tz);
        }

        public Temporal setTimeZone(DateTimeZone tz) {
            return this;
        }

        public Temporal next() {
            Duration per = this.getPeriod();
            if (per != null) {
                if (this instanceof Duration) {
                    return new RelativeTime(new RelativeTime(TemporalOp.THIS, this, 4096), TemporalOp.OFFSET, per);
                }
                return TemporalOp.OFFSET.apply(this, (Temporal)per);
            }
            return null;
        }

        public Temporal prev() {
            Duration per = this.getPeriod();
            if (per != null) {
                if (this instanceof Duration) {
                    return new RelativeTime(new RelativeTime(TemporalOp.THIS, this, 8192), TemporalOp.OFFSET, per.multiplyBy(-1));
                }
                return TemporalOp.OFFSET.apply(this, (Temporal)per.multiplyBy(-1));
            }
            return null;
        }

        public Temporal intersect(Temporal t) {
            return null;
        }

        public String getMod() {
            return this.mod;
        }

        public Temporal addMod(String mod) {
            try {
                Temporal t = (Temporal)this.clone();
                t.mod = mod;
                return t;
            }
            catch (CloneNotSupportedException ex) {
                throw new RuntimeException(ex);
            }
        }

        public Temporal addModApprox(String mod, boolean approx) {
            try {
                Temporal t = (Temporal)this.clone();
                t.mod = mod;
                t.approx = approx;
                return t;
            }
            catch (CloneNotSupportedException ex) {
                throw new RuntimeException(ex);
            }
        }
    }

    public static class TimeIndex {
        Index<Temporal> temporalIndex = new HashIndex<Temporal>();
        Index<Temporal> temporalFuncIndex = new HashIndex<Temporal>();

        public TimeIndex() {
            this.addTemporal(TIME_REF);
        }

        public void clear() {
            this.temporalIndex.clear();
            this.temporalFuncIndex.clear();
            this.addTemporal(TIME_REF);
        }

        public Temporal getTemporal(int i) {
            return this.temporalIndex.get(i);
        }

        public Temporal getTemporalFunc(int i) {
            return this.temporalFuncIndex.get(i);
        }

        public boolean addTemporal(Temporal t) {
            return this.temporalIndex.add(t);
        }

        public boolean addTemporalFunc(Temporal t) {
            return this.temporalFuncIndex.add(t);
        }

        public int indexOfTemporal(Temporal t, boolean add) {
            return this.temporalIndex.indexOf(t, add);
        }

        public int indexOfTemporalFunc(Temporal t, boolean add) {
            return this.temporalFuncIndex.indexOf(t, add);
        }
    }

    public static enum TimexAttr {
        type,
        value,
        tid,
        beginPoint,
        endPoint,
        quant,
        freq,
        mod,
        anchorTimeID,
        comment,
        valueFromFunction,
        temporalFunction,
        functionInDocument;

    }

    public static enum TimexDocFunc {
        CREATION_TIME,
        EXPIRATION_TIME,
        MODIFICATION_TIME,
        PUBLICATION_TIME,
        RELEASE_TIME,
        RECEPTION_TIME,
        NONE;

    }

    public static enum TimexMod {
        BEFORE("<"),
        AFTER(">"),
        ON_OR_BEFORE("<="),
        ON_OR_AFTER("<="),
        LESS_THAN("<"),
        MORE_THAN(">"),
        EQUAL_OR_LESS("<="),
        EQUAL_OR_MORE(">="),
        START,
        MID,
        END,
        APPROX("~"),
        EARLY,
        LATE;

        String symbol;

        private TimexMod() {
        }

        private TimexMod(String symbol) {
            this.symbol = symbol;
        }

        public String getSymbol() {
            return this.symbol;
        }
    }

    public static enum TimexType {
        DATE,
        TIME,
        DURATION,
        SET;

    }
}

