/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.trees;

import edu.stanford.nlp.ling.CoreLabel;
import edu.stanford.nlp.ling.HasWord;
import edu.stanford.nlp.ling.Label;
import edu.stanford.nlp.trees.Dependency;
import edu.stanford.nlp.trees.DependencyFactory;
import edu.stanford.nlp.util.XMLUtils;

public class UnnamedDependency
implements Dependency<Label, Label, Object> {
    private static final long serialVersionUID = -3768440215342256085L;
    protected final String regentText;
    protected final String dependentText;
    private final Label regent;
    private final Label dependent;

    public UnnamedDependency(String regent, String dependent) {
        if (regent == null || dependent == null) {
            throw new IllegalArgumentException("governor or dependent cannot be null");
        }
        CoreLabel headLabel = new CoreLabel();
        headLabel.setValue(regent);
        headLabel.setWord(regent);
        this.regent = headLabel;
        CoreLabel depLabel = new CoreLabel();
        depLabel.setValue(dependent);
        depLabel.setWord(dependent);
        this.dependent = depLabel;
        this.regentText = regent;
        this.dependentText = dependent;
    }

    public UnnamedDependency(Label regent, Label dependent) {
        if (regent == null || dependent == null) {
            throw new IllegalArgumentException("governor or dependent cannot be null");
        }
        this.regent = regent;
        this.dependent = dependent;
        this.regentText = this.getText(regent);
        this.dependentText = this.getText(dependent);
    }

    @Override
    public Label governor() {
        return this.regent;
    }

    @Override
    public Label dependent() {
        return this.dependent;
    }

    @Override
    public Object name() {
        return null;
    }

    protected String getText(Label label) {
        return label instanceof HasWord ? ((HasWord)((Object)label)).word() : label.value();
    }

    public int hashCode() {
        return this.regentText.hashCode() ^ this.dependentText.hashCode();
    }

    public boolean equals(Object o) {
        return this.equalsIgnoreName(o);
    }

    @Override
    public boolean equalsIgnoreName(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof UnnamedDependency)) {
            return false;
        }
        UnnamedDependency d = (UnnamedDependency)o;
        String thisHeadWord = this.regentText;
        String thisDepWord = this.dependentText;
        String headWord = d.regentText;
        String depWord = d.dependentText;
        return thisHeadWord.equals(headWord) && thisDepWord.equals(depWord);
    }

    public String toString() {
        return String.format("%s --> %s", this.regentText, this.dependentText);
    }

    @Override
    public String toString(String format) {
        if ("xml".equals(format)) {
            return "  <dep>\n    <governor>" + XMLUtils.escapeXML(this.governor().value()) + "</governor>\n    <dependent>" + XMLUtils.escapeXML(this.dependent().value()) + "</dependent>\n  </dep>";
        }
        if ("predicate".equals(format)) {
            return "dep(" + this.governor() + "," + this.dependent() + ")";
        }
        return this.toString();
    }

    @Override
    public DependencyFactory dependencyFactory() {
        return DependencyFactoryHolder.df;
    }

    public static DependencyFactory factory() {
        return DependencyFactoryHolder.df;
    }

    private static class UnnamedDependencyFactory
    implements DependencyFactory {
        private UnnamedDependencyFactory() {
        }

        @Override
        public Dependency<Label, Label, Object> newDependency(Label regent, Label dependent) {
            return this.newDependency(regent, dependent, null);
        }

        @Override
        public Dependency<Label, Label, Object> newDependency(Label regent, Label dependent, Object name) {
            return new UnnamedDependency(regent, dependent);
        }
    }

    private static class DependencyFactoryHolder {
        private static final DependencyFactory df = new UnnamedDependencyFactory();

        private DependencyFactoryHolder() {
        }
    }
}

