/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.trees.tregex.tsurgeon;

import edu.stanford.nlp.trees.Tree;
import edu.stanford.nlp.trees.tregex.TregexMatcher;
import edu.stanford.nlp.trees.tregex.tsurgeon.TsurgeonPattern;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

class RelabelNode
extends TsurgeonPattern {
    static final String regexPatternString = "((?:(?:[^/]*[^/\\\\])|\\\\/)*(?:\\\\\\\\)*)";
    static final Pattern regexPattern = Pattern.compile("/((?:(?:[^/]*[^/\\\\])|\\\\/)*(?:\\\\\\\\)*)/");
    static final String nodePatternString = "(=\\{[a-zA-Z0-9_]+\\})";
    static final Pattern nodePattern = Pattern.compile("(=\\{[a-zA-Z0-9_]+\\})");
    static final String variablePatternString = "(%\\{[a-zA-Z0-9_]+\\})";
    static final Pattern variablePattern = Pattern.compile("(%\\{[a-zA-Z0-9_]+\\})");
    static final String oneGeneralReplacement = "((=\\{[a-zA-Z0-9_]+\\})|(%\\{[a-zA-Z0-9_]+\\}))";
    static final Pattern oneGeneralReplacementPattern = Pattern.compile("((=\\{[a-zA-Z0-9_]+\\})|(%\\{[a-zA-Z0-9_]+\\}))");
    static final Pattern substPattern = Pattern.compile("/((?:(?:[^/]*[^/\\\\])|\\\\/)*(?:\\\\\\\\)*)/(.*)/");
    private final RelabelMode mode;
    private final String newLabel;
    private final Pattern labelRegex;
    private final String replacementString;
    private final List<String> replacementPieces;

    public RelabelNode(TsurgeonPattern child, String newLabel) {
        super("relabel", new TsurgeonPattern[]{child});
        Matcher m1 = substPattern.matcher(newLabel);
        if (m1.matches()) {
            this.mode = RelabelMode.REGEX;
            this.labelRegex = Pattern.compile(m1.group(1));
            this.replacementString = m1.group(2);
            this.replacementPieces = new ArrayList<String>();
            Matcher generalMatcher = oneGeneralReplacementPattern.matcher(m1.group(2));
            int lastPosition = 0;
            while (generalMatcher.find()) {
                if (generalMatcher.start() > lastPosition) {
                    this.replacementPieces.add(this.replacementString.substring(lastPosition, generalMatcher.start()));
                }
                lastPosition = generalMatcher.end();
                String piece = generalMatcher.group();
                if (piece.equals("")) continue;
                this.replacementPieces.add(generalMatcher.group());
            }
            if (lastPosition < this.replacementString.length()) {
                this.replacementPieces.add(this.replacementString.substring(lastPosition));
            }
            this.newLabel = null;
        } else {
            this.mode = RelabelMode.FIXED;
            Matcher m2 = regexPattern.matcher(newLabel);
            if (m2.matches()) {
                String unescapedLabel = m2.group(1);
                this.newLabel = RelabelNode.removeEscapeSlashes(unescapedLabel);
            } else {
                this.newLabel = newLabel;
            }
            this.replacementString = null;
            this.replacementPieces = null;
            this.labelRegex = null;
        }
    }

    private static String removeEscapeSlashes(String in) {
        StringBuilder out2 = new StringBuilder();
        int len = in.length();
        boolean lastIsBackslash = false;
        for (int i = 0; i < len; ++i) {
            char ch = in.charAt(i);
            if (ch == '\\') {
                if (lastIsBackslash || i == len - 1) {
                    out2.append(ch);
                    lastIsBackslash = false;
                    continue;
                }
                lastIsBackslash = true;
                continue;
            }
            out2.append(ch);
            lastIsBackslash = false;
        }
        return out2.toString();
    }

    @Override
    public Tree evaluate(Tree t, TregexMatcher tm) {
        Tree nodeToRelabel = this.children[0].evaluate(t, tm);
        switch (this.mode) {
            case FIXED: {
                nodeToRelabel.label().setValue(this.newLabel);
                break;
            }
            case REGEX: {
                Matcher m = this.labelRegex.matcher(nodeToRelabel.label().value());
                StringBuilder label = new StringBuilder();
                for (String chunk : this.replacementPieces) {
                    String name;
                    if (variablePattern.matcher(chunk).matches()) {
                        name = chunk.substring(2, chunk.length() - 1);
                        label.append(Matcher.quoteReplacement(tm.getVariableString(name)));
                        continue;
                    }
                    if (nodePattern.matcher(chunk).matches()) {
                        name = chunk.substring(2, chunk.length() - 1);
                        label.append(Matcher.quoteReplacement(tm.getNode(name).value()));
                        continue;
                    }
                    label.append(chunk);
                }
                nodeToRelabel.label().setValue(m.replaceAll(label.toString()));
                break;
            }
            default: {
                throw new AssertionError((Object)("Unsupported relabel mode " + (Object)((Object)this.mode)));
            }
        }
        return t;
    }

    @Override
    public String toString() {
        switch (this.mode) {
            case FIXED: {
                return this.label + '(' + this.children[0].toString() + ',' + this.newLabel + ')';
            }
            case REGEX: {
                return this.label + '(' + this.children[0].toString() + ',' + this.labelRegex.toString() + ',' + this.replacementString + ')';
            }
        }
        throw new AssertionError((Object)("Unsupported relabel mode " + (Object)((Object)this.mode)));
    }

    static enum RelabelMode {
        FIXED,
        REGEX;

    }
}

