/*
 * Decompiled with CFR 0.152.
 */
package javax.media.jai.registry;

import java.awt.image.RenderedImage;
import java.awt.image.renderable.ContextualRenderedImageFactory;
import java.awt.image.renderable.ParameterBlock;
import java.awt.image.renderable.RenderContext;
import javax.media.jai.JAI;
import javax.media.jai.OperationNode;
import javax.media.jai.OperationRegistry;
import javax.media.jai.PropertySource;
import javax.media.jai.RenderableOp;
import javax.media.jai.registry.JaiI18N;

public final class CRIFRegistry {
    private static final String MODE_NAME = "renderable";

    public static void register(OperationRegistry operationRegistry, String string, ContextualRenderedImageFactory contextualRenderedImageFactory) {
        operationRegistry = operationRegistry != null ? operationRegistry : JAI.getDefaultInstance().getOperationRegistry();
        operationRegistry.registerFactory(MODE_NAME, string, null, contextualRenderedImageFactory);
    }

    public static void unregister(OperationRegistry operationRegistry, String string, ContextualRenderedImageFactory contextualRenderedImageFactory) {
        operationRegistry = operationRegistry != null ? operationRegistry : JAI.getDefaultInstance().getOperationRegistry();
        operationRegistry.unregisterFactory(MODE_NAME, string, null, contextualRenderedImageFactory);
    }

    public static ContextualRenderedImageFactory get(OperationRegistry operationRegistry, String string) {
        operationRegistry = operationRegistry != null ? operationRegistry : JAI.getDefaultInstance().getOperationRegistry();
        return (ContextualRenderedImageFactory)operationRegistry.getFactory(MODE_NAME, string);
    }

    public static RenderedImage create(OperationRegistry operationRegistry, String string, RenderContext renderContext, ParameterBlock parameterBlock) {
        operationRegistry = operationRegistry != null ? operationRegistry : JAI.getDefaultInstance().getOperationRegistry();
        Object[] objectArray = new Object[]{renderContext, parameterBlock};
        return (RenderedImage)operationRegistry.invokeFactory(MODE_NAME, string, objectArray);
    }

    public static PropertySource getPropertySource(RenderableOp renderableOp) {
        if (renderableOp == null) {
            throw new IllegalArgumentException("op - " + JaiI18N.getString("Generic0"));
        }
        return renderableOp.getRegistry().getPropertySource((OperationNode)renderableOp);
    }
}

