/*
 * Decompiled with CFR 0.152.
 */
package opennlp.grok.preprocess.mwe;

import java.io.IOException;
import java.io.Reader;
import opennlp.common.util.PerlHelp;
import opennlp.grok.preprocess.mwe.MWEModel;
import opennlp.grok.preprocess.mwe.VariableMWEModel;

public class VariableMWEModelReader {
    private MWEModel model = new VariableMWEModel();
    public static final int NOUN = 1;
    public static final int ADVERB = 2;
    public static final int ADJECTIVE = 3;
    public static final int VERB = 4;

    public VariableMWEModelReader(Reader reader, int type) {
        this.addData(reader, type);
    }

    public void addData(Reader reader, int type) {
        if (type < 1 || type > 4) {
            throw new IllegalArgumentException("type expected to be one ofNOUN, ADVERB, ADJECTIVE or VERB");
        }
        try {
            StringBuffer sb = new StringBuffer();
            int chr = reader.read();
            while (chr >= 0) {
                if (chr == 10 || chr == 13) {
                    String line = sb.toString();
                    int split = line.indexOf(35);
                    if (split >= 0) {
                        line = line.substring(0, split);
                    }
                    if ((line = line.trim()).length() > 0) {
                        switch (type) {
                            case 1: {
                                String[] spaceSplit = PerlHelp.split((String)line);
                                this.model.addMWE(spaceSplit.length + " " + line);
                                break;
                            }
                            case 3: {
                                this.model.addMWE("-1 " + line);
                                break;
                            }
                            case 2: {
                                this.model.addMWE("-1 " + line);
                                break;
                            }
                            case 4: {
                                this.model.addMWE("1 " + line);
                            }
                        }
                    }
                    sb.setLength(0);
                } else {
                    sb.append((char)chr);
                }
                chr = reader.read();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public MWEModel getModel() {
        return this.model;
    }
}

