package Net::Amazon::EMR::EbsBlockDevice;
use Moose;
with 'Net::Amazon::EMR::Role::AttrHash';
use Net::Amazon::EMR::Coercions;
use Net::Amazon::EMR::VolumeSpecification;

has 'Device' => ( is => 'ro', 
                  isa => 'Str' );

has 'VolumeSpecification' => ( is => 'ro',
                               isa => 'Net::Amazon::EMR::Type::VolumeSpecification',
                               coerce => 1,
                           );

__PACKAGE__->meta->make_immutable();

1;

__END__

=head1 NAME

Net::Amazon::EMR::EbsBlockDevice

=head1 DESCRIPTION

Implements the EbsBlockDevice data type described at L<http://docs.amazonwebservices.com/ElasticMapReduce/latest/APIReference/API_EbsBlockDevice.html>.

=head1 AUTHOR

Jon Schutz 

L<http://notes.jschutz.net>

=head1 DOCUMENTATION, LICENSE AND COPYRIGHT

See L<Net::Amazon::EMR>.

=cut
