#!perl

use strict;
use warnings;

# This test was generated by inc::CheckJiraInChanges

use Test::More;

plan skip_all => "Disabled" if $ENV{NO_JIRA_CHECK};

my @commits = split /\n/, <<'EOC';
eb28fd35 (HEAD -> maint-v2.0, sandbox/maint-v2.0, origin/maint-v2.0, dagolden/maint-v2.0) PERL-959 Make Perl::Critic happy with the pvt construtor gen
d79be6f2 PERL-967 Document that X509 doesn't need username
0427b981 PERL-968 Re-enable release time spell check tests; fix more errors
ca4fca0a PERL-968 Fix spelling errors
61bd2f28 PERL-958 Don't require BSON::XS on Windows XP or earlier
90a2882e PERL-897 Limit use of nameOnly for non-name filters
3610cae7 PERL-897 Add nameOnly option to list_collections
cff63d82 PERL-959 Undefer constructor in the private constructor
a601807f PERL-953 Fix warning with default compression level
2e722608 PERL-952 Show how to upgrade v2 over v1 without shadows

EOC

my %ticket_map;
for my $commit ( @commits ) {
    for my $ticket ( $commit =~ /PERL-(\d+)/g ) {
        next if $ENV{CHECK_JIRA_SKIP}
            && grep { $ticket eq $_ } split " ", $ENV{CHECK_JIRA_SKIP};
        $ticket_map{$ticket} ||= [];
        push @{$ticket_map{$ticket}}, $commit;
    }
}

# grab Changes lines from new version to next un-indented line
open my $fh, "<:encoding(UTF-8)", "Changes";
my $changelog = do { local $/; <$fh> };

my @bad;
for my $ticket ( keys %ticket_map ) {
    if ( index( $changelog, "PERL-$ticket" ) < 0 ) {
       push @bad, $ticket;
    }
}

if ( !@commits ) {
    pass("No commits with Jira tickets");
}
else {
    ok( ! scalar @bad, "Jira tickets in Changes")
        or diag "Jira tickets missing:\n"
        . join("\n", map { "  * $_" } map { @{$ticket_map{$_}} } sort { $a <=> $b } @bad );
}

done_testing();
