
package Paws::RDS::ModifyEventSubscription;
  use Moose;
  has Enabled => (is => 'ro', isa => 'Bool');
  has EventCategories => (is => 'ro', isa => 'ArrayRef[Str|Undef]');
  has SnsTopicArn => (is => 'ro', isa => 'Str');
  has SourceType => (is => 'ro', isa => 'Str');
  has SubscriptionName => (is => 'ro', isa => 'Str', required => 1);

  use MooseX::ClassAttribute;

  class_has _api_call => (isa => 'Str', is => 'ro', default => 'ModifyEventSubscription');
  class_has _returns => (isa => 'Str', is => 'ro', default => 'Paws::RDS::ModifyEventSubscriptionResult');
  class_has _result_key => (isa => 'Str', is => 'ro', default => 'ModifyEventSubscriptionResult');
1;

### main pod documentation begin ###

=head1 NAME

Paws::RDS::ModifyEventSubscription - Arguments for method ModifyEventSubscription on L<Paws::RDS>

=head1 DESCRIPTION

This class represents the parameters used for calling the method ModifyEventSubscription on the
L<Amazon Relational Database Service|Paws::RDS> service. Use the attributes of this class
as arguments to method ModifyEventSubscription.

You shouldn't make instances of this class. Each attribute should be used as a named argument in the call to ModifyEventSubscription.

=head1 SYNOPSIS

    my $rds = Paws->service('RDS');
    # To change event notification subscription settings
    # This example changes the specified setting for the specified event
    # notification subscription.
    my $ModifyEventSubscriptionResult = $rds->ModifyEventSubscription(
      'Enabled'          => 1,
      'EventCategories'  => [ 'deletion', 'low storage' ],
      'SourceType'       => 'db-instance',
      'SubscriptionName' => 'mymysqleventsubscription'
    );

    # Results:
    my $EventSubscription = $ModifyEventSubscriptionResult->EventSubscription;

    # Returns a L<Paws::RDS::ModifyEventSubscriptionResult> object.

Values for attributes that are native types (Int, String, Float, etc) can passed as-is (scalar values). Values for complex Types (objects) can be passed as a HashRef. The keys and values of the hashref will be used to instance the underlying object.
For the AWS API documentation, see L<https://docs.aws.amazon.com/goto/WebAPI/rds/ModifyEventSubscription>

=head1 ATTRIBUTES


=head2 Enabled => Bool

A value that indicates whether to activate the subscription.



=head2 EventCategories => ArrayRef[Str|Undef]

A list of event categories for a source type (C<SourceType>) that you
want to subscribe to. You can see a list of the categories for a given
source type in Events
(https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Events.html)
in the I<Amazon RDS User Guide> or by using the
C<DescribeEventCategories> operation.



=head2 SnsTopicArn => Str

The Amazon Resource Name (ARN) of the SNS topic created for event
notification. The ARN is created by Amazon SNS when you create a topic
and subscribe to it.



=head2 SourceType => Str

The type of source that is generating the events. For example, if you
want to be notified of events generated by a DB instance, you would set
this parameter to db-instance. If this value isn't specified, all
events are returned.

Valid values: C<db-instance> | C<db-cluster> | C<db-parameter-group> |
C<db-security-group> | C<db-snapshot> | C<db-cluster-snapshot>



=head2 B<REQUIRED> SubscriptionName => Str

The name of the RDS event notification subscription.




=head1 SEE ALSO

This class forms part of L<Paws>, documenting arguments for method ModifyEventSubscription in L<Paws::RDS>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

