/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.util;

import edu.stanford.nlp.util.Scored;
import java.io.Serializable;
import java.util.Comparator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ScoredComparator
implements Comparator<Scored>,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final boolean ASCENDING = true;
    private static final boolean DESCENDING = false;
    public static final ScoredComparator ASCENDING_COMPARATOR = new ScoredComparator(true);
    public static final ScoredComparator DESCENDING_COMPARATOR = new ScoredComparator(false);
    private final boolean ascending;

    private ScoredComparator(boolean ascending) {
        this.ascending = ascending;
    }

    @Override
    public int compare(Scored o1, Scored o2) {
        if (o1 == o2) {
            return 0;
        }
        double d1 = o1.score();
        double d2 = o2.score();
        if (this.ascending) {
            if (d1 < d2) {
                return -1;
            }
            if (d1 > d2) {
                return 1;
            }
        } else {
            if (d1 < d2) {
                return 1;
            }
            if (d1 > d2) {
                return -1;
            }
        }
        return 0;
    }

    @Override
    public boolean equals(Object o) {
        if (o instanceof ScoredComparator) {
            ScoredComparator sc = (ScoredComparator)o;
            if (this.ascending == sc.ascending) {
                return true;
            }
        }
        return false;
    }

    public int hashCode() {
        if (this.ascending) {
            return 0x800000;
        }
        return 0x800001;
    }

    public String toString() {
        return "ScoredComparator(" + (this.ascending ? "ascending" : "descending") + ")";
    }
}

