# automatically generated file, don't edit



# Copyright 2024 David Cantrell, derived from data from libphonenumber
# http://code.google.com/p/libphonenumber/
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
package Number::Phone::StubCountry::DE;
use base qw(Number::Phone::StubCountry);

use strict;
use warnings;
use utf8;
our $VERSION = 1.20240910191015;

my $formatters = [
                {
                  'format' => '$1 $2',
                  'leading_digits' => '
            3[02]|
            40|
            [68]9
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{2})(\\d{3,13})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '
            2(?:
              0[1-389]|
              12[0-8]
            )|
            3(?:
              [35-9][15]|
              4[015]
            )|
            906|
            2(?:
              [13][14]|
              2[18]
            )|
            (?:
              2[4-9]|
              4[2-9]|
              [579][1-9]|
              [68][1-8]
            )1
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{3,12})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '
            [24-6]|
            3(?:
              3(?:
                0[1-467]|
                2[127-9]|
                3[124578]|
                7[1257-9]|
                8[1256]|
                9[145]
              )|
              4(?:
                2[135]|
                4[13578]|
                9[1346]
              )|
              5(?:
                0[14]|
                2[1-3589]|
                6[1-4]|
                7[13468]|
                8[13568]
              )|
              6(?:
                2[1-489]|
                3[124-6]|
                6[13]|
                7[12579]|
                8[1-356]|
                9[135]
              )|
              7(?:
                2[1-7]|
                4[145]|
                6[1-5]|
                7[1-4]
              )|
              8(?:
                21|
                3[1468]|
                6|
                7[1467]|
                8[136]
              )|
              9(?:
                0[12479]|
                2[1358]|
                4[134679]|
                6[1-9]|
                7[136]|
                8[147]|
                9[1468]
              )
            )|
            70[2-8]|
            8(?:
              0[2-9]|
              [1-8]
            )|
            90[7-9]|
            [79][1-9]|
            3[68]4[1347]|
            3(?:
              47|
              60
            )[1356]|
            3(?:
              3[46]|
              46|
              5[49]
            )[1246]|
            3[4579]3[1357]
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{4})(\\d{2,11})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '138',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{4})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '3',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{5})(\\d{2,10})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '181',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{5,11})'
                },
                {
                  'format' => '$1 $2 $3',
                  'leading_digits' => '
            1(?:
              3|
              80
            )|
            9
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d)(\\d{4,10})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '1[67]',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{7,8})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '8',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{7,12})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '18500',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{5})(\\d{6})'
                },
                {
                  'format' => '$1 $2 $3',
                  'leading_digits' => '7',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{4})(\\d{4})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '18[68]',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{4})(\\d{7})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '15[1279]',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{4})(\\d{7})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '
            15(?:
              [0568]|
              31
            )
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{5})(\\d{6})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '18',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{8})'
                },
                {
                  'format' => '$1 $2 $3',
                  'leading_digits' => '
            1(?:
              6[023]|
              7
            )
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{2})(\\d{7,8})'
                },
                {
                  'format' => '$1 $2 $3',
                  'leading_digits' => '15[279]',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{4})(\\d{2})(\\d{7})'
                },
                {
                  'format' => '$1 $2 $3',
                  'leading_digits' => '15',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{2})(\\d{8})'
                }
              ];

my $validators = {
                'fixed_line' => '
          32\\d{9,11}|
          49[1-6]\\d{10}|
          322\\d{6}|
          49[0-7]\\d{3,9}|
          (?:
            [34]0|
            [68]9
          )\\d{3,13}|
          (?:
            2(?:
              0[1-689]|
              [1-3569]\\d|
              4[0-8]|
              7[1-7]|
              8[0-7]
            )|
            3(?:
              [3569]\\d|
              4[0-79]|
              7[1-7]|
              8[1-8]
            )|
            4(?:
              1[02-9]|
              [2-48]\\d|
              5[0-6]|
              6[0-8]|
              7[0-79]
            )|
            5(?:
              0[2-8]|
              [124-6]\\d|
              [38][0-8]|
              [79][0-7]
            )|
            6(?:
              0[02-9]|
              [1-358]\\d|
              [47][0-8]|
              6[1-9]
            )|
            7(?:
              0[2-8]|
              1[1-9]|
              [27][0-7]|
              3\\d|
              [4-6][0-8]|
              8[0-5]|
              9[013-7]
            )|
            8(?:
              0[2-9]|
              1[0-79]|
              2\\d|
              3[0-46-9]|
              4[0-6]|
              5[013-9]|
              6[1-8]|
              7[0-8]|
              8[0-24-6]
            )|
            9(?:
              0[6-9]|
              [1-4]\\d|
              [589][0-7]|
              6[0-8]|
              7[0-467]
            )
          )\\d{3,12}
        ',
                'geographic' => '
          32\\d{9,11}|
          49[1-6]\\d{10}|
          322\\d{6}|
          49[0-7]\\d{3,9}|
          (?:
            [34]0|
            [68]9
          )\\d{3,13}|
          (?:
            2(?:
              0[1-689]|
              [1-3569]\\d|
              4[0-8]|
              7[1-7]|
              8[0-7]
            )|
            3(?:
              [3569]\\d|
              4[0-79]|
              7[1-7]|
              8[1-8]
            )|
            4(?:
              1[02-9]|
              [2-48]\\d|
              5[0-6]|
              6[0-8]|
              7[0-79]
            )|
            5(?:
              0[2-8]|
              [124-6]\\d|
              [38][0-8]|
              [79][0-7]
            )|
            6(?:
              0[02-9]|
              [1-358]\\d|
              [47][0-8]|
              6[1-9]
            )|
            7(?:
              0[2-8]|
              1[1-9]|
              [27][0-7]|
              3\\d|
              [4-6][0-8]|
              8[0-5]|
              9[013-7]
            )|
            8(?:
              0[2-9]|
              1[0-79]|
              2\\d|
              3[0-46-9]|
              4[0-6]|
              5[013-9]|
              6[1-8]|
              7[0-8]|
              8[0-24-6]
            )|
            9(?:
              0[6-9]|
              [1-4]\\d|
              [589][0-7]|
              6[0-8]|
              7[0-467]
            )
          )\\d{3,12}
        ',
                'mobile' => '
          15310\\d{6}|
          1(?:
            6[023]|
            7[0-57-9]
          )\\d{7,8}|
          1(?:
            5[0-25-9]|
            76
          )\\d{8}
        ',
                'pager' => '
          16(?:
            4\\d{1,10}|
            [89]\\d{1,11}
          )
        ',
                'personal_number' => '700\\d{8}',
                'specialrate' => '(
          180\\d{5,11}|
          13(?:
            7[1-6]\\d\\d|
            8
          )\\d{4}
        )|(
          (?:
            137[7-9]|
            900(?:
              [135]|
              9\\d
            )
          )\\d{6}
        )|(
          18(?:
            1\\d{5,11}|
            [2-9]\\d{8}
          )
        )',
                'toll_free' => '800\\d{7,12}',
                'voip' => ''
              };
my %areanames = ();
$areanames{de} = {"4935726", "Groß\ Särchen",
"498536", "Kößlarn",
"496364", "Nußbach\ Pfalz",
"498807", "Dießen\ am\ Ammersee",
"498170", "Straßlach\-Dingharting",
"497162", "Süßen",
"4935753", "Großräschen",
"4939976", "Groß\ Bützin",
"496321", "Neustadt\ an\ der\ Weinstraße",
"4935240", "Tauscha\ bei\ Großenhain",
"4935952", "Großröhrsdorf\ OL",
"494497", "Barßel\-Harkebrügge",
"4938234", "Born\ Darß",
"4935248", "Schönfeld\ bei\ Großenhain",
"499567", "Seßlach\-Gemünda",
"492339", "Sprockhövel\-Haßlinghausen",
"4936484", "Knau\ bei\ Pößneck",
"4935938", "Großpostwitz\ OL",
"497351", "Biberach\ an\ der\ Riß",
"498367", "Roßhaupten\ Forggensee",
"497355", "Hochdorf\ Riß",
"495827", "Unterlüß",
"4934493", "Gößnitz\ Thüringen",
"4936705", "Oberweißbach\ Thüringer\ Wald",
"4934445", "Stößen",
"495064", "Groß\ Düngen",
"496252", "Heppenheim\ Bergstraße",
"494509", "Groß\ Grönau",
"494483", "Ovelgönne\-Großenmeer",
"49911", "Nürnberg",
"492203", "Köln\-Porz",
"495053", "Faßberg\-Müden",
"499636", "Plößberg",
"498633", "Tüßling",
"499656", "Moosbach\ bei\ Vohenstrauß",
"499242", "Gößweinstein",
"4936072", "Weißenborn\-Lüderode",
"4989", "München",
"4934901", "Roßlau\ Elbe",
"4935841", "Großschönau\ Sachsen",
"4939883", "Groß\ Dölln",
"494684", "Langeneß\ Hallig",
"4939934", "Groß\ Plasten",
"493647", "Pößneck",
"496663", "Steinau\ an\ der\ Straße",
"499141", "Weißenburg\ in\ Bayern",
"495384", "Seesen\-Groß\ Rhüden",
"49221", "Köln",
"4936949", "Obermaßfeld\-Grimmenthal",};
$areanames{en} = {"497477", "Jungingen\ bei\ Hechingen",
"499481", "Pfatter",
"496036", "Wölfersheim",
"497229", "Iffezheim",
"4938293", "Kühlungsborn\ Ostseebad",
"4939085", "Zichtau",
"492522", "Oelde",
"495358", "Bahrdorf\-Mackendorf",
"495447", "Lembruch",
"498064", "Au\ bei\ Bad\ Aibling",
"498423", "Titting",
"495456", "Westerkappeln\-Velpe",
"494935", "Juist",
"4939489", "Strassberg\ Harz",
"499977", "Arnschwang",
"493933", "Genthin",
"495436", "Nortrup",
"499179", "Freystadt",
"494955", "Westoverledingen",
"498858", "Kochel\-Walchensee",
"494848", "Rantrum",
"497739", "Hilzingen",
"499426", "Oberschneiding",
"494973", "Wittmund\-Burhafe",
"498592", "Wegscheid\ Niederbayern",
"498462", "Berching",
"4937362", "Seiffen\ Erzgebirge",
"498046", "Bad\ Heilbrunn",
"496047", "Altenstadt\ Hessen",
"492661", "Bad\ Marienberg\ Westerwald",
"492563", "Stadtlohn",
"4934325", "Mochau\-Lüttewitz",
"492625", "Ochtendung",
"496056", "Bad\ Soden\-Salmünster",
"498057", "Aschau\-Sachrang",
"4938871", "Mühlen\ Eichsen",
"497025", "Neuffen",
"496848", "Homburg\-Einöd",
"4939292", "Biederitz",
"499163", "Dachsbach",
"4938723", "Kladrum",
"498724", "Massing",
"4938450", "Tarnow\ bei\ Bützow",
"497272", "Rülzheim",
"496285", "Walldürn\-Altheim",
"496244", "Westhofen\ Rheinhessenen",
"492384", "Welver",
"494154", "Trittau",
"498144", "Grafrath",
"49521", "Bielefeld",
"495242", "Rheda\-Wiedenbrück",
"496809", "Grossrosseln",
"495152", "Hessisch\ Oldendorf",
"494285", "Rhade\ bei\ Zeven",
"494244", "Harpstedt",
"4934244", "Mockrehna",
"498254", "Altomünster",
"496154", "Ober\-Ramstadt",
"497231", "Pforzheim",
"499648", "Neustadt\ am\ Kulm",
"497568", "Bad\ Wurzach\-Hauerz",
"495132", "Lehrte",
"498234", "Bobingen",
"496134", "Mainz\-Kastel",
"497251", "Bruchsal",
"499122", "Schwabach",
"4935249", "Basslitz",
"498166", "Allershausen\ Oberbayern",
"496167", "Modautal",
"49971", "Bad\ Kissingen",
"498267", "Dirlewang",
"499742", "Kalbach\ Rhön",
"496266", "Hassmersheim",
"497765", "Rickenbach\ Hotzenwald",
"494167", "Apensen",
"495171", "Peine",
"497721", "Villingen\ im\ Schwarzwald",
"4933833", "Wollin\ bei\ Brandenburg",
"4938787", "Glöwen",
"494266", "Brockel",
"4939722", "Sarnow\ bei\ Anklam",
"497141", "Ludwigsburg\ Württemberg",
"495503", "Nörten\-Hardenberg",
"494134", "Embsen\ Kreis\ Lüneburg",
"495601", "Schauenburg",
"4939246", "Lindau\ Anh",
"497226", "Bühl\-Sand",
"496039", "Karben",
"4933333", "Tantow",
"494761", "Bremervörde",
"498501", "Thyrnau",
"495777", "Diepenau\-Essern",
"497127", "Neckartenzlingen",
"494725", "Helgoland",
"4934658", "Hayn\ Harz",
"496255", "Lindenfels",
"492354", "Meinerzhagen",
"493723", "Hohenstein\-Ernstthal",
"497747", "Berau",
"4939428", "Pabstorf",
"494184", "Hanstedt\ Nordheide",
"4934772", "Helbra",
"4936331", "Ilfeld",
"495459", "Hörstel",
"494255", "Martfeld",
"495182", "Gronau\ Leine",
"498245", "Türkheim\ Wertach",
"49365", "Gera",
"495300", "Salzgitter\-Üfingen",
"498284", "Ziemetshausen",
"4937606", "Lengenfeld\ Vogtland",
"496184", "Langenselbold",
"494273", "Kirchdorf\ bei\ Sulingen",
"496145", "Flörsheim\ am\ Main",
"494528", "Schönwalde\ am\ Bungsberg",
"496761", "Simmern\ Hunsrück",
"496725", "Gau\-Algesheim",
"499176", "Allersberg",
"495439", "Bersenbrück",
"494235", "Langwedel\-Etelsen",
"4936928", "Neuenhof\ Thüringen",
"499429", "Rain\ Niederbayern",
"492405", "Würselen",
"497736", "Tengen",
"499277", "Warmensteinach",
"499606", "Pfreimd",
"493762", "Crimmitschau",
"4938301", "Putbus",
"496059", "Jossgrund",
"497504", "Horgenzell",
"492367", "Henrichenburg",
"4939747", "Züsedom",
"496235", "Schifferstadt",
"4939754", "Löcknitz\ Vorpom",
"492334", "Hagen\-Hohenlimburg",
"492842", "Kamp\-Lintfort",
"4939262", "Güsten\ Anh",
"49281", "Wesel",
"498135", "Sulzemoos",
"492360", "Haltern\-Lippramsdorf",
"499451", "Schierling",
"494966", "Neubörger",
"4938371", "Karlshagen",
"499074", "Höchstädt\ an\ der\ Donau",
"498807", "Diessen\ am\ Ammersee",
"496806", "Heusweiler",
"4938859", "Alt\ Zachun",
"495692", "Wolfhagen",
"499270", "Creussen",
"496694", "Neukirchen\ Knüll",
"497951", "Crailsheim",
"496021", "Aschaffenburg",
"494806", "Sarzbüttel",
"4936965", "Stadtlengsfeld",
"4939000", "Beetzendorf",
"499472", "Hohenfels\ Oberpfalz",
"494944", "Wiesmoor",
"497931", "Bad\ Mergentheim",
"495307", "Braunschweig\-Wenden",
"4937346", "Geyer",
"4935873", "Herrnhut",
"4938461", "Bützow",
"496269", "Gundelsheim\ Württemberg",
"4935027", "Weesenstein",
"499431", "Schwandorf",
"496086", "Grävenwiesbach",
"4933962", "Heiligengrabe",
"495465", "Neuenkirchen\ bei\ Bramsche",
"494269", "Ahausen\-Kirchwalsede",
"497972", "Gschwend\ bei\ Gaildorf",
"495421", "Dissen\ am\ Teutoburger\ Wald",
"495942", "Uelsen",
"49591", "Lingen\ \(Ems\)",
"499089", "Bissingen\-Unterringingen",
"498638", "Waldkraiburg",
"498752", "Au\ in\ der\ Hallertau",
"49471", "Bremerhaven",
"4936739", "Rottenbach",
"494742", "Dorum",
"4933083", "Schulzendorf\ Kreis\ Oberhavel",
"4939084", "Lindstedt",
"4936081", "Arenshausen",
"494122", "Uetersen",
"497774", "Eigeltingen",
"498222", "Burgau\ Schwaben",
"499134", "Neunkirchen\ am\ Brand",
"496122", "Hofheim\-Wallau",
"4935329", "Dollenchen",
"4937297", "Thum\ Sachsen",
"495744", "Hüllhorst",
"499167", "Oberscheinfeld",
"49671", "Bad\ Kreuznach",
"499266", "Mitwitz",
"496742", "Boppard",
"4934324", "Ostrau\ Sachsen",
"499154", "Pommelsbrunn",
"4936871", "Bad\ Colberg\-Heldburg",
"495507", "Ebergötzen",
"498771", "Ergoldsbach",
"494163", "Horneburg\ Niederelbe",
"4933873", "Grosswudicke",
"496648", "Bad\ Salzschlirf",
"493741", "Plauen",
"496163", "Höchst\ im\ Odenwald",
"492292", "Windeck\ Sieg",
"498732", "Frontenhausen",
"4937204", "Lichtenstein\ Sachsen",
"498263", "Breitenbrunn\ Schwaben",
"499285", "Kirchenlamitz",
"499244", "Betzenstein",
"492861", "Borken\ Westfalen",
"495766", "Rehburg\-Loccum",
"492825", "Uedem",
"494609", "Eggebek",
"493937", "Osterburg\ Altmark",
"494179", "Winsen\-Tönnhausen",
"493964", "Bredenfelde\ bei\ Strasburg",
"499955", "Mamming",
"492554", "Laer\ Kreis\ Steinfurt",
"499848", "Simmershofen",
"496328", "Elmstein",
"499973", "Furth\ im\ Wald",
"494426", "Wangerland\-Horumersiel",
"4934496", "Nöbdenitz",
"4939991", "Daberkow",
"495443", "Lemförde",
"498427", "Wellheim",
"496426", "Fronhausen",
"4936840", "Trusetal",
"494328", "Rickling",
"4936450", "Kranichfeld",
"4937432", "Pausa\ Vogtland",
"498033", "Oberaudorf",
"497473", "Mössingen",
"4939407", "Seehausen\ Börde",
"497455", "Dornhan",
"498053", "Bad\ Endorf",
"494481", "Hatten\-Sandkrug",
"498075", "Amerang",
"493946", "Quedlinburg",
"497435", "Albstadt\-Laufen",
"497304", "Blaustein\ Württemberg",
"496043", "Nidda",
"4935753", "Grossräschen",
"495026", "Steimbke",
"492567", "Ahaus\-Alstätte",
"499935", "Stephansposching",
"492534", "Münster\-Roxel",
"495925", "Wietmarschen",
"494977", "Blomberg\ Ostfriesland",
"495961", "Haselünne",
"4939397", "Geestgottberg",
"49385", "Schwerin",
"492992", "Marsberg",
"499086", "Fremdingen",
"496431", "Limburg\ an\ der\ Lahn",
"4935388", "Klöden",
"492584", "Warendorf\-Milte",
"494472", "Lastrup",
"493868", "Rastow",
"492545", "Rosendahl\-Darfeld",
"499944", "Miltach",
"492379", "Menden\-Asbeck",
"495051", "Bergen\ Kreis\ Celle",
"496472", "Weilmünster",
"495474", "Stemwede\-Dielingen",
"498803", "Peissenberg",
"494431", "Wildeshausen",
"497444", "Alpirsbach",
"499269", "Tettau\ Kreis\ Kronach",
"497485", "Empfingen",
"4938331", "Rakow\ Vorpom",
"495031", "Wunstorf",
"493471", "Bernburg\ Saale",
"498170", "Strasslach\-Dingharting",
"498083", "Isen",
"4938751", "Picher",
"498441", "Pfaffenhofen\ an\ der\ Ilm",
"494451", "Varel\ Jadebusen",
"494298", "Lilienthal",
"499966", "Wiesenfelden",
"49261", "Koblenz\ am\ Rhein",
"492642", "Remagen",
"495072", "Neustadt\-Mandelsloh",
"496451", "Frankenberg\ Eder",
"4934692", "Alsleben\ Saale",
"496298", "Möckmühl",
"493987", "Templin",
"496074", "Rödermark",
"497466", "Beuron",
"497042", "Vaihingen\ an\ der\ Enz",
"495769", "Steyerberg\-Voigtei",
"495303", "Wendeburg",
"498782", "Pfeffenhausen",
"496894", "St\ Ingbert",
"4938220", "Wustrow\ Ostseebad",
"494606", "Wanderup",
"499235", "Thierstein",
"494176", "Marschacht",
"495225", "Spenge",
"495261", "Lemgo",
"494277", "Schwaförden",
"498177", "Münsing\ Starnberger\ See",
"493727", "Mittweida",
"4934466", "Janisroda",
"4936964", "Dermbach\ Rhön",
"496429", "Schweinsberg\ Hessen",
"4936371", "Schlossvippach",
"497743", "Ühlingen\-Birkendorf",
"498276", "Baar\ Schwaben",
"495755", "Kalletal\-Varenholz",
"495773", "Stemwede\-Wehdem",
"497123", "Metzingen\ Württemberg",
"499184", "Deining\ Oberpfalz",
"499145", "Solnhofen",
"4935829", "Gersdorf\ bei\ Görlitz",
"498392", "Markt\ Rettenbach",
"499761", "Bad\ Königshofen\ im\ Grabfeld",
"493949", "Oschersleben\ Bode",
"499725", "Poppenhausen\ Unterfranken",
"492363", "Datteln",
"4939030", "Brunau",
"499255", "Marktleugast",
"497162", "Süssen",
"499273", "Bad\ Berneck\ im\ Fichtelgebirge",
"4936461", "Bad\ Sulza",
"499528", "Donnersdorf",
"4939826", "Blankensee\ bei\ Neustrelitz",
"496872", "Losheim\ am\ See",
"493366", "Beeskow",
"492502", "Nottuln",
"495874", "Soltendieck",
"494550", "Bühnsdorf",
"498403", "Pförring",
"494793", "Hambergen",
"497332", "Lauterstein",
"497844", "Rheinau",
"495341", "Salzgitter",
"49345", "Halle\ Saale",
"495196", "Wietzendorf",
"495659", "Ringgau",
"496831", "Saarlouis",
"497371", "Riedlingen\ Württemberg",
"494872", "Hanerau\-Hademarschen",
"496550", "Irrhausen",
"4938306", "Samtens",
"492133", "Dormagen",
"4936336", "Klettenberg",
"4934928", "Seegrehna",
"496851", "St\ Wendel",
"493385", "Rathenow",
"492605", "Löf",
"493344", "Bad\ Freienwalde",
"494383", "Grebin",
"492175", "Leichlingen\ Rheinland",
"498374", "Dietmannsried",
"492153", "Nettetal\-Lobberich",
"499406", "Mintraching",
"492243", "Eitorf",
"496383", "Glan\-Münchweiler",
"4935726", "Gross\ Särchen",
"4933607", "Briesen\ Mark",
"493871", "Parchim",
"4935242", "Nossen",
"497906", "Braunsbach",
"497352", "Ochsenhausen",
"498841", "Murnau\ am\ Staffelsee",
"494851", "Marne",
"4937601", "Mülsen\ Skt\ Jacob",
"493624", "Ohrdruf",
"4938466", "Jürgenshagen",
"494537", "Sülfeld\ Holstein",
"499651", "Vohenstrauss",
"4938824", "Mallentin",
"499553", "Ebrach\ Oberfranken",
"499349", "Werbach\-Wenkheim",
"4939482", "Gatersleben",
"4937341", "Ehrenfriedersdorf",
"4938732", "Gallin\ bei\ Lübz",
"499575", "Weismain",
"492974", "Schmallenberg\-Fredeburg",
"4933677", "Glienicke\ bei\ Beeskow",
"494494", "Bösel\ Oldenburg",
"498704", "Altdorf\-Pfettrach",
"4938427", "Blowatz",
"494564", "Schashagen",
"495686", "Schwarzenborn\ Knüll",
"495492", "Steinfeld\ Oldenburg",
"495562", "Dassel\-Markoldendorf",
"497138", "Schwaigern",
"496564", "Neuerburg\ Eifel",
"499778", "Fladungen",
"498536", "Kösslarn",
"494829", "Wewelsfleth",
"499672", "Neunburg\ vorm\ Wald",
"497158", "Neuhausen\ auf\ den\ Fildern",
"494546", "Mustin\ Lauenburg",
"498556", "Haidmühle",
"496557", "Hallschlag",
"4938376", "Zirchow",
"499102", "Wilhermsdorf",
"498547", "Osterhofen\-Gergweis",
"4938352", "Kemnitz\ bei\ Greifswald",
"494557", "Blunk",
"496092", "Heimbuchenthal",
"499631", "Tirschenreuth",
"4935930", "Seitschen",
"499533", "Untermerzbach",
"4933734", "Felgentreu",
"495665", "Guxhagen",
"495278", "Höxter\-Ovenhausen",
"495621", "Bad\ Wildungen",
"495523", "Bad\ Sachsa",
"4938483", "Brüel",
"4937369", "Wolkenstein",
"4936702", "Lauscha",
"497248", "Marxzell",
"4938852", "Wittenburg",
"492943", "Erwitte",
"499681", "Windischeschenbach",
"496508", "Hetzerath\ Mosel",
"495647", "Lichtenau\-Kleinenberg",
"498565", "Dietersburg\-Baumgarten",
"494705", "Wremen",
"498623", "Kirchweidach",
"495656", "Waldkappel",
"495199", "Schneverdingen\-Heber",
"4936943", "Bettenhausen\ Thüringen",
"4938876", "Roggendorf",
"495320", "Torfhaus",
"494508", "Krummesse",
"495636", "Lichtenfels\-Goddelsheim",
"4933969", "Stepenitz",
"499626", "Hohenburg",
"498586", "Hauzenberg",
"496587", "Zerf",
"498662", "Siegsdorf\ Kreis\ Traunstein",
"492461", "Jülich",
"492693", "Antweiler",
"499350", "Eussenheim\-Hundsbach",
"499409", "Pielenhofen",
"492425", "Nideggen\-Embken",
"492591", "Lüdinghausen",
"4938324", "Velgast",
"4939062", "Bebertal",
"497524", "Bad\ Waldsee",
"4933847", "Görzke",
"4939853", "Holzendorf\ bei\ Prenzlau",
"4933457", "Altreetz",
"4935797", "Schwepnitz",
"496333", "Waldfischbach\-Burgalben",
"499191", "Forchheim\ Oberfranken",
"495843", "Wustrow\ Wendland",
"499346", "Grünsfeld",
"496826", "Bexbach",
"495978", "Hörstel\-Dreierwalde",
"497948", "Öhringen\-Ohrnberg",
"4939241", "Leitzkau",
"4939978", "Gross\ Roge",
"498028", "Fischbachau",
"493335", "Finowfurt",
"4939200", "Gommern",
"494333", "Erfde",
"499357", "Gräfendorf\ Bayern",
"499448", "Hausen\ Niederbayern",
"4936257", "Luisenthal\ Thüringen",
"496580", "Zemmer",
"494826", "Hohenlockstedt",
"4934779", "Abberode",
"4936020", "Ebeleben",
"4935695", "Simmersdorf",
"496881", "Lebach",
"499364", "Zellingen",
"494353", "Ascheffel",
"498343", "Aitrang",
"4933208", "Fahrland",
"4935774", "Boxberg\ Sachsen",
"499337", "Gaukönigshofen",
"4933970", "Neustadt\ Dosse",
"495327", "Bad\ Grund\ Harz",
"492183", "Rommerskirchen",
"496353", "Freinsheim",
"4935266", "Heyda\ bei\ Riesa",
"496375", "Wallhalben",
"492274", "Elsdorf\ Rheinland",
"494881", "Friedrichstadt",
"497382", "Römerstein",
"495401", "Georgsmarienhütte",
"497835", "Zell\ am\ Harmersbach",
"499546", "Burgebrach",
"495859", "Thomasburg",
"492150", "Meerbusch\-Lank",
"496631", "Alsfeld",
"499092", "Wemding",
"496533", "Morbach\ Hunsrück",
"4939058", "Uthmöden",
"4938756", "Grabow",
"494102", "Ahrensburg",
"4937439", "Jocketa",
"494672", "Langenhorn",
"496672", "Eiterfeld",
"495674", "Grebenstein",
"4934263", "Hohburg",
"493535", "Herzberg\ Elster",
"498202", "Althegnenberg",
"494631", "Glücksburg\ Ostsee",
"494533", "Reinfeld\ Holstein",
"4933637", "Beerfelde",
"497644", "Kenzingen",
"497685", "Gutach\-Bleibach",
"496102", "Neu\-Isenburg",
"493573", "Senftenberg",
"493671", "Saalfeld\ Saale",
"4939773", "Altwarp",
"492921", "Soest",
"499564", "Bad\ Rodach",
"498543", "Aidenbach",
"4935208", "Radeburg",
"494349", "Dänischenhagen",
"498641", "Grassau\ Kreis\ Traunstein",
"494553", "Geschendorf",
"492066", "Duisburg\-Homberg",
"495527", "Duderstadt",
"49241", "Aachen",
"495839", "Wittingen\-Ohrdorf",
"493632", "Sondershausen",
"496651", "Rasdorf",
"496553", "Schönecken",
"496349", "Billigheim\-Ingenheim",
"499829", "Flachslanden",
"4936692", "Bürgel",
"496575", "Landscheid",
"497582", "Bad\ Buchau",
"497666", "Denzlingen",
"494778", "Wingst",
"499383", "Wiesentheid",
"492236", "Wesseling\ Rheinland",
"492137", "Neuss\-Norf",
"4935322", "Doberlug\-Kirchhain",
"494406", "Berne",
"496308", "Olsbrücken",
"4933984", "Blumenthal\ bei\ Pritzwalk",
"492164", "Jüchen\-Otzenrath",
"495293", "Paderborn\-Dahl",
"4938825", "Klütz",
"498321", "Sonthofen",
"498365", "Wertach",
"4939821", "Carpin",
"499851", "Dinkelsbühl",
"496629", "Schenklengsfeld",
"4936732", "Könitz",
"495520", "Braunlage",
"4933704", "Baruth\ Mark",
"4934600", "Ostrau\ Saalkreis",
"498407", "Grossmehring",
"4936427", "Dornburg\ Saale",
"497195", "Winnenden",
"496406", "Lollar",
"494308", "Schwedeneck",
"4937423", "Adorf\ Vogtland",
"499831", "Gunzenhausen",
"495865", "Gusborn",
"495821", "Bad\ Bevensen",
"4936483", "Ziegenrück",
"492247", "Neunkirchen\-Seelscheid",
"496387", "Sankt\ Julian",
"498386", "Oberstaufen",
"492391", "Plettenberg",
"4939927", "Nossentiner\ Hütte",
"499872", "Heilsbronn",
"492256", "Mechernich\-Satzvey",
"492157", "Nettetal\-Kaldenkirchen",
"495905", "Beesten",
"4936646", "Tanna\ bei\ Schleiz",
"4936376", "Straussfurt",
"497324", "Herbrechtingen",
"4934461", "Nebra\ Unstrut",
"499353", "Karlstadt",
"499549", "Lisberg",
"492751", "Bad\ Berleburg",
"494337", "Jevenstedt",
"499375", "Freudenberg\ Baden",
"4934977", "Quellendorf",
"494364", "Dahme\ Kreis\ Ostholstein",
"495362", "Wolfsburg\-Fallersleben",
"493928", "Schönebeck\ Elbe",
"496364", "Nussbach\ Pfalz",
"4937384", "Wechselburg",
"492265", "Reichshof\-Eckenhagen",
"4934293", "Naunhof\ bei\ Grimma",
"492678", "Büchel\ bei\ Cochem",
"498336", "Erkheim",
"496337", "Grossbundenbach",
"498823", "Mittenwald",
"492772", "Herborn\ Hessen",
"4939321", "Arneburg",
"494191", "Kaltenkirchen\ Holstein",
"496357", "Standenbühl",
"494346", "Gettorf",
"495836", "Wittingen\-Radenbeck",
"499333", "Sommerhausen",
"494357", "Sehestedt\ Eider",
"498458", "Gaimersheim",
"496346", "Annweiler\ am\ Trifels",
"498347", "Friesenried",
"495323", "Clausthal\-Zellerfeld",
"499826", "Weidenbach\ Mittelfranken",
"498291", "Zusmarshausen",
"4935822", "Hagenwerder",
"497669", "St\ Märgen",
"493377", "Zossen\ Brandenburg",
"498862", "Steingaden\ Oberbayern",
"4938325", "Rolofshagen",
"493496", "Köthen\ Anhalt",
"493682", "Zella\-Mehlis",
"492302", "Witten",
"494409", "Westerstede\-Ocholt",
"498340", "Baisweil",
"495205", "Bielefeld\-Sennestadt",
"4933238", "Senzke",
"495168", "Walsrode\-Stellichte",
"497532", "Meersburg",
"494626", "Treia",
"4935694", "Gosda\ bei\ Klinge",
"495643", "Borgentreich",
"495541", "Hann\.\ Münden",
"496626", "Wildeck\-Obersuhl",
"497673", "Schönau\ im\ Schwarzwald",
"492947", "Anröchte",
"497571", "Sigmaringen",
"496409", "Biebertal",
"497655", "Feldberg\-Altglashütten",
"493544", "Luckau\ Brandenburg",
"4935775", "Pechern",
"493585", "Löbau",
"498389", "Weissensberg",
"494681", "Wyk\ auf\ Föhr",
"495840", "Schnackenburg",
"498574", "Wittibreut",
"497635", "Schliengen",
"4935607", "Jänschwalde",
"496583", "Palzem",
"4934907", "Jeber\-Bergfrieden",
"496681", "Hilders",
"492697", "Blankenheim\-Ahrhütte",
"494330", "Emkendorf",
"497552", "Pfullendorf",
"4933767", "Friedersdorf\ bei\ Berlin",
"4934491", "Schmölln\ Thüringen",
"4939996", "Törpin",
"494166", "Ahlerstedt",
"499638", "Neualbenreuth",
"495271", "Höxter",
"494267", "Lauenbrück",
"494234", "Dörverden",
"497708", "Geisingen\-Leipferdingen",
"492404", "Alsdorf\ Rheinland",
"499222", "Presseck",
"497151", "Waiblingen",
"496234", "Mutterstadt",
"4936741", "Bad\ Blankenburg",
"492335", "Wetter\ Ruhr",
"4939744", "Rothenklempenow",
"495232", "Lage\ Lippe",
"498134", "Odelzhausen",
"495763", "Uchte",
"495309", "Lehre\-Wendhausen",
"496166", "Fischbachtal",
"498167", "Zolling",
"4935893", "Mücka",
"497505", "Fronreute",
"4934632", "Mücheln\ Geiseltal",
"4933743", "Blönsdorf",
"4935932", "Guttau",
"498266", "Kirchheim\ in\ Schwaben",
"496267", "Fahrenbach\ Baden",
"497131", "Heilbronn\ Neckar",
"496254", "Lautertal\ Odenwald",
"499420", "Feldkirchen\ Niederbayern",
"492355", "Schalksmühle",
"495252", "Bad\ Lippspringe",
"499771", "Bad\ Neustadt\ an\ der\ Saale",
"494185", "Marxen\ Auetal",
"492373", "Menden\ Sauerland",
"494144", "Himmelpforten",
"4939828", "Wustrow\ Kreis\ Mecklenburg\-Strelitz",
"4939395", "Wanzer",
"494724", "Cuxhaven\-Lüdingworth",
"499658", "Georgenberg",
"497172", "Lorch\ Württemberg",
"495722", "Bückeburg",
"496050", "Biebergemünd",
"499263", "Ludwigsstadt",
"499732", "Hammelburg",
"4938391", "Altenkirchen\ Rügen",
"496724", "Stromberg\ Hunsrück",
"494254", "Eystrup",
"4934222", "Arzberg\ bei\ Torgau",
"495142", "Eschede",
"498285", "Burtenbach",
"49511", "Hannover",
"496185", "Hammersbach\ Hessen",
"498809", "Wessobrunn",
"4934746", "Giersleben",
"496144", "Bischofsheim\ bei\ Rüsselsheim",
"4935473", "Neu\ Lübbenau",
"498056", "Eggstätt",
"496057", "Flörsbachtal",
"494462", "Wittmund",
"493943", "Wernigerode",
"492369", "Dorsten\-Wulfen",
"4939389", "Schollene",
"494858", "Sankt\ Margarethen\ Holstein",
"494945", "Grossefehn\-Timmel",
"4935386", "Prettin",
"496858", "Ottweiler\-Fürth",
"495437", "Menslage",
"499279", "Mistelgau",
"4935024", "Stadt\ Wehlen",
"499427", "Leiblfing",
"496462", "Gladenbach",
"496046", "Ortenberg\ Hessen",
"4935240", "Tauscha\ bei\ Grossenhain",
"496592", "Daun",
"495464", "Alfhausen",
"4935201", "Langebrück",
"495594", "Bovenden\-Reyershausen",
"495023", "Liebenau\ Kreis\ Nieburg\ Weser",
"496838", "Saarwellingen",
"495457", "Hopsten\-Schale",
"494423", "Fedderwarden",
"499976", "Rötz",
"493425", "Wurzen",
"493591", "Bautzen",
"493693", "Meiningen",
"4935363", "Fermerswalde",
"493461", "Merseburg\ Saale",
"499075", "Glött",
"498036", "Stephanskirchen\ Simssee",
"4937462", "Rothenkirchen\ Vogtland",
"4939051", "Calvörde",
"494260", "Visselhövede\-Wittorf",
"497476", "Bisingen",
"4934425", "Droyssig",
"497129", "Lichtenstein\ Württemberg",
"494838", "Tellingstedt",
"4938459", "Laage",
"495062", "Holle\ bei\ Hildesheim",
"495446", "Rehden",
"496423", "Wetter\ Hessen",
"496695", "Jesberg",
"494169", "Sauensiek",
"4938203", "Bad\ Doberan",
"498086", "Buchbach\ Oberbayern",
"496087", "Waldems",
"499963", "Konzell",
"497220", "Forbach\-Hundsbach",
"4933972", "Breddin",
"492624", "Höhr\-Grenzhausen",
"494954", "Moormerland",
"4934498", "Rositz",
"497024", "Wendlingen\ am\ Neckar",
"496888", "Lebach\-Steinbach",
"497463", "Mühlheim\ an\ der\ Donau",
"495952", "Sögel",
"4935052", "Kipsdorf\ Kurort",
"495306", "Cremlingen",
"499803", "Colmberg",
"4936623", "Berga\ Elster",
"498269", "Unteregg\ bei\ Mindelheim",
"499922", "Zwiesel",
"495932", "Haren\ Ems",
"498065", "Tuntenhausen\-Schönau",
"499170", "Schwanstetten",
"498021", "Waakirchen",
"499441", "Kelheim",
"4939365", "Bellingen\ bei\ Stendal",
"499083", "Möttingen",
"496008", "Echzell",
"499198", "Heiligenstadt\ in\ Oberfranken",
"4933231", "Pausin",
"4936022", "Grossengottern",
"497422", "Schramberg",
"494967", "Rhauderfehn\-Burlage",
"495971", "Rheine",
"494934", "Marienhafe",
"4939889", "Boitzenburg",
"4939202", "Gross\ Ammensleben",
"498806", "Utting\ am\ Ammersee",
"4934953", "Gräfenhainichen",
"497941", "Öhringen",
"4937295", "Lugau\ Erzgebirge",
"492366", "Herten\ Westfalen",
"4936785", "Gräfinau\-Angstedt",
"496135", "Bodenheim\ Rhein",
"497181", "Schorndorf\ Württemberg",
"499177", "Heideck",
"4938784", "Kleinow\ Kreis\ Prignitz",
"499276", "Bischofsgrün",
"494135", "Kirchgellersen",
"4939328", "Rochau",
"492852", "Hamminkeln",
"497764", "Herrischried",
"496049", "Kefenrod",
"4933433", "Buckow\ Märkische\ Schweiz",
"499607", "Luhe\-Wildenau",
"492598", "Senden\-Ottmarsbocholt",
"496284", "Mudau",
"494173", "Wulfsen",
"4939009", "Badel",
"493605", "Leinefelde",
"492385", "Hamm\-Rhynern",
"496245", "Biblis",
"498145", "Mammendorf",
"494155", "Büchen",
"495282", "Schieder\-Schwalenberg",
"492832", "Kevelaer",
"499392", "Faulbach\ Unterfranken",
"4938850", "Gammelin",
"498725", "Wurmannsquick",
"498761", "Moosburg\ an\ der\ Isar",
"494603", "Havetoft",
"494501", "Kastorf\ Holstein",
"497227", "Lichtenau\ Baden",
"498039", "Rott\ am\ Inn",
"492871", "Bocholt",
"4939405", "Hötensleben",
"495776", "Preussisch\ Ströhen",
"497126", "Burladingen\-Melchingen",
"496501", "Konz",
"496173", "Kronberg\ im\ Taunus",
"494284", "Selsingen",
"4939931", "Röbel\ Müritz",
"494245", "Neuenkirchen\ bei\ Bassum",
"496155", "Griesheim\ Hessen",
"498273", "Nordendorf",
"497746", "Wutöschingen",
"498043", "Jachenau",
"495027", "Linsburg",
"492566", "Legden",
"492682", "Hamm\ Sieg",
"493302", "Hennigsdorf",
"495433", "Badbergen",
"499423", "Geiselhöring",
"494976", "Spiekeroog",
"497082", "Neuenbürg\ Württemberg",
"495828", "Himbergen",
"4935433", "Vetschau",
"496053", "Wächtersbach",
"499260", "Wilhelmsthal\ Oberfranken",
"493947", "Thale",
"4939745", "Hetzdorf\ bei\ Strasburg",
"492585", "Warendorf\-Hoetmar",
"498179", "Eurasburg\ an\ der\ Loisach",
"499945", "Arnbruck",
"498426", "Walting\ Kreis\ Eichstätt",
"496427", "Cölbe\-Schönstadt",
"4939394", "Hohenberg\-Krusemark",
"499462", "Falkenstein\ Oberpfalz",
"496033", "Butzbach",
"4933393", "Gross\ Schönebeck\ Kreis\ Barnim",
"497802", "Oberkirch\ Baden",
"4937348", "Oberwiesenthal\ Kurort",
"4934602", "Landsberg\ Sachsen\-Anhalt",
"496301", "Otterbach\ Pfalz",
"497445", "Pfalzgrafenweiler",
"4937752", "Eibenstock",
"497484", "Simmersfeld",
"495453", "Recke",
"4936730", "Sitzendorf",
"495475", "Bohmte\-Hunteburg",
"498328", "Balderschwang",
"497962", "Fichtenau",
"496658", "Poppenhausen\ Wasserkuppe",
"495734", "Bergkirchen\ Westfalen",
"4939959", "Dargun",
"496263", "Neckargerach",
"4934672", "Rossleben",
"496732", "Wörrstadt",
"492192", "Hückeswagen",
"499724", "Stadtlauringen",
"4934342", "Neukieritzsch",
"4937608", "Waldenburg\ Sachsen",
"499185", "Mühlhausen\ Oberpfalz",
"494771", "Hemmoor",
"495767", "Warmsen",
"499144", "Pleinfeld",
"499254", "Gefrees",
"496420", "Lahntal",
"497393", "Munderkingen",
"495506", "Adelebsen",
"496771", "St\ Goarshausen",
"4939426", "Hessen",
"492928", "Soest\-Ostönnen",
"4933052", "Leegebruch",
"4934921", "Kemberg",
"4935025", "Liebstadt",
"494263", "Scheessel",
"4934656", "Wallhausen\ Sachsen\-Anhalt",
"494732", "Stadland\-Rodenkirchen",
"496222", "Wiesloch",
"499234", "Neusorg",
"495224", "Enger\ Westfalen",
"498122", "Erding",
"493772", "Schneeberg\ Erzgebirge",
"499166", "Münchsteinach",
"4936849", "Kleinschmalkalden",
"494638", "Tarp",
"4936459", "Blankenhain\ Thüringen",
"494752", "Neuhaus\ Oste",
"49871", "Landshut",
"499267", "Nordhalben",
"498742", "Velden\ Vils",
"496638", "Schwalmtal\-Renzendorf",
"4936651", "Lobenstein",
"495754", "Extertal\-Bremke",
"4936967", "Geisa",
"493731", "Freiberg\ Sachsen",
"496752", "Kirn\ Nahe",
"494222", "Ganderkesee",
"4934424", "Reuden\ bei\ Zeitz",
"4936926", "Creuzburg",
"492377", "Wickede\ Ruhr",
"4933653", "Ziltendorf",
"494392", "Nortorf\ bei\ Neumünster",
"4933473", "Zechin",
"4934327", "Waldheim\ Sachsen",
"499080", "Harburg\ Schwaben",
"499603", "Floss",
"499173", "Thalmässing",
"497733", "Engen\ Hegau",
"499155", "Simmelsdorf",
"497262", "Eppingen",
"499284", "Schwarzenbach\ an\ der\ Saale",
"4937207", "Hainichen\ Sachsen",
"4936203", "Vieselbach",
"499245", "Obertrubach",
"492824", "Kalkar",
"496392", "Hauenstein\ Pfalz",
"4933201", "Gross\ Glienicke",
"4939971", "Gnoien",
"498176", "Egling\ bei\ Wolfratshausen",
"493726", "Flöha",
"496276", "Hesseneck",
"4939248", "Dobritz",
"4939364", "Dolle",
"497578", "Wald\ Hohenz",
"4933363", "Altenhof\ Kreis\ Barnim",
"497223", "Bühl\ Baden",
"493391", "Neuruppin",
"4938233", "Prerow\ Ostseebad",
"4939087", "Jerchel\ Altmark",
"4937294", "Grünhainichen",
"495745", "Stemwede\-Levern",
"49202", "Wuppertal",
"4934383", "Trebsen\ Mulde",
"494607", "Janneby",
"496782", "Birkenfeld\ Nahe",
"497775", "Mühlingen",
"494177", "Drage\ Elbe",
"495161", "Walsrode",
"497753", "Albbruck",
"499135", "Hessdorf\ Mittelfranken",
"494276", "Borstel\ bei\ Sulingen",
"494441", "Vechta",
"492738", "Netphen",
"496198", "Eppstein",
"4936784", "Stützerbach",
"498074", "Schnaitsee",
"492652", "Mendig",
"497434", "Winterlingen",
"494922", "Borkum",
"497467", "Neuhausen\ ob\ Eck",
"4939039", "Bonese",
"492535", "Sendenhorst\-Albersloh",
"497052", "Bad\ Liebenzell",
"495509", "Rosdorf\ Kreis\ Göttingen",
"495924", "Bad\ Bentheim\-Gildehaus",
"496441", "Wetzlar",
"497305", "Erbach\ Donau",
"496083", "Weilrod",
"4935820", "Zodel",
"4938785", "Berge\ bei\ Perleberg",
"4933932", "Fehrbellin",
"497032", "Herrenberg",
"499954", "Simbach\ Niederbayern",
"493965", "Burow\ bei\ Altentreptow",
"492555", "Schöppingen",
"493921", "Burg\ bei\ Magdeburg",
"492671", "Cochem",
"492573", "Nordwalde",
"496803", "Mandelbachtal\-Ommersheim",
"492228", "Remagen\-Rolandseck",
"49341", "Leipzig",
"494963", "Dörpen",
"498431", "Neuburg\ an\ der\ Donau",
"499087", "Marktoffingen",
"492758", "Bad\ Berleburg\-Girkhausen",
"497071", "Tübingen",
"492632", "Andernach",
"497454", "Sulz\ am\ Neckar",
"4938229", "Bad\ Sülze",
"495483", "Lienen",
"4939404", "Ausleben",
"495041", "Springe\ Deister",
"494803", "Pahlen",
"498092", "Grafing\ bei\ München",
"497728", "Niedereschach",
"498546", "Windorf\-Otterskirchen",
"494556", "Ahrensbök\-Gnissau",
"492424", "Vettweiss",
"497148", "Grossbottwar",
"493576", "Weisswasser",
"495608", "Söhrewald",
"4939453", "Derenburg",
"497525", "Aulendorf",
"497663", "Eichstetten",
"497561", "Leutkirch\ im\ Allgäu",
"4938327", "Elmenhorst\ Vorpom",
"497258", "Oberderdingen\-Flehingen",
"495190", "Soltau\-Emmingen",
"4939382", "Kamern",
"499339", "Ippesheim",
"494547", "Gudow\ Lauenburg",
"499202", "Waischenfeld",
"496556", "Pronsfeld",
"498557", "Mauth",
"495329", "Schulenberg\ im\ Oberharz",
"4933454", "Wölsickendorf\/Wollenberg",
"4933844", "Brück\ Brandenburg",
"494704", "Drangstedt",
"498564", "Johanniskirchen",
"4939998", "Loitz\ bei\ Demmin",
"499359", "Karlstadt\-Wiesenfeld",
"499543", "Hirschaid",
"4938842", "Lüttenmark",
"499641", "Grafenwöhr",
"4938452", "Lalendorf",
"496536", "Kleinich",
"498537", "Bad\ Füssing\-Aigen",
"492983", "Winterberg\-Siedlinghausen",
"4934975", "Görzig\ Kreis\ Köthen",
"494536", "Steinhorst\ Lauenburg",
"497622", "Schopfheim",
"495702", "Petershagen\-Lahde",
"496704", "Langenlonsheim",
"498383", "Grünenbach\ Allgäu",
"4937360", "Olbernhau",
"496841", "Homburg\ Saar",
"497907", "Schwäbisch\ Hall\-Sulzdorf",
"495331", "Wolfenbüttel",
"4934639", "Wallendorf\ Luppe",
"4934785", "Sandersleben",
"499365", "Rimpar",
"492723", "Kirchhundem",
"4935939", "Hochkirch",
"499321", "Kitzingen",
"494841", "Husum\ Nordsee",
"49731", "Ulm\ Donau",
"498851", "Kochel\ am\ See",
"4936878", "Oberland",
"4933765", "Märkisch\ Buchholz",
"497834", "Wolfach",
"4935605", "Komptendorf",
"495372", "Meinersen",
"496589", "Kell\ am\ See",
"492253", "Bad\ Münstereifel",
"4934905", "Wörlitz",
"496374", "Weilerbach",
"499407", "Wenzenbach",
"492275", "Kerpen\-Buir",
"495197", "Soltau\-Frielingen",
"497854", "Kehl\-Goldscheuer",
"492762", "Wenden\ Südsauerland",
"499386", "Prosselsheim",
"495883", "Lemgow",
"492233", "Hürth\ Rheinland",
"494403", "Bad\ Zwischenahn",
"498550", "Philippsreut",
"496403", "Linden\ Hessen",
"49381", "Rostock",
"495351", "Helmstedt",
"4936254", "Friedrichswerth",
"493334", "Eberswalde",
"4936762", "Steinach\ Thüringen",
"499438", "Fensterbach",
"498549", "Vilshofen\-Pleinting",
"492174", "Burscheid\ Rheinland",
"494343", "Laboe",
"494559", "Wensin",
"495428", "Melle\-Neuenkirchen",
"498375", "Weitnau",
"492604", "Nassau\ Lahn",
"4934741", "Frose",
"4933604", "Lebus",
"497938", "Mulfingen\ Jagst",
"495650", "Cornberg",
"4939603", "Burg\ Stargard",
"499336", "Bütthard",
"495833", "Brome",
"496559", "Leidenborn",
"496343", "Bad\ Bergzabern",
"499823", "Leutershausen",
"495326", "Langelsheim",
"4936378", "Ostramondra",
"496028", "Sulzbach\ am\ Main",
"497958", "Rot\ Am\ See\-Brettheim",
"495853", "Neu\ Darchau",
"499356", "Burgsinn",
"495875", "Emmendorf",
"494827", "Wacken",
"4936648", "Dittersdorf\ bei\ Schleiz",
"499347", "Wittighausen",
"4939002", "Oebisfelde",
"498333", "Babenhausen\ Schwaben",
"494539", "Westerau",
"4933635", "Arensdorf\ Kreis\ Oder\-Spree",
"496827", "Eppelborn",
"495381", "Seesen",
"497402", "Fluorn\-Winzeln",
"494662", "Leck",
"499340", "Königheim\-Brehmen",
"493522", "Grossenhain\ Sachsen",
"4935455", "Walddrehna",
"4933979", "Wusterhausen\ Dosse",
"499627", "Freudenberg\ Oberpfalz",
"4939925", "Wredenhagen",
"492933", "Sundern\ Sauerland",
"496586", "Beuren\ Hochwald",
"495664", "Morschen",
"4939056", "Klüden",
"4938758", "Dömitz",
"4933674", "Trebatsch",
"4939343", "Jerichow",
"495657", "Meissner",
"4936029", "Menteroda",
"494521", "Eutin",
"4938827", "Kalkhorst",
"494495", "Friesoythe\-Thüle",
"494623", "Böklund",
"498705", "Altfraunhofen",
"493493", "Bitterfeld",
"4939882", "Gollin",
"4938424", "Bobitz",
"4939209", "Wanzleben",
"493563", "Spremberg",
"492953", "Wünnenberg",
"493661", "Greiz",
"492975", "Schmallenberg\-Oberkirchen",
"499574", "Marktzeuln",
"4935206", "Kreischa\ bei\ Dresden",
"497676", "Feldberg\ Schwarzwald",
"4936425", "Isserstedt",
"494768", "Hipstedt",
"495646", "Willebadessen",
"496623", "Rotenburg\ an\ der\ Fulda",
"496565", "Dudeldorf",
"492257", "Reckerscheid",
"4937323", "Lichtenberg\ Erzgebirge",
"492156", "Willich\-Anrath",
"499403", "Donaustauf",
"4939976", "Gross\ Bützin",
"493322", "Falkensee",
"4934203", "Zwenkau",
"497903", "Mainhardt",
"4933845", "Borkheide",
"4939952", "Grammentin",
"4935795", "Königsbrück",
"492246", "Lohmar\ Rheinland",
"498387", "Weiler\-Simmerberg",
"494488", "Westerstede",
"496386", "Altenkirchen\ Pfalz",
"495808", "Gerdau",
"494365", "Heringsdorf\ Holstein",
"497822", "Ettenheim",
"494321", "Neumünster",
"498629", "Palling",
"4934361", "Dahlen\ Sachsen",
"4935268", "Stauchitz",
"499374", "Eschau",
"498406", "Böhmfeld",
"496407", "Rabenau\ Hessen",
"494796", "Teufelsmoor",
"492237", "Kerpen\ Rheinland\-Türnich",
"4933206", "Fichtenwalde",
"4937430", "Eichigt",
"494407", "Wardenburg",
"4936842", "Oberhof\ Thüringen",
"499841", "Bad\ Windsheim",
"495193", "Schneverdingen",
"4936452", "Berlstedt",
"497660", "St\ Peter\ Schwarzwald",
"492264", "Marienheide",
"496321", "Neustadt\ an\ der\ Weinstrasse",
"498651", "Bad\ Reichenhall",
"494543", "Nusse",
"494641", "Süderbrarup",
"498553", "Spiegelau",
"498349", "Stötten\ am\ Auerberg",
"497634", "Sulzburg",
"492452", "Heinsberg\ Rheinland",
"497667", "Breisach\ am\ Rhein",
"493379", "Mahlow",
"499704", "Euerdorf",
"4934904", "Oranienbaum",
"4935604", "Krieschow",
"496543", "Büchenbeuren",
"496359", "Grünstadt",
"496641", "Lauterbach\ Hessen",
"496400", "Mücke",
"4933764", "Mittenwalde\ Mark",
"499536", "Kirchlauter",
"492054", "Essen\-Kettwig",
"4934609", "Salzmünde",
"492471", "Roetgen\ Eifel",
"496339", "Grosssteinhausen",
"499556", "Geiselwind",
"496202", "Schwetzingen",
"495849", "Waddeweitz",
"49361", "Erfurt",
"498102", "Höhenkirchen\-Siegertsbrunn",
"498380", "Achberg",
"495204", "Steinhagen\ Westfalen",
"498631", "Mühldorf\ am\ Inn",
"494339", "Christiansholm",
"498533", "Rotthalmünster",
"499547", "Zapfendorf",
"496215", "Ludwigshafen",
"494202", "Achim\ bei\ Bremen",
"4936255", "Goldbach\ bei\ Gotha",
"497654", "Löffingen",
"4935697", "Bagenz",
"492432", "Wassenberg",
"495683", "Wabern\ Hessen",
"498583", "Neureichenau",
"492937", "Arnsberg\-Oeventrop",
"498681", "Waging\ am\ See",
"492482", "Hellenthal",
"495850", "Neetze",
"492696", "Nohn\ Eifel",
"492159", "Meerbusch\-Osterath",
"495531", "Holzminden",
"495633", "Diemelsee",
"499521", "Hassfurt",
"499495", "Breitenbrunn\ Oberpfalz",
"492964", "Brilon\-Alme",
"499565", "Untersiemau",
"497542", "Tettnang",
"49751", "Ravensburg",
"4939223", "Theessen",
"495572", "Bodenfelde",
"4933605", "Boossen",
"498330", "Legau",
"492804", "Xanten\-Marienbaum",
"496574", "Hasborn",
"4939032", "Mahlsdorf\ bei\ Salzwedel",
"497203", "Walzbachtal",
"492045", "Bottrop\-Kirchhellen",
"496627", "Nentershausen\ Hessen",
"499662", "Vilseck",
"4938222", "Semlow",
"49760", "Oberried\ Breisgau",
"494340", "Achterwehr",
"492957", "Wünnenberg\-Haaren",
"4938378", "Heringsdorf\ Seebad",
"499820", "Lehrberg",
"495105", "Barsinghausen",
"4936602", "Ronneburg\ Thüringen",
"497645", "Freiamt",
"496340", "Wörth\-Schaidt",
"497684", "Glottertal",
"495551", "Northeim",
"495653", "Sontra",
"4933634", "Berkenbrück\ Kreis\ Oder\-Spree",
"495675", "Trendelburg",
"494627", "Dörpstedt",
"496458", "Rosenthal\ Hessen",
"498191", "Landsberg\ am\ Lech",
"494356", "Gross\ Wittensee",
"498346", "Pforzen",
"496347", "Hochstadt\ Pfalz",
"495837", "Sprakensehl",
"494902", "Jemgum\-Ditzum",
"4938308", "Göhren\ Rügen",
"499827", "Lichtenau\ Mittelfranken",
"496291", "Adelsheim",
"495864", "Jameln",
"497361", "Aalen",
"494862", "Garding",
"497325", "Sontheim\ an\ der\ Brenz",
"496620", "Philippsthal\ Werra",
"4936921", "Wutha\-Farnroda",
"4939924", "Stuer",
"496356", "Carlsberg\ Pfalz",
"494458", "Wiefelstede\-Spohle",
"494347", "Flintbek",
"4933923", "Flecken\ Zechlin",
"4935844", "Oybin\ Kurort",
"4935454", "Uckro",
"495529", "Rhumspringe",
"495904", "Lengerich\ Emsl",
"492165", "Jüchen",
"4938425", "Kirchdorf\ Poel",
"498364", "Seeg",
"496336", "Dellfeld",
"498337", "Altenstadt\ Iller",
"492741", "Betzdorf",
"493901", "Salzwedel",
"4935728", "Uhyst\ Spree",
"499343", "Lauda\-Königshofen",
"495846", "Gartow\ Niedersachsen",
"4938792", "Lenzen\ \(Elbe\)",
"492208", "Niederkassel",
"4933675", "Tauche",
"4935951", "Neukirch\ Lausitz",
"496438", "Hünfelden",
"494336", "Owschlag",
"495857", "Bleckede\-Brackede",
"4934651", "Rossla",
"494823", "Wilster",
"497194", "Spiegelberg",
"4936424", "Kahla\ Thüringen",
"4939421", "Osterwieck",
"493861", "Plate",
"4936338", "Bleicherode",
"4934926", "Pretzsch\ Elbe",
"4936783", "Gehren\ Thüringen",
"492429", "Hürtgenwald",
"499405", "Bad\ Abbach",
"494322", "Bordesholm",
"497821", "Lahr\ Schwarzwald",
"493386", "Premnitz",
"492606", "Winningen\ Mosel",
"4939932", "Malchow\ bei\ Waren",
"499367", "Unterpleichfeld",
"497905", "Langenburg",
"4933435", "Rehfelde",
"495324", "Vienenburg",
"49981", "Ansbach",
"499842", "Uffenheim",
"496322", "Bad\ Dürkheim",
"499334", "Giebelstadt",
"494363", "Lensahn",
"4935828", "Reichenbach\ OL",
"499354", "Rieneck",
"493321", "Nauen\ Brandenburg",
"498824", "Oberau\ Loisach",
"49209", "Gelsenkirchen",
"496363", "Niederkirchen",
"496709", "Fürfeld\ Kreis\ Bad\ Kreuznach",
"4939403", "Gröningen\ Sachsen\-Anhalt",
"497520", "Bodnegg",
"4936766", "Schalkau",
"495195", "Neuenkirchen\ bei\ Soltau",
"498573", "Ering",
"498671", "Altötting",
"4933474", "Neutrebbin",
"494545", "Seedorf\ Lauenburg",
"498555", "Perlesreut",
"496128", "Taunusstein",
"492472", "Monschau",
"4935389", "Holzdorf\ Elster",
"496201", "Weinheim\ Bergstr",
"493641", "Jena",
"4933877", "Nitzahn",
"497527", "Wolfegg",
"4938205", "Tessin\ bei\ Rostock",
"4939201", "Wolmirstedt",
"4936204", "Stotternheim",
"497839", "Schapbach",
"492431", "Erkelenz",
"4936625", "Langenwetzendorf",
"494748", "Stubben\ bei\ Bremerhaven",
"4936021", "Schlotheim",
"4933232", "Brieselang",
"495582", "Sankt\ Andreasberg",
"496545", "Blankenrath",
"494128", "Kollmar",
"4939386", "Seehausen\ Altmark",
"496584", "Wellen\ Mosel",
"4933087", "Bredereiche",
"494642", "Kappeln\ Schlei",
"49461", "Flensburg",
"498652", "Berchtesgaden",
"492451", "Geilenkirchen",
"493991", "Waren\ Müritz",
"499360", "Thüngen",
"4939363", "Angern",
"4933364", "Gross\ Ziethen\ Kreis\ Barnim",
"499576", "Lichtenfels\-Isling",
"4938456", "Langhagen\ bei\ Güstrow",
"4933971", "Kyritz\ Brandenburg",
"4938234", "Born\ Darss",
"4937293", "Eppendorf\ Sachsen",
"4934955", "Gossa",
"4934384", "Grossbothen",
"498535", "Haarbach",
"497674", "Todtmoos",
"496642", "Schlitz",
"49661", "Fulda",
"495685", "Knüllwald",
"495644", "Willebadessen\-Peckelsheim",
"492426", "Nörvenich",
"498585", "Grainet",
"494554", "Wahlstedt",
"498544", "Eging\ am\ See",
"499493", "Beratzhausen",
"499625", "Kastl\ bei\ Amberg",
"499563", "Rödental",
"499661", "Sulzbach\-Rosenberg",
"495635", "Vöhl",
"493574", "Lauchhammer",
"4935475", "Straupitz",
"4939863", "Seehausen\ bei\ Prenzlau",
"4939052", "Erxleben\ bei\ Haldensleben",
"495552", "Katlenburg",
"496554", "Waxweiler",
"496567", "Oberkail",
"494706", "Schiffdorf",
"498682", "Laufen\ Salzach",
"492043", "Gladbeck",
"4935365", "Falkenberg\ Elster",
"495532", "Stadtoldendorf",
"498370", "Wiggensbach",
"496534", "Mülheim\ Mosel",
"499522", "Eltmann",
"4939886", "Milmersdorf",
"497643", "Herbolzheim\ Breisgau",
"492977", "Schmallenberg\-Bödefeld",
"497541", "Friedrichshafen",
"4935202", "Klingenberg\ Sachsen",
"495103", "Wennigsen\ Deister",
"494534", "Steinburg\ Kreis\ Storman",
"495673", "Immenhausen\ Hessen",
"4937600", "Neumark\ Sachsen",
"498707", "Adlkofen",
"495571", "Uslar",
"496706", "Wallhausen\ Nahe",
"4934423", "Heuckewalde",
"494497", "Barssel\-Harkebrügge",
"495655", "Wanfried",
"4933654", "Fünfeichen",
"496478", "Greifenstein\-Ulm",
"492742", "Wissen",
"493902", "Diesdorf\ Altm",
"49271", "Siegen",
"4936738", "Königsee",
"4933745", "Petkus",
"497836", "Schiltach",
"4934221", "Schildau\ Gneisenaustadt",
"497323", "Gerstetten",
"4935895", "Klitten",
"498377", "Unterthingau",
"494478", "Cappeln\ Oldenburg",
"4935434", "Altdöbern",
"4938392", "Sassnitz",
"495294", "Hövelhof\-Espeln",
"498192", "Schondorf\ am\ Ammersee",
"496292", "Seckach",
"4939393", "Werben\ Elbe",
"492163", "Schwalmtal\ Niederrhein",
"496825", "Illingen\ Saar",
"496861", "Merzig",
"4933394", "Blumberg\ Kreis\ Barnim",
"499384", "Schwanfeld",
"499345", "Külsheim\ Baden",
"494825", "Burg\ Dithmarschen",
"494861", "Tönning",
"497362", "Bopfingen",
"4935931", "Königswartha",
"4939006", "Miesterhorst",
"4936742", "Uhlstädt",
"494292", "Ritterhude",
"492065", "Duisburg\-Rheinhausen",
"495158", "Hemeringen",
"492694", "Wershofen",
"499642", "Kemnath\ Stadt",
"49961", "Weiden\ in\ der\ Oberpfalz",
"4938783", "Dallmin",
"497621", "Lörrach",
"4933837", "Brielow",
"497665", "March\ Breisgau",
"4933434", "Herzfelde\ bei\ Strausberg",
"4938858", "Lassahn",
"495248", "Langenberg\ Kreis\ Gütersloh",
"498624", "Obing",
"498091", "Kirchseeon",
"4939320", "Schinne",
"4938727", "Mestlin",
"492944", "Rietberg\-Mastholte",
"499545", "Buttenheim",
"492985", "Winterberg\-Niedersfeld",
"497562", "Isny\ im\ Allgäu",
"495138", "Sehnde",
"499128", "Feucht",
"4933931", "Rheinsberg\ Mark",
"499201", "Gesees",
"492269", "Kierspe\-Rönsahl",
"499748", "Motten",
"4938204", "Broderstorf",
"498344", "Westendorf\ bei\ Kaufbeuren",
"494354", "Fleckeby",
"498385", "Hergatz",
"4934659", "Blankenheim\ bei\ Sangerhausen",
"499363", "Arnstein\ Unterfranken",
"492725", "Lennestadt\-Oedingen",
"4939972", "Walkendorf",
"492761", "Olpe\ Biggesee",
"4933475", "Letschin",
"4939956", "Neukalen",
"492528", "Ennigerloh\-Enniger",
"495352", "Schöningen",
"493841", "Wismar",
"4936624", "Teichwolframsdorf",
"495906", "Lünne",
"492273", "Kerpen\-Horrem",
"4936205", "Gräfenroda",
"492255", "Euskirchen\-Flamersheim",
"4938297", "Moitin",
"498366", "Oy\-Mittelberg",
"4933365", "Lüdersdorf\ Kreis\ Barnim",
"495332", "Schöppenstedt",
"49681", "Saarbrücken",
"496842", "Blieskastel",
"495209", "Gütersloh\-Friedrichsdorf",
"494405", "Edewecht",
"4936929", "Ruhla",
"496334", "Thaleischweiler\-Fröschen",
"495844", "Clenze",
"492235", "Erftstadt",
"49481", "Heide\ Holstein",
"494842", "Nordstrand",
"496405", "Laubach\ Hessen",
"494334", "Bredenbek\ bei\ Rendsburg",
"4933202", "Töplitz",
"495371", "Gifhorn",
"494367", "Grossenbrode",
"498468", "Altmannstein\-Pondorf",
"4934385", "Mutzschen",
"4934954", "Roitzsch\ bei\ Bitterfeld",
"4936846", "Suhl\-Dietzhausen",
"4935474", "Schönwalde\ bei\ Lübben",
"492154", "Willich",
"498373", "Altusried",
"494384", "Selent",
"499901", "Hengersberg\ Bayern",
"497327", "Dischingen",
"4935877", "Cunewalde",
"499292", "Konradsreuth",
"4935023", "Bad\ Gottleuba",
"499825", "Herrieden",
"4936652", "Wurzbach",
"495382", "Bad\ Gandersheim",
"499861", "Rothenburg\ ob\ der\ Tauber",
"496384", "Konken",
"495835", "Wahrenholz",
"492244", "Königswinter\-Oberpleis",
"496345", "Albersweiler",
"497843", "Renchen",
"4934341", "Geithain",
"499560", "Grub\ am\ Forst",
"498404", "Oberdolling",
"499376", "Collenberg",
"495873", "Eimke",
"4935364", "Lebusa",
"4935248", "Schönfeld\ bei\ Grossenhain",
"4938796", "Viesecke",
"494794", "Worpswede\-Ostersode",
"4934671", "Bad\ Frankenhausen\ Kyffhäuser",
"495855", "Nahrendorf",
"4935971", "Sebnitz",
"495948", "Itterbeck",
"4933655", "Grunow\ Kreis\ Oder\-Spree",
"498335", "Fellheim",
"492266", "Lindlar",
"4933051", "Nassenheide",
"4934922", "Mühlanger",
"497636", "Münstertal\ Schwarzwald",
"494522", "Plön",
"493586", "Neugersdorf\ Sachsen",
"499567", "Sesslach\-Gemünda",
"499497", "Seubersdorf\ in\ der\ Oberpfalz",
"4939743", "Zerrenthin",
"4935435", "Gollmitz\ bei\ Calau",
"4939820", "Triepkendorf",
"4935894", "Hähnichen",
"4934601", "Teutschenthal",
"4939036", "Binde",
"4938738", "Karow\ bei\ Lübz",
"495909", "Wettrup",
"495524", "Bad\ Lauterberg\ im\ Harz",
"4939488", "Güntersberge",
"492935", "Sundern\-Hachen",
"499534", "Burgpreppach",
"4933744", "Hohenseefeld",
"496522", "Mettendorf",
"494493", "Friesoythe\-Gehlenberg",
"494625", "Jübek",
"494563", "Scharbeutz\-Haffkrug",
"495677", "Calden\-Westuffeln",
"498703", "Essenbach",
"494661", "Niebüll",
"498369", "Rückholz",
"492056", "Heiligenhaus",
"4933337", "Altkünkendorf",
"4933395", "Zerpenschleuse",
"495206", "Bielefeld\-Jöllenbeck",
"492973", "Eslohe\ Sauerland",
"493521", "Meissen",
"493623", "Friedrichroda",
"499554", "Untersteinbach\ Unterfranken",
"492955", "Büren\-Wewelsburg",
"4938226", "Dierhagen\ Ostseebad",
"497656", "Schluchsee",
"4936606", "Kraftsdorf",
"49375", "Zwickau",
"496625", "Niederaula",
"496563", "Kyllburg",
"496661", "Schlüchtern",
"492626", "Selters\ Westerwald",
"4939881", "Ringenwalde\ bei\ Templin",
"493976", "Torgelow\ bei\ Ueckermünde",
"498084", "Taufkirchen\ Vils",
"498045", "Lenggries\-Fall",
"492409", "Stolberg\-Gressenich",
"4936330", "Grossberndten",
"4933239", "Gross\ Behnitz",
"499461", "Roding",
"494239", "Dörverden\-Westen",
"495435", "Berge\ bei\ Quakenbrück",
"494956", "Uplengen",
"494180", "Königsmoor",
"494302", "Kirchbarkau",
"495304", "Meine",
"498139", "Röhrmoos",
"496239", "Bobenheim\-Roxheim",
"497026", "Lenningen",
"494947", "Aurich\-Ogenbargen",
"4939923", "Priborn",
"496302", "Winnweiler",
"4933924", "Rägelin",
"496073", "Babenhausen\ Hessen",
"4935843", "Hirschfelde\ bei\ Zittau",
"497961", "Ellwangen\ Jagst",
"4935453", "Drahnsdorf",
"496055", "Freigericht",
"494149", "Fredenbeck",
"496697", "Willingshausen",
"492681", "Altenkirchen\ Westerwald",
"493301", "Oranienburg",
"492583", "Sassenberg",
"499943", "Lam\ Oberpfalz",
"4939345", "Parchen",
"4936074", "Worbis",
"496035", "Reichelsheim\ Wetterau",
"499077", "Bachhagel",
"497443", "Dornstetten",
"497081", "Bad\ Wildbad",
"4938300", "Insel\ Hiddensee",
"4936423", "Orlamünde",
"492330", "Herdecke",
"495473", "Ostercappeln",
"495455", "Tecklenburg\-Brochterbeck",
"498249", "Ettringen\ Wertach",
"494936", "Grossheide",
"496678", "Wildeck\-Hönebach",
"496265", "Billigheim\ Baden",
"4939777", "Borkenfriede",
"496221", "Heidelberg",
"4938370", "Kröslin",
"492364", "Haltern\ Westfalen",
"493771", "Aue\ Sachsen",
"498121", "Markt\ Schwaben",
"499070", "Tapfheim",
"498165", "Neufahrn\ bei\ Freising",
"499183", "Burgthann",
"498208", "Eurasburg\ bei\ Augsburg",
"498741", "Vilsbiburg",
"492337", "Hagen\-Dahl",
"494751", "Otterndorf",
"496108", "Mühlheim\ am\ Main",
"499274", "Hollfeld",
"4939224", "Büden",
"496751", "Bad\ Sobernheim",
"494108", "Rosengarten\ Kreis\ Harburg",
"497395", "Ehingen\-Dächingen",
"4939605", "Gross\ Nemerow",
"4935936", "Sohland\ Spree",
"494265", "Fintel",
"4934636", "Schafstädt",
"4939001", "Apenburg",
"494221", "Delmenhorst",
"496187", "Schöneck",
"496286", "Walldürn\-Rippberg",
"496731", "Alzey",
"492191", "Remscheid",
"496893", "Saarbrücken\-Ensheim",
"494772", "Oberndorf\ Oste",
"494893", "Hohenaspe",
"495774", "Wagenfeld\-Ströhen",
"497124", "Trochtelfingen\ Hohenz",
"496772", "Nastätten",
"4934742", "Sylda",
"497744", "Stühlingen",
"494187", "Holm\-Seppensen",
"4933633", "Spreenhagen",
"492448", "Hellenthal\-Rescheid",
"494286", "Gyhum",
"494731", "Nordenham",
"492357", "Herscheid\ Westfalen",
"499605", "Weiherhammer",
"4934783", "Gerbstedt",
"494164", "Harsefeld",
"497735", "Öhningen",
"492406", "Herzogenrath",
"499153", "Schnaittach",
"494137", "Barendorf",
"499175", "Spalt",
"494236", "Kirchlinteln",
"494959", "Dollart",
"492308", "Unna\-Hemmerde",
"498136", "Markt\ Indersdorf",
"498237", "Aindling",
"4934903", "Coswig\ Anhalt",
"496781", "Idar\-Oberstein",
"496236", "Neuhofen\ Pfalz",
"4935603", "Burg\ Spreewald",
"4936761", "Heubisch",
"499243", "Pottenstein",
"495162", "Fallingbostel",
"4933763", "Bestensee",
"496164", "Reichelsheim\ Odenwald",
"494146", "Stade\-Bützfleth",
"496157", "Pfungstadt",
"498257", "Inchenhofen",
"499502", "Frensdorf",
"496256", "Lampertheim\-Hüttenfeld",
"494247", "Affinghausen",
"497558", "Illmensee",
"497261", "Sinsheim",
"497225", "Gaggenau",
"498727", "Falkenberg\ Niederbayern",
"496726", "Lorch\ Rheingau",
"495743", "Espelkamp\-Gestringen",
"497755", "Weilheim\ Kreis\ Waldshut",
"499133", "Baiersdorf\ Mittelfranken",
"496146", "Hochheim\ am\ Main",
"496391", "Dahn",
"494256", "Hilgermissen",
"492387", "Drensteinfurt\-Walstedde",
"495123", "Schellerten",
"498246", "Waal",
"497773", "Bodman\-Ludwigshafen",
"496247", "Worms\-Pfeddersheim",
"494939", "Baltrum",
"4938451", "Hoppenrade\ bei\ Güstrow",
"495368", "Parsau",
"4933976", "Wutike",
"497031", "Böblingen",
"4938841", "Neuhaus\ Elbe",
"4937324", "Reinsberg\ Sachsen",
"498054", "Breitbrunn\ am\ Chiemsee",
"4937438", "Bad\ Brambach",
"492672", "Treis\-Karden",
"493441", "Zeitz",
"492102", "Ratingen",
"4939059", "Wegenstedt",
"498250", "Hilgertshausen\-Tandern",
"4934204", "Schkeuditz",
"494240", "Syke\-Heiligenfelde",
"497072", "Gomaringen",
"498432", "Burgheim",
"4935056", "Altenberg\ Sachsen",
"492533", "Münster\-Nienberge",
"492631", "Neuwied",
"496150", "Weiterstadt",
"495466", "Merzen",
"495042", "Bad\ Münder\ am\ Deister",
"496044", "Schotten\ Hessen",
"497303", "Illertissen",
"496085", "Waldsolms",
"4939455", "Schierke",
"498230", "Gablingen",
"4934973", "Osternienburg",
"499974", "Traitsching",
"492575", "Greven\-Reckenfeld",
"498452", "Geisenfeld",
"49441", "Oldenburg",
"496805", "Kleinblittersdorf",
"494442", "Lohne\ Oldenburg",
"493963", "Woldegk",
"4935209", "Mohorn",
"492553", "Ochtrup",
"492651", "Mayen",
"496130", "Schwabenheim\ an\ der\ Selz",
"494965", "Surwold",
"494921", "Emden\ Stadt",
"498868", "Schwabsoien",
"4935343", "Hirschfeld\ bei\ Elsterwerda",
"492778", "Siegbach",
"4934297", "Liebertwolkwitz",
"497051", "Calw",
"4936026", "Struth\ bei\ Mühlhausen",
"498034", "Brannenburg",
"497474", "Haigerloch",
"49641", "Giessen",
"496442", "Braunfels",
"498067", "Tuntenhausen",
"496066", "Michelstadt\-Vielbrunn",
"494805", "Schafstedt",
"4939206", "Eichenbarleben",
"495485", "Ladbergen",
"494289", "Kirchtimke",
"495444", "Wagenfeld",
"497132", "Neckarsulm",
"4938791", "Bad\ Wilsnack",
"495251", "Paderborn",
"499772", "Bischofsheim\ an\ der\ Rhön",
"4934346", "Narsdorf",
"4933056", "Mühlenbeck\ Kreis\ Oberhavel",
"497171", "Schwäbisch\ Gmünd",
"495721", "Stadthagen",
"499187", "Altdorf\ bei\ Nürnberg",
"495765", "Raddestorf",
"4939422", "Badersleben",
"492826", "Kranenburg\ Niederrhein",
"4933925", "Wustrau\-Altfriesack",
"499286", "Oberkotzau",
"492333", "Ennepetal",
"4934652", "Allstedt",
"495141", "Celle",
"4935952", "Grossröhrsdorf\ OL",
"497503", "Wilhelmsdorf\ Württemberg",
"497440", "Bad\ Rippoldsau",
"496274", "Waldbrunn\ Odenwald",
"494183", "Jesteburg",
"4936075", "Dingelstädt\ Eichsfeld",
"4933673", "Weichensdorf",
"4939344", "Güsen",
"4939268", "Egeln",
"492375", "Balve",
"495272", "Brakel\ Westfalen",
"492353", "Halver",
"493724", "Burgstädt",
"4933209", "Caputh",
"4938423", "Bad\ Kleinen",
"49721", "Karlsruhe",
"4938750", "Malliss",
"497242", "Rheinstetten",
"499265", "Pressig",
"496897", "Sulzbach\ Saar",
"497152", "Leonberg\ Württemberg",
"499221", "Kulmbach",
"495231", "Detmold",
"496183", "Erlensee",
"494274", "Varrel\ bei\ Sulingen",
"4936922", "Gerstungen",
"498283", "Neuburg\ an\ der\ Kammel",
"493984", "Prenzlau",
"498076", "Pfaffing",
"499729", "Grettstadt",
"497436", "Messstetten\-Oberdigisheim",
"4938221", "Marlow",
"493462", "Bad\ Dürrenberg",
"499149", "Weissenburg\-Suffersheim",
"493592", "Kirschau",
"494943", "Grossefehn",
"495926", "Engden",
"49212", "Solingen",
"4936370", "Grossenehrich",
"492508", "Drensteinfurt",
"499936", "Wallerfing",
"4933603", "Falkenhagen\ bei\ Seelow",
"4939604", "Wildberg\ bei\ Altentreptow",
"4936601", "Hermsdorf\ Thüringen",
"495025", "Estorf\ Weser",
"4936640", "Remptendorf",
"4939225", "Altengrabow",
"494425", "Wangerland\-Hooksiel",
"494461", "Jever",
"499956", "Eichendorf\-Aufhausen",
"499180", "Pyrbaum",
"499302", "Rottendorf\ Unterfranken",
"497358", "Eberhardzell\-Füramoos",
"499073", "Gundelfingen\ an\ der\ Donau",
"497447", "Baiersbronn\-Schwarzenberg",
"4933968", "Meyenburg\ Kreis\ Prignitz",
"493423", "Eilenburg",
"493695", "Bad\ Salzungen",
"493838", "Bergen\ auf\ Rügen",
"4937756", "Breitenbrunn\ Erzgebirge",
"497456", "Haiterbach",
"4934606", "Teicha\ Sachsen\-Anhalt",
"4939031", "Dähre",
"496591", "Gerolstein",
"496425", "Rauschenberg\ Hessen",
"496693", "Neuental",
"496461", "Biedenkopf",
"499947", "Neukirchen\ bei\ Hl\ Blut",
"492587", "Ennigerloh\-Westkirchen",
"499965", "Sankt\ Englmar",
"492564", "Vreden",
"499921", "Regen",
"498022", "Tegernsee",
"495931", "Meppen",
"497307", "Senden\ Iller",
"494974", "Neuharlingersiel",
"49941", "Regensburg",
"499442", "Riedenburg",
"4935032", "Langenhennersdorf",
"499805", "Burgoberbach",
"499289", "Schwarzenbach\ am\ Wald",
"497465", "Emmingen\-Liptingen",
"497942", "Neuenstein\ Württemberg",
"49791", "Schwäbisch\ Hall",
"498063", "Feldkirchen\-Westerham",
"4939298", "Barby\ Elbe",
"498424", "Nassenfels",
"4936870", "Masserberg",
"492546", "Coesfeld\-Lette",
"497388", "Pfronstetten",
"499085", "Alerheim",
"497486", "Horb\-Altheim",
"4937368", "Deutschneudorf",
"495951", "Werlte",
"4936253", "Georgenthal\ Thüringer\ Wald",
"493967", "Oertzenhof\ bei\ Strasburg",
"492557", "Wettringen\ Kreis\ Steinfurt",
"499726", "Euerbach",
"492831", "Geldern",
"495281", "Bad\ Pyrmont",
"496133", "Oppenheim",
"499146", "Markt\ Berolzheim",
"4937325", "Niederbobritzsch",
"499391", "Marktheidenfeld",
"494502", "Lübeck\-Travemünde",
"4934362", "Mügeln\ bei\ Oschatz",
"498762", "Wartenberg\ Oberbayern",
"498233", "Kissing",
"4939454", "Elbingerode\ Harz",
"494133", "Wittorf\ Kreis\ Lüneburg",
"495504", "Friedland\ Kreis\ Göttingen",
"4936451", "Buttelstedt",
"4936841", "Schleusingen",
"499157", "Alfeld\ Mittelfranken",
"496502", "Schweich",
"499256", "Stammbach",
"492872", "Rhede\ Westfalen",
"4935793", "Elstra",
"4939857", "Drense",
"4933843", "Niemegk",
"4934205", "Markranstädt",
"498143", "Inning\ am\ Ammersee",
"495226", "Bruchmühlen\ Westfalen",
"494153", "Lauenburg\ Elbe",
"494175", "Egestorf\ Nordheide",
"499236", "Nagel",
"492383", "Bönen",
"493603", "Bad\ Langensalza",
"497777", "Sauldorf",
"496243", "Monsheim",
"495127", "Harsum",
"4939728", "Medow\ bei\ Anklam",
"493501", "Pirna",
"498723", "Arnstorf",
"494605", "Medelby",
"499164", "Langenfeld\ Mittelfranken",
"4934929", "Straach",
"4936947", "Jüchsen",
"497182", "Welzheim",
"497459", "Nagold\-Hochdorf",
"497300", "Roggenburg",
"492851", "Rees",
"496175", "Friedrichsdorf\ Taunus",
"4939951", "Faulenrost",
"498253", "Pöttmes",
"494243", "Twistringen",
"493672", "Rudolstadt",
"4939038", "Henningen",
"4938736", "Goldberg",
"492922", "Werl",
"4938462", "Baumgarten",
"496535", "Osann\-Monzel",
"498642", "Übersee",
"49861", "Traunstein",
"497204", "Malsch\-Völkersbach",
"492441", "Kall",
"496652", "Hünfeld",
"493631", "Nordhausen\ Thüringen",
"493533", "Elsterwerda",
"4936963", "Dorndorf\ Rhön",
"495654", "Herleshausen",
"4933657", "Steinsdorf\ Brandenburg",
"497683", "Simonswald",
"497581", "Saulgau",
"494535", "Nahe",
"499624", "Ensdorf\ Oberpfalz",
"499091", "Monheim\ Schwaben",
"492963", "Brilon\-Messinghausen",
"495634", "Waldeck\-Sachsenhausen",
"4935875", "Obercunnersdorf\ bei\ Löbau",
"494101", "Pinneberg",
"496758", "Waldböckelheim",
"494671", "Bredstedt",
"498379", "Waltenhofen\-Oberdorf",
"4936608", "Seelingstädt\ bei\ Gera",
"498584", "Breitenberg\ Niederbayern",
"498545", "Hofkirchen\ Bayern",
"4938372", "Usedom",
"494555", "Seedorf\ bei\ Bad\ Segeberg",
"496228", "Schönau\ Odenwald",
"492803", "Wesel\-Büderich",
"496573", "Gillenfeld",
"4938356", "Behrenhoff",
"496555", "Bleialf",
"4938228", "Dettmannsdorf\-Kölzow",
"494632", "Steinbergkirche",
"496101", "Bad\ Vilbel",
"494758", "Nordleda",
"499832", "Wassertrüdingen",
"496824", "Ottweiler",
"4962195", "Ludwigshafen",
"495822", "Ebstorf",
"493629", "Stadtilm",
"499385", "Kolitzheim",
"499344", "Gerchsheim",
"494499", "Barssel",
"495295", "Lichtenau\ Westfalen",
"498709", "Eching\ Niederbayern",
"498363", "Pfronten",
"4933397", "Wandlitz",
"4933335", "Pinnow\ Kreis\ Uckermark",
"492392", "Werdohl",
"499871", "Windsbach",
"496569", "Bickendorf",
"492688", "Kroppach",
"494824", "Krempe",
"4938302", "Sagard",
"497193", "Sulzbach\ an\ der\ Murr",
"499366", "Geroldshausen\ Unterfranken",
"495863", "Zernien",
"4934771", "Querfurt",
"4936332", "Ellrich",
"498322", "Oberstdorf",
"499852", "Feuchtwangen",
"4935246", "Ziegenhain\ Sachsen",
"495903", "Emsbüren",
"4935722", "Lauta\ bei\ Hoyerswerda",
"499468", "Zell\ Oberpfalz",
"492607", "Kobern\-Gondorf",
"497808", "Hohberg\ bei\ Offenburg",
"499373", "Amorbach",
"492771", "Dillenburg",
"4937609", "Wolkenburg\ Mulde",
"499355", "Frammersbach",
"493364", "Eisenhüttenstadt",
"494192", "Bad\ Bramstedt",
"493337", "Biesenthal\ Brandenburg",
"4938725", "Gross\ Godems",
"492732", "Kreuztal",
"496192", "Hofheim\ am\ Taunus",
"492263", "Engelskirchen",
"4939721", "Liepen\ bei\ Anklam",
"495194", "Bispingen",
"498292", "Dinkelscherben",
"498861", "Schongau",
"494928", "Ihlow\-Riepe",
"498825", "Krün",
"497837", "Oberharmersbach",
"492752", "Bad\ Laasphe",
"493346", "Seelow",
"4936458", "Bad\ Berka",
"4936848", "Wernshausen",
"492638", "Waldbreitbach",
"499404", "Nittendorf",
"498376", "Sulzberg\ Allgäu",
"495325", "Goslar\-Hahnenklee",
"495361", "Wolfsburg",
"499335", "Aub\ Kreis\ Würzburg",
"4935754", "Klettwitz",
"492222", "Bornheim\ Rheinland",
"493448", "Meuselwitz\ Thüringen",
"4933835", "Golzow\ bei\ Brandenburg",
"497529", "Waldburg\ Württemberg",
"497904", "Ilshofen",
"4937361", "Neuhausen\ Erzgebirge",
"495203", "Werther\ Westfalen",
"4933084", "Gutengermendorf",
"4938856", "Pritzier\ bei\ Hagenow",
"496398", "Vorderweidenthal",
"494496", "Friesoythe\-Markhausen",
"494682", "Amrum",
"4939083", "Messdorf",
"4938295", "Satow\ bei\ Bad\ Doberan",
"496707", "Windesheim",
"498706", "Vilsheim",
"4933367", "Friedrichswalde\ Brandenburg",
"492053", "Velbert\-Neviges",
"496682", "Tann\ Rhön",
"496566", "Körperich",
"494707", "Langen\-Neuenwalde",
"495684", "Frielendorf",
"495645", "Borgentreich\-Borgholz",
"4939291", "Calbe\ Saale",
"497551", "Überlingen\ Bodensee",
"497653", "Lenzkirch",
"498534", "Tettenweis",
"4938872", "Rehna",
"497675", "Bernau\ Baden",
"497268", "Bad\ Rappenau\-Obergimpern",
"499369", "Uettingen",
"493583", "Zittau",
"493681", "Suhl",
"492301", "Holzwickede",
"4933477", "Trebnitz\ bei\ Müncheberg",
"496788", "Sien",
"4933874", "Stechow\ Brandenburg",
"497531", "Konstanz",
"497633", "Staufen\ im\ Breisgau",
"498554", "Schönberg\ Niederbayern",
"494544", "Berkenthin",
"495542", "Witzenhausen",
"492427", "Nideggen",
"49551", "Göttingen",
"496544", "Rhaunen",
"496585", "Ralingen",
"4937203", "Gersdorf\ bei\ Chemnitz",
"4936207", "Plaue\ Thüringen",
"497572", "Mengen\ Württemberg",
"4937349", "Scheibenberg",
"4935326", "Schönborn\ Kreis\ Elbe\-Elster",
"496852", "Nohfelden",
"498405", "Stammham\ bei\ Ingolstadt",
"494795", "Garlstedt",
"493831", "Stralsund",
"495854", "Bleckede\-Barskamp",
"496468", "Dautphetal\-Mornshausen",
"494366", "Grömitz\-Cismar",
"494468", "Friedeburg\-Reepsholt",
"498367", "Rosshaupten\ Forggensee",
"4936736", "Arnsgereuth",
"4936462", "Ossmannstedt",
"4939329", "Möringen",
"49881", "Weilheim\ in\ Oberbayern",
"494852", "Brunsbüttel",
"497351", "Biberach\ an\ der\ Riss",
"4936043", "Kirchheilingen",
"495109", "Ronnenberg",
"498334", "Bad\ Grönenbach",
"499499", "Painten",
"492501", "Münster\-Hiltrup",
"492603", "Bad\ Ems",
"499569", "Sesslach",
"496871", "Wadern",
"4935477", "Rietzneuendorf\-Friedrichshof",
"495907", "Geeste",
"494832", "Meldorf",
"497331", "Geislingen\ an\ der\ Steige",
"4935874", "Bernstadt\ an\ der\ Eigen",
"495068", "Elze\ Leine",
"494385", "Hohenfelde\ bei\ Kiel",
"494344", "Schönberg\ Holstein",
"492173", "Langenfeld\ Rheinland",
"4939008", "Kunrau",
"496832", "Beckingen\-Reimsbach",
"4936642", "Harra",
"499824", "Dietenhofen",
"49531", "Braunschweig",
"492245", "Much",
"495834", "Wittingen\-Knesebeck",
"496385", "Reichenbach\-Steegen",
"496344", "Schwegenheim",
"494871", "Hohenwestedt",
"4936372", "Kleinneuhausen",
"499228", "Thurnau",
"4938752", "Zierzow\ bei\ Ludwigslust",
"499573", "Staffelstein\ Oberfranken",
"4933334", "Greiffenberg",
"499671", "Oberviechtach",
"495238", "Nieheim\-Himmighausen",
"493494", "Wolfen",
"492954", "Rüthen\-Oestereiden",
"499555", "Schlüsselfeld\-Aschbach",
"493564", "Schwarze\ Pumpe",
"494624", "Kropp",
"493537", "Jessen\ Elster",
"499101", "Langenzenn",
"496624", "Heringen\ Werra",
"4936920", "Grossenlupnitz",
"499632", "Waldsassen",
"495622", "Fritzlar",
"497702", "Blumberg\ Baden",
"496216", "Ludwigshafen",
"4934691", "Könnern",
"493546", "Lübben\ Spreewald",
"499652", "Waidhaus",
"499738", "Rottershausen",
"495148", "Steinhorst\ Niedersachsen",
"495663", "Spangenberg",
"495561", "Einbeck",
"495491", "Damme\ Dümmer",
"495525", "Walkenried",
"495258", "Salzkotten",
"4938332", "Gross\ Bisdorf",
"492934", "Sundern\-Altenhellefeld",
"499535", "Pfarrweisach",
"4939888", "Lychen",
"4933747", "Marzahna",
"4939753", "Strasburg",
"497329", "Steinheim\ am\ Albuch",
"497657", "Eisenbach\ Hochschwarzwald",
"4938724", "Siggelkow",
"492945", "Lippstadt\-Benninghausen",
"499544", "Baunach",
"492984", "Hallenberg",
"4939388", "Goldbeck\ Altm",
"492858", "Hünxe",
"498563", "Bad\ Birnbach\ Rottal",
"494703", "Loxstedt\-Donnern",
"498661", "Grabenstätt\ Chiemsee",
"492592", "Selm",
"492462", "Linnich",
"495676", "Liebenau\ Hessen",
"496703", "Wöllstein\ Rheinhessen",
"4934243", "Bad\ Düben",
"497646", "Weisweil\ Breisgau",
"495207", "Schloss\ Holte\-Stukenbrock",
"499682", "Erbendorf",
"499566", "Meeder",
"492064", "Dinslaken",
"492695", "Insul",
"492423", "Langerwehe",
"4937431", "Mehltheuer\ Vogtland",
"4933834", "Pritzerbe",
"4938458", "Zehna",
"492838", "Sonsbeck",
"4938848", "Vellahn",
"4939992", "Görmin",
"499398", "Birkenfeld\ bei\ Würzburg",
"4935755", "Ortrand",
"4933437", "Reichenberg\ bei\ Strausberg",
"4939833", "Mirow\ Kreis\ Neustrelitz",
"497664", "Freiburg\-Tiengen",
"494404", "Elsfleth",
"496335", "Trulben",
"4938294", "Neubukow",
"492234", "Frechen",
"495845", "Bergen\ Dumme",
"492267", "Wipperfürth",
"497853", "Kehl\-Bodersweier",
"4933085", "Seilershof",
"492166", "Mönchengladbach\-Rheydt",
"497381", "Münsingen",
"494882", "Lunden",
"496404", "Lich\ Hessen",
"499377", "Freudenberg\-Boxtal",
"494335", "Hohn\ bei\ Rendsburg",
"495402", "Bissendorf\ Kreis\ Osnabrück",
"492724", "Finnentrop\-Serkenrode",
"499192", "Gräfenberg",
"4936082", "Ershausen",
"493375", "Königs\ Wusterhausen",
"497428", "Rosenfeld",
"4933875", "Rhinow",
"4938207", "Stäbelow",
"4939829", "Blankenförde",
"494355", "Rieseby",
"498345", "Stöttwang",
"498384", "Röthenbach\ Allgäu",
"499928", "Kirchdorf\ im\ Wald",
"4935826", "Königshain\ bei\ Görlitz",
"496373", "Schönenberg\-Kübelberg",
"493881", "Grevesmühlen",
"496355", "Albisheim\ Pfrimm",
"492254", "Weilerswist",
"4934441", "Hohenmölsen",
"497833", "Hornberg\ Schwarzwaldbahn",
"496002", "Ober\-Mörlen",
"497326", "Neresheim",
"492620", "Neuhäusel\ Westerwald",
"498772", "Mallersdorf\-Pfaffenberg",
"497224", "Gernsbach",
"494186", "Buchholz\-Trelde",
"494950", "Holtland",
"4938309", "Trent",
"49371", "Chemnitz\ Sachsen",
"492902", "Warstein",
"494287", "Heeslingen\-Boitzen",
"496186", "Grosskrotzenburg",
"492291", "Waldbröl",
"4935693", "Lauschütz",
"497754", "Görwihl",
"493998", "Demmin",
"498731", "Dingolfing",
"496287", "Limbach\ Baden",
"492862", "Südlohn",
"497734", "Gailingen",
"494208", "Grasberg",
"499174", "Hilpoltstein",
"494741", "Nordholz\ bei\ Bremerhaven",
"498751", "Mainburg",
"499604", "Wernberg\-Köblitz",
"494165", "Hollenstedt\ Nordheide",
"494121", "Elmshorn",
"498221", "Günzburg",
"498678", "Marktl",
"498265", "Pfaffenhausen\ Schwaben",
"496165", "Breuberg",
"4933230", "Börnicke\ Kreis\ Havelland",
"497506", "Wangen\-Leupolz",
"4939242", "Prödel",
"492823", "Goch",
"499283", "Rehau",
"496741", "St\ Goar",
"4939726", "Ducherow",
"492336", "Schwelm",
"494964", "Rhede\ Ems",
"499076", "Wittislingen",
"499975", "Waldmünchen\-Geigant",
"492574", "Saerbeck",
"494482", "Hatten",
"494159", "Basthorst",
"496804", "Mandelbachtal",
"499953", "Pilsting",
"492389", "Werne",
"495802", "Wrestedt",
"496249", "Guntersblum",
"496482", "Runkel",
"496696", "Gilserberg",
"496159", "Messel",
"494804", "Nordhastedt",
"495484", "Lienen\-Kattenvenne",
"4937383", "Lunzenau",
"498259", "Schiltberg",
"4934294", "Rackwitz",
"494249", "Bassum\-Nordwohlde",
"495445", "Drebber",
"4936945", "Henneberg",
"497453", "Altensteig\ Württemberg",
"498035", "Raubling",
"495962", "Herzlake",
"493328", "Teltow",
"4939061", "Weferlingen",
"497475", "Burladingen",
"496139", "Budenheim",
"4937327", "Rechenberg\-Bienenmühle",
"498302", "Görisried",
"498239", "Langenneufnach",
"494946", "Grossefehn\-Bagband",
"498073", "Gars\ am\ Inn",
"497433", "Balingen",
"4938851", "Zarrentin",
"498055", "Halfing",
"4937366", "Rübenau",
"492627", "Braubach",
"495082", "Langlingen",
"4939855", "Parmen\-Weggun",
"496045", "Gedern",
"496084", "Schmitten\ Taunus",
"4934207", "Zwochau",
"495923", "Schüttorf",
"494139", "Hohnstorf\ Elbe",
"4939296", "Welsleben",
"499933", "Wallersdorf",
"494957", "Detern",
"4938379", "Benz\ Usedom",
"495032", "Neustadt\ am\ Rübenberge",
"496034", "Wöllstadt",
"494189", "Undeloh",
"49841", "Ingolstadt\ Donau",
"494452", "Zetel\-Neuenburg",
"498442", "Wolnzach",
"498066", "Bad\ Feilnbach",
"4936077", "Grossbodungen",
"4933983", "Gross\ Pankow\ Kreis\ Prignitz",
"494230", "Verden\-Walle",
"492641", "Bad\ Neuenahr\-Ahrweiler",
"492359", "Kierspe",
"492543", "Billerbeck\ Westfalen",
"496452", "Battenberg\ Eder",
"495071", "Schwarmstedt",
"4936701", "Lichte",
"498805", "Hohenpeissenberg",
"493431", "Döbeln",
"495454", "Hörstel\-Riesenbeck",
"497041", "Mühlacker",
"496868", "Mettlach\-Tünsdorf",
"497483", "Horb\-Mühringen",
"4938351", "Mesekenhagen",
"4933703", "Sperenberg",
"496432", "Diez",
"492991", "Marsberg\-Bredelar",
"499424", "Strasskirchen",
"494140", "Estorf\ Kreis\ Stade",
"495434", "Essen\ Oldenburg",
"4936484", "Knau\ bei\ Pössneck",
"4939481", "Hedersleben\ bei\ Aschersleben",
"494471", "Cloppenburg",
"495467", "Voltlage",
"498085", "Sankt\ Wolfgang",
"4937342", "Cranzahl",
"4938731", "Lübz",
"496471", "Weilburg",
"495052", "Hermannsburg",
"4933966", "Dranse",
"4938485", "Dabel",
"496054", "Birstein",
"494432", "Dötlingen\-Brettorf",
"495305", "Sickte",
"492202", "Bergisch\ Gladbach",
"4933927", "Linum",
"492339", "Sprockhövel\-Hasslinghausen",
"496727", "Gensingen",
"498726", "Schönau\ Niederbayern",
"496147", "Trebur",
"498146", "Moorenweis",
"4934776", "Rothenschirmbach",
"495223", "Bünde",
"494156", "Talkau",
"499233", "Arzberg\ Oberfranken",
"493606", "Heiligenstadt\ Heilbad",
"494257", "Schweringen",
"496246", "Eich\ Rheinhessen",
"499762", "Saal\ an\ der\ Saale",
"498247", "Bad\ Wörishofen",
"498157", "Feldafing",
"497745", "Jestetten",
"4937602", "Kirchberg\ Sachsen",
"4934348", "Frohburg",
"496257", "Seeheim\-Jugenheim",
"494246", "Twistringen\-Heiligenloh",
"4935200", "Arnsdorf\ bei\ Dresden",
"497161", "Göppingen",
"495775", "Diepenau",
"497125", "Bad\ Urach",
"4935241", "Lommatzsch",
"495753", "Auetal\-Bernsen",
"498137", "Petershausen",
"496136", "Nieder\-Olm",
"499143", "Pappenheim\ Mittelfranken",
"4939774", "Mönkebude",
"498781", "Rottenburg\ an\ der\ Laaber",
"498236", "Fischach",
"496237", "Maxdorf",
"496264", "Neudenau",
"499723", "Röthlein",
"492365", "Marl",
"495262", "Extertal",
"495733", "Vlotho",
"494264", "Sottrum\ Kreis\ Rotenburg",
"4939050", "Bartensleben",
"499275", "Speichersdorf",
"494136", "Scharnebeck",
"4939266", "Förderstedt",
"492407", "Herzogenrath\-Kohlscheid",
"499253", "Weissenstadt",
"494237", "Bendingbostel",
"497394", "Schelklingen",
"497457", "Rottenburg\-Ergenzingen",
"497348", "Beimerstetten",
"499084", "Bissingen\ Schwaben",
"498461", "Beilngries",
"495378", "Sassenburg\-Platendorf",
"498591", "Obernzell",
"4935058", "Pretzschendorf",
"492586", "Beelen",
"499946", "Hohenwarth\ bei\ Kötzing",
"492662", "Hachenburg",
"4938759", "Tewswoos",
"495476", "Ostercappeln\-Venne",
"499280", "Selbitz\ Oberfranken",
"494933", "Dornum\ Ostfriesland",
"495129", "Söhlde",
"4934492", "Lucka",
"497062", "Beilstein\ Württemberg",
"497446", "Lossburg",
"4933978", "Segeletz",
"493935", "Tangerhütte",
"4933200", "Bergholz\-Rehbrücke",
"4937436", "Weischlitz",
"494975", "Westerholt\ Ostfriesland",
"499482", "Wörth\ an\ der\ Donau",
"4939208", "Loitsche",
"494953", "Bunde",
"499937", "Oberpöring",
"492565", "Gronau\-Epe",
"499964", "Stallwang",
"4935773", "Schleife",
"492623", "Ransbach\-Baumbach",
"492521", "Beckum",
"493973", "Pasewalk",
"4936028", "Kammerforst\ Thüringen",
"499804", "Aurach",
"497023", "Weilheim\ an\ der\ Teck",
"497464", "Talheim\ Kreis\ Tuttlingen",
"495131", "Garbsen",
"494604", "Grossenwiehe",
"499165", "Sugenheim",
"497252", "Bretten",
"4939322", "Tangermünde",
"499208", "Bindlach",
"493969", "Siedenbollentin",
"496283", "Hardheim\ Odenwald",
"494174", "Stelle\ Kreis\ Harburg",
"499741", "Bad\ Brückenau",
"495172", "Ilsede",
"497722", "Triberg\ im\ Schwarzwald",
"498274", "Buttenwiesen",
"496174", "Königstein\ im\ Taunus",
"494283", "Tarmstedt",
"4934446", "Grosskorbetha",
"4936944", "Rentwertshausen",
"497142", "Bietigheim\-Bissingen",
"4934295", "Krensitz",
"49711", "Stuttgart",
"495602", "Hessisch\ Lichtenau",
"499186", "Lauterhofen\ Oberpfalz",
"4936649", "Gefell\ bei\ Schleiz",
"492827", "Goch\-Hassum",
"497271", "Wörth\ am\ Rhein",
"499287", "Selb",
"497628", "Efringen\-Kirchen",
"495241", "Gütersloh",
"4936379", "Holzengel",
"4938323", "Prohn",
"495151", "Hameln",
"497763", "Murg",
"497309", "Weissenhorn",
"497232", "Königsbach\-Stein",
"4939457", "Benneckenstein\ Harz",
"495505", "Hardegsen",
"4939854", "Kleptow",
"4935938", "Grosspostwitz\ OL",
"494723", "Cuxhaven\-Altenwalde",
"4934638", "Zöschen",
"4938823", "Selmsdorf",
"4939347", "Kade",
"496668", "Birstein\-Lichenroth",
"496275", "Rothenberg\ Odenwald",
"494143", "Drochtersen",
"492374", "Iserlohn\-Letmathe",
"498153", "Wessling",
"496253", "Fürth\ Odenwald",
"493761", "Werdau\ Sachsen",
"493725", "Zschopau",
"494668", "Klanxbüll",
"494275", "Ehrenburg",
"494253", "Asendorf\ Kreis\ Diepholz",
"498243", "Fuchstal",
"495126", "Algermissen",
"4934462", "Laucha\ Unstrut",
"499264", "Küps",
"497449", "Baiersbronn\-Obertal",
"49465", "Sylt",
"496723", "Oestrich\-Winkel",
"495746", "Rödinghausen",
"492841", "Moers",
"493528", "Radeberg",
"492403", "Eschweiler\ Rheinland",
"499156", "Neuhaus\ an\ der\ Pegnitz",
"494233", "Blender",
"499257", "Zell\ Oberfranken",
"498502", "Fürstenzell",
"494762", "Kutenholz",
"499727", "Schonungen\-Marktsteinach",
"4933733", "Stülpe",
"495181", "Alfeld\ Leine",
"499147", "Nennslingen",
"4938484", "Ventschow",
"4939822", "Kratzeburg",
"495764", "Steyerberg",
"498133", "Haimhausen\ Oberbayern",
"496233", "Frankenthal\ Pfalz",
"499246", "Pegnitz\-Trockau",
"4936731", "Unterloquitz",
"496762", "Kastellaun",
"499471", "Burglengenfeld",
"499720", "Üchtelhausen",
"497932", "Niederstetten\ Württemberg",
"492556", "Metelen",
"493966", "Cölpin",
"4934920", "Kropstädt",
"496424", "Ebsdorfergrund",
"496063", "Bad\ König",
"495422", "Melle",
"497971", "Gaildorf",
"492547", "Rosendahl\-Osterwick",
"495941", "Neuenhaus\ Dinkel",
"4936691", "Eisenberg\ Thüringen",
"499189", "Berg\ bei\ Neumarkt\ in\ der\ Oberpfalz",
"499452", "Langquaid",
"4939999", "Tutow",
"499868", "Schillingsfürst",
"493944", "Blankenburg\ Harz",
"4939775", "Ahlbeck\ bei\ Torgelow",
"4937468", "Treuen\ Vogtland",
"495691", "Bad\ Arolsen",
"495024", "Rohrsen\ Kreis\ Nienburg\ Weser",
"495593", "Bovenden\-Lenglern",
"497306", "Vöhringen\ Iller",
"496022", "Obernburg\ am\ Main",
"497952", "Gerabronn",
"499908", "Schöfweg",
"492536", "Münster\-Albachten",
"4939607", "Kotelow",
"4936083", "Uder",
"4933977", "Gumtow",
"492207", "Kürten\-Dürscheid",
"499453", "Thalmassing",
"498338", "Böhen",
"4937364", "Reitzenhain\ Erzgebirge",
"494464", "Wittmund\-Carolinensiel",
"492676", "Ulmen",
"4935057", "Hermsdorf\ Erzgebirge",
"496464", "Angelburg",
"497953", "Blaufelden",
"496023", "Alzenau\ in\ Unterfranken",
"496594", "Birresborn",
"495462", "Ankum",
"495592", "Gleichen\-Bremke",
"497975", "Untergröningen",
"495858", "Hitzacker\-Wietzetze",
"4939294", "Gross\ Rosenburg",
"495945", "Wilsum",
"494779", "Freiburg\ Elbe",
"497933", "Creglingen",
"499828", "Rügland",
"493981", "Neustrelitz",
"495838", "Gross\ Oesingen",
"4936873", "Themar",
"496348", "Offenbach\ an\ der\ Queich",
"494446", "Bakum\ Kreis\ Vechta",
"496457", "Burgwald\ Eder",
"498456", "Lenting",
"495695", "Twistetal",
"495423", "Versmold",
"4934296", "Groitzsch\ bei\ Pegau",
"495064", "Gross\ Düngen",
"499433", "Nabburg",
"496446", "Hohenahr",
"4936027", "Lengenfeld\ Unterm\ Stein",
"496062", "Erbach\ Odenwald",
"494348", "Schönkirchen",
"495037", "Bad\ Rehburg",
"4934445", "Stössen",
"4939207", "Colbitz",
"494232", "Langwedel\ Kreis\ Verden",
"494763", "Gnarrenburg",
"498503", "Neuhaus\ am\ Inn",
"492402", "Stolberg\ Rheinland",
"496628", "Oberaula",
"496271", "Eberbach\ Baden",
"498171", "Wolfratshausen",
"493721", "Meinersdorf",
"493765", "Reichenbach\ Vogtland",
"494271", "Sulingen",
"495166", "Walsrode\-Kirchboitzen",
"49355", "Cottbus",
"496232", "Speyer",
"496763", "Kirchberg\ Hunsrück",
"4939993", "Hohenmocker",
"4939724", "Klein\ Bünzow",
"4939832", "Wesenberg",
"495234", "Horn\-Bad\ Meinberg",
"492845", "Neukirchen\-Vluyn",
"492958", "Büren\-Harth",
"494722", "Cuxhaven\-Altenbruch",
"496252", "Heppenheim\ Bergstrasse",
"496430", "Hahnstätten",
"495254", "Paderborn\-Schloss\ Neuhaus",
"4939458", "Heudeber",
"498152", "Herrsching\ am\ Ammersee",
"492938", "Ense",
"494142", "Steinkirchen\ Kreis\ Stade",
"49821", "Augsburg",
"4934242", "Hohenpriessnitz",
"494252", "Bruchhausen\-Vilsen",
"495185", "Duingen",
"495144", "Wathlingen",
"4937435", "Reuth\ bei\ Plauen",
"49611", "Wiesbaden",
"496142", "Rüsselsheim",
"49208", "Oberhausen\ Rheinland",
"495724", "Obernkirchen",
"497174", "Mögglingen",
"4935751", "Welzow",
"499734", "Burkardroth",
"496722", "Rüdesheim\ am\ Rhein",
"495135", "Burgwedel\-Fuhrberg",
"4939776", "Hintersee",
"494480", "Ovelgönne\-Strückhausen",
"499161", "Neustadt\ an\ der\ Aisch",
"49203", "Duisburg",
"499745", "Wildflecken",
"493504", "Dippoldiswalde",
"497762", "Wehr\ Baden",
"497233", "Niefern\-Öschelbronn",
"4938333", "Horst\ bei\ Grimmen",
"4939752", "Blumenhagen\ bei\ Strasburg",
"4934637", "Frankleben",
"4935937", "Prischwitz",
"499548", "Mühlhausen\ Mittelfranken",
"4939348", "Klitsche",
"4939264", "Kroppenstedt",
"499394", "Esselbach",
"492867", "Heiden\ Kreis\ Borken",
"494776", "Osten\-Altendorf",
"4938753", "Wöbbelin",
"497253", "Bad\ Schönborn",
"497275", "Kandel",
"497668", "Ihringen",
"496282", "Walldürn",
"49231", "Dortmund",
"4934774", "Röblingen\ am\ See",
"495284", "Schwalenberg",
"495245", "Herzebrock\-Clarholz",
"492834", "Straelen",
"498459", "Manching",
"494282", "Sittensen",
"495155", "Emmerthal",
"495173", "Uetze",
"497723", "Furtwangen\ im\ Schwarzwald",
"496449", "Ehringshausen\-Katzenfurt",
"496776", "Dachsenhausen",
"495603", "Gudensberg",
"497143", "Besigheim",
"494952", "Rhauderfehn",
"496408", "Buseck",
"498421", "Eichstätt\ Bayern",
"498465", "Kipfenberg",
"492622", "Bendorf\ am\ Rhein",
"4936643", "Thimmendorf",
"4933964", "Fretzdorf",
"497022", "Nürtingen",
"496306", "Trippstadt",
"494408", "Hude\ Oldenburg",
"493931", "Stendal",
"4936373", "Buttstädt",
"495954", "Lorup",
"492238", "Pulheim",
"494971", "Esens",
"4939608", "Staven",
"499924", "Bodenmais",
"492525", "Beckum\-Neubeckum",
"492663", "Westerburg\ Westerwald",
"492561", "Ahaus",
"495934", "Haren\-Rütenbrock",
"494932", "Norderney",
"495807", "Altenmedingen",
"4936463", "Gebstedt",
"4937467", "Klingenthal\ Sachsen",
"494487", "Grossenkneten\-Huntlosen",
"498388", "Hergensweiler",
"4936042", "Tonna",
"497063", "Bad\ Wimpfen",
"497424", "Spaichingen",
"498766", "Gammelsdorf",
"4934322", "Rosswein",
"494506", "Stockelsdorf\-Krumbeck",
"49911", "Nuremberg",
"4937365", "Sayda",
"499142", "Treuchtlingen",
"495263", "Barntrup",
"495732", "Löhne",
"498395", "Tannheim\ Württemberg",
"495658", "Wehretal",
"497930", "Boxberg\ Baden",
"496734", "Flonheim",
"499722", "Werneck",
"4939295", "Zuchau",
"497741", "Tiengen\ Hochrhein",
"4937202", "Claussnitz\ bei\ Chemnitz",
"4933760", "Münchehofe\ Kreis\ Dahme\-Spreewald",
"494734", "Stadland\-Seefeld",
"4935600", "Döbern\ NL",
"494767", "Bremervörde\-Bevern",
"498507", "Neuburg\ am\ Inn",
"499252", "Helmbrechts",
"496506", "Welschbillig",
"497121", "Reutlingen",
"495771", "Rahden\ Westfalen",
"497165", "Göppingen\-Hohenstaufen",
"4939856", "Beenz\ bei\ Prenzlau",
"498785", "Rottenburg\-Oberroning",
"494754", "Bülkau",
"498744", "Gerzen",
"492361", "Recklinghausen",
"496224", "Sandhausen\ Baden",
"499232", "Wunsiedel",
"4939082", "Mieste",
"499763", "Sulzdorf\ an\ der\ Lederhecke",
"492325", "Wanne\-Eickel",
"495222", "Bad\ Salzuflen",
"498124", "Forstern\ Oberbayern",
"493774", "Schwarzenberg",
"494224", "Gross\ Ippener",
"4934444", "Lützen",
"4936946", "Erbenhausen\ Thüringen",
"499628", "Ursensollen",
"4933989", "Sadenbeck",
"499271", "Thurnau\-Alladorf",
"495752", "Auetal\-Hattendorf",
"4938873", "Carlow",
"497950", "Schnelldorf",
"496020", "Heigenbrücken",
"496754", "Martinstein",
"494828", "Lägerdorf",
"496433", "Hadamar",
"499446", "Altmannstein",
"497957", "Kressberg",
"496027", "Stockstadt\ am\ Main",
"498026", "Hausham",
"499779", "Nordheim\ von\ der\ Rhön",
"4938721", "Ziegendorf",
"492645", "Vettelschoss",
"497139", "Neuenstadt\ am\ Kocher",
"492684", "Puderbach\ Westerwald",
"493304", "Velten",
"4935263", "Gröditz\ bei\ Riesa",
"493435", "Oschatz",
"497946", "Bretzfeld",
"498801", "Seeshaupt",
"495053", "Fassberg\-Müden",
"495976", "Salzbergen",
"497084", "Schömberg\ bei\ Neuenbürg",
"492203", "Cologne\-Porz",
"497045", "Oberderdingen",
"494433", "Dötlingen",
"499348", "Werbach\-Gamburg",
"497249", "Stutensee",
"499464", "Walderbach",
"493473", "Aschersleben\ Sachsen\-Anhalt",
"497804", "Oppenau",
"495033", "Wunstorf\-Grossenheidorn",
"494475", "Molbergen",
"492542", "Gescher",
"49251", "Münster",
"495427", "Melle\-Buer",
"498443", "Hohenwart\ Paar",
"4934208", "Löbnitz\ bei\ Delitzsch",
"494453", "Zetel",
"498081", "Dorfen\ Stadt",
"496475", "Weilmünster\-Wolfenhausen",
"496453", "Gemünden\ Wohra",
"497964", "Stödtlen",
"4937328", "Grossschirma",
"497937", "Dörzbach",
"495301", "Lehre\-Essenrode",
"4937434", "Bobenneukirchen",
"4933831", "Weseram",
"497159", "Renningen",
"497482", "Horb\-Dettingen",
"498303", "Waltenhofen",
"494509", "Gross\ Grönau",
"494924", "Moormerland\-Oldersum",
"493466", "Artern\ Unstrut",
"4936333", "Heringen\ Helme",
"493596", "Neustadt\ in\ Sachsen",
"499971", "Cham",
"4933331", "Casekow",
"495198", "Schneverdingen\-Wintermoor",
"498072", "Haag\ in\ Oberbayern",
"497250", "Kraichtal",
"492654", "Polch",
"497432", "Albstadt\-Tailfingen",
"4939265", "Löderburg",
"4935723", "Bernsdorf\ OL",
"495441", "Diepholz",
"49335", "Frankfurt\ \(Oder\)",
"495083", "Hohne\ bei\ Celle",
"499932", "Osterhofen",
"497054", "Wildberg\ Württemberg",
"496509", "Büdlich",
"497720", "Schwenningen\ am\ Neckar",
"495922", "Bad\ Bentheim",
"497471", "Hechingen",
"498031", "Rosenheim\ Oberbayern",
"4934775", "Wippra",
"4933928", "Wildberg\ Brandenburg",
"499952", "Eichendorf",
"497034", "Ehningen",
"499306", "Kist",
"495803", "Rosche",
"494483", "Ovelgönne\-Grossenmeer",
"498051", "Prien\ am\ Chiemsee",
"492667", "Stein\-Neukirch",
"499408", "Altenthann",
"4937757", "Rittersgrün",
"496483", "Selters\ Taunus",
"4934607", "Wettin",
"496041", "Glauburg",
"495963", "Bawinkel",
"4938303", "Sellin\ Ostseebad",
"492634", "Rengsdorf",
"497452", "Nagold",
"498538", "Pocking\-Hartkirchen",
"497264", "Bad\ Rappenau",
"494394", "Bokhorst",
"497237", "Neulingen\ Enzkreis",
"498029", "Kreuth\ bei\ Tegernsee",
"499776", "Mellrichstadt",
"4938373", "Katzow",
"4934347", "Oelzschau\ bei\ Borna",
"497136", "Bad\ Friedrichshall",
"496394", "Bundenthal",
"497949", "Pfedelbach\-Untersteinbach",
"492295", "Ruppichteroth",
"498735", "Gangkofen\-Kollbach",
"4933965", "Herzsprung\ bei\ Wittstock",
"499282", "Naila",
"4938486", "Gustävel",
"492822", "Emmerich",
"498773", "Neufahrn\ in\ Niederbayern",
"497246", "Malsch\ Kreis\ Karlsruhe",
"495607", "Fuldatal",
"494745", "Bad\ Bederkesa",
"497147", "Sachsenheim\ Württemberg",
"495276", "Marienmünster",
"492903", "Meschede\-Freienohl",
"499480", "Sünching",
"494125", "Seestermühe",
"494161", "Buxtehude",
"497727", "Vöhrenbach",
"495177", "Edemissen\-Abbensen",
"498261", "Mindelheim",
"4936962", "Vacha",
"498225", "Jettingen\-Scheppach",
"498558", "Hohenau\ Niederbayern",
"496161", "Brensbach",
"497257", "Bruchsal\-Untergrombach",
"492863", "Velen",
"496745", "Gondershausen",
"497156", "Ditzingen",
"496784", "Weierbach",
"499193", "Höchstadt\ an\ der\ Aisch",
"495841", "Lüchow\ Wendland",
"496331", "Pirmasens",
"492227", "Bornheim\-Merten",
"494372", "Westfehmarn",
"495374", "Isenbüttel",
"493866", "Cambs",
"496372", "Bruchmühlbach\-Miesau",
"4935244", "Krögis",
"4933093", "Fürstenberg\ Havel",
"496003", "Rosbach\ von\ der\ Höhe",
"4935020", "Struppen",
"4936695", "Söllmnitz",
"497344", "Blaubeuren",
"497385", "Gomadingen",
"494331", "Rendsburg",
"499088", "Mönchsdeggingen",
"498639", "Neumarkt\-Sankt\ Veit",
"4934261", "Kühren\ bei\ Wurzen",
"497832", "Haslach\ im\ Kinzigtal",
"492764", "Welschen\ Ennest",
"493371", "Luckenwalde",
"492181", "Grevenbroich",
"496296", "Ahorn\ Baden",
"4939771", "Ueckermünde",
"498196", "Pürgen",
"492737", "Netphen\-Deuz",
"494351", "Eckernförde",
"497852", "Willstätt",
"498341", "Kaufbeuren",
"494296", "Schwanewede\-Aschwarden",
"493844", "Schwaan",
"497570", "Sigmaringen\-Gutenstein",
"4939007", "Tangeln",
"493332", "Schwedt\/Oder",
"496351", "Eisenberg\ Pfalz",
"495403", "Bad\ Iburg",
"4935478", "Goyatz",
"494883", "Süderstapel",
"497366", "Abtsgmünd",
"499683", "Friedenfels",
"497577", "Veringenstadt",
"492941", "Lippstadt",
"498094", "Steinhöring",
"494329", "Langwedel\ Holstein",
"498621", "Trostberg",
"498665", "Inzell",
"492422", "Kreuzau",
"496329", "Weidenthal\ Pfalz",
"4933732", "Hennickendorf\ bei\ Luckenwalde",
"499204", "Plankenfels",
"4938354", "Wusterhusen",
"494178", "Radbruch",
"495556", "Lindau\ Harz",
"4937421", "Oelsnitz\ Vogtland",
"4936704", "Steinheid",
"496190", "Hattersheim\ am\ Main",
"4939823", "Rechlin",
"494608", "Handewitt",
"4939740", "Nechlin",
"4936481", "Neustadt\ an\ der\ Orla",
"4939484", "Harzgerode",
"4938822", "Diedrichshagen\ bei\ Grevesmühlen",
"499526", "Riedbach",
"4933748", "Treuenbrietzen",
"495536", "Holzminden\-Neuhaus",
"492691", "Adenau",
"492593", "Ascheberg\ Westfalen",
"492750", "Diedenshausen",
"4935325", "Rückersdorf\ bei\ Finsterwalde",
"492463", "Titz",
"494702", "Sandstedt",
"4939887", "Gerswalde",
"498562", "Triftern",
"498686", "Petting",
"495704", "Petershagen\-Friedewalde",
"4934463", "Bad\ Kösen",
"4936735", "Probstzella",
"497624", "Grenzach\-Wyhlen",
"499268", "Teuschnitz",
"499675", "Altendorf\ am\ Nabburg",
"499653", "Eslarn",
"499551", "Burgwindheim",
"494637", "Sterup",
"493909", "Klötze\ Altmark",
"494664", "Neukirchen\ bei\ Niebüll",
"4933876", "Buschow",
"495820", "Suhlendorf",
"499105", "Grosshabersdorf",
"492129", "Haan\ Rheinland",
"4938322", "Richtenberg",
"496664", "Sinntal\-Sterbfritz",
"492378", "Fröndenberg\-Langschede",
"496095", "Bessenbach",
"493869", "Dümmer",
"495662", "Felsberg\ Hessen",
"495586", "Wieda",
"4935825", "Kodersdorf",
"4938780", "Lanz\ Brandenburg",
"4939387", "Havelberg",
"496637", "Feldatal",
"498636", "Ampfing",
"4934291", "Borsdorf",
"4933086", "Grieben\ Kreis\ Oberhavel",
"495768", "Petershagen\-Heimsen",
"4938854", "Redefin",
"4933438", "Altlandsberg",
"498320", "Missen\-Wilhams",
"499572", "Burgkunstadt",
"4939323", "Schönhausen\ Elbe",
"4938847", "Boizenburg\ Elbe",
"496657", "Hofbieber",
"498656", "Anger",
"494646", "Mohrkirch",
"4938457", "Krakow\ am\ See",
"495623", "Edertal",
"495495", "Vörden\ Kreis\ Vechta",
"495521", "Herzberg\ am\ Harz",
"495565", "Einbeck\-Wenzen",
"499633", "Mitterteich",
"499531", "Ebern",
"496646", "Grebenau",
"492927", "Neuengeseke",
"497703", "Bonndorf\ im\ Schwarzwald",
"493677", "Ilmenau\ Thüringen",
"494791", "Osterholz\-Scharmbeck",
"498640", "Reit\ Im\ Winkl",
"492602", "Montabaur",
"493382", "Lehnin",
"4935772", "Rietschen",
"494326", "Wankendorf",
"496428", "Stadtallendorf",
"494833", "Wesselburen",
"499857", "Schopfloch\ Mittelfranken",
"4935756", "Hosena",
"496326", "Deidesheim",
"498327", "Rettenberg",
"496833", "Rehlingen\-Siersburg",
"49906", "Donauwörth",
"499846", "Ipsheim",
"492131", "Neuss",
"496650", "Hosenfeld",
"4934721", "Nienburg\ Saale",
"497355", "Hochdorf\ Riss",
"497373", "Zwiefalten",
"496875", "Nonnweiler\-Primstal",
"492505", "Altenberge\ Westfalen",
"499904", "Lalling",
"499529", "Oberaurach",
"496853", "Marpingen",
"4936628", "Zeulenroda",
"492151", "Krefeld",
"496630", "Schwalmtal\-Storndorf",
"495028", "Pennigsehl",
"497335", "Wiesensteig",
"494381", "Lütjenburg",
"494630", "Barderup",
"4934493", "Gössnitz\ Thüringen",
"497404", "Epfendorf",
"492241", "Siegburg",
"496381", "Kusel",
"494875", "Stafstedt",
"495827", "Unterlüss",
"4938208", "Kavelstorf",
"494853", "Sankt\ Michaelisdonn",
"499837", "Haundorf",
"494526", "Ascheberg\ Holstein",
"493994", "Malchin",
"497632", "Badenweiler",
"492454", "Gangelt",
"496526", "Bollendorf",
"495641", "Warburg",
"495543", "Staufenberg\ Niedersachsen",
"4936694", "Schkölen\ Thüringen",
"497555", "Deggenhausertal",
"4939037", "Pretzier",
"4935245", "Burkhardswalde\-Munzig",
"497671", "Todtnau",
"497573", "Stetten\ am\ kalten\ Markt",
"497228", "Forbach",
"492305", "Castrop\-Rauxel",
"493685", "Hildburghausen",
"493644", "Apolda",
"496204", "Viernheim",
"498104", "Sauerlach",
"495339", "Gielde",
"496849", "Kirkel",
"495202", "Oerlinghausen",
"4933336", "Passow\ Kreis\ Uckermark",
"4962196", "Ludwigshafen",
"492052", "Velbert\-Langenberg",
"499190", "Heroldsbach",
"4938227", "Lüdershagen\ bei\ Barth",
"494683", "Oldsum",
"499608", "Kohlberg\ Oberpfalz",
"492597", "Senden\ Westfalen",
"496581", "Saarburg",
"496683", "Ehrenberg\ Rhön",
"4936607", "Niederpöllnitz",
"4937603", "Wildenfels",
"49234", "Bochum",
"497738", "Steisslingen",
"494204", "Thedinghausen",
"499178", "Abenberg\ Mittelfranken",
"497652", "Hinterzarten",
"494849", "Hooge",
"492434", "Wegberg",
"492775", "Driedorf",
"496007", "Rosbach\-Rodheim",
"492753", "Erndtebrück",
"4937209", "Einsiedel\ bei\ Chemnitz",
"499351", "Gemünden\ am\ Main",
"492590", "Dülmen\-Buldern",
"4937343", "Jöhstadt",
"4935876", "Weissenberg\ Sachsen",
"492223", "Königswinter",
"4936705", "Oberweissbach\ Thüringer\ Wald",
"4933398", "Werneuchen",
"498821", "Garmisch\-Partenkirchen",
"494968", "Neulehe",
"4938355", "Züssow",
"499197", "Egloffstein",
"495407", "Wallenhorst",
"499372", "Klingenberg\ am\ Main",
"4935324", "Crinitz",
"4933982", "Hoppenrade\ Kreis\ Prignitz",
"4939390", "Iden",
"4938735", "Plau\ am\ See",
"4938797", "Karstädt\ Kreis\ Prignitz",
"494193", "Henstedt\-Ulzburg",
"4939485", "Gernrode\ Harz",
"497824", "Schwanau",
"495365", "Wolfsburg\-Neindorf",
"4938481", "Witzin",
"495321", "Goslar",
"498293", "Welden\ bei\ Augsburg",
"492733", "Hilchenbach",
"499331", "Ochsenfurt",
"492262", "Wiehl",
"4936734", "Leutenberg",
"4939089", "Bismark\ Altmark",
"497569", "Isny\-Eisenbach",
"496887", "Schmelz\ Saar",
"4933702", "Wünsdorf",
"496864", "Mettlach",
"495862", "Hitzacker\ Elbe",
"499381", "Volkach",
"494529", "Süsel\-Bujendorf",
"498323", "Immenstadt\ im\ Allgäu",
"495347", "Burgdorf\ bei\ Salzgitter",
"495458", "Hopsten",
"496837", "Wallerfangen",
"499875", "Wolframs\-Eschenbach",
"4939957", "Gielow",
"495356", "Helmstedt\-Barmke",
"499853", "Wilburgstetten",
"495902", "Freren",
"494837", "Neuenkirchen\ Dithmarschen",
"494864", "Oldenswort",
"4936941", "Wasungen",
"4936969", "Merkers",
"499326", "Markt\ Einersheim",
"495823", "Bienenbüttel",
"4938296", "Rerik\ Ostseebad",
"495336", "Semmenstedt",
"499833", "Heidenheim\ Mittelfranken",
"498847", "Obersöchering",
"494857", "Barlt",
"492393", "Sundern\-Allendorf",
"4938855", "Lübtheen",
"498362", "Füssen",
"493877", "Wittenberge",
"496058", "Gründau",
"4939851", "Göritz\ bei\ Prenzlau",
"4939400", "Wefensleben",
"4937382", "Geringswalde",
"499428", "Kirchroth",
"4936847", "Steinbach\-Hallenberg",
"495438", "Bakum\-Lüsche",
"497192", "Murrhardt",
"494846", "Hattstedt",
"496857", "Namborn",
"498856", "Penzberg",
"496633", "Homberg\ Ohm",
"496531", "Bernkastel\-Kues",
"492962", "Olsberg",
"499646", "Freihung",
"492445", "Schleiden\ Eifel",
"492484", "Mechernich\-Eiserfey",
"493635", "Kölleda",
"495574", "Oberweser",
"492802", "Alpen",
"4933368", "Hohensaaten",
"4933836", "Butzow\ bei\ Brandenburg",
"496572", "Manderscheid\ Eifel",
"497585", "Ostrach",
"497544", "Markdorf",
"4939243", "Nedlitz\ bei\ Zerbst",
"494633", "Satrup",
"494531", "Bad\ Oldesloe",
"499657", "Waldthurn",
"499664", "Hahnbach",
"494830", "Süderhastedt",
"492923", "Lippetal\-Herzfeld",
"497707", "Bräunlingen",
"493571", "Hoyerswerda",
"4938726", "Spornitz",
"494105", "Seevetal",
"494268", "Bötersen",
"498541", "Vilshofen\ Niederbayern",
"494551", "Bad\ Segeberg",
"4936208", "Ermstedt",
"499637", "Falkenberg\ Oberpfalz",
"496268", "Hüffenhardt",
"496675", "Breitenbach\ am\ Herzberg",
"4935692", "Kerkwitz",
"496653", "Burghaun",
"496551", "Prüm",
"498168", "Attenkirchen",
"498205", "Dasing",
"497566", "Argenbühl",
"496105", "Mörfelden\-Walldorf",
"497682", "Elzach",
"4933478", "Gross\ Neuendorf",
"496242", "Osthofen",
"499766", "Grosswenkheim",
"49621", "Mannheim",
"492382", "Ahlen\ Westfalen",
"494489", "Apen",
"49811", "Hallbergmoos",
"494152", "Geesthacht",
"495285", "Bad\ Pyrmont\-Kleinenberg",
"4938488", "Demen",
"498142", "Olching",
"492835", "Issum",
"495244", "Rietberg",
"4936259", "Tabarz\ Thüringer\ Wald",
"499395", "Triefenstein",
"498722", "Gangkofen",
"497274", "Germersheim",
"497183", "Rudersberg\ Württemberg",
"495154", "Aerzen",
"494242", "Syke",
"498252", "Schrobenhausen",
"4937755", "Schönheide\ Erzgebirge",
"49421", "Bremen",
"4934224", "Belgern\ Sachsen",
"496152", "Gross\-Gerau",
"4934605", "Gröbers",
"495266", "Lemgo\-Kirchheide",
"499744", "Zeitlofs\-Detter",
"494171", "Winsen\ Luhe",
"495167", "Walsrode\-Westenholz",
"494503", "Timmendorfer\ Strand",
"498450", "Ingolstadt\-Zuchering",
"498232", "Schwabmünchen",
"496132", "Ingelheim\ am\ Rhein",
"496440", "Kölschhausen",
"4939742", "Brüssow\ bei\ Pasewalk",
"496503", "Hermeskeil",
"492873", "Isselburg\-Werth",
"492948", "Lippstadt\-Rebbeke",
"494132", "Amelinghausen",
"492855", "Voerde\ Niederrhein",
"4939226", "Hohenziatz",
"4939267", "Schneidlingen",
"498271", "Meitingen",
"498628", "Kienberg\ Oberbayern",
"4935934", "Grossdubrau",
"496171", "Oberursel\ Taunus",
"492524", "Ennigerloh",
"499925", "Bayerisch\ Eisenstein",
"4940", "Hamburg",
"499961", "Mitterfels",
"498446", "Pörnbach",
"495935", "Twist\-Schöninghsdorf",
"498062", "Bruckmühl\ Mangfall",
"496447", "Langgöns\-Niederkleen",
"494456", "Varel\-Altjührden",
"496358", "Kriegsfeld",
"4936076", "Niederorschel",
"493476", "Hettstedt\ Sachsen\-Anhalt",
"495036", "Neustadt\-Schneeren",
"4937464", "Schöneck\ Vogtland",
"493378", "Ludwigsfelde",
"497461", "Tuttlingen",
"497425", "Trossingen",
"498348", "Bidingen",
"494447", "Vechta\-Langförden",
"494358", "Loose\ bei\ Eckernförde",
"498457", "Vohburg\ an\ der\ Donau",
"496456", "Haina\ Kloster",
"4934923", "Cobbelsdorf",
"498023", "Bayrischzell",
"498464", "Dietfurt\ an\ der\ Altmühl",
"4934345", "Bad\ Lausick",
"4935975", "Hohnstein",
"4933849", "Wiesenburg\ Mark",
"499081", "Nördlingen",
"496436", "Dornburg\ Hessen",
"494338", "Alt\ Duvenstedt",
"499443", "Abensberg",
"4933967", "Freyenstein",
"495973", "Neuenkirchen\ Kreis\ Steinfurt",
"492206", "Overath",
"495955", "Esterwegen",
"4935022", "Bad\ Schandau",
"496338", "Hornbach\ Pfalz",
"495848", "Trebel",
"492677", "Lutzerath",
"497943", "Schöntal\ Jagst",
"4933055", "Kremmen",
"4936653", "Lehesten\ Thüringer\ Wald",
"4933926", "Herzberg\ Mark",
"495056", "Winsen\-Meissendorf",
"493941", "Halberstadt",
"499303", "Eibelstadt",
"495806", "Barum\ bei\ Bad\ Bevensen",
"494486", "Edewecht\-Friedrichsfehn",
"492248", "Hennef\-Uckerath",
"499072", "Lauingen\ Donau",
"4936024", "Diedorf\ bei\ Mühlhausen",
"495966", "Meppen\-Apeldorn",
"4933679", "Wendisch\ Rietz",
"4933203", "Kleinmachnow",
"4939204", "Niederndodeleben",
"495021", "Nienburg\ Weser",
"495694", "Diemelstadt",
"4936201", "Walschleben",
"495065", "Sibbesse",
"492158", "Grefrath\ bei\ Krefeld",
"4938429", "Glasin",
"496486", "Katzenelnbogen",
"496692", "Neustadt\ Hessen",
"4937326", "Frauenstein\ Sachsen",
"494465", "Friedeburg\ Ostfriesland",
"494421", "Wilhelmshaven",
"4933361", "Joachimsthal",
"494770", "Wischhafen",
"4933974", "Dessow",
"4938231", "Barth",
"498306", "Ronsberg",
"496307", "Schopp",
"4939973", "Altkalen",
"499474", "Schmidmühlen",
"49491", "Leer\ Ostfriesland",
"494942", "Südbrookmerland",
"4937367", "Lengefeld\ Erzgebirge",
"493691", "Eisenach\ Thüringen",
"494307", "Raisdorf",
"4934206", "Rötha",
"495944", "Hoogstede",
"4935054", "Lauenstein\ Sachsen",
"496465", "Breidenbach\ bei\ Biedenkopf",
"4939297", "Eickendorf\ Kreis\ Schönebeck",
"496595", "Dockweiler",
"4934381", "Colditz",
"496421", "Marburg",
"495086", "Celle\-Scheuen",
"497974", "Bühlerzell",
"495273", "Beverungen",
"495528", "Gieboldehausen",
"492352", "Altena\ Westfalen",
"495255", "Altenbeken",
"494182", "Tostedt",
"4939858", "Bietikow",
"497243", "Ettlingen",
"494777", "Cadenberge",
"495761", "Stolzenau",
"492866", "Dorsten\-Rhade",
"497175", "Leinzell",
"495725", "Lindhorst\ bei\ Stadthagen",
"497153", "Plochingen",
"499735", "Massbach",
"495184", "Freden\ Leine",
"498282", "Krumbach\ Schwaben",
"495145", "Beedenbostel",
"496182", "Seligenstadt",
"492371", "Iserlohn",
"499773", "Unsleben",
"497133", "Lauffen\ am\ Neckar",
"493764", "Meerane",
"4933609", "Brieskow\-Finkenheerd",
"493737", "Rochlitz",
"4936948", "Römhild",
"496439", "Holzappel",
"4938782", "Reetz\ bei\ Perleberg",
"499225", "Stadtsteinach",
"492332", "Gevelsberg",
"499261", "Kronach",
"492844", "Rheinberg\-Orsoy",
"495235", "Blomberg\ Lippe",
"497502", "Wolpertswende",
"4939727", "Spantekow",
"4938320", "Tribsees",
"493962", "Penzlin\ bei\ Waren",
"495328", "Altenau\ Harz",
"492552", "Steinfurt\-Borghorst",
"499338", "Röttingen\ Unterfranken",
"4939392", "Rönnebeck\ Sachsen\-Anhalt",
"494443", "Dinklage",
"498453", "Reichertshofen\ Oberbayern",
"497936", "Schrozberg\-Bartenstein",
"493445", "Naumburg\ Saale",
"497259", "Östringen\-Odenheim",
"4934604", "Niemberg",
"4935891", "Rothenburg\ OL",
"49340", "Dessau\ Anh",
"495609", "Ahnatal",
"4937754", "Zwönitz",
"4933741", "Niedergörsdorf",
"492635", "Rheinbrohl",
"495426", "Glandorf",
"4936743", "Teichel",
"497729", "Tennenbronn",
"499436", "Nittenau",
"496081", "Usingen",
"496443", "Ehringshausen\ Dill",
"496500", "Waldrach",
"492673", "Ellenz\-Poltersdorf",
"492571", "Greven\ Westfalen",
"497947", "Forchtenberg",
"493923", "Zerbst",
"4935609", "Drachhausen",
"4934909", "Aken\ Elbe",
"492655", "Weibern",
"494925", "Hinte",
"4933769", "Töpchin",
"494961", "Papenburg",
"495977", "Spelle",
"492103", "Hilden",
"497055", "Neuweiler\ Kreis\ Calw",
"492532", "Ostbevern",
"4934635", "Bad\ Lauchstädt",
"4935935", "Kleinwelka",
"497073", "Ammerbuch",
"499447", "Essing",
"499358", "Gössenheim",
"498433", "Königsmoos",
"497302", "Pfaffenhofen\ an\ der\ Roth",
"498027", "Dietramszell",
"496026", "Grossostheim",
"495043", "Lauenau",
"4939606", "Glienke",
"4938393", "Binz\ Ostseebad",
"495481", "Lengerich\ Westfalen",
"499503", "Oberhaid\ Oberfranken",
"494124", "Glückstadt",
"4939346", "Tucheim",
"496588", "Pluwig",
"4935471", "Birkenhainchen",
"497731", "Singen\ Hohentwiel",
"498754", "Volkenschwand",
"494744", "Loxstedt",
"499171", "Roth\ Mittelfranken",
"498020", "Weyarn",
"495742", "Preussisch\ Oldendorf",
"49571", "Minden\ Westfalen",
"4934979", "Wulfen\ Sachsen\-Anhalt",
"496744", "Oberwesel",
"496785", "Herrstein",
"4935203", "Tharandt",
"497940", "Künzelsau",
"4939778", "Ferdinandshof\ bei\ Torgelow",
"498224", "Offingen\ Donau",
"4934422", "Osterfeld",
"499132", "Herzogenaurach",
"4937465", "Tannenbergsthal\ Vogtland",
"496124", "Bad\ Schwalbach",
"4935361", "Schlieben",
"4935974", "Hinterhermsdorf",
"495648", "Brakel\-Gehrden",
"4934344", "Kohren\-Sahlis",
"494766", "Basdahl",
"496507", "Neumagen\-Dhron",
"498506", "Bad\ Höhenstadt",
"497221", "Baden\-Baden",
"499152", "Hartenstein\ Mittelfranken",
"497265", "Angelbachtal",
"496766", "Kisselbach",
"499242", "Gössweinstein",
"49921", "Bayreuth",
"4933054", "Liebenwalde",
"4939862", "Schmölln\ bei\ Prenzlau",
"496395", "Münchweiler\ an\ der\ Rodalb",
"4939053", "Süplingen",
"497751", "Waldshut",
"492294", "Morsbach\ Sieg",
"498734", "Reisbach\ Niederbayern",
"495163", "Fallingbostel\-Dorfmark",
"496261", "Mosbach\ Baden",
"492324", "Hattingen\ Ruhr",
"498161", "Freising",
"4939362", "Grieben\ bei\ Tangerhütte",
"496558", "Büdesheim\ Eifel",
"4938201", "Gelbensande",
"497939", "Schrozberg\-Spielbach",
"494773", "Lamstedt",
"497256", "Philippsburg",
"497157", "Waldenbuch",
"498784", "Hohenthann",
"498745", "Bodenkirchen",
"494755", "Ihlienworth",
"4937292", "Oederan",
"497247", "Linkenheim\-Hochstetten",
"496773", "Kamp\-Bornhofen",
"4936621", "Elsterberg\ bei\ Plauen",
"495606", "Zierenberg",
"497391", "Ehingen\ Donau",
"494892", "Schenefeld\ Mittelholstein",
"497146", "Remseck\ am\ Neckar",
"4939205", "Langenweddingen",
"496755", "Odernheim\ am\ Glan",
"493578", "Kamenz",
"495429", "Melle\-Wellingholzhausen",
"495277", "Höxter\-Fürstenau",
"494261", "Rotenburg\ Wümme",
"499439", "Neunburg\-Kemnath",
"495176", "Edemissen",
"497726", "Bad\ Dürrheim",
"4936025", "Körner",
"494558", "Todesfelde",
"498548", "Vilshofen\-Sandbach",
"498394", "Lautrach",
"4939929", "Jabel\ bei\ Waren",
"492195", "Radevormwald",
"496735", "Eppelsheim",
"4933975", "Dannenwalde\ Kreis\ Prignitz",
"499182", "Velburg",
"497164", "Boll\ Kreis\ Göppingen",
"493733", "Annaberg\-Buchholz",
"4939456", "Altenbrak",
"4935055", "Höckendorf\ bei\ Dippoldiswalde",
"499777", "Ostheim\ von\ der\ Rhön",
"497959", "Frankenhardt",
"4933233", "Ketzin",
"497236", "Keltern",
"496029", "Mömbris",
"494735", "Butjadingen\-Stollhamm",
"492582", "Everswinkel",
"494474", "Garrel",
"492666", "Freilingen\ Westerwald",
"49991", "Deggendorf",
"499942", "Viechtach",
"498041", "Bad\ Tölz",
"499465", "Neukirchen\-Balbini",
"497130", "Löwenstein\ Württemberg",
"499421", "Straubing",
"492994", "Marsberg\-Westheim",
"497805", "Appenweier",
"495431", "Quakenbrück",
"497442", "Baiersbronn",
"497066", "Bad\ Rappenau\-Bonfeld",
"49741", "Rottweil",
"499307", "Altertheim",
"4939402", "Völpke",
"496474", "Villmar\-Aumenau",
"495472", "Bad\ Essen",
"496051", "Gelnhausen",
"4937437", "Bad\ Elster",
"497965", "Ellwangen\-Röhlingen",
"4936782", "Schmiedefeld\ am\ Rennsteig",
"492644", "Linz\ am\ Rhein",
"497240", "Pfinztal",
"492685", "Flammersfeld",
"494303", "Schlesen",
"4934298", "Taucha\ bei\ Leipzig",
"494769", "Bremervörde\-Iselersheim",
"498509", "Ruderting",
"496031", "Friedberg\ Hessen",
"497085", "Enzklösterle",
"496303", "Enkenbach\-Alsenborn",
"4939933", "Vollrathsruhe",
"497044", "Mönsheim",
"497150", "Korntal\-Münchingen",
"495074", "Rodewald",
"495451", "Ibbenbüren",
"494492", "Saterland",
"498702", "Wörth\ an\ der\ Isar",
"494562", "Grömitz",
"493622", "Waltershausen\ Thüringen",
"4938454", "Kritzkow",
"495829", "Wriedel",
"4938844", "Gülze",
"4937321", "Frankenstein\ Sachsen",
"492972", "Schmallenberg",
"4933366", "Chorin",
"4933838", "Päwesin",
"499527", "Knetzgau",
"493860", "Raben\ Steinfeld",
"4936845", "Gehlberg",
"4934386", "Dürrweitzschen\ bei\ Grimma",
"495494", "Holdorf\ Niedersachsen",
"495564", "Dassel",
"492931", "Arnsberg",
"498687", "Taching\-Tengling",
"496562", "Speicher",
"494665", "Emmelsbüll\-Horsbüll",
"494523", "Malente",
"494621", "Schleswig",
"499104", "Emskirchen",
"4933476", "Neuhardenberg",
"499674", "Schönsee",
"492951", "Büren",
"493561", "Guben",
"493663", "Schleiz",
"493525", "Riesa",
"493491", "Lutherstadt\ Wittenberg",
"4934363", "Cavertitz",
"4936206", "Grossfahner",
"497576", "Krauchenwies",
"4939955", "Jürgenstorf",
"496665", "Sinntal\-Altengronau",
"4935792", "Ossling",
"496523", "Holsthum",
"496094", "Weibersbrunn",
"4939384", "Arendsee\ Altmark",
"496621", "Bad\ Hersfeld",
"495546", "Scheden",
"4933452", "Neulewin",
"498178", "Icking",
"4938728", "Domsühl",
"497334", "Deggingen",
"494297", "Ottersberg\-Posthausen",
"497842", "Kappelrodeck",
"498649", "Schleching",
"49781", "Offenburg",
"496874", "Wadern\-Nunkirchen",
"499905", "Bernried\ Niederbayern",
"492504", "Telgte",
"497367", "Aalen\-Ebnat",
"495872", "Stoetze",
"493679", "Neuhaus\ am\ Rennweg",
"494874", "Todenbüttel",
"499865", "Adelshofen\ Mittelfranken",
"4936252", "Tambach\-Dietharz",
"498296", "Villenbach",
"496297", "Ravenstein\ Baden",
"496196", "Bad\ Soden\ am\ Taunus",
"496659", "Eichenzell",
"492736", "Burbach\ Siegerl",
"496341", "Landau\ in\ der\ Pfalz",
"495831", "Wittingen",
"4936764", "Neuhaus\-Schierschnitz",
"4939749", "Grambow\ bei\ Pasewalk",
"498372", "Obergünzburg",
"493867", "Lübstorf",
"493834", "Greifswald",
"496639", "Ottrau",
"495851", "Dahlenburg",
"493342", "Neuenhagen\ bei\ Berlin",
"49331", "Potsdam",
"499293", "Berg\ Oberfranken",
"497354", "Erolzheim",
"4935033", "Rosenthal\ Sächsische\ Schweiz",
"498331", "Memmingen",
"494639", "Schafflund",
"492747", "Molzhain",
"493907", "Gardelegen",
"492226", "Rheinbach",
"495383", "Lutter\ am\ Barenberge",
"4938225", "Trinwillershagen",
"498381", "Lindenberg\ im\ Allgäu",
"499323", "Iphofen",
"495826", "Suderburg",
"492721", "Lennestadt",
"495333", "Dettum",
"499836", "Gunzenhausen\-Cronheim",
"496843", "Gersheim",
"4933396", "Klosterfelde",
"4939004", "Köckte\ bei\ Gardelegen",
"494843", "Viöl",
"492568", "Heek",
"498630", "Oberneukirchen",
"4939221", "Möckern\ bei\ Magdeburg",
"492251", "Euskirchen",
"4936605", "Bad\ Köstritz",
"4938789", "Wolfshagen\ bei\ Perleberg",
"496327", "Neustadt\-Lachen",
"498326", "Fischen\ im\ Allgäu",
"499847", "Ergersheim",
"498650", "Marktschellenberg",
"494401", "Brake\ Unterweser",
"497345", "Langenau\ Württemberg",
"496401", "Grünberg\ Hessen",
"4935247", "Zehren\ Sachsen",
"4939035", "Kuhfelde",
"497384", "Schelklingen\-Hütten",
"497579", "Schwenningen\ Baden",
"4933602", "Alt\ Zeschdorf",
"495375", "Müden\ Aller",
"494327", "Grossenaspe",
"495353", "Königslutter\ am\ Elm",
"499856", "Dürrwangen",
"4935436", "Laasow\ bei\ Calau",
"492272", "Bedburg\ Erft",
"4938737", "Ganzlin",
"4933672", "Pfaffendorfb\ Beeskow",
"496647", "Herbstein\-Stockhausen",
"4939487", "Friedrichsbrunn",
"495508", "Gleichen\-Rittmarshausen",
"4939884", "Hassleben\ bei\ Prenzlau",
"4938422", "Neukloster",
"494320", "Heidmühlen",
"4933921", "Zechlinerhütte",
"497661", "Kirchzarten",
"497563", "Kisslegg",
"497625", "Zell\ im\ Wiesental",
"495705", "Petershagen\-Windheim",
"4933656", "Bahro",
"492739", "Wilnsdorf",
"498657", "Ramsau\ bei\ Berchtesgaden",
"496656", "Ebersburg",
"4936923", "Treffurt",
"498095", "Aying",
"498664", "Chieming",
"4936071", "Teistungen",
"496636", "Romrod",
"498637", "Lohkirchen",
"492759", "Bad\ Berleburg\-Aue",
"492981", "Winterberg\ Westfalen",
"499643", "Auerbach\ in\ der\ Oberpfalz",
"497522", "Wangen\ im\ Allgäu",
"4939423", "Wegeleben",
"494636", "Langballig",
"4935953", "Burkau",
"499205", "Vorbach",
"4934653", "Rottleberode",
"4933338", "Stolpe\/Oder",
"496293", "Schefflenz",
"492162", "Viersen",
"4938845", "Kaarssen",
"498193", "Geltendorf",
"4938455", "Plaaz",
"495308", "Lehre",
"4935342", "Mühlberg\ Elbe",
"495406", "Belm",
"497363", "Lauchheim",
"497709", "Wutach",
"4939451", "Wasserleben",
"4936454", "Magdala",
"494293", "Ottersberg\-Fischerhude",
"4936844", "Rohr\ Thüringen",
"4934956", "Zörbig",
"499639", "Mähring",
"498808", "Pähl",
"4938206", "Graal\-Müritz\ Seeheilbad",
"496865", "Mettlach\-Orscholz",
"496821", "Neunkirchen\ Saar",
"499196", "Wiesenttal",
"499659", "Leuchtenberg",
"499341", "Tauberbischofsheim",
"492743", "Daaden",
"494865", "Osterhever",
"494821", "Itzehoe",
"4935827", "Nieder\-Seifersdorf",
"497322", "Giengen\ an\ der\ Brenz",
"4939954", "Stavenhagen\ Reuterstadt",
"499874", "Neuendettelsau",
"493863", "Crivitz",
"4936626", "Auma",
"494674", "Ockholm",
"492596", "Nordkirchen",
"49201", "Essen",
"498581", "Waldkirchen\ Niederbayern",
"4939080", "Kalbe\ Milde",
"498683", "Tittmoning",
"499278", "Weidenberg",
"499665", "Königstein\ Oberpfalz",
"499523", "Hofheim\ in\ Unterfranken",
"499094", "Tagmersheim",
"499621", "Amberg\ Oberpfalz",
"494104", "Aumühle\ bei\ Hamburg",
"495533", "Bodenwerder",
"495631", "Korbach",
"498204", "Mickhausen",
"495102", "Laatzen",
"49761", "Freiburg\ im\ Breisgau",
"494859", "Windbergen",
"497642", "Endingen\ Kaiserstuhl",
"4933878", "Nennhausen",
"4939399", "Kleinau",
"496104", "Heusenstamm",
"496674", "Friedewald\ Hessen",
"492368", "Oer\-Erkenschwick",
"495672", "Bad\ Karlshafen",
"496527", "Oberweis",
"4934782", "Mansfeld\ Südharz",
"497748", "Grafenhausen\ Hochschwarzwald",
"492444", "Schleiden\-Gemünd",
"494839", "Wöhrden\ Dithmarschen",
"492485", "Schleiden\-Dreiborn",
"497128", "Sonnenbühl",
"499492", "Parsberg",
"499562", "Sonnefeld",
"497584", "Altshausen",
"497545", "Immenstaad\ am\ Bodensee",
"4935602", "Drebkau",
"494527", "Bosau",
"4937200", "Wittgensdorf\ bei\ Chemnitz",
"493634", "Sömmerda",
"4933088", "Falkenthal",
"4933762", "Zeuthen",
"4933436", "Prötzel",
"495553", "Kalefeld",
"495651", "Eschwege",
"497534", "Reichenau\ Baden",
"498268", "Tussenhausen",
"494541", "Ratzeburg",
"494643", "Gelting\ Angeln",
"498551", "Freyung",
"4939409", "Eilsleben",
"492304", "Schwerte",
"496205", "Hockenheim",
"4938224", "Gresenhorst",
"498105", "Gilching",
"497567", "Leutkirch\-Friesenhofen",
"4939601", "Friedland",
"4936604", "Münchenbernsdorf",
"495409", "Hilter\ am\ Teutoburger\ Wald",
"494205", "Ottersberg",
"497706", "Oberbaldingen",
"492435", "Erkelenz\-Lövenich",
"495626", "Bad\ Zwesten",
"4933632", "Hangelsberg",
"4934743", "Ermsleben",
"4939005", "Kusey",
"499636", "Plössberg",
"494168", "Neu\ Wulmstorf\-Elstorf",
"496541", "Traben\-Trarbach",
"496643", "Herbstein",
"492473", "Simmerath",
"498572", "Tann\ Niederbayern",
"492455", "Waldfeucht",
"499199", "Kunreuth",
"499656", "Moosbach\ bei\ Vohenstrauss",
"49351", "Dresden",
"493542", "Lübbenau\ Spreewald",
"497554", "Heiligenberg\ Baden",
"499647", "Kirchenthumbach",
"498633", "Tüssling",
"498531", "Pocking",
"4933746", "Werbig\ bei\ Jüterbog",
"4939034", "Fleetmark",
"495681", "Homberg\ Efze",
"495583", "Braunlage\-Hohegeiss",
"492599", "Ascheberg\-Herbern",
"499401", "Neutraubling",
"4935327", "Priessen",
"494362", "Heiligenhafen",
"496048", "Büdingen\-Eckartshausen",
"4939885", "Jakobshagen",
"497825", "Kippenheim",
"494847", "Oster\-Ohrstedt",
"496856", "St\ Wendel\-Niederkirchen",
"498857", "Benediktbeuern",
"4938794", "Cumlosen",
"4936737", "Drognitz",
"498846", "Uffing\ am\ Staffelsee",
"494856", "Kronprinzenkoog",
"495337", "Kissenbrück",
"495364", "Velpke",
"4936422", "Reinstädt\ Thüringen",
"493876", "Perleberg",
"496362", "Alsenz",
"494323", "Bornhöved",
"4935476", "Wittmannsdorf\-Bückchen",
"494836", "Hennstedt\ Dithmarschen",
"495448", "Barver",
"495357", "Grasleben",
"492774", "Dietzhölztal",
"4939341", "Redekin",
"498038", "Vogtareuth",
"497478", "Hirrlingen",
"493361", "Fürstenwalde\ Spree",
"4935383", "Elster\ Elbe",
"4939922", "Dambeck\ bei\ Röbel",
"497376", "Langenenslingen",
"499978", "Schönthal\ Oberpfalz",
"496323", "Edenkoben",
"4935452", "Golssen",
"496836", "Überherrn",
"499843", "Burgbernheim",
"495346", "Liebenburg",
"4935842", "Oderwitz",
"495191", "Soltau",
"498195", "Weil\ Kreis\ Landsberg\ am\ Lech",
"496295", "Rosenberg\ Baden",
"499867", "Geslau",
"492394", "Neuenrade\-Affeln",
"499834", "Theilenhofen",
"495824", "Bad\ Bodenteich",
"499342", "Wertheim",
"49931", "Würzburg",
"497321", "Heidenheim\ an\ der\ Brenz",
"494822", "Kellinghusen",
"497365", "Essingen\ Württemberg",
"496660", "Steinau\-Marjoss",
"499907", "Zenting",
"4938781", "Mellen",
"493886", "Gadebusch",
"494295", "Emtinghausen",
"4936256", "Wechmar",
"492161", "Mönchengladbach",
"498324", "Hindelang",
"494903", "Wymeer",
"492745", "Brachbach\ Sieg",
"4939934", "Gross\ Plasten",
"494863", "Sankt\ Peter\-Ording",
"497386", "Hayingen",
"4935267", "Diesbar\-Seusslitz",
"493865", "Holthusen",
"499854", "Wittelshofen",
"493821", "Ribnitz\-Damgarten",
"492548", "Dülmen\-Rorup",
"4933933", "Lindow\ Mark",
"498685", "Kirchanschöring",
"497202", "Karlsbad",
"4933362", "Liepe\ Kreis\ Barnim",
"495535", "Polle",
"499561", "Coburg",
"4938232", "Zingst\ Ostseebad",
"499663", "Neukirchen\ bei\ Sulzbach\-Rosenberg",
"499525", "Königsberg\ in\ Bayern",
"499491", "Hemau",
"492509", "Nottuln\-Appelhülsen",
"492924", "Möhnesee",
"4934382", "Nerchau",
"499148", "Ettenstatt",
"496654", "Gersfeld\ Rhön",
"4933205", "Michendorf",
"495652", "Bad\ Sooden\-Allendorf",
"499728", "Wülfershausen\ Unterfranken",
"492041", "Bottrop",
"4933472", "Golzow\ bei\ Seelow",
"498582", "Röhrnbach",
"4939975", "Thürkow",
"498666", "Teisendorf",
"496667", "Steinau\-Ulmbach",
"499622", "Hirschau\ Oberpfalz",
"4933929", "Gühlen\-Glienicke",
"496634", "Gemünden\ Felda",
"4935698", "Hornow",
"495632", "Willingen\ Upland",
"495101", "Pattensen",
"494634", "Husby",
"4936202", "Neudietendorf",
"497641", "Emmendingen",
"497543", "Kressbronn\ am\ Bodensee",
"4933456", "Wriezen",
"499238", "Röslau",
"4933846", "Dippmannsdorf",
"495555", "Moringen\-Fredelsloh",
"4933234", "Wustermark",
"4935796", "Panschwitz\-Kuckau",
"495228", "Vlotho\-Exter",
"495671", "Hofgeismar",
"495573", "Uslar\-Volpriehausen",
"494667", "Dagebüll",
"494684", "Langeness\ Hallig",
"4933676", "Friedland\ bei\ Beeskow",
"498571", "Simbach\ am\ Inn",
"495707", "Petershagen\ Weser",
"499288", "Bad\ Steben",
"497627", "Steinen\ Kreis\ Lörrach",
"4938426", "Neuburg\-Steinhausen",
"493541", "Calau",
"496203", "Ladenburg",
"492828", "Emmerich\-Elten",
"493643", "Weimar\ Thüringen",
"4934925", "Bad\ Schmiedeberg",
"492433", "Hückelhoven",
"498532", "Griesbach\ im\ Rottal",
"494203", "Weyhe\ bei\ Bremen",
"4935204", "Wilsdruff",
"496684", "Hofbieber\-Schwarzbach",
"497340", "Neenstetten",
"496645", "Ulrichstein",
"4933652", "Neuzelle",
"495682", "Borken\ Hessen",
"4935021", "Königstein\ Sächsische\ Schweiz",
"492453", "Heinsberg\-Randerath",
"499106", "Markt\ Erlbach",
"4934673", "Heldrungen",
"499207", "Königsfeld\ Oberfranken",
"498552", "Grafenau\ Niederbayern",
"49451", "Lübeck",
"494542", "Mölln\ Lauenburg",
"4935973", "Stolpen",
"4934343", "Regis\-Breitingen",
"4938377", "Zinnowitz",
"499676", "Winklarn",
"497574", "Gammertingen",
"498635", "Pleiskirchen",
"4933053", "Zehlendorf\ Kreis\ Oberhavel",
"497389", "Heroldstatt",
"4937329", "Grosshartmannsdorf",
"495544", "Reinhardshagen",
"4939054", "Flechtingen",
"495585", "Herzberg\-Sieber",
"49651", "Trier",
"496542", "Bullay",
"496096", "Wiesen\ Unterfranken",
"494194", "Sievershütten",
"497823", "Seelbach\ Schutter",
"493847", "Sternberg",
"497336", "Lonsee",
"499938", "Moos\ Niederbayern",
"493362", "Erkner",
"496876", "Weiskirchen\ Saar",
"492506", "Münster\-Wolbeck",
"4934603", "Nauendorf\ Sachsen\-Anhalt",
"494876", "Reher\ Holstein",
"492734", "Freudenberg\ Westfalen",
"4936744", "Remda",
"4939741", "Jatznick",
"495192", "Munster",
"4938307", "Poseritz",
"498294", "Horgau",
"4936337", "Schiedungen",
"4933708", "Rangsdorf",
"499402", "Regenstauf",
"495377", "Ehra\-Lessien",
"494361", "Oldenburg\ in\ Holstein",
"498669", "Traunreut",
"492754", "Bad\ Laasphe\-Feudingen",
"493836", "Wolgast",
"497347", "Dietenheim",
"497458", "Ebhausen",
"4933606", "Müllrose",
"4935727", "Burghammer",
"497356", "Schemmerhofen",
"499845", "Oberdachstetten",
"497620", "Schopfheim\-Gersbach",
"496325", "Lambrecht\ Pfalz",
"492224", "Bad\ Honnef",
"496361", "Rockenhausen",
"494622", "Taarstedt",
"496238", "Dirmstein",
"4936781", "Grossbreitenbach",
"492306", "Lünen",
"493686", "Eisfeld",
"4938328", "Miltzow",
"498138", "Schwabhausen\ bei\ Dachau",
"492952", "Rüthen",
"493562", "Forst\ Lausitz",
"494238", "Neddenaverbergen",
"497704", "Geisingen\ Baden",
"492408", "Aachen\-Kornelimünster",
"496622", "Bebra",
"4936940", "Oepfershausen",
"499634", "Wiesau",
"495624", "Bad\ Emstal",
"498248", "Lamerdingen",
"494258", "Schwarme",
"494561", "Neustadt\ in\ Holstein",
"494663", "Süderlügum",
"494525", "Ahrensbök",
"494491", "Friesoythe",
"499654", "Pleystein",
"493523", "Coswig\ bei\ Dresden",
"493621", "Gotha\ Thüringen",
"492971", "Schmallenberg\-Dorlar",
"496728", "Ober\-Hilbersheim",
"4934906", "Raguhn",
"4939401", "Neuwegersleben",
"4935606", "Briesen\ bei\ Cottbus",
"497556", "Uhldingen\-Mühlhofen",
"496258", "Gernsheim",
"4933432", "Müncheberg",
"496561", "Bitburg",
"4939997", "Jarmen",
"496663", "Steinau\ an\ der\ Strasse",
"496525", "Irrel",
"498158", "Tutzing",
"494148", "Drochtersen\-Assel",
"4933766", "Teupitz",
"492932", "Neheim\-Hüsten",
"495468", "Bramsche\-Engter",
"4934976", "Gröbzig",
"496854", "Oberthal\ Saar",
"494109", "Tangstedt\ Bz\ Hamburg",
"493341", "Strausberg",
"495852", "Bleckede",
"499099", "Kaisheim",
"499903", "Schöllnach",
"494854", "Friedrichskoog",
"4939349", "Parey\ Elbe",
"4936023", "Horsmar",
"496109", "Frankfurt\-Bergen\-Enkheim",
"4933204", "Beelitz\ Mark",
"498332", "Ottobeuren",
"497403", "Dunningen",
"4939203", "Barleben",
"493874", "Ludwigslust",
"495366", "Jembke",
"494834", "Büsum",
"492449", "Blankenheim\ Ahr",
"4938202", "Volkenshagen",
"4933973", "Zernitz\ bei\ Neustadt\ Dosse",
"496068", "Beerfelden",
"4936087", "Wüstheuterode",
"494342", "Preetz\ Kreis\ Plön",
"49431", "Kiel",
"497841", "Achern",
"492776", "Bad\ Endbach\-Hartenrod",
"4939361", "Lüderitz",
"497374", "Uttenweiler",
"4933235", "Friesack",
"499295", "Töpen",
"496867", "Perl",
"4935053", "Glashütte\ Sachsen",
"496834", "Bous",
"4936622", "Triebes",
"4937291", "Augustusburg",
"499822", "Bechhofen\ an\ der\ Heide",
"495344", "Lengede",
"495832", "Hankensbüttel",
"496342", "Schweigen\-Rechtenbach",
"49631", "Kaiserslautern",
"495335", "Schladen",
"494402", "Rastede",
"4935362", "Schönewalde\ bei\ Herzberg",
"495882", "Gorleben",
"499325", "Kleinlangheim",
"492763", "Drolshagen\-Bleche",
"492309", "Waltrop",
"492232", "Brühl\ Rheinland",
"494958", "Jemgum",
"494884", "Schwabstedt",
"496402", "Hungen",
"4937463", "Bergen\ Vogtland",
"494845", "Ostenfeld\ Husum",
"495404", "Westerkappeln",
"4935205", "Ottendorf\-Okrilla",
"492271", "Bergheim\ Erft",
"4936426", "Ottendorf\ bei\ Stadtroda",
"493843", "Güstrow",
"4939861", "Gramzow\ bei\ Prenzlau",
"492628", "Rhens",
"4934924", "Zahna",
"494938", "Hagermarsch",
"49211", "Düsseldorf",
"4939459", "Hasselfelde",
"4935472", "Schlepzig",
"498382", "Lindau\ Bodensee",
"492722", "Attendorn",
"499194", "Ebermannstadt",
"498670", "Reischach\ Kreis\ Altötting",
"493327", "Werder\ Havel",
"4939926", "Grabowhöfe",
"497343", "Buch\ bei\ Illertissen",
"4936647", "Saalburg\ Thüringen",
"496004", "Lich\-Eberstadt",
"4939055", "Hörsingen",
"495355", "Frellstedt",
"4935456", "Terpt",
"4936377", "Rastenberg",
"495373", "Hillerse\ Kreis\ Gifhorn",
"499876", "Rohr\ Mittelfranken",
"492252", "Zülpich",
"492594", "Dülmen",
"4938757", "Neustadt\-Glewe",
"492464", "Aldenhoven\ bei\ Jülich",
"494106", "Quickborn\ Kreis\ Pinneberg",
"494207", "Oyten",
"49951", "Bamberg",
"499542", "Schesslitz",
"492982", "Medebach",
"497565", "Aichstetten\ Kreis\ Ravensburg",
"497623", "Rheinfelden\ Baden",
"496106", "Rodgau",
"498206", "Egling\ an\ der\ Paar",
"496207", "Wald\-Michelbach",
"493647", "Pössneck",
"4934223", "Dommitzsch",
"495703", "Hille",
"496676", "Hohenroda\ Hessen",
"498677", "Burghausen\ Salzach",
"4933636", "Steinhöfel\ Kreis\ Oder\-Spree",
"494288", "Horstedt\ Kreis\ Rotenburg",
"492446", "Heimbach\ Eifel",
"498093", "Glonn\ Kreis\ Ebersberg",
"499645", "Eschenbach\ in\ der\ Oberpfalz",
"492779", "Greifenstein\-Beilstein",
"4939391", "Lückstedt",
"497586", "Herbertingen",
"498869", "Kinsau",
"497662", "Vogtsburg\ im\ Kaiserstuhl",
"4935892", "Horka\ OL",
"493636", "Greussen",
"4935933", "Neschwitz",
"4933742", "Oehna\ Brandenburg",
"499203", "Neudrossenfeld",
"4934633", "Braunsbedra",
"4938828", "Schönberg",
"492572", "Emsdetten",
"494484", "Hude\-Wüsting",
"494445", "Visbek\ Kreis\ Vechta",
"496802", "Völklingen\-Lauterbach",
"497033", "Weil\ Der\ Stadt",
"495804", "Rätzlingen\ Kreis\ Uelzen",
"494962", "Papenburg\-Aschendorf",
"497427", "Schömberg\ bei\ Balingen",
"4936072", "Weissenborn\-Lüderode",
"493443", "Weissenfels\ Sachsen\-Anhalt",
"4938793", "Dergenthin",
"4989", "Munich",
"4936925", "Marksuhl",
"492633", "Brohl\-Lützing",
"495964", "Lähden",
"4933369", "Oderberg",
"496484", "Beselich",
"496445", "Schöffengrund",
"494802", "Wrohm",
"495937", "Geeste\-Gross\ Hesepe",
"495482", "Tecklenburg",
"495696", "Bad\ Arolsen\-Landau",
"492850", "Rees\-Haldern",
"495159", "Coppenbrügge\-Bisperode",
"499927", "Kirchberg\ Wald",
"499749", "Oberbach\ Unterfranken",
"493925", "Stassfurt",
"492551", "Steinfurt\-Burgsteinfurt",
"493961", "Altentreptow",
"492653", "Kaisersesch",
"4936209", "Klettbach",
"492675", "Ediger\-Eller",
"492268", "Kürten",
"499129", "Wendelstein",
"4933671", "Lieberose",
"495957", "Lindern\ Oldenburg",
"4937347", "Bärenstein\ Kreis\ Annaberg",
"495139", "Burgwedel",
"494923", "Krummhörn\-Pewsum",
"498304", "Wildpoldsried",
"49214", "Leverkusen",
"4933479", "Küstrin\-Kietz",
"4935026", "Dürrröhrsdorf\-Dittersbach",
"498435", "Ehekirchen",
"495946", "Georgsdorf",
"4935384", "Steinsdorf\ bei\ Jessen",
"499378", "Eichenbühl\-Riedern",
"497053", "Bad\ Teinach\-Zavelstein",
"4935955", "Pulsnitz",
"4933922", "Karwesee",
"495045", "Springe\-Bennigsen",
"495084", "Hambühren",
"497976", "Sulzbach\-Laufen",
"496082", "Niederreifenberg",
"4939425", "Dingelstedt\ am\ Huy",
"492529", "Oelde\-Stromberg",
"499505", "Litzendorf",
"492904", "Bestwig",
"493744", "Auerbach\ Vogtland",
"4938223", "Saal\ Vorpom",
"498774", "Bayerbach\ bei\ Ergoldsbach",
"497222", "Rastatt",
"499151", "Hersbruck",
"499241", "Pegnitz",
"4936603", "Weida",
"4937607", "Ebersbrunn\ Sachsen",
"496783", "Baumholder",
"499708", "Bad\ Bocklet",
"492864", "Reken",
"493588", "Niesky",
"499397", "Wertheim\-Dertingen",
"492837", "Weeze",
"495186", "Salzhemmendorf\-Wallensen",
"4933601", "Podelzig",
"499602", "Neustadt\ an\ der\ Waldnaab",
"494393", "Boostedt",
"498469", "Freystadt\-Burggriesbach",
"492857", "Rees\-Mehr",
"493395", "Pritzwalk",
"497732", "Radolfzell\ am\ Bodensee",
"497263", "Waibstadt",
"499920", "Bischofsmais",
"499172", "Georgensgmünd",
"4936968", "Rossdorf\ Rhön",
"4939222", "Möser",
"495741", "Lübbecke",
"495208", "Leopoldshöhe",
"4939746", "Krackow",
"492058", "Wülfrath",
"495165", "Rethem\ Aller",
"495121", "Hildesheim",
"497771", "Stockach",
"497420", "Deisslingen",
"4939033", "Wallstawe",
"496393", "Fischbach\ bei\ Dahn",
"499131", "Erlangen",
"495246", "Verl",
"498123", "Moosinning",
"493773", "Johanngeorgenstadt",
"496223", "Neckargemünd",
"495147", "Uetze\-Hänigsen",
"499764", "Höchheim",
"496578", "Salmtal",
"499737", "Wartmannsroth",
"498743", "Geisenhausen",
"497276", "Herxheim\ bei\ Landau\ Pfalz",
"4937208", "Auerswalde",
"494753", "Balje",
"4933080", "Marienthal\ Kreis\ Oberhavel",
"494775", "Grossenwörden",
"499181", "Neumarkt\ in\ der\ Oberpfalz",
"496753", "Meisenheim",
"496775", "Strüth\ Taunus",
"495257", "Hövelhof",
"495156", "Coppenbrügge",
"494223", "Ganderkesee\-Bookholzberg",
"4934328", "Hartha\ bei\ Döbeln",
"496262", "Aglasterhausen",
"499746", "Zeitlofs",
"492193", "Dabringhausen",
"496733", "Gau\-Odernheim",
"495264", "Kalletal",
"4933870", "Zollchow\ bei\ Rathenow",
"499126", "Eckental",
"4935439", "Zinnitz",
"495237", "Augustdorf",
"495136", "Burgdorf\ Kreis\ Hannover",
"499227", "Neuenmarkt",
"495060", "Bodenburg",
"4939088", "Letzlingen",
"497392", "Laupheim",
"493735", "Marienberg\ Sachsen",
"494262", "Visselhövede",
"494733", "Butjadingen\-Burhave",
"4939247", "Güterglück",
"494454", "Jade",
"498444", "Schweitenkirchen",
"495067", "Bockenem",
"492526", "Sendenhorst",
"495908", "Wietmarschen\-Lohne",
"497803", "Gengenbach",
"495034", "Neustadt\-Hagen",
"499463", "Wald\ Oberpfalz",
"496032", "Bad\ Nauheim",
"4933451", "Heckelberg",
"4933841", "Belzig",
"496454", "Lichtenfels\-Sachsenberg",
"4936453", "Mellingen",
"4936843", "Benshausen",
"499220", "Kasendorf\-Azendorf",
"497963", "Adelmannsfelden",
"496071", "Dieburg",
"495452", "Mettingen\ Westfalen",
"499941", "Kötzting",
"493303", "Birkenwerder",
"492683", "Asbach\ Westerwald",
"492581", "Warendorf",
"496597", "Jünkerath",
"498466", "Denkendorf\ Oberbayern",
"498042", "Lenggries",
"4937322", "Brand\-Erbisdorf",
"496467", "Hatzfeld\ Eder",
"496434", "Bad\ Camberg",
"499422", "Bogen\ Niederbayern",
"495432", "Löningen",
"494305", "Westensee",
"49228", "Bonn",
"495250", "Delbrück\ Westfalen",
"494434", "Colnrade",
"4934202", "Delitzsch",
"497083", "Bad\ Herrenalb",
"492204", "Bensberg",
"496305", "Hochspeyer",
"4939953", "Schwinkendorf",
"497441", "Freudenstadt",
"495054", "Bergen\-Sülze",
"498368", "Halblech",
"494467", "Wittmund\-Funnix",
"495471", "Bohmte",
"496052", "Bad\ Orb",
"495283", "Lügde\-Rischenau",
"4939342", "Gladau",
"494920", "Wirdum",
"492833", "Kerken",
"494172", "Salzhausen",
"496787", "Niederbrombach",
"498231", "Königsbrunn\ bei\ Augsburg",
"4939883", "Gross\ Dölln",
"494602", "Freienwill",
"499393", "Rothenfels\ Unterfranken",
"497254", "Waghäusel",
"496131", "Mainz",
"497144", "Marbach\ am\ Neckar",
"4934467", "Eckartsberga",
"4935841", "Grossschönau\ Sachsen",
"4935451", "Dahme\ Brandenburg",
"495604", "Grossalmerode",
"494131", "Lüneburg",
"497724", "St\ Georgen\ im\ Schwarzwald",
"495174", "Lahstedt",
"498272", "Wertingen",
"4934426", "Kayna",
"496172", "Bad\ Homburg\ von\ der\ Höhe",
"4936924", "Mihla",
"492428", "Niederzier",
"4939921", "Ankershagen",
"493601", "Mühlhausen\ Thüringen",
"492381", "Hamm\ Westfalen",
"496241", "Worms",
"496708", "Bad\ Münster\ am\ Stein\-Ebernburg",
"498141", "Fürstenfeldbruck",
"494151", "Schwarzenbek",
"496397", "Leimen\ Pfalz",
"498765", "Bruckberg\ Niederbayern",
"494505", "Stockelsdorf\-Curau",
"498721", "Eggenfelden",
"4936421", "Camburg",
"497267", "Gemmingen",
"4939424", "Schwanebeck\ Sachsen\-Anhalt",
"492853", "Schermbeck",
"4938209", "Sanitz\ bei\ Rostock",
"496505", "Kordel",
"497166", "Adelberg",
"498251", "Aichach",
"4935954", "Grossharthau",
"494241", "Bassum",
"4934654", "Stolberg\ Harz",
"4935385", "Annaburg",
"4939827", "Schwarz\ bei\ Neustrelitz",
"494708", "Ringstedt",
"492630", "Mülheim\-Kärlich",
"497234", "Tiefenbronn",
"496151", "Darmstadt",
"494129", "Haseldorf",
"495933", "Lathen",
"4939396", "Neukirchen\ Altmark",
"497260", "Sinsheim\-Hilsbach",
"499923", "Teisnach",
"492664", "Rennerod",
"494749", "Schiffdorf\-Geestenseth",
"492637", "Weissenthurm",
"4930", "Berlin",
"499082", "Oettingen\ in\ Bayern",
"497838", "Nordrach",
"497423", "Oberndorf\ am\ Neckar",
"4939003", "Jübar",
"493447", "Altenburg\ Thüringen",
"4934745", "Winningen\ Sachsen\-Anhalt",
"496129", "Schlangenbad",
"496476", "Mengerskirchen",
"492646", "Königsfeld\ Eifel",
"499962", "Schwarzach\ Niederbayern",
"498025", "Miesbach",
"493338", "Bernau\ Brandenburg",
"498061", "Bad\ Aibling",
"499484", "Brennberg",
"499445", "Neustadt\ an\ der\ Donau",
"4933439", "Fredersdorf\-Vogelsdorf",
"495953", "Börger",
"499802", "Ansbach\-Katterbach",
"4933631", "Bad\ Saarow\-Pieskow",
"495975", "Rheine\-Mesum",
"494927", "Krummhörn\-Loquard",
"497462", "Immendingen",
"497046", "Zaberfeld",
"492657", "Uersfeld",
"4939602", "Kleeth",
"497945", "Wüstenrot",
"494422", "Sande\ Kreis\ Friesl",
"497967", "Jagstzell",
"499305", "Estenfeld",
"494941", "Aurich",
"4934781", "Greifenhagen",
"497934", "Weikersheim",
"497807", "Neuried\ Ortenaukreis",
"4934497", "Langenleuba\-Niederhain",
"492608", "Welschneudorf",
"499467", "Michelsneukirchen",
"499434", "Bodenwöhr",
"496422", "Kirchhain",
"495424", "Bad\ Rothenfelde",
"4934901", "Rosslau\ Elbe",
"4939406", "Harbke",
"495063", "Bad\ Salzdetfurth",
"4935601", "Peitz",
"49391", "Magdeburg",
"494463", "Wangerland",
"499454", "Aufhausen\ Oberpfalz",
"493421", "Torgau",
"496220", "Wilhelmsfeld",
"499071", "Dillingen\ an\ der\ Donau",
"493307", "Zehdenick",
"492687", "Horhausen\ Westerwald",
"495022", "Wietzen",
"496593", "Hillesheim\ Eifel",
"496024", "Schöllkrippen",
"497954", "Kirchberg\ an\ der\ Jagst",
"496691", "Schwalmstadt",
"494126", "Horst\ Holstein",
"495253", "Bad\ Driburg",
"4939366", "Kehnert",
"492372", "Hemer",
"494479", "Molbergen\-Peheim",
"495275", "Höxter\-Ottbergen",
"494746", "Hagen\ bei\ Bremerhaven",
"4938453", "Mistorf",
"498756", "Nandlstadt",
"496757", "Becherbach\ bei\ Kirn",
"4938843", "Bennin",
"497245", "Durmersheim",
"492680", "Mündersbach",
"4938720", "Grebbin",
"4939327", "Klietz",
"499262", "Wallenfels",
"496746", "Pfalzfeld",
"494757", "Wanna",
"492331", "Hagen\ Westfalen",
"499733", "Münnerstadt",
"4937296", "Stollberg\ Erzgebirge",
"495723", "Bad\ Nenndorf",
"497173", "Heubach",
"496126", "Idstein",
"496479", "Waldbrunn\ Westerwald",
"498226", "Bibertal",
"495143", "Winsen\ Aller",
"496227", "Walldorf\ Baden",
"494737", "Stadland\-Schwei",
"492351", "Lüdenscheid",
"497135", "Brackenheim",
"4935341", "Bad\ Liebenwerda",
"499775", "Schönau\ an\ der\ Brend",
"494181", "Buchholz\ in\ der\ Nordheide",
"498504", "Tittling",
"494764", "Gnarrenburg\-Klenkendorf",
"4934364", "Wermsdorf",
"495233", "Steinheim\ Westfalen",
"4939452", "Ilsenburg",
"499223", "Rugendorf",
"496764", "Rheinböllen",
"496737", "Köngernheim",
"498281", "Thannhausen\ Schwaben",
"4939383", "Sandau\ Elbe",
"4933830", "Ziesar",
"496181", "Hanau",
"492296", "Reichshof\-Brüchermühle",
"495201", "Halle\ Westfalen",
"4933638", "Rüdersdorf\ bei\ Berlin",
"495128", "Hohenhameln",
"492051", "Velbert",
"494666", "Ladelund",
"4938374", "Lassan\ bei\ Wolgast",
"492474", "Nideggen\-Schmidt",
"4936041", "Bad\ Tennstedt",
"495545", "Hedemünden",
"495584", "Hattorf\ am\ Harz",
"4936375", "Kindelbrück",
"495379", "Sassenburg\-Grussendorf",
"496666", "Freiensteinau",
"498667", "Seeon\-Seebruck",
"496582", "Freudenburg",
"497575", "Messkirch",
"498634", "Garching\ an\ der\ Alz",
"497553", "Salem\ Baden",
"497651", "Titisee\-Neustadt",
"4936645", "Mühltroff",
"4939057", "Rätzlingen\ Sachsen\-Anhalt",
"4934299", "Gaschwitz",
"4938464", "Bernitt",
"493581", "Görlitz",
"493683", "Schmalkalden",
"492303", "Unna",
"499701", "Sandberg\ Unterfranken",
"4938826", "Dassow",
"494644", "Karby",
"498654", "Freilassing",
"497533", "Allensbach",
"497631", "Müllheim\ Baden",
"4935207", "Moritzburg",
"496644", "Grebenhain",
"49561", "Kassel",
"495642", "Warburg\-Scherfede",
"4936465", "Oberndorf\ bei\ Apolda",
"499158", "Offenhausen\ Mittelfranken",
"497672", "St\ Blasien",
"492755", "Bad\ Berleburg\-Schwarzenau",
"497387", "Hohenstein\ Württemberg",
"4936428", "Stadtroda",
"492773", "Haiger",
"4936334", "Wolkramshausen",
"499371", "Miltenberg",
"494324", "Brokstedt",
"492558", "Horstmar",
"495322", "Bad\ Harzburg",
"493968", "Schönbeck",
"499844", "Obernzenn",
"496324", "Hassloch",
"4933920", "Walsleben\ bei\ Neuruppin",
"492261", "Gummersbach",
"499332", "Marktbreit",
"4935724", "Lohsa",
"499209", "Emtmannsberg",
"492225", "Meckenheim\ Rheinland",
"49395", "Neubrandenburg",
"492538", "Drensteinfurt\-Rinkerode",
"499352", "Lohr\ am\ Main",
"499906", "Mariaposching",
"494195", "Hartenholm",
"497308", "Nersingen",
"4939928", "Möllenhagen",
"4938755", "Eldena",
"496195", "Kelkheim\ Taunus",
"492735", "Neunkirchen\ Siegerl",
"4939751", "Penkun",
"495363", "Wolfsburg\-Vorsfelde",
"498295", "Altenmünster\ Schwaben",
"4938304", "Garz\ Rügen",
"497629", "Tegernau\ Baden",
"498822", "Oberammergau",
"493529", "Heidenau\ Sachsen",
"493904", "Haldensleben",
"492744", "Herdorf",
"497448", "Seewald",
"497357", "Attenweiler",
"4937320", "Mulda\ Sachsen",
"498361", "Nesselwang",
"498325", "Oberstaufen\-Thalkirchdorf",
"492588", "Harsewinkel\-Greffen",
"4935264", "Strehla",
"499855", "Dentlein\ am\ Forst",
"499948", "Eschlkam",
"499873", "Abenberg\-Wassermungenau",
"495376", "Wesendorf\ Kreis\ Gifhorn",
"496669", "Neuhof\-Hauswurz",
"4939995", "Nossendorf",
"4935752", "Ruhland",
"4939779", "Eggesin",
"4934241", "Jesewitz",
"497346", "Illerkirchberg",
"4934978", "Radegast\ Kreis\ Köthen",
"497191", "Backnang",
"499835", "Ehingen\ Mittelfranken",
"499382", "Gerolzhofen",
"495825", "Wieren",
"494877", "Hennstedt\ bei\ Itzehoe",
"495861", "Dannenberg\ Elbe",
"495292", "Lichtenau\-Atteln",
"498194", "Vilgertshofen",
"496294", "Krautheim\ Jagst",
"492395", "Finnentrop\-Rönkhausen",
"496078", "Gross\-Umstadt",
"494294", "Riede\ Kreis\ Verden",
"495901", "Fürstenau\ bei\ Bramsche",
"497337", "Nellingen\ Alb",
"4939831", "Feldberg",
"4937433", "Gutenfürst",
"497364", "Oberkochen",
"492507", "Havixbeck",
"496635", "Kirtorf",
"492443", "Mechernich",
"4933872", "Hohennauen",
"4936085", "Reinholterode",
"49851", "Passau",
"494552", "Leezen",
"498542", "Ortenburg",
"499107", "Trautskirchen",
"495554", "Moringen",
"493531", "Finsterwalde",
"496552", "Olzheim",
"499206", "Mistelgau\-Obernsees",
"4938326", "Grimmen",
"494635", "Sörup",
"497681", "Waldkirch\ Breisgau",
"4933237", "Paulinenaue",
"496898", "Völklingen",
"497583", "Bad\ Schussenried",
"499677", "Oberviechtach\-Pullenried",
"493675", "Sonneberg\ Thüringen",
"4936875", "Straufhain\-Streufdorf",
"494103", "Wedel",
"495534", "Eschershausen\ an\ der\ Lenne",
"492961", "Brilon",
"496532", "Zeltingen\-Rachtig",
"499093", "Polsingen",
"499524", "Zeil\ am\ Main",
"4933768", "Prieros",
"492925", "Warstein\-Allagen",
"4933082", "Menz\ Kreis\ Oberhavel",
"498684", "Fridolfing",
"4935608", "Gross\ Ossnig",
"494673", "Joldelund",
"496655", "Neuhof\ Kreis\ Fulda",
"4934443", "Teuchern",
"499869", "Wettringen\ Mittelfranken",
"496571", "Wittlich",
"495706", "Porta\ Westfalica",
"496673", "Haunetal",
"492801", "Xanten",
"497626", "Kandern",
"496103", "Langen\ Hessen",
"4938874", "Lützow",
"498203", "Grossaitingen",
"499188", "Postbauer\-Heng",
"494532", "Bargteheide",
"499195", "Adelsdorf\ Mittelfranken",
"4938375", "Koserow",
"493372", "Jüterbog",
"498867", "Rottenbuch\ Oberbayern",
"496866", "Perl\-Nennig",
"4935872", "Neusalza\-Spremberg",
"4939859", "Fürstenwerder",
"492182", "Grevenbroich\-Kapellen",
"497851", "Kehl",
"498342", "Marktoberdorf",
"49831", "Kempten\ Allgäu",
"494352", "Damp",
"495354", "Jerxheim",
"4936644", "Hirschberg\ Saale",
"496352", "Kirchheimbolanden",
"4939600", "Zwiedorf",
"493331", "Angermünde",
"4933963", "Wulfersdorf\ bei\ Wittstock",
"4936961", "Bad\ Liebenstein",
"4936374", "Weissensee",
"497383", "Münsingen\-Buttenhausen",
"492777", "Breitscheid\ Hessen",
"495334", "Hornburg\ Kreis\ Wolfenbüttel",
"496844", "Blieskastel\-Altheim",
"499324", "Dettelbach",
"4936949", "Obermassfeld\-Grimmenthal",
"496332", "Zweibrücken",
"495842", "Schnega",
"496209", "Mörlenbach",
"49581", "Uelzen",
"4933608", "Jacobsdorf\ Mark",
"4933986", "Falkenhagen\ Kreis\ Prignitz",
"495367", "Rühen",
"498679", "Burgkirchen\ an\ der\ Alz",
"494371", "Burg\ auf\ Fehmarn",
"493883", "Hagenow",
"4936464", "Wormstedt",
"496371", "Landstuhl",
"4934927", "Globig\-Bleddin",
"494885", "Bergenhusen",
"494844", "Pellworm",
"497831", "Hausach",
"494332", "Hamdorf\ bei\ Rendsburg",
"495405", "Hasbergen\ Kreis\ Osnabrück",
"494209", "Schwanewede",
"493329", "Stahnsdorf",
"499644", "Pressath",
"497557", "Herdwangen\-Schönach",
"4936335", "Grosswechsungen",
"494248", "Bassum\-Neubruchhausen",
"498258", "Sielenbach",
"492692", "Kelberg",
"492486", "Nettersheim",
"496158", "Riedstadt",
"498561", "Pfarrkirchen\ Niederbayern",
"498663", "Ruhpolding",
"492388", "Hamm\-Uentrop",
"494158", "Roseburg",
"4938428", "Hohenkirchen\ bei\ Wismar",
"496701", "Sprendlingen\ Rheinhessen",
"4938334", "Grammendorf",
"4935725", "Wittichenau",
"498728", "Geratskirchen",
"4933678", "Storkow\ Mark",
"4939263", "Unseburg",
"497546", "Oberteuringen",
"4933332", "Gartz\ Oder",
"4938754", "Leussow\ bei\ Ludwigslust",
"494138", "Betzendorf\ Kreis\ Lüneburg",
"492942", "Geseke",
"49291", "Meschede",
"499666", "Illschwang",
"498622", "Tacherting\-Peterskirchen",
"492770", "Eschenburg",
"4934773", "Schwittersdorf",
"492421", "Düren",
"492595", "Olfen",
"492465", "Inden",
"498860", "Bernbeuren",
"4938305", "Gingst",
"497564", "Bad\ Wurzach",
"498238", "Gessertshausen",
"496138", "Mommenheim",
"492307", "Kamen",
"499655", "Tännesberg",
"499571", "Lichtenfels\ Bayern",
"496869", "Merzig\-Silwingen",
"499673", "Tiefenbach\ Oberpfalz",
"497587", "Hosskirch",
"493996", "Teterow",
"492456", "Selfkant",
"499103", "Cadolzburg",
"496188", "Kahl\ am\ Main",
"494524", "Scharbeutz\-Pönitz",
"4933832", "Rogäsen",
"495522", "Osterode\ am\ Harz",
"492358", "Meinerzhagen\-Valbert",
"492447", "Dahlem\ bei\ Kall",
"494188", "Welle\ Nordheide",
"499532", "Maroldsweisach",
"496093", "Laufach",
"496524", "Rodershausen",
"4939994", "Metschow",
"4939723", "Krien",
"4935265", "Glaubitz",
"498106", "Vaterstetten",
"496107", "Kelsterbach",
"4933458", "Falkenberg\ Mark",
"4938722", "Raduhn",
"4933848", "Raben",
"492338", "Breckerfeld",
"498207", "Affing",
"499552", "Burghaslach",
"496206", "Lampertheim",
"496677", "Neuenstein\ Hessen",
"499635", "Bärnau",
"4935696", "Briesnig",
"495625", "Naumburg\ Hessen",
"495493", "Neuenkirchen\ Kreis\ Vechta",
"495661", "Melsungen",
"495563", "Kreiensen",
"494107", "Siek\ Kreis\ Stormarn",
"492436", "Wegberg\-Rödgen",
"497705", "Wolterdingen\ Schwarzw",
"499097", "Marxheim",
"494206", "Stuhr\-Heiligenrode",
"4939081", "Kakerbeck\ Sachsen\-Anhalt",
"4936084", "Heuthen",
"4936258", "Friemar",
"4937363", "Zöblitz",
"499090", "Rain\ Lech",
"494835", "Albersdorf\ Holstein",
"492152", "Kempen",
"494382", "Wangels",
"496698", "Schrecksbach",
"4939977", "Jördenstorf",
"496835", "Beckingen",
"495384", "Seesen\-Gross\ Rhüden",
"495345", "Baddeckenstedt",
"496382", "Lauterecken",
"49221", "Cologne",
"492242", "Hennef\ Sieg",
"497375", "Obermarchtal",
"496670", "Ludwigsau\ Hessen",
"499294", "Regnitzlosau",
"4939293", "Dreileben",
"499078", "Mertingen",
"497353", "Schwendi",
"498402", "Münchsmünster",
"496855", "Freisen",
"494792", "Worpswede",
"4938292", "Kröpelin",
"496873", "Nonnweiler",
"493381", "Brandenburg\ an\ der\ Havel",
"492601", "Nauort",
"492440", "Nettersheim\-Tondorf",
"492171", "Leverkusen\-Opladen",
"4934321", "Leisnig",
"497826", "Schuttertal",
"4936874", "Schönbrunn\ bei\ Hildburghaus",
"497333", "Laichingen",
"4933207", "Gross\ Kreutz",
"4938875", "Schlagsdorf\ bei\ Gadebusch",
"498845", "Bad\ Kohlgrub",
"494855", "Eddelak",
"494948", "Wiesmoor\-Marcardsmoor",
"492132", "Meerbusch\-Büderich",
"494873", "Aukrug",
"495108", "Gehrden\ Han",
"499231", "Marktredwitz",
"492362", "Dorsten",
"494469", "Wangerooge",
"4937298", "Oelsnitz\ Erzgebirge",
"495265", "Dörentrup",
"4933470", "Lietzen",
"495221", "Herford",
"498393", "Holzgünz",
"496599", "Weidenbach\ bei\ Gerolstein",
"495751", "Rinteln",
"499272", "Fichtelberg",
"492856", "Hamminkeln\-Brünen",
"4939244", "Steutz",
"4936200", "Elxleben\ bei\ Arnstadt",
"497163", "Ebersbach\ an\ der\ Fils",
"498783", "Rohr\ in\ Niederbayern",
"4935771", "Bad\ Muskau",
"499141", "Weissenburg\ in\ Bayern",
"499396", "Urspringen\ bei\ Lohr",
"494774", "Hechthausen",
"495731", "Bad\ Oeynhausen",
"495286", "Ottenstein\ Niedersachsen",
"492836", "Wachtendonk",
"499721", "Schweinfurt",
"492323", "Herne",
"499765", "Trappstadt",
"495187", "Delligsen",
"4934722", "Preusslitz",
"497742", "Klettgau",
"49771", "Donaueschingen",
"495069", "Nordstemmen",
"499251", "Münchberg",
"497122", "St\ Johann\ Württemberg",
"495772", "Espelkamp",
"4934495", "Dobitschen",
"499498", "Laaber",
"499568", "Neustadt\ bei\ Coburg",
"496774", "Kaub",
"495947", "Laar\ Vechte",
"496435", "Wallmerod",
"4939408", "Hadmersleben",
"492643", "Altenahr",
"497977", "Oberrot\ bei\ Gaildorf",
"492541", "Coesfeld",
"498082", "Schwindegg",
"495055", "Fassberg",
"493433", "Borna\ Stadt",
"4935823", "Ostritz",
"495073", "Neustadt\-Esperke",
"495956", "Rastdorf",
"494435", "Grossenkneten",
"495302", "Vechelde",
"492205", "Rösrath",
"499229", "Mainleus",
"497043", "Maulbronn",
"496304", "Wolfstein\ Pfalz",
"493475", "Lutherstadt\ Eisleben",
"495035", "Gross\ Munzel",
"497328", "Königsbronn",
"4939325", "Vinzelberg",
"492993", "Marsberg\-Canstein",
"498445", "Gerolsbach",
"495936", "Twist",
"494455", "Jade\-Schweiburg",
"495259", "Bad\ Driburg\-Neuenheerse",
"494473", "Emstek",
"499926", "Frauenau",
"498802", "Huglfing",
"496455", "Frankenau\ Hessen",
"496473", "Leun",
"4934292", "Brandis\ bei\ Wurzen",
"495149", "Wienhausen",
"4938321", "Martensdorf\ bei\ Stralsund",
"497426", "Gosheim",
"4969", "Frankfurt\ am\ Main",
"492104", "Mettmann",
"4936482", "Triptis",
"4938821", "Lüdersdorf",
"499951", "Landau\ an\ der\ Isar",
"4937344", "Crottendorf\ Sachsen",
"494466", "Wittmund\-Ardorf",
"498052", "Aschau\ im\ Chiemgau",
"492674", "Bad\ Bertrich",
"495044", "Springe\-Eldagsen",
"495085", "Burgdorf\-Ehlershausen",
"4935387", "Seyda",
"4939825", "Wokuhl",
"498467", "Kinding",
"496466", "Dautphetal\-Friedensdorf",
"496042", "Büdingen\ Hessen",
"496596", "Üdersdorf",
"498434", "Rennertshofen",
"492859", "Wesel\-Bislich",
"4939398", "Gross\ Garz",
"497451", "Horb\ am\ Neckar",
"4935323", "Sonnewalde",
"494485", "Elsfleth\-Huntorf",
"499972", "Waldmünchen",
"498454", "Karlshuld",
"492839", "Straelen\-Herongen",
"495130", "Wedemark",
"494444", "Goldenstedt",
"497431", "Albstadt\-Ebingen",
"499120", "Leinburg",
"495805", "Oetzen",
"498071", "Wasserburg\ am\ Inn",
"496485", "Nentershausen\ Westerwald",
"496444", "Bischoffen",
"495442", "Barnstorf\ Kreis\ Diepholz",
"495066", "Sarstedt",
"492527", "Lippetal\-Lippborg",
"49541", "Osnabrück",
"4933089", "Himmelpfort",
"4936733", "Kaulsdorf",
"4934465", "Bad\ Bibra",
"499931", "Plattling",
"4933731", "Trebbin",
"498032", "Rohrdorf\ Kreis\ Rosenheim",
"495965", "Klein\ Berssen",
"4937422", "Markneukirchen",
"497472", "Rottenburg\ am\ Neckar",
"495921", "Nordhorn",
"493394", "Wittstock\ Dosse",
"492520", "Wadersloh\-Diestedde",
"4939772", "Rothemühl",
"494162", "Jork",
"495164", "Hodenhagen",
"498733", "Mengkofen",
"498262", "Mittelneufnach",
"499747", "Geroda\ Bayern",
"496162", "Reinheim\ Odenwald",
"492293", "Nümbrecht",
"4936693", "Crossen\ an\ der\ Elster",
"495236", "Blomberg\-Grossenmarpe",
"499127", "Rosstal\ Mittelfranken",
"495137", "Seelze",
"494743", "Langen\ bei\ Bremerhaven",
"498460", "Berching\-Holnstein",
"498753", "Elsendorf\ Niederbayern",
"494123", "Barmstedt",
"495939", "Sustrum",
"499504", "Stadelhofen",
"499929", "Ruhmannsfelden",
"493745", "Falkenstein\ Vogtland",
"492905", "Bestwig\-Ramsbeck",
"495157", "Emmerthal\-Börry",
"496123", "Eltville\ am\ Rhein",
"495247", "Harsewinkel",
"4934262", "Falkenhain\ bei\ Wurzen",
"4937604", "Mosel",
"495146", "Wietze",
"498223", "Ichenhausen",
"497277", "Wörth\-Büchelberg",
"496743", "Bacharach",
"499736", "Oberthulba",
"497429", "Egesheim",
"499281", "Hof\ Saale",
"492821", "Kleve\ Niederrhein",
"497176", "Spraitbach",
"495726", "Wiedensahl",
"492865", "Raesfeld",
"493464", "Sangerhausen",
"493594", "Bischofswerda",
"494926", "Krummhörn\-Greetsiel",
"499473", "Kallmünz",
"492656", "Virneburg",
"493437", "Grimma",
"492647", "Kesseling",
"497973", "Obersontheim",
"4939245", "Loburg",
"496061", "Michelstadt",
"497955", "Wallhausen\ Württemberg",
"4935691", "Bärenklau\ NL",
"495943", "Emlichheim",
"497056", "Gechingen",
"497935", "Schrozberg",
"496229", "Neckarsteinach",
"496477", "Greifenstein\-Nenderoth",
"499435", "Schwarzenfeld",
"495693", "Volkmarsen",
"4934494", "Ehrenhain",
"495425", "Borgholzhausen",
"494477", "Lastrup\-Hemmelte",
"498378", "Buchenberg\ bei\ Kempten",
"495461", "Bramsche\ Hase",
"492636", "Burgbrohl",
"4962199", "Ludwigshafen",
"497266", "Kirchardt",
"494721", "Cuxhaven",
"494765", "Ebersdorf\ bei\ Bremervörde",
"498505", "Hutthurm",
"496251", "Bensheim",
"492689", "Dierdorf",
"493763", "Glauchau",
"497134", "Weinsberg",
"494141", "Stade",
"498151", "Starnberg",
"496568", "Wolsfeld",
"499774", "Oberelsbach",
"494251", "Hoya",
"4937206", "Frankenberg\ Sachsen",
"498241", "Buchloe",
"494498", "Saterland\-Ramsloh",
"496396", "Hinterweidenthal",
"498708", "Weihmichl\-Unterneuhausen",
"493628", "Arnstadt",
"4939852", "Schönermark\ bei\ Prenzlau",
"492843", "Rheinberg",
"496721", "Bingen\ am\ Rhein",
"4937381", "Penig",
"496765", "Gemünden\ Hunsrück",
"494231", "Verden\ Aller",
"4938853", "Drönnewitz\ bei\ Hagenow",
"499469", "Roding\-Neubäu",
"497244", "Weingarten\ Baden",
"492401", "Baesweiler",
"496272", "Hirschhorn\ Neckar",
"4939324", "Kläden\ bei\ Stendal",
"4939086", "Jävenitz",
"495274", "Nieheim",
"4938788", "Gross\ Warnow",
"493722", "Limbach\-Oberfrohna",
"494272", "Siedenburg",
"492327", "Bochum\-Wattenscheid",
"495183", "Lamspringe",
"496231", "Hochdorf\-Assenheim",
"496786", "Kempfeld",
"497154", "Kornwestheim",
"498131", "Dachau",
"499123", "Lauf\ an\ der\ Pegnitz",
"4933981", "Putlitz",
"494929", "Ihlow\ Kreis\ Aurich",
"494504", "Ratekau",
"498764", "Mauern\ Kreis\ Freising",
"496736", "Bechenheim",
"496281", "Buchen\ Odenwald",
"492196", "Wermelskirchen",
"492297", "Wildbergerhütte",
"494281", "Zeven",
"494736", "Butjadingen\-Tossens",
"4938353", "Gützkow\ bei\ Greifswald",
"4933701", "Grossbeeren",
"4939427", "Ströbeck",
"497235", "Unterreichenbach\ Kreis\ Calw",
"495502", "Dransfeld",
"4936703", "Gräfenthal",
"4938482", "Warin",
"4939824", "Hohenzieritz",
"496504", "Thalfang",
"492874", "Isselburg",
"497528", "Neukirch\ bei\ Tettnang",
"4939483", "Ballenstedt",
"497273", "Hagenbach\ Pfalz",
"496747", "Emmelshausen",
"494756", "Odisheim",
"499162", "Scheinfeld",
"4938733", "Karbow\-Vietlübbe",
"497255", "Graben\-Neudorf",
"496127", "Niedernhausen\ Taunus",
"496226", "Meckesheim",
"4939748", "Viereck",
"495175", "Lehrte\-Arpke",
"497725", "Königsfeld\ im\ Schwarzwald",
"494127", "Westerhorn",
"497761", "Bad\ Säckingen",
"495153", "Salzhemmendorf",
"4934464", "Freyburg\ Unstrut",
"4936966", "Kaltennordheim",
"4936927", "Unterellen",
"497145", "Markgröningen",
"497184", "Kaisersbach",
"494747", "Beverstedt",
"496756", "Winterbach\ Soonwald",
"492639", "Anhausen\ Kreis\ Neuwied",
"495605", "Kaufungen\ Hessen",
"4933839", "Wusterwitz",
"494972", "Langeoog",
"497269", "Sulzfeld\ Baden",
"499444", "Siegenburg",
"494120", "Ellerhoop",
"492562", "Gronau\ Westfalen",
"493306", "Gransee",
"492686", "Weyerbusch",
"498024", "Holzkirchen",
"498593", "Untergriesbach",
"498463", "Greding",
"494740", "Loxstedt\-Dedesdorf",
"494931", "Norden",
"497944", "Kupferzell",
"4935243", "Weinböhla",
"4933094", "Löwenberg",
"496120", "Aarbergen",
"497806", "Bad\ Peterstal\-Griesbach",
"494951", "Weener",
"499466", "Stamsried",
"493971", "Anklam",
"4935028", "Krippen",
"498422", "Dollnstein",
"492621", "Lahnstein",
"492523", "Wadersloh",
"4938729", "Marnitz",
"497966", "Unterschneidheim",
"4937605", "Hartenstein\ Sachsen",
"497021", "Kirchheim\ unter\ Teck",
"496789", "Heimbach\ Nahe",};
my $timezones = {
               '' => [
                       'Europe/Berlin'
                     ]
             };

    sub new {
      my $class = shift;
      my $number = shift;
      $number =~ s/(^\+49|\D)//g;
      my $self = bless({ country_code => '49', number => $number, formatters => $formatters, validators => $validators, timezones => $timezones, areanames => \%areanames}, $class);
      return $self if ($self->is_valid());
      $number =~ s/^(?:0)//;
      $self = bless({ country_code => '49', number => $number, formatters => $formatters, validators => $validators, areanames => \%areanames}, $class);
      return $self->is_valid() ? $self : undef;
    }
1;