use Text::Shorten;
use Test::More tests => 10080;
use strict;
use warnings FATAL => 'all';
$| = 1;

# test that the shortened version of the given number
# is roughly the same as the original number

for my $sign ('', '+', '-') {
  for my $d1 ('', '0'x10, '1'x20, '2'x30, '3'x40, '4'x50,
	      '5'x60, '6'x70, '7'x80, '8'x90, '9'x99,
	      '00000000000235873285612873461287628935612879462893756',
	      '12341234891723489172509734597326137523809571203957123906732',
	      '09273458923745293847509138745932759155') {

    for my $d2 ('', '.', '.0', '.00000', '.'.$d1, '.'.$d1.$d1,
		'.345234523463534573473654675467456745745858757',
		'.3534698572394867329573246097191729357129',
		'.000000000000000000000000345324523452345254',
		'.000000000000000023412353000000000000') {

      next if "$d1$d2" eq '' || "$d1$d2" eq '.';

      for my $e ('', 'e0', 'e-0', 'e+0', 'e+00000000000006',
		 'e-0000000000014', 'e35', 'E-14', 'E+105') {


	my $n = "$sign$d1$d2$e";

	next if $n =~ /\.[eE]/;

	for my $len (40, 20, 10) {

	  if (++$::k == 251) {
	    $::k = 512;
	  }

	  my $p = Text::Shorten::shorten_scalar($n, $len);
	  $n =~ s/^0+(\d)/$1/;
	  $n =~ s/^\-0+(\d)/-$1/;
	  $n =~ s/\.[eE]/e/;
	  my $diff = ($p-$n) / (($n+0) || 1);

	  unless(ok(abs($diff) < 2.0E-4)) {
	    diag("shorten $n = $len => $p");
	  }

	}
      }
    }
  }
}





