package Graphics::ColorNamesCMYK::All;

use strict 'vars', 'subs';

our $AUTHORITY = 'cpan:PERLANCAR'; # AUTHORITY
our $DATE = '2024-05-16'; # DATE
our $DIST = 'Graphics-ColorNamesCMYK-All'; # DIST
our $VERSION = '0.001'; # VERSION

our $NAMES_CMYK_TABLE = {
  "-white"                     => 2816,
  "100C"                       => 16795136,
  "100U"                       => 274944,
  "101C"                       => 16797184,
  "101U"                       => 343040,
  "102C"                       => 25600,
  "102U"                       => 479744,
  "103C"                       => 549907,
  "103U"                       => 806173,
  "104C"                       => 51012637,
  "104U"                       => 605991,
  "105C"                       => 252992810,
  "105U"                       => 404275,
  "106C"                       => 16797440,
  "106U"                       => 539392,
  "107C"                       => 88064,
  "107U"                       => 672768,
  "108C"                       => 156416,
  "108U"                       => 872192,
  "109C"                       => 353280,
  "109U"                       => 1467392,
  "110C"                       => 1336328,
  "110U"                       => 1462548,
  "111C"                       => 1139745,
  "111U"                       => 867879,
  "112C"                       => 51536934,
  "112U"                       => 800558,
  "113C"                       => 84480,
  "113U"                       => 802560,
  "114C"                       => 151552,
  "114U"                       => 1001216,
  "115C"                       => 284672,
  "115U"                       => 1266176,
  "116C"                       => 680448,
  "116U"                       => 1924352,
  "117C"                       => 1729551,
  "117U"                       => 1526300,
  "118C"                       => 1729567,
  "118U"                       => 1196070,
  "119C"                       => 186146861,
  "119U"                       => 666928,
  "1205C"                      => 274432,
  "1205U"                      => 731648,
  "120C"                       => 344576,
  "120U"                       => 1332736,
  "1215C"                      => 474368,
  "1215U"                      => 996096,
  "121C"                       => 411648,
  "121U"                       => 1328128,
  "1225C"                      => 1069056,
  "1225U"                      => 1787136,
  "122C"                       => 610304,
  "122U"                       => 1657600,
  "1235C"                      => 1662464,
  "1235U"                      => 2116864,
  "123C"                       => 1071360,
  "123U"                       => 2183424,
  "1245C"                      => 35611152,
  "1245U"                      => 1720603,
  "124C"                       => 1926145,
  "124U"                       => 2182160,
  "1255C"                      => 52322077,
  "1255U"                      => 1259557,
  "125C"                       => 2057241,
  "125U"                       => 1457955,
  "1265C"                      => 169892909,
  "1265U"                      => 929327,
  "126C"                       => 1991720,
  "126U"                       => 1062444,
  "127C"                       => 212736,
  "127U"                       => 667393,
  "128C"                       => 477952,
  "128U"                       => 1195521,
  "129C"                       => 675840,
  "129U"                       => 1985282,
  "130C"                       => 2122752,
  "130U"                       => 2445571,
  "131C"                       => 2581515,
  "131U"                       => 2050331,
  "132C"                       => 2253860,
  "132U"                       => 1260585,
  "133C"                       => 203514428,
  "133U"                       => 666419,
  "1345C"                      => 864768,
  "1345U"                      => 1059584,
  "134C"                       => 736768,
  "134U"                       => 1127680,
  "1355C"                      => 1260800,
  "1355U"                      => 1454848,
  "135C"                       => 1198080,
  "135U"                       => 1588224,
  "1365C"                      => 1855232,
  "1365U"                      => 2113536,
  "136C"                       => 1463040,
  "136U"                       => 2115328,
  "1375C"                      => 2646272,
  "1375U"                      => 2640640,
  "137C"                       => 2384896,
  "137U"                       => 2510336,
  "1385C"                      => 3564549,
  "1385U"                      => 2573844,
  "138C"                       => 3564545,
  "138U"                       => 2706449,
  "1395C"                      => 3367975,
  "1395U"                      => 1718058,
  "139C"                       => 3171354,
  "139U"                       => 1916454,
  "1405C"                      => 137453884,
  "1405U"                      => 1058869,
  "140C"                       => 103507002,
  "140U"                       => 1125938,
  "141C"                       => 1065984,
  "141U"                       => 1456130,
  "142C"                       => 1395968,
  "142U"                       => 1916675,
  "143C"                       => 1791232,
  "143U"                       => 2311428,
  "144C"                       => 3236864,
  "144U"                       => 2771717,
  "145C"                       => 3236872,
  "145U"                       => 2384152,
  "146C"                       => 3105823,
  "146U"                       => 1719078,
  "147C"                       => 321279796,
  "147U"                       => 730422,
  "1485C"                      => 2245632,
  "1485U"                      => 2309376,
  "148C"                       => 1126144,
  "148U"                       => 1453824,
  "1495C"                      => 3235840,
  "1495U"                      => 2769920,
  "149C"                       => 1456128,
  "149U"                       => 1914371,
  "1505C"                      => 4219904,
  "1505U"                      => 3296768,
  "150C"                       => 1984256,
  "150U"                       => 2638592,
  "151C"                       => 3564544,
  "151U"                       => 3099648,
  "1525C"                      => 5071886,
  "1525U"                      => 3098138,
  "152C"                       => 4023296,
  "152U"                       => 3033100,
  "1535C"                      => 4678694,
  "1535U"                      => 2308393,
  "153C"                       => 3761169,
  "153U"                       => 2309665,
  "1545C"                      => 4482115,
  "1545U"                      => 1452340,
  "154C"                       => 3761190,
  "154U"                       => 1914155,
  "1555C"                      => 1910784,
  "1555U"                      => 1582592,
  "155C"                       => 860928,
  "155U"                       => 1255427,
  "1565C"                      => 2767872,
  "1565U"                      => 2175232,
  "156C"                       => 1520384,
  "156U"                       => 1650435,
  "1575C"                      => 3889664,
  "1575U"                      => 2702336,
  "157C"                       => 2639616,
  "157U"                       => 2505733,
  "1585C"                      => 4350720,
  "1585U"                      => 3163392,
  "158C"                       => 4088064,
  "158U"                       => 3097607,
  "1595C"                      => 4613122,
  "1595U"                      => 3097361,
  "159C"                       => 4482055,
  "159U"                       => 2900245,
  "1605C"                      => 21126942,
  "1605U"                      => 2307619,
  "160C"                       => 4219936,
  "160U"                       => 2111270,
  "1615C"                      => 21258796,
  "1615U"                      => 2044458,
  "161C"                       => 188570689,
  "161U"                       => 1189685,
  "1625C"                      => 2696960,
  "1625U"                      => 2239232,
  "162C"                       => 1777664,
  "162U"                       => 1779456,
  "1635C"                      => 3487488,
  "1635U"                      => 2700032,
  "163C"                       => 2898176,
  "163U"                       => 2569728,
  "1645C"                      => 4478208,
  "1645U"                      => 3292672,
  "164C"                       => 3887360,
  "164U"                       => 3096320,
  "1655C"                      => 5071872,
  "1655U"                      => 3687936,
  "165C"                       => 4481024,
  "165U"                       => 3557376,
  "1665C"                      => 5399552,
  "1665U"                      => 3621898,
  "166C"                       => 5006336,
  "166U"                       => 3557388,
  "1675C"                      => 5202970,
  "1675U"                      => 2832673,
  "167C"                       => 4809743,
  "167U"                       => 2833693,
  "1685C"                      => 21978928,
  "1685U"                      => 2306090,
  "168C"                       => 38428217,
  "168U"                       => 1977902,
  "169C"                       => 2233600,
  "169U"                       => 1843200,
  "170C"                       => 3682304,
  "170U"                       => 2962176,
  "171C"                       => 4871424,
  "171U"                       => 3488768,
  "172C"                       => 5267968,
  "172U"                       => 3950080,
  "173C"                       => 5464836,
  "173U"                       => 3489811,
  "174C"                       => 5529381,
  "174U"                       => 2766119,
  "175C"                       => 223235387,
  "175U"                       => 1910323,
  "1765C"                      => 2754816,
  "1765U"                      => 2301184,
  "1767C"                      => 2360576,
  "1767U"                      => 1774848,
  "176C"                       => 2230528,
  "176U"                       => 2038528,
  "1775C"                      => 3477248,
  "1775U"                      => 2959360,
  "1777C"                      => 4726272,
  "1777U"                      => 3287808,
  "177C"                       => 3808512,
  "177U"                       => 2960128,
  "1785C"                      => 5387008,
  "1785U"                      => 3946240,
  "1787C"                      => 5849600,
  "1787U"                      => 4011777,
  "1788C"                      => 6115840,
  "1788U"                      => 4078850,
  "178C"                       => 4929792,
  "178U"                       => 3552512,
  "1795C"                      => 6312449,
  "1795U"                      => 3881743,
  "1797C"                      => 6047750,
  "1797U"                      => 4012820,
  "179C"                       => 5788928,
  "179U"                       => 3816972,
  "1805C"                      => 6376982,
  "1805U"                      => 3355421,
  "1807C"                      => 56246556,
  "1807U"                      => 3355171,
  "180C"                       => 22498573,
  "180U"                       => 3290393,
  "1815C"                      => 39929908,
  "1815U"                      => 2632492,
  "1817C"                      => 391133753,
  "1817U"                      => 2039605,
  "181C"                       => 106383151,
  "181U"                       => 2369837,
  "182C"                       => 1966080,
  "182U"                       => 1840384,
  "183C"                       => 3016192,
  "183U"                       => 2958336,
  "184C"                       => 5185280,
  "184U"                       => 3682305,
  "185C"                       => 6576384,
  "185U"                       => 4406277,
  "186C"                       => 6574085,
  "186U"                       => 4011794,
  "187C"                       => 6572570,
  "187U"                       => 3419936,
  "188C"                       => 90191926,
  "188U"                       => 2499374,
  "1895C"                      => 2097152,
  "1895U"                      => 1970944,
  "189C"                       => 2753280,
  "189U"                       => 2168832,
  "1905C"                      => 3080704,
  "1905U"                      => 2497025,
  "190C"                       => 4262656,
  "190U"                       => 3089408,
  "1915C"                      => 5312512,
  "1915U"                      => 3614980,
  "191C"                       => 5578240,
  "191U"                       => 3616003,
  "1925C"                      => 6566912,
  "1925U"                      => 4338953,
  "192C"                       => 6569472,
  "192U"                       => 4273927,
  "1935C"                      => 6568712,
  "1935U"                      => 4076309,
  "193C"                       => 6568715,
  "193U"                       => 3813655,
  "1945C"                      => 6565914,
  "1945U"                      => 3418399,
  "194C"                       => 39922465,
  "194U"                       => 2958884,
  "1955C"                      => 6564651,
  "1955U"                      => 2958377,
  "195U"                       => 2235695,
  "196C"                       => 1376768,
  "196U"                       => 1315076,
  "197C"                       => 2950912,
  "197U"                       => 2169349,
  "198C"                       => 5581056,
  "198U"                       => 3550729,
  "199C"                       => 6573824,
  "199U"                       => 4208653,
  "200C"                       => 6573069,
  "200U"                       => 3814170,
  "201C"                       => 6569759,
  "201U"                       => 3024933,
  "202C"                       => 23214636,
  "202U"                       => 2564908,
  "203C"                       => 2228224,
  "203U"                       => 1839364,
  "204C"                       => 3801344,
  "204U"                       => 2957063,
  "205C"                       => 5508864,
  "205U"                       => 3746314,
  "206C"                       => 6571266,
  "206U"                       => 4535567,
  "207C"                       => 6568730,
  "207U"                       => 3814170,
  "208C"                       => 6561068,
  "208U"                       => 2694188,
  "209C"                       => 257957687,
  "209U"                       => 2103089,
  "210C"                       => 19660800,
  "210U"                       => 2364416,
  "211C"                       => 3932160,
  "211U"                       => 3087361,
  "212C"                       => 5112320,
  "212U"                       => 3679236,
  "213C"                       => 6228224,
  "213U"                       => 4205321,
  "214C"                       => 23334403,
  "214U"                       => 4008466,
  "215C"                       => 40111637,
  "215U"                       => 3482400,
  "216C"                       => 207753518,
  "216U"                       => 2497070,
  "217C"                       => 18546688,
  "217U"                       => 1378308,
  "218C"                       => 37879808,
  "218U"                       => 2955014,
  "219C"                       => 6225920,
  "219U"                       => 3940875,
  "220C"                       => 6556954,
  "220U"                       => 3744287,
  "221C"                       => 6557222,
  "221U"                       => 3415590,
  "222C"                       => 358876980,
  "222U"                       => 2232881,
  "223C"                       => 70254592,
  "223U"                       => 2231554,
  "224C"                       => 88080384,
  "224U"                       => 2953988,
  "225C"                       => 73007104,
  "225U"                       => 3874056,
  "226C"                       => 6553602,
  "226U"                       => 6565650,
  "227C"                       => 56885268,
  "227U"                       => 3874591,
  "228C"                       => 291766305,
  "228U"                       => 2955053,
  "229C"                       => 459540790,
  "229U"                       => 2035764,
  "230C"                       => 52887552,
  "230U"                       => 1969152,
  "231C"                       => 87883776,
  "231U"                       => 3085058,
  "232C"                       => 122748928,
  "232U"                       => 3676165,
  "233C"                       => 191102976,
  "233U"                       => 4268054,
  "234C"                       => 274989073,
  "234U"                       => 3611169,
  "235C"                       => 308543525,
  "235U"                       => 3020075,
  "2365C"                      => 52232192,
  "2365U"                      => 1509123,
  "236C"                       => 86376448,
  "236U"                       => 2165251,
  "2375C"                      => 205193216,
  "2375U"                      => 2755080,
  "237C"                       => 120913920,
  "237U"                       => 2755845,
  "2385C"                      => 324141056,
  "2385U"                      => 3280140,
  "238C"                       => 189136896,
  "238U"                       => 3412489,
  "2395C"                      => 392167424,
  "2395U"                      => 3871248,
  "239C"                       => 240189440,
  "239U"                       => 4003342,
  "2405C"                      => 526647297,
  "2405U"                      => 3543067,
  "240C"                       => 341442560,
  "240U"                       => 3675416,
  "2415C"                      => 593756166,
  "2415U"                      => 3346209,
  "241C"                       => 476315648,
  "241U"                       => 3413279,
  "2425C"                      => 610533399,
  "2425U"                      => 2953001,
  "242C"                       => 543424541,
  "242U"                       => 2428973,
  "243C"                       => 102563840,
  "243U"                       => 1705221,
  "244C"                       => 170590208,
  "244U"                       => 2229768,
  "245C"                       => 238551040,
  "245U"                       => 2819852,
  "246C"                       => 458817536,
  "246U"                       => 3804435,
  "247C"                       => 509476864,
  "247U"                       => 3739162,
  "248C"                       => 627310592,
  "248U"                       => 3345701,
  "249C"                       => 727973905,
  "249U"                       => 2362159,
  "250C"                       => 119341056,
  "250U"                       => 1442311,
  "251C"                       => 220856320,
  "251U"                       => 2162700,
  "252C"                       => 440598528,
  "252U"                       => 3014931,
  "253C"                       => 677314560,
  "253U"                       => 3408669,
  "254C"                       => 778174464,
  "254U"                       => 3080998,
  "255C"                       => 895746064,
  "255U"                       => 2229553,
  "2562C"                      => 237174784,
  "2562U"                      => 85524489,
  "2563C"                      => 304480256,
  "2563U"                      => 102301711,
  "2567C"                      => 405143552,
  "2567U"                      => 203096078,
  "256C"                       => 186122240,
  "256U"                       => 51445775,
  "2572C"                      => 389087232,
  "2572U"                      => 136511501,
  "2573C"                      => 473169920,
  "2573U"                      => 153157652,
  "2577C"                      => 657981440,
  "2577U"                      => 287571990,
  "257C"                       => 321323008,
  "257U"                       => 68681748,
  "2582C"                      => 692912128,
  "2582U"                      => 170590227,
  "2583C"                      => 709296128,
  "2583U"                      => 170197021,
  "2587C"                      => 1028849664,
  "2587U"                      => 338165788,
  "258C"                       => 861143040,
  "258U"                       => 119537696,
  "2592C"                      => 878510080,
  "2592U"                      => 187826201,
  "2593C"                      => 996016128,
  "2593U"                      => 187301925,
  "2597C"                      => 1382285316,
  "2597U"                      => 355270692,
  "259C"                       => 1080295431,
  "259U"                       => 86114343,
  "2602C"                      => 979566592,
  "2602U"                      => 154140707,
  "2603C"                      => 1113849860,
  "2603U"                      => 153550891,
  "2607C"                      => 1432616973,
  "2607U"                      => 321454121,
  "260C"                       => 1013186582,
  "260U"                       => 35389485,
  "2612C"                      => 1029963777,
  "2612U"                      => 86376493,
  "2613C"                      => 1147404296,
  "2613U"                      => 119799855,
  "2617C"                      => 1432616983,
  "2617U"                      => 270991406,
  "261C"                       => 1013186591,
  "261U"                       => 35192881,
  "2622C"                      => 962528027,
  "2622U"                      => 1704244,
  "2623C"                      => 1113849876,
  "2623U"                      => 69074996,
  "2627C"                      => 1399062572,
  "2627U"                      => 186777651,
  "262C"                       => 979371569,
  "262U"                       => 1311030,
  "2635C"                      => 354091008,
  "2635U"                      => 219480073,
  "263C"                       => 185860096,
  "263U"                       => 101646344,
  "2645C"                      => 573112320,
  "2645U"                      => 320602123,
  "264C"                       => 388104192,
  "264U"                       => 270336011,
  "2655C"                      => 825688064,
  "2655U"                      => 421855247,
  "265C"                       => 910360576,
  "265U"                       => 422182930,
  "2665C"                      => 1095303168,
  "2665U"                      => 523042837,
  "266C"                       => 1196949504,
  "266U"                       => 506462231,
  "267C"                       => 1365442560,
  "267U"                       => 456065056,
  "2685C"                      => 1633943571,
  "2685U"                      => 489553955,
  "268C"                       => 1331953664,
  "268U"                       => 338034732,
  "2695C"                      => 1499725882,
  "2695U"                      => 270204978,
  "269C"                       => 1281622034,
  "269U"                       => 220135474,
  "2705C"                      => 606076928,
  "2705U"                      => 353763337,
  "2706C"                      => 302710784,
  "2706U"                      => 252444677,
  "2707C"                      => 352780288,
  "2707U"                      => 302645252,
  "2708C"                      => 420216832,
  "2708U"                      => 437256198,
  "270C"                       => 488046592,
  "270U"                       => 370540557,
  "2715C"                      => 875495424,
  "2715U"                      => 488636429,
  "2716C"                      => 639238144,
  "2716U"                      => 521732105,
  "2717C"                      => 537722880,
  "2717U"                      => 521273348,
  "2718C"                      => 1093140480,
  "2718U"                      => 858128399,
  "271C"                       => 740687872,
  "271U"                       => 454754321,
  "2725C"                      => 1229193216,
  "2725U"                      => 589824017,
  "2726C"                      => 1396834304,
  "2726U"                      => 757661715,
  "2727C"                      => 1261240320,
  "2727U"                      => 958791689,
  "2728C"                      => 1665925120,
  "2728U"                      => 976093208,
  "272C"                       => 1027014656,
  "272U"                       => 555745302,
  "2735C"                      => 1667432453,
  "2735U"                      => 707985438,
  "2736C"                      => 1683619842,
  "2736U"                      => 825229339,
  "2738C"                      => 1683685389,
  "2738U"                      => 959774756,
  "273C"                       => 1650524197,
  "273U"                       => 589824039,
  "2745C"                      => 1684144150,
  "2745U"                      => 623706152,
  "2746C"                      => 1683685386,
  "2746U"                      => 774635555,
  "2747C"                      => 1683292197,
  "2747U"                      => 908918828,
  "2748C"                      => 1683357731,
  "2748U"                      => 824967213,
  "274C"                       => 1650524209,
  "274U"                       => 539295789,
  "2755C"                      => 1667366947,
  "2755U"                      => 556269613,
  "2756C"                      => 1683750938,
  "2756U"                      => 622985261,
  "2757C"                      => 1683030067,
  "2757U"                      => 757399603,
  "2758C"                      => 1683161135,
  "2758U"                      => 690290740,
  "275C"                       => 1650655290,
  "275U"                       => 488767537,
  "2765C"                      => 1650589756,
  "2765U"                      => 455213109,
  "2766C"                      => 1683423290,
  "2766U"                      => 505086003,
  "2767C"                      => 1682374722,
  "2767U"                      => 437780541,
  "2768C"                      => 1682833474,
  "2768U"                      => 538705977,
  "276C"                       => 1583153231,
  "276U"                       => 286720056,
  "277C"                       => 537395200,
  "277U"                       => 470679557,
  "278C"                       => 722534400,
  "278U"                       => 689307655,
  "279C"                       => 1159856128,
  "279U"                       => 975372302,
  "280C"                       => 1683292199,
  "280U"                       => 892010545,
  "281C"                       => 1682833465,
  "281U"                       => 774176822,
  "282C"                       => 1682440265,
  "282U"                       => 589103164,
  "283C"                       => 688586752,
  "283U"                       => 588251143,
  "284C"                       => 907214848,
  "284U"                       => 790102025,
  "285C"                       => 1513029632,
  "285U"                       => 1092943891,
  "286C"                       => 1682964492,
  "286U"                       => 1177550884,
  "287C"                       => 1683030039,
  "287U"                       => 1009319977,
  "288C"                       => 1682898981,
  "288U"                       => 925237295,
  "289C"                       => 1682047052,
  "289U"                       => 605618235,
  "2905C"                      => 721616896,
  "2905U"                      => 705626119,
  "290C"                       => 419495936,
  "290U"                       => 504037383,
  "2915C"                      => 973602816,
  "2915U"                      => 957808649,
  "291C"                       => 637796352,
  "291U"                       => 772997128,
  "2925C"                      => 1259470848,
  "2925U"                      => 1193213966,
  "292C"                       => 923598848,
  "292U"                       => 958070794,
  "2935C"                      => 1681850370,
  "2935U"                      => 1412169761,
  "293C"                       => 1682702345,
  "293U"                       => 1328414754,
  "2945C"                      => 1681915920,
  "2945U"                      => 1193607213,
  "294C"                       => 1682571309,
  "294U"                       => 992149551,
  "2955C"                      => 1681129530,
  "2955U"                      => 857342006,
  "295C"                       => 1681850435,
  "295U"                       => 874315831,
  "2965C"                      => 1680343122,
  "2965U"                      => 672333884,
  "296C"                       => 1680736345,
  "296U"                       => 504430654,
  "2975C"                      => 620756992,
  "2975U"                      => 705363975,
  "297C"                       => 872415232,
  "297U"                       => 789446663,
  "2985C"                      => 973078528,
  "2985U"                      => 1158938633,
  "298C"                       => 1090715648,
  "298U"                       => 1125515273,
  "2995C"                      => 1325596672,
  "2995U"                      => 1578893326,
  "299C"                       => 1325858816,
  "299U"                       => 1545535503,
  "3005C"                      => 1680015362,
  "3005U"                      => 1680146457,
  "300C"                       => 1681391619,
  "300U"                       => 1680343069,
  "3015C"                      => 1679818777,
  "3015U"                      => 1310523434,
  "301C"                       => 1681063970,
  "301U"                       => 1209991212,
  "3025C"                      => 1678966840,
  "3025U"                      => 924057652,
  "302C"                       => 1679818820,
  "302U"                       => 907345973,
  "3035C"                      => 1678969416,
  "3035U"                      => 621674556,
  "303C"                       => 1679885908,
  "303U"                       => 638582844,
  "304C"                       => 587203072,
  "304U"                       => 671547399,
  "305C"                       => 922747136,
  "305U"                       => 1091436551,
  "306C"                       => 1275068416,
  "306U"                       => 1679097867,
  "307C"                       => 1679032345,
  "307U"                       => 1679556644,
  "308C"                       => 1678377012,
  "308U"                       => 956305973,
  "309C"                       => 1678251084,
  "309U"                       => 621543485,
  "3105C"                      => 822085376,
  "3105U"                      => 1107755021,
  "310C"                       => 838861824,
  "310U"                       => 1007288330,
  "3115C"                      => 1174408448,
  "3115U"                      => 1678311441,
  "311C"                       => 1090520576,
  "311U"                       => 1678573582,
  "3125C"                      => 1493177088,
  "3125U"                      => 1678508056,
  "312C"                       => 1543506944,
  "312U"                       => 1678770194,
  "3135C"                      => 1677727242,
  "3135U"                      => 1678639139,
  "313C"                       => 1677724422,
  "313U"                       => 1679032351,
  "3145C"                      => 1677727774,
  "3145U"                      => 1678508079,
  "314C"                       => 1677724950,
  "314U"                       => 1678901288,
  "3155C"                      => 1677728047,
  "3155U"                      => 1292566582,
  "315C"                       => 1677725996,
  "315U"                       => 1242497077,
  "3165C"                      => 1677729088,
  "3165U"                      => 906625084,
  "316C"                       => 1678384452,
  "316U"                       => 621281342,
  "317C"                       => 436209152,
  "317U"                       => 419430409,
  "318C"                       => 654313728,
  "318U"                       => 872546317,
  "319C"                       => 1006637056,
  "319U"                       => 1375928338,
  "320C"                       => 1677730817,
  "320U"                       => 1678049315,
  "321C"                       => 1677731082,
  "321U"                       => 1678049326,
  "322C"                       => 1677731617,
  "322U"                       => 1375993909,
  "323C"                       => 1677732147,
  "323U"                       => 889454652,
  "3242C"                      => 738201856,
  "3242U"                      => 973079566,
  "3245C"                      => 671093504,
  "3245U"                      => 1090521102,
  "3248C"                      => 872423424,
  "3248U"                      => 822086163,
  "324C"                       => 570427904,
  "324U"                       => 671088911,
  "3252C"                      => 989862400,
  "3252U"                      => 1677722900,
  "3255C"                      => 973086208,
  "3255U"                      => 1677724179,
  "3258C"                      => 1040196352,
  "3258U"                      => 1056967448,
  "325C"                       => 905974784,
  "325U"                       => 1124074264,
  "3262C"                      => 1358964736,
  "3262U"                      => 1677723163,
  "3265C"                      => 1258302208,
  "3265U"                      => 1677724441,
  "3268C"                      => 1442854656,
  "3268U"                      => 1308626206,
  "326C"                       => 1358964224,
  "326U"                       => 1677722913,
  "3272C"                      => 1677734656,
  "3272U"                      => 1677723436,
  "3275C"                      => 1560295680,
  "3275U"                      => 1677725217,
  "3278C"                      => 1677738240,
  "3278U"                      => 1677725991,
  "327C"                       => 1677736717,
  "327U"                       => 1677723436,
  "3282C"                      => 1677735439,
  "3282U"                      => 1677722927,
  "3285C"                      => 1677736193,
  "3285U"                      => 1677724204,
  "3288C"                      => 1677738769,
  "3288U"                      => 1677724204,
  "328C"                       => 1677735966,
  "328U"                       => 1426064179,
  "3292C"                      => 1677735992,
  "3292U"                      => 889193529,
  "3295C"                      => 1677737244,
  "3295U"                      => 1207961651,
  "3298C"                      => 1677738792,
  "3298U"                      => 872417591,
  "329C"                       => 1677735722,
  "329U"                       => 1023410998,
  "3302C"                      => 1594636352,
  "3302U"                      => 553648702,
  "3305C"                      => 1561148734,
  "3305U"                      => 553649467,
  "3308C"                      => 1544438598,
  "3308U"                      => 436209214,
  "330C"                       => 1561212217,
  "330U"                       => 536871229,
  "331C"                       => 452988672,
  "331U"                       => 620759305,
  "332C"                       => 587207936,
  "332U"                       => 838863371,
  "333C"                       => 905978368,
  "333U"                       => 1677725458,
  "334C"                       => 1677739009,
  "334U"                       => 1677725482,
  "335C"                       => 1677738775,
  "335U"                       => 1191185459,
  "336C"                       => 1661027117,
  "336U"                       => 822086199,
  "3375C"                      => 687873792,
  "3375U"                      => 973083148,
  "337C"                       => 671096064,
  "337U"                       => 654314768,
  "3385C"                      => 922758400,
  "3385U"                      => 1224742161,
  "338C"                       => 872424448,
  "338U"                       => 1023414552,
  "3395C"                      => 1291862784,
  "3395U"                      => 1677728022,
  "339C"                       => 1325415424,
  "339U"                       => 1342182688,
  "3405C"                      => 1543525632,
  "3405U"                      => 1677729566,
  "340C"                       => 1677742336,
  "340U"                       => 1677728038,
  "3415C"                      => 1677743389,
  "3415U"                      => 1056969777,
  "341C"                       => 1593920282,
  "341U"                       => 956305973,
  "3425C"                      => 1610764335,
  "3425U"                      => 754978869,
  "342C"                       => 1560562475,
  "342U"                       => 721423928,
  "3435C"                      => 1460620613,
  "3435U"                      => 436210492,
  "343C"                       => 1460488248,
  "343U"                       => 486541884,
  "344C"                       => 587211520,
  "344U"                       => 570430479,
  "345C"                       => 671098368,
  "345U"                       => 771758100,
  "346C"                       => 872428032,
  "346U"                       => 989862938,
  "347C"                       => 1543528704,
  "347U"                       => 1442850087,
  "348C"                       => 1560306193,
  "348U"                       => 1023418416,
  "349C"                       => 1426283308,
  "349U"                       => 637540151,
  "350C"                       => 1242714430,
  "350U"                       => 301993788,
  "351C"                       => 536879360,
  "351U"                       => 603985418,
  "352C"                       => 620766720,
  "352U"                       => 838867724,
  "353C"                       => 704654336,
  "353U"                       => 1056972816,
  "354C"                       => 1426088448,
  "354U"                       => 1677733410,
  "355C"                       => 1560306688,
  "355U"                       => 1392518697,
  "356C"                       => 1526752282,
  "356U"                       => 922754611,
  "357C"                       => 1342789692,
  "357U"                       => 436212281,
  "358C"                       => 536883968,
  "358U"                       => 503325711,
  "359C"                       => 637549056,
  "359U"                       => 654322196,
  "360C"                       => 989878784,
  "360U"                       => 822095388,
  "361C"                       => 1140876288,
  "361U"                       => 922760481,
  "362C"                       => 1107321865,
  "362U"                       => 704655146,
  "363C"                       => 1073767448,
  "363U"                       => 587213104,
  "364C"                       => 989881387,
  "364U"                       => 419439669,
  "365C"                       => 385890304,
  "365U"                       => 268444938,
  "366C"                       => 486555648,
  "366U"                       => 402664206,
  "367C"                       => 620776704,
  "367U"                       => 536883474,
  "368C"                       => 905995264,
  "368U"                       => 704658718,
  "369C"                       => 973104132,
  "369U"                       => 654326309,
  "370C"                       => 822109214,
  "370U"                       => 402665518,
  "371C"                       => 671769147,
  "371U"                       => 151003191,
  "372C"                       => 251671808,
  "372U"                       => 218114054,
  "373C"                       => 302005248,
  "373U"                       => 352334601,
  "374C"                       => 385893632,
  "374U"                       => 452999691,
  "375C"                       => 671113728,
  "375U"                       => 721440277,
  "376C"                       => 805331969,
  "376U"                       => 587220001,
  "377C"                       => 687891478,
  "377U"                       => 335558444,
  "378C"                       => 537486396,
  "378U"                       => 100672820,
  "379C"                       => 151012608,
  "379U"                       => 50343943,
  "380C"                       => 218125056,
  "380U"                       => 117456139,
  "381C"                       => 302015232,
  "381U"                       => 218122512,
  "382C"                       => 369124352,
  "382U"                       => 402674456,
  "383C"                       => 318792722,
  "383U"                       => 134234408,
  "384C"                       => 234906659,
  "384U"                       => 67123501,
  "385C"                       => 286220340,
  "385U"                       => 141363,
  "386C"                       => 100680448,
  "386U"                       => 16790021,
  "387C"                       => 167794176,
  "387U"                       => 67125255,
  "388C"                       => 184572672,
  "388U"                       => 134236937,
  "389C"                       => 251683584,
  "389U"                       => 234906126,
  "390C"                       => 335569928,
  "390U"                       => 184569378,
  "391C"                       => 167797795,
  "391U"                       => 16791854,
  "392C"                       => 151479345,
  "392U"                       => 77875,
  "3935C"                      => 33572864,
  "3935U"                      => 273921,
  "393C"                       => 50347776,
  "393U"                       => 143107,
  "3945C"                      => 33579520,
  "3945U"                      => 343553,
  "394C"                       => 83907584,
  "394U"                       => 147461,
  "3955C"                      => 33580032,
  "3955U"                      => 413186,
  "395C"                       => 100686848,
  "395U"                       => 18695,
  "3965C"                      => 33580033,
  "3965U"                      => 416515,
  "396C"                       => 117466112,
  "396U"                       => 50357259,
  "3975C"                      => 50750487,
  "3975U"                      => 543517,
  "397C"                       => 184574989,
  "397U"                       => 16795425,
  "3985C"                      => 34366505,
  "3985U"                      => 539687,
  "398C"                       => 134243354,
  "398U"                       => 15914,
  "3995C"                      => 286875708,
  "3995U"                      => 404529,
  "399C"                       => 33907748,
  "399U"                       => 277550,
  "400C"                       => 336663296,
  "400U"                       => 198422,
  "401C"                       => 471407619,
  "401U"                       => 198429,
  "402C"                       => 572399880,
  "402U"                       => 198436,
  "403C"                       => 656680974,
  "403U"                       => 198443,
  "404C"                       => 757804825,
  "404U"                       => 263981,
  "405C"                       => 825176864,
  "405U"                       => 264245,
  "406C"                       => 336793856,
  "406U"                       => 329494,
  "407U"                       => 329249,
  "408C"                       => 589570058,
  "408U"                       => 329254,
  "409C"                       => 673851410,
  "409U"                       => 395050,
  "410C"                       => 758131994,
  "410U"                       => 395054,
  "411C"                       => 859255847,
  "411U"                       => 461108,
  "412C"                       => 1027883082,
  "412U"                       => 527165,
  "413C"                       => 420550144,
  "413U"                       => 16778522,
  "414C"                       => 521608451,
  "414U"                       => 16778273,
  "415C"                       => 656221193,
  "415U"                       => 16778278,
  "416C"                       => 757279506,
  "416U"                       => 16778283,
  "417C"                       => 891958303,
  "417U"                       => 33555504,
  "418C"                       => 993016364,
  "418U"                       => 16778548,
  "419C"                       => 1279345242,
  "419U"                       => 1089,
  "420C"                       => 302844416,
  "420U"                       => 16777497,
  "421C"                       => 471077889,
  "421U"                       => 16777245,
  "422C"                       => 605689604,
  "422U"                       => 33620004,
  "423C"                       => 740367625,
  "423U"                       => 67174441,
  "424C"                       => 875111956,
  "424U"                       => 16842798,
  "425C"                       => 1060318497,
  "425U"                       => 33620018,
  "426C"                       => 1363359571,
  "426U"                       => 16842811,
  "4278C"                      => 50528305,
  "4278U"                      => 50528303,
  "427C"                       => 235406336,
  "427U"                       => 67174421,
  "428C"                       => 353175552,
  "428U"                       => 117637148,
  "429C"                       => 588714754,
  "429U"                       => 151257126,
  "430C"                       => 841095947,
  "430U"                       => 201719851,
  "431C"                       => 1059922457,
  "431U"                       => 201654321,
  "432C"                       => 1312368440,
  "432U"                       => 168165431,
  "433C"                       => 1480534101,
  "433U"                       => 117768254,
  "434C"                       => 235997696,
  "434U"                       => 394512,
  "435C"                       => 353897984,
  "435U"                       => 525596,
  "436C"                       => 505484804,
  "436U"                       => 525858,
  "437C"                       => 741549848,
  "437U"                       => 657197,
  "438C"                       => 876491567,
  "438U"                       => 788785,
  "439C"                       => 943995712,
  "439U"                       => 657719,
  "440C"                       => 1027948363,
  "440U"                       => 526907,
  "441C"                       => 403443200,
  "441U"                       => 83886360,
  "442C"                       => 605296386,
  "442U"                       => 83886109,
  "443C"                       => 723065349,
  "443U"                       => 134283303,
  "444C"                       => 908272401,
  "444U"                       => 134348846,
  "445C"                       => 1110388517,
  "445U"                       => 117571639,
  "446C"                       => 1194669877,
  "446U"                       => 100663611,
  "447C"                       => 1178156865,
  "447U"                       => 50332478,
  "4485C"                      => 354966077,
  "4485U"                      => 665396,
  "448C"                       => 657412419,
  "448U"                       => 399420,
  "4495C"                      => 287134757,
  "4495U"                      => 533036,
  "449C"                       => 489379651,
  "449U"                       => 399927,
  "4505C"                      => 337333018,
  "4505U"                      => 466724,
  "450C"                       => 422205504,
  "450U"                       => 466482,
  "4515C"                      => 337001226,
  "4515U"                      => 466207,
  "451C"                       => 454573328,
  "451U"                       => 202282,
  "4525C"                      => 286339332,
  "4525U"                      => 400152,
  "452C"                       => 403976198,
  "452U"                       => 70690,
  "4535C"                      => 252520961,
  "4535U"                      => 399893,
  "453C"                       => 336602370,
  "453U"                       => 135962,
  "4545C"                      => 202056704,
  "4545U"                      => 399120,
  "454C"                       => 286006528,
  "454U"                       => 69397,
  "455C"                       => 303980091,
  "455U"                       => 468789,
  "456C"                       => 202660637,
  "456U"                       => 668716,
  "457C"                       => 118513686,
  "457U"                       => 802080,
  "458C"                       => 168380162,
  "458U"                       => 668435,
  "459C"                       => 151536385,
  "459U"                       => 536077,
  "460C"                       => 117716736,
  "460U"                       => 403465,
  "461C"                       => 67185408,
  "461U"                       => 336135,
  "4625C"                      => 239819596,
  "4625U"                      => 1451832,
  "462C"                       => 456413757,
  "462U"                       => 859960,
  "4635C"                      => 188107810,
  "4635U"                      => 1516587,
  "463C"                       => 221665333,
  "463U"                       => 1124144,
  "4645C"                      => 237779730,
  "4645U"                      => 1450277,
  "464C"                       => 120936746,
  "464U"                       => 1322279,
  "4655C"                      => 237317896,
  "4655U"                      => 1318686,
  "465C"                       => 220151564,
  "465U"                       => 1058079,
  "4665C"                      => 203302915,
  "4665U"                      => 1187349,
  "466C"                       => 219755526,
  "466U"                       => 926232,
  "4675C"                      => 135600896,
  "4675U"                      => 989711,
  "467C"                       => 185805314,
  "467U"                       => 728594,
  "4685C"                      => 101849088,
  "4685U"                      => 792074,
  "468C"                       => 135143680,
  "468U"                       => 530444,
  "4695C"                      => 323702594,
  "4695U"                      => 1515829,
  "469C"                       => 188766525,
  "469U"                       => 1451828,
  "4705C"                      => 322978602,
  "4705U"                      => 1317677,
  "470C"                       => 54417438,
  "470U"                       => 2044452,
  "4715C"                      => 355612184,
  "4715U"                      => 1186088,
  "471C"                       => 20930067,
  "471U"                       => 2308121,
  "4725C"                      => 338241803,
  "4725U"                      => 1119776,
  "472C"                       => 2635265,
  "472U"                       => 2174990,
  "4735C"                      => 287252740,
  "4735U"                      => 988442,
  "473C"                       => 1581312,
  "473U"                       => 1846023,
  "4745C"                      => 236525312,
  "4745U"                      => 856595,
  "474C"                       => 1317888,
  "474U"                       => 1516548,
  "4755C"                      => 169021696,
  "4755U"                      => 659214,
  "475C"                       => 988928,
  "475U"                       => 1253121,
  "476C"                       => 557993028,
  "476U"                       => 989497,
  "477C"                       => 323309116,
  "477U"                       => 1253171,
  "478C"                       => 206065974,
  "478U"                       => 1516332,
  "479C"                       => 288109071,
  "479U"                       => 1252129,
  "480C"                       => 236790275,
  "480U"                       => 1186326,
  "481C"                       => 186062848,
  "481U"                       => 857361,
  "482C"                       => 135336960,
  "482U"                       => 659981,
  "483C"                       => 173166911,
  "483U"                       => 1778995,
  "484C"                       => 22699041,
  "484U"                       => 2831141,
  "485C"                       => 6251520,
  "485U"                       => 3883275,
  "486C"                       => 3287552,
  "486U"                       => 2699014,
  "487C"                       => 2432768,
  "487U"                       => 2172933,
  "488C"                       => 1840896,
  "488U"                       => 1580804,
  "489C"                       => 1446912,
  "489U"                       => 1251588,
  "490C"                       => 307772226,
  "490U"                       => 1908021,
  "491C"                       => 156842800,
  "491U"                       => 2434348,
  "492C"                       => 106511399,
  "492U"                       => 2696998,
  "493U"                       => 2498326,
  "494C"                       => 2688768,
  "494U"                       => 2104074,
  "495C"                       => 1835264,
  "495U"                       => 1775109,
  "496C"                       => 1507584,
  "496U"                       => 1446402,
  "4975C"                      => 458899027,
  "4975U"                      => 1711159,
  "497C"                       => 575487555,
  "497U"                       => 1382456,
  "4985C"                      => 407251231,
  "4985U"                      => 1709612,
  "498C"                       => 390872374,
  "498U"                       => 1776946,
  "4995C"                      => 389882387,
  "4995U"                      => 1643558,
  "499C"                       => 306920494,
  "499U"                       => 2040109,
  "5005C"                      => 338828041,
  "5005U"                      => 1446686,
  "500C"                       => 204608773,
  "500U"                       => 1841178,
  "5015C"                      => 220467457,
  "5015U"                      => 1315349,
  "501C"                       => 119868160,
  "501U"                       => 1577999,
  "5025C"                      => 135989504,
  "5025U"                      => 1117966,
  "502C"                       => 35325440,
  "502U"                       => 1315338,
  "5035C"                      => 102107392,
  "5035U"                      => 920842,
  "503C"                       => 18220800,
  "503U"                       => 986629,
  "504C"                       => 492318017,
  "504U"                       => 1775410,
  "505C"                       => 358228532,
  "505U"                       => 2169390,
  "506C"                       => 341253157,
  "506U"                       => 2365992,
  "507C"                       => 120522241,
  "507U"                       => 2037011,
  "508C"                       => 19202816,
  "508U"                       => 1971725,
  "509C"                       => 2097408,
  "509U"                       => 1708808,
  "510C"                       => 1704448,
  "510U"                       => 1380357,
  "5115C"                      => 811274555,
  "5115U"                      => 1509944,
  "511C"                       => 761007151,
  "511U"                       => 1772343,
  "5125C"                      => 810684450,
  "5125U"                      => 1377331,
  "512C"                       => 811598090,
  "512U"                       => 2361390,
  "5135C"                      => 725881107,
  "5135U"                      => 1246253,
  "513C"                       => 811597824,
  "513U"                       => 2622502,
  "5145C"                      => 573902087,
  "5145U"                      => 1049380,
  "514C"                       => 238223360,
  "514U"                       => 2163987,
  "5155C"                      => 337708801,
  "5155U"                      => 984091,
  "515C"                       => 119734272,
  "515U"                       => 1771019,
  "5165C"                      => 185926400,
  "5165U"                      => 787476,
  "516C"                       => 68812800,
  "516U"                       => 1443081,
  "5175C"                      => 152175360,
  "517C"                       => 18219008,
  "517U"                       => 1115653,
  "5185C"                      => 961683003,
  "5185U"                      => 1182262,
  "518C"                       => 1012143670,
  "5195C"                      => 843651619,
  "5195U"                      => 1050417,
  "519C"                       => 1046218274,
  "5205C"                      => 691672336,
  "5205U"                      => 984108,
  "520C"                       => 1063452692,
  "5215C"                      => 455478275,
  "5215U"                      => 918564,
  "521C"                       => 590741504,
  "5225C"                      => 303761152,
  "5225U"                      => 722200,
  "522C"                       => 405274624,
  "5235C"                      => 219546880,
  "5235U"                      => 591120,
  "523C"                       => 270401536,
  "523U"                       => 34471952,
  "5245C"                      => 135201024,
  "5245U"                      => 525324,
  "524C"                       => 185925632,
  "524U"                       => 17432590,
  "5255C"                      => 1683882062,
  "5255U"                      => 236191802,
  "525C"                       => 1080164641,
  "525U"                       => 35258422,
  "5265C"                      => 1347291942,
  "5265U"                      => 269615153,
  "526C"                       => 1113849856,
  "526U"                       => 203948075,
  "5275C"                      => 1128206101,
  "5275U"                      => 269549611,
  "527C"                       => 1046282240,
  "527U"                       => 271384607,
  "5285C"                      => 740821509,
  "5285U"                      => 219021345,
  "528C"                       => 523632640,
  "528U"                       => 203620370,
  "5295C"                      => 471335936,
  "5295U"                      => 151650328,
  "529C"                       => 321257472,
  "529U"                       => 135987212,
  "5305C"                      => 319815936,
  "5305U"                      => 101187602,
  "530C"                       => 203096064,
  "530U"                       => 85196809,
  "5315C"                      => 185139200,
  "5315U"                      => 50593804,
  "531C"                       => 135528448,
  "531U"                       => 51314696,
  "532C"                       => 1548295513,
  "532U"                       => 151519293,
  "533C"                       => 1581843781,
  "533U"                       => 370147381,
  "534C"                       => 1682374707,
  "534U"                       => 521470001,
  "535C"                       => 739968258,
  "535U"                       => 403636252,
  "536C"                       => 605225728,
  "536U"                       => 319488020,
  "537C"                       => 403439872,
  "537U"                       => 218562575,
  "538C"                       => 319357440,
  "538U"                       => 151257100,
  "5395C"                      => 1680607835,
  "5395U"                      => 336527425,
  "539C"                       => 1680539731,
  "539U"                       => 487718974,
  "5405C"                      => 1160057616,
  "5405U"                      => 487391282,
  "540C"                       => 1681195073,
  "540U"                       => 723124280,
  "5415C"                      => 1092751371,
  "5415U"                      => 487325739,
  "541C"                       => 1681719339,
  "541U"                       => 891224115,
  "5425C"                      => 874056964,
  "5425U"                      => 453705763,
  "542C"                       => 856686592,
  "542U"                       => 789905430,
  "5435C"                      => 571344384,
  "5435U"                      => 336068631,
  "543C"                       => 587661312,
  "543U"                       => 705888274,
  "5445C"                      => 436863744,
  "5445U"                      => 252051473,
  "544C"                       => 402915328,
  "544U"                       => 537722893,
  "5455C"                      => 386400768,
  "5455U"                      => 184811532,
  "545C"                       => 335740928,
  "545U"                       => 403308554,
  "5463C"                      => 1662984794,
  "5463U"                      => 470351938,
  "5467C"                      => 1478835024,
  "5467U"                      => 201326655,
  "546C"                       => 1629495894,
  "546U"                       => 336134209,
  "5473C"                      => 1444421931,
  "5473U"                      => 520552502,
  "5477C"                      => 1193553959,
  "5477U"                      => 251658296,
  "547C"                       => 1678447698,
  "547U"                       => 604897340,
  "5483C"                      => 1142365198,
  "5483U"                      => 520421422,
  "5487C"                      => 1025517333,
  "5487U"                      => 268501043,
  "548C"                       => 1678248778,
  "548U"                       => 739180600,
  "5493C"                      => 856626179,
  "5493U"                      => 470024228,
  "5497C"                      => 806886663,
  "5497U"                      => 218103850,
  "549C"                       => 957352450,
  "549U"                       => 671875104,
  "5503C"                      => 705368064,
  "5503U"                      => 352518170,
  "5507C"                      => 638719489,
  "5507U"                      => 184549666,
  "550C"                       => 738854400,
  "550U"                       => 604700697,
  "5513C"                      => 537332224,
  "5513U"                      => 268501012,
  "5517C"                      => 487395328,
  "5517U"                      => 150995483,
  "551C"                       => 587596800,
  "551U"                       => 453443603,
  "5523C"                      => 453314560,
  "5523U"                      => 201326608,
  "5527C"                      => 403311872,
  "5527U"                      => 134218262,
  "552C"                       => 419692800,
  "552U"                       => 335872014,
  "5535C"                      => 1461667158,
  "5535U"                      => 318767937,
  "553C"                       => 1293699651,
  "553U"                       => 218106683,
  "5545C"                      => 1176188451,
  "5545U"                      => 318768694,
  "554C"                       => 1343244339,
  "554U"                       => 419434038,
  "5555C"                      => 1041772309,
  "5555U"                      => 285213996,
  "555C"                       => 1292649507,
  "555U"                       => 536875059,
  "5565C"                      => 840115207,
  "5565U"                      => 251659556,
  "556C"                       => 940321799,
  "556U"                       => 469765158,
  "5575C"                      => 722476547,
  "5575U"                      => 218105117,
  "557C"                       => 805970947,
  "557U"                       => 402656030,
  "5585C"                      => 571152640,
  "5585U"                      => 201327899,
  "558C"                       => 671554816,
  "558U"                       => 335546649,
  "5595C"                      => 386273792,
  "5595U"                      => 134219026,
  "559C"                       => 520361472,
  "559U"                       => 218105874,
  "5605C"                      => 1310935630,
  "5605U"                      => 167774779,
  "560C"                       => 1444823371,
  "560U"                       => 335545151,
  "5615C"                      => 958280987,
  "5615U"                      => 201328437,
  "561C"                       => 1527594037,
  "561U"                       => 603981113,
  "5625C"                      => 874196241,
  "5625U"                      => 201328174,
  "562C"                       => 1543976739,
  "562U"                       => 805307698,
  "5635C"                      => 672407813,
  "5635U"                      => 167773734,
  "563C"                       => 973086464,
  "563U"                       => 603981083,
  "5645C"                      => 588323842,
  "5645U"                      => 150996511,
  "564C"                       => 788535552,
  "564U"                       => 520094998,
  "5655C"                      => 487397120,
  "5655U"                      => 117441817,
  "565C"                       => 587207424,
  "565U"                       => 520095250,
  "5665C"                      => 403378944,
  "5665U"                      => 100664598,
  "566C"                       => 419433984,
  "566U"                       => 335545612,
  "567C"                       => 1477984842,
  "567U"                       => 419431997,
  "568U"                       => 771754290,
  "569C"                       => 1610693396,
  "569U"                       => 1157630252,
  "570C"                       => 905977344,
  "570U"                       => 822085912,
  "571C"                       => 603984384,
  "571U"                       => 637536015,
  "572C"                       => 503320320,
  "572U"                       => 553649933,
  "573C"                       => 402656000,
  "573U"                       => 352322569,
  "5743C"                      => 823810118,
  "5743U"                      => 83892027,
  "5747C"                      => 655581260,
  "5747U"                      => 50340151,
  "574C"                       => 823547194,
  "574U"                       => 134224439,
  "5753C"                      => 739790895,
  "5753U"                      => 100668979,
  "5757C"                      => 538007854,
  "5757U"                      => 50339632,
  "575C"                       => 789141027,
  "575U"                       => 251666993,
  "5763C"                      => 689390879,
  "5763U"                      => 117445423,
  "5767C"                      => 554847001,
  "5767U"                      => 50339112,
  "576C"                       => 805719825,
  "576U"                       => 352331047,
  "5773C"                      => 638991122,
  "5773U"                      => 67113509,
  "5777C"                      => 504380427,
  "5777U"                      => 33561378,
  "577C"                       => 570636033,
  "577U"                       => 285220894,
  "5783C"                      => 538062599,
  "5783U"                      => 50335515,
  "5787C"                      => 403451395,
  "5787U"                      => 33560857,
  "578C"                       => 469838848,
  "578U"                       => 251665431,
  "5793C"                      => 453912066,
  "5793U"                      => 33557781,
  "5797C"                      => 336144128,
  "5797U"                      => 16783125,
  "579C"                       => 419506688,
  "579U"                       => 184555794,
  "5803C"                      => 353050624,
  "5803U"                      => 33557777,
  "5807C"                      => 268836608,
  "5807U"                      => 16782353,
  "580C"                       => 352331264,
  "580U"                       => 151000590,
  "5815C"                      => 488463169,
  "5815U"                      => 205367,
  "581C"                       => 370499644,
  "581U"                       => 206645,
  "5825C"                      => 437669920,
  "5825U"                      => 270637,
  "582C"                       => 268723237,
  "582U"                       => 13355,
  "5835C"                      => 437535504,
  "5835U"                      => 204586,
  "583C"                       => 402678534,
  "583U"                       => 117456926,
  "5845C"                      => 403847432,
  "5845U"                      => 138787,
  "584C"                       => 285231872,
  "584U"                       => 67122448,
  "5855C"                      => 353251075,
  "5855U"                      => 203802,
  "585C"                       => 201342976,
  "585U"                       => 16787978,
  "5865C"                      => 285879041,
  "5865U"                      => 138004,
  "586C"                       => 151010048,
  "586U"                       => 16787977,
  "5875C"                      => 235414784,
  "5875U"                      => 137488,
  "587C"                       => 117453568,
  "587U"                       => 9223,
  "600C"                       => 16788480,
  "600U"                       => 205367,
  "601C"                       => 33566976,
  "601U"                       => 207363,
  "602C"                       => 33569536,
  "602U"                       => 274179,
  "603C"                       => 67128832,
  "603U"                       => 408325,
  "604C"                       => 83908608,
  "604U"                       => 476167,
  "605C"                       => 67200004,
  "605U"                       => 674571,
  "606C"                       => 418829,
  "606U"                       => 741395,
  "607C"                       => 67120128,
  "607U"                       => 270853,
  "608C"                       => 83899648,
  "608U"                       => 272390,
  "609C"                       => 117455872,
  "609U"                       => 339207,
  "610C"                       => 167987712,
  "610U"                       => 407052,
  "611C"                       => 184900100,
  "611U"                       => 539926,
  "612C"                       => 67462161,
  "612U"                       => 606748,
  "613C"                       => 17392668,
  "613U"                       => 606500,
  "614C"                       => 184887552,
  "614U"                       => 269324,
  "615C"                       => 218640384,
  "615U"                       => 270095,
  "616C"                       => 252261377,
  "616U"                       => 270868,
  "617C"                       => 319635974,
  "617U"                       => 337179,
  "618C"                       => 319836690,
  "618U"                       => 338211,
  "619C"                       => 269507356,
  "619U"                       => 404521,
  "620C"                       => 168845868,
  "620U"                       => 405039,
  "621C"                       => 218106112,
  "621U"                       => 150996237,
  "622C"                       => 453317120,
  "622U"                       => 201327892,
  "623C"                       => 671750913,
  "623U"                       => 285214237,
  "624C"                       => 890250759,
  "624U"                       => 318768677,
  "625C"                       => 1108685078,
  "625U"                       => 369100334,
  "626C"                       => 1343568944,
  "626U"                       => 402654518,
  "627C"                       => 1495024211,
  "627U"                       => 436208960,
  "628C"                       => 419431424,
  "628U"                       => 369295370,
  "629C"                       => 603981056,
  "629U"                       => 604373005,
  "630C"                       => 838862848,
  "630U"                       => 772341776,
  "631C"                       => 1124207360,
  "631U"                       => 973864980,
  "632C"                       => 1460145671,
  "632U"                       => 1158676509,
  "633C"                       => 1678051614,
  "633U"                       => 1259470886,
  "634C"                       => 1678115120,
  "634U"                       => 1259601966,
  "635C"                       => 536871168,
  "635U"                       => 486932486,
  "636C"                       => 704643072,
  "636U"                       => 705232903,
  "637C"                       => 1006633472,
  "637U"                       => 990707722,
  "638C"                       => 1291846400,
  "638U"                       => 1309736973,
  "639C"                       => 1627652866,
  "639U"                       => 1679228948,
  "640C"                       => 1678245900,
  "640U"                       => 1679425563,
  "641C"                       => 1679163421,
  "641U"                       => 1679556643,
  "642C"                       => 251920384,
  "642U"                       => 168034312,
  "643C"                       => 335937536,
  "643U"                       => 285736970,
  "644C"                       => 638517248,
  "644U"                       => 437059600,
  "645C"                       => 857145345,
  "645U"                       => 554762263,
  "646C"                       => 1092747777,
  "646U"                       => 622067743,
  "647C"                       => 1479803660,
  "647U"                       => 655753254,
  "648C"                       => 1682243640,
  "648U"                       => 672727089,
  "649C"                       => 184745984,
  "649U"                       => 84082695,
  "650C"                       => 268828672,
  "650U"                       => 151322632,
  "651C"                       => 554631168,
  "651U"                       => 336265230,
  "652C"                       => 874184705,
  "652U"                       => 504430615,
  "653C"                       => 1412825866,
  "653U"                       => 622198820,
  "654C"                       => 1682505761,
  "654U"                       => 655949869,
  "655C"                       => 1682505789,
  "655U"                       => 656080946,
  "656C"                       => 167903232,
  "656U"                       => 117637125,
  "657C"                       => 319225856,
  "657U"                       => 201785349,
  "658C"                       => 487260160,
  "658U"                       => 386727943,
  "659C"                       => 857341952,
  "659U"                       => 571801610,
  "660C"                       => 1244397568,
  "660U"                       => 840957972,
  "661C"                       => 1683030029,
  "661U"                       => 942080033,
  "662C"                       => 1683423268,
  "662U"                       => 908722220,
  "663C"                       => 84279296,
  "663U"                       => 262155,
  "664C"                       => 101187584,
  "664U"                       => 17170445,
  "665C"                       => 320208896,
  "665U"                       => 67829779,
  "666C"                       => 589759490,
  "666U"                       => 118358042,
  "667C"                       => 876218376,
  "667U"                       => 185794597,
  "668C"                       => 1095239698,
  "668U"                       => 185925675,
  "669C"                       => 1348534317,
  "669U"                       => 185991218,
  "670C"                       => 17760256,
  "670U"                       => 787973,
  "671C"                       => 35389440,
  "671U"                       => 1181702,
  "672C"                       => 86638592,
  "672U"                       => 1838089,
  "673C"                       => 104267776,
  "673U"                       => 2429197,
  "674C"                       => 239861760,
  "674U"                       => 2888980,
  "675C"                       => 291635463,
  "675U"                       => 3283480,
  "676C"                       => 6555427,
  "676U"                       => 3415074,
  "677C"                       => 51445760,
  "677U"                       => 853766,
  "678C"                       => 68419584,
  "678U"                       => 1050378,
  "679C"                       => 102301696,
  "679U"                       => 1509901,
  "680C"                       => 237764608,
  "680U"                       => 1838105,
  "681C"                       => 406848515,
  "681U"                       => 2101027,
  "682C"                       => 491784204,
  "682U"                       => 2298156,
  "683C"                       => 425723686,
  "683U"                       => 2430257,
  "684C"                       => 68485120,
  "684U"                       => 919559,
  "685C"                       => 102563840,
  "685U"                       => 1116682,
  "6865U"                      => 138004,
  "686C"                       => 187105536,
  "686U"                       => 1444624,
  "687C"                       => 322110722,
  "687U"                       => 1773081,
  "688C"                       => 440469767,
  "688U"                       => 1904164,
  "689C"                       => 542444567,
  "689U"                       => 2036012,
  "690C"                       => 442633531,
  "690U"                       => 2299699,
  "691C"                       => 17892608,
  "691U"                       => 789509,
  "692C"                       => 51972096,
  "692U"                       => 1183497,
  "693C"                       => 119934464,
  "693U"                       => 1643790,
  "694C"                       => 204674309,
  "694U"                       => 1840920,
  "695C"                       => 255662603,
  "695U"                       => 2103840,
  "696C"                       => 273425947,
  "696U"                       => 2235688,
  "697C"                       => 256912932,
  "697U"                       => 2433582,
  "698C"                       => 983808,
  "698U"                       => 920834,
  "699C"                       => 1639424,
  "699U"                       => 1512193,
  "700C"                       => 2427136,
  "700U"                       => 2038531,
  "701C"                       => 3674112,
  "701U"                       => 2564361,
  "702C"                       => 38346243,
  "702U"                       => 2893327,
  "703C"                       => 56112144,
  "703U"                       => 3288093,
  "704C"                       => 23022367,
  "704U"                       => 3354404,
  "705C"                       => 786432,
  "705U"                       => 854784,
  "706C"                       => 1245184,
  "706U"                       => 1380608,
  "707C"                       => 2163712,
  "707U"                       => 2038016,
  "708C"                       => 3411712,
  "708U"                       => 2630144,
  "709C"                       => 4792320,
  "709U"                       => 3288067,
  "710C"                       => 5782016,
  "710U"                       => 3748619,
  "711C"                       => 6181893,
  "711U"                       => 4012819,
  "712C"                       => 1255424,
  "712U"                       => 1385984,
  "713C"                       => 1650944,
  "713U"                       => 1584128,
  "714C"                       => 2376192,
  "714U"                       => 2044928,
  "715C"                       => 3300608,
  "715U"                       => 2571266,
  "716C"                       => 3892224,
  "716U"                       => 2834696,
  "717C"                       => 4547586,
  "717U"                       => 3032592,
  "718C"                       => 4875276,
  "718U"                       => 3032342,
  "719C"                       => 17964800,
  "719U"                       => 1188101,
  "720C"                       => 35269376,
  "720U"                       => 1385991,
  "721C"                       => 69350915,
  "721U"                       => 1649420,
  "722C"                       => 70142733,
  "722U"                       => 1847061,
  "723C"                       => 20405785,
  "723U"                       => 1978651,
  "724C"                       => 4219945,
  "724U"                       => 1979427,
  "725C"                       => 4482101,
  "725U"                       => 1979434,
  "726C"                       => 102048000,
  "726U"                       => 989961,
  "727C"                       => 135931650,
  "727U"                       => 1187854,
  "728C"                       => 169881862,
  "728U"                       => 1319957,
  "729C"                       => 170606866,
  "729U"                       => 1451291,
  "730C"                       => 120804641,
  "730U"                       => 1583395,
  "731C"                       => 4154425,
  "731U"                       => 1583658,
  "732C"                       => 4547652,
  "732U"                       => 1583919,
  "7401C"                      => 532740,
  "7401U"                      => 664320,
  "7402C"                      => 401927,
  "7402U"                      => 664837,
  "7403C"                      => 732423,
  "7403U"                      => 995076,
  "7404C"                      => 739844,
  "7404U"                      => 1198593,
  "7405C"                      => 1008645,
  "7405U"                      => 1531402,
  "7406C"                      => 1270789,
  "7406U"                      => 1594117,
  "7407C"                      => 1391636,
  "7407U"                      => 1322516,
  "7408C"                      => 1532932,
  "7408U"                      => 2249735,
  "7409C"                      => 1660166,
  "7409U"                      => 1983491,
  "7410C"                      => 2110720,
  "7410U"                      => 2439424,
  "7411C"                      => 1850378,
  "7411U"                      => 2044937,
  "7412C"                      => 2509585,
  "7412U"                      => 2176530,
  "7413C"                      => 2575630,
  "7413U"                      => 2505741,
  "7414C"                      => 2906136,
  "7414U"                      => 2242841,
  "7415C"                      => 1252106,
  "7415U"                      => 1515016,
  "7416C"                      => 3555082,
  "7416U"                      => 3290888,
  "7417C"                      => 4279052,
  "7417U"                      => 3553801,
  "7418C"                      => 3880980,
  "7418U"                      => 3157785,
  "7419C"                      => 3813663,
  "7419U"                      => 3813663,
  "7420C"                      => 5126439,
  "7420U"                      => 3089700,
  "7421C"                      => 4731452,
  "7421U"                      => 2497331,
  "7422C"                      => 1051908,
  "7422U"                      => 1052161,
  "7423C"                      => 3680268,
  "7423U"                      => 3155211,
  "7424C"                      => 4532491,
  "7424U"                      => 3942927,
  "7425C"                      => 5256477,
  "7425U"                      => 3417883,
  "7426C"                      => 5848612,
  "7426U"                      => 3418143,
  "7427C"                      => 5391657,
  "7427U"                      => 3288099,
  "7428C"                      => 3811898,
  "7428U"                      => 1840178,
  "7429C"                      => 1116683,
  "7429U"                      => 919815,
  "7430C"                      => 1510670,
  "7430U"                      => 1379594,
  "7431C"                      => 2364693,
  "7431U"                      => 1708046,
  "7432C"                      => 3218717,
  "7432U"                      => 2299415,
  "7433C"                      => 4270115,
  "7433U"                      => 4270115,
  "7434C"                      => 4401959,
  "7434U"                      => 2562594,
  "7435C"                      => 4728879,
  "7435U"                      => 2562093,
  "7436C"                      => 524807,
  "7436U"                      => 786949,
  "7437C"                      => 34603026,
  "7437U"                      => 17760272,
  "7438C"                      => 18546704,
  "7438U"                      => 1835024,
  "7439C"                      => 68812827,
  "7439U"                      => 51707926,
  "7440C"                      => 35389475,
  "7440U"                      => 34799643,
  "7441C"                      => 288620569,
  "7441U"                      => 237371413,
  "7442C"                      => 356778010,
  "7442U"                      => 288358425,
  "7443C"                      => 84279305,
  "7443U"                      => 101187592,
  "7444C"                      => 286261262,
  "7444U"                      => 286261259,
  "7445C"                      => 235995160,
  "7445U"                      => 235929622,
  "7446C"                      => 539099157,
  "7446U"                      => 488439827,
  "7447C"                      => 371720245,
  "7447U"                      => 219480107,
  "7448C"                      => 18481222,
  "7448U"                      => 34209847,
  "7449C"                      => 2623819,
  "7449U"                      => 1181501,
  "7450C"                      => 235536398,
  "7450U"                      => 218693644,
  "7451C"                      => 672727051,
  "7451U"                      => 622329864,
  "7452C"                      => 706805773,
  "7452U"                      => 605945867,
  "7453C"                      => 739835917,
  "7453U"                      => 672661515,
  "7454C"                      => 789905437,
  "7454U"                      => 621936667,
  "7455C"                      => 1127153696,
  "7455U"                      => 706740251,
  "7456C"                      => 774242334,
  "7456U"                      => 555548697,
  "7457C"                      => 318963722,
  "7457U"                      => 319029255,
  "7458C"                      => 738918421,
  "7458U"                      => 772669465,
  "7459C"                      => 1074790429,
  "7459U"                      => 873463841,
  "7460C"                      => 1679687705,
  "7460U"                      => 1679425561,
  "7461C"                      => 1679884315,
  "7461U"                      => 1109000214,
  "7462C"                      => 1680277549,
  "7462U"                      => 806944804,
  "7463C"                      => 1680408647,
  "7463U"                      => 588447795,
  "7464C"                      => 385876754,
  "7464U"                      => 369099278,
  "7465C"                      => 1124076312,
  "7465U"                      => 956303638,
  "7467C"                      => 1678114848,
  "7467U"                      => 1678049311,
  "7468C"                      => 1679294504,
  "7468U"                      => 957546538,
  "7469C"                      => 1679622191,
  "7469U"                      => 940834862,
  "7470C"                      => 1678966840,
  "7470U"                      => 823066673,
  "7471C"                      => 721421581,
  "7471U"                      => 738198539,
  "7472C"                      => 838861596,
  "7472U"                      => 721420826,
  "7473C"                      => 1258293800,
  "7473U"                      => 721422115,
  "7474C"                      => 1678311473,
  "7474U"                      => 889651242,
  "7475C"                      => 704708660,
  "7475U"                      => 402718765,
  "7476C"                      => 1426456642,
  "7476U"                      => 453181492,
  "7477C"                      => 1007681601,
  "7477U"                      => 386334773,
  "7478C"                      => 536875019,
  "7478U"                      => 536875016,
  "7479C"                      => 1375741970,
  "7479U"                      => 1342187028,
  "7480C"                      => 1677732377,
  "7480U"                      => 1677730328,
  "7481C"                      => 1677736220,
  "7481U"                      => 1677732123,
  "7482C"                      => 1677734950,
  "7482U"                      => 1291854115,
  "7483C"                      => 973088832,
  "7483U"                      => 436212277,
  "7484C"                      => 1677728834,
  "7484U"                      => 620760377,
  "7485C"                      => 100667405,
  "7485U"                      => 117444619,
  "7486C"                      => 268444172,
  "7486U"                      => 318776075,
  "7487C"                      => 603993613,
  "7487U"                      => 637546252,
  "7488C"                      => 738214160,
  "7488U"                      => 872429842,
  "7489C"                      => 536884513,
  "7489U"                      => 486548513,
  "7490C"                      => 436220968,
  "7490U"                      => 369106982,
  "7491C"                      => 167786287,
  "7491U"                      => 134225709,
  "7492C"                      => 100672788,
  "7492U"                      => 117448981,
  "7493C"                      => 83892759,
  "7493U"                      => 83891992,
  "7494C"                      => 184555039,
  "7494U"                      => 167776799,
  "7495C"                      => 117455656,
  "7495U"                      => 134227244,
  "7496C"                      => 218124079,
  "7496U"                      => 184560944,
  "7497C"                      => 466484,
  "7497U"                      => 265773,
  "7498C"                      => 117452094,
  "7498U"                      => 83891251,
  "7499C"                      => 334341,
  "7499U"                      => 334082,
  "7500C"                      => 399629,
  "7500U"                      => 465418,
  "7501C"                      => 531215,
  "7501U"                      => 596493,
  "7502C"                      => 729619,
  "7502U"                      => 794646,
  "7503C"                      => 599586,
  "7503U"                      => 465702,
  "7504C"                      => 1189162,
  "7504U"                      => 792362,
  "7505C"                      => 1716785,
  "7505U"                      => 923951,
  "7506C"                      => 530950,
  "7506U"                      => 662274,
  "7507C"                      => 1124097,
  "7507U"                      => 860416,
  "7508C"                      => 1190924,
  "7508U"                      => 1321228,
  "7509C"                      => 1521424,
  "7509U"                      => 1518866,
  "7510C"                      => 2049046,
  "7510U"                      => 1782041,
  "7511C"                      => 2313756,
  "7511U"                      => 1913891,
  "7512C"                      => 2642979,
  "7512U"                      => 1914153,
  "7513C"                      => 1251852,
  "7513U"                      => 1250825,
  "7514C"                      => 1582352,
  "7514U"                      => 1448975,
  "7515C"                      => 1912599,
  "7515U"                      => 1712920,
  "7516C"                      => 1911082,
  "7516U"                      => 1845029,
  "7517C"                      => 3296560,
  "7517U"                      => 1911082,
  "7518C"                      => 1844025,
  "7518U"                      => 789553,
  "7519C"                      => 1254208,
  "7519U"                      => 593206,
  "7520C"                      => 1251592,
  "7520U"                      => 1250565,
  "7521C"                      => 1253401,
  "7521U"                      => 1185815,
  "7522C"                      => 2700573,
  "7522U"                      => 2040607,
  "7523C"                      => 3027233,
  "7523U"                      => 2039330,
  "7524C"                      => 3291172,
  "7524U"                      => 2171684,
  "7525C"                      => 2044200,
  "7525U"                      => 1383208,
  "7526C"                      => 3887150,
  "7526U"                      => 2305067,
  "7527C"                      => 133136,
  "7527U"                      => 132366,
  "7528C"                      => 396567,
  "7528U"                      => 329490,
  "7529C"                      => 528412,
  "7529U"                      => 395803,
  "7530C"                      => 660516,
  "7530U"                      => 527394,
  "7531C"                      => 990772,
  "7531U"                      => 593197,
  "7532C"                      => 1189437,
  "7532U"                      => 528181,
  "7533C"                      => 1518152,
  "7533U"                      => 593977,
  "7534C"                      => 133650,
  "7534U"                      => 132626,
  "7535C"                      => 266012,
  "7535U"                      => 198681,
  "7536C"                      => 266787,
  "7536U"                      => 264735,
  "7537C"                      => 50333217,
  "7537U"                      => 33554716,
  "7538C"                      => 67110440,
  "7538U"                      => 50331937,
  "7539C"                      => 16778540,
  "7539U"                      => 33620005,
  "7540C"                      => 184942659,
  "7540U"                      => 168165427,
  "7541C"                      => 67108875,
  "7541U"                      => 67174410,
  "7542C"                      => 251854872,
  "7543C"                      => 218497056,
  "7543U"                      => 151257113,
  "7544C"                      => 319291435,
  "7544U"                      => 201719839,
  "7545C"                      => 554565693,
  "7545U"                      => 252182572,
  "7546C"                      => 789905481,
  "7546U"                      => 268959796,
  "7547C"                      => 907739220,
  "7547U"                      => 218759232,
  "801C"                       => 1426065408,
  "801U"                       => 1679294484,
  "802C"                       => 855659776,
  "802U"                       => 1207977746,
  "803C"                       => 221440,
  "803U"                       => 613120,
  "804C"                       => 2703104,
  "804U"                       => 2180096,
  "805C"                       => 3811584,
  "805U"                       => 3618048,
  "806C"                       => 4718592,
  "806U"                       => 4726528,
  "807C"                       => 206307328,
  "807U"                       => 4985353,
  "808C"                       => 1677726236,
  "808U"                       => 1677725985,
  "809C"                       => 33575433,
  "809U"                       => 33573641,
  "810C"                       => 1068800,
  "810U"                       => 1133568,
  "811C"                       => 2898432,
  "811U"                       => 3095552,
  "812C"                       => 4137984,
  "812U"                       => 4270592,
  "813C"                       => 4658690,
  "813U"                       => 4790532,
  "814C"                       => 590479377,
  "814U"                       => 641007638,
  "alabaster"                  => 0,
  "alaska sky"                 => 1362559021,
  "aliceblue (svg)"            => 100859904,
  "alizarin red"               => 6317078,
  "aluminum"                   => 117768221,
  "amarante"                   => 4733739,
  "amber"                      => 1270790,
  "amethyst"                   => 322306083,
  "aniline black"              => 304676955,
  "animal black"               => 100,
  "anise green"                => 620780544,
  "anjou pear"                 => 417819,
  "antiquewhite (svg)"         => 396802,
  "antiquewhite1"              => 396800,
  "antiquewhite4"              => 396845,
  "apple green"                => 1241534997,
  "apricot"                    => 2969354,
  "aquamarine"                 => 855638019,
  "aquamarine (svg)"           => 838865152,
  "aquamarine4"                => 838865197,
  "aquarium"                   => 1207962657,
  "ash"                        => 133398,
  "asparagus"                  => 385887013,
  "aubergine"                  => 6560590,
  "auburn"                     => 4021286,
  "aurore"                     => 1326592,
  "avacado"                    => 268449560,
  "azur mist"                  => 100663296,
  "azure3"                     => 100663316,
  "azurin"                     => 557056000,
  "barney"                     => 5054993,
  "bartlett pear"              => 1134100,
  "battleship"                 => 16779026,
  "beach sand"                 => 662023,
  "beef blood"                 => 6120503,
  "beige"                      => 926998,
  "beige (svg)"                => 2564,
  "beigeasse"                  => 335391,
  "belly doe"                  => 923657,
  "berlin blue"                => 1025114176,
  "bi"                         => 398597,
  "bishop violet"              => 3017783,
  "bisque"                     => 726784,
  "bisque3"                    => 726804,
  "bistre"                     => 1190448,
  "bitumen"                    => 1454405,
  "black"                      => 100,
  "black (safe 16 svg hex3)"   => 100,
  "black 2U"                   => 266813,
  "black 3U"                   => 67109952,
  "black 4U"                   => 594491,
  "black 5U"                   => 920635,
  "black 6U"                   => 201916482,
  "black 7U"                   => 263994,
  "black coal"                 => 100,
  "black ink"                  => 100,
  "black smoke"                => 1716061,
  "Black U"                    => 264254,
  "blackberry"                 => 845,
  "blet"                       => 2249024,
  "bleu de france"             => 1327955977,
  "blonde"                     => 1126667,
  "bloodorange (hex3)"         => 6054932,
  "bloodred (safe hex3)"       => 6579260,
  "blue"                       => 1428488212,
  "Blue 072 U"                 => 1077739552,
  "blue corn chips"            => 721473,
  "blue cornflower"            => 874643488,
  "blue horizon"               => 386793507,
  "blue ice"                   => 184549892,
  "blue jeans"                 => 655884346,
  "blue jumped"                => 1678901277,
  "blue line"                  => 1293615117,
  "blue ridge mtns"            => 1092943891,
  "blue sky"                   => 891092992,
  "blue south sea"             => 1677721620,
  "blue wagon"                 => 470941718,
  "blue woad"                  => 739835944,
  "blueberry fresh"            => 824377376,
  "bluegrass"                  => 536873784,
  "bone (safe hex3)"           => 5120,
  "bordeaux"                   => 6179897,
  "breadfruit"                 => 251677479,
  "brick"                      => 4280368,
  "bright red (safe hex3)"     => 6574080,
  "brightgold"                 => 22543,
  "bronze"                     => 1329470,
  "bronzeii"                   => 1654563,
  "brooms rose"                => 3021591,
  "brown"                      => 3499073,
  "brown (svg)"                => 4934435,
  "brown2"                     => 4934407,
  "brown4"                     => 4934445,
  "brownmadder"                => 5329166,
  "brownochre"                 => 3362095,
  "brushed aluminum"           => 134218775,
  "bubble gum"                 => 2824960,
  "bulle"                      => 731399,
  "burlywood (svg)"            => 1124109,
  "burnt orange"               => 3826708,
  "butter"                     => 341766,
  "buttermilk"                 => 335104,
  "byzantine"                  => 4787482,
  "byzantium"                  => 4131896,
  "cachou"                     => 2837074,
  "cadetblue"                  => 671088678,
  "cadetblue3"                 => 671350804,
  "cadmiumorange"              => 4088576,
  "cadmiumredlight"            => 6512384,
  "caeruleum"                  => 1410400263,
  "cafe"                       => 2253641,
  "cafe americano"             => 1717839,
  "camel hair"                 => 2248989,
  "camo2"                      => 268440085,
  "candy pink"                 => 4859138,
  "cannelle"                   => 1980979,
  "canvas"                     => 864294,
  "caramel"                    => 3957811,
  "carbon black"               => 1716061,
  "cardinal red"               => 5462812,
  "carmine red"                => 6575145,
  "carnation"                  => 2626573,
  "carrot"                     => 3691781,
  "cashew"                     => 1454093,
  "cassis"                     => 6377037,
  "cat eye"                    => 756547597,
  "cauldron"                   => 2513200,
  "celadon"                    => 352323875,
  "cerulean"                   => 873332741,
  "cerulean blue"              => 1193345052,
  "chair"                      => 1515520,
  "chamois"                    => 534802,
  "champagne"                  => 269058,
  "charcoal grey"              => 1212235069,
  "chartreuse3"                => 838886420,
  "cherry"                     => 6184475,
  "chestnut"                   => 990770,
  "chickadee"                  => 67133190,
  "chili"                      => 4343057,
  "chip"                       => 4741189,
  "chocolate"                  => 2375233,
  "chocolate1"                 => 3298816,
  "chocolate3"                 => 3298836,
  "chrome"                     => 25088,
  "chrome green"               => 973090638,
  "chromeoxidegreen"           => 335565874,
  "cichlid"                    => 1682702336,
  "cinnabargreen"              => 771771678,
  "circuit board"              => 721435708,
  "clay"                       => 6,
  "clear blue"                 => 873332741,
  "clover"                     => 1023422245,
  "cobalt (safe hex3)"         => 1010565120,
  "cobalt blue"                => 1227817011,
  "cobalt yellow"              => 418816,
  "cobaltgreen"                => 973092907,
  "cobaltvioletdeep"           => 139395110,
  "cocoa"                      => 1517630,
  "coconut"                    => 70400,
  "coconut shell"              => 2441498,
  "coffee"                     => 3367457,
  "colombin"                   => 2296890,
  "concord grape"              => 560136232,
  "cool gray 1"                => 527,
  "cool gray 10U"              => 67305519,
  "cool gray 11U"              => 84082737,
  "cool gray 2"                => 277,
  "cool gray 3"                => 67305492,
  "cool gray 4U"               => 16842779,
  "cool gray 5U"               => 33619999,
  "cool gray 6U"               => 33620002,
  "cool gray 7U"               => 50397221,
  "cool gray 8U"               => 50462760,
  "cool gray 9U"               => 67239980,
  "cooler"                     => 754977351,
  "copper"                     => 2778142,
  "coral1"                     => 3621376,
  "corn"                       => 865792,
  "cornflower blue"            => 874643488,
  "cornsilk (svg)"             => 200192,
  "cornsilk2"                  => 200199,
  "cornsilk3"                  => 134676,
  "cornsilk4"                  => 134701,
  "cotton candy"               => 1838083,
  "cow tail 1"                 => 535320,
  "cow tail 2"                 => 663330,
  "cranberry"                  => 4794653,
  "cream city brick"           => 136203,
  "crimson"                    => 5982478,
  "crimson (svg)"              => 5982478,
  "crow wing"                  => 100,
  "cucumber"                   => 889200704,
  "curacao"                    => 859045915,
  "cyan"                       => 1392508930,
  "cyan2 (hex3)"               => 1677721607,
  "dark blue"                  => 1682636800,
  "dark gray"                  => 75,
  "dark green"                 => 1679385625,
  "dark magenta"               => 6553650,
  "dark wheat"                 => 928777,
  "darkgoldenrod (svg)"        => 1793564,
  "darkgoldenrod1"             => 1793536,
  "darkgray (svg)"             => 34,
  "darkgreencopper"            => 620758838,
  "darkgrey (svg)"             => 34,
  "darkkhaki (svg)"            => 207642,
  "darkmagenta (svg)"          => 6553645,
  "darkolivegreen"             => 10565,
  "darkolivegreen3"            => 352335892,
  "darkorange (svg)"           => 2974720,
  "darkorange1"                => 3302400,
  "darkorange4"                => 3302445,
  "darkorchid"                 => 424411156,
  "darkorchid1"                => 424411136,
  "darkseagreen2"              => 402659335,
  "darkseagreen4"              => 402659373,
  "darkslateblue (svg)"        => 808976429,
  "darkslategray1"             => 687865856,
  "darkslategray4"             => 687865901,
  "darktan"                    => 1978409,
  "darkviolet (svg)"           => 509870097,
  "darkwood"                   => 1913392,
  "deep red"                   => 426009625,
  "deeppink3"                  => 6040084,
  "deepskyblue (svg)"          => 1679360000,
  "deepskyblue3"               => 1679360020,
  "delft"                      => 1161232442,
  "denim"                      => 1025572897,
  "denim blue"                 => 1614282752,
  "desert sand"                => 593920,
  "diamond blue"               => 1578237961,
  "dimgray (svg)"              => 59,
  "dimgrey (svg)"              => 59,
  "dodgerblue3"                => 1479213076,
  "dodgerblue4"                => 1479278637,
  "dog tongue"                 => 2166020,
  "dorian"                     => 1293559611,
  "dove gray"                  => 526363,
  "duck"                       => 1628045352,
  "ebony"                      => 100,
  "ecru white"                 => 3072,
  "eggplant"                   => 68681775,
  "eggshell"                   => 527105,
  "egyptian blue"              => 1514471459,
  "electric blue"              => 1396047872,
  "emerald green"              => 1677736720,
  "english green"              => 973090638,
  "english red"                => 5660419,
  "englishred"                 => 4675601,
  "eton blue"                  => 419435286,
  "fauve"                      => 3563296,
  "fees butter"                => 273664,
  "fenway monster"             => 654442548,
  "fire truck green"           => 83911184,
  "firebrick4"                 => 5329197,
  "fishing"                    => 1645569,
  "flatpink (safe hex3)"       => 1315840,
  "flave"                      => 8714,
  "flax grey"                  => 185466887,
  "flax white"                 => 264194,
  "floralwhite (svg)"          => 132608,
  "fog"                        => 2580,
  "forest green"               => 1493185348,
  "fraser fir"                 => 469768506,
  "fresh green"                => 956308495,
  "frosted"                    => 637534226,
  "fuchsia"                    => 4925953,
  "fuchsia2 (hex3)"            => 6562048,
  "fumes"                      => 285671436,
  "gainsboro (svg)"            => 14,
  "gamboge"                    => 2317830,
  "ganegreen (hex3)"           => 14645,
  "garden hose"                => 1459624492,
  "garnet"                     => 5919289,
  "glycine"                    => 152764430,
  "gold (svg)"                 => 1074176,
  "gold4"                      => 1074221,
  "gold5"                      => 2509588,
  "golden button"              => 875777,
  "golden yellow"              => 680198,
  "goldenrod"                  => 12558,
  "goldenrod2"                 => 1594887,
  "goldochre"                  => 2642198,
  "goose caca"                 => 24084,
  "grapefruit"                 => 338437,
  "grass"                      => 989874458,
  "gray"                       => 38,
  "gray (16 svg)"              => 50,
  "gray iron"                  => 50,
  "gray1"                      => 99,
  "gray10"                     => 90,
  "gray11"                     => 89,
  "gray12"                     => 88,
  "gray13"                     => 87,
  "gray14"                     => 86,
  "gray15"                     => 85,
  "gray16"                     => 84,
  "gray17"                     => 83,
  "gray18"                     => 82,
  "gray19"                     => 81,
  "gray2"                      => 98,
  "gray20 (safe hex3)"         => 80,
  "gray21"                     => 79,
  "gray22"                     => 78,
  "gray23"                     => 77,
  "gray24"                     => 76,
  "gray25"                     => 75,
  "gray26"                     => 74,
  "gray27"                     => 73,
  "gray28"                     => 72,
  "gray29"                     => 71,
  "gray3"                      => 97,
  "gray30"                     => 70,
  "gray31"                     => 69,
  "gray32"                     => 68,
  "gray33 (hex3)"              => 67,
  "gray34"                     => 66,
  "gray35"                     => 65,
  "gray36"                     => 64,
  "gray37"                     => 63,
  "gray38"                     => 62,
  "gray39"                     => 61,
  "gray4"                      => 96,
  "gray40 (safe hex3)"         => 60,
  "gray42"                     => 58,
  "gray43"                     => 57,
  "gray44"                     => 56,
  "gray45"                     => 55,
  "gray46"                     => 54,
  "gray47"                     => 53,
  "gray48"                     => 52,
  "gray49"                     => 51,
  "gray5"                      => 95,
  "gray50"                     => 50,
  "gray51"                     => 49,
  "gray52"                     => 48,
  "gray53"                     => 47,
  "gray54"                     => 46,
  "gray55"                     => 45,
  "gray56"                     => 44,
  "gray57"                     => 43,
  "gray58"                     => 42,
  "gray59"                     => 41,
  "gray6"                      => 94,
  "gray60 (safe hex3)"         => 40,
  "gray61"                     => 39,
  "gray62"                     => 38,
  "gray63"                     => 37,
  "gray64"                     => 36,
  "gray65"                     => 35,
  "gray66"                     => 34,
  "gray67"                     => 33,
  "gray68"                     => 32,
  "gray69"                     => 31,
  "gray7"                      => 93,
  "gray70"                     => 30,
  "gray71"                     => 29,
  "gray72"                     => 28,
  "gray73"                     => 27,
  "gray74"                     => 26,
  "gray75"                     => 25,
  "gray76"                     => 24,
  "gray77"                     => 23,
  "gray78"                     => 22,
  "gray79"                     => 21,
  "gray8"                      => 92,
  "gray80 (safe hex3)"         => 20,
  "gray81"                     => 19,
  "gray82"                     => 18,
  "gray83"                     => 17,
  "gray84"                     => 16,
  "gray85"                     => 15,
  "gray86"                     => 14,
  "gray87"                     => 13,
  "gray88"                     => 12,
  "gray89"                     => 11,
  "gray9"                      => 91,
  "gray90"                     => 10,
  "gray91"                     => 9,
  "gray92"                     => 8,
  "gray93"                     => 7,
  "gray94"                     => 6,
  "gray95"                     => 5,
  "gray97"                     => 3,
  "gray98"                     => 2,
  "gray99"                     => 1,
  "green"                      => 1677747200,
  "green (16 svg)"             => 1677747250,
  "green algae"                => 704654113,
  "green almond"               => 570436887,
  "green apple"                => 587219753,
  "green ash"                  => 469763628,
  "green bottle"               => 1543527482,
  "green card"                 => 285213954,
  "green chartreuse"           => 352342019,
  "green empire"               => 1677739330,
  "green gables"               => 788531254,
  "green grape"                => 88595,
  "green grass"                => 1056984614,
  "green imperial"             => 1677739330,
  "green khaki"                => 201342766,
  "green lantern"              => 939539501,
  "green lawyer"               => 570450481,
  "green led"                  => 1056989185,
  "green leek"                 => 905978915,
  "green lime"                 => 352337170,
  "green meadow"               => 989874192,
  "green mist"                 => 352331527,
  "green opaline"              => 536873741,
  "green parrot"               => 1275086085,
  "green pepper"               => 905994803,
  "green prasin"               => 905978915,
  "green smaragdin"            => 1677736720,
  "green spinach"              => 687865925,
  "green stamp"                => 570432564,
  "Green U"                    => 1677726497,
  "green water"                => 452991237,
  "green3"                     => 1677747220,
  "greenyellow"                => 553660686,
  "greenyellow (svg)"          => 536891904,
  "grege"                      => 463643,
  "grenadine"                  => 4999433,
  "grey"                       => 62,
  "grey (16 svg)"              => 50,
  "guacamole"                  => 385885712,
  "gummi yellow"               => 876290,
  "hazel"                      => 2771242,
  "heather blue"               => 201719826,
  "heavenly blue"              => 1410400263,
  "heliotrope"                 => 221708288,
  "honey"                      => 1203983,
  "honeydew2"                  => 100664839,
  "hooker"                     => 1107319365,
  "hot pink"                   => 6566400,
  "hotpink (svg)"              => 3874048,
  "iceberg lettuce"            => 167784971,
  "imperial yellow"            => 741120,
  "indianred1"                 => 3815936,
  "indiglo"                    => 1644756992,
  "indigo"                     => 962854970,
  "indigo (svg)"               => 711196721,
  "indigo dye"                 => 1529544749,
  "indigo web"                 => 711196721,
  "ivory (svg)"                => 1536,
  "ivory black"                => 100,
  "ivory2"                     => 1543,
  "ivory3"                     => 1556,
  "ivory4"                     => 1581,
  "jade"                       => 704652809,
  "jet black"                  => 100,
  "jonathan apple"             => 4148254,
  "kermit"                     => 234904090,
  "khaki"                      => 870186,
  "khaki (svg)"                => 272902,
  "khaki1"                     => 273408,
  "khaki2"                     => 207879,
  "khaki3"                     => 207892,
  "khaki4"                     => 273453,
  "kiwi"                       => 301998632,
  "klein 1"                    => 1683423232,
  "klein 2"                    => 1246887987,
  "kumquat"                    => 2514958,
  "la maison bleue"            => 1042219008,
  "lake huron"                 => 621805610,
  "lake michigan"              => 990773272,
  "lake superior"              => 689307695,
  "lapis lazuli"               => 1277558823,
  "larch green"                => 838869816,
  "latte"                      => 1457461,
  "lavalliere"                 => 2509868,
  "lavender"                   => 606863367,
  "lavender (safe hex3)"       => 1638420,
  "lavender field"             => 35979317,
  "lavenderblush (svg)"        => 394240,
  "lavenderblush2"             => 394247,
  "lavenderblush3"             => 394260,
  "lavenderblush4"             => 394285,
  "lead"                       => 100728881,
  "lead white"                 => 0,
  "lemon"                      => 50351104,
  "lemonchiffon (svg)"         => 136192,
  "lemonchiffon2"              => 136199,
  "lemonchiffon3"              => 136212,
  "lemonchiffon4"              => 70445,
  "lichen green"               => 520102680,
  "licorice"                   => 1319250,
  "light"                      => 1455405,
  "light beige"                => 2600,
  "light blue"                 => 1176833280,
  "light copper"               => 1189383,
  "light cyan3"                => 201326612,
  "light goldenrod2"           => 535815,
  "light goldenrod3"           => 470292,
  "light gray"                 => 45,
  "light green (svg)"          => 654321415,
  "light pink1"                => 2104064,
  "light pink3"                => 2104084,
  "light salmon2"              => 2438151,
  "light skyblue1"             => 520814592,
  "light skyblue4"             => 520880173,
  "light slateblue"            => 808976384,
  "light steelblue1"           => 353107968,
  "light steelblue3"           => 353107988,
  "light wood"                 => 1121545,
  "light yellow2"              => 3079,
  "light yellow3"              => 3092,
  "light yellow4"              => 3117,
  "lightblue (svg)"            => 419823626,
  "lightcyan (svg)"            => 201326592,
  "lightgoldenrodyellow (svg)" => 4098,
  "lightgray (svg)"            => 17,
  "lightgrey (svg)"            => 17,
  "lightyellow (svg)"          => 3072,
  "lilas"                      => 221446162,
  "lime"                       => 1677747200,
  "lime green"                 => 637554177,
  "limepulp"                   => 184559367,
  "lindsay eyes"               => 570818600,
  "linen (svg)"                => 264194,
  "liz eyes"                   => 957677623,
  "lozenge blue"               => 218431488,
  "lunar white"                => 67108864,
  "magenta"                    => 6553600,
  "magenta fuchsia"            => 6565646,
  "magenta2 (hex3)"            => 6553607,
  "mahogany"                   => 3362607,
  "mailbox"                    => 1193803811,
  "majorelle blue"             => 943718414,
  "malachite green"            => 1358966565,
  "manatee gray"               => 395039,
  "mandarianorange"            => 3100171,
  "mandarine"                  => 2377728,
  "march"                      => 803079,
  "march rouge"                => 5660419,
  "maroon3"                    => 5250580,
  "maroon4"                    => 5250349,
  "maroon5"                    => 4612923,
  "marsorange"                 => 3561257,
  "masters jacket"             => 1073745227,
  "maya blue"                  => 907476994,
  "medium aquamarine2"         => 1258297620,
  "medium aquamarine3"         => 1275074836,
  "medium blue"                => 1263206420,
  "medium goldenrod"           => 6664,
  "medium gray"                => 60,
  "medium purple1"             => 556859392,
  "medium purple3"             => 556859412,
  "medium seagreen"            => 687876408,
  "medium slateblue2"          => 845414400,
  "medium wood"                => 1517603,
  "mediumblue (svg)"           => 1684275220,
  "mediumorchid (svg)"         => 205258769,
  "mediumseagreen (svg)"       => 1107305758,
  "mediumvioletred (svg)"      => 5841174,
  "melon"                      => 2120205,
  "midnight blue"              => 1449066554,
  "midnightblue"               => 690552901,
  "military green"             => 218112572,
  "mineral blue"               => 1025114176,
  "mint blue"                  => 234881536,
  "mint ice cream"             => 218107915,
  "mintcream (svg)"            => 67109376,
  "mistyrose3"                 => 723988,
  "moorish grey"               => 664635,
  "mordore"                    => 2249007,
  "moss"                       => 587213606,
  "mountbatten pink"           => 18350120,
  "murky"                      => 587205671,
  "nacarat"                    => 4144897,
  "naples yellow"              => 399872,
  "naplesyellowdeep"           => 2252032,
  "natural turquoise"          => 1090520600,
  "navajowhite2"               => 860167,
  "navy"                       => 1614217286,
  "navy (16 svg)"              => 1684275250,
  "navy blue"                  => 1680998465,
  "neonavocado (safe hex3)"    => 1677736960,
  "neonblue"                   => 1178992640,
  "neonpink"                   => 3741184,
  "newtan"                     => 991496,
  "noiraud"                    => 2377298,
  "nymph thigh"                => 591360,
  "od green"                   => 251665220,
  "office"                     => 1259066,
  "offwhitegreen (safe hex3)"  => 335549440,
  "oil blue"                   => 1074462788,
  "old money"                  => 922756408,
  "oldlace (svg)"              => 198913,
  "olive"                      => 352340781,
  "olive (16 svg)"             => 25650,
  "olive3b"                    => 620770879,
  "olivedrab (svg)"            => 419449644,
  "or"                         => 1203712,
  "orange"                     => 2253826,
  "orange (svg)"               => 2319360,
  "Orange 021U"                => 2771717,
  "orange4"                    => 2319405,
  "orangered"                  => 5661696,
  "orangered2"                 => 4809735,
  "orchid"                     => 3211791,
  "orchid (svg)"               => 3211791,
  "orchid4"                    => 3211565,
  "orpiment"                   => 1136897,
  "oxidized tin"               => 27,
  "pabst blue"                 => 1211891756,
  "pacific blue"               => 856883258,
  "packer gold"                => 1858561,
  "palegoldenrod (svg)"        => 204039,
  "palegreen3"                 => 671098900,
  "paleturquoise1 (hex3)"      => 452984832,
  "paleturquoise4"             => 452984877,
  "palevioletred2"             => 3219719,
  "palevioletred4"             => 3219757,
  "papaya"                     => 13056,
  "park ranger"                => 100665670,
  "parma"                      => 186581001,
  "parrot"                     => 1278017550,
  "parrotgreen (safe hex3)"    => 1342197760,
  "pass velvet"                => 4733739,
  "pastel"                     => 739835944,
  "pastel blue"                => 369229828,
  "payne grey"                 => 252117045,
  "peach"                      => 396800,
  "peachpuff (svg)"            => 989952,
  "peacock"                    => 1611726892,
  "pear"                       => 134237707,
  "pearl grey"                 => 67109456,
  "peppermint"                 => 1476409884,
  "permanent redviolet"        => 5456910,
  "persian blue"               => 1013186560,
  "peru (svg)"                 => 2311444,
  "pervenche"                  => 336855040,
  "picasso blue"               => 1664417793,
  "pickle"                     => 149556,
  "pinchard"                   => 20,
  "pine green"                 => 1660946485,
  "pinegreen (safe hex3)"      => 1677747280,
  "pink"                       => 1642752,
  "pink candy"                 => 1705742,
  "pink glass"                 => 655889,
  "pink2"                      => 1906439,
  "pistachio green"            => 369112324,
  "pistachio shell"            => 793352,
  "plum pudding"               => 4532271,
  "plum2"                      => 1769479,
  "police strobe"              => 1612513280,
  "pool table"                 => 1241528859,
  "popcornyellow (hex3)"       => 8448,
  "powderblue (svg)"           => 386072586,
  "presidential blue"          => 724631619,
  "Process Black U"            => 330835,
  "Process Blue U"             => 1679884312,
  "Process Cyan U"             => 1679163408,
  "Process Magenta U"          => 6566160,
  "Process Yellow U"           => 416516,
  "prune"                      => 5514289,
  "prussian blue"              => 1025114176,
  "pumpkin"                    => 2969613,
  "pure tin"                   => 7,
  "purple"                     => 5978918,
  "purple ink"                 => 2032423,
  "purple rose"                => 373227573,
  "Purple U"                   => 3736857,
  "purple3"                    => 659619860,
  "putty"                      => 70430,
  "ralphyellow (safe hex3)"    => 25620,
  "raspberry"                  => 5128214,
  "red"                        => 6579200,
  "red 032U"                   => 4407300,
  "red adrianople"             => 5923618,
  "red aniline"                => 6579208,
  "red bismarck"               => 5070371,
  "red blood"                  => 6250288,
  "red burgundy"               => 5789754,
  "red cinnabar"               => 4740353,
  "red crayfish"               => 5464858,
  "red culvert"                => 6317078,
  "red currant"                => 6247955,
  "red fire"                   => 4678656,
  "red gong"                   => 5329202,
  "red madder"                 => 6118663,
  "red nasturtium"             => 4146688,
  "red ochre"                  => 2046477,
  "red poppy"                  => 6317078,
  "red roof"                   => 3489046,
  "red tomato"                 => 5397005,
  "red tomette"                => 3753504,
  "red vermilion"              => 4740353,
  "red-violet"                 => 5841174,
  "red3"                       => 6579220,
  "reef"                       => 4809737,
  "Rhodamine red U"            => 4399115,
  "robin's egg"                => 302252039,
  "romaine lettuce"            => 486554179,
  "rose"                       => 3745281,
  "rosemadder"                 => 4999947,
  "rosybrown2"                 => 1579015,
  "rosybrown4"                 => 1579053,
  "roux"                       => 3563296,
  "royal blue"                 => 1327955977,
  "royalblue2"                 => 1211498503,
  "rubine red U"               => 4401678,
  "ruby red"                   => 6044172,
  "rust"                       => 2839848,
  "safety cone"                => 4411392,
  "safran"                     => 809733,
  "sage green"                 => 570432550,
  "salmon"                     => 2834947,
  "salmon1"                    => 2964224,
  "salmon4"                    => 2964269,
  "sand"                       => 530700,
  "sandybrown (svg)"           => 2178308,
  "sap green"                  => 1207982133,
  "sapphire blue"              => 1665728541,
  "scarlet"                    => 6579207,
  "scotland pound"             => 603986744,
  "seagreen (svg)"             => 1124082989,
  "seagreen3"                  => 1124083220,
  "seashell (svg)"             => 263936,
  "seashell2"                  => 263943,
  "seashell3"                  => 263956,
  "seashell4"                  => 263725,
  "semisweet chocolate1"       => 2506810,
  "senois"                     => 3623469,
  "sepia"                      => 1387296,
  "sgibrightgray"              => 134679,
  "sgilight gray (hex3)"       => 33,
  "sgiolivedrab"               => 15660,
  "sheet-dead"                 => 3098664,
  "sienna"                     => 2703148,
  "sienna2"                    => 3229703,
  "sienna4"                    => 3229997,
  "sign orange"                => 3105805,
  "silver"                     => 19,
  "silver (16 svg)"            => 25,
  "sinople"                    => 1442862634,
  "skyblue1"                   => 789774336,
  "skyblue4"                   => 789774381,
  "slate"                      => 269221946,
  "slate blue"                 => 437583917,
  "slateblue"                  => 1680998400,
  "slateblue3"                 => 825819156,
  "slategray3"                 => 369819668,
  "slategrey (svg)"            => 369819692,
  "smalt blue"                 => 1682112552,
  "snow (svg)"                 => 131584,
  "snow white"                 => 0,
  "snow2"                      => 131591,
  "snow3"                      => 131604,
  "snow4"                      => 65837,
  "spring green"               => 1677734400,
  "springgreen (safe hex3)"    => 1677742080,
  "springgreen (svg)"          => 1677734400,
  "springgreen4"               => 1677734445,
  "stained glass"              => 1380843520,
  "stainless steel"            => 524,
  "steel blue"                 => 1159200795,
  "steel grey"                 => 31,
  "steelblue3"                 => 1025245204,
  "strawberry"                 => 4934425,
  "strawberry crushed"         => 5131812,
  "sulfur"                     => 14848,
  "sulfur flower"              => 14848,
  "summersky"                  => 1259667469,
  "suntan"                     => 1455405,
  "sweet potato vine"          => 318785301,
  "tan (svg)"                  => 925970,
  "tangerine"                  => 4806912,
  "tank"                       => 205630,
  "tanne"                      => 3236643,
  "taupe"                      => 662857,
  "tea rose"                   => 3095040,
  "teal"                       => 1677721644,
  "teal (16 svg)"              => 1677721650,
  "terracotta"                 => 4077332,
  "terreverte"                 => 671110207,
  "thistle1"                   => 786432,
  "thistle3"                   => 786452,
  "tiffany blue"               => 1241851392,
  "titanium"                   => 263965,
  "tobacco"                    => 3100966,
  "tomato (svg)"               => 4016128,
  "tomato4"                    => 4016429,
  "topaz"                      => 407042,
  "tourdille"                  => 67608,
  "turkish red"                => 5923618,
  "turquin blue"               => 874643502,
  "turquoise"                  => 1426065409,
  "turquoise2"                 => 1677983751,
  "turquoiseblue"              => 1677729302,
  "ultramarine"                => 1214513192,
  "umber"                      => 1657131,
  "vandykebrown"               => 3956543,
  "vanilla"                    => 532492,
  "venetian"                   => 1785865,
  "venetianred"                => 5788945,
  "verdigris"                  => 167774755,
  "vermeil"                    => 6313741,
  "veronese green"             => 352336696,
  "vert absinthe"              => 721437197,
  "verylight grey"             => 20,
  "violet"                     => 2687045,
  "violet flower"              => 423559168,
  "Violet U"                   => 573767710,
  "violetred"                  => 4921620,
  "violetred3"                 => 4991252,
  "violine"                    => 6296101,
  "viride green"               => 855642161,
  "walnut brou"                => 3038795,
  "warm gray 10U"              => 329777,
  "warm gray 11U"              => 329779,
  "warm gray 1U"               => 198158,
  "warm gray 2U"               => 263955,
  "warm gray 3U"               => 264217,
  "warm gray 4U"               => 264221,
  "warm gray 5U"               => 329762,
  "warm gray 6U"               => 263972,
  "warm gray 7U"               => 329513,
  "warm gray 8U"               => 329772,
  "warm gray 9U"               => 329519,
  "warm red U"                 => 4870916,
  "warmgrey"                   => 4658,
  "wasabi (safe hex3)"         => 1006648320,
  "water mint"                 => 1107307266,
  "watermelon"                 => 2696448,
  "wavecrest"                  => 419430932,
  "wheat"                      => 544521,
  "wheat1"                     => 596736,
  "wheat3"                     => 596756,
  "wheelwright blue"           => 470941718,
  "white"                      => 0,
  "white (safe 16 svg hex3)"   => 0,
  "white cream"                => 334593,
  "white ivory"                => 4452,
  "white lead white"           => 0,
  "white milk"                 => 257,
  "white of spain"             => 1536,
  "white opal"                 => 83886080,
  "white platinum"             => 267522,
  "white saturn"               => 0,
  "white silver"               => 0,
  "white troyes"               => 1536,
  "white-blue"                 => 0,
  "whitesmoke (svg)"           => 4,
  "wine lie"                   => 5454881,
  "yellow"                     => 25600,
  "yellow (safe 16 svg hex3)"  => 25600,
  "yellow aureolin"            => 804870,
  "yellow banana"              => 876818,
  "yellow candy"               => 76039,
  "yellow chartreuse"          => 218129408,
  "yellow chick"               => 540163,
  "yellow mimosa"              => 145664,
  "yellow mustard"             => 67134483,
  "yellow nankin"              => 604419,
  "yellow ocher"               => 1462797,
  "yellow olive"               => 25650,
  "yellow perch"               => 274700,
  "yellow straw"               => 739328,
  "yellow2 (hex3)"             => 25607,
  "yellow3"                    => 25620,
  "yellow4"                    => 25645,
  "yellowgreen (svg)"          => 419449876,
  "yellowochre"                => 2841099,
  "yinmn blue"                 => 1143734316,
  "zinc white"                 => 50331648,
  "zizolin"                    => 157417525,
};

1;
# ABSTRACT: CMYK colors from all Graphics::ColorNamesCMYK::*

__END__

=pod

=encoding UTF-8

=head1 NAME

Graphics::ColorNamesCMYK::All - CMYK colors from all Graphics::ColorNamesCMYK::*

=head1 VERSION

This document describes version 0.001 of Graphics::ColorNamesCMYK::All (from Perl distribution Graphics-ColorNamesCMYK-All), released on 2024-05-16.

=head1 DESCRIPTION

=head1 HOMEPAGE

Please visit the project's homepage at L<https://metacpan.org/release/Graphics-ColorNamesCMYK-All>.

=head1 SOURCE

Source repository is at L<https://github.com/perlancar/perl-Graphics-ColorNamesCMYK-All>.

=head1 SEE ALSO

Other C<Graphics::ColorNamesCMYK::*> modules.

=head1 AUTHOR

perlancar <perlancar@cpan.org>

=head1 CONTRIBUTING


To contribute, you can send patches by email/via RT, or send pull requests on
GitHub.

Most of the time, you don't need to build the distribution yourself. You can
simply modify the code, then test via:

 % prove -l

If you want to build the distribution (e.g. to try to install it locally on your
system), you can install L<Dist::Zilla>,
L<Dist::Zilla::PluginBundle::Author::PERLANCAR>,
L<Pod::Weaver::PluginBundle::Author::PERLANCAR>, and sometimes one or two other
Dist::Zilla- and/or Pod::Weaver plugins. Any additional steps required beyond
that are considered a bug and can be reported to me.

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2024 by perlancar <perlancar@cpan.org>.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=head1 BUGS

Please report any bugs or feature requests on the bugtracker website L<https://rt.cpan.org/Public/Dist/Display.html?Name=Graphics-ColorNamesCMYK-All>

When submitting a bug or request, please include a test-file or a
patch to an existing test-file that illustrates the bug or desired
feature.

=cut
