use strict;
use ExtUtils::MakeMaker 6.17;

my $EUMM = eval( $ExtUtils::MakeMaker::VERSION );

my $meta = {
  "abstract"         => "Formulate Test::FITesque fixture tables in RDF",
  "author"           => ["Kjetil Kjernsmo (KJETILK) <kjetilk\@cpan.org>"],
  "dynamic_config"   => 0,
  "generated_by"     => "Dist::Inkt::Profile::KJETILK version 0.101, CPAN::Meta::Converter version 2.150010",
  "keywords"         => [],
  "license"          => ["mit"],
  "meta-spec"        => {
                          url => "http://search.cpan.org/perldoc?CPAN::Meta::Spec",
                          version => 2,
                        },
  "name"             => "Test-FITesque-RDF",
  "no_index"         => { directory => ["eg", "examples", "inc", "t", "xt"] },
  "prereqs"          => {
                          configure => { requires => { "ExtUtils::MakeMaker" => 6.17 } },
                          develop   => { recommends => { "Dist::Inkt" => 0.001 } },
                          runtime   => {
                                         requires => {
                                           "Attean"            => 0.025,
                                           "HTTP::Message"     => 0,
                                           "LWP::UserAgent"    => 0,
                                           "Moo"               => "1.006000",
                                           "Path::Tiny"        => 0,
                                           "perl"              => 5.014,
                                           "RDF::NS::Curated"  => 1.002,
                                           "RDF::Prefixes"     => 0,
                                           "Test::FITesque"    => 0,
                                           "Try::Tiny"         => 0,
                                           "Types::Path::Tiny" => 0,
                                           "Types::Standard"   => 0,
                                           "Types::URI"        => 0.007,
                                           "URI::NamespaceMap" => 1.08,
                                         },
                                       },
                          test      => {
                                         requires => {
                                           "FindBin"                 => 0,
                                           "Test::Deep"              => 0,
                                           "Test::HTTP::LocalServer" => 0,
                                           "Test::Modern"            => 0,
                                           "Test::More"              => 0.96,
                                         },
                                       },
                        },
  "provides"         => {
                          "Test::FITesque::RDF" => { file => "lib/Test/FITesque/RDF.pm", version => "0.10" },
                        },
  "release_status"   => "stable",
  "resources"        => {
                          bugtracker   => { web => "https://github.com/kjetilk/p5-test-fitesque-rdf/issues" },
                          homepage     => "https://metacpan.org/release/Test-FITesque-RDF",
                          license      => ["http://www.opensource.org/licenses/mit-license.php"],
                          repository   => {
                                            type => "git",
                                            url  => "git://github.com/kjetilk/p5-test-fitesque-rdf.git",
                                            web  => "https://github.com/kjetilk/p5-test-fitesque-rdf",
                                          },
                          x_identifier => "http://purl.org/NET/cpan-uri/dist/Test-FITesque-RDF/project",
                          x_IRC        => "irc://irc.perl.org/#perlrdf",
                        },
  "version"          => "0.10",
  "x_static_install" => 1,
};

my %dynamic_config;

my %WriteMakefileArgs = (
	ABSTRACT   => $meta->{abstract},
	AUTHOR     => ($EUMM >= 6.5702 ? $meta->{author} : $meta->{author}[0]),
	DISTNAME   => $meta->{name},
	VERSION    => $meta->{version},
	EXE_FILES  => [ map $_->{file}, values %{ $meta->{x_provides_scripts} || {} } ],
	NAME       => do { my $n = $meta->{name}; $n =~ s/-/::/g; $n },
	test       => { TESTS => "t/*.t" },
	%dynamic_config,
);

$WriteMakefileArgs{LICENSE} = $meta->{license}[0] if $EUMM >= 6.3001;

sub deps
{
	my %r;
	for my $stage (@_)
	{
		for my $dep (keys %{$meta->{prereqs}{$stage}{requires}})
		{
			next if $dep eq 'perl';
			my $ver = $meta->{prereqs}{$stage}{requires}{$dep};
			$r{$dep} = $ver if !exists($r{$dep}) || $ver >= $r{$dep};
		}
	}
	\%r;
}

my ($build_requires, $configure_requires, $runtime_requires, $test_requires);
if ($EUMM >= 6.6303)
{
	$WriteMakefileArgs{BUILD_REQUIRES}     ||= deps('build');
	$WriteMakefileArgs{CONFIGURE_REQUIRES} ||= deps('configure');
	$WriteMakefileArgs{TEST_REQUIRES}      ||= deps('test');
	$WriteMakefileArgs{PREREQ_PM}          ||= deps('runtime');
}
elsif ($EUMM >= 6.5503)
{
	$WriteMakefileArgs{BUILD_REQUIRES}     ||= deps('build', 'test');
	$WriteMakefileArgs{CONFIGURE_REQUIRES} ||= deps('configure');
	$WriteMakefileArgs{PREREQ_PM}          ||= deps('runtime');	
}
elsif ($EUMM >= 6.52)
{
	$WriteMakefileArgs{CONFIGURE_REQUIRES} ||= deps('configure');
	$WriteMakefileArgs{PREREQ_PM}          ||= deps('runtime', 'build', 'test');	
}
else
{
	$WriteMakefileArgs{PREREQ_PM}          ||= deps('configure', 'build', 'test', 'runtime');	
}

{
	my ($minperl) = reverse sort(
		grep defined && /^[0-9]+(\.[0-9]+)?$/,
		map $meta->{prereqs}{$_}{requires}{perl},
		qw( configure build runtime )
	);
	
	if (defined($minperl))
	{
		die "Installing $meta->{name} requires Perl >= $minperl"
			unless $] >= $minperl;
		
		$WriteMakefileArgs{MIN_PERL_VERSION} ||= $minperl
			if $EUMM >= 6.48;
	}
}


my $mm = WriteMakefile(%WriteMakefileArgs);

exit(0);

