#!/usr/bin/perl
use strict;
use warnings;

use Dancer ':syntax';
use Dancer::Test;
use Log::Any::Test;
use Log::Any qw{$log};
use Test::More import => ['!pass'];

setting log => 'core';
setting logger => 'LogAny';

for my $level (qw{core debug info warning error}) {
    my $route = "/$level";
    my $message = "$level-whatever";
    my $sub = "Dancer::Logger::$level";
    get $route => sub {
        no strict 'refs';
        &$sub ($message);
        return $message;
    };
    route_exists [GET => $route];
    response_content_is ([GET => $route], $message);
    # There's a lot of messages generated by core we don't want to worry with
    my $messages = $log->msgs;
    is_deeply (pop @{$messages}, {category => 'Dancer::Logger::LogAny', level => ($level eq 'core' ? 'info' : $level), message => $message}, "Compare message recieved to expected");
    $log->clear;
}

done_testing;
