package CPAN::Testers::Reports::Counts::TestWrapper;
use strict;
use warnings;

#
# This module puts a wrapper around http_get() in Net::HTTP::Tiny.
# We basically put an eval { } around http_get, and if the request
# fails, then we see if the URL asked for is one we have some
# fallback data for, and if so, then we return that.
#
# This means that if the user doesn't have an internet connection,
# or if the CPAN Testers website is down, then we're mocking the HTTP
# request, so the tests can still run.
#
# But if the file on CPAN Testers changes format, then I'll start to
# see failed requests. I should probably catch 404's and still die
# with those.
#

require Net::HTTP::Tiny;

my %mock_data;

my $real_http_get = \&Net::HTTP::Tiny::http_get;

{
    no strict 'refs';
    no warnings 'redefine';

    *{'Net::HTTP::Tiny::http_get'} = sub ($) {
        my $url = shift;
        my $content;
        eval { $content = &$real_http_get($url); };
        if ($@) {
            if (exists($mock_data{$url})) {
                return $mock_data{$url};
            } else {
                die $@;
            }
        } else {
            return $content;
        }
    };
}

$mock_data{'http://stats.cpantesters.org/stats/stats1.txt'} = <<'END_STATS1';
#DATE,UPLOADS,REPORTS,PASS,FAIL
199908,250,77,64,2
199909,298,712,562,35
199910,215,448,378,19
199911,242,504,417,37
199912,196,717,557,68
200001,235,828,603,47
200002,281,755,625,42
200003,294,694,582,39
200004,297,544,462,32
200005,313,682,580,35
200006,271,592,510,28
200007,278,631,522,33
200008,307,779,665,43
200009,323,687,594,40
200010,284,393,326,22
200011,293,493,421,16
200012,275,332,296,9
200101,355,911,769,45
200102,388,989,799,86
200103,458,821,702,39
200104,401,1067,862,100
200105,443,1035,895,67
200106,531,548,447,48
200107,465,247,207,30
200108,490,208,177,15
200109,424,566,485,32
200110,550,348,286,28
200111,622,1030,890,76
200112,477,570,519,33
200201,597,925,763,101
200202,507,764,672,62
200203,601,864,775,61
200204,629,1185,1059,78
200205,593,2425,2016,278
200206,588,3304,2911,257
200207,656,2952,2418,271
200208,733,8335,6522,1007
200209,728,2693,2193,307
200210,594,3438,2745,443
200211,654,4851,3905,639
200212,592,1494,1216,207
200301,766,2540,2177,297
200302,686,3771,3377,333
200303,874,2993,2621,275
200304,812,1751,1491,197
200305,814,1994,1738,207
200306,906,1615,1306,217
200307,909,1379,1166,157
200308,907,2183,1837,257
200309,953,2985,2664,200
200310,836,4709,4092,405
200311,775,2639,2308,246
200312,840,2340,1922,293
200401,1050,2989,2637,280
200402,932,3163,2614,373
200403,1096,4439,3826,463
200404,951,4333,3734,492
200405,996,5192,4639,394
200406,853,3347,2982,285
200407,875,4395,3815,436
200408,783,2842,2496,250
200409,925,4472,3976,357
200410,968,2256,2056,150
200411,897,5357,4747,525
200412,936,4913,4391,443
200501,1092,3726,3407,279
200502,887,4494,3847,566
200503,1117,7566,6633,803
200504,996,5844,5311,457
200505,954,7658,6355,1161
200506,901,8455,6844,1365
200507,1061,7246,6085,989
200508,1104,8503,7472,834
200509,1108,14745,12461,2205
200510,1032,8777,7630,1076
200511,1086,6525,5804,648
200512,1034,6522,5877,622
200601,1161,6270,5605,650
200602,1015,5961,5416,536
200603,1147,8872,8098,714
200604,929,6095,5569,515
200605,1058,7187,6805,373
200606,1026,5199,4785,383
200607,1126,12364,10237,2057
200608,1083,4991,4597,383
200609,1128,6335,5767,543
200610,1060,12415,10985,1342
200611,1099,12731,11244,1411
200612,893,11583,9966,1500
200701,977,14408,12401,1944
200702,1004,15001,13023,1811
200703,1307,24635,21403,3043
200704,1092,19191,16768,2110
200705,1274,27431,23814,2952
200706,1036,22121,19266,2320
200707,1178,27372,23852,2995
200708,1115,46265,38748,6344
200709,1319,62309,52269,8086
200710,1397,63960,54227,7641
200711,1547,92427,80464,9240
200712,1248,85106,72399,9801
200801,1562,97315,82116,11610
200802,1528,79522,67322,8791
200803,1569,150894,129014,16507
200804,1638,146029,125343,14576
200805,1464,175275,147456,19813
200806,1590,264352,205337,42521
200807,1489,133893,114022,16088
200808,1531,149971,127184,15788
200809,1438,227411,194195,21075
200810,1566,181287,160159,13444
200811,1635,190355,164744,16092
200812,1474,239989,205896,17250
200901,1669,207391,174045,18786
200902,1555,187118,159956,17920
200903,1648,235484,186759,23615
200904,1900,190898,156788,15859
200905,1779,225458,190808,18430
200906,1624,358107,296178,31708
200907,1819,466345,381506,37831
200908,1723,339884,280668,33746
200909,1618,265375,217123,27552
200910,1894,369250,303063,35920
200911,2060,452585,371932,42318
200912,1734,323068,273221,27417
201001,1860,149788,130954,12156
201002,1715,118244,101059,9948
201003,2154,168969,140661,15740
201004,1788,249808,217693,20123
201005,1798,262204,219965,25616
201006,1786,271643,229998,24480
201007,1676,254198,211891,23641
201008,1819,304605,263200,25174
201009,1945,411600,357460,33715
201010,1827,534604,461313,44313
201011,1916,484195,404615,47059
201012,1849,430007,377817,31933
201101,2012,348981,304322,28806
201102,2008,409904,351975,31752
201103,1917,387248,338211,27300
201104,1835,510217,439615,36699
201105,1898,670243,591342,46353
201106,1858,744831,645485,56229
201107,1751,968262,832084,75340
201108,1810,1079556,939244,77766
201109,1404,889377,757088,77851
201110,1920,826098,706949,69947
201111,1704,975564,835460,82662
201112,1699,984260,837907,85420
201201,1679,821659,719987,62710
201202,1870,773673,669171,65880
201203,1976,634317,550062,53980
201204,1785,505876,440474,44758
201205,1885,557026,500344,38886
201206,1966,403004,352135,36569
201207,1899,405760,355661,34352
201208,1852,218215,192059,16776
201209,1682,767877,686126,53760
201210,2028,870858,791970,53499
201211,2041,1033056,918453,71859
201212,1865,1204353,1078735,76002
201301,2015,1024099,913665,72496
201302,2025,871588,777321,58500
201303,2183,815702,719109,51879
201304,2152,504808,455094,34733
201305,2418,902555,803318,66486
201306,2180,867318,790607,54404
201307,2053,863487,800711,43426
201308,2176,873865,792526,54569
201309,2408,871371,797625,51224
201310,2119,1042912,961351,53788
201311,2113,1118730,1024056,66333
201312,1807,1042616,944931,63406
201401,2211,1120646,1029800,61017
END_STATS1

$mock_data{'http://stats.cpantesters.org/stats/stats3.txt'} = <<'END_STATS3';
#DATE,FAIL,NA,UNKNOWN
199908,2,0,11
199909,35,0,115
199910,19,0,51
199911,37,0,50
199912,68,15,77
200001,47,13,165
200002,42,10,78
200003,39,1,72
200004,32,0,50
200005,35,0,67
200006,28,0,54
200007,33,0,76
200008,43,0,71
200009,40,0,53
200010,22,0,45
200011,16,0,56
200012,9,0,27
200101,45,3,94
200102,86,7,97
200103,39,2,78
200104,100,3,102
200105,67,7,66
200106,48,4,49
200107,30,1,9
200108,15,10,6
200109,32,14,35
200110,28,9,25
200111,76,16,48
200112,33,0,18
200201,101,1,60
200202,62,2,28
200203,61,3,25
200204,78,0,48
200205,278,18,113
200206,257,32,104
200207,271,50,213
200208,1007,124,682
200209,307,59,134
200210,443,15,235
200211,639,189,118
200212,207,29,42
200301,297,29,37
200302,333,22,39
200303,275,36,61
200304,197,16,47
200305,207,8,41
200306,217,15,77
200307,157,8,48
200308,257,23,66
200309,200,31,90
200310,405,42,170
200311,246,55,30
200312,293,33,92
200401,280,29,43
200402,373,104,72
200403,463,55,95
200404,492,36,71
200405,394,75,84
200406,285,32,48
200407,436,45,99
200408,250,28,68
200409,357,63,76
200410,150,27,23
200411,525,38,47
200412,443,24,55
200501,279,8,32
200502,566,9,72
200503,803,60,70
200504,457,19,57
200505,1161,48,94
200506,1365,26,220
200507,989,52,120
200508,834,40,157
200509,2205,30,49
200510,1076,22,49
200511,648,17,56
200512,622,17,6
200601,650,10,5
200602,536,9,0
200603,714,29,31
200604,515,9,2
200605,373,7,2
200606,383,28,3
200607,2057,48,22
200608,383,9,2
200609,543,6,19
200610,1342,61,27
200611,1411,52,24
200612,1500,92,25
200701,1944,53,10
200702,1811,123,44
200703,3043,103,86
200704,2110,203,110
200705,2952,479,186
200706,2320,372,163
200707,2995,345,180
200708,6344,397,776
200709,8086,732,1222
200710,7641,1258,834
200711,9240,1799,924
200712,9801,1830,1076
200801,11610,2188,1401
200802,8791,2379,1030
200803,16507,3046,2327
200804,14576,3431,2679
200805,19813,5280,2726
200806,42521,8060,8434
200807,16088,1888,1895
200808,15788,4012,2987
200809,21075,2097,10044
200810,13444,3181,4503
200811,16092,2889,6630
200812,17250,6144,10699
200901,18786,6000,8560
200902,17920,4135,5107
200903,23615,9685,15425
200904,15859,10462,7789
200905,18430,6335,9885
200906,31708,10859,19362
200907,37831,9264,37744
200908,33746,8031,17439
200909,27552,7486,13214
200910,35920,11009,19258
200911,42318,9199,29136
200912,27417,6092,16338
201001,12156,2792,3886
201002,9948,1582,5655
201003,15740,1867,10701
201004,20123,3170,8822
201005,25616,3177,13446
201006,24480,2682,14483
201007,23641,2824,15842
201008,25174,4830,11401
201009,33715,3852,16573
201010,44313,5704,23274
201011,47059,5814,26707
201012,31933,5191,15066
201101,28806,4536,11317
201102,31752,5916,20261
201103,27300,6318,15419
201104,36699,6649,27254
201105,46353,7430,25118
201106,56229,7342,35775
201107,75340,8774,52064
201108,77766,11796,50750
201109,77851,9131,45307
201110,69947,9271,39931
201111,82662,10769,46673
201112,85420,11953,48980
201201,62710,10364,28598
201202,65880,9248,29374
201203,53980,8383,21892
201204,44758,4152,16492
201205,38886,4339,13457
201206,36569,3561,10739
201207,34352,4555,11192
201208,16776,2761,6619
201209,53760,6011,21980
201210,53499,6754,18635
201211,71859,9225,33519
201212,76002,9750,39866
201301,72496,9178,28760
201302,58500,7536,28231
201303,51879,7777,36937
201304,34733,4428,10553
201305,66486,10536,22215
201306,54404,7151,15156
201307,43426,6915,12435
201308,54569,8884,17886
201309,51224,11454,11068
201310,53788,11417,16356
201311,66333,9633,18708
201312,63406,11815,22464
201401,61017,12620,17209
END_STATS3

1;
