# This file was _NOT_ automatically generated by Dist::Zilla::Plugin::Alien v0.023.
use strict;
use warnings;
our $VERSION = 0.020_000;
use 5.008;

use lib qw{inc};
use My::ModuleBuild;
use Config;
use English qw(-no_match_vars);  # for $OSNAME

# choose correct compiler for each OS and/or Perl configuration
my $cxx = 'g++';
if ($OSNAME eq 'freebsd') {
    $cxx = 'c++';
}
if ($Config{cc} =~ /clang/) {
    $cxx = 'clang++';
}

# primary build options
my $builder = My::ModuleBuild->new(
    module_name        => 'Alien::astyle',
    dist_abstract      => 'Build & Install the Artistic Style Code Formatter',
    dist_author        => 'William N. Braswell, Jr. <wbraswell@cpan.org>',
    dist_version       => '0.010000',
    license            => 'perl',
    alien_bin_requires => {
        'Alien::Build' => '1.39',
        'Alien::gmake' => '0.21',
    },
    alien_msys => 1,
    configure_requires => {
        # DEV NOTE, CORRELATION #aa001: must install IO::Socket::SSL & Alien::Base::ModuleBuild from Build.PL (which becomes META.json, for CPAN) & .travis.yml & appveyor.yml 
        'IO::Socket::SSL'          => '2.043',
        'Alien::Base::ModuleBuild' => '1.02',
        'Capture::Tiny'            => '0',
        'IPC::Cmd'                 => '0.96',
        'File::ShareDir'           => '1.03',
        'File::chdir'              => '0',
        'perl'                     => '5.008'
    },
    test_requires        => {
        'Test::More' => '0.94',
        'perl'       => '5.008'
    },
    requires => {
        'perl'           => '5.8.0',
        'parent'         => '0',
        'Alien::Base'    => '0',
        'File::ShareDir' => '1.03',
    },
    alien_build_commands => [
        "%{gmake} --directory=build/gcc CXX=$cxx"
    ],
    alien_install_commands => [
        "%{gmake} --directory=build/gcc CXX=$cxx INSTALL=install prefix=%s install"
    ],
    alien_name       => 'astyle',
    alien_repository => 
    {   protocol => 'https',
        host     => 'wbraswell.github.io',
        location => '/astyle-mirror/',
        pattern  => qr/astyle_([\d\.]+)_linux\.tar\.gz$/,
    },
    alien_stage_install => 1,
    meta_merge => {
        resources => {
            repository => 'https://github.com/wbraswell/alien-astyle',
            bugtracker => 'https://github.com/wbraswell/alien-astyle/issues',
        },
    },
    recursive_test_files => 1,
);
$builder->create_build_script;
