/*                                                                
**  Copyright (C) 1996,2007  Smithsonian Astrophysical Observatory 
*/                                                                

/*                                                                          */
/*  This program is free software; you can redistribute it and/or modify    */
/*  it under the terms of the GNU General Public License as published by    */
/*  the Free Software Foundation; either version 3 of the License, or       */
/*  (at your option) any later version.                                     */
/*                                                                          */
/*  This program is distributed in the hope that it will be useful,         */
/*  but WITHOUT ANY WARRANTY; without even the implied warranty of          */
/*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the           */
/*  GNU General Public License for more details.                            */
/*                                                                          */
/*  You should have received a copy of the GNU General Public License along */
/*  with this program; if not, write to the Free Software Foundation, Inc., */
/*  51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.             */
/*                                                                          */

/* pquery.c
**/


#include <unistd.h>
#include <stdlib.h>
#include <string.h>

#include "pfile.h"
#include "putil.h"
#include "ptemplat.h"
#include "parameter.h"


int main(int argc, char *argv[])
{
		paramfile	  pfile;
		int		  pmode;
		char		value[SZ_PFLINE];

		char		*progname;
		char		*mode = "rw";
		char		*pdef;

	if ( (progname = strrchr(argv[0], '/')) )
		progname++;
	else	progname = argv[0];

	if ( argc <= 2 ) {
	   fprintf(stderr, "usage: pquery pfile param [param1=value ...]\n");
		exit(1);
	}

	if ( (pdef = getenv("PDEFAULTS")) ) {
		mode = pdef;
	}

	if ( (pfile = paramopen(argv[1], &argv[2], argc - 2, mode)) == NULL ) {
	  fprintf(stderr, "pquery: can't open parameter file : %s\n", argv[1]);
		exit(1);
	}
	
	memset( paramToolName, 0, PARAMTOOLNAMELEN);
	if ( strrchr( argv[1], '/' ) ) 
	  strncpy( paramToolName, strrchr(argv[1], '/'), PARAMTOOLNAMELEN-1 );
	else
	  strncpy( paramToolName, argv[1],  PARAMTOOLNAMELEN-1);
	

	if ( argv[2][0] == '-' ) {
			char	tok[SZ_PFLINE];
			int	first = 1;

		while ( 1 ) {
			if ( PSkipWhite(stdin)         == -1 ) break;
			if ( PReadTok(stdin, tok, SZ_PFLINE) == -1 ) break;

			if ( !first )
			    fprintf(stdout, "	");
			else
			    first = 0;

			if ( pgetstr(pfile, tok, value, SZ_PFLINE) )
				fprintf(stdout, "%s", value);
			else
				paramerr(1, "pquery", argv[2]);
		}
		fprintf(stdout, "\n");
	} else
		if ( pgetstr(pfile, argv[2], value, SZ_PFLINE) )
			fprintf(stdout, "%s\n", value);
		else
			paramerr(1, "pquery", argv[2]);

	paramclose(pfile);
        return 0;		
}


