BEGIN {
  use strict; use warnings;
  my %missing = map {
    eval qq{ require $_ };
    $@ ? ($_=>1) : ()
  } qw( experimental warnings );
  if(%missing)
  {
    print "Your Perl is missing core modules: @{[ sort keys %missing ]}\n";
    print "Ideally if you are using the system Perl you can install the appropriate\n";
    print "package which includes the core Perl modules.  On at least some versions\n";
    print "of Fedora, CentOS and RHEL, this is the `perl-core` package.\n";
    print "\n";
    print " % dnf install perl-core\n";
    print "   ~ or ~\n";
    print " % yum install perl-core\n";
    print "\n";
    print "If you really want to install dual-life modules from CPAN, then you can\n";
    print "use cpanm:\n";
    print "\n";
    print " % cpanm @{[ sort keys %missing ]}\n";
    print "\n";
    print "Note that some core modules are not available from CPAN.\n";
    exit;
  }
}
BEGIN {
  use strict; use warnings;
  unless(eval q{ use 5.020; 1}) {
    print "Perl 5.020 or better required\n";
    exit;
  }
}
# This file was automatically generated by Dist::Zilla::Plugin::Author::Plicease::MakeMaker v2.78.
use strict;
use warnings;
use 5.020;
use ExtUtils::MakeMaker;

my %WriteMakefileArgs = (
  "ABSTRACT"           => "Work with __DATA__ section files from the command line",
  "AUTHOR"             => "Graham Ollis <plicease\@cpan.org>",
  "CONFIGURE_REQUIRES" => {
    "ExtUtils::MakeMaker" => 0
  },
  "DISTNAME"  => "App-datasection",
  "EXE_FILES" => [
    "bin/datasection"
  ],
  "LICENSE"          => "perl",
  "MIN_PERL_VERSION" => "5.020",
  "NAME"             => "App::datasection",
  "PM"               => {
    "lib/App/datasection.pm"                 => "\$(INST_LIB)/App/datasection.pm",
    "lib/App/datasection/Command.pm"         => "\$(INST_LIB)/App/datasection/Command.pm",
    "lib/App/datasection/Command/diff.pm"    => "\$(INST_LIB)/App/datasection/Command/diff.pm",
    "lib/App/datasection/Command/extract.pm" => "\$(INST_LIB)/App/datasection/Command/extract.pm",
    "lib/App/datasection/Command/insert.pm"  => "\$(INST_LIB)/App/datasection/Command/insert.pm"
  },
  "PREREQ_PM" => {
    "App::Cmd::Setup"          => 0,
    "Data::Section::Pluggable" => "0.08",
    "Data::Section::Writer"    => "0.04",
    "Path::Tiny"               => "0.130",
    "Text::Diff"               => 0,
    "stable"                   => 0,
    "true"                     => 0
  },
  "TEST_REQUIRES" => {
    "App::Cmd::Tester" => 0,
    "Test2::V0"        => "0.000121"
  },
  "VERSION" => "0.01",
  "test"    => {
    "TESTS" => "t/*.t"
  }
);

my %FallbackPrereqs = (
  "App::Cmd::Setup"          => 0,
  "App::Cmd::Tester"         => 0,
  "Data::Section::Pluggable" => "0.08",
  "Data::Section::Writer"    => "0.04",
  "Path::Tiny"               => "0.130",
  "Test2::V0"                => "0.000121",
  "Text::Diff"               => 0,
  "stable"                   => 0,
  "true"                     => 0
);

unless ( eval { ExtUtils::MakeMaker->VERSION(6.63_03) } ) {
  delete $WriteMakefileArgs{TEST_REQUIRES};
  delete $WriteMakefileArgs{BUILD_REQUIRES};
  $WriteMakefileArgs{PREREQ_PM} = \%FallbackPrereqs;
}

delete $WriteMakefileArgs{CONFIGURE_REQUIRES}
  unless eval { ExtUtils::MakeMaker->VERSION(6.52) };

WriteMakefile(%WriteMakefileArgs);