use utf8;
use strict;
use warnings;
use open qw( :encoding(UTF-8) :std );
use Test::More tests => 22;
use Lingua::Stem::UniNE::BG qw( stem );

note 'no test for: ',                'remove -ища';
is stem('благодаря'),    'благодар', 'remove -я';
is stem('това'),         'тов',      'remove -а';
is stem('добре'),        'добр',     'remove -е';
is stem('какво'),        'какв',     'remove -о';
is stem('сигурен'),      'сигурн',   'remove -е- from -ен';
is stem('веднъж'),       'веднж',    'remove -ъ- from -ъ�';
is stem('единственият'), 'единствн', 'remove article: -ият';
is stem('история'),      'истор',    'remove article: -ия';
is stem('животът'),      'живот',    'remove article: -ът';
is stem('работата'),     'раб',      'remove article: -та';
is stem('когато'),       'ког',      'remove article: -то';
is stem('дяволите'),     'дявол',    'remove article: -те';
is stem('правят'),       'прав',     'remove article: -ят';
is stem('ключовете'),    'ключ',     'remove plural: -ове';
note 'no test for: ',                'remove plural: replace -еве with -й';
is stem('търговци'),     'търг',     'remove plural: remove -вци from -овци';
is stem('запази'),       'запаг',    'remove plural: replace -зи with -г';
is stem('приятели'),     'приятял',  'remove plural: replace -е�и with -я�';
is stem('седмици'),      'седмик',   'remove plural: replace -ци with -к';
is stem('момчетата'),    'момч',     'remove plural: -та';
is stem('сънищата'),     'сън',      'remove plural: -ища';
is stem('спаси'),        'спах',     'remove plural: replace -си with -х';
is stem('всички'),       'всичк',    'remove plural: -и';
