#!/usr/bin/perl

package eBay::API::XML::DataType::Enum::PolicyComplianceStatusCodeType;

use strict;
use warnings;  

##########################################################################
#
# Module: ............... <user defined location>eBay/API/XML
# File: ................. PolicyComplianceStatusCodeType.pm
# Generated by: ......... genEBayApiDataTypes.pl
# Last Generated: ....... 08/24/2008 16:44
# API Release Number: ... 579
#
##########################################################################  

=head1 NAME

eBay::API::XML::DataType::Enum::PolicyComplianceStatusCodeType

=head1 DESCRIPTION

The policy compliance status rates how well you are following eBay rules and policies 
in your selling.



=head1 SYNOPSIS

=cut



=head1 Enums:

=cut


=head2 Good

You're doing a good job of selling in line with eBay policies.
Be sure to continue to follow eBay rules in your selling. 
Although your risk of restrictions is low, a future policy violation could result 
in the removal of some of your listings.



=cut


use constant Good => scalar('Good');


=head2 Fair

You're at risk of having your listings canceled.
Check to see what policies you violated and what steps you can take to avoid 
those mistakes in the future. Additonal violations could cause eBay
to cancel your listings.



=cut


use constant Fair => scalar('Fair');


=head2 Poor

Your selling status and privileges are at risk. 
Check to see what policies you have violated and take steps 
improve your selling practices. 
Additonal violations could cause eBay to cancel your listings and/or
add restrictions on your account. You could lose your PowerSeller 
status and privileges.



=cut


use constant Poor => scalar('Poor');


=head2 Failing

Your account is at risk and may be suspended. 
Check the policies you violated and improve your selling practices immediately.
Additonal violations could cause eBay to cancel your listings,
add restrictions on your account, suspend your account, and or take other measures. 
You could lose your PowerSeller status and privileges.



=cut


use constant Failing => scalar('Failing');


=head2 CustomCode

Reserved for internal or future use.



=cut


use constant CustomCode => scalar('CustomCode');







1;   
