#!/usr/bin/perl
# This is automatically generated by author/import-moose-test.pl.
# DO NOT EDIT THIS FILE. ANY CHANGES WILL BE LOST!!!
use lib "t/lib";
use MooseCompat;

use strict;
use warnings;

use Test::More;
use Test::Exception;

=pod

This tests to make sure that the inlined constructor
has all the type constraints in order, even in the
cases when there is no type constraint available, such
as with a Mouse::Meta::Attribute object.

=cut

{
    package Foo;
    use Mouse;
    use Mouse::Util::TypeConstraints;

    coerce 'Int' => from 'Str' => via { length $_ ? $_ : 69 };

    has 'foo' => (is => 'rw', isa => 'Int');
    has 'baz' => (is => 'rw', isa => 'Int');
    has 'zot' => (is => 'rw', isa => 'Int', init_arg => undef);
    has 'moo' => (is => 'rw', isa => 'Int', coerce => 1, default => '', required => 1);
    has 'boo' => (is => 'rw', isa => 'Int', coerce => 1, builder => '_build_boo', required => 1);

    sub _build_boo { '' }

    Foo->meta->add_attribute(
        Mouse::Meta::Attribute->new(
            'bar' => (
                accessor => 'bar',
            )
        )
    );
}

for (1..2) {
    my $is_immutable   = Foo->meta->is_immutable;
    my $mutable_string = $is_immutable ? 'immutable' : 'mutable';
    lives_ok {
        my $f = Foo->new(foo => 10, bar => "Hello World", baz => 10, zot => 4);
        is($f->moo, 69, "Type coercion works as expected on default ($mutable_string)");
        is($f->boo, 69, "Type coercion works as expected on builder ($mutable_string)");
    } "... this passes the constuctor correctly ($mutable_string)";

    lives_ok {
        Foo->new(foo => 10, bar => "Hello World", baz => 10, zot => "not an int");
    } "... the constructor doesn't care about 'zot' ($mutable_string)";

    dies_ok {
        Foo->new(foo => "Hello World", bar => 100, baz => "Hello World");
    } "... this fails the constuctor correctly ($mutable_string)";

    Foo->meta->make_immutable(debug => 0) unless $is_immutable;
}

done_testing;
