/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.load;

import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import org.apache.derby.impl.load.ControlInfo;
import org.apache.derby.impl.load.ImportReadData;
import org.apache.derby.impl.load.ImportResultSetMetaData;
import org.apache.derby.impl.load.LoadError;
import org.apache.derby.vti.VTITemplate;

abstract class ImportAbstract
extends VTITemplate {
    protected ControlInfo controlFileReader;
    protected ImportReadData importReadData;
    protected String[] columnNames;
    protected int numberOfColumns;
    protected int[] columnWidths;
    protected String[] nextRow;
    protected ResultSetMetaData importResultSetMetaData;
    protected int noOfColumnsExpected;
    private boolean wasNull;
    protected static final String COLUMNNAMEPREFIX = "COLUMN";

    ImportAbstract() {
    }

    protected abstract ImportReadData getImportReadData() throws Exception;

    protected void doAllTheWork() throws Exception {
        this.importReadData = this.getImportReadData();
        this.numberOfColumns = this.importReadData.getNumberOfColumns();
        if (this.numberOfColumns == 0) {
            this.numberOfColumns = this.noOfColumnsExpected;
        }
        this.columnWidths = this.controlFileReader.getColumnWidths();
        this.columnNames = new String[this.numberOfColumns];
        this.loadColumnNames();
        this.nextRow = new String[this.numberOfColumns];
        this.importResultSetMetaData = new ImportResultSetMetaData(this.numberOfColumns, this.columnNames, this.columnWidths);
    }

    protected void loadColumnNames() {
        for (int i = 1; i <= this.numberOfColumns; ++i) {
            this.columnNames[i - 1] = COLUMNNAMEPREFIX + i;
        }
    }

    public ResultSetMetaData getMetaData() {
        return this.importResultSetMetaData;
    }

    public int getRow() throws SQLException {
        return this.importReadData.getCurrentRowNumber();
    }

    public boolean next() throws SQLException {
        try {
            return this.importReadData.readNextRow(this.nextRow);
        }
        catch (Exception exception) {
            throw LoadError.unexpectedError(exception);
        }
    }

    public void close() throws SQLException {
        try {
            if (this.importReadData != null) {
                this.importReadData.closeStream();
            }
        }
        catch (Exception exception) {
            throw LoadError.unexpectedError(exception);
        }
    }

    public boolean wasNull() {
        return this.wasNull;
    }

    public String getString(int n) throws SQLException {
        if (n <= this.numberOfColumns) {
            String string = this.nextRow[n - 1];
            this.wasNull = string == null;
            return string;
        }
        throw LoadError.invalidColumnNumber(this.numberOfColumns);
    }
}

