/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr.instruct;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.sf.saxon.Controller;
import net.sf.saxon.expr.JPConverter;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.instruct.GlobalParameterSet;
import net.sf.saxon.expr.instruct.GlobalVariable;
import net.sf.saxon.expr.instruct.SlotManager;
import net.sf.saxon.expr.parser.RoleLocator;
import net.sf.saxon.expr.parser.TypeChecker;
import net.sf.saxon.om.DocumentInfo;
import net.sf.saxon.om.DocumentPool;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.om.ValueRepresentation;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.EmptySequence;
import net.sf.saxon.value.SequenceType;

public final class Bindery {
    private ValueRepresentation[] globals;
    private long[] busy;
    private GlobalParameterSet globalParameters;
    private SlotManager globalVariableMap;
    private Map<GlobalVariable, Set<GlobalVariable>> dependencies = new HashMap<GlobalVariable, Set<GlobalVariable>>();
    private boolean applyConversionRules = true;

    public void allocateGlobals(SlotManager map) {
        this.globalVariableMap = map;
        int n = map.getNumberOfVariables() + 1;
        this.globals = new ValueRepresentation[n];
        this.busy = new long[n];
        for (int i = 0; i < n; ++i) {
            this.globals[i] = null;
            this.busy[i] = -1L;
        }
    }

    public void setApplyFunctionConversionRulesToExternalVariables(boolean convert) {
        this.applyConversionRules = convert;
    }

    public boolean isApplyFunctionConversionRulesToExternalVariables() {
        return this.applyConversionRules;
    }

    public void defineGlobalParameters(GlobalParameterSet params) {
        this.globalParameters = params;
    }

    public boolean useGlobalParameter(StructuredQName qName, int slot, SequenceType requiredType, XPathContext context) throws XPathException {
        ValueRepresentation val;
        if (this.globals != null && this.globals[slot] != null) {
            return true;
        }
        if (this.globalParameters == null) {
            return false;
        }
        Object obj = this.globalParameters.get(qName);
        if (obj == null) {
            return false;
        }
        if (obj instanceof DocumentInfo) {
            String systemId = ((DocumentInfo)obj).getSystemId();
            try {
                if (systemId != null && new URI(systemId).isAbsolute()) {
                    Controller controller = context.getController();
                    assert (controller != null);
                    DocumentPool pool = controller.getDocumentPool();
                    if (pool.find(systemId) == null) {
                        pool.add((DocumentInfo)obj, systemId);
                    }
                }
            }
            catch (URISyntaxException err) {
                // empty catch block
            }
        }
        if (obj instanceof ValueRepresentation) {
            val = (EmptySequence)obj;
        } else {
            JPConverter converter = JPConverter.allocate(obj.getClass(), context.getConfiguration());
            val = converter.convert(obj, context);
        }
        if (val == null) {
            val = EmptySequence.getInstance();
        }
        if (this.applyConversionRules) {
            RoleLocator role = new RoleLocator(3, qName.getDisplayName(), -1);
            val = TypeChecker.applyFunctionConversionRules(val, requiredType, role, null, context);
        } else {
            XPathException err = TypeChecker.testConformance(val, requiredType, context);
            if (err != null) {
                throw err;
            }
        }
        this.globals[slot] = val;
        return true;
    }

    public void defineGlobalVariable(GlobalVariable binding, ValueRepresentation value) {
        this.globals[binding.getSlotNumber()] = value;
    }

    public boolean setExecuting(GlobalVariable binding) throws XPathException {
        long thisThread = Thread.currentThread().getId();
        int slot = binding.getSlotNumber();
        long busyThread = this.busy[slot];
        if (busyThread != -1L) {
            if (busyThread == thisThread) {
                throw new XPathException.Circularity("Circular definition of variable " + binding.getVariableQName().getDisplayName());
            }
            for (int i = 0; i < 10; ++i) {
                try {
                    Thread.sleep(20 * i);
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
                if (this.busy[slot] != -1L) continue;
                return false;
            }
            return true;
        }
        this.busy[slot] = thisThread;
        return true;
    }

    public void setNotExecuting(GlobalVariable binding) {
        int slot = binding.getSlotNumber();
        this.busy[slot] = -1L;
    }

    public synchronized ValueRepresentation saveGlobalVariableValue(GlobalVariable binding, ValueRepresentation value) {
        int slot = binding.getSlotNumber();
        if (this.globals[slot] != null) {
            return this.globals[slot];
        }
        this.busy[slot] = -1L;
        this.globals[slot] = value;
        return value;
    }

    public ValueRepresentation getGlobalVariableValue(GlobalVariable binding) {
        return this.globals[binding.getSlotNumber()];
    }

    public ValueRepresentation getGlobalVariable(int slot) {
        return this.globals[slot];
    }

    public void setGlobalVariable(int slot, ValueRepresentation value) {
        this.globals[slot] = value;
    }

    public void assignGlobalVariable(GlobalVariable binding, ValueRepresentation value) {
        this.defineGlobalVariable(binding, value);
    }

    public SlotManager getGlobalVariableMap() {
        return this.globalVariableMap;
    }

    public ValueRepresentation[] getGlobalVariables() {
        return this.globals;
    }

    public synchronized void registerDependency(GlobalVariable one, GlobalVariable two) throws XPathException {
        Set<GlobalVariable> existingDependencies;
        if (one == two) {
            throw new XPathException.Circularity("Circular dependency among global variables: " + one.getVariableQName().getDisplayName() + " depends on its own value");
        }
        Set<GlobalVariable> transitiveDependencies = this.dependencies.get(two);
        if (transitiveDependencies != null) {
            if (transitiveDependencies.contains(one)) {
                throw new XPathException.Circularity("Circular dependency among variables: " + one.getVariableQName().getDisplayName() + " depends on the value of " + two.getVariableQName().getDisplayName() + ", which depends directly or indirectly on the value of " + one.getVariableQName().getDisplayName());
            }
            for (GlobalVariable var : transitiveDependencies) {
                this.registerDependency(one, var);
            }
        }
        if ((existingDependencies = this.dependencies.get(one)) == null) {
            existingDependencies = new HashSet<GlobalVariable>();
            this.dependencies.put(one, existingDependencies);
        }
        existingDependencies.add(two);
    }
}

