#!/usr/bin/perl

package eBay::API::XML::DataType::MemberMessageExchangeType;

use strict;
use warnings;  

##########################################################################
#
# Module: ............... <user defined location>eBay/API/XML
# File: ................. MemberMessageExchangeType.pm
# Generated by: ......... genEBayApiDataTypes.pl
# Last Generated: ....... 08/24/2008 16:44
# API Release Number: ... 579
#
##########################################################################  

=head1 NAME

eBay::API::XML::DataType::MemberMessageExchangeType

=head1 DESCRIPTION

Container for message metadata.



=head1 SYNOPSIS

=cut


=head1 INHERITANCE

eBay::API::XML::DataType::MemberMessageExchangeType inherits from the L<eBay::API::XML::BaseDataType> class

=cut

use eBay::API::XML::BaseDataType;
our @ISA = ("eBay::API::XML::BaseDataType");

use eBay::API::XML::DataType::ItemType;
use eBay::API::XML::DataType::MemberMessageType;
use eBay::API::XML::DataType::Enum::MessageStatusTypeCodeType;


my @gaProperties = ( [ 'CreationDate', 'xs:dateTime', '', '', '' ]
	, [ 'Item', 'ns:ItemType', ''
	     ,'eBay::API::XML::DataType::ItemType', '1' ]
	, [ 'LastModifiedDate', 'xs:dateTime', '', '', '' ]
	, [ 'MessageStatus', 'ns:MessageStatusTypeCodeType', ''
	     ,'eBay::API::XML::DataType::Enum::MessageStatusTypeCodeType', '' ]
	, [ 'Question', 'ns:MemberMessageType', ''
	     ,'eBay::API::XML::DataType::MemberMessageType', '1' ]
	, [ 'Response', 'xs:string', '1', '', '' ]
                    );
push @gaProperties, @{eBay::API::XML::BaseDataType::getPropertiesList()};

my @gaAttributes = ( 
                    );
push @gaAttributes, @{eBay::API::XML::BaseDataType::getAttributesList()};

=head1 Subroutines:

=cut

sub new {
  my $classname = shift;
  my %args = @_;
  my $self = $classname->SUPER::new(%args);
  return $self;
}

sub isScalar {
   return 0; 
}



=head2 setCreationDate()

Date the message was created. In the request, used to filter response. Returned
if the parent container is returned.

#    Argument: 'xs:dateTime'

=cut

sub setCreationDate {
  my $self = shift;
  $self->{'CreationDate'} = shift
}

=head2 getCreationDate()

  Calls: GetAdFormatLeads
  Returned: Conditionally
  Details: DetailLevel: ReturnAll

#    Returns: 'xs:dateTime'

=cut

sub getCreationDate {
  my $self = shift;
  return $self->{'CreationDate'};
}


=head2 setItem()

The item about which the question was asked. Returned if the parent container is returned.

#    Argument: 'ns:ItemType'

=cut

sub setItem {
  my $self = shift;
  $self->{'Item'} = shift
}

=head2 getItem()

  Calls: GetMemberMessages
  Returned: Conditionally

#    Returns: 'ns:ItemType'

=cut

sub getItem {
  my $self = shift;
  return $self->_getDataTypeInstance( 'Item'
		,'eBay::API::XML::DataType::ItemType');
}


=head2 setLastModifiedDate()

Date the message was last modified. Returned if the parent container is returned.

#    Argument: 'xs:dateTime'

=cut

sub setLastModifiedDate {
  my $self = shift;
  $self->{'LastModifiedDate'} = shift
}

=head2 getLastModifiedDate()

  Calls: GetMemberMessages
  Returned: Conditionally

#    Returns: 'xs:dateTime'

=cut

sub getLastModifiedDate {
  my $self = shift;
  return $self->{'LastModifiedDate'};
}


=head2 setMessageStatus()

The status of the message. Returned if the parent container is returned.

#    Argument: 'ns:MessageStatusTypeCodeType'

=cut

sub setMessageStatus {
  my $self = shift;
  $self->{'MessageStatus'} = shift
}

=head2 getMessageStatus()

  Calls: GetMemberMessages
  Returned: Conditionally

#    Returns: 'ns:MessageStatusTypeCodeType'

=cut

sub getMessageStatus {
  my $self = shift;
  return $self->{'MessageStatus'};
}


=head2 setQuestion()

Contains all the information about the question being asked.  Returned if the
parent container is returned.

#    Argument: 'ns:MemberMessageType'

=cut

sub setQuestion {
  my $self = shift;
  $self->{'Question'} = shift
}

=head2 getQuestion()

  Calls: GetAdFormatLeads
  Returned: Conditionally
  Details: DetailLevel: ReturnAll

  Calls: GetMemberMessages
  Returned: Conditionally

#    Returns: 'ns:MemberMessageType'

=cut

sub getQuestion {
  my $self = shift;
  return $self->_getDataTypeInstance( 'Question'
		,'eBay::API::XML::DataType::MemberMessageType');
}


=head2 setResponse()

An answer to the question. Returned if the parent container is returned.
<br/><br/>
For GetAdFormatLeads, returned if the seller responded to the
lead's question. Contains the body of the seller's response
message.

#    Argument: reference to an array  
                      of 'xs:string'

=cut

sub setResponse {
  my $self = shift;
  $self->{'Response'} = 
		$self->convertArray_To_RefToArrayIfNeeded(@_);
}

=head2 getResponse()

  Calls: GetAdFormatLeads
  Returned: Conditionally
  Details: DetailLevel: ReturnAll

  Calls: GetMemberMessages
  Returned: Conditionally

#    Returns: reference to an array  
                      of 'xs:string'

=cut

sub getResponse {
  my $self = shift;
  return $self->_getDataTypeArray('Response');
}





##  Attribute and Property lists
sub getPropertiesList {
   my $self = shift;
   return \@gaProperties;
}

sub getAttributesList {
   my $self = shift;
   return \@gaAttributes;
}



1;   
