/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.metadata.iso.content;

import java.util.Collection;
import java.util.Collections;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlSeeAlso;
import javax.xml.bind.annotation.XmlType;
import org.apache.sis.internal.jaxb.gmi.MI_CoverageDescription;
import org.apache.sis.internal.metadata.Dependencies;
import org.apache.sis.internal.metadata.LegacyPropertyAdapter;
import org.apache.sis.metadata.iso.content.AbstractContentInformation;
import org.apache.sis.metadata.iso.content.DefaultAttributeGroup;
import org.apache.sis.metadata.iso.content.DefaultImageDescription;
import org.opengis.annotation.Obligation;
import org.opengis.annotation.Specification;
import org.opengis.annotation.UML;
import org.opengis.metadata.Identifier;
import org.opengis.metadata.content.CoverageContentType;
import org.opengis.metadata.content.CoverageDescription;
import org.opengis.metadata.content.ImageDescription;
import org.opengis.metadata.content.RangeDimension;
import org.opengis.metadata.content.RangeElementDescription;
import org.opengis.util.RecordType;

@XmlType(name="MD_CoverageDescription_Type", propOrder={"attributeDescription", "contentType", "dimensions", "rangeElementDescriptions"})
@XmlRootElement(name="MD_CoverageDescription")
@XmlSeeAlso(value={DefaultImageDescription.class, MI_CoverageDescription.class})
public class DefaultCoverageDescription
extends AbstractContentInformation
implements CoverageDescription {
    private static final long serialVersionUID = 2161065580202989466L;
    private RecordType attributeDescription;
    private Identifier processingLevelCode;
    private Collection<DefaultAttributeGroup> attributeGroups;
    private Collection<RangeElementDescription> rangeElementDescriptions;

    public DefaultCoverageDescription() {
    }

    public DefaultCoverageDescription(CoverageDescription coverageDescription) {
        super(coverageDescription);
        if (coverageDescription != null) {
            this.attributeDescription = coverageDescription.getAttributeDescription();
            this.rangeElementDescriptions = this.copyCollection(coverageDescription.getRangeElementDescriptions(), RangeElementDescription.class);
            if (coverageDescription instanceof DefaultCoverageDescription) {
                this.processingLevelCode = ((DefaultCoverageDescription)coverageDescription).getProcessingLevelCode();
                this.attributeGroups = this.copyCollection(((DefaultCoverageDescription)coverageDescription).getAttributeGroups(), DefaultAttributeGroup.class);
            }
        }
    }

    public static DefaultCoverageDescription castOrCopy(CoverageDescription coverageDescription) {
        if (coverageDescription instanceof ImageDescription) {
            return DefaultImageDescription.castOrCopy((ImageDescription)coverageDescription);
        }
        if (coverageDescription == null || coverageDescription instanceof DefaultCoverageDescription) {
            return (DefaultCoverageDescription)coverageDescription;
        }
        return new DefaultCoverageDescription(coverageDescription);
    }

    @Override
    @XmlElement(name="attributeDescription", required=true)
    public RecordType getAttributeDescription() {
        return this.attributeDescription;
    }

    public void setAttributeDescription(RecordType recordType) {
        this.checkWritePermission();
        this.attributeDescription = recordType;
    }

    @UML(identifier="processingLevelCode", obligation=Obligation.OPTIONAL, specification=Specification.ISO_19115)
    public Identifier getProcessingLevelCode() {
        return this.processingLevelCode;
    }

    public void setProcessingLevelCode(Identifier identifier) {
        this.checkWritePermission();
        this.processingLevelCode = identifier;
    }

    @UML(identifier="attributeGroup", obligation=Obligation.OPTIONAL, specification=Specification.ISO_19115)
    public Collection<DefaultAttributeGroup> getAttributeGroups() {
        this.attributeGroups = this.nonNullCollection(this.attributeGroups, DefaultAttributeGroup.class);
        return this.attributeGroups;
    }

    public void setAttributeGroups(Collection<? extends DefaultAttributeGroup> collection) {
        this.attributeGroups = this.writeCollection(collection, this.attributeGroups, DefaultAttributeGroup.class);
    }

    @Override
    @Deprecated
    @XmlElement(name="contentType", required=true)
    @Dependencies(value={"getAttributeGroups"})
    public CoverageContentType getContentType() {
        CoverageContentType coverageContentType = null;
        Collection<DefaultAttributeGroup> collection = this.getAttributeGroups();
        if (collection != null) {
            block0: for (DefaultAttributeGroup defaultAttributeGroup : collection) {
                Collection<CoverageContentType> collection2 = defaultAttributeGroup.getContentTypes();
                if (collection2 == null) continue;
                for (CoverageContentType coverageContentType2 : collection2) {
                    if (coverageContentType == null) {
                        coverageContentType = coverageContentType2;
                        continue;
                    }
                    LegacyPropertyAdapter.warnIgnoredExtraneous(CoverageContentType.class, DefaultCoverageDescription.class, "getContentType");
                    continue block0;
                }
            }
        }
        return coverageContentType;
    }

    @Deprecated
    public void setContentType(CoverageContentType coverageContentType) {
        Object object;
        this.checkWritePermission();
        Collection<CoverageContentType> collection = LegacyPropertyAdapter.asCollection(coverageContentType);
        Collection<DefaultAttributeGroup> collection2 = this.attributeGroups;
        if (collection2 != null && (object = collection2.iterator()).hasNext()) {
            DefaultAttributeGroup defaultAttributeGroup = (DefaultAttributeGroup)object.next();
            defaultAttributeGroup.setContentTypes(collection);
            return;
        }
        object = new DefaultAttributeGroup();
        ((DefaultAttributeGroup)object).setContentTypes(collection);
        if (collection2 != null) {
            collection2.add((DefaultAttributeGroup)object);
        } else {
            collection2 = Collections.singleton(object);
        }
        this.setAttributeGroups(collection2);
    }

    @Deprecated
    @XmlElement(name="dimension")
    @Dependencies(value={"getAttributeGroups"})
    public final Collection<RangeDimension> getDimensions() {
        return new LegacyPropertyAdapter<RangeDimension, DefaultAttributeGroup>(this.getAttributeGroups()){

            @Override
            protected DefaultAttributeGroup wrap(RangeDimension rangeDimension) {
                DefaultAttributeGroup defaultAttributeGroup = new DefaultAttributeGroup();
                defaultAttributeGroup.setAttributes(1.asCollection(rangeDimension));
                return defaultAttributeGroup;
            }

            @Override
            protected RangeDimension unwrap(DefaultAttributeGroup defaultAttributeGroup) {
                return 1.getSingleton(defaultAttributeGroup.getAttributes(), RangeDimension.class, this, DefaultCoverageDescription.class, "getDimensions");
            }

            @Override
            protected boolean update(DefaultAttributeGroup defaultAttributeGroup, RangeDimension rangeDimension) {
                if (defaultAttributeGroup instanceof DefaultAttributeGroup) {
                    defaultAttributeGroup.setAttributes(1.asCollection(rangeDimension));
                    return true;
                }
                return false;
            }
        }.validOrNull();
    }

    @Deprecated
    public void setDimensions(Collection<? extends RangeDimension> collection) {
        this.checkWritePermission();
        ((LegacyPropertyAdapter)this.getDimensions()).setValues(collection);
    }

    @XmlElement(name="rangeElementDescription", namespace="http://www.isotc211.org/2005/gmi")
    public Collection<RangeElementDescription> getRangeElementDescriptions() {
        this.rangeElementDescriptions = this.nonNullCollection(this.rangeElementDescriptions, RangeElementDescription.class);
        return this.rangeElementDescriptions;
    }

    public void setRangeElementDescriptions(Collection<? extends RangeElementDescription> collection) {
        this.rangeElementDescriptions = this.writeCollection(collection, this.rangeElementDescriptions, RangeElementDescription.class);
    }
}

