# NAME

App::Greple::tee - ενότητα για την αντικατάσταση του κειμένου που ταιριάζει με το αποτέλεσμα της εξωτερικής εντολής

# SYNOPSIS

    greple -Mtee command -- ...

# VERSION

Version 0.9903

# DESCRIPTION

Η ενότητα **-Mtee** του Greple στέλνει το τμήμα του κειμένου που ταιριάζει με την εντολή φίλτρου που έχει δοθεί και τα αντικαθιστά με το αποτέλεσμα της εντολής. Η ιδέα προέρχεται από την εντολή που ονομάζεται **teip**. Είναι σαν να παρακάμπτουμε μερικά δεδομένα στην εξωτερική εντολή φίλτρου.

Η εντολή φίλτρου ακολουθεί τη δήλωση της ενότητας (`-Mtee`) και τερματίζεται με δύο παύλες (`--`). Για παράδειγμα, η επόμενη εντολή καλεί την εντολή `tr` με ορίσματα `a-z A-Z` για την αντιστοιχισμένη λέξη στα δεδομένα.

    greple -Mtee tr a-z A-Z -- '\w+' ...

Η παραπάνω εντολή μετατρέπει όλες τις λέξεις που ταιριάζουν από πεζά σε κεφαλαία. Στην πραγματικότητα αυτό το ίδιο το παράδειγμα δεν είναι τόσο χρήσιμο επειδή η **greple** μπορεί να κάνει το ίδιο πράγμα πιο αποτελεσματικά με την επιλογή **--cm**.

Από προεπιλογή, η εντολή εκτελείται ως ενιαία διεργασία και όλα τα δεδομένα που αντιστοιχούν αποστέλλονται στη διεργασία αναμεμειγμένα. Εάν το κείμενο που ταιριάζει δεν τελειώνει με νέα γραμμή, προστίθεται πριν από την αποστολή και αφαιρείται μετά τη λήψη. Τα δεδομένα εισόδου και εξόδου αντιστοιχίζονται γραμμή προς γραμμή, οπότε ο αριθμός των γραμμών εισόδου και εξόδου πρέπει να είναι ίδιος.

Χρησιμοποιώντας την επιλογή **--discrete**, καλείται μεμονωμένη εντολή για κάθε αντιστοιχισμένη περιοχή κειμένου. Μπορείτε να καταλάβετε τη διαφορά από τις ακόλουθες εντολές.

    greple -Mtee cat -n -- copyright LICENSE
    greple -Mtee cat -n -- copyright LICENSE --discrete

Οι γραμμές των δεδομένων εισόδου και εξόδου δεν χρειάζεται να είναι πανομοιότυπες όταν χρησιμοποιείται η επιλογή **--discrete**.

# OPTIONS

- **--discrete**

    Κλήση νέας εντολής ξεχωριστά για κάθε αντιστοιχισμένο τμήμα.

- **--bulkmode**

    Με την επιλογή <--discrete>, κάθε εντολή εκτελείται κατά παραγγελία. Η επιλογή
    <--bulkmode> option causes all conversions to be performed at once.

- **--crmode**

    Αυτή η επιλογή αντικαθιστά όλους τους χαρακτήρες νέας γραμμής στη μέση κάθε μπλοκ με χαρακτήρες επιστροφής μεταφορέα. Οι επιστροφές μεταφορέα που περιέχονται στο αποτέλεσμα της εκτέλεσης της εντολής επανέρχονται σε χαρακτήρα νέας γραμμής. Έτσι, τα μπλοκ που αποτελούνται από πολλές γραμμές μπορούν να επεξεργαστούν σε παρτίδες χωρίς τη χρήση της επιλογής **--discrete**.

- **--fillup**

    Συνδυάστε μια ακολουθία μη κενών γραμμών σε μια ενιαία γραμμή προτού τις περάσετε στην εντολή filter. Οι χαρακτήρες νέας γραμμής μεταξύ χαρακτήρων ευρέος πλάτους διαγράφονται και οι υπόλοιποι χαρακτήρες νέας γραμμής αντικαθίστανται με κενά.

- **--blocks**

    Κανονικά, η περιοχή που ταιριάζει με το καθορισμένο μοτίβο αναζήτησης αποστέλλεται στην εξωτερική εντολή. Εάν καθοριστεί αυτή η επιλογή, δεν θα υποβληθεί σε επεξεργασία η περιοχή που ταιριάζει, αλλά ολόκληρο το μπλοκ που την περιέχει.

    Για παράδειγμα, για να στείλετε γραμμές που περιέχουν το μοτίβο `foo` στην εξωτερική εντολή, πρέπει να καθορίσετε το μοτίβο που ταιριάζει σε ολόκληρη τη γραμμή:

        greple -Mtee cat -n -- '^.*foo.*\n' --all

    Αλλά με την επιλογή **--blocks**, μπορεί να γίνει απλά ως εξής:

        greple -Mtee cat -n -- foo --blocks

    Με την επιλογή **--blocks**, αυτή η ενότητα συμπεριφέρεται περισσότερο σαν την επιλογή **-g** του [teip(1)](http://man.he.net/man1/teip). Διαφορετικά, η συμπεριφορά του είναι παρόμοια με αυτή του [teip(1)](http://man.he.net/man1/teip) με την επιλογή **-o**.

    Μην χρησιμοποιείτε το **--blocks** με την επιλογή **--all**, καθώς το μπλοκ θα είναι το σύνολο των δεδομένων.

- **--squeeze**

    Συνδυάζει δύο ή περισσότερους διαδοχικούς χαρακτήρες νέας γραμμής σε έναν.

# WHY DO NOT USE TEIP

Πρώτα απ' όλα, όποτε μπορείτε να το κάνετε με την εντολή **teip**, χρησιμοποιήστε την. Είναι ένα εξαιρετικό εργαλείο και πολύ πιο γρήγορο από την εντολή **greple**.

Επειδή η **greple** έχει σχεδιαστεί για να επεξεργάζεται αρχεία εγγράφων, έχει πολλά χαρακτηριστικά που είναι κατάλληλα για αυτήν, όπως τα στοιχεία ελέγχου της περιοχής αντιστοίχισης. Ίσως αξίζει να χρησιμοποιήσετε το **greple** για να επωφεληθείτε από αυτά τα χαρακτηριστικά.

Επίσης, το **teip** δεν μπορεί να χειριστεί πολλαπλές γραμμές δεδομένων ως ενιαία μονάδα, ενώ το **greple** μπορεί να εκτελέσει μεμονωμένες εντολές σε ένα κομμάτι δεδομένων που αποτελείται από πολλαπλές γραμμές.

# EXAMPLE

Η επόμενη εντολή θα βρει μπλοκ κειμένου μέσα σε έγγραφο στυλ [perlpod(1)](http://man.he.net/man1/perlpod) που περιλαμβάνεται στο αρχείο μονάδας Perl.

    greple --inside '^=(?s:.*?)(^=cut|\z)' --re '^(\w.+\n)+' tee.pm

Μπορείτε να τα μεταφράσετε με την υπηρεσία DeepL εκτελώντας την παραπάνω εντολή σε συνδυασμό με την ενότητα **-Mtee** η οποία καλεί την εντολή **deepl** ως εξής:

    greple -Mtee deepl text --to JA - -- --fillup ...

Η ειδική ενότητα [App::Greple::xlate::deepl](https://metacpan.org/pod/App%3A%3AGreple%3A%3Axlate%3A%3Adeepl) είναι όμως πιο αποτελεσματική για το σκοπό αυτό. Στην πραγματικότητα, η υπόδειξη της υλοποίησης του module **tee** προήλθε από το module **xlate**.

# EXAMPLE 2

Η επόμενη εντολή θα βρει κάποιο εσοχές στο έγγραφο LICENSE.

    greple --re '^[ ]{2}[a-z][)] .+\n([ ]{5}.+\n)*' -C LICENSE

      a) distribute a Standard Version of the executables and library files,
         together with instructions (in the manual page or equivalent) on where to
         get the Standard Version.

      b) accompany the distribution with the machine-readable source of the Package
         with your modifications.

Μπορείτε να αναδιαμορφώσετε αυτό το τμήμα χρησιμοποιώντας την ενότητα **tee** με την εντολή **ansifold**:

    greple -Mtee ansifold -rsw40 --prefix '     ' -- --discrete --re ...

      a) distribute a Standard Version of
         the executables and library files,
         together with instructions (in the
         manual page or equivalent) on where
         to get the Standard Version.

      b) accompany the distribution with the
         machine-readable source of the
         Package with your modifications.

Η επιλογή --discrete θα εκκινήσει πολλαπλές διεργασίες, οπότε η εκτέλεση της διεργασίας θα διαρκέσει περισσότερο. Έτσι, μπορείτε να χρησιμοποιήσετε την επιλογή `--διαχωρισμός '\r'` με την επιλογή `ansifold` η οποία παράγει μία μόνο γραμμή χρησιμοποιώντας τον χαρακτήρα CR αντί για NL.

    greple -Mtee ansifold -rsw40 --prefix '     ' --separate '\r' --

Στη συνέχεια, μετατρέψτε τον χαρακτήρα CR σε NL με την εντολή [tr(1)](http://man.he.net/man1/tr) ή κάποια άλλη.

    ... | tr '\r' '\n'

# EXAMPLE 3

Σκεφτείτε μια κατάσταση στην οποία θέλετε να αναζητήσετε με grep συμβολοσειρές από γραμμές που δεν έχουν κεφαλίδα. Για παράδειγμα, μπορεί να θέλετε να αναζητήσετε ονόματα εικόνων Docker από την εντολή `docker image ls`, αλλά να αφήσετε τη γραμμή επικεφαλίδας. Μπορείτε να το κάνετε με την ακόλουθη εντολή.

    greple -Mtee grep perl -- -Mline -L 2: --discrete --all

Η επιλογή `-Mline -L 2:` ανακτά τις προτελευταίες γραμμές και τις στέλνει στην εντολή `grep perl`. Η επιλογή --discrete απαιτείται επειδή ο αριθμός των γραμμών εισόδου και εξόδου αλλάζει, αλλά επειδή η εντολή εκτελείται μόνο μία φορά, δεν υπάρχει μειονέκτημα απόδοσης.

Αν προσπαθήσετε να κάνετε το ίδιο πράγμα με την εντολή **teip**, η `teip -l 2- -- grep` θα δώσει σφάλμα επειδή ο αριθμός των γραμμών εξόδου είναι μικρότερος από τον αριθμό των γραμμών εισόδου. Ωστόσο, δεν υπάρχει κανένα πρόβλημα με το αποτέλεσμα που λαμβάνεται.

# INSTALL

## CPANMINUS

    $ cpanm App::Greple::tee

# SEE ALSO

[App::Greple::tee](https://metacpan.org/pod/App%3A%3AGreple%3A%3Atee), [https://github.com/kaz-utashiro/App-Greple-tee](https://github.com/kaz-utashiro/App-Greple-tee)

[https://github.com/greymd/teip](https://github.com/greymd/teip)

[App::Greple](https://metacpan.org/pod/App%3A%3AGreple), [https://github.com/kaz-utashiro/greple](https://github.com/kaz-utashiro/greple)

[https://github.com/tecolicom/Greple](https://github.com/tecolicom/Greple)

[App::Greple::xlate](https://metacpan.org/pod/App%3A%3AGreple%3A%3Axlate)

# BUGS

Η επιλογή `--fillup` θα αφαιρέσει τα κενά μεταξύ των χαρακτήρων Hangul κατά τη συνένωση κορεατικού κειμένου.

# AUTHOR

Kazumasa Utashiro

# LICENSE

Copyright © 2023 Kazumasa Utashiro.

This library is free software; you can redistribute it and/or modify
it under the same terms as Perl itself.
