/*
 * Decompiled with CFR 0.152.
 */
package com.zzo.javaserver;

import com.zzo.javaserver.Callback;
import com.zzo.javaserver.EventListener;
import com.zzo.javaserver.Log;
import com.zzo.javaserver.Shutdownable;
import com.zzo.javaserver.SwingEventListener;
import com.zzo.javaserver.UnicodeFormatter;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;

public class Dealer
extends Thread
implements Shutdownable {
    PrintWriter out;
    BufferedReader in;
    boolean go;
    public Hashtable object_hash;
    int object_count;
    EventListener event_listener;
    public static final String NULL_TOKEN = "___NULL___";
    public String callbackObject;

    public Dealer(BufferedReader bufferedReader, Writer writer, Writer writer2) {
        this.in = bufferedReader;
        this.out = new PrintWriter(writer);
        this.go = true;
        this.object_hash = new Hashtable();
        if (writer2 != null) {
            try {
                Class<?> clazz = Class.forName("javax.swing.JFrame");
                this.event_listener = new SwingEventListener(new PrintWriter(writer2, true));
            }
            catch (Exception exception) {
                try {
                    Class<?> clazz = Class.forName("java.awt.Frame");
                    this.event_listener = new EventListener(new PrintWriter(writer2, true));
                }
                catch (Exception exception2) {
                    this.event_listener = null;
                }
            }
        } else {
            this.event_listener = null;
        }
        this.object_count = 0;
    }

    public void run() {
        if (this.event_listener != null) {
            this.event_listener.setDealer(this);
        }
        Callback callback = new Callback(this);
        this.callbackObject = callback.getClass() + "^" + this.getObjectCount();
        this.callbackObject = this.callbackObject.substring(5);
        this.callbackObject = this.callbackObject.trim();
        this.putInHash(this.callbackObject, callback);
        while (this.go) {
            StringBuffer stringBuffer = new StringBuffer();
            String string = null;
            try {
                boolean bl = true;
                while (bl) {
                    string = this.in.readLine();
                    if (string == null || string.startsWith("\u0001")) {
                        bl = false;
                        continue;
                    }
                    stringBuffer.append(string + "\n");
                }
                if (stringBuffer != null && stringBuffer.length() > 0) {
                    stringBuffer.setLength(stringBuffer.length() - 1);
                }
                this.out.println(this.parse(stringBuffer.toString()) + "\n\u0001");
                if (!this.out.checkError()) continue;
                throw new IOException("PrintWriter error");
            }
            catch (IOException iOException) {
                Log.info("Lost connexion!");
                this.go = false;
            }
        }
        try {
            this.in.close();
            this.out.close();
        }
        catch (Exception exception) {
            Log.info("Couldn't close sumthin'");
        }
    }

    public void shutdown() {
        this.go = false;
        this.interrupt();
    }

    public String registerObject(Object object) {
        String string = object.getClass() + "^" + this.getObjectCount();
        string = string.substring(5);
        string = string.trim();
        this.putInHash(string, object);
        return string;
    }

    public String parse(String string) {
        if (string == null) {
            return null;
        }
        if (string.startsWith("NEW")) {
            Object object = null;
            try {
                Log.debug("Creating new object: " + string);
                object = this.createNewObject(string);
                Log.info("Created new object: " + object);
            }
            catch (Exception exception) {
                return this.makeErrorResponse(exception);
            }
            String string2 = object.getClass() + "^" + this.getObjectCount();
            string2 = string2.substring(5);
            string2 = string2.trim();
            this.putInHash(string2, object);
            return string2;
        }
        if (string.startsWith("CAL")) {
            String string3 = null;
            string = string.substring(3);
            string = string.trim();
            Object object = null;
            try {
                object = this.callFunction(string);
            }
            catch (Exception exception) {
                return this.makeErrorResponse(exception);
            }
            if (object != null) {
                string3 = object.getClass() + "^" + this.getObjectCount();
                string3 = string3.substring(5);
                string3 = string3.trim();
                this.putInHash(string3, object);
                return string3;
            }
            return "NUL";
        }
        if (string.startsWith("BYE")) {
            string = string.substring(3);
            if (this.object_hash.containsKey(string = string.trim())) {
                Object v = this.object_hash.get(string);
                this.object_hash.remove(string);
                if (this.event_listener != null) {
                    this.event_listener.remove_obj(v);
                }
            } else {
                return "ERROR: Object " + string + " does not exist";
            }
            return "NUL";
        }
        if (string.startsWith("GET")) {
            string = string.substring(3);
            string = string.trim();
            String string4 = null;
            Object object = null;
            try {
                object = this.makeIntoObject(string);
            }
            catch (Exception exception) {
                return this.makeErrorResponse(exception);
            }
            if (string.endsWith("LEN")) {
                return (String)object;
            }
            if (object == null) {
                return "NUL";
            }
            string4 = object.getClass() + "^" + this.getObjectCount();
            string4 = string4.substring(5);
            string4 = string4.trim();
            this.putInHash(string4, object);
            return string4;
        }
        if (string.startsWith("SET")) {
            string = string.substring(3);
            string = string.trim();
            try {
                this.setIntoObject(string);
            }
            catch (Exception exception) {
                return this.makeErrorResponse(exception);
            }
            return "NUL";
        }
        if (string.startsWith("VAL")) {
            string = string.substring(3);
            if (!this.object_hash.containsKey(string = string.trim())) {
                return "ERROR: " + string + " not in hash!";
            }
            return this.object_hash.get(string).toString();
        }
        if (string.startsWith("EVT")) {
            if (this.event_listener != null) {
                return this.event_listener.doListener(string);
            }
            return "ERROR: No event port";
        }
        if (string.startsWith("BYTE")) {
            string = string.substring(4);
            string = string.trim();
            int n = string.indexOf(" ");
            String string5 = string.substring(0, n);
            String string6 = string.substring(n + 1);
            string5 = string5.trim();
            string6 = string6.trim();
            try {
                return this.doByteRequest(string5, string6);
            }
            catch (Exception exception) {
                return this.makeErrorResponse(exception);
            }
        }
        if (string.startsWith("BCK")) {
            return this.callbackObject;
        }
        return "ERROR: Unknown command " + string;
    }

    public String callback(String string) {
        this.out.println("CALLBACK " + string + "\n\u0001");
        this.out.flush();
        StringBuffer stringBuffer = new StringBuffer();
        String string2 = null;
        try {
            boolean bl = true;
            while (bl) {
                string2 = this.in.readLine();
                if (string2 == null || string2.startsWith("\u0001")) {
                    bl = false;
                    continue;
                }
                stringBuffer.append(string2 + "\n");
            }
            if (stringBuffer != null && stringBuffer.length() > 0) {
                stringBuffer.setLength(stringBuffer.length() - 1);
            }
        }
        catch (IOException iOException) {
            Log.info("Lost connexion!");
            this.go = false;
        }
        return stringBuffer.toString();
    }

    String stripAndCheck(String string, String string2) throws Exception {
        if (!string.startsWith(string2)) {
            throw new Exception("Don't start w/" + string2);
        }
        string = string.substring(3);
        string = string.trim();
        return string;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    Object callFunction(String string) throws Exception {
        int n = string.indexOf("%");
        if (n < 0) {
            throw new Exception("No separator in " + string);
        }
        String string2 = string.substring(0, n);
        int n2 = string.indexOf("(");
        if (n2 < 0) {
            throw new Exception("No first paren in " + string);
        }
        String string3 = string.substring(n + 1, n2);
        string3 = string3.trim();
        String string4 = string.substring(n2 + 1, string.length() - 1);
        string4 = string4.trim();
        Object object = null;
        Class<?> clazz = null;
        Log.debug("IN CAL with " + string2);
        if (string2.indexOf("^") > 0) {
            if (!this.object_hash.containsKey(string2)) throw new Exception("Object " + string2 + " not in our hash!");
            object = this.object_hash.get(string2);
            clazz = object.getClass();
        } else {
            clazz = Class.forName(string2);
        }
        Log.debug("found object class: " + clazz);
        Log.debug("Parameter list = " + string4);
        Object[] objectArray = this.parseArgs(string4);
        Method method = this.getFunction(clazz, objectArray, string3);
        Log.debug("WANTING " + string3 + " on " + string2 + ":" + object + " with " + objectArray);
        if (method == null) {
            throw new Exception("Can't find function " + string3);
        }
        Log.info("Calling function " + string3 + " on " + string2 + ":" + object + " with " + objectArray);
        Object object2 = null;
        try {
            object2 = method.invoke(object, objectArray);
        }
        catch (InvocationTargetException invocationTargetException) {
            Log.warn("Exception in invoked method", invocationTargetException);
            throw Dealer.convertITE(invocationTargetException);
        }
        catch (Exception exception) {
            Log.warn("Exception invoking method", exception);
            throw exception;
        }
        if (object2 == null) return object2;
        Log.info("Got back: " + object2.toString());
        return object2;
    }

    public Method getFunction(Class clazz, Object[] objectArray, String string) {
        Log.debug("Looking for " + string + " with " + objectArray);
        Method method = this.matchMethod(objectArray, string, clazz.getMethods());
        if (method == null) {
            method = this.matchMethod(objectArray, string, clazz.getDeclaredMethods());
        }
        Log.debug("returning: " + method);
        if (method == null) {
            return null;
        }
        Log.debug("Mods: " + Modifier.toString(method.getModifiers()));
        return method;
    }

    private Method matchMethod(Object[] objectArray, String string, Method[] methodArray) {
        int n = 0;
        while (n < methodArray.length) {
            Class[] classArray = methodArray[n].getParameterTypes();
            if (this.typeMatch(objectArray, classArray)) {
                Log.debug(methodArray[n].getName() + " vs. " + string);
                if (methodArray[n].getName().equals(string)) {
                    Log.debug("FOUND A MATCH!");
                    if (!methodArray[n].isAccessible()) {
                        methodArray[n].setAccessible(true);
                    }
                    return methodArray[n];
                }
            }
            ++n;
        }
        return null;
    }

    private Field matchField(Class clazz, String string) throws NoSuchFieldException {
        Field field;
        try {
            field = clazz.getField(string);
        }
        catch (NoSuchFieldException noSuchFieldException) {
            field = clazz.getDeclaredField(string);
        }
        if (!field.isAccessible()) {
            field.setAccessible(true);
        }
        return field;
    }

    Object createNewObject(String string) throws Exception {
        Object object;
        int n = (string = this.stripAndCheck(string, "NEW")).indexOf("(");
        if (n < 0) {
            throw new Exception("No first paren in " + string);
        }
        String string2 = string.substring(0, n);
        String string3 = string.substring(n + 1, string.length() - 1);
        string3 = string3.trim();
        if (string2.startsWith("[")) {
            return this.createArray(string2, string3);
        }
        Class<?> clazz = null;
        try {
            clazz = Class.forName(string2);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new Exception("Class " + string2 + " don't exist!");
        }
        Object[] objectArray = this.parseArgs(string3);
        Log.debug("Args");
        int n2 = 0;
        while (n2 < objectArray.length) {
            Log.debug("Parameter Object " + n2 + " is " + objectArray[n2]);
            ++n2;
        }
        Constructor<?>[] constructorArray = clazz.getConstructors();
        Constructor<?> constructor = null;
        int n3 = 0;
        while (n3 < constructorArray.length) {
            object = constructorArray[n3].getParameterTypes();
            if (this.typeMatch(objectArray, (Class[])object)) {
                constructor = constructorArray[n3];
                break;
            }
            ++n3;
        }
        if (constructor == null) {
            object = new StringBuffer("No constructor found: ");
            ((StringBuffer)object).append(string2);
            ((StringBuffer)object).append("(");
            int n4 = 0;
            while (n4 < objectArray.length) {
                ((StringBuffer)object).append(objectArray[n4]);
                if (n4 != objectArray.length - 1) {
                    ((StringBuffer)object).append(", ");
                }
                ++n4;
            }
            ((StringBuffer)object).append(")");
            throw new Exception(((StringBuffer)object).toString());
        }
        Log.debug("Found a constructor");
        try {
            object = constructor.newInstance(objectArray);
        }
        catch (InvocationTargetException invocationTargetException) {
            Log.warn("Exception in constructor", invocationTargetException);
            throw Dealer.convertITE(invocationTargetException);
        }
        catch (Exception exception) {
            Log.warn("Exception invoking constructor", exception);
            throw exception;
        }
        return object;
    }

    Object createArray(String string, String string2) throws Exception {
        Object object;
        string = string.substring(2, string.length() - 1);
        StringTokenizer stringTokenizer = new StringTokenizer(string2, ",");
        int n = stringTokenizer.countTokens();
        int[] nArray = new int[n];
        int n2 = 0;
        while (stringTokenizer.hasMoreTokens()) {
            object = stringTokenizer.nextToken();
            nArray[n2++] = Integer.parseInt((String)object);
        }
        if (string.indexOf(".") < 0) {
            if (string.equalsIgnoreCase("byte")) {
                object = new byte[nArray[0]];
                return object;
            }
            if (string.equalsIgnoreCase("int")) {
                object = new int[nArray[0]];
                return object;
            }
            if (string.equalsIgnoreCase("short")) {
                object = new short[nArray[0]];
                return object;
            }
            if (string.equalsIgnoreCase("long")) {
                object = new long[nArray[0]];
                return object;
            }
            if (string.equalsIgnoreCase("boolean")) {
                object = new boolean[nArray[0]];
                return object;
            }
            if (string.equalsIgnoreCase("double")) {
                object = new double[nArray[0]];
                return object;
            }
            if (string.equalsIgnoreCase("float")) {
                object = new float[nArray[0]];
                return object;
            }
        } else {
            object = Class.forName(string);
            return Array.newInstance(object, nArray);
        }
        return null;
    }

    Object[] parseArgs(String string) throws Exception {
        Object[] objectArray;
        Vector<Object> vector = new Vector<Object>();
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\u0001");
        while (stringTokenizer.hasMoreTokens()) {
            objectArray = stringTokenizer.nextToken();
            objectArray = objectArray.trim();
            Object object = this.makeIntoObject((String)objectArray);
            vector.addElement(object);
        }
        objectArray = new Object[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    Object makeIntoObject(String string) throws Exception {
        Log.debug("Objectifying " + string);
        if (string.equalsIgnoreCase(NULL_TOKEN)) {
            return null;
        }
        if (string.indexOf(":") > 0) {
            return this.createPrimitive(string);
        }
        if (string.indexOf("#") > 0) {
            return this.getField(string);
        }
        if (string.startsWith("NEW")) {
            return this.createNewObject(string);
        }
        if (this.object_hash.containsKey(string)) {
            Object v = this.object_hash.get(string);
            return v;
        }
        throw new Exception("Object " + string + " not in our hash!");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void setIntoObject(String string) throws Exception {
        int n = string.indexOf("#");
        if (n < 0) {
            throw new Exception("Missing '#' in SET");
        }
        String string2 = string.substring(0, n);
        string2 = string2.trim();
        String string3 = string.substring(n + 1);
        int n2 = string3.indexOf("(");
        if (n2 < 0) {
            throw new Exception("Malformed SET: " + string);
        }
        String string4 = string3.substring(0, n2);
        String string5 = string3.substring(n2 + 1, string3.length() - 1);
        Object object = this.makeIntoObject(string5);
        Object object2 = null;
        Class<?> clazz = null;
        if (string2.indexOf("^") > 0) {
            if (!this.object_hash.containsKey(string2)) throw new Exception("Object " + string2 + " doesn't exist!");
            object2 = this.object_hash.get(string2);
            clazz = object2.getClass();
        } else {
            clazz = Class.forName(string2);
        }
        if (string2.startsWith("[")) {
            Array.set(object2, Integer.parseInt(string4), object);
            return;
        }
        Field field = this.matchField(clazz, string4);
        field.set(object2, object);
    }

    Object createPrimitive(String string) throws Exception {
        int n = string.lastIndexOf(":");
        String string2 = string.substring(0, n);
        String string3 = string.substring(n + 1);
        if (string3.equalsIgnoreCase("int")) {
            int n2 = Integer.parseInt(string2);
            return new Integer(n2);
        }
        if (string3.equalsIgnoreCase("short")) {
            short s = Short.parseShort(string2);
            return new Short(s);
        }
        if (string3.equalsIgnoreCase("byte")) {
            byte by = Byte.parseByte(string2);
            return new Byte(by);
        }
        if (string3.equalsIgnoreCase("char")) {
            char c = string2.charAt(0);
            return new Character(c);
        }
        if (string3.equalsIgnoreCase("long")) {
            long l = Long.parseLong(string2);
            return new Long(l);
        }
        if (string3.equalsIgnoreCase("float")) {
            return new Float(string2);
        }
        if (string3.equalsIgnoreCase("double")) {
            return new Double(string2);
        }
        if (string3.equalsIgnoreCase("boolean")) {
            return new Boolean(string2);
        }
        if (string3.startsWith("string")) {
            string2 = string2.substring(1);
            int n3 = string3.indexOf("_");
            if (n3 > 0) {
                String string4 = string3.substring(n3 + 1);
                return new String(string2.substring(0, string2.length() - 1).getBytes(), string4);
            }
            return new String(string2.substring(0, string2.length() - 1));
        }
        throw new Exception("I don't know the primitive type " + string3);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    Object getField(String string) throws Exception {
        int n = string.indexOf("#");
        String string2 = string.substring(0, n);
        String string3 = string.substring(n + 1);
        Object object = null;
        Class<?> clazz = null;
        if (string2.indexOf("^") > 0) {
            if (!this.object_hash.containsKey(string2)) throw new Exception("Object " + string2 + " doesn't exist!");
            object = this.object_hash.get(string2);
            clazz = object.getClass();
        } else {
            clazz = Class.forName(string2);
        }
        if (string2.startsWith("[") && string3.equalsIgnoreCase("len")) {
            int n2 = Array.getLength(object);
            return Integer.toString(n2);
        }
        if (string2.startsWith("[")) {
            return Array.get(object, Integer.parseInt(string3));
        }
        Field field = this.matchField(clazz, string3);
        return field.get(object);
    }

    boolean typeMatch(Object[] objectArray, Class[] classArray) {
        if (objectArray.length != classArray.length) {
            return false;
        }
        Log.debug("typeMatch: here we go... " + objectArray.length);
        int n = 0;
        while (n < objectArray.length) {
            if (objectArray[n] == null) {
                if (classArray[n].isPrimitive()) {
                    return false;
                }
            } else {
                Class<?> clazz = objectArray[n].getClass();
                Log.debug(n + ": " + clazz + " vs. " + classArray[n]);
                if (!this.checkPrimitives(clazz, classArray[n]) && !classArray[n].isAssignableFrom(clazz)) {
                    Log.debug("not assignable from...");
                    return false;
                }
            }
            ++n;
        }
        return true;
    }

    boolean checkPrimitives(Class clazz, Class clazz2) {
        Class clazz3 = null;
        Class clazz4 = null;
        Log.debug("CheckPrim: " + clazz3 + " vs. " + clazz4);
        if (clazz.isArray() && clazz2.isArray()) {
            return true;
        }
        if (!clazz.isPrimitive() && !clazz2.isPrimitive()) {
            Log.debug("Neither is prim!");
            return false;
        }
        if (clazz.isPrimitive() && clazz2.isPrimitive()) {
            return false;
        }
        if (clazz.isPrimitive()) {
            clazz3 = clazz;
            clazz4 = clazz2;
        } else {
            clazz3 = clazz2;
            clazz4 = clazz;
        }
        String string = clazz3.toString();
        String string2 = clazz4.toString();
        Log.debug(string + " vs. " + string2);
        if (string.equals("int") && string2.equals("class java.lang.Integer")) {
            return true;
        }
        if (string.equals("boolean") && string2.equals("class java.lang.Boolean")) {
            return true;
        }
        if (string.equals("double") && string2.equals("class java.lang.Double")) {
            return true;
        }
        if (string.equals("float") && string2.equals("class java.lang.Float")) {
            return true;
        }
        if (string.equals("char") && string2.equals("class java.lang.Character")) {
            return true;
        }
        if (string.equals("byte") && string2.equals("class java.lang.Byte")) {
            return true;
        }
        if (string.equals("short") && string2.equals("class java.lang.Short")) {
            return true;
        }
        if (string.equals("long") && string2.equals("class java.lang.Long")) {
            return true;
        }
        return string.equals("void") && string2.equals("class java.lang.Void");
    }

    public synchronized String putInHash(String string, Object object) {
        if (string.startsWith("class")) {
            string = string.substring(5);
        }
        string = string.trim();
        this.object_hash.put(string, object);
        return string;
    }

    public synchronized int getObjectCount() {
        return this.object_count++;
    }

    public Object extractArray(Object object) {
        return null;
    }

    public String doByteRequest(String string, String string2) throws Exception {
        if (string.equals("java.lang.String")) {
            String string3;
            Log.debug("IN do Byte Request!\n");
            int n = string2.indexOf(" ");
            String string4 = string2.substring(0, n);
            string4 = string4.trim();
            String string5 = string2.substring(n + 1);
            int n2 = Integer.parseInt(string5);
            Log.debug("Got encaps of " + string4 + " and len of " + n2);
            this.out.println("GIMMIE");
            this.out.flush();
            Log.debug("Waiting to read...\n");
            String string6 = this.in.readLine();
            string6 = string6.trim();
            Log.debug("Just read in line " + string6);
            StringTokenizer stringTokenizer = new StringTokenizer(string6, " ");
            int n3 = stringTokenizer.countTokens();
            if (n3 != n2) {
                Log.debug("Different number of bytes! " + n3 + " vs. " + n2);
            }
            byte[] byArray = new byte[n3];
            int n4 = 0;
            while (stringTokenizer.hasMoreTokens()) {
                string3 = stringTokenizer.nextToken();
                string3 = string3.trim();
                Log.debug("Reading : " + string3);
                try {
                    byArray[n4++] = (byte)Integer.parseInt(string3);
                }
                catch (Exception exception) {
                    Log.warn("ERROR: ", exception);
                    Log.warn("TOK: " + string3);
                    throw exception;
                }
            }
            string3 = new String(byArray, string4);
            String string7 = string3.getClass() + "^" + this.getObjectCount();
            string7 = this.putInHash(string7, string3);
            return string7;
        }
        return "ERROR: BYTE request on " + string + " no supported";
    }

    public static void printBytes(byte[] byArray, String string) {
        int n = 0;
        while (n < byArray.length) {
            System.out.println(string + "[" + n + "] = " + "0x" + UnicodeFormatter.byteToHex(byArray[n]));
            ++n;
        }
    }

    public static void printChars(char[] cArray, String string) {
        int n = 0;
        while (n < cArray.length) {
            System.out.println(string + "[" + n + "] = " + "0x" + cArray[n]);
            ++n;
        }
    }

    private static Exception convertITE(InvocationTargetException invocationTargetException) {
        Throwable throwable = invocationTargetException.getCause();
        if (throwable instanceof Exception) {
            return (Exception)throwable;
        }
        return invocationTargetException;
    }

    public String makeErrorResponse(Exception exception) {
        if (exception instanceof InvocationTargetException) {
            exception = Dealer.convertITE((InvocationTargetException)exception);
        }
        Log.warn("Error invoking Java", exception);
        String string = exception.getClass() + "^" + this.getObjectCount();
        string = string.substring(5);
        string = string.trim();
        this.putInHash(string, exception);
        return "ERROR: " + exception.toString() + "%%%" + string;
    }
}

