use strict;
use Test::More;
use Games::Mahjongg::Solver::deBondt::FFI;

my $ffi = Games::Mahjongg::Solver::deBondt::FFI->new();
isa_ok $ffi, 'Games::Mahjongg::Solver::deBondt::FFI';

is $ffi->get_r1, 0, "r1 == 0";
$ffi->set_r1(10);
is $ffi->get_r1, 10, "r1 == 10";

my $g;
{
    use YAML::XS;
    my $yaml = YAML::XS::LoadFile "t/memo_geom.yaml";
    my(@g, @max);
  X: for my $x (sort {$a <=> $b} keys %$yaml) {
        my $v = $yaml->{$x};
        for my $y (sort {$a <=> $b} keys %$v) {
            my $v2 = $v->{$y};
            for my $d (sort {$a <=> $b} keys %$v2) {
                my $v3 = $v2->{$d};
                my $facename = $v3->{facename};
                my($group, $rest1, $rest2) = split /:/, $facename;
                push @g, join " ", map { sprintf "%02d", $_ } $y, $x, $d, $group;
            }
        }
    }
    $g = join "", map { "$_ " } @g;
}

# diag explain { G => $g };
my $length;
ok $length=length($g), "length of g";
$ffi->set_g($g);
pass("did not die on set_g");
my $g2 = $ffi->get_g;
pass("did not die on get_g/cast/free_string");
is length($g2), $length, "length of \$g2 is $length as for \$g";
is $length, 144*12, "this length $length equals 144*12";
my($remain) = $ffi->mjsolve();
pass("did not die on mjsolve");
is $remain, 0, "remain == 0 for a solvable game";
my $g3 = $ffi->get_g;
pass("did not die on second get_g");
(my $g4 = $g3) =~ s/\n/ /g;
# diag $g4;

my $yaml_string = <<EOF;
---
G_INPUT: |
  02 08 00 05
  02 10 00 25
  02 12 00 12
  02 14 00 20
  02 14 01 27
  02 16 00 30
  04 16 00 25
  06 12 00 30
  06 14 00 34
  06 16 00 20
  10 08 00 18
  10 10 00 27
  10 12 00 18
  10 12 01 12
  12 10 00 34
  12 12 00 06
  12 14 00 29
  12 16 00 05
  12 18 00 06
  14 22 00 29
G_INPUT_SCALAR: 20
R1_IN: 2
R2_IN: 18
EOF
{
    my $y = YAML::XS::Load $yaml_string;
    $g = $y->{G_INPUT};
    $ffi->set_g($g);
    $ffi->set_r1(0);
    $ffi->set_r2(0);
    ($remain) = $ffi->mjsolve();
    is $remain, 0, "remain == 0 for a (partial) solvable game";
}
for my $g ( split "\n",<<EOF
 08 08 01 00 10 04 00 00 10 16 00 00 10 12 01 00 02 20 00 01 12 06 00 01 14 08 00 01 08 08 00 01 00 08 00 02 06 02 00 02 12 16 01 02 04 16 00 02 08 22 00 03 08 10 00 03 08 12 02 03 10 12 00 03 07 26 00 04 10 12 02 04 14 16 00 04 02 18 00 04 00 04 00 05 00 20 00 05 10 20 00 05 08 16 00 05 02 14 01 06 06 06 00 06 06 16 02 06 08 12 03 06 02 12 01 07 06 18 01 07 12 20 00 07 06 18 00 07 10 18 00 08 08 14 03 08 10 14 00 08 02 12 00 08 02 08 01 09 08 10 02 09 12 14 01 09 10 14 01 09 06 10 02 10 08 18 01 10 14 18 00 10 02 08 00 10 14 22 00 11 04 16 01 11 10 10 01 11 02 14 00 11 00 14 00 12 04 20 00 12 08 04 00 12 04 14 00 12 04 16 02 13 06 20 00 13 07 28 00 13 06 14 03 13 06 24 00 14 08 16 02 14 06 10 01 14 08 14 01 14 04 14 02 15 14 06 00 15 08 18 00 15 06 14 02 15 00 10 00 16 04 04 00 16 10 08 01 16 10 16 02 16 00 02 00 17 12 12 01 17 04 18 00 17 06 14 00 17 06 04 00 18 07 00 00 18 08 20 00 18 08 14 00 18 04 08 01 19 08 24 00 19 06 16 00 19 06 12 00 19 04 06 00 20 04 10 02 20 04 08 00 20 02 10 00 20 07 13 04 21 14 10 00 21 04 14 01 21 08 14 02 21 02 16 01 22 10 14 02 22 06 14 01 22 04 10 00 22 00 18 00 23 06 08 01 23 06 12 02 23 06 12 01 23 10 18 01 24 14 24 00 24 04 10 01 24 08 12 00 24 04 12 02 25 10 06 00 25 14 14 00 25 12 12 00 25 02 06 00 26 08 06 00 26 08 10 01 26 10 10 00 26 04 18 01 27 14 20 00 27 12 08 00 27 10 16 01 27 10 22 00 28 14 04 00 28 04 12 01 28 10 08 00 28 00 06 00 29 04 22 00 29 08 02 00 29 06 10 00 29 00 22 00 30 12 08 01 30 12 18 01 30 12 16 00 30 00 16 00 31 12 10 01 31 14 02 00 31 06 12 03 31 06 22 00 32 12 18 00 32 12 10 00 32 06 08 00 32 02 18 01 33 10 10 02 33 02 16 00 33 12 14 00 33 02 10 01 34 04 12 00 34 08 16 01 34 08 12 01 34 00 12 00 35 00 24 00 35 14 12 00 35 06 16 01 35
 06 18 01 00 10 14 01 00 02 10 00 00 04 16 01 00 06 10 02 01 08 02 00 01 06 08 00 01 06 14 03 01 00 12 00 02 02 20 00 02 04 22 00 02 08 12 03 02 06 20 00 03 14 12 00 03 10 12 00 03 08 12 00 03 00 04 00 04 12 16 01 04 14 08 00 04 02 16 00 04 04 04 00 05 10 20 00 05 10 10 01 05 08 14 03 05 04 16 02 06 14 14 00 06 06 16 01 06 10 12 01 06 00 18 00 07 12 12 01 07 04 10 00 07 06 16 00 07 00 20 00 08 08 06 00 08 12 06 00 08 12 18 00 08 02 14 01 09 04 10 02 09 08 08 01 09 08 14 02 09 00 24 00 10 07 13 04 10 08 24 00 10 12 08 01 10 02 16 01 11 06 02 00 11 08 22 00 11 10 14 02 11 07 00 00 12 10 18 00 12 06 12 03 12 06 12 02 12 12 14 01 13 14 24 00 13 04 12 01 13 06 14 00 13 00 10 00 14 06 04 00 14 04 10 01 14 12 12 00 14 14 04 00 15 04 12 00 15 06 18 00 15 10 16 00 15 04 06 00 16 06 16 02 16 06 22 00 16 08 14 01 16 02 10 01 17 04 12 02 17 12 10 01 17 02 14 00 17 08 10 02 18 10 08 00 18 12 08 00 18 08 10 01 18 00 06 00 19 04 20 00 19 06 10 00 19 08 12 02 19 02 12 01 20 04 18 00 20 04 14 00 20 12 10 00 20 04 14 02 21 08 20 00 21 10 04 00 21 10 18 01 21 00 22 00 22 07 26 00 22 08 04 00 22 12 16 00 22 00 16 00 23 02 18 01 23 06 24 00 23 10 12 02 23 08 18 01 24 10 22 00 24 04 14 01 24 08 16 01 24 00 02 00 25 02 06 00 25 10 10 00 25 06 14 02 25 10 08 01 26 10 16 02 26 14 18 00 26 08 18 00 26 14 02 00 27 08 08 00 27 04 16 00 27 12 14 00 27 02 08 01 28 10 10 02 28 04 08 00 28 06 12 01 28 04 08 01 29 12 20 00 29 14 06 00 29 06 14 01 29 00 08 00 30 14 22 00 30 06 10 01 30 02 12 00 30 06 06 00 31 10 14 00 31 08 16 00 31 08 12 01 31 00 14 00 32 07 28 00 32 12 18 01 32 02 08 00 32 08 16 02 33 10 06 00 33 10 16 01 33 08 14 00 33 04 18 01 34 06 08 01 34 14 10 00 34 14 20 00 34 14 16 00 35 02 18 00 35 08 10 00 35 06 12 00 35
 06 16 02 00 12 20 00 00 06 10 01 00 02 16 00 00 00 16 00 01 04 18 01 01 08 08 01 01 12 18 01 01 04 12 02 02 04 08 00 02 08 14 03 02 10 16 00 02 00 04 00 03 02 10 01 03 14 16 00 03 08 12 00 03 02 16 01 04 08 04 00 04 08 12 02 04 08 14 01 04 00 10 00 05 07 28 00 05 06 16 00 05 04 10 01 05 08 10 02 06 08 16 02 06 08 10 00 06 10 12 01 06 06 08 01 07 06 10 02 07 10 06 00 07 14 04 00 07 04 08 01 08 06 06 00 08 08 16 01 08 06 14 00 08 02 12 01 09 12 16 01 09 04 16 01 09 06 14 02 09 00 02 00 10 06 04 00 10 10 16 02 10 02 08 00 10 00 18 00 11 14 14 00 11 08 08 00 11 12 18 00 11 06 18 01 12 08 18 01 12 06 18 00 12 10 10 00 12 00 22 00 13 10 04 00 13 14 08 00 13 14 24 00 13 04 06 00 14 08 16 00 14 04 14 01 14 06 12 00 14 10 12 02 15 08 18 00 15 12 10 00 15 04 10 00 15 04 16 02 16 08 24 00 16 10 20 00 16 12 14 00 16 06 20 00 17 07 13 04 17 08 22 00 17 04 12 01 17 10 08 01 18 12 12 01 18 14 02 00 18 08 14 02 18 00 14 00 19 04 10 02 19 02 10 00 19 08 14 00 19 04 22 00 20 10 18 01 20 10 18 00 20 02 14 00 20 07 26 00 21 12 10 01 21 12 14 01 21 14 12 00 21 00 08 00 22 14 20 00 22 08 10 01 22 10 10 01 22 00 06 00 23 14 22 00 23 06 16 01 23 02 12 00 23 06 24 00 24 10 08 00 24 04 16 00 24 08 12 03 24 00 20 00 25 02 14 01 25 08 06 00 25 04 18 00 25 02 08 01 26 06 22 00 26 10 10 02 26 12 12 00 26 10 16 01 27 12 16 00 27 08 12 01 27 06 12 02 27 02 18 01 28 06 08 00 28 04 12 00 28 06 12 01 28 08 02 00 29 10 22 00 29 06 12 03 29 06 10 00 29 02 20 00 30 10 14 02 30 06 14 01 30 10 12 00 30 02 06 00 31 14 10 00 31 06 14 03 31 02 18 00 31 08 20 00 32 12 06 00 32 14 18 00 32 10 14 01 32 04 14 02 33 12 08 01 33 12 08 00 33 10 14 00 33 00 24 00 34 04 04 00 34 14 06 00 34 04 14 00 34 00 12 00 35 04 20 00 35 06 02 00 35 07 00 00 35
 10 14 02 00 12 18 01 00 04 18 00 00 04 16 01 00 00 10 00 01 04 22 00 01 08 08 01 01 10 06 00 01 06 02 00 02 06 22 00 02 14 06 00 02 14 12 00 02 04 08 01 03 08 22 00 03 10 16 00 03 06 12 00 03 12 10 01 04 06 12 03 04 08 18 00 04 08 14 02 04 07 00 00 05 08 02 00 05 02 12 00 05 10 14 00 05 02 10 01 06 07 28 00 06 08 06 00 06 06 14 01 06 08 24 00 07 02 16 00 07 02 14 00 07 04 08 00 07 04 06 00 08 08 18 01 08 14 08 00 08 14 10 00 08 00 06 00 09 06 20 00 09 10 18 01 09 12 14 01 09 06 10 01 10 02 18 00 10 04 12 01 10 08 14 01 10 06 16 02 11 10 04 00 11 12 10 00 11 08 10 01 11 06 10 02 12 12 06 00 12 10 08 00 12 06 14 00 12 06 08 01 13 07 13 04 13 10 12 02 13 14 22 00 13 08 10 02 14 06 18 00 14 04 10 00 14 08 14 00 14 14 02 00 15 14 20 00 15 08 12 00 15 08 16 00 15 14 16 00 16 08 12 03 16 06 12 02 16 10 16 01 16 00 24 00 17 06 18 01 17 10 18 00 17 04 14 00 17 02 20 00 18 04 10 02 18 10 12 01 18 04 16 00 18 08 16 02 19 06 10 00 19 12 14 00 19 08 16 01 19 02 18 01 20 10 22 00 20 02 08 00 20 10 14 01 20 02 16 01 21 07 26 00 21 12 16 01 21 04 10 01 21 00 04 00 22 12 18 00 22 12 16 00 22 04 14 01 22 00 12 00 23 08 20 00 23 10 08 01 23 12 08 01 23 00 16 00 24 04 14 02 24 12 12 01 24 06 14 02 24 04 18 01 25 06 06 00 25 14 14 00 25 06 16 01 25 02 12 01 26 02 14 01 26 14 04 00 26 02 10 00 26 02 06 00 27 04 20 00 27 06 04 00 27 10 10 00 27 02 08 01 28 10 10 02 28 12 12 00 28 08 12 01 28 00 02 00 29 04 16 02 29 12 08 00 29 08 12 02 29 06 24 00 30 06 12 01 30 06 16 00 30 10 12 00 30 04 12 02 31 08 04 00 31 12 20 00 31 06 08 00 31 04 04 00 32 14 24 00 32 08 08 00 32 08 14 03 32 00 14 00 33 00 22 00 33 14 18 00 33 10 10 01 33 00 20 00 34 10 16 02 34 06 14 03 34 04 12 00 34 00 08 00 35 00 18 00 35 10 20 00 35 08 10 00 35
EOF
        ) {
    my $game = substr($g,2,8);
    $ffi->set_g($g);
    $ffi->set_r1(0);
    $ffi->set_r2(0);
    ($remain) = $ffi->mjsolve();
    is $remain, 0, "remain == 0 for solvable game $game";
}
$yaml_string = <<EOF;
---
G_INPUT: |
  00 02 00 04
  00 04 00 27
  00 06 00 29
  00 08 00 06
  00 10 00 18
  00 12 00 00
  00 14 00 32
  00 16 00 06
  00 18 00 14
  00 20 00 24
  00 22 00 25
  00 24 00 30
  02 06 00 22
  02 08 00 20
  02 08 01 10
  02 10 00 10
  02 10 01 07
  02 12 00 22
  02 12 01 26
  02 14 00 21
  02 14 01 12
  02 16 00 03
  02 16 01 35
  02 18 00 04
  02 18 01 16
  02 20 00 08
  04 04 00 20
  04 06 00 33
  04 08 00 26
  04 08 01 17
  04 10 00 31
  04 10 01 29
  04 10 02 09
  04 12 00 23
  04 12 01 08
  04 12 02 34
  04 14 00 32
  04 14 01 30
  04 14 02 28
  04 16 00 21
  04 16 01 13
  04 16 02 31
  04 18 00 15
  04 18 01 24
  04 20 00 12
  04 22 00 28
  06 02 00 08
  06 04 00 29
  06 06 00 00
  06 08 00 11
  06 08 01 04
  06 10 00 16
  06 10 01 31
  06 10 02 12
  06 12 00 35
  06 12 01 20
  06 12 02 13
  06 12 03 02
  06 14 00 34
  06 14 01 18
  06 14 02 09
  06 14 03 02
  06 16 00 20
  06 16 01 05
  06 16 02 31
  06 18 00 27
  06 18 01 33
  06 20 00 19
  06 22 00 25
  06 24 00 10
  07 00 00 12
  07 13 04 02
  07 26 00 09
  07 28 00 21
  08 02 00 14
  08 04 00 16
  08 06 00 05
  08 08 00 32
  08 08 01 11
  08 10 00 24
  08 10 01 03
  08 10 02 07
  08 12 00 34
  08 12 01 18
  08 12 02 06
  08 12 03 02
  08 14 00 30
  08 14 01 14
  08 14 02 04
  08 14 03 01
  08 16 00 01
  08 16 01 17
  08 16 02 33
  08 18 00 33
  08 18 01 14
  08 20 00 25
  08 22 00 26
  08 24 00 24
  10 04 00 11
  10 06 00 23
  10 08 00 30
  10 08 01 34
  10 10 00 27
  10 10 01 29
  10 10 02 23
  10 12 00 21
  10 12 01 05
  10 12 02 01
  10 14 00 13
  10 14 01 00
  10 14 02 19
  10 16 00 19
  10 16 01 13
  10 16 02 15
  10 18 00 00
  10 18 01 03
  10 20 00 03
  10 22 00 01
  12 06 00 26
  12 08 00 27
  12 08 01 18
  12 10 00 17
  12 10 01 28
  12 12 00 22
  12 12 01 19
  12 14 00 23
  12 14 01 35
  12 16 00 22
  12 16 01 09
  12 18 00 10
  12 18 01 15
  12 20 00 16
  14 02 00 15
  14 04 00 28
  14 06 00 11
  14 08 00 32
  14 10 00 07
  14 12 00 05
  14 14 00 25
  14 16 00 07
  14 18 00 35
  14 20 00 17
  14 22 00 06
  14 24 00 08
G_INPUT_SCALAR: 144
EOF

my %seen_result;
my $runs = 256;
for (1..$runs) {
    $ffi->set_g($g);
    $ffi->set_r1(0);
    $ffi->set_r2(0);
    ($remain) = $ffi->mjsolve();
    my $y = YAML::XS::Load $yaml_string;
    my $g5 = $y->{G_INPUT};
    # ok $length=length($g5), "length of g in second yaml";
    # is $length, 1728, "length is $length=1728";
    $ffi->set_g($g5);
    $ffi->set_r1(144);
    $ffi->set_r2(0);
    ($remain) = $ffi->mjsolve();
    is $remain, 34, "always the same result '34' for unsolvable game";
    my $g6 = $ffi->get_g;
    (my $g7 = $g6) =~ s/\n/ /g;
    $seen_result{$g7}++;
}
pass sprintf "in %d runs we got %d different results", $runs, scalar keys %seen_result;

pass("Reached end of Testscript");
done_testing;
