#!perl -w
use strict;
use Test::More;
use Log::Log4perl qw(:easy);

use WWW::Mechanize::Chrome;

use lib '.';
use t::helper;

Log::Log4perl->easy_init($ERROR);  # Set priority of root logger to ERROR

# What instances of Chrome will we try?
my @instances = t::helper::browser_instances();

if (my $err = t::helper::default_unavailable) {
    plan skip_all => "Couldn't connect to Chrome: $@";
    exit
} else {
    plan tests => 2*@instances;
};

sub new_mech {
    t::helper::need_minimum_chrome_version( '62.0.0.0', @_ );
    WWW::Mechanize::Chrome->new(
        autodie => 1,
        @_,
    );
};

t::helper::run_across_instances(\@instances, \&new_mech, 2, sub {
    my ($browser_instance, $mech) = @_;

    isa_ok $mech, 'WWW::Mechanize::Chrome';

    $mech->get_local('50-form2.html');
    # A second attempt, to cycle the node ids quickly to avoid a node id 0
    $mech->get_local('50-form2.html');

    my $node = $mech->selector('#target_select',single=>1);
    like $node->get_text, qr!\A\s*Mercanti 20/20\s+Villaggio:\s+oppure\s+X:\s+Y:\s*\z!sm, "We retrieve text, not HTML";
});

